/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.DintType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class DIntValue
implements AnySignedValue {
    public static final DIntValue DEFAULT = new DIntValue(0);
    private final int value;

    private DIntValue(int value) {
        this.value = value;
    }

    public static DIntValue toDIntValue(int value) {
        return new DIntValue(value);
    }

    public static DIntValue toDIntValue(Number value) {
        return new DIntValue(value.intValue());
    }

    public static DIntValue toDIntValue(String value) {
        return DIntValue.toDIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static DIntValue toDIntValue(AnyMagnitudeValue value) {
        return DIntValue.toDIntValue(value.intValue());
    }

    public DintType getType() {
        return IecTypes.ElementaryTypes.DINT;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.longValue());
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DIntValue other = (DIntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

