/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.IExportFilter;
import org.eclipse.fordiac.ide.export.ui.Messages;
import org.eclipse.fordiac.ide.export.ui.wizard.ExportStatusMessageDialog;
import org.eclipse.fordiac.ide.export.ui.wizard.SelectFBTypesWizardPage;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.CMakeListsMarker;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class FordiacExportWizard
extends Wizard
implements IExportWizard {
    private static final String FORDIAC_EXPORT_SECTION = "4DIAC_EXPORT_SECTION";
    private IStructuredSelection selection;
    private SelectFBTypesWizardPage page;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        this.selection = new StructuredSelection(selectedResources);
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        IDialogSettings settings = PlatformUI.getDialogSettingsProvider((Bundle)bundle).getDialogSettings();
        if (settings.getSection(FORDIAC_EXPORT_SECTION) == null) {
            settings.addNewSection(FORDIAC_EXPORT_SECTION);
        }
        this.setDialogSettings(settings);
        this.setWindowTitle(Messages.FordiacExportWizard_LABEL_Window_Title);
    }

    public void addPages() {
        super.addPages();
        this.page = new SelectFBTypesWizardPage(Messages.FordiacExportWizard_WizardPage, this.selection);
        this.page.setDescription(Messages.FordiacExportWizard_DESCRIPTION_WizardPage);
        this.page.setTitle(Messages.FordiacExportWizard_TITLE_WizardPage);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        this.page.saveWidgetValues();
        List<IFile> exportees = this.collectExportees();
        if (!IDE.saveAllEditors((IResource[])exportees.toArray(new IResource[exportees.size()]), (boolean)true)) {
            return false;
        }
        Exporter exporter = new Exporter(this.page.getSelectedExportFilter(), exportees, this.page.getDirectory(), this.page.overwriteWithoutWarning(), this.page.enableCMakeLists());
        try {
            this.setNeedsProgressMonitor(true);
            this.getContainer().run(true, true, (IRunnableWithProgress)exporter);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            FordiacExportWizard.showExceptionErrorDialog(e);
        }
        catch (Exception e) {
            FordiacExportWizard.showExceptionErrorDialog(e);
        }
        return true;
    }

    protected static void showExceptionErrorDialog(Exception e) {
        FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
        msg.setMessage(Messages.FordiacExportWizard_ERROR + e.getMessage());
        msg.open();
    }

    private final List<IFile> collectExportees() {
        List<?> resources = this.page.getSelectedResources();
        return resources.parallelStream().filter(IFile.class::isInstance).map(IFile.class::cast).toList();
    }

    private static class Exporter
    implements IRunnableWithProgress {
        private final List<IFile> exportees;
        private final String outputDirectory;
        private final IConfigurationElement conf;
        private boolean overwriteWithoutWarning;
        private boolean enableCMakeLists;

        public Exporter(IConfigurationElement conf, List<IFile> exportees, String outputDirectory, boolean overwriteWithoutWarning, boolean enableCMakeLists) {
            this.conf = conf;
            this.exportees = exportees;
            this.outputDirectory = outputDirectory;
            this.overwriteWithoutWarning = overwriteWithoutWarning;
            this.enableCMakeLists = enableCMakeLists;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(MessageFormat.format(Messages.FordiacExportWizard_ExportingSelectedTypesUsingExporter, this.conf.getAttribute("name")), this.exportees.size() + 1);
            IExportFilter filter = this.createExportFilter();
            if (filter != null) {
                for (IFile file : this.exportees) {
                    if (monitor.isCanceled()) break;
                    try {
                        this.exportElement(monitor, filter, file, null);
                    }
                    catch (ExportException.OverwriteAll e) {
                        this.overwriteWithoutWarning = true;
                    }
                    catch (ExportException.CancelAll e) {
                        this.enableCMakeLists = false;
                        filter.getWarnings().add(Messages.FordiacExportWizard_EXPORT_CANCELED);
                        break;
                    }
                    catch (ExportException.UserInteraction userInteraction) {
                        // empty catch block
                    }
                    monitor.worked(1);
                }
                if (this.enableCMakeLists && !monitor.isCanceled()) {
                    try {
                        this.exportElement(monitor, filter, null, (EObject)new CMakeListsMarker());
                    }
                    catch (ExportException.UserInteraction userInteraction) {
                        // empty catch block
                    }
                    monitor.worked(1);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    filter.getErrors().add(Messages.FordiacExportWizard_EXPORT_CANCELED);
                }
                Display.getDefault().asyncExec(() -> Exporter.showErrorWarningSummary(filter));
            }
            monitor.done();
        }

        private void exportElement(IProgressMonitor monitor, IExportFilter filter, IFile file, EObject source) throws ExportException.UserInteraction {
            try {
                if (source instanceof CMakeListsMarker) {
                    monitor.subTask(Messages.FordiacExportWizard_ExportingCMakeLists);
                    filter.export(null, this.outputDirectory, this.overwriteWithoutWarning, source);
                } else {
                    String name = "anonymous";
                    if (source instanceof INamedElement) {
                        INamedElement ne = (INamedElement)source;
                        name = ne.getName();
                    } else if (file != null) {
                        name = file.getFullPath().removeFileExtension().lastSegment();
                    }
                    monitor.subTask(MessageFormat.format(Messages.FordiacExportWizard_ExportingType, name));
                    filter.export(file, this.outputDirectory, this.overwriteWithoutWarning, source);
                }
            }
            catch (ExportException.UserInteraction e) {
                throw e;
            }
            catch (ExportException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
                msg.setMessage(Messages.FordiacExportWizard_ERROR + e.getMessage());
                msg.open();
            }
        }

        private IExportFilter createExportFilter() {
            IExportFilter filter = null;
            try {
                filter = (IExportFilter)this.conf.createExecutableExtension("class");
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                MessageBox msg = new MessageBox(Display.getDefault().getActiveShell());
                msg.setMessage(Messages.FordiacExportWizard_ERROR + e.getMessage());
                msg.open();
            }
            return filter;
        }

        private static void showErrorWarningSummary(IExportFilter filter) {
            if (!filter.getErrors().isEmpty() || !filter.getWarnings().isEmpty()) {
                new ExportStatusMessageDialog(Display.getDefault().getActiveShell(), filter.getWarnings(), filter.getErrors()).open();
            }
        }
    }
}

