/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_lua.filter;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_lua.filter.LuaConstants;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.Algorithm;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Method;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.STMethod;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class BasicFBFilter {
    private Map<ECTransition, ILanguageSupport> transitionLanguageSupport;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private List<String> errors = new ArrayList<String>();

    private void setupLanguageSupport(BasicFBType type) {
        Functions.Function1 _function = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_lua", (EObject)it);
        this.transitionLanguageSupport = IterableExtensions.toInvertedMap((Iterable)type.getECC().getECTransition(), (Functions.Function1)_function);
    }

    public String lua(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        this.setupLanguageSupport(type);
        _builder.newLineIfNotEmpty();
        _builder.append("local STfunc = require \"STfunc\"");
        _builder.newLine();
        _builder.newLine();
        CharSequence _luaConstants = LuaConstants.luaConstants(type);
        _builder.append((Object)_luaConstants);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaMethods = this.luaMethods(type);
        _builder.append((Object)_luaMethods);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaAlgorithms = this.luaAlgorithms(type);
        _builder.append((Object)_luaAlgorithms);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaStates = this.luaStates(type.getECC());
        _builder.append((Object)_luaStates);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaECC = this.luaECC(type.getECC(), this.getVariables(type), this.getAdapterSocketsVariables(type), this.getAdapterPlugsVariables(type));
        _builder.append((Object)_luaECC);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaInterfaceSpec = LuaConstants.luaInterfaceSpec(type.getInterfaceList());
        _builder.append((Object)_luaInterfaceSpec);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _luaInternalVarsInformation = LuaConstants.luaInternalVarsInformation(type);
        _builder.append((Object)_luaInternalVarsInformation);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("return {ECC = executeEvent, interfaceSpec = interfaceSpec, internalVarsInformation = internalVarsInformation}");
        _builder.newLine();
        return _builder.toString();
    }

    private CharSequence luaECC(ECC ecc, Iterable<VarDeclaration> variables, Map<AdapterDeclaration, String> adapterSocketsVariables, Map<AdapterDeclaration, String> adapterPlugsVariables) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function transition(fb, id)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("local ");
        CharSequence _luaStateVariable = LuaConstants.luaStateVariable();
        _builder.append((Object)_luaStateVariable, "  ");
        _builder.append(" = ");
        CharSequence _luaFBStateVariable = LuaConstants.luaFBStateVariable();
        _builder.append((Object)_luaFBStateVariable, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaFBVariablesPrefix = LuaConstants.luaFBVariablesPrefix(variables);
        _builder.append((Object)_luaFBVariablesPrefix, "  ");
        _builder.newLineIfNotEmpty();
        Set<AdapterDeclaration> _keySet = adapterSocketsVariables.keySet();
        for (AdapterDeclaration adapter : _keySet) {
            EList _inputVars = adapter.getType().getInterfaceList().getInputVars();
            for (VarDeclaration input : _inputVars) {
                _builder.append("  ");
                CharSequence _luaFBAdapterInECCVariablesPrefix = LuaConstants.luaFBAdapterInECCVariablesPrefix(input, adapter.getName(), false);
                _builder.append((Object)_luaFBAdapterInECCVariablesPrefix, "  ");
                _builder.newLineIfNotEmpty();
            }
            EList _outputVars = adapter.getType().getInterfaceList().getOutputVars();
            for (VarDeclaration output : _outputVars) {
                _builder.append("  ");
                CharSequence _luaFBAdapterInECCVariablesPrefix_1 = LuaConstants.luaFBAdapterInECCVariablesPrefix(output, adapter.getName(), false);
                _builder.append((Object)_luaFBAdapterInECCVariablesPrefix_1, "  ");
                _builder.newLineIfNotEmpty();
            }
        }
        Set<AdapterDeclaration> _keySet_1 = adapterPlugsVariables.keySet();
        for (AdapterDeclaration adapter_1 : _keySet_1) {
            EList _inputVars_1 = adapter_1.getType().getInterfaceList().getInputVars();
            for (VarDeclaration input_1 : _inputVars_1) {
                _builder.append("  ");
                CharSequence _luaFBAdapterInECCVariablesPrefix_2 = LuaConstants.luaFBAdapterInECCVariablesPrefix(input_1, adapter_1.getName(), true);
                _builder.append((Object)_luaFBAdapterInECCVariablesPrefix_2, "  ");
                _builder.newLineIfNotEmpty();
            }
            EList _outputVars_1 = adapter_1.getType().getInterfaceList().getOutputVars();
            for (VarDeclaration output_1 : _outputVars_1) {
                _builder.append("  ");
                CharSequence _luaFBAdapterInECCVariablesPrefix_3 = LuaConstants.luaFBAdapterInECCVariablesPrefix(output_1, adapter_1.getName(), true);
                _builder.append((Object)_luaFBAdapterInECCVariablesPrefix_3, "  ");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("  ");
        CharSequence _luaTransitions = this.luaTransitions(ecc);
        _builder.append((Object)_luaTransitions, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("end");
        _builder.newLine();
        _builder.newLine();
        _builder.append("local function executeEvent(fb, id)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("local modified = transition(fb, id)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("while modified do");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("modified = transition(fb, -1)");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("end");
        _builder.newLine();
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    private Iterable<VarDeclaration> getVariables(BasicFBType type) {
        EList _inputVars = type.getInterfaceList().getInputVars();
        EList _outputVars = type.getInterfaceList().getOutputVars();
        Iterable _plus = Iterables.concat((Iterable)_inputVars, (Iterable)_outputVars);
        EList _internalVars = type.getInternalVars();
        return Iterables.concat((Iterable)_plus, (Iterable)_internalVars);
    }

    private Map<AdapterDeclaration, String> getAdapterSocketsVariables(BasicFBType type) {
        HashMap<AdapterDeclaration, String> ret = new HashMap<AdapterDeclaration, String>();
        EList _sockets = type.getInterfaceList().getSockets();
        for (AdapterDeclaration adapterDecl : _sockets) {
            ret.put(adapterDecl, adapterDecl.getName());
        }
        return ret;
    }

    private Map<AdapterDeclaration, String> getAdapterPlugsVariables(BasicFBType type) {
        HashMap<AdapterDeclaration, String> ret = new HashMap<AdapterDeclaration, String>();
        EList _plugs = type.getInterfaceList().getPlugs();
        for (AdapterDeclaration adapterDecl : _plugs) {
            ret.put(adapterDecl, adapterDecl.getName());
        }
        return ret;
    }

    private CharSequence luaTransitions(ECC ecc) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eCState = ecc.getECState();
        boolean _hasElements = false;
        for (ECState state : _eCState) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("if ");
            } else {
                _builder.appendImmediate((Object)"\nelseif ", "");
            }
            CharSequence _luaStateName = LuaConstants.luaStateName(state);
            _builder.append((Object)_luaStateName);
            _builder.append(" == ");
            CharSequence _luaStateVariable = LuaConstants.luaStateVariable();
            _builder.append((Object)_luaStateVariable);
            _builder.append(" then");
            _builder.newLineIfNotEmpty();
            CharSequence _luaTransition = this.luaTransition(state);
            _builder.append((Object)_luaTransition);
        }
        if (_hasElements) {
            _builder.append("\nelse return false\nend");
        }
        return _builder;
    }

    private CharSequence luaTransition(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        EList _outTransitions = state.getOutTransitions();
        boolean _hasElements = false;
        for (ECTransition tran : _outTransitions) {
            if (!_hasElements) {
                _hasElements = true;
                _builder.append("if ");
            } else {
                _builder.appendImmediate((Object)"\nelseif ", "");
            }
            CharSequence _luaTransitionCondition = this.luaTransitionCondition(tran);
            _builder.append((Object)_luaTransitionCondition);
            _builder.append(" then return enter");
            CharSequence _luaStateName = LuaConstants.luaStateName(tran.getDestination());
            _builder.append((Object)_luaStateName);
            _builder.append("(fb)");
        }
        if (_hasElements) {
            _builder.append("\nelse return false\nend");
        }
        return _builder;
    }

    private CharSequence luaTransitionCondition(ECTransition tran) {
        boolean _not;
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        Event _conditionEvent = tran.getConditionEvent();
        boolean bl = _tripleNotEquals = _conditionEvent != null;
        if (_tripleNotEquals) {
            CharSequence _luaInputEventName = LuaConstants.luaInputEventName(tran.getConditionEvent());
            _builder.append((Object)_luaInputEventName);
            _builder.append(" == id");
        } else {
            _builder.append("true");
        }
        _builder.append(" and ");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)tran.getConditionExpression());
        boolean bl2 = _not = !_isNullOrEmpty;
        if (_not) {
            CharSequence _luaTransitionConditionExpression = this.luaTransitionConditionExpression(tran);
            _builder.append((Object)_luaTransitionConditionExpression);
        } else {
            _builder.append("true");
        }
        return _builder;
    }

    private CharSequence luaTransitionConditionExpression(ECTransition tran) {
        try {
            ILanguageSupport _get = this.transitionLanguageSupport.get(tran);
            CharSequence _generate = null;
            if (_get != null) {
                _generate = _get.generate(CollectionLiterals.emptyMap());
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private CharSequence luaStates(ECC ecc) {
        StringConcatenation _builder = new StringConcatenation();
        EList _eCState = ecc.getECState();
        for (ECState state : _eCState) {
            CharSequence _luaState = this.luaState(state);
            _builder.append((Object)_luaState);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence luaState(ECState state) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("local function enter");
        CharSequence _luaStateName = LuaConstants.luaStateName(state);
        _builder.append((Object)_luaStateName);
        _builder.append("(fb)");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _luaFBStateVariable = LuaConstants.luaFBStateVariable();
        _builder.append((Object)_luaFBStateVariable, "  ");
        _builder.append(" = ");
        CharSequence _luaStateName_1 = LuaConstants.luaStateName(state);
        _builder.append((Object)_luaStateName_1, "  ");
        _builder.newLineIfNotEmpty();
        EList _eCAction = state.getECAction();
        for (ECAction action : _eCAction) {
            boolean _tripleNotEquals;
            _builder.append("  ");
            Algorithm _algorithm = action.getAlgorithm();
            boolean bl = _tripleNotEquals = _algorithm != null;
            if (_tripleNotEquals) {
                CharSequence _luaAlgorithmName = LuaConstants.luaAlgorithmName(action.getAlgorithm());
                _builder.append((Object)_luaAlgorithmName, "  ");
                _builder.append("(fb)");
            }
            _builder.newLineIfNotEmpty();
            FBNetworkElement _fBNetworkElement = action.getOutput().getFBNetworkElement();
            if (_fBNetworkElement instanceof AdapterFB) {
                _builder.append("  ");
                Event _output = action.getOutput();
                CharSequence _luaSendAdapterOutputEvent = null;
                if (_output != null) {
                    _luaSendAdapterOutputEvent = LuaConstants.luaSendAdapterOutputEvent(_output);
                }
                _builder.append((Object)_luaSendAdapterOutputEvent, "  ");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("  ");
            Event _output_1 = action.getOutput();
            CharSequence _luaSendOutputEvent = null;
            if (_output_1 != null) {
                _luaSendOutputEvent = LuaConstants.luaSendOutputEvent(_output_1);
            }
            _builder.append((Object)_luaSendOutputEvent, "  ");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("  ");
        _builder.append("return true");
        _builder.newLine();
        _builder.append("end");
        _builder.newLine();
        return _builder;
    }

    private CharSequence luaMethods(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        EList _methods = type.getMethods();
        for (Method meth : _methods) {
            String _luaMethod = this.luaMethod(meth);
            _builder.append(_luaMethod);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    private String _luaMethod(Method meth) {
        Class<?> _class = meth.getClass();
        String _plus = "Cannot export algorithm " + String.valueOf(_class);
        throw new UnsupportedOperationException(_plus);
    }

    private String _luaMethod(STMethod meth) {
        try {
            ILanguageSupport lang = ILanguageSupportFactory.createLanguageSupport((String)"forte_lua", (EObject)meth);
            StringConcatenation _builder = new StringConcatenation();
            CharSequence _generate = lang.generate(Collections.emptyMap());
            _builder.append((Object)_generate);
            String result = _builder.toString();
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Error in algorithm ");
                String _name = meth.getName();
                _builder_1.append(_name);
                _builder_1.append(": ");
                _builder_1.append(it);
                return _builder_1.toString();
            };
            this.errors.addAll(ListExtensions.map((List)lang.getErrors(), (Functions.Function1)_function));
            lang.getErrors().clear();
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private CharSequence luaAlgorithms(BasicFBType type) {
        StringConcatenation _builder = new StringConcatenation();
        EList _algorithm = type.getAlgorithm();
        for (Algorithm alg : _algorithm) {
            String _luaAlgorithm = this.luaAlgorithm(alg);
            _builder.append(_luaAlgorithm);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    private String _luaAlgorithm(Algorithm alg) {
        Class<?> _class = alg.getClass();
        String _plus = "Cannot export algorithm " + String.valueOf(_class);
        throw new UnsupportedOperationException(_plus);
    }

    private String _luaAlgorithm(STAlgorithm alg) {
        try {
            ILanguageSupport lang = ILanguageSupportFactory.createLanguageSupport((String)"forte_lua", (EObject)alg);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("local function ");
            CharSequence _luaAlgorithmName = LuaConstants.luaAlgorithmName((Algorithm)alg);
            _builder.append((Object)_luaAlgorithmName);
            _builder.append("(fb)");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            CharSequence _generate = lang.generate(Collections.emptyMap());
            _builder.append((Object)_generate, "  ");
            _builder.newLineIfNotEmpty();
            _builder.append("end");
            _builder.newLine();
            String result = _builder.toString();
            Functions.Function1 _function = it -> {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Error in algorithm ");
                String _name = alg.getName();
                _builder_1.append(_name);
                _builder_1.append(": ");
                _builder_1.append(it);
                return _builder_1.toString();
            };
            this.errors.addAll(ListExtensions.map((List)lang.getErrors(), (Functions.Function1)_function));
            lang.getErrors().clear();
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @XbaseGenerated
    private String luaMethod(Method meth) {
        if (meth instanceof STMethod) {
            return this._luaMethod((STMethod)meth);
        }
        if (meth != null) {
            return this._luaMethod(meth);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(meth).toString());
    }

    @XbaseGenerated
    private String luaAlgorithm(Algorithm alg) {
        if (alg instanceof STAlgorithm) {
            return this._luaAlgorithm((STAlgorithm)alg);
        }
        if (alg != null) {
            return this._luaAlgorithm(alg);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(alg).toString());
    }

    @Pure
    public List<String> getErrors() {
        return this.errors;
    }
}

