/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.fb;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.debug.CommonLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.Messages;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchEventQueue;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.variable.FBVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;

public class FBLaunchConfigurationDelegate
extends CommonLaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IResource resource = LaunchConfigurationAttributes.getResource(configuration);
        if (resource instanceof IFile) {
            FBType type = (FBType)TypeLibraryManager.INSTANCE.getTypeEntryForFile((IFile)resource).getType();
            Event event = FBLaunchConfigurationAttributes.getEvent(configuration, type, this.getDefaultEvent(type));
            boolean repeatEvent = FBLaunchConfigurationAttributes.isRepeatEvent(configuration);
            boolean keepRunningWhenIdle = FBLaunchConfigurationAttributes.isKeepRunningWhenIdle(configuration);
            List<Variable<?>> defaultArguments = FBLaunchConfigurationDelegate.getDefaultArguments(type);
            List<Variable<?>> variables = LaunchConfigurationAttributes.getArguments(configuration, defaultArguments);
            FBEvaluator<?> evaluator = this.createEvaluator(type, variables);
            FBLaunchEventQueue fBLaunchEventQueue = new FBLaunchEventQueue(event, repeatEvent, keepRunningWhenIdle);
            fBLaunchEventQueue.setDebugTimeValue(FBLaunchConfigurationAttributes.getClockMode(configuration), FBLaunchConfigurationAttributes.getClockInterval(configuration));
            evaluator.setEventQueue((FBEvaluatorEventQueue)fBLaunchEventQueue);
            this.launch((Evaluator)evaluator, configuration, mode, launch, resource, monitor);
        }
    }

    protected FBEvaluator<?> createEvaluator(FBType type, List<Variable<?>> variables) {
        return (FBEvaluator)EvaluatorFactory.createEvaluator((Object)type, type.eClass().getInstanceClass().asSubclass(FBType.class), (String)"sampling", null, variables, null);
    }

    public static List<Variable<?>> getDefaultArguments(FBType type) throws CoreException {
        try {
            return List.copyOf(new FBVariable("dummy", type).getChildren().toList());
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)MessageFormat.format(Messages.FBLaunchConfigurationDelegate_InvalidDefaultArguments, type.getName()), (Throwable)e));
        }
    }

    protected Event getDefaultEvent(FBType type) {
        EList eventInputs = type.getInterfaceList().getEventInputs();
        if (!eventInputs.isEmpty()) {
            return (Event)eventInputs.get(0);
        }
        return null;
    }
}

