/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug;

import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugElement;
import org.eclipse.fordiac.ide.debug.IEvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugValue;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public class EvaluatorDebugVariable
extends EvaluatorDebugElement
implements IVariable,
Comparable<EvaluatorDebugVariable> {
    private final Variable<?> variable;
    private final EvaluatorDebugVariable parent;
    private final String expression;
    private EvaluatorDebugValue cachedValue;
    private long updateCount;

    public EvaluatorDebugVariable(Variable<?> variable, String expression, IEvaluatorDebugTarget debugTarget) {
        this(variable, expression, null, debugTarget);
    }

    protected EvaluatorDebugVariable(Variable<?> variable, String expression, EvaluatorDebugVariable parent, IEvaluatorDebugTarget debugTarget) {
        super(debugTarget);
        this.variable = variable;
        this.parent = parent;
        this.expression = expression;
        this.cachedValue = EvaluatorDebugValue.forValue(variable.getValue(), this);
        this.updateCount = debugTarget.getVariableUpdateCount();
    }

    public EvaluatorDebugVariable createSubVariable(Variable<?> variable, String expression) {
        return new EvaluatorDebugVariable(variable, expression, this, this.getDebugTarget());
    }

    public void setValue(String expression) throws DebugException {
        try {
            this.variable.setValue(expression, this.getDebugTarget().getTypeLibrary());
        }
        catch (Exception e) {
            throw new DebugException(Status.error((String)e.getMessage(), (Throwable)e));
        }
        this.fireContentChanged();
    }

    public void setValue(IValue value) throws DebugException {
        if (value instanceof EvaluatorDebugValue) {
            EvaluatorDebugValue evaluatorValue = (EvaluatorDebugValue)value;
            this.variable.setValue(evaluatorValue.getInternalValue());
            this.cachedValue = evaluatorValue;
            this.fireContentChanged();
        } else {
            this.setValue(value.getValueString());
        }
    }

    protected void fireContentChanged() {
        DebugPlugin.getDefault().fireDebugEventSet((DebugEvent[])StreamSupport.stream(new ParentSpliterator(this), false).map(v -> new DebugEvent(v, 16, 512)).toArray(DebugEvent[]::new));
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) {
        return this.variable.validateValue(expression, this.getDebugTarget().getTypeLibrary());
    }

    public boolean verifyValue(IValue value) throws DebugException {
        if (value instanceof EvaluatorDebugValue) {
            EvaluatorDebugValue evaluatorValue = (EvaluatorDebugValue)value;
            INamedElement variableType = this.variable.getType();
            INamedElement valueType = evaluatorValue.getInternalValue().getType();
            if (variableType instanceof DataType) {
                DataType variableDataType = (DataType)variableType;
                if (valueType instanceof DataType) {
                    DataType valueDataType = (DataType)valueType;
                    return variableDataType.isAssignableFrom(valueDataType);
                }
            }
            return variableType == valueType;
        }
        return this.verifyValue(value.getValueString());
    }

    public EvaluatorDebugValue getValue() {
        Value value = this.variable.getValue();
        if (value != this.cachedValue.getInternalValue()) {
            IEvaluatorDebugTarget debugTarget = this.getDebugTarget();
            if (!value.equals(this.cachedValue.getInternalValue())) {
                this.updateCount = debugTarget.getVariableUpdateCount();
            }
            this.cachedValue = EvaluatorDebugValue.forValue(value, this);
        }
        return this.cachedValue;
    }

    public Variable<?> getInternalVariable() {
        return this.variable;
    }

    public String getName() {
        return this.variable.getName();
    }

    public String getExpression() {
        return this.expression;
    }

    public String getReferenceTypeName() {
        return this.variable.getType().getName();
    }

    public boolean hasValueChanged() {
        return this.updateCount == this.getDebugTarget().getVariableUpdateCount();
    }

    public IEvaluatorDebugTarget getDebugTarget() {
        return (IEvaluatorDebugTarget)super.getDebugTarget();
    }

    public final EvaluatorDebugVariable getParent() {
        return this.parent;
    }

    @Override
    public int compareTo(EvaluatorDebugVariable o) {
        return this.variable.getName().compareTo(o.variable.getName());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return this.variable.equals(((EvaluatorDebugVariable)obj).variable);
        }
        return false;
    }

    public int hashCode() {
        return this.variable.hashCode();
    }

    private static final class ParentSpliterator
    implements Spliterator<EvaluatorDebugVariable> {
        private EvaluatorDebugVariable current;

        private ParentSpliterator(EvaluatorDebugVariable current) {
            this.current = current;
        }

        @Override
        public boolean tryAdvance(Consumer<? super EvaluatorDebugVariable> action) {
            if (this.current != null) {
                action.accept(this.current);
                this.current = this.current.getParent();
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<EvaluatorDebugVariable> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1297;
        }
    }
}

