/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.fb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.ui.MainLaunchConfigurationTab;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class FBLaunchConfigurationTab
extends MainLaunchConfigurationTab {
    private ComboViewer eventCombo;
    private Button repeatEventCheckbox;
    private Button keepDebuggerRunningCheckbox;
    private Button systemTimeRadio;
    private Button incrementTimeRadio;
    private Button manualTimeRadio;
    private Text debugTimeText;

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite eventComponent = this.createEventComponent((Composite)this.getControl());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)eventComponent);
        Composite argumentsComponent = this.createArgumentsComponent((Composite)this.getControl());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)argumentsComponent);
    }

    @Override
    protected Composite createOptionsComponent(Composite parent) {
        Group group = (Group)super.createOptionsComponent(parent);
        Composite comp = (Composite)group.getChildren()[0];
        this.repeatEventCheckbox = new Button(comp, 32);
        this.repeatEventCheckbox.setText(Messages.FBLaunchConfigurationTab_RepeatEvent);
        this.repeatEventCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        GridDataFactory.fillDefaults().applyTo((Control)this.repeatEventCheckbox);
        this.keepDebuggerRunningCheckbox = new Button(comp, 32);
        this.keepDebuggerRunningCheckbox.setText(Messages.FBLaunchConfigurationTab_KeepDebuggerRunningWhenIdle);
        this.keepDebuggerRunningCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        GridDataFactory.fillDefaults().applyTo((Control)this.keepDebuggerRunningCheckbox);
        Composite debugTimeComponent = this.createDebugTimeComponent(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)debugTimeComponent);
        return group;
    }

    protected Composite createEventComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText(Messages.FBLaunchConfigurationTab_Event);
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        this.eventCombo = new ComboViewer(comp, 12);
        this.eventCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.eventCombo.setLabelProvider((IBaseLabelProvider)new EventsLabelProvider());
        this.eventCombo.addSelectionChangedListener(e -> this.updateLaunchConfigurationDialog());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.eventCombo.getCombo());
        return group;
    }

    protected Composite createDebugTimeComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText(Messages.FBLaunchConfigurationTab_DebugTime);
        Composite radioComp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(radioComp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)radioComp);
        this.systemTimeRadio = new Button(radioComp, 16);
        this.systemTimeRadio.setText(Messages.FBLaunchConfigurationTab_UseSystemClock);
        this.systemTimeRadio.addListener(13, e -> this.updateLaunchConfigurationDialog());
        GridDataFactory.fillDefaults().applyTo((Control)this.systemTimeRadio);
        this.incrementTimeRadio = new Button(radioComp, 16);
        this.incrementTimeRadio.setText(Messages.FBLaunchConfigurationTab_IncrementClockAfterEachEventBySpecifiedAmount);
        this.incrementTimeRadio.addListener(13, e -> this.updateLaunchConfigurationDialog());
        GridDataFactory.fillDefaults().applyTo((Control)this.incrementTimeRadio);
        this.manualTimeRadio = new Button(radioComp, 16);
        this.manualTimeRadio.setText(Messages.FBLaunchConfigurationTab_UseFixedClockWithSpecifiedTime);
        this.manualTimeRadio.addListener(13, e -> this.updateLaunchConfigurationDialog());
        GridDataFactory.fillDefaults().applyTo((Control)this.manualTimeRadio);
        Composite c = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(c);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)c);
        Label clockIntervalLabel = new Label(c, 0);
        clockIntervalLabel.setText(Messages.FBLaunchConfigurationTab_ClockInterval);
        this.debugTimeText = new Text(c, 2048);
        this.debugTimeText.setText("0");
        this.debugTimeText.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.debugTimeText.addSegmentListener(e -> this.updateLaunchConfigurationDialog());
        Label debugTimeLabel = new Label(c, 0);
        debugTimeLabel.setText("ms");
        debugTimeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        return group;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.event");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.repeatEvent");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.keepRunningWhenIdle");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.clockMode");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.debugTime");
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            FBType fbType = this.getFBType();
            List<Event> events = FBLaunchConfigurationTab.getInputEvents(fbType);
            this.eventCombo.setInput(events);
            if (!events.isEmpty()) {
                Event event = FBLaunchConfigurationAttributes.getEvent((ILaunchConfiguration)configuration, (FBType)fbType, (Event)events.get(0));
                this.eventCombo.setSelection((ISelection)new StructuredSelection((Object)event), true);
            }
            this.repeatEventCheckbox.setSelection(FBLaunchConfigurationAttributes.isRepeatEvent((ILaunchConfiguration)configuration));
            this.keepDebuggerRunningCheckbox.setSelection(FBLaunchConfigurationAttributes.isKeepRunningWhenIdle((ILaunchConfiguration)configuration));
            this.systemTimeRadio.setSelection(FBLaunchConfigurationAttributes.isSystem((ILaunchConfiguration)configuration));
            this.incrementTimeRadio.setSelection(FBLaunchConfigurationAttributes.isIncrement((ILaunchConfiguration)configuration));
            this.manualTimeRadio.setSelection(FBLaunchConfigurationAttributes.isManual((ILaunchConfiguration)configuration));
            this.debugTimeText.setText(FBLaunchConfigurationAttributes.getClockIntervalText((ILaunchConfiguration)configuration));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.initializeArgumentsFrom(configuration);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String debugTime;
        super.performApply(configuration);
        Event event = (Event)this.eventCombo.getStructuredSelection().getFirstElement();
        if (event != null) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.event", FBLaunchConfigurationTab.getEventName(event));
        } else {
            configuration.removeAttribute("org.eclipse.fordiac.ide.debug.event");
        }
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.repeatEvent", this.repeatEventCheckbox.getSelection());
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.keepRunningWhenIdle", this.keepDebuggerRunningCheckbox.getSelection());
        if (this.systemTimeRadio.getSelection()) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.clockMode", FBDebugClockMode.SYSTEM.toString());
        }
        if (this.incrementTimeRadio.getSelection()) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.clockMode", FBDebugClockMode.INCREMENT.toString());
        }
        if (this.manualTimeRadio.getSelection()) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.clockMode", FBDebugClockMode.MANUAL.toString());
        }
        if (!(debugTime = this.debugTimeText.getText()).isBlank()) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.debugTime", debugTime);
        } else {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.debugTime", "0");
        }
    }

    @Override
    protected void handleResourceUpdated() {
        FBType fbType = this.getFBType();
        Event oldEvent = (Event)this.eventCombo.getStructuredSelection().getFirstElement();
        List<Event> events = FBLaunchConfigurationTab.getInputEvents(fbType);
        this.eventCombo.setInput(events);
        if (!events.isEmpty()) {
            Event event = oldEvent != null ? events.stream().filter(e -> e.getName().equals(oldEvent.getName())).findFirst().orElse(events.get(0)) : events.get(0);
            this.eventCombo.setSelection((ISelection)new StructuredSelection((Object)event), true);
        }
        this.updateArguments();
        super.handleResourceUpdated();
    }

    protected static List<Event> getInputEvents(FBType fbType) {
        ArrayList<Event> result = new ArrayList<Event>();
        if (fbType != null) {
            result.addAll((Collection<Event>)fbType.getInterfaceList().getEventInputs());
            Stream.concat(fbType.getInterfaceList().getSockets().stream(), fbType.getInterfaceList().getPlugs().stream()).map(AdapterDeclaration::getAdapterFB).map(FBNetworkElement::getInterface).map(InterfaceList::getEventOutputs).forEachOrdered(result::addAll);
        }
        return result;
    }

    @Override
    protected List<Variable<?>> getDefaultArguments() throws CoreException {
        FBType fbType = this.getFBType();
        if (fbType != null) {
            return FBLaunchConfigurationDelegate.getDefaultArguments((FBType)fbType);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean filterTargetResource(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            LibraryElement libraryElement;
            TypeEntry typeEntry;
            IFile file = (IFile)resource;
            if (resource.getFileExtension() != null && resource.getFileExtension().equalsIgnoreCase("FBT") && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file)) != null && (libraryElement = typeEntry.getType()) instanceof FBType) {
                FBType fbType = (FBType)libraryElement;
                return this.filterTargetFBType(fbType);
            }
        }
        return super.filterTargetResource(resource);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            int debugTime = Integer.parseInt(this.debugTimeText.getText());
            if (debugTime < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            this.setErrorMessage(Messages.FBLaunchConfigurationTab_ERROR_InvalidDebugTime);
            return false;
        }
        return true;
    }

    protected boolean filterTargetFBType(FBType fbType) {
        return fbType instanceof BasicFBType || fbType instanceof FunctionFBType || fbType instanceof SimpleFBType;
    }

    protected FBType getFBType() {
        LibraryElement libraryElement;
        IFile file;
        TypeEntry typeEntry;
        IResource resource = this.getResource();
        if (resource instanceof IFile && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file = (IFile)resource)) != null && (libraryElement = typeEntry.getType()) instanceof FBType) {
            FBType fbType = (FBType)libraryElement;
            return fbType;
        }
        return null;
    }

    protected static String getEventName(Event event) {
        if (event.getFBNetworkElement() instanceof AdapterFB) {
            return event.getFBNetworkElement().getName() + "." + event.getName();
        }
        return event.getName();
    }

    private static class EventsLabelProvider
    extends LabelProvider {
        private EventsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Event) {
                Event event = (Event)element;
                return FBLaunchConfigurationTab.getEventName(event);
            }
            return super.getText(element);
        }
    }
}

