/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.filter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jgit.revwalk.RevCommit;

public class NodesByCommitTimeFilter {
    private static final Pattern FILTER_ACTIVE_PATTERN = Pattern.compile("#\\d*");
    private final boolean active;
    private final int maxCount;
    private final PriorityQueue<TimedNode> nodes = new PriorityQueue<TimedNode>(Comparator.comparing(TimedNode::getTime));
    private final List<RepositoryTreeNode<?>> allNodes = new ArrayList();
    private int thresholdTime = Integer.MIN_VALUE;

    public NodesByCommitTimeFilter(String filterText) {
        boolean doFilter = false;
        int count = -1;
        if (filterText != null && (doFilter = FILTER_ACTIVE_PATTERN.matcher(filterText).matches()) && filterText.length() > 1) {
            try {
                count = Integer.parseInt(filterText.substring(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.active = doFilter;
        this.maxCount = count;
    }

    public void addNode(RepositoryTreeNode<?> treeNode, Object timeCarrier) {
        if (this.isFiltering()) {
            if (this.maxCount > 0) {
                int time = Integer.MIN_VALUE;
                if (timeCarrier instanceof RevCommit) {
                    time = ((RevCommit)timeCarrier).getCommitTime();
                }
                if (time >= this.thresholdTime) {
                    TimedNode node = new TimedNode(treeNode, time);
                    this.nodes.add(node);
                    if (this.nodes.size() > this.maxCount) {
                        this.nodes.poll();
                        this.thresholdTime = this.nodes.peek().getTime();
                    }
                }
            }
        } else {
            this.allNodes.add(treeNode);
        }
    }

    public List<RepositoryTreeNode<?>> getFilteredNodes() {
        if (this.isFiltering()) {
            return this.nodes.stream().map(TimedNode::getNode).collect(Collectors.toList());
        }
        return this.allNodes;
    }

    public boolean isFilterActive() {
        return this.active;
    }

    private boolean isFiltering() {
        return this.maxCount >= 0;
    }

    private static class TimedNode {
        private final RepositoryTreeNode<?> node;
        private final int time;

        TimedNode(RepositoryTreeNode<?> node, int time) {
            this.node = node;
            this.time = time;
        }

        int getTime() {
            return this.time;
        }

        RepositoryTreeNode<?> getNode() {
            return this.node;
        }
    }
}

