=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'cgi'

module OpenbaoClient
  class IdentityApi
    attr_accessor :api_client

    def initialize(api_client = ApiClient.default)
      @api_client = api_client
    end
    # Create a new alias.
    # @param alias_create_request [AliasCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def alias_create(alias_create_request, opts = {})
      alias_create_with_http_info(alias_create_request, opts)
      nil
    end

    # Create a new alias.
    # @param alias_create_request [AliasCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def alias_create_with_http_info(alias_create_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.alias_create ...'
      end
      # verify the required parameter 'alias_create_request' is set
      if @api_client.config.client_side_validation && alias_create_request.nil?
        fail ArgumentError, "Missing the required parameter 'alias_create_request' when calling IdentityApi.alias_create"
      end
      # resource path
      local_var_path = '/identity/alias'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(alias_create_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.alias_create",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#alias_create\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def alias_delete_by_id(id, opts = {})
      alias_delete_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def alias_delete_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.alias_delete_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.alias_delete_by_id"
      end
      # resource path
      local_var_path = '/identity/alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.alias_delete_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#alias_delete_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List all the alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def alias_list_by_id(list, opts = {})
      alias_list_by_id_with_http_info(list, opts)
      nil
    end

    # List all the alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def alias_list_by_id_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.alias_list_by_id ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.alias_list_by_id"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/alias/id'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.alias_list_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#alias_list_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def alias_read_by_id(id, opts = {})
      alias_read_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def alias_read_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.alias_read_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.alias_read_by_id"
      end
      # resource path
      local_var_path = '/identity/alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.alias_read_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#alias_read_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the alias
    # @param alias_update_by_id_request [AliasUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def alias_update_by_id(id, alias_update_by_id_request, opts = {})
      alias_update_by_id_with_http_info(id, alias_update_by_id_request, opts)
      nil
    end

    # @param id [String] ID of the alias
    # @param alias_update_by_id_request [AliasUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def alias_update_by_id_with_http_info(id, alias_update_by_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.alias_update_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.alias_update_by_id"
      end
      # verify the required parameter 'alias_update_by_id_request' is set
      if @api_client.config.client_side_validation && alias_update_by_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'alias_update_by_id_request' when calling IdentityApi.alias_update_by_id"
      end
      # resource path
      local_var_path = '/identity/alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(alias_update_by_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.alias_update_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#alias_update_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param entity_batch_delete_request [EntityBatchDeleteRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_batch_delete(entity_batch_delete_request, opts = {})
      entity_batch_delete_with_http_info(entity_batch_delete_request, opts)
      nil
    end

    # @param entity_batch_delete_request [EntityBatchDeleteRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_batch_delete_with_http_info(entity_batch_delete_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_batch_delete ...'
      end
      # verify the required parameter 'entity_batch_delete_request' is set
      if @api_client.config.client_side_validation && entity_batch_delete_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_batch_delete_request' when calling IdentityApi.entity_batch_delete"
      end
      # resource path
      local_var_path = '/identity/entity/batch-delete'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_batch_delete_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_batch_delete",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_batch_delete\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param entity_create_request [EntityCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_create(entity_create_request, opts = {})
      entity_create_with_http_info(entity_create_request, opts)
      nil
    end

    # @param entity_create_request [EntityCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_create_with_http_info(entity_create_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_create ...'
      end
      # verify the required parameter 'entity_create_request' is set
      if @api_client.config.client_side_validation && entity_create_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_create_request' when calling IdentityApi.entity_create"
      end
      # resource path
      local_var_path = '/identity/entity'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_create_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_create",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_create\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Create a new alias.
    # @param entity_create_alias_request [EntityCreateAliasRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_create_alias(entity_create_alias_request, opts = {})
      entity_create_alias_with_http_info(entity_create_alias_request, opts)
      nil
    end

    # Create a new alias.
    # @param entity_create_alias_request [EntityCreateAliasRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_create_alias_with_http_info(entity_create_alias_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_create_alias ...'
      end
      # verify the required parameter 'entity_create_alias_request' is set
      if @api_client.config.client_side_validation && entity_create_alias_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_create_alias_request' when calling IdentityApi.entity_create_alias"
      end
      # resource path
      local_var_path = '/identity/entity-alias'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_create_alias_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_create_alias",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_create_alias\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_delete_alias_by_id(id, opts = {})
      entity_delete_alias_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_delete_alias_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_delete_alias_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.entity_delete_alias_by_id"
      end
      # resource path
      local_var_path = '/identity/entity-alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_delete_alias_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_delete_alias_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the entity. If set, updates the corresponding existing entity.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_delete_by_id(id, opts = {})
      entity_delete_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the entity. If set, updates the corresponding existing entity.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_delete_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_delete_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.entity_delete_by_id"
      end
      # resource path
      local_var_path = '/identity/entity/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_delete_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_delete_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the entity
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_delete_by_name(name, opts = {})
      entity_delete_by_name_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the entity
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_delete_by_name_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_delete_by_name ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.entity_delete_by_name"
      end
      # resource path
      local_var_path = '/identity/entity/name/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_delete_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_delete_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List all the alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_list_aliases_by_id(list, opts = {})
      entity_list_aliases_by_id_with_http_info(list, opts)
      nil
    end

    # List all the alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_list_aliases_by_id_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_list_aliases_by_id ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.entity_list_aliases_by_id"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/entity-alias/id'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_list_aliases_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_list_aliases_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_list_by_id(list, opts = {})
      entity_list_by_id_with_http_info(list, opts)
      nil
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_list_by_id_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_list_by_id ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.entity_list_by_id"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/entity/id'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_list_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_list_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_list_by_name(list, opts = {})
      entity_list_by_name_with_http_info(list, opts)
      nil
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_list_by_name_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_list_by_name ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.entity_list_by_name"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/entity/name'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_list_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_list_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Query entities based on various properties.
    # @param entity_look_up_request [EntityLookUpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_look_up(entity_look_up_request, opts = {})
      entity_look_up_with_http_info(entity_look_up_request, opts)
      nil
    end

    # Query entities based on various properties.
    # @param entity_look_up_request [EntityLookUpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_look_up_with_http_info(entity_look_up_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_look_up ...'
      end
      # verify the required parameter 'entity_look_up_request' is set
      if @api_client.config.client_side_validation && entity_look_up_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_look_up_request' when calling IdentityApi.entity_look_up"
      end
      # resource path
      local_var_path = '/identity/lookup/entity'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_look_up_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_look_up",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_look_up\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param entity_merge_request [EntityMergeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_merge(entity_merge_request, opts = {})
      entity_merge_with_http_info(entity_merge_request, opts)
      nil
    end

    # @param entity_merge_request [EntityMergeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_merge_with_http_info(entity_merge_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_merge ...'
      end
      # verify the required parameter 'entity_merge_request' is set
      if @api_client.config.client_side_validation && entity_merge_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_merge_request' when calling IdentityApi.entity_merge"
      end
      # resource path
      local_var_path = '/identity/entity/merge'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_merge_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_merge",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_merge\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_read_alias_by_id(id, opts = {})
      entity_read_alias_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the alias
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_read_alias_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_read_alias_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.entity_read_alias_by_id"
      end
      # resource path
      local_var_path = '/identity/entity-alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_read_alias_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_read_alias_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the entity. If set, updates the corresponding existing entity.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_read_by_id(id, opts = {})
      entity_read_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the entity. If set, updates the corresponding existing entity.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_read_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_read_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.entity_read_by_id"
      end
      # resource path
      local_var_path = '/identity/entity/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_read_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_read_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the entity
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_read_by_name(name, opts = {})
      entity_read_by_name_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the entity
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_read_by_name_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_read_by_name ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.entity_read_by_name"
      end
      # resource path
      local_var_path = '/identity/entity/name/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_read_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_read_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the alias
    # @param entity_update_alias_by_id_request [EntityUpdateAliasByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_update_alias_by_id(id, entity_update_alias_by_id_request, opts = {})
      entity_update_alias_by_id_with_http_info(id, entity_update_alias_by_id_request, opts)
      nil
    end

    # @param id [String] ID of the alias
    # @param entity_update_alias_by_id_request [EntityUpdateAliasByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_update_alias_by_id_with_http_info(id, entity_update_alias_by_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_update_alias_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.entity_update_alias_by_id"
      end
      # verify the required parameter 'entity_update_alias_by_id_request' is set
      if @api_client.config.client_side_validation && entity_update_alias_by_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_update_alias_by_id_request' when calling IdentityApi.entity_update_alias_by_id"
      end
      # resource path
      local_var_path = '/identity/entity-alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_update_alias_by_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_update_alias_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_update_alias_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the entity. If set, updates the corresponding existing entity.
    # @param entity_update_by_id_request [EntityUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_update_by_id(id, entity_update_by_id_request, opts = {})
      entity_update_by_id_with_http_info(id, entity_update_by_id_request, opts)
      nil
    end

    # @param id [String] ID of the entity. If set, updates the corresponding existing entity.
    # @param entity_update_by_id_request [EntityUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_update_by_id_with_http_info(id, entity_update_by_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_update_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.entity_update_by_id"
      end
      # verify the required parameter 'entity_update_by_id_request' is set
      if @api_client.config.client_side_validation && entity_update_by_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_update_by_id_request' when calling IdentityApi.entity_update_by_id"
      end
      # resource path
      local_var_path = '/identity/entity/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_update_by_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_update_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_update_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the entity
    # @param entity_update_by_name_request [EntityUpdateByNameRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def entity_update_by_name(name, entity_update_by_name_request, opts = {})
      entity_update_by_name_with_http_info(name, entity_update_by_name_request, opts)
      nil
    end

    # @param name [String] Name of the entity
    # @param entity_update_by_name_request [EntityUpdateByNameRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def entity_update_by_name_with_http_info(name, entity_update_by_name_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.entity_update_by_name ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.entity_update_by_name"
      end
      # verify the required parameter 'entity_update_by_name_request' is set
      if @api_client.config.client_side_validation && entity_update_by_name_request.nil?
        fail ArgumentError, "Missing the required parameter 'entity_update_by_name_request' when calling IdentityApi.entity_update_by_name"
      end
      # resource path
      local_var_path = '/identity/entity/name/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(entity_update_by_name_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.entity_update_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#entity_update_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param group_create_request [GroupCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_create(group_create_request, opts = {})
      group_create_with_http_info(group_create_request, opts)
      nil
    end

    # @param group_create_request [GroupCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_create_with_http_info(group_create_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_create ...'
      end
      # verify the required parameter 'group_create_request' is set
      if @api_client.config.client_side_validation && group_create_request.nil?
        fail ArgumentError, "Missing the required parameter 'group_create_request' when calling IdentityApi.group_create"
      end
      # resource path
      local_var_path = '/identity/group'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(group_create_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_create",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_create\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Creates a new group alias, or updates an existing one.
    # @param group_create_alias_request [GroupCreateAliasRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_create_alias(group_create_alias_request, opts = {})
      group_create_alias_with_http_info(group_create_alias_request, opts)
      nil
    end

    # Creates a new group alias, or updates an existing one.
    # @param group_create_alias_request [GroupCreateAliasRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_create_alias_with_http_info(group_create_alias_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_create_alias ...'
      end
      # verify the required parameter 'group_create_alias_request' is set
      if @api_client.config.client_side_validation && group_create_alias_request.nil?
        fail ArgumentError, "Missing the required parameter 'group_create_alias_request' when calling IdentityApi.group_create_alias"
      end
      # resource path
      local_var_path = '/identity/group-alias'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(group_create_alias_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_create_alias",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_create_alias\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the group alias.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_delete_alias_by_id(id, opts = {})
      group_delete_alias_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the group alias.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_delete_alias_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_delete_alias_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.group_delete_alias_by_id"
      end
      # resource path
      local_var_path = '/identity/group-alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_delete_alias_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_delete_alias_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the group. If set, updates the corresponding existing group.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_delete_by_id(id, opts = {})
      group_delete_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the group. If set, updates the corresponding existing group.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_delete_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_delete_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.group_delete_by_id"
      end
      # resource path
      local_var_path = '/identity/group/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_delete_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_delete_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the group.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_delete_by_name(name, opts = {})
      group_delete_by_name_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the group.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_delete_by_name_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_delete_by_name ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.group_delete_by_name"
      end
      # resource path
      local_var_path = '/identity/group/name/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_delete_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_delete_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List all the group alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_list_aliases_by_id(list, opts = {})
      group_list_aliases_by_id_with_http_info(list, opts)
      nil
    end

    # List all the group alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_list_aliases_by_id_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_list_aliases_by_id ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.group_list_aliases_by_id"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/group-alias/id'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_list_aliases_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_list_aliases_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List all the group IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_list_by_id(list, opts = {})
      group_list_by_id_with_http_info(list, opts)
      nil
    end

    # List all the group IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_list_by_id_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_list_by_id ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.group_list_by_id"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/group/id'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_list_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_list_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_list_by_name(list, opts = {})
      group_list_by_name_with_http_info(list, opts)
      nil
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_list_by_name_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_list_by_name ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.group_list_by_name"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/group/name'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_list_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_list_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Query groups based on various properties.
    # @param group_look_up_request [GroupLookUpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_look_up(group_look_up_request, opts = {})
      group_look_up_with_http_info(group_look_up_request, opts)
      nil
    end

    # Query groups based on various properties.
    # @param group_look_up_request [GroupLookUpRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_look_up_with_http_info(group_look_up_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_look_up ...'
      end
      # verify the required parameter 'group_look_up_request' is set
      if @api_client.config.client_side_validation && group_look_up_request.nil?
        fail ArgumentError, "Missing the required parameter 'group_look_up_request' when calling IdentityApi.group_look_up"
      end
      # resource path
      local_var_path = '/identity/lookup/group'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(group_look_up_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_look_up",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_look_up\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the group alias.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_read_alias_by_id(id, opts = {})
      group_read_alias_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the group alias.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_read_alias_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_read_alias_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.group_read_alias_by_id"
      end
      # resource path
      local_var_path = '/identity/group-alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_read_alias_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_read_alias_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the group. If set, updates the corresponding existing group.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_read_by_id(id, opts = {})
      group_read_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the group. If set, updates the corresponding existing group.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_read_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_read_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.group_read_by_id"
      end
      # resource path
      local_var_path = '/identity/group/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_read_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_read_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the group.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_read_by_name(name, opts = {})
      group_read_by_name_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the group.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_read_by_name_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_read_by_name ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.group_read_by_name"
      end
      # resource path
      local_var_path = '/identity/group/name/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_read_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_read_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the group alias.
    # @param group_update_alias_by_id_request [GroupUpdateAliasByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_update_alias_by_id(id, group_update_alias_by_id_request, opts = {})
      group_update_alias_by_id_with_http_info(id, group_update_alias_by_id_request, opts)
      nil
    end

    # @param id [String] ID of the group alias.
    # @param group_update_alias_by_id_request [GroupUpdateAliasByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_update_alias_by_id_with_http_info(id, group_update_alias_by_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_update_alias_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.group_update_alias_by_id"
      end
      # verify the required parameter 'group_update_alias_by_id_request' is set
      if @api_client.config.client_side_validation && group_update_alias_by_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'group_update_alias_by_id_request' when calling IdentityApi.group_update_alias_by_id"
      end
      # resource path
      local_var_path = '/identity/group-alias/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(group_update_alias_by_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_update_alias_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_update_alias_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the group. If set, updates the corresponding existing group.
    # @param group_update_by_id_request [GroupUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_update_by_id(id, group_update_by_id_request, opts = {})
      group_update_by_id_with_http_info(id, group_update_by_id_request, opts)
      nil
    end

    # @param id [String] ID of the group. If set, updates the corresponding existing group.
    # @param group_update_by_id_request [GroupUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_update_by_id_with_http_info(id, group_update_by_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_update_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.group_update_by_id"
      end
      # verify the required parameter 'group_update_by_id_request' is set
      if @api_client.config.client_side_validation && group_update_by_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'group_update_by_id_request' when calling IdentityApi.group_update_by_id"
      end
      # resource path
      local_var_path = '/identity/group/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(group_update_by_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_update_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_update_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the group.
    # @param group_update_by_name_request [GroupUpdateByNameRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def group_update_by_name(name, group_update_by_name_request, opts = {})
      group_update_by_name_with_http_info(name, group_update_by_name_request, opts)
      nil
    end

    # @param name [String] Name of the group.
    # @param group_update_by_name_request [GroupUpdateByNameRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def group_update_by_name_with_http_info(name, group_update_by_name_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.group_update_by_name ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.group_update_by_name"
      end
      # verify the required parameter 'group_update_by_name_request' is set
      if @api_client.config.client_side_validation && group_update_by_name_request.nil?
        fail ArgumentError, "Missing the required parameter 'group_update_by_name_request' when calling IdentityApi.group_update_by_name"
      end
      # resource path
      local_var_path = '/identity/group/name/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(group_update_by_name_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.group_update_by_name",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#group_update_by_name\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Destroys a TOTP secret for the given MFA method ID on the given entity
    # @param mfa_admin_destroy_totp_secret_request [MfaAdminDestroyTotpSecretRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_admin_destroy_totp_secret(mfa_admin_destroy_totp_secret_request, opts = {})
      mfa_admin_destroy_totp_secret_with_http_info(mfa_admin_destroy_totp_secret_request, opts)
      nil
    end

    # Destroys a TOTP secret for the given MFA method ID on the given entity
    # @param mfa_admin_destroy_totp_secret_request [MfaAdminDestroyTotpSecretRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_admin_destroy_totp_secret_with_http_info(mfa_admin_destroy_totp_secret_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_admin_destroy_totp_secret ...'
      end
      # verify the required parameter 'mfa_admin_destroy_totp_secret_request' is set
      if @api_client.config.client_side_validation && mfa_admin_destroy_totp_secret_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_admin_destroy_totp_secret_request' when calling IdentityApi.mfa_admin_destroy_totp_secret"
      end
      # resource path
      local_var_path = '/identity/mfa/method/totp/admin-destroy'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_admin_destroy_totp_secret_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_admin_destroy_totp_secret",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_admin_destroy_totp_secret\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update or create TOTP secret for the given method ID on the given entity.
    # @param mfa_admin_generate_totp_secret_request [MfaAdminGenerateTotpSecretRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_admin_generate_totp_secret(mfa_admin_generate_totp_secret_request, opts = {})
      mfa_admin_generate_totp_secret_with_http_info(mfa_admin_generate_totp_secret_request, opts)
      nil
    end

    # Update or create TOTP secret for the given method ID on the given entity.
    # @param mfa_admin_generate_totp_secret_request [MfaAdminGenerateTotpSecretRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_admin_generate_totp_secret_with_http_info(mfa_admin_generate_totp_secret_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_admin_generate_totp_secret ...'
      end
      # verify the required parameter 'mfa_admin_generate_totp_secret_request' is set
      if @api_client.config.client_side_validation && mfa_admin_generate_totp_secret_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_admin_generate_totp_secret_request' when calling IdentityApi.mfa_admin_generate_totp_secret"
      end
      # resource path
      local_var_path = '/identity/mfa/method/totp/admin-generate'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_admin_generate_totp_secret_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_admin_generate_totp_secret",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_admin_generate_totp_secret\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_duo_method_request [MfaConfigureDuoMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_configure_duo_method(method_id, mfa_configure_duo_method_request, opts = {})
      mfa_configure_duo_method_with_http_info(method_id, mfa_configure_duo_method_request, opts)
      nil
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_duo_method_request [MfaConfigureDuoMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_configure_duo_method_with_http_info(method_id, mfa_configure_duo_method_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_configure_duo_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_configure_duo_method"
      end
      # verify the required parameter 'mfa_configure_duo_method_request' is set
      if @api_client.config.client_side_validation && mfa_configure_duo_method_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_configure_duo_method_request' when calling IdentityApi.mfa_configure_duo_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/duo/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_configure_duo_method_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_configure_duo_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_configure_duo_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_okta_method_request [MfaConfigureOktaMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_configure_okta_method(method_id, mfa_configure_okta_method_request, opts = {})
      mfa_configure_okta_method_with_http_info(method_id, mfa_configure_okta_method_request, opts)
      nil
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_okta_method_request [MfaConfigureOktaMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_configure_okta_method_with_http_info(method_id, mfa_configure_okta_method_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_configure_okta_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_configure_okta_method"
      end
      # verify the required parameter 'mfa_configure_okta_method_request' is set
      if @api_client.config.client_side_validation && mfa_configure_okta_method_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_configure_okta_method_request' when calling IdentityApi.mfa_configure_okta_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/okta/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_configure_okta_method_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_configure_okta_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_configure_okta_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_ping_id_method_request [MfaConfigurePingIdMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_configure_ping_id_method(method_id, mfa_configure_ping_id_method_request, opts = {})
      mfa_configure_ping_id_method_with_http_info(method_id, mfa_configure_ping_id_method_request, opts)
      nil
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_ping_id_method_request [MfaConfigurePingIdMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_configure_ping_id_method_with_http_info(method_id, mfa_configure_ping_id_method_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_configure_ping_id_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_configure_ping_id_method"
      end
      # verify the required parameter 'mfa_configure_ping_id_method_request' is set
      if @api_client.config.client_side_validation && mfa_configure_ping_id_method_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_configure_ping_id_method_request' when calling IdentityApi.mfa_configure_ping_id_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/pingid/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_configure_ping_id_method_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_configure_ping_id_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_configure_ping_id_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_totp_method_request [MfaConfigureTotpMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_configure_totp_method(method_id, mfa_configure_totp_method_request, opts = {})
      mfa_configure_totp_method_with_http_info(method_id, mfa_configure_totp_method_request, opts)
      nil
    end

    # Update or create a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param mfa_configure_totp_method_request [MfaConfigureTotpMethodRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_configure_totp_method_with_http_info(method_id, mfa_configure_totp_method_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_configure_totp_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_configure_totp_method"
      end
      # verify the required parameter 'mfa_configure_totp_method_request' is set
      if @api_client.config.client_side_validation && mfa_configure_totp_method_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_configure_totp_method_request' when calling IdentityApi.mfa_configure_totp_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/totp/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_configure_totp_method_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_configure_totp_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_configure_totp_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_delete_duo_method(method_id, opts = {})
      mfa_delete_duo_method_with_http_info(method_id, opts)
      nil
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_delete_duo_method_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_delete_duo_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_delete_duo_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/duo/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_delete_duo_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_delete_duo_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete a login enforcement
    # @param name [String] Name for this login enforcement configuration
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_delete_login_enforcement(name, opts = {})
      mfa_delete_login_enforcement_with_http_info(name, opts)
      nil
    end

    # Delete a login enforcement
    # @param name [String] Name for this login enforcement configuration
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_delete_login_enforcement_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_delete_login_enforcement ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.mfa_delete_login_enforcement"
      end
      # resource path
      local_var_path = '/identity/mfa/login-enforcement/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_delete_login_enforcement",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_delete_login_enforcement\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_delete_okta_method(method_id, opts = {})
      mfa_delete_okta_method_with_http_info(method_id, opts)
      nil
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_delete_okta_method_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_delete_okta_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_delete_okta_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/okta/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_delete_okta_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_delete_okta_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_delete_ping_id_method(method_id, opts = {})
      mfa_delete_ping_id_method_with_http_info(method_id, opts)
      nil
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_delete_ping_id_method_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_delete_ping_id_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_delete_ping_id_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/pingid/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_delete_ping_id_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_delete_ping_id_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_delete_totp_method(method_id, opts = {})
      mfa_delete_totp_method_with_http_info(method_id, opts)
      nil
    end

    # Delete a configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_delete_totp_method_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_delete_totp_method ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_delete_totp_method"
      end
      # resource path
      local_var_path = '/identity/mfa/method/totp/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_delete_totp_method",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_delete_totp_method\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Update or create TOTP secret for the given method ID on the given entity.
    # @param mfa_generate_totp_secret_request [MfaGenerateTotpSecretRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_generate_totp_secret(mfa_generate_totp_secret_request, opts = {})
      mfa_generate_totp_secret_with_http_info(mfa_generate_totp_secret_request, opts)
      nil
    end

    # Update or create TOTP secret for the given method ID on the given entity.
    # @param mfa_generate_totp_secret_request [MfaGenerateTotpSecretRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_generate_totp_secret_with_http_info(mfa_generate_totp_secret_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_generate_totp_secret ...'
      end
      # verify the required parameter 'mfa_generate_totp_secret_request' is set
      if @api_client.config.client_side_validation && mfa_generate_totp_secret_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_generate_totp_secret_request' when calling IdentityApi.mfa_generate_totp_secret"
      end
      # resource path
      local_var_path = '/identity/mfa/method/totp/generate'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_generate_totp_secret_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_generate_totp_secret",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_generate_totp_secret\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_list_duo_methods(list, opts = {})
      mfa_list_duo_methods_with_http_info(list, opts)
      nil
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_list_duo_methods_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_list_duo_methods ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.mfa_list_duo_methods"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/mfa/method/duo'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_list_duo_methods",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_list_duo_methods\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List login enforcements
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_list_login_enforcements(list, opts = {})
      mfa_list_login_enforcements_with_http_info(list, opts)
      nil
    end

    # List login enforcements
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_list_login_enforcements_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_list_login_enforcements ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.mfa_list_login_enforcements"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/mfa/login-enforcement'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_list_login_enforcements",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_list_login_enforcements\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List MFA method configurations for all MFA methods
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_list_methods(list, opts = {})
      mfa_list_methods_with_http_info(list, opts)
      nil
    end

    # List MFA method configurations for all MFA methods
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_list_methods_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_list_methods ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.mfa_list_methods"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/mfa/method'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_list_methods",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_list_methods\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_list_okta_methods(list, opts = {})
      mfa_list_okta_methods_with_http_info(list, opts)
      nil
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_list_okta_methods_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_list_okta_methods ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.mfa_list_okta_methods"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/mfa/method/okta'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_list_okta_methods",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_list_okta_methods\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_list_ping_id_methods(list, opts = {})
      mfa_list_ping_id_methods_with_http_info(list, opts)
      nil
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_list_ping_id_methods_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_list_ping_id_methods ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.mfa_list_ping_id_methods"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/mfa/method/pingid'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_list_ping_id_methods",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_list_ping_id_methods\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_list_totp_methods(list, opts = {})
      mfa_list_totp_methods_with_http_info(list, opts)
      nil
    end

    # List MFA method configurations for the given MFA method
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_list_totp_methods_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_list_totp_methods ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.mfa_list_totp_methods"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/mfa/method/totp'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_list_totp_methods",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_list_totp_methods\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_read_duo_method_configuration(method_id, opts = {})
      mfa_read_duo_method_configuration_with_http_info(method_id, opts)
      nil
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_read_duo_method_configuration_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_read_duo_method_configuration ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_read_duo_method_configuration"
      end
      # resource path
      local_var_path = '/identity/mfa/method/duo/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_read_duo_method_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_read_duo_method_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the current login enforcement
    # @param name [String] Name for this login enforcement configuration
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_read_login_enforcement(name, opts = {})
      mfa_read_login_enforcement_with_http_info(name, opts)
      nil
    end

    # Read the current login enforcement
    # @param name [String] Name for this login enforcement configuration
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_read_login_enforcement_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_read_login_enforcement ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.mfa_read_login_enforcement"
      end
      # resource path
      local_var_path = '/identity/mfa/login-enforcement/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_read_login_enforcement",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_read_login_enforcement\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the current configuration for the given ID regardless of the MFA method type
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_read_method_configuration(method_id, opts = {})
      mfa_read_method_configuration_with_http_info(method_id, opts)
      nil
    end

    # Read the current configuration for the given ID regardless of the MFA method type
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_read_method_configuration_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_read_method_configuration ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_read_method_configuration"
      end
      # resource path
      local_var_path = '/identity/mfa/method/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_read_method_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_read_method_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_read_okta_method_configuration(method_id, opts = {})
      mfa_read_okta_method_configuration_with_http_info(method_id, opts)
      nil
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_read_okta_method_configuration_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_read_okta_method_configuration ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_read_okta_method_configuration"
      end
      # resource path
      local_var_path = '/identity/mfa/method/okta/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_read_okta_method_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_read_okta_method_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_read_ping_id_method_configuration(method_id, opts = {})
      mfa_read_ping_id_method_configuration_with_http_info(method_id, opts)
      nil
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_read_ping_id_method_configuration_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_read_ping_id_method_configuration ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_read_ping_id_method_configuration"
      end
      # resource path
      local_var_path = '/identity/mfa/method/pingid/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_read_ping_id_method_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_read_ping_id_method_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_read_totp_method_configuration(method_id, opts = {})
      mfa_read_totp_method_configuration_with_http_info(method_id, opts)
      nil
    end

    # Read the current configuration for the given MFA method
    # @param method_id [String] The unique identifier for this MFA method.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_read_totp_method_configuration_with_http_info(method_id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_read_totp_method_configuration ...'
      end
      # verify the required parameter 'method_id' is set
      if @api_client.config.client_side_validation && method_id.nil?
        fail ArgumentError, "Missing the required parameter 'method_id' when calling IdentityApi.mfa_read_totp_method_configuration"
      end
      # resource path
      local_var_path = '/identity/mfa/method/totp/{method_id}'.sub('{' + 'method_id' + '}', CGI.escape(method_id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_read_totp_method_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_read_totp_method_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Create or update a login enforcement
    # @param name [String] Name for this login enforcement configuration
    # @param mfa_write_login_enforcement_request [MfaWriteLoginEnforcementRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def mfa_write_login_enforcement(name, mfa_write_login_enforcement_request, opts = {})
      mfa_write_login_enforcement_with_http_info(name, mfa_write_login_enforcement_request, opts)
      nil
    end

    # Create or update a login enforcement
    # @param name [String] Name for this login enforcement configuration
    # @param mfa_write_login_enforcement_request [MfaWriteLoginEnforcementRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def mfa_write_login_enforcement_with_http_info(name, mfa_write_login_enforcement_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.mfa_write_login_enforcement ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.mfa_write_login_enforcement"
      end
      # verify the required parameter 'mfa_write_login_enforcement_request' is set
      if @api_client.config.client_side_validation && mfa_write_login_enforcement_request.nil?
        fail ArgumentError, "Missing the required parameter 'mfa_write_login_enforcement_request' when calling IdentityApi.mfa_write_login_enforcement"
      end
      # resource path
      local_var_path = '/identity/mfa/login-enforcement/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(mfa_write_login_enforcement_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.mfa_write_login_enforcement",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#mfa_write_login_enforcement\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param oidc_configure_request [OidcConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_configure(oidc_configure_request, opts = {})
      oidc_configure_with_http_info(oidc_configure_request, opts)
      nil
    end

    # @param oidc_configure_request [OidcConfigureRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_configure_with_http_info(oidc_configure_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_configure ...'
      end
      # verify the required parameter 'oidc_configure_request' is set
      if @api_client.config.client_side_validation && oidc_configure_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_configure_request' when calling IdentityApi.oidc_configure"
      end
      # resource path
      local_var_path = '/identity/oidc/config'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_configure_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_configure",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_configure\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the assignment
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_delete_assignment(name, opts = {})
      oidc_delete_assignment_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the assignment
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_delete_assignment_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_delete_assignment ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_delete_assignment"
      end
      # resource path
      local_var_path = '/identity/oidc/assignment/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_delete_assignment",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_delete_assignment\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the client.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_delete_client(name, opts = {})
      oidc_delete_client_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the client.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_delete_client_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_delete_client ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_delete_client"
      end
      # resource path
      local_var_path = '/identity/oidc/client/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_delete_client",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_delete_client\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # CRUD operations for OIDC keys.
    # @param name [String] Name of the key
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_delete_key(name, opts = {})
      oidc_delete_key_with_http_info(name, opts)
      nil
    end

    # CRUD operations for OIDC keys.
    # @param name [String] Name of the key
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_delete_key_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_delete_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_delete_key"
      end
      # resource path
      local_var_path = '/identity/oidc/key/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_delete_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_delete_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_delete_provider(name, opts = {})
      oidc_delete_provider_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_delete_provider_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_delete_provider ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_delete_provider"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_delete_provider",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_delete_provider\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # CRUD operations on OIDC Roles
    # @param name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_delete_role(name, opts = {})
      oidc_delete_role_with_http_info(name, opts)
      nil
    end

    # CRUD operations on OIDC Roles
    # @param name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_delete_role_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_delete_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_delete_role"
      end
      # resource path
      local_var_path = '/identity/oidc/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_delete_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_delete_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the scope
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_delete_scope(name, opts = {})
      oidc_delete_scope_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the scope
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_delete_scope_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_delete_scope ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_delete_scope"
      end
      # resource path
      local_var_path = '/identity/oidc/scope/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_delete_scope",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_delete_scope\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Generate an OIDC token
    # @param name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_generate_token(name, opts = {})
      oidc_generate_token_with_http_info(name, opts)
      nil
    end

    # Generate an OIDC token
    # @param name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_generate_token_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_generate_token ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_generate_token"
      end
      # resource path
      local_var_path = '/identity/oidc/token/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_generate_token",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_generate_token\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Verify the authenticity of an OIDC token
    # @param oidc_introspect_request [OidcIntrospectRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_introspect(oidc_introspect_request, opts = {})
      oidc_introspect_with_http_info(oidc_introspect_request, opts)
      nil
    end

    # Verify the authenticity of an OIDC token
    # @param oidc_introspect_request [OidcIntrospectRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_introspect_with_http_info(oidc_introspect_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_introspect ...'
      end
      # verify the required parameter 'oidc_introspect_request' is set
      if @api_client.config.client_side_validation && oidc_introspect_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_introspect_request' when calling IdentityApi.oidc_introspect"
      end
      # resource path
      local_var_path = '/identity/oidc/introspect'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_introspect_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_introspect",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_introspect\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_list_assignments(list, opts = {})
      oidc_list_assignments_with_http_info(list, opts)
      nil
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_list_assignments_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_list_assignments ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.oidc_list_assignments"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/oidc/assignment'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_list_assignments",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_list_assignments\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_list_clients(list, opts = {})
      oidc_list_clients_with_http_info(list, opts)
      nil
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_list_clients_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_list_clients ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.oidc_list_clients"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/oidc/client'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_list_clients",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_list_clients\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List OIDC keys
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_list_keys(list, opts = {})
      oidc_list_keys_with_http_info(list, opts)
      nil
    end

    # List OIDC keys
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_list_keys_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_list_keys ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.oidc_list_keys"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/oidc/key'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_list_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_list_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @option opts [String] :allowed_client_id Filters the list of OIDC providers to those that allow the given client ID in their set of allowed_client_ids. (default to '')
    # @return [nil]
    def oidc_list_providers(list, opts = {})
      oidc_list_providers_with_http_info(list, opts)
      nil
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @option opts [String] :allowed_client_id Filters the list of OIDC providers to those that allow the given client ID in their set of allowed_client_ids. (default to '')
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_list_providers_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_list_providers ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.oidc_list_providers"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/oidc/provider'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list
      query_params[:'allowed_client_id'] = opts[:'allowed_client_id'] if !opts[:'allowed_client_id'].nil?

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_list_providers",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_list_providers\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List configured OIDC roles
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_list_roles(list, opts = {})
      oidc_list_roles_with_http_info(list, opts)
      nil
    end

    # List configured OIDC roles
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_list_roles_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_list_roles ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.oidc_list_roles"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/oidc/role'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_list_roles",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_list_roles\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_list_scopes(list, opts = {})
      oidc_list_scopes_with_http_info(list, opts)
      nil
    end

    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_list_scopes_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_list_scopes ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.oidc_list_scopes"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/oidc/scope'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_list_scopes",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_list_scopes\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_provider_authorize(name, opts = {})
      oidc_provider_authorize_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_provider_authorize_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_provider_authorize ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_provider_authorize"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}/authorize'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_provider_authorize",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_provider_authorize\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param oidc_provider_authorize_with_parameters_request [OidcProviderAuthorizeWithParametersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_provider_authorize_with_parameters(name, oidc_provider_authorize_with_parameters_request, opts = {})
      oidc_provider_authorize_with_parameters_with_http_info(name, oidc_provider_authorize_with_parameters_request, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param oidc_provider_authorize_with_parameters_request [OidcProviderAuthorizeWithParametersRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_provider_authorize_with_parameters_with_http_info(name, oidc_provider_authorize_with_parameters_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_provider_authorize_with_parameters ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_provider_authorize_with_parameters"
      end
      # verify the required parameter 'oidc_provider_authorize_with_parameters_request' is set
      if @api_client.config.client_side_validation && oidc_provider_authorize_with_parameters_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_provider_authorize_with_parameters_request' when calling IdentityApi.oidc_provider_authorize_with_parameters"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}/authorize'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_provider_authorize_with_parameters_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_provider_authorize_with_parameters",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_provider_authorize_with_parameters\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param oidc_provider_token_request [OidcProviderTokenRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_provider_token(name, oidc_provider_token_request, opts = {})
      oidc_provider_token_with_http_info(name, oidc_provider_token_request, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param oidc_provider_token_request [OidcProviderTokenRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_provider_token_with_http_info(name, oidc_provider_token_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_provider_token ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_provider_token"
      end
      # verify the required parameter 'oidc_provider_token_request' is set
      if @api_client.config.client_side_validation && oidc_provider_token_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_provider_token_request' when calling IdentityApi.oidc_provider_token"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}/token'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_provider_token_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_provider_token",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_provider_token\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_provider_user_info(name, opts = {})
      oidc_provider_user_info_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_provider_user_info_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_provider_user_info ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_provider_user_info"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}/userinfo'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_provider_user_info",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_provider_user_info\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_provider_user_info2(name, opts = {})
      oidc_provider_user_info2_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_provider_user_info2_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_provider_user_info2 ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_provider_user_info2"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}/userinfo'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_provider_user_info2",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_provider_user_info2\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the assignment
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_assignment(name, opts = {})
      oidc_read_assignment_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the assignment
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_assignment_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_assignment ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_assignment"
      end
      # resource path
      local_var_path = '/identity/oidc/assignment/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_assignment",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_assignment\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the client.
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_client(name, opts = {})
      oidc_read_client_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the client.
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_client_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_client ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_client"
      end
      # resource path
      local_var_path = '/identity/oidc/client/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_client",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_client\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_configuration(opts = {})
      oidc_read_configuration_with_http_info(opts)
      nil
    end

    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_configuration_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_configuration ...'
      end
      # resource path
      local_var_path = '/identity/oidc/config'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # CRUD operations for OIDC keys.
    # @param name [String] Name of the key
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_key(name, opts = {})
      oidc_read_key_with_http_info(name, opts)
      nil
    end

    # CRUD operations for OIDC keys.
    # @param name [String] Name of the key
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_key_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_key"
      end
      # resource path
      local_var_path = '/identity/oidc/key/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Query OIDC configurations
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_open_id_configuration(opts = {})
      oidc_read_open_id_configuration_with_http_info(opts)
      nil
    end

    # Query OIDC configurations
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_open_id_configuration_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_open_id_configuration ...'
      end
      # resource path
      local_var_path = '/identity/oidc/.well-known/openid-configuration'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_open_id_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_open_id_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_provider(name, opts = {})
      oidc_read_provider_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_provider_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_provider ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_provider"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_provider",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_provider\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_provider_open_id_configuration(name, opts = {})
      oidc_read_provider_open_id_configuration_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_provider_open_id_configuration_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_provider_open_id_configuration ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_provider_open_id_configuration"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}/.well-known/openid-configuration'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_provider_open_id_configuration",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_provider_open_id_configuration\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_provider_public_keys(name, opts = {})
      oidc_read_provider_public_keys_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_provider_public_keys_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_provider_public_keys ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_provider_public_keys"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}/.well-known/keys'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_provider_public_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_provider_public_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Retrieve public keys
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_public_keys(opts = {})
      oidc_read_public_keys_with_http_info(opts)
      nil
    end

    # Retrieve public keys
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_public_keys_with_http_info(opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_public_keys ...'
      end
      # resource path
      local_var_path = '/identity/oidc/.well-known/keys'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_public_keys",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_public_keys\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # CRUD operations on OIDC Roles
    # @param name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_role(name, opts = {})
      oidc_read_role_with_http_info(name, opts)
      nil
    end

    # CRUD operations on OIDC Roles
    # @param name [String] Name of the role
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_role_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_role"
      end
      # resource path
      local_var_path = '/identity/oidc/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the scope
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_read_scope(name, opts = {})
      oidc_read_scope_with_http_info(name, opts)
      nil
    end

    # @param name [String] Name of the scope
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_read_scope_with_http_info(name, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_read_scope ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_read_scope"
      end
      # resource path
      local_var_path = '/identity/oidc/scope/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_read_scope",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_read_scope\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Rotate a named OIDC key.
    # @param name [String] Name of the key
    # @param oidc_rotate_key_request [OidcRotateKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_rotate_key(name, oidc_rotate_key_request, opts = {})
      oidc_rotate_key_with_http_info(name, oidc_rotate_key_request, opts)
      nil
    end

    # Rotate a named OIDC key.
    # @param name [String] Name of the key
    # @param oidc_rotate_key_request [OidcRotateKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_rotate_key_with_http_info(name, oidc_rotate_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_rotate_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_rotate_key"
      end
      # verify the required parameter 'oidc_rotate_key_request' is set
      if @api_client.config.client_side_validation && oidc_rotate_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_rotate_key_request' when calling IdentityApi.oidc_rotate_key"
      end
      # resource path
      local_var_path = '/identity/oidc/key/{name}/rotate'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_rotate_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_rotate_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_rotate_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the assignment
    # @param oidc_write_assignment_request [OidcWriteAssignmentRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_write_assignment(name, oidc_write_assignment_request, opts = {})
      oidc_write_assignment_with_http_info(name, oidc_write_assignment_request, opts)
      nil
    end

    # @param name [String] Name of the assignment
    # @param oidc_write_assignment_request [OidcWriteAssignmentRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_write_assignment_with_http_info(name, oidc_write_assignment_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_write_assignment ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_write_assignment"
      end
      # verify the required parameter 'oidc_write_assignment_request' is set
      if @api_client.config.client_side_validation && oidc_write_assignment_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_write_assignment_request' when calling IdentityApi.oidc_write_assignment"
      end
      # resource path
      local_var_path = '/identity/oidc/assignment/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_write_assignment_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_write_assignment",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_write_assignment\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the client.
    # @param oidc_write_client_request [OidcWriteClientRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_write_client(name, oidc_write_client_request, opts = {})
      oidc_write_client_with_http_info(name, oidc_write_client_request, opts)
      nil
    end

    # @param name [String] Name of the client.
    # @param oidc_write_client_request [OidcWriteClientRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_write_client_with_http_info(name, oidc_write_client_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_write_client ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_write_client"
      end
      # verify the required parameter 'oidc_write_client_request' is set
      if @api_client.config.client_side_validation && oidc_write_client_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_write_client_request' when calling IdentityApi.oidc_write_client"
      end
      # resource path
      local_var_path = '/identity/oidc/client/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_write_client_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_write_client",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_write_client\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # CRUD operations for OIDC keys.
    # @param name [String] Name of the key
    # @param oidc_write_key_request [OidcWriteKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_write_key(name, oidc_write_key_request, opts = {})
      oidc_write_key_with_http_info(name, oidc_write_key_request, opts)
      nil
    end

    # CRUD operations for OIDC keys.
    # @param name [String] Name of the key
    # @param oidc_write_key_request [OidcWriteKeyRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_write_key_with_http_info(name, oidc_write_key_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_write_key ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_write_key"
      end
      # verify the required parameter 'oidc_write_key_request' is set
      if @api_client.config.client_side_validation && oidc_write_key_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_write_key_request' when calling IdentityApi.oidc_write_key"
      end
      # resource path
      local_var_path = '/identity/oidc/key/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_write_key_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_write_key",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_write_key\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the provider
    # @param oidc_write_provider_request [OidcWriteProviderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_write_provider(name, oidc_write_provider_request, opts = {})
      oidc_write_provider_with_http_info(name, oidc_write_provider_request, opts)
      nil
    end

    # @param name [String] Name of the provider
    # @param oidc_write_provider_request [OidcWriteProviderRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_write_provider_with_http_info(name, oidc_write_provider_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_write_provider ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_write_provider"
      end
      # verify the required parameter 'oidc_write_provider_request' is set
      if @api_client.config.client_side_validation && oidc_write_provider_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_write_provider_request' when calling IdentityApi.oidc_write_provider"
      end
      # resource path
      local_var_path = '/identity/oidc/provider/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_write_provider_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_write_provider",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_write_provider\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # CRUD operations on OIDC Roles
    # @param name [String] Name of the role
    # @param oidc_write_role_request [OidcWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_write_role(name, oidc_write_role_request, opts = {})
      oidc_write_role_with_http_info(name, oidc_write_role_request, opts)
      nil
    end

    # CRUD operations on OIDC Roles
    # @param name [String] Name of the role
    # @param oidc_write_role_request [OidcWriteRoleRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_write_role_with_http_info(name, oidc_write_role_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_write_role ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_write_role"
      end
      # verify the required parameter 'oidc_write_role_request' is set
      if @api_client.config.client_side_validation && oidc_write_role_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_write_role_request' when calling IdentityApi.oidc_write_role"
      end
      # resource path
      local_var_path = '/identity/oidc/role/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_write_role_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_write_role",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_write_role\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param name [String] Name of the scope
    # @param oidc_write_scope_request [OidcWriteScopeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def oidc_write_scope(name, oidc_write_scope_request, opts = {})
      oidc_write_scope_with_http_info(name, oidc_write_scope_request, opts)
      nil
    end

    # @param name [String] Name of the scope
    # @param oidc_write_scope_request [OidcWriteScopeRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def oidc_write_scope_with_http_info(name, oidc_write_scope_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.oidc_write_scope ...'
      end
      # verify the required parameter 'name' is set
      if @api_client.config.client_side_validation && name.nil?
        fail ArgumentError, "Missing the required parameter 'name' when calling IdentityApi.oidc_write_scope"
      end
      # verify the required parameter 'oidc_write_scope_request' is set
      if @api_client.config.client_side_validation && oidc_write_scope_request.nil?
        fail ArgumentError, "Missing the required parameter 'oidc_write_scope_request' when calling IdentityApi.oidc_write_scope"
      end
      # resource path
      local_var_path = '/identity/oidc/scope/{name}'.sub('{' + 'name' + '}', CGI.escape(name.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(oidc_write_scope_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.oidc_write_scope",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#oidc_write_scope\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # Create a new alias.
    # @param persona_create_request [PersonaCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def persona_create(persona_create_request, opts = {})
      persona_create_with_http_info(persona_create_request, opts)
      nil
    end

    # Create a new alias.
    # @param persona_create_request [PersonaCreateRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def persona_create_with_http_info(persona_create_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.persona_create ...'
      end
      # verify the required parameter 'persona_create_request' is set
      if @api_client.config.client_side_validation && persona_create_request.nil?
        fail ArgumentError, "Missing the required parameter 'persona_create_request' when calling IdentityApi.persona_create"
      end
      # resource path
      local_var_path = '/identity/persona'

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(persona_create_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.persona_create",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#persona_create\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the persona
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def persona_delete_by_id(id, opts = {})
      persona_delete_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the persona
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def persona_delete_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.persona_delete_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.persona_delete_by_id"
      end
      # resource path
      local_var_path = '/identity/persona/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.persona_delete_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:DELETE, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#persona_delete_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # List all the alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def persona_list_by_id(list, opts = {})
      persona_list_by_id_with_http_info(list, opts)
      nil
    end

    # List all the alias IDs.
    # @param list [String] Must be set to &#x60;true&#x60;
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def persona_list_by_id_with_http_info(list, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.persona_list_by_id ...'
      end
      # verify the required parameter 'list' is set
      if @api_client.config.client_side_validation && list.nil?
        fail ArgumentError, "Missing the required parameter 'list' when calling IdentityApi.persona_list_by_id"
      end
      # verify enum value
      allowable_values = ["true"]
      if @api_client.config.client_side_validation && !allowable_values.include?(list)
        fail ArgumentError, "invalid value for \"list\", must be one of #{allowable_values}"
      end
      # resource path
      local_var_path = '/identity/persona/id'

      # query parameters
      query_params = opts[:query_params] || {}
      query_params[:'list'] = list

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.persona_list_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#persona_list_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the persona
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def persona_read_by_id(id, opts = {})
      persona_read_by_id_with_http_info(id, opts)
      nil
    end

    # @param id [String] ID of the persona
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def persona_read_by_id_with_http_info(id, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.persona_read_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.persona_read_by_id"
      end
      # resource path
      local_var_path = '/identity/persona/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body]

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.persona_read_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:GET, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#persona_read_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end

    # @param id [String] ID of the persona
    # @param persona_update_by_id_request [PersonaUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [nil]
    def persona_update_by_id(id, persona_update_by_id_request, opts = {})
      persona_update_by_id_with_http_info(id, persona_update_by_id_request, opts)
      nil
    end

    # @param id [String] ID of the persona
    # @param persona_update_by_id_request [PersonaUpdateByIdRequest] 
    # @param [Hash] opts the optional parameters
    # @return [Array<(nil, Integer, Hash)>] nil, response status code and response headers
    def persona_update_by_id_with_http_info(id, persona_update_by_id_request, opts = {})
      if @api_client.config.debugging
        @api_client.config.logger.debug 'Calling API: IdentityApi.persona_update_by_id ...'
      end
      # verify the required parameter 'id' is set
      if @api_client.config.client_side_validation && id.nil?
        fail ArgumentError, "Missing the required parameter 'id' when calling IdentityApi.persona_update_by_id"
      end
      # verify the required parameter 'persona_update_by_id_request' is set
      if @api_client.config.client_side_validation && persona_update_by_id_request.nil?
        fail ArgumentError, "Missing the required parameter 'persona_update_by_id_request' when calling IdentityApi.persona_update_by_id"
      end
      # resource path
      local_var_path = '/identity/persona/id/{id}'.sub('{' + 'id' + '}', CGI.escape(id.to_s))

      # query parameters
      query_params = opts[:query_params] || {}

      # header parameters
      header_params = opts[:header_params] || {}
      # HTTP header 'Content-Type'
      content_type = @api_client.select_header_content_type(['application/json'])
      if !content_type.nil?
          header_params['Content-Type'] = content_type
      end

      # form parameters
      form_params = opts[:form_params] || {}

      # http body (model)
      post_body = opts[:debug_body] || @api_client.object_to_http_body(persona_update_by_id_request)

      # return_type
      return_type = opts[:debug_return_type]

      # auth_names
      auth_names = opts[:debug_auth_names] || []

      new_options = opts.merge(
        :operation => :"IdentityApi.persona_update_by_id",
        :header_params => header_params,
        :query_params => query_params,
        :form_params => form_params,
        :body => post_body,
        :auth_names => auth_names,
        :return_type => return_type
      )

      data, status_code, headers = @api_client.call_api(:POST, local_var_path, new_options)
      if @api_client.config.debugging
        @api_client.config.logger.debug "API called: IdentityApi#persona_update_by_id\nData: #{data.inspect}\nStatus code: #{status_code}\nHeaders: #{headers}"
      end
      return data, status_code, headers
    end
  end
end
