# frozen_string_literal: true

# See https://docs.gitlab.com/ee/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.

class TmpIndexOnVulnerabilityReads < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '17.3'

  # TODO: remove this index in https://gitlab.com/gitlab-org/gitlab/-/issues/475161
  INDEX_NAME = 'tmp_index_vulnerability_reads_where_state_is_detected'
  TABLE_NAME = :vulnerability_reads

  def up
    add_concurrent_index TABLE_NAME, :id, name: INDEX_NAME, where: "state = 1"
  end

  def down
    remove_concurrent_index_by_name TABLE_NAME, INDEX_NAME
  end
end
