# frozen_string_literal: true

class AddIndexOnVulnerabilityReadsForFiltering < Gitlab::Database::Migration[2.1]
  disable_ddl_transaction!

  INDEX_NAME = "idx_vuln_reads_for_filtering"

  def up
    add_concurrent_index(
      :vulnerability_reads,
      %i[project_id state dismissal_reason severity vulnerability_id],
      order: { severity: :desc, vulnerability_id: "DESC NULLS LAST" },
      name: INDEX_NAME
    )
  end

  def down
    remove_concurrent_index_by_name(
      :vulnerability_reads,
      INDEX_NAME
    )
  end
end
