---
stage: Manage
group: Import and Integrate
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!--
  This documentation is auto generated by a script.
  Please do not edit this file directly.

  To edit the introductory text, modify `tooling/graphql/docs/templates/default.md.haml`.

  Run `bundle exec rake gitlab:graphql:compile_docs`
  or check the `compile_docs` task in `lib/tasks/gitlab/graphql.rake`.
-->

# GraphQL API resources

This documentation is self-generated based on GitLab current GraphQL schema.

The API can be explored using the [interactive GraphQL explorer](../index.md#interactive-graphql-explorer). Developers can also [generate a machine-readable GraphQL schema in IDL and JSON formats](../../../development/rake_tasks.md#update-machine-readable-schema-files).

Each table below documents a GraphQL type. Types match loosely to models, but not all
fields and methods on a model are available via GraphQL.

WARNING:
Fields that are deprecated are marked with **{warning-solid}**.
Items (fields, enums, etc) that have been removed according to our [deprecation process](../index.md#deprecation-and-removal-process) can be found
in [Removed Items](../removed_items.md).

<!-- vale off -->
<!-- Vale linting disabled after this line. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing/vale.html#disable-vale-tests -->

<!-- markdownlint-disable MD044 -->
<!-- MD044/proper-names test disabled after this line to make page compatible with markdownlint-cli 0.29.0. -->
<!-- See https://docs.gitlab.com/ee/development/documentation/testing/markdownlint.html#disable-markdownlint-tests -->

## `Query` type

The `Query` type contains the API's top-level entry points for all executable queries.

### `Query.abuseReport`

Find an abuse report.

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Returns [`AbuseReport`](#abusereport).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryabusereportid"></a>`id` | [`AbuseReportID!`](#abusereportid) | ID of the abuse report. |

### `Query.abuseReportLabels`

Abuse report labels.

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Returns [`LabelConnection`](#labelconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryabusereportlabelssearchterm"></a>`searchTerm` | [`String`](#string) | Search term to find labels with. |

### `Query.addOnPurchase`

Retrieve the active add-on purchase. This query can be used in GitLab SaaS and self-managed environments.

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Returns [`AddOnPurchase`](#addonpurchase).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaddonpurchaseaddontype"></a>`addOnType` | [`GitlabSubscriptionsAddOnType!`](#gitlabsubscriptionsaddontype) | Type of add-on for the add-on purchase. |
| <a id="queryaddonpurchasenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | ID of namespace that the add-on was purchased for. |

### `Query.aiMessages`

Find GitLab Duo Chat messages.

DETAILS:
**Introduced** in GitLab 16.1.
**Status**: Experiment.

Returns [`AiMessageConnection!`](#aimessageconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryaimessagesagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | Global ID of the agent to answer the chat. |
| <a id="queryaimessagesrequestids"></a>`requestIds` | [`[ID!]`](#id) | Array of request IDs to fetch. |
| <a id="queryaimessagesroles"></a>`roles` | [`[AiMessageRole!]`](#aimessagerole) | Array of roles to fetch. |

### `Query.auditEventDefinitions`

Definitions for all audit events available on the instance.

Returns [`AuditEventDefinitionConnection!`](#auditeventdefinitionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.auditEventsInstanceAmazonS3Configurations`

Instance-level Amazon S3 configurations for audit events.

Returns [`InstanceAmazonS3ConfigurationTypeConnection`](#instanceamazons3configurationtypeconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.auditEventsInstanceStreamingDestinations`

Instance-level external audit event streaming destinations.

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Returns [`InstanceAuditEventStreamingDestinationConnection`](#instanceauditeventstreamingdestinationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.boardList`

Find an issue board list.

Returns [`BoardList`](#boardlist).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryboardlistid"></a>`id` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="queryboardlistissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when getting issue metadata in the board list. |

### `Query.ciApplicationSettings`

CI related settings that apply to the entire instance.

Returns [`CiApplicationSettings`](#ciapplicationsettings).

### `Query.ciCatalogResource`

A single CI/CD Catalog resource visible to an authorized user.

DETAILS:
**Introduced** in GitLab 16.1.
**Status**: Experiment.

Returns [`CiCatalogResource`](#cicatalogresource).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcefullpath"></a>`fullPath` | [`ID`](#id) | CI/CD Catalog resource full path. |
| <a id="querycicatalogresourceid"></a>`id` | [`CiCatalogResourceID`](#cicatalogresourceid) | CI/CD Catalog resource global ID. |

### `Query.ciCatalogResources`

All CI/CD Catalog resources under a common namespace, visible to an authorized user.

DETAILS:
**Introduced** in GitLab 15.11.
**Status**: Experiment.

Returns [`CiCatalogResourceConnection`](#cicatalogresourceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycicatalogresourcesscope"></a>`scope` | [`CiCatalogResourceScope`](#cicatalogresourcescope) | Scope of the returned catalog resources. |
| <a id="querycicatalogresourcessearch"></a>`search` | [`String`](#string) | Search term to filter the catalog resources by name or description. |
| <a id="querycicatalogresourcessort"></a>`sort` | [`CiCatalogResourceSort`](#cicatalogresourcesort) | Sort catalog resources by given criteria. |

### `Query.ciConfig`

Linted and processed contents of a CI config.
Should not be requested more than once per request.

Returns [`CiConfig`](#ciconfig).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciconfigcontent"></a>`content` | [`String!`](#string) | Contents of `.gitlab-ci.yml`. |
| <a id="queryciconfigdryrun"></a>`dryRun` | [`Boolean`](#boolean) | Run pipeline creation simulation, or only do static check. |
| <a id="queryciconfigprojectpath"></a>`projectPath` | [`ID!`](#id) | Project of the CI config. |
| <a id="queryciconfigsha"></a>`sha` | [`String`](#string) | Sha for the pipeline. |
| <a id="queryciconfigskipverifyprojectsha"></a>`skipVerifyProjectSha` **{warning-solid}** | [`Boolean`](#boolean) | **Introduced** in GitLab 16.5. **Status**: Experiment. If the provided `sha` is found in the project's repository but is not associated with a Git reference (a detached commit), the verification fails and a validation error is returned. Otherwise, verification passes, even if the `sha` is invalid. Set to `true` to skip this verification process. |

### `Query.ciMinutesUsage`

Compute usage data for a namespace.

Returns [`CiMinutesNamespaceMonthlyUsageConnection`](#ciminutesnamespacemonthlyusageconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciminutesusagedate"></a>`date` | [`Date`](#date) | Date for which to retrieve the usage data, should be the first day of a month. |
| <a id="queryciminutesusagenamespaceid"></a>`namespaceId` | [`NamespaceID`](#namespaceid) | Global ID of the Namespace for the monthly compute usage. |

### `Query.ciPipelineStage`

Stage belonging to a CI pipeline.

Returns [`CiStage`](#cistage).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycipipelinestageid"></a>`id` | [`CiStageID!`](#cistageid) | Global ID of the CI stage. |

### `Query.ciQueueingHistory`

Time taken for CI jobs to be picked up by runner by percentile.

DETAILS:
**Introduced** in GitLab 16.4.
**Status**: Experiment.

Returns [`QueueingDelayHistory`](#queueingdelayhistory).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryciqueueinghistoryfromtime"></a>`fromTime` | [`Time`](#time) | Start of the requested time frame. Defaults to three hours ago. |
| <a id="queryciqueueinghistoryrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Filter jobs by the type of runner that executed them. |
| <a id="queryciqueueinghistorytotime"></a>`toTime` | [`Time`](#time) | End of the requested time frame. Defaults to the current time. |

### `Query.ciVariables`

List of the instance's CI/CD variables.

Returns [`CiInstanceVariableConnection`](#ciinstancevariableconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycivariablessort"></a>`sort` | [`CiVariableSort`](#civariablesort) | Sort order of results. |

### `Query.containerRepository`

Find a container repository.

Returns [`ContainerRepositoryDetails`](#containerrepositorydetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | Global ID of the container repository. |

### `Query.currentLicense`

Fields related to the current license.

Returns [`CurrentLicense`](#currentlicense).

### `Query.currentUser`

Get information about current user.

Returns [`CurrentUser`](#currentuser).

### `Query.designManagement`

Fields related to design management.

Returns [`DesignManagement!`](#designmanagement).

### `Query.devopsAdoptionEnabledNamespaces`

Get configured DevOps adoption namespaces. **Status:** Beta. This endpoint is subject to change without notice.

Returns [`DevopsAdoptionEnabledNamespaceConnection`](#devopsadoptionenablednamespaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querydevopsadoptionenablednamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Filter by display namespace. |

### `Query.echo`

Testing endpoint to validate the API with.

Returns [`String!`](#string).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryechotext"></a>`text` | [`String!`](#string) | Text to echo back. |

### `Query.epicBoardList`

Returns [`EpicList`](#epiclist).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryepicboardlistepicfilters"></a>`epicFilters` | [`EpicFilters`](#epicfilters) | Filters applied when getting epic metadata in the epic board list. |
| <a id="queryepicboardlistid"></a>`id` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the list. |

### `Query.explainVulnerabilityPrompt`

GitLab Duo Vulnerability explanation prompt for a specified vulnerability.

DETAILS:
**Introduced** in GitLab 16.2.
**Status**: Experiment.

Returns [`ExplainVulnerabilityPrompt`](#explainvulnerabilityprompt).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryexplainvulnerabilitypromptvulnerabilityid"></a>`vulnerabilityId` | [`VulnerabilityID!`](#vulnerabilityid) | Vulnerability to generate a prompt for. |

### `Query.frecentGroups`

A user's frecently visited groups.

Returns [`[Group!]`](#group).

### `Query.frecentProjects`

A user's frecently visited projects.

Returns [`[Project!]`](#project).

### `Query.geoNode`

Find a Geo node.

Returns [`GeoNode`](#geonode).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygeonodename"></a>`name` | [`String`](#string) | Name of the Geo node. Defaults to the current Geo node name. |

### `Query.gitpodEnabled`

Whether Gitpod is enabled in application settings.

Returns [`Boolean`](#boolean).

### `Query.googleCloudArtifactRegistryRepositoryArtifact`

Details about an artifact in the Google Artifact Registry.

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Returns [`GoogleCloudArtifactRegistryArtifactDetails`](#googlecloudartifactregistryartifactdetails).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygooglecloudartifactregistryrepositoryartifactgooglecloudprojectid"></a>`googleCloudProjectId` | [`String!`](#string) | ID of the Google Cloud project. |
| <a id="querygooglecloudartifactregistryrepositoryartifactimage"></a>`image` | [`String!`](#string) | Name of the image in the Google Artifact Registry. |
| <a id="querygooglecloudartifactregistryrepositoryartifactlocation"></a>`location` | [`String!`](#string) | Location of the Artifact Registry repository. |
| <a id="querygooglecloudartifactregistryrepositoryartifactprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path. |
| <a id="querygooglecloudartifactregistryrepositoryartifactrepository"></a>`repository` | [`String!`](#string) | Repository on the Google Artifact Registry. |

### `Query.group`

Find a group.

Returns [`Group`](#group).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygroupfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the group. For example, `gitlab-org/gitlab-foss`. |

### `Query.groups`

Find groups.

Returns [`GroupConnection`](#groupconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querygroupssearch"></a>`search` | [`String`](#string) | Search query for group name or group full path. |
| <a id="querygroupssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. |

### `Query.instanceExternalAuditEventDestinations`

Instance level external audit event destinations.

Returns [`InstanceExternalAuditEventDestinationConnection`](#instanceexternalauditeventdestinationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.instanceGoogleCloudLoggingConfigurations`

Instance level google cloud logging configurations.

Returns [`InstanceGoogleCloudLoggingConfigurationTypeConnection`](#instancegooglecloudloggingconfigurationtypeconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.instanceSecurityDashboard`

Fields related to Instance Security Dashboard.

Returns [`InstanceSecurityDashboard`](#instancesecuritydashboard).

### `Query.integrationExclusions`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Returns [`IntegrationExclusionConnection`](#integrationexclusionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryintegrationexclusionsintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | Type of integration. |

### `Query.issue`

Find an issue.

Returns [`Issue`](#issue).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryissueid"></a>`id` | [`IssueID!`](#issueid) | Global ID of the issue. |

### `Query.issues`

Find issues visible to the current user. At least one filter must be provided.

DETAILS:
**Introduced** in GitLab 15.6.
**Status**: Experiment.

Returns [`IssueConnection`](#issueconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryissuesassigneeid"></a>`assigneeId` | [`String`](#string) | ID of a user assigned to the issues. Wildcard values "NONE" and "ANY" are supported. |
| <a id="queryissuesassigneeusername"></a>`assigneeUsername` **{warning-solid}** | [`String`](#string) | **Deprecated** in GitLab 13.11. Use `assigneeUsernames`. |
| <a id="queryissuesassigneeusernames"></a>`assigneeUsernames` | [`[String!]`](#string) | Usernames of users assigned to the issue. |
| <a id="queryissuesassigneewildcardid"></a>`assigneeWildcardId` | [`AssigneeWildcardId`](#assigneewildcardid) | Filter by assignee wildcard. Incompatible with assigneeUsername and assigneeUsernames. |
| <a id="queryissuesauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author of the issue. |
| <a id="queryissuesclosedafter"></a>`closedAfter` | [`Time`](#time) | Issues closed after this date. |
| <a id="queryissuesclosedbefore"></a>`closedBefore` | [`Time`](#time) | Issues closed before this date. |
| <a id="queryissuesconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter for confidential issues. If "false", excludes confidential issues. If "true", returns only confidential issues. |
| <a id="queryissuescreatedafter"></a>`createdAfter` | [`Time`](#time) | Issues created after this date. |
| <a id="queryissuescreatedbefore"></a>`createdBefore` | [`Time`](#time) | Issues created before this date. |
| <a id="queryissuescrmcontactid"></a>`crmContactId` | [`String`](#string) | ID of a contact assigned to the issues. |
| <a id="queryissuescrmorganizationid"></a>`crmOrganizationId` | [`String`](#string) | ID of an organization assigned to the issues. |
| <a id="queryissuesepicid"></a>`epicId` | [`String`](#string) | ID of an epic associated with the issues, "none" and "any" values are supported. |
| <a id="queryissuesepicwildcardid"></a>`epicWildcardId` | [`EpicWildcardId`](#epicwildcardid) | Filter by epic ID wildcard. Incompatible with epicId. |
| <a id="queryissueshealthstatusfilter"></a>`healthStatusFilter` | [`HealthStatusFilter`](#healthstatusfilter) | Health status of the issue, "none" and "any" values are supported. |
| <a id="queryissuesiid"></a>`iid` | [`String`](#string) | IID of the issue. For example, "1". |
| <a id="queryissuesiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of issues. For example, `["1", "2"]`. |
| <a id="queryissuesin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="queryissuesincludearchived"></a>`includeArchived` | [`Boolean`](#boolean) | Whether to include issues from archived projects. Defaults to `false`. |
| <a id="queryissuesincludesubepics"></a>`includeSubepics` | [`Boolean`](#boolean) | Whether to include subepics when filtering issues by epicId. |
| <a id="queryissuesiterationcadenceid"></a>`iterationCadenceId` | [`[IterationsCadenceID!]`](#iterationscadenceid) | Filter by a list of iteration cadence IDs. |
| <a id="queryissuesiterationid"></a>`iterationId` | [`[ID]`](#id) | List of iteration Global IDs applied to the issue. |
| <a id="queryissuesiterationtitle"></a>`iterationTitle` | [`String`](#string) | Filter by iteration title. |
| <a id="queryissuesiterationwildcardid"></a>`iterationWildcardId` | [`IterationWildcardId`](#iterationwildcardid) | Filter by iteration ID wildcard. |
| <a id="queryissueslabelname"></a>`labelName` | [`[String]`](#string) | Labels applied to this issue. |
| <a id="queryissuesmilestonetitle"></a>`milestoneTitle` | [`[String]`](#string) | Milestone applied to this issue. |
| <a id="queryissuesmilestonewildcardid"></a>`milestoneWildcardId` | [`MilestoneWildcardId`](#milestonewildcardid) | Filter issues by milestone ID wildcard. |
| <a id="queryissuesmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. Wildcard values "NONE" and "ANY" are supported. |
| <a id="queryissuesnot"></a>`not` | [`NegatedIssueFilterInput`](#negatedissuefilterinput) | Negated arguments. |
| <a id="queryissuesor"></a>`or` | [`UnionedIssueFilterInput`](#unionedissuefilterinput) | List of arguments with inclusive OR. |
| <a id="queryissuessearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="queryissuessort"></a>`sort` | [`IssueSort`](#issuesort) | Sort issues by this criteria. |
| <a id="queryissuesstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of this issue. |
| <a id="queryissuestypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter issues by the given issue types. |
| <a id="queryissuesupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Issues updated after this date. |
| <a id="queryissuesupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Issues updated before this date. |
| <a id="queryissuesweight"></a>`weight` | [`String`](#string) | Weight applied to the issue, "none" and "any" values are supported. |
| <a id="queryissuesweightwildcardid"></a>`weightWildcardId` | [`WeightWildcardId`](#weightwildcardid) | Filter by weight ID wildcard. Incompatible with weight. |

### `Query.iteration`

Find an iteration.

Returns [`Iteration`](#iteration).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryiterationid"></a>`id` | [`IterationID!`](#iterationid) | Find an iteration by its ID. |

### `Query.jobs`

All jobs on this GitLab instance. Returns an empty result for users without administrator access.

Returns [`CiJobConnection`](#cijobconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryjobsfailurereason"></a>`failureReason` **{warning-solid}** | [`CiJobFailureReason`](#cijobfailurereason) | **Introduced** in GitLab 16.4. **Status**: Experiment. Filter jobs by failure reason. Currently only `RUNNER_SYSTEM_FAILURE` together with `runnerTypes: INSTANCE_TYPE` is supported. |
| <a id="queryjobsrunnertypes"></a>`runnerTypes` **{warning-solid}** | [`[CiRunnerType!]`](#cirunnertype) | **Introduced** in GitLab 16.4. **Status**: Experiment. Filter jobs by runner type if feature flag `:admin_jobs_filter_runner_type` is enabled. |
| <a id="queryjobsstatuses"></a>`statuses` | [`[CiJobStatus!]`](#cijobstatus) | Filter jobs by status. |

### `Query.licenseHistoryEntries`

Fields related to entries in the license history.

Returns [`LicenseHistoryEntryConnection`](#licensehistoryentryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.memberRole`

Finds a single custom role.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Returns [`MemberRole`](#memberrole).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymemberroleid"></a>`id` | [`MemberRoleID`](#memberroleid) | Global ID of the member role to look up. |
| <a id="querymemberroleorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | Ordering column. Default is NAME. |
| <a id="querymemberrolesort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | Ordering column. Default is ASC. |

### `Query.memberRolePermissions`

List of all customizable permissions.

DETAILS:
**Introduced** in GitLab 16.4.
**Status**: Experiment.

Returns [`CustomizablePermissionConnection`](#customizablepermissionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.memberRoles`

Member roles available for the instance.

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Returns [`MemberRoleConnection`](#memberroleconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymemberrolesid"></a>`id` | [`MemberRoleID`](#memberroleid) | Global ID of the member role to look up. |
| <a id="querymemberrolesorderby"></a>`orderBy` | [`MemberRolesOrderBy`](#memberrolesorderby) | Ordering column. Default is NAME. |
| <a id="querymemberrolessort"></a>`sort` | [`SortDirectionEnum`](#sortdirectionenum) | Ordering column. Default is ASC. |

### `Query.mergeRequest`

Find a merge request.

Returns [`MergeRequest`](#mergerequest).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymergerequestid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | Global ID of the merge request. |

### `Query.metadata`

Metadata about GitLab.

Returns [`Metadata`](#metadata).

### `Query.milestone`

Find a milestone.

Returns [`Milestone`](#milestone).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymilestoneid"></a>`id` | [`MilestoneID!`](#milestoneid) | Find a milestone by its ID. |

### `Query.mlModel`

Find machine learning models.

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Returns [`MlModel`](#mlmodel).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querymlmodelid"></a>`id` | [`MlModelID!`](#mlmodelid) | ID of the model. |

### `Query.namespace`

Find a namespace.

Returns [`Namespace`](#namespace).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querynamespacefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace. For example, `gitlab-org/gitlab-foss`. |

### `Query.note`

Find a note.

DETAILS:
**Introduced** in GitLab 15.9.
**Status**: Experiment.

Returns [`Note`](#note).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querynoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note. |

### `Query.organization`

Find an organization.

DETAILS:
**Introduced** in GitLab 16.4.
**Status**: Experiment.

Returns [`Organization`](#organization).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryorganizationid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | ID of the organization. |

### `Query.organizations`

List organizations.

DETAILS:
**Introduced** in GitLab 16.8.
**Status**: Experiment.

Returns [`OrganizationConnection`](#organizationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.package`

Find a package. This field can only be resolved for one query in any single request. Returns `null` if a package has no `default` status.

Returns [`PackageDetailsType`](#packagedetailstype).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | Global ID of the package. |

### `Query.project`

Find a project.

Returns [`Project`](#project).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectfullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the project. For example, `gitlab-org/gitlab-foss`. |

### `Query.projects`

Find projects visible to the current user.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryprojectsfullpaths"></a>`fullPaths` | [`[String!]`](#string) | Filter projects by full paths. You cannot provide more than 50 full paths. |
| <a id="queryprojectsids"></a>`ids` | [`[ID!]`](#id) | Filter projects by IDs. |
| <a id="queryprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | Return only projects that the current user is a member of. |
| <a id="queryprojectspersonal"></a>`personal` | [`Boolean`](#boolean) | Return only personal projects. |
| <a id="queryprojectssearch"></a>`search` | [`String`](#string) | Search query, which can be for the project name, a path, or a description. |
| <a id="queryprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | Include namespace in project search. |
| <a id="queryprojectssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. |
| <a id="queryprojectstopics"></a>`topics` | [`[String!]`](#string) | Filter projects by topics. |
| <a id="queryprojectswithissuesenabled"></a>`withIssuesEnabled` | [`Boolean`](#boolean) | Return only projects with issues enabled. |
| <a id="queryprojectswithmergerequestsenabled"></a>`withMergeRequestsEnabled` | [`Boolean`](#boolean) | Return only projects with merge requests enabled. |

### `Query.queryComplexity`

Information about the complexity of the GraphQL query.

Returns [`QueryComplexity`](#querycomplexity).

### `Query.runner`

Find a runner.

Returns [`CiRunner`](#cirunner).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnerid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | Runner ID. |

### `Query.runnerPlatforms`

Supported runner platforms.

DETAILS:
**Deprecated** in GitLab 15.9.
No longer used, use gitlab-runner documentation to learn about supported platforms.

Returns [`RunnerPlatformConnection`](#runnerplatformconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.runnerSetup`

Runner setup instructions.

DETAILS:
**Deprecated** in GitLab 15.9.
No longer used, use gitlab-runner documentation to learn about runner registration commands.

Returns [`RunnerSetup`](#runnersetup).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnersetuparchitecture"></a>`architecture` | [`String!`](#string) | Architecture to generate the instructions for. |
| <a id="queryrunnersetupgroupid"></a>`groupId` **{warning-solid}** | [`GroupID`](#groupid) | **Deprecated** in GitLab 13.11. No longer used. |
| <a id="queryrunnersetupplatform"></a>`platform` | [`String!`](#string) | Platform to generate the instructions for. |
| <a id="queryrunnersetupprojectid"></a>`projectId` **{warning-solid}** | [`ProjectID`](#projectid) | **Deprecated** in GitLab 13.11. No longer used. |

### `Query.runnerUsage`

Runner usage by runner.

DETAILS:
**Introduced** in GitLab 16.9.
**Status**: Experiment.

Returns [`[CiRunnerUsage!]`](#cirunnerusage).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagefromdate"></a>`fromDate` | [`Date`](#date) | Start of the requested date frame. Defaults to the start of the previous calendar month. |
| <a id="queryrunnerusagerunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Filter runners by the type. |
| <a id="queryrunnerusagerunnerslimit"></a>`runnersLimit` | [`Int`](#int) | Maximum number of runners to return. Other runners will be aggregated to a `runner: null` entry. Defaults to 5 if unspecified. Maximum of 500. |
| <a id="queryrunnerusagetodate"></a>`toDate` | [`Date`](#date) | End of the requested date frame. Defaults to the end of the previous calendar month. |

### `Query.runnerUsageByProject`

Runner usage by project.

DETAILS:
**Introduced** in GitLab 16.9.
**Status**: Experiment.

Returns [`[CiRunnerUsageByProject!]`](#cirunnerusagebyproject).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnerusagebyprojectfromdate"></a>`fromDate` | [`Date`](#date) | Start of the requested date frame. Defaults to the start of the previous calendar month. |
| <a id="queryrunnerusagebyprojectprojectslimit"></a>`projectsLimit` | [`Int`](#int) | Maximum number of projects to return.Other projects will be aggregated to a `project: null` entry. Defaults to 5 if unspecified. Maximum of 500. |
| <a id="queryrunnerusagebyprojectrunnertype"></a>`runnerType` | [`CiRunnerType`](#cirunnertype) | Filter jobs by the type of runner that executed them. |
| <a id="queryrunnerusagebyprojecttodate"></a>`toDate` | [`Date`](#date) | End of the requested date frame. Defaults to the end of the previous calendar month. |

### `Query.runners`

Get all runners in the GitLab instance (project and shared). Access is restricted to users with administrator access.

Returns [`CiRunnerConnection`](#cirunnerconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryrunnersactive"></a>`active` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated** in GitLab 14.8. This was renamed. Use: `paused`. |
| <a id="queryrunnerscreatorid"></a>`creatorId` | [`UserID`](#userid) | Filter runners by creator ID. |
| <a id="queryrunnerscreatorusername"></a>`creatorUsername` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.7. **Status**: Experiment. Filter runners by creator username. |
| <a id="queryrunnerspaused"></a>`paused` | [`Boolean`](#boolean) | Filter runners by `paused` (true) or `active` (false) status. |
| <a id="queryrunnerssearch"></a>`search` | [`String`](#string) | Filter by full token or partial text in description field. |
| <a id="queryrunnerssort"></a>`sort` | [`CiRunnerSort`](#cirunnersort) | Sort order of results. |
| <a id="queryrunnersstatus"></a>`status` | [`CiRunnerStatus`](#cirunnerstatus) | Filter runners by status. |
| <a id="queryrunnerstaglist"></a>`tagList` | [`[String!]`](#string) | Filter by tags associated with the runner (comma-separated or array). |
| <a id="queryrunnerstype"></a>`type` | [`CiRunnerType`](#cirunnertype) | Filter runners by type. |
| <a id="queryrunnersupgradestatus"></a>`upgradeStatus` | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | Filter by upgrade status. |
| <a id="queryrunnersversionprefix"></a>`versionPrefix` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.6. **Status**: Experiment. Filter runners by version. Runners that contain runner managers with the version at the start of the search term are returned. For example, the search term '14.' returns runner managers with versions '14.11.1' and '14.2.3'. |

### `Query.selfManagedAddOnEligibleUsers`

Users within the self-managed instance who are eligible for add-ons.

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Returns [`AddOnUserConnection`](#addonuserconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryselfmanagedaddoneligibleusersaddontype"></a>`addOnType` | [`GitlabSubscriptionsAddOnType!`](#gitlabsubscriptionsaddontype) | Type of add on to filter the eligible users by. |
| <a id="queryselfmanagedaddoneligibleuserssearch"></a>`search` | [`String`](#string) | Search the user list. |

### `Query.snippets`

Find Snippets visible to the current user.

Returns [`SnippetConnection`](#snippetconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysnippetsauthorid"></a>`authorId` | [`UserID`](#userid) | ID of an author. |
| <a id="querysnippetsexplore"></a>`explore` | [`Boolean`](#boolean) | Explore personal snippets. |
| <a id="querysnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | Array of global snippet IDs. For example, `gid://gitlab/ProjectSnippet/1`. |
| <a id="querysnippetsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | ID of a project. |
| <a id="querysnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | Type of snippet. |
| <a id="querysnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | Visibility of the snippet. |

### `Query.subscriptionFutureEntries`

Fields related to entries in future subscriptions.

Returns [`SubscriptionFutureEntryConnection`](#subscriptionfutureentryconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

### `Query.syntheticNote`

Find a synthetic note.

DETAILS:
**Introduced** in GitLab 15.9.
**Status**: Experiment.

Returns [`Note`](#note).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querysyntheticnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to search synthetic note on. |
| <a id="querysyntheticnotesha"></a>`sha` | [`String!`](#string) | Global ID of the note. |

### `Query.timelogs`

Find timelogs visible to the current user.

Returns [`TimelogConnection`](#timelogconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytimelogsenddate"></a>`endDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or before endDate. |
| <a id="querytimelogsendtime"></a>`endTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or before endTime. |
| <a id="querytimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | List timelogs for a group. |
| <a id="querytimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | List timelogs for a project. |
| <a id="querytimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | List timelogs in a particular order. |
| <a id="querytimelogsstartdate"></a>`startDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or after startDate. |
| <a id="querytimelogsstarttime"></a>`startTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or after startTime. |
| <a id="querytimelogsusername"></a>`username` | [`String`](#string) | List timelogs for a user. |

### `Query.todo`

Retrieve a single to-do item.

Returns [`Todo`](#todo).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytodoid"></a>`id` | [`TodoID!`](#todoid) | ID of the to-do item. |

### `Query.topics`

Find project topics.

Returns [`TopicConnection`](#topicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="querytopicssearch"></a>`search` | [`String`](#string) | Search query for topic name. |

### `Query.usageTrendsMeasurements`

Get statistics on the instance.

Returns [`UsageTrendsMeasurementConnection`](#usagetrendsmeasurementconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryusagetrendsmeasurementsidentifier"></a>`identifier` | [`MeasurementIdentifier!`](#measurementidentifier) | Type of measurement or statistics to retrieve. |
| <a id="queryusagetrendsmeasurementsrecordedafter"></a>`recordedAfter` | [`Time`](#time) | Measurement recorded after this date. |
| <a id="queryusagetrendsmeasurementsrecordedbefore"></a>`recordedBefore` | [`Time`](#time) | Measurement recorded before this date. |

### `Query.user`

Find a user.

Returns [`UserCore`](#usercore).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryuserid"></a>`id` | [`UserID`](#userid) | ID of the User. |
| <a id="queryuserusername"></a>`username` | [`String`](#string) | Username of the User. |

### `Query.users`

Find users.

Returns [`UserCoreConnection`](#usercoreconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryusersadmins"></a>`admins` | [`Boolean`](#boolean) | Return only admin users. |
| <a id="queryusersgroupid"></a>`groupId` | [`GroupID`](#groupid) | Return users member of a given group. |
| <a id="queryusersids"></a>`ids` | [`[ID!]`](#id) | List of user Global IDs. |
| <a id="queryuserssearch"></a>`search` | [`String`](#string) | Query to search users by name, username, or primary email. |
| <a id="queryuserssort"></a>`sort` | [`Sort`](#sort) | Sort users by this criteria. |
| <a id="queryusersusernames"></a>`usernames` | [`[String!]`](#string) | List of usernames. |

### `Query.vulnerabilities`

Vulnerabilities reported on projects on the current user's instance security dashboard.

Returns [`VulnerabilityConnection`](#vulnerabilityconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiesclusteragentid"></a>`clusterAgentId` | [`[ClustersAgentID!]`](#clustersagentid) | Filter vulnerabilities by `cluster_agent_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="queryvulnerabilitiesclusterid"></a>`clusterId` | [`[ClustersClusterID!]`](#clustersclusterid) | Filter vulnerabilities by `cluster_id`. Vulnerabilities with a `reportType` of `cluster_image_scanning` are only included with this filter. |
| <a id="queryvulnerabilitiesdismissalreason"></a>`dismissalReason` | [`[VulnerabilityDismissalReason!]`](#vulnerabilitydismissalreason) | Filter by dismissal reason. Only dismissed Vulnerabilities will be included with the filter. |
| <a id="queryvulnerabilitieshasissues"></a>`hasIssues` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have linked issues. |
| <a id="queryvulnerabilitieshasmergerequest"></a>`hasMergeRequest` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have linked merge requests. |
| <a id="queryvulnerabilitieshasremediations"></a>`hasRemediations` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have remediations. |
| <a id="queryvulnerabilitieshasresolution"></a>`hasResolution` | [`Boolean`](#boolean) | Returns only the vulnerabilities which have been resolved on default branch. |
| <a id="queryvulnerabilitiesimage"></a>`image` | [`[String!]`](#string) | Filter vulnerabilities by location image. When this filter is present, the response only matches entries for a `reportType` that includes `container_scanning`, `cluster_image_scanning`. |
| <a id="queryvulnerabilitiesowasptopten"></a>`owaspTopTen` | [`[VulnerabilityOwaspTop10!]`](#vulnerabilityowasptop10) | Filter vulnerabilities by OWASP Top 10 category. |
| <a id="queryvulnerabilitiesprojectid"></a>`projectId` | [`[ID!]`](#id) | Filter vulnerabilities by project. |
| <a id="queryvulnerabilitiesreporttype"></a>`reportType` | [`[VulnerabilityReportType!]`](#vulnerabilityreporttype) | Filter vulnerabilities by report type. |
| <a id="queryvulnerabilitiesscanner"></a>`scanner` | [`[String!]`](#string) | Filter vulnerabilities by VulnerabilityScanner.externalId. |
| <a id="queryvulnerabilitiesscannerid"></a>`scannerId` | [`[VulnerabilitiesScannerID!]`](#vulnerabilitiesscannerid) | Filter vulnerabilities by scanner ID. |
| <a id="queryvulnerabilitiesseverity"></a>`severity` | [`[VulnerabilitySeverity!]`](#vulnerabilityseverity) | Filter vulnerabilities by severity. |
| <a id="queryvulnerabilitiessort"></a>`sort` | [`VulnerabilitySort`](#vulnerabilitysort) | List vulnerabilities by sort order. |
| <a id="queryvulnerabilitiesstate"></a>`state` | [`[VulnerabilityState!]`](#vulnerabilitystate) | Filter vulnerabilities by state. |

### `Query.vulnerabilitiesCountByDay`

The historical number of vulnerabilities per day for the projects on the current user's instance security dashboard.

Returns [`VulnerabilitiesCountByDayConnection`](#vulnerabilitiescountbydayconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilitiescountbydayenddate"></a>`endDate` | [`ISO8601Date!`](#iso8601date) | Last day for which to fetch vulnerability history. |
| <a id="queryvulnerabilitiescountbydaystartdate"></a>`startDate` | [`ISO8601Date!`](#iso8601date) | First day for which to fetch vulnerability history. |

### `Query.vulnerability`

Find a vulnerability.

Returns [`Vulnerability`](#vulnerability).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryvulnerabilityid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | Global ID of the Vulnerability. |

### `Query.workItem`

Find a work item.

DETAILS:
**Introduced** in GitLab 15.1.
**Status**: Experiment.

Returns [`WorkItem`](#workitem).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkitemid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |

### `Query.workItemsByReference`

Find work items by their reference.

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Returns [`WorkItemConnection`](#workitemconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkitemsbyreferencecontextnamespacepath"></a>`contextNamespacePath` | [`ID`](#id) | Full path of the context namespace (project or group). |
| <a id="queryworkitemsbyreferencerefs"></a>`refs` | [`[String!]!`](#string) | Work item references. Can be either a short reference or URL. |

### `Query.workspace`

Find a workspace.

Returns [`Workspace`](#workspace).

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkspaceid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | Find a workspace by its ID. |

### `Query.workspaces`

Find workspaces across the entire instance. This field is only available to instance admins, it will return an empty result for all non-admins.

Returns [`WorkspaceConnection`](#workspaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="queryworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | Filter workspaces by actual states. |
| <a id="queryworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | Filter workspaces by agent GlobalIDs. |
| <a id="queryworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | Filter workspaces by workspace GlobalIDs. For example, `["gid://gitlab/RemoteDevelopment::Workspace/1"]`. |
| <a id="queryworkspacesincludeactualstates"></a>`includeActualStates` **{warning-solid}** | [`[String!]`](#string) | **Deprecated** in GitLab 16.7. Use actual_states instead. |
| <a id="queryworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | Filter workspaces by project GlobalIDs. |
| <a id="queryworkspacesuserids"></a>`userIds` | [`[ProjectID!]`](#projectid) | Filter workspaces by user GlobalIDs. |

## `Mutation` type

The `Mutation` type contains all the mutations you can execute.

All mutations receive their arguments in a single input object named `input`, and all mutations
support at least a return field `errors` containing a list of error messages.

All input objects may have a `clientMutationId: String` field, identifying the mutation.

For example:

```graphql
mutation($id: NoteableID!, $body: String!) {
  createNote(input: { noteableId: $id, body: $body }) {
    errors
  }
}
```

### `Mutation.abuseReportLabelCreate`

DETAILS:
**Introduced** in GitLab 16.4.
**Status**: Experiment.

Input type: `AbuseReportLabelCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationabusereportlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationabusereportlabelcreatecolor"></a>`color` | [`String`](#string) | The color of the label given in 6-digit hex notation with leading '#' sign (for example, `#FFAABB`) or one of the CSS color names. |
| <a id="mutationabusereportlabelcreatetitle"></a>`title` | [`String!`](#string) | Title of the label. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationabusereportlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationabusereportlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationabusereportlabelcreatelabel"></a>`label` | [`Label`](#label) | Label after mutation. |

### `Mutation.achievementsAward`

DETAILS:
**Introduced** in GitLab 15.10.
**Status**: Experiment.

Input type: `AchievementsAwardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being awarded. |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsawarduserid"></a>`userId` | [`UserID!`](#userid) | Global ID of the user being awarded the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsawardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsawarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationachievementsawarduserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Achievement award. |

### `Mutation.achievementsCreate`

DETAILS:
**Introduced** in GitLab 15.8.
**Status**: Experiment.

Input type: `AchievementsCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the achievement. |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementscreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the achievement. |
| <a id="mutationachievementscreatename"></a>`name` | [`String!`](#string) | Name for the achievement. |
| <a id="mutationachievementscreatenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Namespace for the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementscreateachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement created. |
| <a id="mutationachievementscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.achievementsDelete`

DETAILS:
**Introduced** in GitLab 15.11.
**Status**: Experiment.

Input type: `AchievementsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being deleted. |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsdeleteachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement. |
| <a id="mutationachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.achievementsRevoke`

DETAILS:
**Introduced** in GitLab 15.10.
**Status**: Experiment.

Input type: `AchievementsRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsrevokeuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | Global ID of the user achievement being revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationachievementsrevokeuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Achievement award. |

### `Mutation.achievementsUpdate`

DETAILS:
**Introduced** in GitLab 15.11.
**Status**: Experiment.

Input type: `AchievementsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievementid"></a>`achievementId` | [`AchievementsAchievementID!`](#achievementsachievementid) | Global ID of the achievement being updated. |
| <a id="mutationachievementsupdateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the achievement. |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the achievement. |
| <a id="mutationachievementsupdatename"></a>`name` | [`String`](#string) | Name for the achievement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationachievementsupdateachievement"></a>`achievement` | [`Achievement`](#achievement) | Achievement. |
| <a id="mutationachievementsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationachievementsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.addProjectToSecurityDashboard`

Input type: `AddProjectToSecurityDashboardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaddprojecttosecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | ID of the project to be added to Instance Security Dashboard. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaddprojecttosecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaddprojecttosecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationaddprojecttosecuritydashboardproject"></a>`project` | [`Project`](#project) | Project that was added to the Instance Security Dashboard. |

### `Mutation.adminSidekiqQueuesDeleteJobs`

Input type: `AdminSidekiqQueuesDeleteJobsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsairesource"></a>`aiResource` | [`String`](#string) | Delete jobs matching ai_resource in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsize"></a>`artifactSize` | [`String`](#string) | Delete jobs matching artifact_size in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactusedcdn"></a>`artifactUsedCdn` | [`String`](#string) | Delete jobs matching artifact_used_cdn in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciescount"></a>`artifactsDependenciesCount` | [`String`](#string) | Delete jobs matching artifacts_dependencies_count in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsartifactsdependenciessize"></a>`artifactsDependenciesSize` | [`String`](#string) | Delete jobs matching artifacts_dependencies_size in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsbulkimportentityid"></a>`bulkImportEntityId` | [`String`](#string) | Delete jobs matching bulk_import_entity_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobscallerid"></a>`callerId` | [`String`](#string) | Delete jobs matching caller_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsclientid"></a>`clientId` | [`String`](#string) | Delete jobs matching client_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobsfeaturecategory"></a>`featureCategory` | [`String`](#string) | Delete jobs matching feature_category in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsjobid"></a>`jobId` | [`String`](#string) | Delete jobs matching job_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsmergeactionstatus"></a>`mergeActionStatus` | [`String`](#string) | Delete jobs matching merge_action_status in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobspipelineid"></a>`pipelineId` | [`String`](#string) | Delete jobs matching pipeline_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsproject"></a>`project` | [`String`](#string) | Delete jobs matching project in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsqueuename"></a>`queueName` | [`String!`](#string) | Name of the queue to delete jobs from. |
| <a id="mutationadminsidekiqqueuesdeletejobsrelatedclass"></a>`relatedClass` | [`String`](#string) | Delete jobs matching related_class in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsremoteip"></a>`remoteIp` | [`String`](#string) | Delete jobs matching remote_ip in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsrootcallerid"></a>`rootCallerId` | [`String`](#string) | Delete jobs matching root_caller_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsrootnamespace"></a>`rootNamespace` | [`String`](#string) | Delete jobs matching root_namespace in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobssidekiqdestinationshardredis"></a>`sidekiqDestinationShardRedis` | [`String`](#string) | Delete jobs matching sidekiq_destination_shard_redis in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobssubscriptionplan"></a>`subscriptionPlan` | [`String`](#string) | Delete jobs matching subscription_plan in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsuser"></a>`user` | [`String`](#string) | Delete jobs matching user in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsuserid"></a>`userId` | [`String`](#string) | Delete jobs matching user_id in the context metadata. |
| <a id="mutationadminsidekiqqueuesdeletejobsworkerclass"></a>`workerClass` | [`String`](#string) | Delete jobs with the given worker class. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationadminsidekiqqueuesdeletejobsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationadminsidekiqqueuesdeletejobsresult"></a>`result` | [`DeleteJobsResponse`](#deletejobsresponse) | Information about the status of the deletion request. |

### `Mutation.aiAction`

DETAILS:
**Introduced** in GitLab 15.11.
**Status**: Experiment.

Input type: `AiActionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiactionanalyzecijobfailure"></a>`analyzeCiJobFailure` | [`AnalyzeCiJobFailureInput`](#analyzecijobfailureinput) | Input for analyze_ci_job_failure AI action. |
| <a id="mutationaiactionchat"></a>`chat` | [`AiChatInput`](#aichatinput) | Input for chat AI action. |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiactionclientsubscriptionid"></a>`clientSubscriptionId` | [`String`](#string) | Client generated ID that can be subscribed to, to receive a response for the mutation. |
| <a id="mutationaiactionexplaincode"></a>`explainCode` | [`AiExplainCodeInput`](#aiexplaincodeinput) | Input for explain_code AI action. |
| <a id="mutationaiactionexplainvulnerability"></a>`explainVulnerability` | [`AiExplainVulnerabilityInput`](#aiexplainvulnerabilityinput) | Input for explain_vulnerability AI action. |
| <a id="mutationaiactionfillinmergerequesttemplate"></a>`fillInMergeRequestTemplate` | [`AiFillInMergeRequestTemplateInput`](#aifillinmergerequesttemplateinput) | Input for fill_in_merge_request_template AI action. |
| <a id="mutationaiactiongeneratecommitmessage"></a>`generateCommitMessage` | [`AiGenerateCommitMessageInput`](#aigeneratecommitmessageinput) | Input for generate_commit_message AI action. |
| <a id="mutationaiactiongeneratecubequery"></a>`generateCubeQuery` | [`AiGenerateCubeQueryInput`](#aigeneratecubequeryinput) | Input for generate_cube_query AI action. |
| <a id="mutationaiactiongeneratedescription"></a>`generateDescription` | [`AiGenerateDescriptionInput`](#aigeneratedescriptioninput) | Input for generate_description AI action. |
| <a id="mutationaiactionresolvevulnerability"></a>`resolveVulnerability` | [`AiResolveVulnerabilityInput`](#airesolvevulnerabilityinput) | Input for resolve_vulnerability AI action. |
| <a id="mutationaiactionsummarizecomments"></a>`summarizeComments` | [`AiSummarizeCommentsInput`](#aisummarizecommentsinput) | Input for summarize_comments AI action. |
| <a id="mutationaiactionsummarizenewmergerequest"></a>`summarizeNewMergeRequest` | [`AiSummarizeNewMergeRequestInput`](#aisummarizenewmergerequestinput) | Input for summarize_new_merge_request AI action. |
| <a id="mutationaiactionsummarizereview"></a>`summarizeReview` | [`AiSummarizeReviewInput`](#aisummarizereviewinput) | Input for summarize_review AI action. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiactionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiactionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationaiactionrequestid"></a>`requestId` | [`String`](#string) | ID of the request. |

### `Mutation.aiAgentCreate`

DETAILS:
**Introduced** in GitLab 16.8.
**Status**: Experiment.

Input type: `AiAgentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentcreatename"></a>`name` | [`String!`](#string) | Name of the agent. |
| <a id="mutationaiagentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to which the agent belongs. |
| <a id="mutationaiagentcreateprompt"></a>`prompt` | [`String!`](#string) | Prompt for the agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentcreateagent"></a>`agent` | [`AiAgent`](#aiagent) | Agent after mutation. |
| <a id="mutationaiagentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.aiAgentDestroy`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `AiAgentDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | Global ID of the AI Agent to be deleted. |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to which the agent belongs. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentdestroyagent"></a>`agent` | [`AiAgent`](#aiagent) | Agent after mutation. |
| <a id="mutationaiagentdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationaiagentdestroymessage"></a>`message` | [`String`](#string) | AI Agent deletion result message. |

### `Mutation.aiAgentUpdate`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `AiAgentUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagentid"></a>`agentId` | [`AiAgentID!`](#aiagentid) | ID of the agent. |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentupdatename"></a>`name` | [`String`](#string) | Name of the agent. |
| <a id="mutationaiagentupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to which the agent belongs. |
| <a id="mutationaiagentupdateprompt"></a>`prompt` | [`String`](#string) | Prompt for the agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationaiagentupdateagent"></a>`agent` | [`AiAgent`](#aiagent) | Agent after mutation. |
| <a id="mutationaiagentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationaiagentupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.alertSetAssignees`

Input type: `AlertSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the alert. Replaces existing assignees by default. |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalertsetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationalertsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationalertsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalertsetassigneesalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationalertsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalertsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationalertsetassigneesissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationalertsetassigneestodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.alertTodoCreate`

Input type: `AlertTodoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalerttodocreateiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationalerttodocreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationalerttodocreatealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationalerttodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationalerttodocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationalerttodocreateissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationalerttodocreatetodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.approvalProjectRuleDelete`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `approvalProjectRuleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruledeleteid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | Global ID of the approval project rule to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruledeleteapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | Deleted approval rule. |
| <a id="mutationapprovalprojectruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.approvalProjectRuleUpdate`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `approvalProjectRuleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | How many approvals are required to satify rule. |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruleupdategroupids"></a>`groupIds` | [`[ID!]`](#id) | List of IDs of Groups that can approval rule. |
| <a id="mutationapprovalprojectruleupdateid"></a>`id` | [`ApprovalProjectRuleID!`](#approvalprojectruleid) | Global ID of the approval rule to destroy. |
| <a id="mutationapprovalprojectruleupdatename"></a>`name` | [`String!`](#string) | Name of the approval rule. |
| <a id="mutationapprovalprojectruleupdateuserids"></a>`userIds` | [`[ID!]`](#id) | List of IDs of Users that can approval rule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovalprojectruleupdateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | Approval rule after mutation. |
| <a id="mutationapprovalprojectruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovalprojectruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.approveDeployment`

Input type: `ApproveDeploymentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovedeploymentcomment"></a>`comment` | [`String`](#string) | Comment to go with the approval. |
| <a id="mutationapprovedeploymentid"></a>`id` | [`DeploymentID!`](#deploymentid) | ID of the deployment. |
| <a id="mutationapprovedeploymentrepresentedas"></a>`representedAs` | [`String`](#string) | Name of the User/Group/Role to use for the approval, when the user belongs to multiple approval rules. |
| <a id="mutationapprovedeploymentstatus"></a>`status` | [`DeploymentsApprovalStatus!`](#deploymentsapprovalstatus) | Status of the approval (either `APPROVED` or `REJECTED`). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationapprovedeploymentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationapprovedeploymentdeploymentapproval"></a>`deploymentApproval` | [`DeploymentApproval`](#deploymentapproval) | DeploymentApproval after mutation. |
| <a id="mutationapprovedeploymenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.artifactDestroy`

Input type: `ArtifactDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationartifactdestroyid"></a>`id` | [`CiJobArtifactID!`](#cijobartifactid) | ID of the artifact to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationartifactdestroyartifact"></a>`artifact` | [`CiJobArtifact`](#cijobartifact) | Deleted artifact. |
| <a id="mutationartifactdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationartifactdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsAmazonS3ConfigurationCreate`

Input type: `AuditEventsAmazonS3ConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationauditeventsamazons3configurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationcreateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | configuration created. |
| <a id="mutationauditeventsamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsAmazonS3ConfigurationDelete`

Input type: `AuditEventsAmazonS3ConfigurationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationdeleteid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | ID of the Amazon S3 configuration to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsAmazonS3ConfigurationUpdate`

Input type: `AuditEventsAmazonS3ConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationupdateid"></a>`id` | [`AuditEventsAmazonS3ConfigurationID!`](#auditeventsamazons3configurationid) | ID of the Amazon S3 configuration to update. |
| <a id="mutationauditeventsamazons3configurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsamazons3configurationupdateamazons3configuration"></a>`amazonS3Configuration` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | Updated Amazon S3 configuration. |
| <a id="mutationauditeventsamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsGroupDestinationEventsAdd`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `AuditEventsGroupDestinationEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsGroupDestinationEventsDelete`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `AuditEventsGroupDestinationEventsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsgroupdestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsGroupDestinationNamespaceFilterCreate`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `AuditEventsGroupDestinationNamespaceFilterCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatedestinationid"></a>`destinationId` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | Destination ID. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacepath"></a>`namespacePath` | [`String`](#string) | Full path of the namespace(only project or group). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefiltercreatenamespacefilter"></a>`namespaceFilter` | [`GroupAuditEventNamespaceFilter`](#groupauditeventnamespacefilter) | Namespace filter created. |

### `Mutation.auditEventsGroupDestinationNamespaceFilterDelete`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `AuditEventsGroupDestinationNamespaceFilterDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsGroupNamespaceFilterID!`](#auditeventsgroupnamespacefilterid) | Namespace filter ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsgroupdestinationnamespacefilterdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationCreate`

Input type: `AuditEventsInstanceAmazonS3ConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateawsregion"></a>`awsRegion` | [`String!`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsinstanceamazons3configurationcreatebucketname"></a>`bucketName` | [`String!`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsinstanceamazons3configurationcreatesecretaccesskey"></a>`secretAccessKey` | [`String!`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationcreateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | Created instance Amazon S3 configuration. |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationDelete`

Input type: `AuditEventsInstanceAmazonS3ConfigurationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | ID of the instance-level Amazon S3 configuration to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsInstanceAmazonS3ConfigurationUpdate`

Input type: `AuditEventsInstanceAmazonS3ConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateaccesskeyxid"></a>`accessKeyXid` | [`String`](#string) | Access key ID of the Amazon S3 account. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateawsregion"></a>`awsRegion` | [`String`](#string) | AWS region where the bucket is created. |
| <a id="mutationauditeventsinstanceamazons3configurationupdatebucketname"></a>`bucketName` | [`String`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateid"></a>`id` | [`AuditEventsInstanceAmazonS3ConfigurationID!`](#auditeventsinstanceamazons3configurationid) | ID of the instance-level Amazon S3 configuration to update. |
| <a id="mutationauditeventsinstanceamazons3configurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationauditeventsinstanceamazons3configurationupdatesecretaccesskey"></a>`secretAccessKey` | [`String`](#string) | Secret access key of the Amazon S3 account. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstanceamazons3configurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsinstanceamazons3configurationupdateinstanceamazons3configuration"></a>`instanceAmazonS3Configuration` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | Updated instance-level Amazon S3 configuration. |

### `Mutation.auditEventsInstanceDestinationEventsAdd`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `AuditEventsInstanceDestinationEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsInstanceDestinationEventsDelete`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `AuditEventsInstanceDestinationEventsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsdeletedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | Destination id. |
| <a id="mutationauditeventsinstancedestinationeventsdeleteeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsinstancedestinationeventsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsinstancedestinationeventsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingDestinationEventsAdd`

Input type: `AuditEventsStreamingDestinationEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsStreamingDestinationEventsRemove`

Input type: `AuditEventsStreamingDestinationEventsRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsremovedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingDestinationInstanceEventsAdd`

Input type: `AuditEventsStreamingDestinationInstanceEventsAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadddestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to add for streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsaddeventtypefilters"></a>`eventTypeFilters` | [`[String!]`](#string) | List of event type filters for the audit event external destination. |

### `Mutation.auditEventsStreamingDestinationInstanceEventsRemove`

Input type: `AuditEventsStreamingDestinationInstanceEventsRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremovedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | Destination id. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveeventtypefilters"></a>`eventTypeFilters` | [`[String!]!`](#string) | List of event type filters to remove from streaming. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingdestinationinstanceeventsremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingHeadersCreate`

Input type: `AuditEventsStreamingHeadersCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination to associate header with. |
| <a id="mutationauditeventsstreamingheaderscreatekey"></a>`key` | [`String!`](#string) | Header key. |
| <a id="mutationauditeventsstreamingheaderscreatevalue"></a>`value` | [`String!`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreamingheaderscreateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | Created header. |

### `Mutation.auditEventsStreamingHeadersDestroy`

Input type: `AuditEventsStreamingHeadersDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | Header to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingHeadersUpdate`

Input type: `AuditEventsStreamingHeadersUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingHeaderID!`](#auditeventsstreamingheaderid) | Header to update. |
| <a id="mutationauditeventsstreamingheadersupdatekey"></a>`key` | [`String`](#string) | Header key. |
| <a id="mutationauditeventsstreamingheadersupdatevalue"></a>`value` | [`String`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreamingheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreamingheadersupdateheader"></a>`header` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | Updates header. |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersAdd`

Input type: `AuditEventsStreamingHTTPNamespaceFiltersAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadddestinationid"></a>`destinationId` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | Destination ID. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersaddnamespacefilter"></a>`namespaceFilter` | [`AuditEventStreamingHTTPNamespaceFilter`](#auditeventstreaminghttpnamespacefilter) | Namespace filter created. |

### `Mutation.auditEventsStreamingHttpNamespaceFiltersDelete`

Input type: `AuditEventsStreamingHTTPNamespaceFiltersDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeletenamespacefilterid"></a>`namespaceFilterId` | [`AuditEventsStreamingHTTPNamespaceFilterID!`](#auditeventsstreaminghttpnamespacefilterid) | Namespace filter ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminghttpnamespacefiltersdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingInstanceHeadersCreate`

Input type: `AuditEventsStreamingInstanceHeadersCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheaderscreatedestinationid"></a>`destinationId` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | Instance level external destination to associate header with. |
| <a id="mutationauditeventsstreaminginstanceheaderscreatekey"></a>`key` | [`String!`](#string) | Header key. |
| <a id="mutationauditeventsstreaminginstanceheaderscreatevalue"></a>`value` | [`String!`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheaderscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheaderscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreaminginstanceheaderscreateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | Created header. |

### `Mutation.auditEventsStreamingInstanceHeadersDestroy`

Input type: `AuditEventsStreamingInstanceHeadersDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | Header to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.auditEventsStreamingInstanceHeadersUpdate`

Input type: `AuditEventsStreamingInstanceHeadersUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateactive"></a>`active` | [`Boolean`](#boolean) | Boolean option determining whether header is active or not. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheaderid"></a>`headerId` | [`AuditEventsStreamingInstanceHeaderID!`](#auditeventsstreaminginstanceheaderid) | Header to update. |
| <a id="mutationauditeventsstreaminginstanceheadersupdatekey"></a>`key` | [`String`](#string) | Header key. |
| <a id="mutationauditeventsstreaminginstanceheadersupdatevalue"></a>`value` | [`String`](#string) | Header value. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationauditeventsstreaminginstanceheadersupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationauditeventsstreaminginstanceheadersupdateheader"></a>`header` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | Updates header. |

### `Mutation.awardEmojiAdd`

Input type: `AwardEmojiAddInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiaddname"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiaddawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Emoji reactions after mutation. |
| <a id="mutationawardemojiaddclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiadderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.awardEmojiRemove`

Input type: `AwardEmojiRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiremovename"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojiremoveawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Emoji reactions after mutation. |
| <a id="mutationawardemojiremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojiremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.awardEmojiToggle`

Input type: `AwardEmojiToggleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardableid"></a>`awardableId` | [`AwardableID!`](#awardableid) | Global ID of the awardable resource. |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojitogglename"></a>`name` | [`String!`](#string) | Emoji name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationawardemojitoggleawardemoji"></a>`awardEmoji` | [`AwardEmoji`](#awardemoji) | Emoji reactions after mutation. |
| <a id="mutationawardemojitoggleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationawardemojitoggleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationawardemojitoggletoggledon"></a>`toggledOn` | [`Boolean!`](#boolean) | Indicates the status of the emoji. True if the toggle awarded the emoji, and false if the toggle removed the emoji. |

### `Mutation.boardEpicCreate`

Input type: `BoardEpicCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board that the epic is in. |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardepiccreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to create is in. |
| <a id="mutationboardepiccreatelistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic board list in which epic will be created. |
| <a id="mutationboardepiccreatetitle"></a>`title` | [`String!`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardepiccreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardepiccreateepic"></a>`epic` | [`Epic`](#epic) | Epic after creation. |
| <a id="mutationboardepiccreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.boardListCreate`

Input type: `BoardListCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateassigneeid"></a>`assigneeId` | [`UserID`](#userid) | Global ID of an existing user. |
| <a id="mutationboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | Create the backlog list. |
| <a id="mutationboardlistcreateboardid"></a>`boardId` | [`BoardID!`](#boardid) | Global ID of the issue board to mutate. |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistcreateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global ID of an existing iteration. |
| <a id="mutationboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | Global ID of an existing label. |
| <a id="mutationboardlistcreatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Global ID of an existing milestone. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationboardlistcreatelist"></a>`list` | [`BoardList`](#boardlist) | Issue list in the issue board. |

### `Mutation.boardListUpdateLimitMetrics`

Input type: `BoardListUpdateLimitMetricsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistupdatelimitmetricslimitmetric"></a>`limitMetric` | [`ListLimitMetric`](#listlimitmetric) | New limit metric type for the list. |
| <a id="mutationboardlistupdatelimitmetricslistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="mutationboardlistupdatelimitmetricsmaxissuecount"></a>`maxIssueCount` | [`Int`](#int) | New maximum issue count limit. |
| <a id="mutationboardlistupdatelimitmetricsmaxissueweight"></a>`maxIssueWeight` | [`Int`](#int) | New maximum issue weight limit. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationboardlistupdatelimitmetricsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationboardlistupdatelimitmetricserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationboardlistupdatelimitmetricslist"></a>`list` | [`BoardList`](#boardlist) | Updated list. |

### `Mutation.branchRuleApprovalProjectRuleCreate`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `branchRuleApprovalProjectRuleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | How many approvals are required to satify rule. |
| <a id="mutationbranchruleapprovalprojectrulecreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to destroy. |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleapprovalprojectrulecreategroupids"></a>`groupIds` | [`[ID!]`](#id) | List of IDs of Groups that can approval rule. |
| <a id="mutationbranchruleapprovalprojectrulecreatename"></a>`name` | [`String!`](#string) | Name of the approval rule. |
| <a id="mutationbranchruleapprovalprojectrulecreateuserids"></a>`userIds` | [`[ID!]`](#id) | List of IDs of Users that can approval rule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleapprovalprojectrulecreateapprovalrule"></a>`approvalRule` | [`ApprovalProjectRule`](#approvalprojectrule) | Approval rule after mutation. |
| <a id="mutationbranchruleapprovalprojectrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleapprovalprojectrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.branchRuleCreate`

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `BranchRuleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchrulecreatename"></a>`name` | [`String!`](#string) | Branch name, with wildcards, for the branch rules. |
| <a id="mutationbranchrulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path to the project that the branch is associated with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchrulecreatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | Branch rule after mutation. |
| <a id="mutationbranchrulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchrulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.branchRuleDelete`

DETAILS:
**Introduced** in GitLab 16.9.
**Status**: Experiment.

Input type: `BranchRuleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruledeleteid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruledeletebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | Branch rule after mutation. |
| <a id="mutationbranchruledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.branchRuleExternalStatusCheckCreate`

Create a new external status check from a branch rule.

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `BranchRuleExternalStatusCheckCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to update. |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalurl"></a>`externalUrl` | [`String!`](#string) | URL of external status check resource. |
| <a id="mutationbranchruleexternalstatuscheckcreatename"></a>`name` | [`String!`](#string) | Name of the external status check. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationbranchruleexternalstatuscheckcreateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | New status check after mutation. |

### `Mutation.branchRuleExternalStatusCheckDestroy`

Destroy an external status check from a branch rule.

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `BranchRuleExternalStatusCheckDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroybranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule. |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckdestroyid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | Global ID of the external status check to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.branchRuleExternalStatusCheckUpdate`

Update an external status check from a branch rule.

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `BranchRuleExternalStatusCheckUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdatebranchruleid"></a>`branchRuleId` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule. |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalurl"></a>`externalUrl` | [`String!`](#string) | External URL of the external status check. |
| <a id="mutationbranchruleexternalstatuscheckupdateid"></a>`id` | [`MergeRequestsExternalStatusCheckID!`](#mergerequestsexternalstatuscheckid) | Global ID of the external status check to update. |
| <a id="mutationbranchruleexternalstatuscheckupdatename"></a>`name` | [`String!`](#string) | Name of the external status check. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleexternalstatuscheckupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleexternalstatuscheckupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationbranchruleexternalstatuscheckupdateexternalstatuscheck"></a>`externalStatusCheck` | [`ExternalStatusCheck`](#externalstatuscheck) | Updated external status check after mutation. |

### `Mutation.branchRuleUpdate`

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `BranchRuleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchprotection"></a>`branchProtection` | [`BranchProtectionInput`](#branchprotectioninput) | Branch protections configured for the branch rule. |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleupdateid"></a>`id` | [`ProjectsBranchRuleID!`](#projectsbranchruleid) | Global ID of the branch rule to update. |
| <a id="mutationbranchruleupdatename"></a>`name` | [`String!`](#string) | Branch name, with wildcards, for the branch rules. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbranchruleupdatebranchrule"></a>`branchRule` | [`BranchRule`](#branchrule) | Branch rule after mutation. |
| <a id="mutationbranchruleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbranchruleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.buildForecast`

DETAILS:
**Introduced** in GitLab 16.0.
**Status**: Experiment.

Input type: `BuildForecastInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbuildforecastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbuildforecastcontextid"></a>`contextId` | [`GlobalID!`](#globalid) | Global ID of the context for the forecast to pick an appropriate model. |
| <a id="mutationbuildforecasthorizon"></a>`horizon` | [`Int!`](#int) | Number of data points to forecast. |
| <a id="mutationbuildforecasttype"></a>`type` | [`String!`](#string) | Type of the forecast. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbuildforecastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbuildforecasterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationbuildforecastforecast"></a>`forecast` | [`Forecast!`](#forecast) | Created forecast. |

### `Mutation.bulkDestroyJobArtifacts`

DETAILS:
**Introduced** in GitLab 15.10.
**Status**: Experiment.

Input type: `BulkDestroyJobArtifactsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkdestroyjobartifactsids"></a>`ids` | [`[CiJobArtifactID!]!`](#cijobartifactid) | Global IDs of the job artifacts to destroy. |
| <a id="mutationbulkdestroyjobartifactsprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global Project ID of the job artifacts to destroy. Incompatible with projectPath. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkdestroyjobartifactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkdestroyjobartifactsdestroyedcount"></a>`destroyedCount` | [`Int`](#int) | Number of job artifacts deleted. |
| <a id="mutationbulkdestroyjobartifactsdestroyedids"></a>`destroyedIds` | [`[CiJobArtifactID!]`](#cijobartifactid) | IDs of job artifacts that were deleted. |
| <a id="mutationbulkdestroyjobartifactserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.bulkEnableDevopsAdoptionNamespaces`

**Status:** Beta.

Input type: `BulkEnableDevopsAdoptionNamespacesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespacesdisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Display namespace ID. |
| <a id="mutationbulkenabledevopsadoptionnamespacesnamespaceids"></a>`namespaceIds` | [`[NamespaceID!]!`](#namespaceid) | List of Namespace IDs. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkenabledevopsadoptionnamespacesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespacesenablednamespaces"></a>`enabledNamespaces` | [`[DevopsAdoptionEnabledNamespace!]`](#devopsadoptionenablednamespace) | Enabled namespaces after mutation. |
| <a id="mutationbulkenabledevopsadoptionnamespaceserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.bulkRunnerDelete`

DETAILS:
**Introduced** in GitLab 15.3.
**Status**: Experiment.

Input type: `BulkRunnerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkrunnerdeleteids"></a>`ids` | [`[CiRunnerID!]`](#cirunnerid) | IDs of the runners to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationbulkrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationbulkrunnerdeletedeletedcount"></a>`deletedCount` | [`Int`](#int) | Number of records effectively deleted. Only present if operation was performed synchronously. |
| <a id="mutationbulkrunnerdeletedeletedids"></a>`deletedIds` | [`[CiRunnerID!]`](#cirunnerid) | IDs of records effectively deleted. Only present if operation was performed synchronously. |
| <a id="mutationbulkrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.catalogResourcesCreate`

DETAILS:
**Introduced** in GitLab 15.11.
**Status**: Experiment.

Input type: `CatalogResourcesCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcescreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path belonging to the catalog resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcescreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcescreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.catalogResourcesDestroy`

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `CatalogResourcesDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcesdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path belonging to the catalog resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcatalogresourcesdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcatalogresourcesdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.ciJobTokenScopeAddGroupOrProject`

Input type: `CiJobTokenScopeAddGroupOrProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddgrouporprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscopeaddgrouporprojecttargetpath"></a>`targetPath` | [`ID!`](#id) | Group or project to be added to the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddgrouporprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscopeaddgrouporprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddgrouporprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.ciJobTokenScopeAddProject`

Input type: `CiJobTokenScopeAddProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddprojectdirection"></a>`direction` **{warning-solid}** | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **Deprecated:** Outbound job token scope is being removed. This field can now only be set to INBOUND. Deprecated in GitLab 16.0. |
| <a id="mutationcijobtokenscopeaddprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscopeaddprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to be added to the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscopeaddprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscopeaddprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscopeaddprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.ciJobTokenScopeRemoveGroup`

Input type: `CiJobTokenScopeRemoveGroupInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemovegroupprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscoperemovegrouptargetgrouppath"></a>`targetGroupPath` | [`ID!`](#id) | Group to be removed from the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemovegroupcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's access scope. |
| <a id="mutationcijobtokenscoperemovegroupclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemovegrouperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.ciJobTokenScopeRemoveProject`

Input type: `CiJobTokenScopeRemoveProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemoveprojectdirection"></a>`direction` **{warning-solid}** | [`CiJobTokenScopeDirection`](#cijobtokenscopedirection) | **Deprecated:** Outbound job token scope is being removed. This field can now only be set to INBOUND. Deprecated in GitLab 16.9. |
| <a id="mutationcijobtokenscoperemoveprojectprojectpath"></a>`projectPath` | [`ID!`](#id) | Project that the CI job token scope belongs to. |
| <a id="mutationcijobtokenscoperemoveprojecttargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to be removed from the CI job token scope. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcijobtokenscoperemoveprojectcijobtokenscope"></a>`ciJobTokenScope` | [`CiJobTokenScopeType`](#cijobtokenscopetype) | CI job token's scope of access. |
| <a id="mutationcijobtokenscoperemoveprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcijobtokenscoperemoveprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.clusterAgentDelete`

Input type: `ClusterAgentDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragentdeleteid"></a>`id` | [`ClustersAgentID!`](#clustersagentid) | Global ID of the cluster agent that will be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.clusterAgentTokenCreate`

Input type: `ClusterAgentTokenCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokencreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | Global ID of the cluster agent that will be associated with the new token. |
| <a id="mutationclusteragenttokencreatedescription"></a>`description` | [`String`](#string) | Description of the token. |
| <a id="mutationclusteragenttokencreatename"></a>`name` | [`String!`](#string) | Name of the token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokencreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationclusteragenttokencreatesecret"></a>`secret` | [`String`](#string) | Token secret value. Make sure you save it - you won't be able to access it again. |
| <a id="mutationclusteragenttokencreatetoken"></a>`token` | [`ClusterAgentToken`](#clusteragenttoken) | Token created after mutation. |

### `Mutation.clusterAgentTokenRevoke`

Input type: `ClusterAgentTokenRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokenrevokeid"></a>`id` | [`ClustersAgentTokenID!`](#clustersagenttokenid) | Global ID of the agent token that will be revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationclusteragenttokenrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationclusteragenttokenrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.commitCreate`

Input type: `CommitCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateactions"></a>`actions` | [`[CommitAction!]!`](#commitaction) | Array of action hashes to commit as a batch. |
| <a id="mutationcommitcreatebranch"></a>`branch` | [`String!`](#string) | Name of the branch to commit into, it can be a new branch. |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcommitcreatemessage"></a>`message` | [`String!`](#string) | Raw commit message. |
| <a id="mutationcommitcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |
| <a id="mutationcommitcreatestartbranch"></a>`startBranch` | [`String`](#string) | If on a new branch, name of the original branch. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcommitcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcommitcreatecommit"></a>`commit` | [`Commit`](#commit) | Commit after mutation. |
| <a id="mutationcommitcreatecommitpipelinepath"></a>`commitPipelinePath` | [`String`](#string) | ETag path for the commit's pipeline. |
| <a id="mutationcommitcreatecontent"></a>`content` | [`[String!]`](#string) | Contents of the commit. |
| <a id="mutationcommitcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.configureContainerScanning`

Configure Container Scanning for a project by enabling Container Scanning in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a merge request are part of the response.

Input type: `ConfigureContainerScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfigurecontainerscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfigurecontainerscanningbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfigurecontainerscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfigurecontainerscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfigurecontainerscanningsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureDependencyScanning`

Configure Dependency Scanning for a project by enabling Dependency Scanning in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a Merge Request are a part of the response.

Input type: `ConfigureDependencyScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguredependencyscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguredependencyscanningbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguredependencyscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguredependencyscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguredependencyscanningsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSast`

Configure SAST for a project by enabling SAST in a new or modified
`.gitlab-ci.yml` file in a new branch. The new branch and a URL to
create a Merge Request are a part of the response.

Input type: `ConfigureSastInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastconfiguration"></a>`configuration` | [`SastCiConfigurationInput!`](#sastciconfigurationinput) | SAST CI configuration for the project. |
| <a id="mutationconfiguresastprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresastclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresasterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguresastsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSastIac`

Enable SAST IaC for a project in a new or
modified `.gitlab-ci.yml` file in a new branch. The new
branch and a URL to create a merge request are a part of the
response.

Input type: `ConfigureSastIacInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastiacprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresastiacbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresastiacclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresastiacerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguresastiacsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.configureSecretDetection`

Configure Secret Detection for a project by enabling Secret Detection
in a new or modified `.gitlab-ci.yml` file in a new branch. The new
branch and a URL to create a Merge Request are a part of the
response.

Input type: `ConfigureSecretDetectionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresecretdetectionprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationconfiguresecretdetectionbranch"></a>`branch` | [`String`](#string) | Branch that has the new/modified `.gitlab-ci.yml` file. |
| <a id="mutationconfiguresecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationconfiguresecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationconfiguresecretdetectionsuccesspath"></a>`successPath` | [`String`](#string) | Redirect path to use when the response is successful. |

### `Mutation.corpusCreate`

Input type: `CorpusCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcorpuscreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the corpus belongs to. |
| <a id="mutationcorpuscreatepackageid"></a>`packageId` | [`PackagesPackageID!`](#packagespackageid) | ID of the corpus package. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcorpuscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcorpuscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createAlertIssue`

Input type: `CreateAlertIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatealertissueiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationcreatealertissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatealertissuealert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationcreatealertissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatealertissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatealertissueissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationcreatealertissuetodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.createAnnotation`

DETAILS:
**Deprecated** in GitLab 16.0.
Underlying feature was removed in 16.0.

Input type: `CreateAnnotationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateannotationclusterid"></a>`clusterId` | [`ClustersClusterID`](#clustersclusterid) | Global ID of the cluster to add an annotation to. |
| <a id="mutationcreateannotationdashboardpath"></a>`dashboardPath` | [`String!`](#string) | Path to a file defining the dashboard on which the annotation should be added. |
| <a id="mutationcreateannotationdescription"></a>`description` | [`String!`](#string) | Description of the annotation. |
| <a id="mutationcreateannotationendingat"></a>`endingAt` | [`Time`](#time) | Timestamp indicating ending moment to which the annotation relates. |
| <a id="mutationcreateannotationenvironmentid"></a>`environmentId` | [`EnvironmentID`](#environmentid) | Global ID of the environment to add an annotation to. |
| <a id="mutationcreateannotationstartingat"></a>`startingAt` | [`Time!`](#time) | Timestamp indicating starting moment to which the annotation relates. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateannotationannotation"></a>`annotation` | [`MetricsDashboardAnnotation`](#metricsdashboardannotation) | Created annotation. |
| <a id="mutationcreateannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateannotationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createBoard`

Input type: `CreateBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ID of user to be assigned to the board. |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateboardgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationcreateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationcreateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationcreateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ID of iteration cadence to be assigned to the board. |
| <a id="mutationcreateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ID of iteration to be assigned to the board. |
| <a id="mutationcreateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationcreateboardlabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationcreateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of milestone to be assigned to the board. |
| <a id="mutationcreateboardname"></a>`name` | [`String`](#string) | Board name. |
| <a id="mutationcreateboardprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationcreateboardweight"></a>`weight` | [`Int`](#int) | Weight value to be assigned to the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationcreateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createBranch`

Input type: `CreateBranchInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatebranchname"></a>`name` | [`String!`](#string) | Name of the branch. |
| <a id="mutationcreatebranchprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the branch is associated with. |
| <a id="mutationcreatebranchref"></a>`ref` | [`String!`](#string) | Branch name or commit SHA to create branch from. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatebranchbranch"></a>`branch` | [`Branch`](#branch) | Branch after mutation. |
| <a id="mutationcreatebranchclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatebrancherrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createClusterAgent`

Input type: `CreateClusterAgentInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateclusteragentname"></a>`name` | [`String!`](#string) | Name of the cluster agent. |
| <a id="mutationcreateclusteragentprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the associated project for the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateclusteragentclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateclusteragentclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | Cluster agent created after mutation. |
| <a id="mutationcreateclusteragenterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createComplianceFramework`

Input type: `CreateComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecomplianceframeworknamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace to add the compliance framework to. |
| <a id="mutationcreatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | Parameters to update the compliance framework with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatecomplianceframeworkframework"></a>`framework` | [`ComplianceFramework`](#complianceframework) | Created compliance framework. |

### `Mutation.createContainerRegistryProtectionRule`

Creates a protection rule to restrict access to a project's container registry. Available only when feature flag `container_registry_protected_containers` is enabled.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `CreateContainerRegistryProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerregistryprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecontainerregistryprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerRegistryProtectionRuleAccessLevel!`](#containerregistryprotectionruleaccesslevel) | Minimum GitLab access level to allow to delete container images in the container registry. For example, `MAINTAINER`, `OWNER`, or `ADMIN`. |
| <a id="mutationcreatecontainerregistryprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerRegistryProtectionRuleAccessLevel!`](#containerregistryprotectionruleaccesslevel) | Minimum GitLab access level to allow to push container images to the container registry. For example, `MAINTAINER`, `OWNER`, or `ADMIN`. |
| <a id="mutationcreatecontainerregistryprotectionruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project where a protection rule is located. |
| <a id="mutationcreatecontainerregistryprotectionrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String!`](#string) | Container repository path pattern protected by the protection rule. For example, `my-project/my-container-*`. Wildcard character `*` allowed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecontainerregistryprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecontainerregistryprotectionrulecontainerregistryprotectionrule"></a>`containerRegistryProtectionRule` | [`ContainerRegistryProtectionRule`](#containerregistryprotectionrule) | Container registry protection rule after mutation. |
| <a id="mutationcreatecontainerregistryprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createCustomEmoji`

Input type: `CreateCustomEmojiInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecustomemojigrouppath"></a>`groupPath` | [`ID!`](#id) | Namespace full path the emoji is associated with. |
| <a id="mutationcreatecustomemojiname"></a>`name` | [`String!`](#string) | Name of the emoji. |
| <a id="mutationcreatecustomemojiurl"></a>`url` | [`String!`](#string) | Location of the emoji file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatecustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatecustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | New custom emoji. |
| <a id="mutationcreatecustomemojierrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createDiffNote`

Input type: `CreateDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |
| <a id="mutationcreatediffnoteposition"></a>`position` | [`DiffPositionInput!`](#diffpositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.createDiscussion`

Input type: `CreateDiscussionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionbody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediscussioninternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatediscussionnoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatediscussionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatediscussionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatediscussionnote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.createEpic`

Input type: `CreateEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the epic. |
| <a id="mutationcreateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | Array of labels to be added to the epic. |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateepiccolor"></a>`color` | [`Color`](#color) | Color of the epic. Available only when feature flag `epic_color_highlight` is enabled. This flag is disabled by default, because the feature is experimental and is subject to change without notice. |
| <a id="mutationcreateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="mutationcreateepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="mutationcreateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | End date of the epic. |
| <a id="mutationcreateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates end date should be sourced from due_date_fixed field not the issue milestones. |
| <a id="mutationcreateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate is in. |
| <a id="mutationcreateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the epic. |
| <a id="mutationcreateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | Start date of the epic. |
| <a id="mutationcreateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates start date should be sourced from start_date_fixed field not the issue milestones. |
| <a id="mutationcreateepictitle"></a>`title` | [`String`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateepicepic"></a>`epic` | [`Epic`](#epic) | Created epic. |
| <a id="mutationcreateepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.createImageDiffNote`

Input type: `CreateImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateimagediffnoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreateimagediffnotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |
| <a id="mutationcreateimagediffnoteposition"></a>`position` | [`DiffImagePositionInput!`](#diffimagepositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreateimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.createIssue`

Input type: `CreateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | Array of user IDs to assign to the issue. |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates the issue is confidential. |
| <a id="mutationcreateissuecreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the issue was created. Available only for admins and project owners. |
| <a id="mutationcreateissuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="mutationcreateissuediscussiontoresolve"></a>`discussionToResolve` | [`String`](#string) | ID of a discussion to resolve. Also pass `merge_request_to_resolve_discussions_of`. |
| <a id="mutationcreateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | Due date of the issue. |
| <a id="mutationcreateissueepicid"></a>`epicId` | [`EpicID`](#epicid) | ID of an epic to associate the issue with. |
| <a id="mutationcreateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Desired health status. |
| <a id="mutationcreateissueiid"></a>`iid` | [`Int`](#int) | IID (internal ID) of a project issue. Only admins and project owners can modify. |
| <a id="mutationcreateissueiterationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global iteration cadence ID. Required when `iterationWildcardId` is provided. |
| <a id="mutationcreateissueiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global iteration ID. Mutually exlusive argument with `iterationWildcardId`. |
| <a id="mutationcreateissueiterationwildcardid"></a>`iterationWildcardId` | [`IssueCreationIterationWildcardId`](#issuecreationiterationwildcardid) | Iteration wildcard ID. Supported values are: `CURRENT`. Mutually exclusive argument with `iterationId`. iterationCadenceId also required when this argument is provided. |
| <a id="mutationcreateissuelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the issue. |
| <a id="mutationcreateissuelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationcreateissuelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="mutationcreateissuemergerequesttoresolvediscussionsof"></a>`mergeRequestToResolveDiscussionsOf` | [`MergeRequestID`](#mergerequestid) | IID of a merge request for which to resolve discussions. |
| <a id="mutationcreateissuemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of the milestone to assign to the issue. On update milestone will be removed if set to null. |
| <a id="mutationcreateissuemoveafterid"></a>`moveAfterId` | [`IssueID`](#issueid) | Global ID of issue that should be placed after the current issue. |
| <a id="mutationcreateissuemovebeforeid"></a>`moveBeforeId` | [`IssueID`](#issueid) | Global ID of issue that should be placed before the current issue. |
| <a id="mutationcreateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the issue is associated with. |
| <a id="mutationcreateissuetitle"></a>`title` | [`String!`](#string) | Title of the issue. |
| <a id="mutationcreateissuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="mutationcreateissueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreateissueissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.createIteration`

DETAILS:
**Deprecated** in GitLab 14.0.
Use iterationCreate.

Input type: `CreateIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateiterationdescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationcreateiterationduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationcreateiterationgrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationcreateiterationiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global ID of the iteration cadence to be assigned to the new iteration. |
| <a id="mutationcreateiterationprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationcreateiterationstartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationcreateiterationtitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreateiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | Created iteration. |

### `Mutation.createNote`

Creates a Note.
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `CreateNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatenotebody"></a>`body` | [`String!`](#string) | Content of the note. |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatenotediscussionid"></a>`discussionId` | [`DiscussionID`](#discussionid) | Global ID of the discussion the note is in reply to. |
| <a id="mutationcreatenoteinternal"></a>`internal` | [`Boolean`](#boolean) | Internal flag for a note. Default is false. |
| <a id="mutationcreatenotemergerequestdiffheadsha"></a>`mergeRequestDiffHeadSha` | [`String`](#string) | SHA of the head commit which is used to ensure that the merge request has not been updated since the request was sent. |
| <a id="mutationcreatenotenoteableid"></a>`noteableId` | [`NoteableID!`](#noteableid) | Global ID of the resource to add a note to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatenoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatenotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.createPackagesProtectionRule`

Creates a protection rule to restrict access to project packages. Available only when feature flag `packages_protected_packages` is enabled.

DETAILS:
**Introduced** in GitLab 16.5.
**Status**: Experiment.

Input type: `CreatePackagesProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String!`](#string) | Package name protected by the protection rule. For example `@my-scope/my-package-*`. Wildcard character `*` allowed. |
| <a id="mutationcreatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType!`](#packagesprotectionrulepackagetype) | Package type protected by the protection rule. For example `NPM`. |
| <a id="mutationcreatepackagesprotectionruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project where a protection rule is located. |
| <a id="mutationcreatepackagesprotectionrulepushprotecteduptoaccesslevel"></a>`pushProtectedUpToAccessLevel` | [`PackagesProtectionRuleAccessLevel!`](#packagesprotectionruleaccesslevel) | Max GitLab access level unable to push a package. For example `DEVELOPER`, `MAINTAINER`, `OWNER`. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | Packages protection rule after mutation. |

### `Mutation.createRequirement`

Input type: `CreateRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreaterequirementdescription"></a>`description` | [`String`](#string) | Description of the requirement. |
| <a id="mutationcreaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirement is associated with. |
| <a id="mutationcreaterequirementtitle"></a>`title` | [`String`](#string) | Title of the requirement. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | Requirement after mutation. |

### `Mutation.createSnippet`

Input type: `CreateSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | Actions to perform over the snippet repository and blobs. |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatesnippetdescription"></a>`description` | [`String`](#string) | Description of the snippet. |
| <a id="mutationcreatesnippetprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project the snippet is associated with. |
| <a id="mutationcreatesnippettitle"></a>`title` | [`String!`](#string) | Title of the snippet. |
| <a id="mutationcreatesnippetuploadedfiles"></a>`uploadedFiles` | [`[String!]`](#string) | Paths to files uploaded in the snippet description. |
| <a id="mutationcreatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum!`](#visibilitylevelsenum) | Visibility level of the snippet. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.createTestCase`

Input type: `CreateTestCaseInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatetestcaseconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the test case confidentiality. |
| <a id="mutationcreatetestcasedescription"></a>`description` | [`String`](#string) | Test case description. |
| <a id="mutationcreatetestcaselabelids"></a>`labelIds` | [`[ID!]`](#id) | IDs of labels to be added to the test case. |
| <a id="mutationcreatetestcaseprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path to create the test case in. |
| <a id="mutationcreatetestcasetitle"></a>`title` | [`String!`](#string) | Test case title. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcreatetestcaseclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcreatetestcaseerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcreatetestcasetestcase"></a>`testCase` | [`Issue`](#issue) | Test case created. |

### `Mutation.customerRelationsContactCreate`

Input type: `CustomerRelationsContactCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactcreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the contact. |
| <a id="mutationcustomerrelationscontactcreateemail"></a>`email` | [`String`](#string) | Email address of the contact. |
| <a id="mutationcustomerrelationscontactcreatefirstname"></a>`firstName` | [`String!`](#string) | First name of the contact. |
| <a id="mutationcustomerrelationscontactcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the contact. |
| <a id="mutationcustomerrelationscontactcreatelastname"></a>`lastName` | [`String!`](#string) | Last name of the contact. |
| <a id="mutationcustomerrelationscontactcreateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | Organization for the contact. |
| <a id="mutationcustomerrelationscontactcreatephone"></a>`phone` | [`String`](#string) | Phone number of the contact. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactcreatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | Contact after the mutation. |
| <a id="mutationcustomerrelationscontactcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.customerRelationsContactUpdate`

Input type: `CustomerRelationsContactUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateactive"></a>`active` | [`Boolean`](#boolean) | State of the contact. |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the contact. |
| <a id="mutationcustomerrelationscontactupdateemail"></a>`email` | [`String`](#string) | Email address of the contact. |
| <a id="mutationcustomerrelationscontactupdatefirstname"></a>`firstName` | [`String`](#string) | First name of the contact. |
| <a id="mutationcustomerrelationscontactupdateid"></a>`id` | [`CustomerRelationsContactID!`](#customerrelationscontactid) | Global ID of the contact. |
| <a id="mutationcustomerrelationscontactupdatelastname"></a>`lastName` | [`String`](#string) | Last name of the contact. |
| <a id="mutationcustomerrelationscontactupdateorganizationid"></a>`organizationId` | [`CustomerRelationsOrganizationID`](#customerrelationsorganizationid) | Organization of the contact. |
| <a id="mutationcustomerrelationscontactupdatephone"></a>`phone` | [`String`](#string) | Phone number of the contact. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationscontactupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationscontactupdatecontact"></a>`contact` | [`CustomerRelationsContact`](#customerrelationscontact) | Contact after the mutation. |
| <a id="mutationcustomerrelationscontactupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.customerRelationsOrganizationCreate`

Input type: `CustomerRelationsOrganizationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationcreatedefaultrate"></a>`defaultRate` | [`Float`](#float) | Standard billing rate for the organization. |
| <a id="mutationcustomerrelationsorganizationcreatedescription"></a>`description` | [`String`](#string) | Description of or notes for the organization. |
| <a id="mutationcustomerrelationsorganizationcreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the organization. |
| <a id="mutationcustomerrelationsorganizationcreatename"></a>`name` | [`String!`](#string) | Name of the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcustomerrelationsorganizationcreateorganization"></a>`organization` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | Organization after the mutation. |

### `Mutation.customerRelationsOrganizationUpdate`

Input type: `CustomerRelationsOrganizationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateactive"></a>`active` | [`Boolean`](#boolean) | State of the organization. |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationupdatedefaultrate"></a>`defaultRate` | [`Float`](#float) | Standard billing rate for the organization. |
| <a id="mutationcustomerrelationsorganizationupdatedescription"></a>`description` | [`String`](#string) | Description of or notes for the organization. |
| <a id="mutationcustomerrelationsorganizationupdateid"></a>`id` | [`CustomerRelationsOrganizationID!`](#customerrelationsorganizationid) | Global ID of the organization. |
| <a id="mutationcustomerrelationsorganizationupdatename"></a>`name` | [`String`](#string) | Name of the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationcustomerrelationsorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationcustomerrelationsorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationcustomerrelationsorganizationupdateorganization"></a>`organization` | [`CustomerRelationsOrganization!`](#customerrelationsorganization) | Organization after the mutation. |

### `Mutation.dastOnDemandScanCreate`

Input type: `DastOnDemandScanCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastondemandscancreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | ID of the scanner profile to be used for the scan. |
| <a id="mutationdastondemandscancreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be used for the scan. |
| <a id="mutationdastondemandscancreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastondemandscancreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastondemandscancreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastondemandscancreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. |

### `Mutation.dastProfileCreate`

Input type: `DastProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreatebranchname"></a>`branchName` | [`String`](#string) | Associated branch. |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilecreatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | Represents a DAST Profile Schedule. |
| <a id="mutationdastprofilecreatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be associated. |
| <a id="mutationdastprofilecreatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be associated. |
| <a id="mutationdastprofilecreatedescription"></a>`description` | [`String`](#string) | Description of the profile. Defaults to an empty string. |
| <a id="mutationdastprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the profile belongs to. |
| <a id="mutationdastprofilecreatename"></a>`name` | [`String!`](#string) | Name of the profile. |
| <a id="mutationdastprofilecreaterunaftercreate"></a>`runAfterCreate` | [`Boolean`](#boolean) | Run scan using profile after creation. Defaults to false. |
| <a id="mutationdastprofilecreatetaglist"></a>`tagList` | [`[String!]`](#string) | Indicates the runner tags associated with the profile. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilecreatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | Created profile. |
| <a id="mutationdastprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastprofilecreatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. Requires `runAfterCreate` to be set to `true`. |

### `Mutation.dastProfileDelete`

Input type: `DastProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofiledeleteid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.dastProfileRun`

Input type: `DastProfileRunInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilerunfullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastprofilerunid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be used for the scan. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofilerunclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofilerunerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastprofilerunpipelineurl"></a>`pipelineUrl` | [`String`](#string) | URL of the pipeline that was created. |

### `Mutation.dastProfileUpdate`

Input type: `DastProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdatebranchname"></a>`branchName` | [`String`](#string) | Associated branch. |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofileupdatedastprofileschedule"></a>`dastProfileSchedule` | [`DastProfileScheduleInput`](#dastprofilescheduleinput) | Represents a DAST profile schedule. |
| <a id="mutationdastprofileupdatedastscannerprofileid"></a>`dastScannerProfileId` | [`DastScannerProfileID`](#dastscannerprofileid) | ID of the scanner profile to be associated. |
| <a id="mutationdastprofileupdatedastsiteprofileid"></a>`dastSiteProfileId` | [`DastSiteProfileID`](#dastsiteprofileid) | ID of the site profile to be associated. |
| <a id="mutationdastprofileupdatedescription"></a>`description` | [`String`](#string) | Description of the profile. Defaults to an empty string. |
| <a id="mutationdastprofileupdatefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastprofileupdateid"></a>`id` | [`DastProfileID!`](#dastprofileid) | ID of the profile to be deleted. |
| <a id="mutationdastprofileupdatename"></a>`name` | [`String`](#string) | Name of the profile. |
| <a id="mutationdastprofileupdaterunafterupdate"></a>`runAfterUpdate` | [`Boolean`](#boolean) | Run scan using profile after update. Defaults to false. |
| <a id="mutationdastprofileupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Indicates the runner tags associated with the profile. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastprofileupdatedastprofile"></a>`dastProfile` | [`DastProfile`](#dastprofile) | Updated profile. |
| <a id="mutationdastprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastprofileupdatepipelineurl"></a>`pipelineUrl` | [`String`](#string) | The URL of the pipeline that was created. Requires the input argument `runAfterUpdate` to be set to `true` when calling the mutation, otherwise no pipeline will be created. |

### `Mutation.dastScannerProfileCreate`

Input type: `DastScannerProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the scanner profile belongs to. |
| <a id="mutationdastscannerprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | Name of the scanner profile. |
| <a id="mutationdastscannerprofilecreatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | Indicates the type of DAST scan that will run. Either a Passive Scan or an Active Scan. |
| <a id="mutationdastscannerprofilecreateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | Indicates if debug messages should be included in DAST console output. True to include the debug messages. |
| <a id="mutationdastscannerprofilecreatespidertimeout"></a>`spiderTimeout` | [`Int`](#int) | Maximum number of minutes allowed for the spider to traverse the site. |
| <a id="mutationdastscannerprofilecreatetaglist"></a>`tagList` **{warning-solid}** | [`[String!]`](#string) | **Deprecated:** Moved to DastProfile. Deprecated in GitLab 15.8. |
| <a id="mutationdastscannerprofilecreatetargettimeout"></a>`targetTimeout` | [`Int`](#int) | Maximum number of seconds allowed for the site under test to respond to a request. |
| <a id="mutationdastscannerprofilecreateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | Indicates if the AJAX spider should be used to crawl the target site. True to run the AJAX spider in addition to the traditional spider, and false to run only the traditional spider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofilecreatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | Created scanner profile. |
| <a id="mutationdastscannerprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastscannerprofilecreateid"></a>`id` **{warning-solid}** | [`DastScannerProfileID`](#dastscannerprofileid) | **Deprecated:** use `dastScannerProfile` field. Deprecated in GitLab 14.10. |

### `Mutation.dastScannerProfileDelete`

Input type: `DastScannerProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofiledeletefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastscannerprofiledeleteid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.dastScannerProfileUpdate`

Input type: `DastScannerProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofileupdatefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastscannerprofileupdateid"></a>`id` | [`DastScannerProfileID!`](#dastscannerprofileid) | ID of the scanner profile to be updated. |
| <a id="mutationdastscannerprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | Name of the scanner profile. |
| <a id="mutationdastscannerprofileupdatescantype"></a>`scanType` | [`DastScanTypeEnum`](#dastscantypeenum) | Indicates the type of DAST scan that will run. Either a Passive Scan or an Active Scan. |
| <a id="mutationdastscannerprofileupdateshowdebugmessages"></a>`showDebugMessages` | [`Boolean`](#boolean) | Indicates if debug messages should be included in DAST console output. True to include the debug messages. |
| <a id="mutationdastscannerprofileupdatespidertimeout"></a>`spiderTimeout` | [`Int!`](#int) | Maximum number of minutes allowed for the spider to traverse the site. |
| <a id="mutationdastscannerprofileupdatetaglist"></a>`tagList` **{warning-solid}** | [`[String!]`](#string) | **Deprecated:** Moved to DastProfile. Deprecated in GitLab 15.8. |
| <a id="mutationdastscannerprofileupdatetargettimeout"></a>`targetTimeout` | [`Int!`](#int) | Maximum number of seconds allowed for the site under test to respond to a request. |
| <a id="mutationdastscannerprofileupdateuseajaxspider"></a>`useAjaxSpider` | [`Boolean`](#boolean) | Indicates if the AJAX spider should be used to crawl the target site. True to run the AJAX spider in addition to the traditional spider, and false to run only the traditional spider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastscannerprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastscannerprofileupdatedastscannerprofile"></a>`dastScannerProfile` | [`DastScannerProfile`](#dastscannerprofile) | Updated scanner profile. |
| <a id="mutationdastscannerprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastscannerprofileupdateid"></a>`id` **{warning-solid}** | [`DastScannerProfileID`](#dastscannerprofileid) | **Deprecated:** use `dastScannerProfile` field. Deprecated in GitLab 14.10. |

### `Mutation.dastSiteProfileCreate`

Input type: `DastSiteProfileCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | Parameters for authentication. |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofilecreateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | URLs to skip during an authenticated scan. Defaults to `[]`. |
| <a id="mutationdastsiteprofilecreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |
| <a id="mutationdastsiteprofilecreateprofilename"></a>`profileName` | [`String!`](#string) | Name of the site profile. |
| <a id="mutationdastsiteprofilecreaterequestheaders"></a>`requestHeaders` | [`String`](#string) | Comma-separated list of request header names and values to be added to every request made by DAST. |
| <a id="mutationdastsiteprofilecreatescanfilepath"></a>`scanFilePath` | [`String`](#string) | File Path or URL used as input for the scan method. |
| <a id="mutationdastsiteprofilecreatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | Scan method by the scanner. |
| <a id="mutationdastsiteprofilecreatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | Type of target to be scanned. |
| <a id="mutationdastsiteprofilecreatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be scanned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofilecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofilecreatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | Site Profile object. |
| <a id="mutationdastsiteprofilecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsiteprofilecreateid"></a>`id` **{warning-solid}** | [`DastSiteProfileID`](#dastsiteprofileid) | **Deprecated:** use `dastSiteProfile.id` field. Deprecated in GitLab 14.10. |

### `Mutation.dastSiteProfileDelete`

Input type: `DastSiteProfileDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofiledeletefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastsiteprofiledeleteid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofiledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofiledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.dastSiteProfileUpdate`

Input type: `DastSiteProfileUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateauth"></a>`auth` | [`DastSiteProfileAuthInput`](#dastsiteprofileauthinput) | Parameters for authentication. |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofileupdateexcludedurls"></a>`excludedUrls` | [`[String!]`](#string) | URLs to skip during an authenticated scan. |
| <a id="mutationdastsiteprofileupdatefullpath"></a>`fullPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Full path not required to qualify Global ID. Deprecated in GitLab 14.5. |
| <a id="mutationdastsiteprofileupdateid"></a>`id` | [`DastSiteProfileID!`](#dastsiteprofileid) | ID of the site profile to be updated. |
| <a id="mutationdastsiteprofileupdateprofilename"></a>`profileName` | [`String!`](#string) | Name of the site profile. |
| <a id="mutationdastsiteprofileupdaterequestheaders"></a>`requestHeaders` | [`String`](#string) | Comma-separated list of request header names and values to be added to every request made by DAST. |
| <a id="mutationdastsiteprofileupdatescanfilepath"></a>`scanFilePath` | [`String`](#string) | File Path or URL used as input for the scan method. |
| <a id="mutationdastsiteprofileupdatescanmethod"></a>`scanMethod` | [`DastScanMethodType`](#dastscanmethodtype) | Scan method by the scanner. |
| <a id="mutationdastsiteprofileupdatetargettype"></a>`targetType` | [`DastTargetTypeEnum`](#dasttargettypeenum) | Type of target to be scanned. |
| <a id="mutationdastsiteprofileupdatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be scanned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsiteprofileupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsiteprofileupdatedastsiteprofile"></a>`dastSiteProfile` | [`DastSiteProfile`](#dastsiteprofile) | Site profile object. |
| <a id="mutationdastsiteprofileupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsiteprofileupdateid"></a>`id` **{warning-solid}** | [`DastSiteProfileID`](#dastsiteprofileid) | **Deprecated:** use `dastSiteProfile.id` field. Deprecated in GitLab 14.10. |

### `Mutation.dastSiteTokenCreate`

Input type: `DastSiteTokenCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitetokencreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site token belongs to. |
| <a id="mutationdastsitetokencreatetargeturl"></a>`targetUrl` | [`String`](#string) | URL of the target to be validated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitetokencreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitetokencreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsitetokencreateid"></a>`id` | [`DastSiteTokenID`](#dastsitetokenid) | ID of the site token. |
| <a id="mutationdastsitetokencreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | Current validation status of the target. |
| <a id="mutationdastsitetokencreatetoken"></a>`token` | [`String`](#string) | Token string. |

### `Mutation.dastSiteValidationCreate`

Input type: `DastSiteValidationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationcreatedastsitetokenid"></a>`dastSiteTokenId` | [`DastSiteTokenID!`](#dastsitetokenid) | ID of the site token. |
| <a id="mutationdastsitevalidationcreatefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site profile belongs to. |
| <a id="mutationdastsitevalidationcreatestrategy"></a>`strategy` | [`DastSiteValidationStrategyEnum`](#dastsitevalidationstrategyenum) | Validation strategy to be used. |
| <a id="mutationdastsitevalidationcreatevalidationpath"></a>`validationPath` | [`String!`](#string) | Path to be requested during validation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdastsitevalidationcreateid"></a>`id` | [`DastSiteValidationID`](#dastsitevalidationid) | ID of the site validation. |
| <a id="mutationdastsitevalidationcreatestatus"></a>`status` | [`DastSiteProfileValidationStatusEnum`](#dastsiteprofilevalidationstatusenum) | Current validation status. |

### `Mutation.dastSiteValidationRevoke`

Input type: `DastSiteValidationRevokeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationrevokefullpath"></a>`fullPath` | [`ID!`](#id) | Project the site validation belongs to. |
| <a id="mutationdastsitevalidationrevokenormalizedtargeturl"></a>`normalizedTargetUrl` | [`String!`](#string) | Normalized URL of the target to be revoked. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdastsitevalidationrevokeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdastsitevalidationrevokeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.deleteAnnotation`

DETAILS:
**Deprecated** in GitLab 16.0.
Underlying feature was removed in 16.0.

Input type: `DeleteAnnotationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteannotationid"></a>`id` | [`String!`](#string) | Global ID of the annotation to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeleteannotationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeleteannotationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.deleteContainerRegistryProtectionRule`

Deletes a container registry protection rule. Available only when feature flag `container_registry_protected_containers` is enabled.

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `DeleteContainerRegistryProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerregistryprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletecontainerregistryprotectionruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | Global ID of the container registry protection rule to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletecontainerregistryprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletecontainerregistryprotectionrulecontainerregistryprotectionrule"></a>`containerRegistryProtectionRule` | [`ContainerRegistryProtectionRule`](#containerregistryprotectionrule) | Container registry protection rule that was deleted successfully. |
| <a id="mutationdeletecontainerregistryprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.deletePackagesProtectionRule`

Deletes a protection rule for packages. Available only when feature flag `packages_protected_packages` is enabled.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `DeletePackagesProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | Global ID of the package protection rule to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdeletepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdeletepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdeletepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | Packages protection rule that was deleted successfully. |

### `Mutation.designManagementDelete`

Input type: `DesignManagementDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementdeletefilenames"></a>`filenames` | [`[String!]!`](#string) | Filenames of the designs to delete. |
| <a id="mutationdesignmanagementdeleteiid"></a>`iid` | [`ID!`](#id) | IID of the issue to modify designs for. |
| <a id="mutationdesignmanagementdeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Project where the issue is to upload designs for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdesignmanagementdeleteversion"></a>`version` | [`DesignVersion`](#designversion) | New version in which the designs are deleted. |

### `Mutation.designManagementMove`

Input type: `DesignManagementMoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementmoveid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | ID of the design to move. |
| <a id="mutationdesignmanagementmovenext"></a>`next` | [`DesignManagementDesignID`](#designmanagementdesignid) | ID of the immediately following design. |
| <a id="mutationdesignmanagementmoveprevious"></a>`previous` | [`DesignManagementDesignID`](#designmanagementdesignid) | ID of the immediately preceding design. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementmoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementmovedesigncollection"></a>`designCollection` | [`DesignCollection`](#designcollection) | Current state of the collection. |
| <a id="mutationdesignmanagementmoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.designManagementUpdate`

Input type: `DesignManagementUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementupdatedescription"></a>`description` | [`String`](#string) | Description of the design. |
| <a id="mutationdesignmanagementupdateid"></a>`id` | [`DesignManagementDesignID!`](#designmanagementdesignid) | ID of the design to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementupdatedesign"></a>`design` | [`Design!`](#design) | Updated design. |
| <a id="mutationdesignmanagementupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.designManagementUpload`

Input type: `DesignManagementUploadInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementuploadfiles"></a>`files` | [`[Upload!]!`](#upload) | Files to upload. |
| <a id="mutationdesignmanagementuploadiid"></a>`iid` | [`ID!`](#id) | IID of the issue to modify designs for. |
| <a id="mutationdesignmanagementuploadprojectpath"></a>`projectPath` | [`ID!`](#id) | Project where the issue is to upload designs for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdesignmanagementuploadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdesignmanagementuploaddesigns"></a>`designs` | [`[Design!]!`](#design) | Designs that were uploaded by the mutation. |
| <a id="mutationdesignmanagementuploaderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdesignmanagementuploadskippeddesigns"></a>`skippedDesigns` | [`[Design!]!`](#design) | Any designs that were skipped from the upload due to there being no change to their content since their last version. |

### `Mutation.destroyBoard`

Input type: `DestroyBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardid"></a>`id` | [`BoardID!`](#boardid) | Global ID of the board to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationdestroyboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyBoardList`

Input type: `DestroyBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardlistlistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list to destroy. Only label lists are accepted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdestroyboardlistlist"></a>`list` | [`BoardList`](#boardlist) | List after mutation. |

### `Mutation.destroyComplianceFramework`

Input type: `DestroyComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | Global ID of the compliance framework to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyContainerRepository`

Input type: `DestroyContainerRepositoryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositoryid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | ID of the container repository. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositoryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorycontainerrepository"></a>`containerRepository` | [`ContainerRepository!`](#containerrepository) | Container repository policy after scheduling the deletion. |
| <a id="mutationdestroycontainerrepositoryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyContainerRepositoryTags`

Input type: `DestroyContainerRepositoryTagsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorytagsid"></a>`id` | [`ContainerRepositoryID!`](#containerrepositoryid) | ID of the container repository. |
| <a id="mutationdestroycontainerrepositorytagstagnames"></a>`tagNames` | [`[String!]!`](#string) | Container repository tag(s) to delete. Total number can't be greater than 20. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycontainerrepositorytagsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycontainerrepositorytagsdeletedtagnames"></a>`deletedTagNames` | [`[String!]!`](#string) | Deleted container repository tags. |
| <a id="mutationdestroycontainerrepositorytagserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyCustomEmoji`

Input type: `DestroyCustomEmojiInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycustomemojiid"></a>`id` | [`CustomEmojiID!`](#customemojiid) | Global ID of the custom emoji to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroycustomemojiclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroycustomemojicustomemoji"></a>`customEmoji` | [`CustomEmoji`](#customemoji) | Deleted custom emoji. |
| <a id="mutationdestroycustomemojierrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyEpicBoard`

Input type: `DestroyEpicBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyepicboardid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroyepicboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroyepicboardepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Epic board after mutation. |
| <a id="mutationdestroyepicboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyNote`

Input type: `DestroyNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroynoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroynoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroynoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdestroynotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.destroyPackage`

Input type: `DestroyPackageInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageid"></a>`id` | [`PackagesPackageID!`](#packagespackageid) | ID of the Package. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyPackageFile`

Input type: `DestroyPackageFileInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileid"></a>`id` | [`PackagesPackageFileID!`](#packagespackagefileid) | ID of the Package file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefileclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyPackageFiles`

Input type: `DestroyPackageFilesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefilesids"></a>`ids` | [`[PackagesPackageFileID!]!`](#packagespackagefileid) | IDs of the Package file. |
| <a id="mutationdestroypackagefilesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the packages cleanup policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagefilesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagefileserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroyPackages`

Input type: `DestroyPackagesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackagesids"></a>`ids` | [`[PackagesPackageID!]!`](#packagespackageid) | Global IDs of the Packages. Max 20. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroypackagesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroypackageserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.destroySnippet`

Input type: `DestroySnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroysnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdestroysnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdestroysnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationdestroysnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.disableDevopsAdoptionNamespace`

**Status:** Beta.

Input type: `DisableDevopsAdoptionNamespaceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdisabledevopsadoptionnamespaceid"></a>`id` | [`[AnalyticsDevopsAdoptionEnabledNamespaceID!]!`](#analyticsdevopsadoptionenablednamespaceid) | One or many IDs of the enabled namespaces to disable. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdisabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdisabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.discussionToggleResolve`

Toggles the resolved state of a discussion.

Input type: `DiscussionToggleResolveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdiscussiontoggleresolveid"></a>`id` | [`DiscussionID!`](#discussionid) | Global ID of the discussion. |
| <a id="mutationdiscussiontoggleresolveresolve"></a>`resolve` | [`Boolean!`](#boolean) | Will resolve the discussion when true, and unresolve the discussion when false. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationdiscussiontoggleresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationdiscussiontoggleresolvediscussion"></a>`discussion` | [`Discussion`](#discussion) | Discussion after mutation. |
| <a id="mutationdiscussiontoggleresolveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.duoUserFeedback`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `DuoUserFeedbackInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | Global ID of the agent to answer the chat. |
| <a id="mutationduouserfeedbackaimessageid"></a>`aiMessageId` | [`String!`](#string) | ID of the AI Message. |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationduouserfeedbacktrackingevent"></a>`trackingEvent` | [`TrackingEventInput`](#trackingeventinput) | Tracking event data. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationduouserfeedbackclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationduouserfeedbackerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.echoCreate`

A mutation that does not perform any changes.

This is expected to be used for testing of endpoints, to verify
that a user has mutation access.

Input type: `EchoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]`](#string) | Errors to return to the user. |
| <a id="mutationechocreatemessages"></a>`messages` | [`[String!]`](#string) | Messages to return to the user. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationechocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationechocreateechoes"></a>`echoes` | [`[String!]`](#string) | Messages returned to the user. |
| <a id="mutationechocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.enableDevopsAdoptionNamespace`

**Status:** Beta.

Input type: `EnableDevopsAdoptionNamespaceInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenabledevopsadoptionnamespacedisplaynamespaceid"></a>`displayNamespaceId` | [`NamespaceID`](#namespaceid) | Display namespace ID. |
| <a id="mutationenabledevopsadoptionnamespacenamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | Namespace ID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenabledevopsadoptionnamespaceclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenabledevopsadoptionnamespaceenablednamespace"></a>`enabledNamespace` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | Enabled namespace after mutation. |
| <a id="mutationenabledevopsadoptionnamespaceerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentCreate`

Create an environment.

Input type: `EnvironmentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentcreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | Cluster agent of the environment. |
| <a id="mutationenvironmentcreateexternalurl"></a>`externalUrl` | [`String`](#string) | External URL of the environment. |
| <a id="mutationenvironmentcreatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | Flux resource path of the environment. |
| <a id="mutationenvironmentcreatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | Kubernetes namespace of the environment. |
| <a id="mutationenvironmentcreatename"></a>`name` | [`String!`](#string) | Name of the environment. |
| <a id="mutationenvironmentcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |
| <a id="mutationenvironmentcreatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | Tier of the environment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentcreateenvironment"></a>`environment` | [`Environment`](#environment) | Created environment. |
| <a id="mutationenvironmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentDelete`

Delete an environment.

Input type: `EnvironmentDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentdeleteid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to Delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentStop`

Stop an environment.

Input type: `EnvironmentStopInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentstopforce"></a>`force` | [`Boolean`](#boolean) | Force environment to stop without executing on_stop actions. |
| <a id="mutationenvironmentstopid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to stop. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentstopclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentstopenvironment"></a>`environment` | [`Environment`](#environment) | Environment after attempt to stop. |
| <a id="mutationenvironmentstoperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentUpdate`

Update an environment.

Input type: `EnvironmentUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentupdateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID`](#clustersagentid) | Cluster agent of the environment. |
| <a id="mutationenvironmentupdateexternalurl"></a>`externalUrl` | [`String`](#string) | External URL of the environment. |
| <a id="mutationenvironmentupdatefluxresourcepath"></a>`fluxResourcePath` | [`String`](#string) | Flux resource path of the environment. |
| <a id="mutationenvironmentupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to update. |
| <a id="mutationenvironmentupdatekubernetesnamespace"></a>`kubernetesNamespace` | [`String`](#string) | Kubernetes namespace of the environment. |
| <a id="mutationenvironmentupdatetier"></a>`tier` | [`DeploymentTier`](#deploymenttier) | Tier of the environment. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentupdateenvironment"></a>`environment` | [`Environment`](#environment) | Environment after attempt to update. |
| <a id="mutationenvironmentupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.environmentsCanaryIngressUpdate`

**Deprecated** This endpoint is planned to be removed along with certificate-based clusters. [See this epic](https://gitlab.com/groups/gitlab-org/configure/-/epics/8) for more information.

Input type: `EnvironmentsCanaryIngressUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentscanaryingressupdateid"></a>`id` | [`EnvironmentID!`](#environmentid) | Global ID of the environment to update. |
| <a id="mutationenvironmentscanaryingressupdateweight"></a>`weight` | [`Int!`](#int) | Weight of the Canary Ingress. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationenvironmentscanaryingressupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationenvironmentscanaryingressupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicAddIssue`

Input type: `EpicAddIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicaddissuegrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate belongs to. |
| <a id="mutationepicaddissueiid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationepicaddissueissueiid"></a>`issueIid` | [`String!`](#string) | IID of the issue to be added. |
| <a id="mutationepicaddissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the issue belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicaddissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicaddissueepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicaddissueepicissue"></a>`epicIssue` | [`EpicIssue`](#epicissue) | Epic-issue relationship. |
| <a id="mutationepicaddissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicBoardCreate`

Input type: `EpicBoardCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardcreatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | Whether or not display epic colors. Ignored unless `epic_color_highlight` flag is enabled. |
| <a id="mutationepicboardcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationepicboardcreatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationepicboardcreatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationepicboardcreatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationepicboardcreatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationepicboardcreatename"></a>`name` | [`String`](#string) | Board name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardcreateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Created epic board. |
| <a id="mutationepicboardcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicBoardListCreate`

Input type: `EpicBoardListCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreatebacklog"></a>`backlog` | [`Boolean`](#boolean) | Create the backlog list. |
| <a id="mutationepicboardlistcreateboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the issue board to mutate. |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistcreatelabelid"></a>`labelId` | [`LabelID`](#labelid) | Global ID of an existing label. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationepicboardlistcreatelist"></a>`list` | [`EpicList`](#epiclist) | Epic list in the epic board. |

### `Mutation.epicBoardListDestroy`

Destroys an epic board list.

Input type: `EpicBoardListDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistdestroylistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic board list to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardlistdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardlistdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationepicboardlistdestroylist"></a>`list` | [`EpicList`](#epiclist) | Epic board list. `null` if the board was destroyed successfully. |

### `Mutation.epicBoardUpdate`

Input type: `EpicBoardUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardupdatedisplaycolors"></a>`displayColors` | [`Boolean`](#boolean) | Whether or not display epic colors. Ignored unless `epic_color_highlight` flag is enabled. |
| <a id="mutationepicboardupdatehidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationepicboardupdatehideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationepicboardupdateid"></a>`id` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Epic board global ID. |
| <a id="mutationepicboardupdatelabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationepicboardupdatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationepicboardupdatename"></a>`name` | [`String`](#string) | Board name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicboardupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicboardupdateepicboard"></a>`epicBoard` | [`EpicBoard`](#epicboard) | Updated epic board. |
| <a id="mutationepicboardupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicMoveList`

Input type: `EpicMoveListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistboardid"></a>`boardId` | [`BoardsEpicBoardID!`](#boardsepicboardid) | Global ID of the board that the epic is in. |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicmovelistepicid"></a>`epicId` | [`EpicID!`](#epicid) | ID of the epic to mutate. |
| <a id="mutationepicmovelistfromlistid"></a>`fromListId` | [`BoardsEpicListID`](#boardsepiclistid) | ID of the board list that the epic will be moved from. Required if moving between lists. |
| <a id="mutationepicmovelistmoveafterid"></a>`moveAfterId` | [`EpicID`](#epicid) | ID of epic that should be placed after the current epic. |
| <a id="mutationepicmovelistmovebeforeid"></a>`moveBeforeId` | [`EpicID`](#epicid) | ID of epic that should be placed before the current epic. |
| <a id="mutationepicmovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | Position of epics within the board list. Positions start at 0. Use -1 to move to the end of the list. |
| <a id="mutationepicmovelisttolistid"></a>`toListId` | [`BoardsEpicListID!`](#boardsepiclistid) | ID of the list the epic will be in after mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicmovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicmovelistepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicmovelisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicSetSubscription`

Input type: `EpicSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicsetsubscriptiongrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate belongs to. |
| <a id="mutationepicsetsubscriptioniid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationepicsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepicsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepicsetsubscriptionepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationepicsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.epicTreeReorder`

Input type: `EpicTreeReorderInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderbaseepicid"></a>`baseEpicId` | [`EpicID!`](#epicid) | ID of the base epic of the tree. |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepictreereordermoved"></a>`moved` | [`EpicTreeNodeFieldsInputType!`](#epictreenodefieldsinputtype) | Parameters for updating the tree positions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationepictreereorderclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationepictreereordererrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.escalationPolicyCreate`

Input type: `EscalationPolicyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicycreatedescription"></a>`description` | [`String`](#string) | Description of the escalation policy. |
| <a id="mutationescalationpolicycreatename"></a>`name` | [`String!`](#string) | Name of the escalation policy. |
| <a id="mutationescalationpolicycreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the escalation policy for. |
| <a id="mutationescalationpolicycreaterules"></a>`rules` | [`[EscalationRuleInput!]!`](#escalationruleinput) | Steps of the escalation policy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationescalationpolicycreateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.escalationPolicyDestroy`

Input type: `EscalationPolicyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicydestroyid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | Escalation policy internal ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationescalationpolicydestroyescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.escalationPolicyUpdate`

Input type: `EscalationPolicyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicyupdatedescription"></a>`description` | [`String`](#string) | Description of the escalation policy. |
| <a id="mutationescalationpolicyupdateid"></a>`id` | [`IncidentManagementEscalationPolicyID!`](#incidentmanagementescalationpolicyid) | ID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationescalationpolicyupdatename"></a>`name` | [`String`](#string) | Name of the escalation policy. |
| <a id="mutationescalationpolicyupdaterules"></a>`rules` | [`[EscalationRuleInput!]`](#escalationruleinput) | Steps of the escalation policy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationescalationpolicyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationescalationpolicyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationescalationpolicyupdateescalationpolicy"></a>`escalationPolicy` | [`EscalationPolicyType`](#escalationpolicytype) | Escalation policy. |

### `Mutation.exportRequirements`

Input type: `ExportRequirementsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsauthorusername"></a>`authorUsername` | [`[String!]`](#string) | Filter requirements by author username. |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexportrequirementsprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirements are associated with. |
| <a id="mutationexportrequirementssearch"></a>`search` | [`String`](#string) | Search query for requirement title. |
| <a id="mutationexportrequirementsselectedfields"></a>`selectedFields` | [`[String!]`](#string) | List of selected requirements fields to be exported. |
| <a id="mutationexportrequirementssort"></a>`sort` | [`Sort`](#sort) | List requirements by sort order. |
| <a id="mutationexportrequirementsstate"></a>`state` | [`RequirementState`](#requirementstate) | Filter requirements by state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexportrequirementsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexportrequirementserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.externalAuditEventDestinationCreate`

Input type: `ExternalAuditEventDestinationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | Destination URL. |
| <a id="mutationexternalauditeventdestinationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationexternalauditeventdestinationcreateverificationtoken"></a>`verificationToken` | [`String`](#string) | Verification token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationexternalauditeventdestinationcreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | Destination created. |

### `Mutation.externalAuditEventDestinationDestroy`

Input type: `ExternalAuditEventDestinationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ID of external audit event destination to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.externalAuditEventDestinationUpdate`

Input type: `ExternalAuditEventDestinationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | Destination URL to change. |
| <a id="mutationexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsExternalAuditEventDestinationID!`](#auditeventsexternalauditeventdestinationid) | ID of external audit event destination to update. |
| <a id="mutationexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | Destination name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationexternalauditeventdestinationupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | Updated destination. |

### `Mutation.geoRegistriesBulkUpdate`

Mutates multiple Geo registries for a given registry class.

DETAILS:
**Introduced** in GitLab 16.4.
**Status**: Experiment.

Input type: `GeoRegistriesBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateaction"></a>`action` | [`GeoRegistriesBulkAction!`](#georegistriesbulkaction) | Action to be executed on Geo registries. |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass!`](#georegistryclass) | Class of the Geo registries to be updated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgeoregistriesbulkupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass`](#georegistryclass) | Updated Geo registry class. |

### `Mutation.geoRegistriesUpdate`

Mutates a Geo registry.

DETAILS:
**Introduced** in GitLab 16.1.
**Status**: Experiment.

Input type: `GeoRegistriesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateaction"></a>`action` | [`GeoRegistryAction!`](#georegistryaction) | Action to be executed on a Geo registry. |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesupdateregistryclass"></a>`registryClass` | [`GeoRegistryClass`](#georegistryclass) | Class of the Geo registry to be updated. |
| <a id="mutationgeoregistriesupdateregistryid"></a>`registryId` | [`GeoBaseRegistryID!`](#geobaseregistryid) | ID of the Geo registry entry to be updated. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgeoregistriesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgeoregistriesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgeoregistriesupdateregistry"></a>`registry` | [`Registrable`](#registrable) | Updated Geo registry entry. |

### `Mutation.gitlabSubscriptionActivate`

Input type: `GitlabSubscriptionActivateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateactivationcode"></a>`activationCode` | [`String!`](#string) | Activation code received after purchasing a GitLab subscription. |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgitlabsubscriptionactivateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgitlabsubscriptionactivateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgitlabsubscriptionactivatefuturesubscriptions"></a>`futureSubscriptions` | [`[SubscriptionFutureEntry!]`](#subscriptionfutureentry) | Array of future subscriptions. |
| <a id="mutationgitlabsubscriptionactivatelicense"></a>`license` | [`CurrentLicense`](#currentlicense) | Current license. |

### `Mutation.googleCloudLoggingConfigurationCreate`

Input type: `GoogleCloudLoggingConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationgooglecloudloggingconfigurationcreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationgooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project.(defaults to `audit_events`). |
| <a id="mutationgooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgooglecloudloggingconfigurationcreategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | configuration created. |

### `Mutation.googleCloudLoggingConfigurationDestroy`

Input type: `GoogleCloudLoggingConfigurationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | ID of the Google Cloud logging configuration to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.googleCloudLoggingConfigurationUpdate`

Input type: `GoogleCloudLoggingConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationgooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsGoogleCloudLoggingConfigurationID!`](#auditeventsgooglecloudloggingconfigurationid) | ID of the google Cloud configuration to update. |
| <a id="mutationgooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project. |
| <a id="mutationgooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgooglecloudloggingconfigurationupdategooglecloudloggingconfiguration"></a>`googleCloudLoggingConfiguration` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | configuration updated. |

### `Mutation.groupAuditEventStreamingDestinationsCreate`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `GroupAuditEventStreamingDestinationsCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | Destination category. |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | Destination config. |
| <a id="mutationgroupauditeventstreamingdestinationscreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |
| <a id="mutationgroupauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgroupauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String!`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | Destination created. |

### `Mutation.groupAuditEventStreamingDestinationsDelete`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `GroupAuditEventStreamingDestinationsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | ID of the audit events external streaming destination to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.groupAuditEventStreamingDestinationsUpdate`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `GroupAuditEventStreamingDestinationsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | Destination category. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | Destination config. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsGroupExternalStreamingDestinationID!`](#auditeventsgroupexternalstreamingdestinationid) | ID of external audit event destination to update. |
| <a id="mutationgroupauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationgroupauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | Updated destination. |

### `Mutation.groupMemberBulkUpdate`

Input type: `GroupMemberBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | Access level to update the members to. |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | Date and time the membership expires. |
| <a id="mutationgroupmemberbulkupdategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Global ID of the group. |
| <a id="mutationgroupmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of the members. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupmemberbulkupdategroupmembers"></a>`groupMembers` | [`[GroupMember!]`](#groupmember) | Group members after mutation. |

### `Mutation.groupSavedReplyCreate`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `GroupSavedReplyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplycreatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationgroupsavedreplycreategroupid"></a>`groupId` | [`GroupID!`](#groupid) | Group for the save reply. |
| <a id="mutationgroupsavedreplycreatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupsavedreplycreatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | Saved reply after mutation. |

### `Mutation.groupSavedReplyDestroy`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `GroupSavedReplyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplydestroyid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | Global ID of the group-level saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupsavedreplydestroysavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | Saved reply after mutation. |

### `Mutation.groupSavedReplyUpdate`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `GroupSavedReplyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationgroupsavedreplyupdateid"></a>`id` | [`GroupsSavedReplyID!`](#groupssavedreplyid) | Global ID of the group-level saved reply. |
| <a id="mutationgroupsavedreplyupdatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupsavedreplyupdatesavedreply"></a>`savedReply` | [`GroupSavedReply`](#groupsavedreply) | Saved reply after mutation. |

### `Mutation.groupUpdate`

Input type: `GroupUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean`](#boolean) | Indicates whether GitLab Duo features are enabled for the group. Introduced in GitLab 16.10: **Status**: Experiment. |
| <a id="mutationgroupupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the group that will be updated. |
| <a id="mutationgroupupdatelockduofeaturesenabled"></a>`lockDuoFeaturesEnabled` | [`Boolean`](#boolean) | Indicates if the GitLab Duo features enabled setting is enforced for all subgroups. Introduced in GitLab 16.10: **Status**: Experiment. |
| <a id="mutationgroupupdatelockmathrenderinglimitsenabled"></a>`lockMathRenderingLimitsEnabled` | [`Boolean`](#boolean) | Indicates if math rendering limits are locked for all descendant groups. |
| <a id="mutationgroupupdatemathrenderinglimitsenabled"></a>`mathRenderingLimitsEnabled` | [`Boolean`](#boolean) | Indicates if math rendering limits are used for this group. |
| <a id="mutationgroupupdatesharedrunnerssetting"></a>`sharedRunnersSetting` | [`SharedRunnersSetting`](#sharedrunnerssetting) | Shared runners availability for the namespace and its descendants. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationgroupupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationgroupupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationgroupupdategroup"></a>`group` | [`Group`](#group) | Group after update. |

### `Mutation.httpIntegrationCreate`

Input type: `HttpIntegrationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationcreatename"></a>`name` | [`String!`](#string) | Name of the integration. |
| <a id="mutationhttpintegrationcreatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationhttpintegrationcreatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |
| <a id="mutationhttpintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the integration in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationcreateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.httpIntegrationDestroy`

Input type: `HttpIntegrationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationdestroyid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationdestroyintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.httpIntegrationResetToken`

Input type: `HttpIntegrationResetTokenInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationresettokenid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationresettokenintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.httpIntegrationUpdate`

Input type: `HttpIntegrationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationupdateid"></a>`id` | [`AlertManagementHttpIntegrationID!`](#alertmanagementhttpintegrationid) | ID of the integration to mutate. |
| <a id="mutationhttpintegrationupdatename"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="mutationhttpintegrationupdatepayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertFieldInput!]`](#alertmanagementpayloadalertfieldinput) | Custom mapping of GitLab alert attributes to fields from the payload example. |
| <a id="mutationhttpintegrationupdatepayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationhttpintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationhttpintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationhttpintegrationupdateintegration"></a>`integration` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | HTTP integration. |

### `Mutation.instanceAuditEventStreamingDestinationsCreate`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `InstanceAuditEventStreamingDestinationsCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreatecategory"></a>`category` | [`String!`](#string) | Destination category. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateconfig"></a>`config` | [`JSON!`](#json) | Destination config. |
| <a id="mutationinstanceauditeventstreamingdestinationscreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstanceauditeventstreamingdestinationscreatesecrettoken"></a>`secretToken` | [`String!`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationscreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationscreateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | Destination created. |

### `Mutation.instanceAuditEventStreamingDestinationsDelete`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `InstanceAuditEventStreamingDestinationsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | ID of the audit events external streaming destination to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.instanceAuditEventStreamingDestinationsUpdate`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `InstanceAuditEventStreamingDestinationsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatecategory"></a>`category` | [`String`](#string) | Destination category. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateconfig"></a>`config` | [`JSON`](#json) | Destination config. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateid"></a>`id` | [`AuditEventsInstanceExternalStreamingDestinationID!`](#auditeventsinstanceexternalstreamingdestinationid) | ID of external audit event destination to update. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdatesecrettoken"></a>`secretToken` | [`String`](#string) | Secret token. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstanceauditeventstreamingdestinationsupdateexternalauditeventdestination"></a>`externalAuditEventDestination` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | Updated destination. |

### `Mutation.instanceExternalAuditEventDestinationCreate`

Input type: `InstanceExternalAuditEventDestinationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreatedestinationurl"></a>`destinationUrl` | [`String!`](#string) | Destination URL. |
| <a id="mutationinstanceexternalauditeventdestinationcreatename"></a>`name` | [`String`](#string) | Destination name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationcreateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | Destination created. |

### `Mutation.instanceExternalAuditEventDestinationDestroy`

Input type: `InstanceExternalAuditEventDestinationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationdestroyid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ID of the external instance audit event destination to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.instanceExternalAuditEventDestinationUpdate`

Input type: `InstanceExternalAuditEventDestinationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdatedestinationurl"></a>`destinationUrl` | [`String`](#string) | Destination URL to change. |
| <a id="mutationinstanceexternalauditeventdestinationupdateid"></a>`id` | [`AuditEventsInstanceExternalAuditEventDestinationID!`](#auditeventsinstanceexternalauditeventdestinationid) | ID of the external instance audit event destination to update. |
| <a id="mutationinstanceexternalauditeventdestinationupdatename"></a>`name` | [`String`](#string) | Destination name. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstanceexternalauditeventdestinationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstanceexternalauditeventdestinationupdateinstanceexternalauditeventdestination"></a>`instanceExternalAuditEventDestination` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | Updated destination. |

### `Mutation.instanceGoogleCloudLoggingConfigurationCreate`

Input type: `InstanceGoogleCloudLoggingConfigurationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientemail"></a>`clientEmail` | [`String!`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreategoogleprojectidname"></a>`googleProjectIdName` | [`String!`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project.(defaults to `audit_events`). |
| <a id="mutationinstancegooglecloudloggingconfigurationcreatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateprivatekey"></a>`privateKey` | [`String!`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationcreateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | configuration created. |

### `Mutation.instanceGoogleCloudLoggingConfigurationDestroy`

Input type: `InstanceGoogleCloudLoggingConfigurationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | ID of the Google Cloud logging configuration to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.instanceGoogleCloudLoggingConfigurationUpdate`

Input type: `InstanceGoogleCloudLoggingConfigurationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientemail"></a>`clientEmail` | [`String`](#string) | Email address associated with the service account that will be used to authenticate and interact with the Google Cloud Logging service. This is part of the IAM credentials. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdategoogleprojectidname"></a>`googleProjectIdName` | [`String`](#string) | Unique identifier of the Google Cloud project to which the logging configuration belongs. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateid"></a>`id` | [`AuditEventsInstanceGoogleCloudLoggingConfigurationID!`](#auditeventsinstancegooglecloudloggingconfigurationid) | ID of the instance google Cloud configuration to update. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatelogidname"></a>`logIdName` | [`String`](#string) | Unique identifier used to distinguish and manage different logs within the same Google Cloud project. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdatename"></a>`name` | [`String`](#string) | Destination name. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateprivatekey"></a>`privateKey` | [`String`](#string) | Private Key associated with the service account. This key is used to authenticate the service account and authorize it to interact with the Google Cloud Logging service. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationinstancegooglecloudloggingconfigurationupdateinstancegooglecloudloggingconfiguration"></a>`instanceGoogleCloudLoggingConfiguration` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | configuration updated. |

### `Mutation.integrationExclusionCreate`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `IntegrationExclusionCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusioncreateintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | Type of integration to exclude. |
| <a id="mutationintegrationexclusioncreateprojectids"></a>`projectIds` | [`[ProjectID!]!`](#projectid) | IDs of projects to exclude up to a maximum of 100. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusioncreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationintegrationexclusioncreateexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | Integration exclusions created by the mutation. |

### `Mutation.integrationExclusionDelete`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `IntegrationExclusionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusiondeleteintegrationname"></a>`integrationName` | [`IntegrationType!`](#integrationtype) | Type of integration. |
| <a id="mutationintegrationexclusiondeleteprojectids"></a>`projectIds` | [`[ProjectID!]!`](#projectid) | IDs of excluded projects. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationintegrationexclusiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationintegrationexclusiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationintegrationexclusiondeleteexclusions"></a>`exclusions` | [`[IntegrationExclusion!]`](#integrationexclusion) | Project no longer excluded due to the mutation. |

### `Mutation.issuableResourceLinkCreate`

Input type: `IssuableResourceLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkcreateid"></a>`id` | [`IssueID!`](#issueid) | Incident id to associate the resource link with. |
| <a id="mutationissuableresourcelinkcreatelink"></a>`link` | [`String!`](#string) | Link of the resource. |
| <a id="mutationissuableresourcelinkcreatelinktext"></a>`linkText` | [`String`](#string) | Link text of the resource. |
| <a id="mutationissuableresourcelinkcreatelinktype"></a>`linkType` | [`IssuableResourceLinkType`](#issuableresourcelinktype) | Link type of the resource. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuableresourcelinkcreateissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | Issuable resource link. |

### `Mutation.issuableResourceLinkDestroy`

Input type: `IssuableResourceLinkDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkdestroyid"></a>`id` | [`IncidentManagementIssuableResourceLinkID!`](#incidentmanagementissuableresourcelinkid) | Issuable resource link ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuableresourcelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuableresourcelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuableresourcelinkdestroyissuableresourcelink"></a>`issuableResourceLink` | [`IssuableResourceLink`](#issuableresourcelink) | Issuable resource link. |

### `Mutation.issueLinkAlerts`

Input type: `IssueLinkAlertsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsalertreferences"></a>`alertReferences` | [`[String!]!`](#string) | Alerts references to be linked to the incident. |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuelinkalertsiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuelinkalertsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuelinkalertsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuelinkalertserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuelinkalertsissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueMove`

Input type: `IssueMoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemoveiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuemoveprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuemovetargetprojectpath"></a>`targetProjectPath` | [`ID!`](#id) | Project to move the issue to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuemoveissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueMoveList`

Input type: `IssueMoveListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistboardid"></a>`boardId` | [`BoardID!`](#boardid) | Global ID of the board that the issue is in. |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemovelistepicid"></a>`epicId` | [`EpicID`](#epicid) | ID of the parent epic. NULL when removing the association. |
| <a id="mutationissuemovelistfromlistid"></a>`fromListId` | [`ID`](#id) | ID of the board list that the issue will be moved from. |
| <a id="mutationissuemovelistiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuemovelistmoveafterid"></a>`moveAfterId` | [`ID`](#id) | ID of issue that should be placed after the current issue. |
| <a id="mutationissuemovelistmovebeforeid"></a>`moveBeforeId` | [`ID`](#id) | ID of issue that should be placed before the current issue. |
| <a id="mutationissuemovelistpositioninlist"></a>`positionInList` | [`Int`](#int) | Position of issue within the board list. Positions start at 0. Use -1 to move to the end of the list. |
| <a id="mutationissuemovelistprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuemovelisttolistid"></a>`toListId` | [`ID`](#id) | ID of the board list that the issue will be moved to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuemovelistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuemovelisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuemovelistissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetAssignees`

Input type: `IssueSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the resource. Replaces existing assignees by default. |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationissuesetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetassigneesissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetConfidential`

Input type: `IssueSetConfidentialInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetconfidentialconfidential"></a>`confidential` | [`Boolean!`](#boolean) | Whether or not to set the issue as a confidential. |
| <a id="mutationissuesetconfidentialiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetconfidentialprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetconfidentialclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetconfidentialerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetconfidentialissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetCrmContacts`

Input type: `IssueSetCrmContactsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetcrmcontactscontactids"></a>`contactIds` | [`[CustomerRelationsContactID!]!`](#customerrelationscontactid) | Customer relations contact IDs to set. Replaces existing contacts by default. |
| <a id="mutationissuesetcrmcontactsiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetcrmcontactsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Changes the operation mode. Defaults to REPLACE. |
| <a id="mutationissuesetcrmcontactsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetcrmcontactsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetcrmcontactserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetcrmcontactsissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetDueDate`

Input type: `IssueSetDueDateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetduedateduedate"></a>`dueDate` | [`Time`](#time) | Desired due date for the issue. Due date is removed if null. |
| <a id="mutationissuesetduedateiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetduedateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetduedateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetduedateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetduedateissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEpic`

Input type: `IssueSetEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetepicepicid"></a>`epicId` | [`EpicID`](#epicid) | Global ID of the epic to be assigned to the issue, epic will be removed if absent or set to null. |
| <a id="mutationissuesetepiciid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetepicprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetepicissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEscalationPolicy`

Input type: `IssueSetEscalationPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationpolicyescalationpolicyid"></a>`escalationPolicyId` | [`IncidentManagementEscalationPolicyID`](#incidentmanagementescalationpolicyid) | Global ID of the escalation policy to assign to the issue. Policy will be removed if absent or set to null. |
| <a id="mutationissuesetescalationpolicyiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetescalationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetescalationpolicyissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetEscalationStatus`

Input type: `IssueSetEscalationStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationstatusiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetescalationstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetescalationstatusstatus"></a>`status` | [`IssueEscalationStatus!`](#issueescalationstatus) | Set the escalation status. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetescalationstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetescalationstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetescalationstatusissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetIteration`

Input type: `IssueSetIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetiterationiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetiterationiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Iteration to assign to the issue. |
| <a id="mutationissuesetiterationprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetiterationissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetLocked`

Input type: `IssueSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetlockediid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | Whether or not to lock discussion on the issue. |
| <a id="mutationissuesetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetlockedissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetSeverity`

Input type: `IssueSetSeverityInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetseverityiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetseverityprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetseverityseverity"></a>`severity` | [`IssuableSeverity!`](#issuableseverity) | Set the incident severity level. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetseverityclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetseverityerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetseverityissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetSubscription`

Input type: `IssueSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetsubscriptioniid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetsubscriptionissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueSetWeight`

Input type: `IssueSetWeightInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetweightiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissuesetweightprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationissuesetweightweight"></a>`weight` | [`Int`](#int) | The desired weight for the issue. If set to null, weight is removed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesetweightclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesetweighterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesetweightissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issueUnlinkAlert`

Input type: `IssueUnlinkAlertInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertalertid"></a>`alertId` | [`AlertManagementAlertID!`](#alertmanagementalertid) | Global ID of the alert to unlink from the incident. |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissueunlinkalertiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationissueunlinkalertprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissueunlinkalertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissueunlinkalerterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissueunlinkalertissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.issuesBulkUpdate`

Allows updating several properties for a set of issues. Does nothing if the `bulk_update_issues_mutation` feature flag is disabled.

DETAILS:
**Introduced** in GitLab 15.9.
**Status**: Experiment.

Input type: `IssuesBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesbulkupdateaddlabelids"></a>`addLabelIds` | [`[LabelID!]`](#labelid) | Global ID array of the labels that will be added to the issues. |
| <a id="mutationissuesbulkupdateassigneeids"></a>`assigneeIds` | [`[UserID!]`](#userid) | Global ID array of the users that will be assigned to the given issues. Existing assignees will be replaced with the ones on this list. |
| <a id="mutationissuesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesbulkupdateepicid"></a>`epicId` | [`EpicID`](#epicid) | Global ID of the epic that will be assigned to the issues. |
| <a id="mutationissuesbulkupdatehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Health status that will be assigned to the issues. |
| <a id="mutationissuesbulkupdateids"></a>`ids` | [`[IssueID!]!`](#issueid) | Global ID array of the issues that will be updated. IDs that the user can't update will be ignored. A max of 100 can be provided. |
| <a id="mutationissuesbulkupdateiterationid"></a>`iterationId` | [`IterationID`](#iterationid) | Global ID of the iteration that will be assigned to the issues. |
| <a id="mutationissuesbulkupdatemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Global ID of the milestone that will be assigned to the issues. |
| <a id="mutationissuesbulkupdateparentid"></a>`parentId` | [`IssueParentID!`](#issueparentid) | Global ID of the parent to which the bulk update will be scoped. The parent can be a project. The parent can also be a group (Premium and Ultimate only). Example `IssueParentID` are `"gid://gitlab/Project/1"` and `"gid://gitlab/Group/1"`. |
| <a id="mutationissuesbulkupdateremovelabelids"></a>`removeLabelIds` | [`[LabelID!]`](#labelid) | Global ID array of the labels that will be removed from the issues. |
| <a id="mutationissuesbulkupdatestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | Close or reopen an issue. |
| <a id="mutationissuesbulkupdatesubscriptionevent"></a>`subscriptionEvent` | [`IssuableSubscriptionEvent`](#issuablesubscriptionevent) | Subscribe to or unsubscribe from issue notifications. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationissuesbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationissuesbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationissuesbulkupdateupdatedissuecount"></a>`updatedIssueCount` | [`Int`](#int) | Number of issues that were successfully updated. |

### `Mutation.iterationCadenceCreate`

Input type: `IterationCadenceCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the iteration cadence is active. |
| <a id="mutationiterationcadencecreateautomatic"></a>`automatic` | [`Boolean!`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencecreatedescription"></a>`description` | [`String`](#string) | Description of the iteration cadence. Maximum length is 5000 characters. |
| <a id="mutationiterationcadencecreatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within this cadence. |
| <a id="mutationiterationcadencecreategrouppath"></a>`groupPath` | [`ID!`](#id) | Group where the iteration cadence is created. |
| <a id="mutationiterationcadencecreateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | Upcoming iterations to be created when iteration cadence is set to automatic. |
| <a id="mutationiterationcadencecreaterollover"></a>`rollOver` | [`Boolean`](#boolean) | Whether the iteration cadence should roll over issues to the next iteration or not. |
| <a id="mutationiterationcadencecreatestartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the automation start date. |
| <a id="mutationiterationcadencecreatetitle"></a>`title` | [`String`](#string) | Title of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcadencecreateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Created iteration cadence. |

### `Mutation.iterationCadenceDestroy`

Input type: `IterationCadenceDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencedestroyid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | Global ID of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadencedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadencedestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcadencedestroygroup"></a>`group` | [`Group!`](#group) | Group the iteration cadence belongs to. |

### `Mutation.iterationCadenceUpdate`

Input type: `IterationCadenceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the iteration cadence is active. |
| <a id="mutationiterationcadenceupdateautomatic"></a>`automatic` | [`Boolean`](#boolean) | Whether the iteration cadence should automatically generate upcoming iterations. |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadenceupdatedescription"></a>`description` | [`String`](#string) | Description of the iteration cadence. Maximum length is 5000 characters. |
| <a id="mutationiterationcadenceupdatedurationinweeks"></a>`durationInWeeks` | [`Int`](#int) | Duration in weeks of the iterations within this cadence. |
| <a id="mutationiterationcadenceupdateid"></a>`id` | [`IterationsCadenceID!`](#iterationscadenceid) | Global ID of the iteration cadence. |
| <a id="mutationiterationcadenceupdateiterationsinadvance"></a>`iterationsInAdvance` | [`Int`](#int) | Upcoming iterations to be created when iteration cadence is set to automatic. |
| <a id="mutationiterationcadenceupdaterollover"></a>`rollOver` | [`Boolean`](#boolean) | Whether the iteration cadence should roll over issues to the next iteration or not. |
| <a id="mutationiterationcadenceupdatestartdate"></a>`startDate` | [`Time`](#time) | Timestamp of the automation start date. |
| <a id="mutationiterationcadenceupdatetitle"></a>`title` | [`String`](#string) | Title of the iteration cadence. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcadenceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcadenceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcadenceupdateiterationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Updated iteration cadence. |

### `Mutation.iterationCreate`

Input type: `iterationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcreatedescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationiterationcreateduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationiterationcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationiterationcreateiterationscadenceid"></a>`iterationsCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | Global ID of the iteration cadence to be assigned to the new iteration. |
| <a id="mutationiterationcreateprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationiterationcreatestartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationiterationcreatetitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationcreateiteration"></a>`iteration` | [`Iteration`](#iteration) | Created iteration. |

### `Mutation.iterationDelete`

Input type: `IterationDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationdeleteid"></a>`id` | [`IterationID!`](#iterationid) | ID of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationiterationdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationiterationdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationiterationdeletegroup"></a>`group` | [`Group!`](#group) | Group the iteration belongs to. |

### `Mutation.jiraImportStart`

Input type: `JiraImportStartInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportstartjiraprojectkey"></a>`jiraProjectKey` | [`String!`](#string) | Project key of the importer Jira project. |
| <a id="mutationjiraimportstartjiraprojectname"></a>`jiraProjectName` | [`String`](#string) | Project name of the importer Jira project. |
| <a id="mutationjiraimportstartprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to import the Jira project into. |
| <a id="mutationjiraimportstartusersmapping"></a>`usersMapping` | [`[JiraUsersMappingInputType!]`](#jirausersmappinginputtype) | Mapping of Jira to GitLab users. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportstartclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportstarterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjiraimportstartjiraimport"></a>`jiraImport` | [`JiraImport`](#jiraimport) | Jira import data after mutation. |

### `Mutation.jiraImportUsers`

Input type: `JiraImportUsersInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportusersprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to import the Jira users into. |
| <a id="mutationjiraimportusersstartat"></a>`startAt` | [`Int`](#int) | Index of the record the import should started at, default 0 (50 records returned). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjiraimportusersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjiraimportuserserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjiraimportusersjirausers"></a>`jiraUsers` | [`[JiraUser!]`](#jirauser) | Users returned from Jira, matched by email and name if possible. |

### `Mutation.jobArtifactsDestroy`

Input type: `JobArtifactsDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobartifactsdestroyid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobartifactsdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobartifactsdestroydestroyedartifactscount"></a>`destroyedArtifactsCount` | [`Int!`](#int) | Number of artifacts deleted. |
| <a id="mutationjobartifactsdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobartifactsdestroyjob"></a>`job` | [`CiJob`](#cijob) | Job with artifacts to be deleted. |

### `Mutation.jobCancel`

Input type: `JobCancelInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobcancelid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobcancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobcancelerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobcanceljob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobPlay`

Input type: `JobPlayInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobplayid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |
| <a id="mutationjobplayvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | Variables to use when playing a manual job. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobplayerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobplayjob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobRetry`

Input type: `JobRetryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobretryid"></a>`id` | [`CiProcessableID!`](#ciprocessableid) | ID of the job to mutate. |
| <a id="mutationjobretryvariables"></a>`variables` | [`[CiVariableInput!]`](#civariableinput) | Variables to use when retrying a manual job. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobretryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobretryjob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.jobUnschedule`

Input type: `JobUnscheduleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobunscheduleid"></a>`id` | [`CiBuildID!`](#cibuildid) | ID of the job to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationjobunscheduleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationjobunscheduleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationjobunschedulejob"></a>`job` | [`CiJob`](#cijob) | Job after the mutation. |

### `Mutation.labelCreate`

Input type: `LabelCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelcreatecolor"></a>`color` | [`String`](#string) | The color of the label given in 6-digit hex notation with leading '#' sign (for example, `#FFAABB`) or one of the CSS color names. |
| <a id="mutationlabelcreatedescription"></a>`description` | [`String`](#string) | Description of the label. |
| <a id="mutationlabelcreategrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationlabelcreateprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationlabelcreatetitle"></a>`title` | [`String!`](#string) | Title of the label. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationlabelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationlabelcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationlabelcreatelabel"></a>`label` | [`Label`](#label) | Label after mutation. |

### `Mutation.markAsSpamSnippet`

Input type: `MarkAsSpamSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmarkasspamsnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmarkasspamsnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmarkasspamsnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmarkasspamsnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.memberRoleCreate`

DETAILS:
**Introduced** in GitLab 16.5.
**Status**: Experiment.

Input type: `MemberRoleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreatebaseaccesslevel"></a>`baseAccessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | Base access level for the custom role. |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberrolecreatedescription"></a>`description` | [`String`](#string) | Description of the member role. |
| <a id="mutationmemberrolecreategrouppath"></a>`groupPath` | [`ID`](#id) | Group the member role to mutate is in. Required for SaaS. |
| <a id="mutationmemberrolecreatename"></a>`name` | [`String`](#string) | Name of the member role. |
| <a id="mutationmemberrolecreatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | List of all customizable permissions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberrolecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberrolecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmemberrolecreatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | Updated member role. |

### `Mutation.memberRoleDelete`

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `MemberRoleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroledeleteid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ID of the member role to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmemberroledeletememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | Deleted member role. |

### `Mutation.memberRoleUpdate`

Input type: `MemberRoleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleupdatedescription"></a>`description` | [`String`](#string) | Description of the member role. |
| <a id="mutationmemberroleupdateid"></a>`id` | [`MemberRoleID!`](#memberroleid) | ID of the member role to mutate. |
| <a id="mutationmemberroleupdatename"></a>`name` | [`String`](#string) | Name of the member role. |
| <a id="mutationmemberroleupdatepermissions"></a>`permissions` | [`[MemberRolePermission!]`](#memberrolepermission) | List of all customizable permissions. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmemberroleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmemberroleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmemberroleupdatememberrole"></a>`memberRole` | [`MemberRole`](#memberrole) | Updated member role. |

### `Mutation.mergeRequestAccept`

Accepts a merge request.
When accepted, the source branch will be scheduled to merge into the target branch, either
immediately if possible, or using one of the automatic merge strategies.

[In GitLab 16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/421510), the merging happens asynchronously.
This results in `mergeRequest` and `state` not updating after a mutation request,
because the merging may not have happened yet.

Input type: `MergeRequestAcceptInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestacceptcommitmessage"></a>`commitMessage` | [`String`](#string) | Custom merge commit message. |
| <a id="mutationmergerequestacceptiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestacceptprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestacceptsha"></a>`sha` | [`String!`](#string) | HEAD SHA at the time when the merge was requested. |
| <a id="mutationmergerequestacceptshouldremovesourcebranch"></a>`shouldRemoveSourceBranch` | [`Boolean`](#boolean) | Should the source branch be removed. |
| <a id="mutationmergerequestacceptsquash"></a>`squash` | [`Boolean`](#boolean) | Squash commits on the source branch before merge. |
| <a id="mutationmergerequestacceptsquashcommitmessage"></a>`squashCommitMessage` | [`String`](#string) | Custom squash commit message (if squash is true). |
| <a id="mutationmergerequestacceptstrategy"></a>`strategy` | [`MergeStrategyEnum`](#mergestrategyenum) | How to merge the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestacceptclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestaccepterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestacceptmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestCreate`

Input type: `MergeRequestCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestcreatedescription"></a>`description` | [`String`](#string) | Description of the merge request (Markdown rendered as HTML for caching). |
| <a id="mutationmergerequestcreatelabels"></a>`labels` | [`[String!]`](#string) | Labels of the merge request. |
| <a id="mutationmergerequestcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project full path the merge request is associated with. |
| <a id="mutationmergerequestcreatesourcebranch"></a>`sourceBranch` | [`String!`](#string) | Source branch of the merge request. |
| <a id="mutationmergerequestcreatetargetbranch"></a>`targetBranch` | [`String!`](#string) | Target branch of the merge request. |
| <a id="mutationmergerequestcreatetitle"></a>`title` | [`String!`](#string) | Title of the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestcreatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestReviewerRereview`

Input type: `MergeRequestReviewerRereviewInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestreviewerrereviewiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestreviewerrereviewprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestreviewerrereviewuserid"></a>`userId` | [`UserID!`](#userid) | User ID for the user that has been requested for a new review. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestreviewerrereviewclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestreviewerrereviewerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestreviewerrereviewmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetAssignees`

Input type: `MergeRequestSetAssigneesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesassigneeusernames"></a>`assigneeUsernames` | [`[String!]!`](#string) | Usernames to assign to the resource. Replaces existing assignees by default. |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetassigneesiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetassigneesoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationmergerequestsetassigneesprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetassigneesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetassigneeserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetassigneesmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetDraft`

Input type: `MergeRequestSetDraftInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetdraftdraft"></a>`draft` | [`Boolean!`](#boolean) | Whether or not to set the merge request as a draft. |
| <a id="mutationmergerequestsetdraftiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetdraftprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetdraftclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetdrafterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetdraftmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetLabels`

Input type: `MergeRequestSetLabelsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlabelsiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetlabelslabelids"></a>`labelIds` | [`[LabelID!]!`](#labelid) | Label IDs to set. Replaces existing labels by default. |
| <a id="mutationmergerequestsetlabelsoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Changes the operation mode. Defaults to REPLACE. |
| <a id="mutationmergerequestsetlabelsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlabelsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlabelserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetlabelsmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetLocked`

Input type: `MergeRequestSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlockediid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetlockedlocked"></a>`locked` | [`Boolean!`](#boolean) | Whether or not to lock the merge request. |
| <a id="mutationmergerequestsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetlockedmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetMilestone`

Input type: `MergeRequestSetMilestoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetmilestoneiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetmilestonemilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | Milestone to assign to the merge request. |
| <a id="mutationmergerequestsetmilestoneprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetmilestoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetmilestoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetmilestonemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetReviewers`

Input type: `MergeRequestSetReviewersInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetreviewersiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetreviewersoperationmode"></a>`operationMode` | [`MutationOperationMode`](#mutationoperationmode) | Operation to perform. Defaults to REPLACE. |
| <a id="mutationmergerequestsetreviewersprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestsetreviewersreviewerusernames"></a>`reviewerUsernames` | [`[String!]!`](#string) | Usernames of reviewers to assign. Replaces existing reviewers by default. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetreviewersclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetreviewerserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetreviewersmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestSetSubscription`

Input type: `MergeRequestSetSubscriptionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetsubscriptioniid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestsetsubscriptionprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestsetsubscriptionsubscribedstate"></a>`subscribedState` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestsetsubscriptionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestsetsubscriptionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestsetsubscriptionmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestUpdate`

Update attributes of a merge request.

Input type: `MergeRequestUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdatedescription"></a>`description` | [`String`](#string) | Description of the merge request (Markdown rendered as HTML for caching). |
| <a id="mutationmergerequestupdateiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestupdateoverriderequestedchanges"></a>`overrideRequestedChanges` | [`Boolean`](#boolean) | Override all requested changes. Can only be set by users who have permissionto merge this merge request. |
| <a id="mutationmergerequestupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestupdatestate"></a>`state` | [`MergeRequestNewState`](#mergerequestnewstate) | Action to perform to change the state. |
| <a id="mutationmergerequestupdatetargetbranch"></a>`targetBranch` | [`String`](#string) | Target branch of the merge request. |
| <a id="mutationmergerequestupdatetimeestimate"></a>`timeEstimate` | [`String`](#string) | Estimated time to complete the merge request. Use `null` or `0` to remove the current estimate. |
| <a id="mutationmergerequestupdatetitle"></a>`title` | [`String`](#string) | Title of the merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestupdatemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mergeRequestUpdateApprovalRule`

Input type: `MergeRequestUpdateApprovalRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleapprovalruleid"></a>`approvalRuleId` | [`Int!`](#int) | ID of an approval rule. |
| <a id="mutationmergerequestupdateapprovalruleapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | Number of required approvals for a given rule. |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateapprovalrulegroupids"></a>`groupIds` | [`[String!]`](#string) | IDs of groups as approvers. |
| <a id="mutationmergerequestupdateapprovalruleiid"></a>`iid` | [`String!`](#string) | IID of the merge request to mutate. |
| <a id="mutationmergerequestupdateapprovalrulename"></a>`name` | [`String!`](#string) | Name of the approval rule. |
| <a id="mutationmergerequestupdateapprovalruleprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the merge request to mutate is in. |
| <a id="mutationmergerequestupdateapprovalruleremovehiddengroups"></a>`removeHiddenGroups` | [`Boolean`](#boolean) | Whether hidden groups should be removed. |
| <a id="mutationmergerequestupdateapprovalruleuserids"></a>`userIds` | [`[String!]`](#string) | IDs of users as approvers. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmergerequestupdateapprovalruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmergerequestupdateapprovalruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmergerequestupdateapprovalrulemergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge request after mutation. |

### `Mutation.mlModelCreate`

DETAILS:
**Introduced** in GitLab 16.8.
**Status**: Experiment.

Input type: `MlModelCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelcreatedescription"></a>`description` | [`String`](#string) | Description of the model. |
| <a id="mutationmlmodelcreatename"></a>`name` | [`String!`](#string) | Name of the model. |
| <a id="mutationmlmodelcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmlmodelcreatemodel"></a>`model` | [`MlModel`](#mlmodel) | Model after mutation. |

### `Mutation.mlModelDestroy`

DETAILS:
**Introduced** in GitLab 16.10.
**Status**: Experiment.

Input type: `MlModelDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodeldestroyid"></a>`id` | [`MlModelID!`](#mlmodelid) | Global ID of the model to be deleted. |
| <a id="mutationmlmodeldestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the model to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodeldestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodeldestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmlmodeldestroymessage"></a>`message` | [`String`](#string) | Model deletion result message. |
| <a id="mutationmlmodeldestroymodel"></a>`model` | [`MlModel`](#mlmodel) | Model after mutation. |

### `Mutation.mlModelVersionDelete`

DETAILS:
**Introduced** in GitLab 17.0.
**Status**: Experiment.

Input type: `MlModelVersionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversiondeleteid"></a>`id` | [`MlModelVersionID!`](#mlmodelversionid) | Global ID of the model version to be deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationmlmodelversiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationmlmodelversiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationmlmodelversiondeletemodelversion"></a>`modelVersion` | [`MlModelVersion`](#mlmodelversion) | Deleted model version. |

### `Mutation.namespaceBanDestroy`

Input type: `NamespaceBanDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacebandestroyid"></a>`id` | [`NamespacesNamespaceBanID!`](#namespacesnamespacebanid) | Global ID of the namespace ban to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacebandestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacebandestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationnamespacebandestroynamespaceban"></a>`namespaceBan` | [`NamespaceBan`](#namespaceban) | Namespace Ban. |

### `Mutation.namespaceCiCdSettingsUpdate`

Input type: `NamespaceCiCdSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdateallowstalerunnerpruning"></a>`allowStaleRunnerPruning` | [`Boolean`](#boolean) | Indicates if stale runners directly belonging to this namespace should be periodically pruned. |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full path of the namespace the settings belong to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`NamespaceCiCdSetting!`](#namespacecicdsetting) | CI/CD settings after mutation. |
| <a id="mutationnamespacecicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.namespaceCreateRemoteDevelopmentClusterAgentMapping`

Input type: `NamespaceCreateRemoteDevelopmentClusterAgentMappingInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent to be associated with the namespace. |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | GlobalID of the namespace to be associated with the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacecreateremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.namespaceDeleteRemoteDevelopmentClusterAgentMapping`

Input type: `NamespaceDeleteRemoteDevelopmentClusterAgentMappingInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent to be un-associated from the namespace. |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | GlobalID of the namespace to be un-associated from the cluster agent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationnamespacedeleteremotedevelopmentclusteragentmappingerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.oncallRotationCreate`

Input type: `OncallRotationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | Active period of time that the on-call rotation should take place. |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationcreateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | End date and time of the on-call rotation, in the timezone of the on-call schedule. |
| <a id="mutationoncallrotationcreatename"></a>`name` | [`String!`](#string) | Name of the on-call rotation. |
| <a id="mutationoncallrotationcreateparticipants"></a>`participants` | [`[OncallUserInputType!]!`](#oncalluserinputtype) | Usernames of users participating in the on-call rotation. A maximum limit of 100 participants applies. |
| <a id="mutationoncallrotationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the on-call schedule in. |
| <a id="mutationoncallrotationcreaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType!`](#oncallrotationlengthinputtype) | Rotation length of the on-call rotation. |
| <a id="mutationoncallrotationcreatescheduleiid"></a>`scheduleIid` | [`String!`](#string) | IID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationoncallrotationcreatestartsat"></a>`startsAt` | [`OncallRotationDateInputType!`](#oncallrotationdateinputtype) | Start date and time of the on-call rotation, in the timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallrotationcreateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallRotationDestroy`

Input type: `OncallRotationDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationdestroyid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call rotation to remove. |
| <a id="mutationoncallrotationdestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to remove the on-call schedule from. |
| <a id="mutationoncallrotationdestroyscheduleiid"></a>`scheduleIid` | [`String!`](#string) | IID of the on-call schedule to the on-call rotation belongs to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallrotationdestroyoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallRotationUpdate`

Input type: `OncallRotationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateactiveperiod"></a>`activePeriod` | [`OncallRotationActivePeriodInputType`](#oncallrotationactiveperiodinputtype) | Active period of time that the on-call rotation should take place. |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationupdateendsat"></a>`endsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | End date and time of the on-call rotation, in the timezone of the on-call schedule. |
| <a id="mutationoncallrotationupdateid"></a>`id` | [`IncidentManagementOncallRotationID!`](#incidentmanagementoncallrotationid) | ID of the on-call schedule to create the on-call rotation in. |
| <a id="mutationoncallrotationupdatename"></a>`name` | [`String`](#string) | Name of the on-call rotation. |
| <a id="mutationoncallrotationupdateparticipants"></a>`participants` | [`[OncallUserInputType!]`](#oncalluserinputtype) | Usernames of users participating in the on-call rotation. A maximum limit of 100 participants applies. |
| <a id="mutationoncallrotationupdaterotationlength"></a>`rotationLength` | [`OncallRotationLengthInputType`](#oncallrotationlengthinputtype) | Rotation length of the on-call rotation. |
| <a id="mutationoncallrotationupdatestartsat"></a>`startsAt` | [`OncallRotationDateInputType`](#oncallrotationdateinputtype) | Start date and time of the on-call rotation, in the timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallrotationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallrotationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallrotationupdateoncallrotation"></a>`oncallRotation` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | On-call rotation. |

### `Mutation.oncallScheduleCreate`

Input type: `OncallScheduleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallschedulecreatedescription"></a>`description` | [`String`](#string) | Description of the on-call schedule. |
| <a id="mutationoncallschedulecreatename"></a>`name` | [`String!`](#string) | Name of the on-call schedule. |
| <a id="mutationoncallschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the on-call schedule in. |
| <a id="mutationoncallschedulecreatetimezone"></a>`timezone` | [`String!`](#string) | Timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallschedulecreateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.oncallScheduleDestroy`

Input type: `OncallScheduleDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduledestroyiid"></a>`iid` | [`String!`](#string) | On-call schedule internal ID to remove. |
| <a id="mutationoncallscheduledestroyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to remove the on-call schedule from. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduledestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduledestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallscheduledestroyoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.oncallScheduleUpdate`

Input type: `OncallScheduleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduleupdatedescription"></a>`description` | [`String`](#string) | Description of the on-call schedule. |
| <a id="mutationoncallscheduleupdateiid"></a>`iid` | [`String!`](#string) | On-call schedule internal ID to update. |
| <a id="mutationoncallscheduleupdatename"></a>`name` | [`String`](#string) | Name of the on-call schedule. |
| <a id="mutationoncallscheduleupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to update the on-call schedule in. |
| <a id="mutationoncallscheduleupdatetimezone"></a>`timezone` | [`String`](#string) | Timezone of the on-call schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationoncallscheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationoncallscheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationoncallscheduleupdateoncallschedule"></a>`oncallSchedule` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | On-call schedule. |

### `Mutation.organizationCreate`

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `OrganizationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the organization. |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationcreatedescription"></a>`description` | [`String`](#string) | Description of the organization. |
| <a id="mutationorganizationcreatename"></a>`name` | [`String!`](#string) | Name for the organization. |
| <a id="mutationorganizationcreatepath"></a>`path` | [`String!`](#string) | Path for the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationorganizationcreateorganization"></a>`organization` | [`Organization`](#organization) | Organization after mutation. |

### `Mutation.organizationUpdate`

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `OrganizationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateavatar"></a>`avatar` | [`Upload`](#upload) | Avatar for the organization. |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationupdatedescription"></a>`description` | [`String`](#string) | Description of the organization. |
| <a id="mutationorganizationupdateid"></a>`id` | [`OrganizationsOrganizationID!`](#organizationsorganizationid) | ID of the organization to mutate. |
| <a id="mutationorganizationupdatename"></a>`name` | [`String`](#string) | Name for the organization. |
| <a id="mutationorganizationupdatepath"></a>`path` | [`String`](#string) | Path for the organization. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationorganizationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationorganizationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationorganizationupdateorganization"></a>`organization` | [`Organization`](#organization) | Organization after mutation. |

### `Mutation.pagesMarkOnboardingComplete`

Input type: `PagesMarkOnboardingCompleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpagesmarkonboardingcompleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpagesmarkonboardingcompleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpagesmarkonboardingcompleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpagesmarkonboardingcompleteonboardingcomplete"></a>`onboardingComplete` | [`Boolean!`](#boolean) | Indicates the new onboarding_complete state of the project's Pages metadata. |

### `Mutation.pipelineCancel`

Input type: `PipelineCancelInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecancelid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinecancelclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinecancelerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.pipelineDestroy`

Input type: `PipelineDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinedestroyid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinedestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinedestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.pipelineRetry`

Input type: `PipelineRetryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineretryid"></a>`id` | [`CiPipelineID!`](#cipipelineid) | ID of the pipeline to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineretryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineretryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelineretrypipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | Pipeline after mutation. |

### `Mutation.pipelineScheduleCreate`

Input type: `PipelineScheduleCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the pipeline schedule should be active or not. |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineschedulecreatecron"></a>`cron` | [`String!`](#string) | Cron expression of the pipeline schedule. |
| <a id="mutationpipelineschedulecreatecrontimezone"></a>`cronTimezone` | [`String`](#string) | Cron time zone supported by ActiveSupport::TimeZone. For example: "Pacific Time (US & Canada)" (default: "UTC"). |
| <a id="mutationpipelineschedulecreatedescription"></a>`description` | [`String!`](#string) | Description of the pipeline schedule. |
| <a id="mutationpipelineschedulecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the pipeline schedule is associated with. |
| <a id="mutationpipelineschedulecreateref"></a>`ref` | [`String!`](#string) | Ref of the pipeline schedule. |
| <a id="mutationpipelineschedulecreatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | Variables for the pipeline schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelineschedulecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelineschedulecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelineschedulecreatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Created pipeline schedule. |

### `Mutation.pipelineScheduleDelete`

Input type: `PipelineScheduleDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduledeleteid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduledeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduledeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.pipelineSchedulePlay`

Input type: `PipelineSchedulePlayInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleplayid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleplayclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleplayerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinescheduleplaypipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Pipeline schedule after mutation. |

### `Mutation.pipelineScheduleTakeOwnership`

Input type: `PipelineScheduleTakeOwnershipInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduletakeownershipid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduletakeownershipclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduletakeownershiperrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinescheduletakeownershippipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Updated pipeline schedule ownership. |

### `Mutation.pipelineScheduleUpdate`

Input type: `PipelineScheduleUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the pipeline schedule should be active or not. |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleupdatecron"></a>`cron` | [`String`](#string) | Cron expression of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdatecrontimezone"></a>`cronTimezone` | [`String`](#string) | Cron time zone supported by ActiveSupport::TimeZone. For example: "Pacific Time (US & Canada)" (default: "UTC"). |
| <a id="mutationpipelinescheduleupdatedescription"></a>`description` | [`String`](#string) | Description of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdateid"></a>`id` | [`CiPipelineScheduleID!`](#cipipelinescheduleid) | ID of the pipeline schedule to mutate. |
| <a id="mutationpipelinescheduleupdateref"></a>`ref` | [`String`](#string) | Ref of the pipeline schedule. |
| <a id="mutationpipelinescheduleupdatevariables"></a>`variables` | [`[PipelineScheduleVariableInput!]`](#pipelineschedulevariableinput) | Variables for the pipeline schedule. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinescheduleupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinescheduleupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinescheduleupdatepipelineschedule"></a>`pipelineSchedule` | [`PipelineSchedule`](#pipelineschedule) | Updated pipeline schedule. |

### `Mutation.pipelineTriggerCreate`

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `PipelineTriggerCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggercreatedescription"></a>`description` | [`String!`](#string) | Description of the pipeline trigger token. |
| <a id="mutationpipelinetriggercreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project that the pipeline trigger token to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinetriggercreatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | Mutated pipeline trigger token. |

### `Mutation.pipelineTriggerDelete`

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `PipelineTriggerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerdeleteid"></a>`id` | [`CiTriggerID!`](#citriggerid) | ID of the pipeline trigger token to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.pipelineTriggerUpdate`

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `PipelineTriggerUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerupdatedescription"></a>`description` | [`String!`](#string) | Description of the pipeline trigger token. |
| <a id="mutationpipelinetriggerupdateid"></a>`id` | [`CiTriggerID!`](#citriggerid) | ID of the pipeline trigger token to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpipelinetriggerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpipelinetriggerupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpipelinetriggerupdatepipelinetrigger"></a>`pipelineTrigger` | [`PipelineTrigger`](#pipelinetrigger) | Mutated pipeline trigger token. |

### `Mutation.projectCiCdSettingsUpdate`

Input type: `ProjectCiCdSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectcicdsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full Path of the project the settings belong to. |
| <a id="mutationprojectcicdsettingsupdateinboundjobtokenscopeenabled"></a>`inboundJobTokenScopeEnabled` | [`Boolean`](#boolean) | Indicates CI/CD job tokens generated in other projects have restricted access to this project. |
| <a id="mutationprojectcicdsettingsupdatejobtokenscopeenabled"></a>`jobTokenScopeEnabled` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** Outbound job token scope is being removed. This field can now only be set to false. Deprecated in GitLab 16.0. |
| <a id="mutationprojectcicdsettingsupdatekeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | Indicates if the latest artifact should be kept for the project. |
| <a id="mutationprojectcicdsettingsupdatemergepipelinesenabled"></a>`mergePipelinesEnabled` | [`Boolean`](#boolean) | Indicates if merged results pipelines are enabled for the project. |
| <a id="mutationprojectcicdsettingsupdatemergetrainsenabled"></a>`mergeTrainsEnabled` | [`Boolean`](#boolean) | Indicates if merge trains are enabled for the project. |
| <a id="mutationprojectcicdsettingsupdatemergetrainsskiptrainallowed"></a>`mergeTrainsSkipTrainAllowed` | [`Boolean`](#boolean) | Indicates whether an option is allowed to merge without refreshing the merge train. Ignored unless the `merge_trains_skip_train` feature flag is also enabled. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectcicdsettingsupdatecicdsettings"></a>`ciCdSettings` | [`ProjectCiCdSetting!`](#projectcicdsetting) | CI/CD settings after mutation. |
| <a id="mutationprojectcicdsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectcicdsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.projectInitializeProductAnalytics`

Input type: `ProjectInitializeProductAnalyticsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectinitializeproductanalyticsprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to initialize. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectinitializeproductanalyticsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectinitializeproductanalyticserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectinitializeproductanalyticsproject"></a>`project` | [`Project`](#project) | Project on which the initialization took place. |

### `Mutation.projectMemberBulkUpdate`

Updates multiple members of a project. To use this mutation, you must have at least the Maintainer role.

Input type: `ProjectMemberBulkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateaccesslevel"></a>`accessLevel` | [`MemberAccessLevel!`](#memberaccesslevel) | Access level to update the members to. |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectmemberbulkupdateexpiresat"></a>`expiresAt` | [`Time`](#time) | Date and time the membership expires. |
| <a id="mutationprojectmemberbulkupdateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global ID of the project. |
| <a id="mutationprojectmemberbulkupdateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of the members. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectmemberbulkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectmemberbulkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectmemberbulkupdateprojectmembers"></a>`projectMembers` | [`[ProjectMember!]`](#projectmember) | Project members after mutation. |

### `Mutation.projectSavedReplyCreate`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `ProjectSavedReplyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplycreatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationprojectsavedreplycreatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |
| <a id="mutationprojectsavedreplycreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Project for the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsavedreplycreatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | Saved reply after mutation. |

### `Mutation.projectSavedReplyDestroy`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `ProjectSavedReplyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplydestroyid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | Global ID of the project-level saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsavedreplydestroysavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | Saved reply after mutation. |

### `Mutation.projectSavedReplyUpdate`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `ProjectSavedReplyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationprojectsavedreplyupdateid"></a>`id` | [`ProjectsSavedReplyID!`](#projectssavedreplyid) | Global ID of the project-level saved reply. |
| <a id="mutationprojectsavedreplyupdatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsavedreplyupdatesavedreply"></a>`savedReply` | [`ProjectSavedReply`](#projectsavedreply) | Saved reply after mutation. |

### `Mutation.projectSetComplianceFramework`

Assign (or unset) a compliance framework to a project.

Input type: `ProjectSetComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcomplianceframeworkcomplianceframeworkid"></a>`complianceFrameworkId` | [`ComplianceManagementFrameworkID`](#compliancemanagementframeworkid) | ID of the compliance framework to assign to the project. Set to `null` to unset. |
| <a id="mutationprojectsetcomplianceframeworkprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project to change the compliance framework of. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsetcomplianceframeworkproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSetContinuousVulnerabilityScanning`

Enable/disable Continuous Vulnerability Scanning for the given project.

Input type: `ProjectSetContinuousVulnerabilityScanningInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for Continuous Vulnerability Scanning feature. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningcontinuousvulnerabilityscanningenabled"></a>`continuousVulnerabilityScanningEnabled` | [`Boolean!`](#boolean) | Whether feature is enabled. |
| <a id="mutationprojectsetcontinuousvulnerabilityscanningerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.projectSetLocked`

Input type: `ProjectSetLockedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetlockedfilepath"></a>`filePath` | [`String!`](#string) | Full path to the file. |
| <a id="mutationprojectsetlockedlock"></a>`lock` | [`Boolean!`](#boolean) | Whether or not to lock the file path. |
| <a id="mutationprojectsetlockedprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsetlockedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsetlockederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsetlockedproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSettingsUpdate`

DETAILS:
**Introduced** in GitLab 16.9.
**Status**: Experiment.

Input type: `ProjectSettingsUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsettingsupdateduofeaturesenabled"></a>`duoFeaturesEnabled` | [`Boolean!`](#boolean) | Indicates whether GitLab Duo features are enabled for the project. |
| <a id="mutationprojectsettingsupdatefullpath"></a>`fullPath` | [`ID!`](#id) | Full Path of the project the settings belong to. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsettingsupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsettingsupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsettingsupdateprojectsettings"></a>`projectSettings` | [`ProjectSetting!`](#projectsetting) | Project settings after mutation. |

### `Mutation.projectSubscriptionCreate`

Input type: `ProjectSubscriptionCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptioncreateprojectpath"></a>`projectPath` | [`String!`](#string) | Full path of the downstream project of the Project Subscription. |
| <a id="mutationprojectsubscriptioncreateupstreampath"></a>`upstreamPath` | [`String!`](#string) | Full path of the upstream project of the Project Subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptioncreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptioncreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsubscriptioncreatesubscription"></a>`subscription` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | Project Subscription created by the mutation. |

### `Mutation.projectSubscriptionDelete`

Input type: `ProjectSubscriptionDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptiondeletesubscriptionid"></a>`subscriptionId` | [`CiSubscriptionsProjectID!`](#cisubscriptionsprojectid) | ID of the subscription to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsubscriptiondeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsubscriptiondeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprojectsubscriptiondeleteproject"></a>`project` | [`Project`](#project) | Project after mutation. |

### `Mutation.projectSyncFork`

DETAILS:
**Introduced** in GitLab 15.9.
**Status**: Experiment.

Input type: `ProjectSyncForkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsyncforkprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project to initialize. |
| <a id="mutationprojectsyncforktargetbranch"></a>`targetBranch` | [`String!`](#string) | Ref of the fork to fetch into. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprojectsyncforkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprojectsyncforkdetails"></a>`details` | [`ForkDetails`](#forkdetails) | Updated fork details. |
| <a id="mutationprojectsyncforkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.prometheusIntegrationCreate`

Input type: `PrometheusIntegrationCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateactive"></a>`active` | [`Boolean!`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationprometheusintegrationcreateapiurl"></a>`apiUrl` | [`String`](#string) | Endpoint at which Prometheus can be queried. |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the integration in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprometheusintegrationcreateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Newly created integration. |

### `Mutation.prometheusIntegrationResetToken`

Input type: `PrometheusIntegrationResetTokenInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationresettokenid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationresettokenclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationresettokenerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprometheusintegrationresettokenintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Newly created integration. |

### `Mutation.prometheusIntegrationUpdate`

Input type: `PrometheusIntegrationUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateactive"></a>`active` | [`Boolean`](#boolean) | Whether the integration is receiving alerts. |
| <a id="mutationprometheusintegrationupdateapiurl"></a>`apiUrl` | [`String`](#string) | Endpoint at which Prometheus can be queried. |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationupdateid"></a>`id` | [`IntegrationsPrometheusID!`](#integrationsprometheusid) | ID of the integration to mutate. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationprometheusintegrationupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationprometheusintegrationupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationprometheusintegrationupdateintegration"></a>`integration` | [`AlertManagementPrometheusIntegration`](#alertmanagementprometheusintegration) | Newly created integration. |

### `Mutation.promoteToEpic`

Input type: `PromoteToEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpromotetoepicgrouppath"></a>`groupPath` | [`ID`](#id) | Group the promoted epic will belong to. |
| <a id="mutationpromotetoepiciid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationpromotetoepicprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationpromotetoepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationpromotetoepicepic"></a>`epic` | [`Epic`](#epic) | Epic after issue promotion. |
| <a id="mutationpromotetoepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationpromotetoepicissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.refreshStandardsAdherenceChecks`

Input type: `RefreshStandardsAdherenceChecksInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshstandardsadherencechecksgrouppath"></a>`groupPath` | [`ID!`](#id) | Group path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrefreshstandardsadherencechecksadherencechecksstatus"></a>`adherenceChecksStatus` | [`StandardsAdherenceChecksStatus`](#standardsadherencechecksstatus) | Progress of standards adherence checks. |
| <a id="mutationrefreshstandardsadherencechecksclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrefreshstandardsadherencecheckserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.releaseAssetLinkCreate`

Input type: `ReleaseAssetLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkcreatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | Relative path for a direct asset link. |
| <a id="mutationreleaseassetlinkcreatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | Type of the asset link. |
| <a id="mutationreleaseassetlinkcreatename"></a>`name` | [`String!`](#string) | Name of the asset link. |
| <a id="mutationreleaseassetlinkcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the asset link is associated with. |
| <a id="mutationreleaseassetlinkcreatetagname"></a>`tagName` | [`String!`](#string) | Name of the associated release's tag. |
| <a id="mutationreleaseassetlinkcreateurl"></a>`url` | [`String!`](#string) | URL of the asset link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseassetlinkcreatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Asset link after mutation. |

### `Mutation.releaseAssetLinkDelete`

Input type: `ReleaseAssetLinkDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkdeleteid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | ID of the release asset link to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseassetlinkdeletelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Deleted release asset link. |

### `Mutation.releaseAssetLinkUpdate`

Input type: `ReleaseAssetLinkUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkupdatedirectassetpath"></a>`directAssetPath` | [`String`](#string) | Relative path for a direct asset link. |
| <a id="mutationreleaseassetlinkupdateid"></a>`id` | [`ReleasesLinkID!`](#releaseslinkid) | ID of the release asset link to update. |
| <a id="mutationreleaseassetlinkupdatelinktype"></a>`linkType` | [`ReleaseAssetLinkType`](#releaseassetlinktype) | Type of the asset link. |
| <a id="mutationreleaseassetlinkupdatename"></a>`name` | [`String`](#string) | Name of the asset link. |
| <a id="mutationreleaseassetlinkupdateurl"></a>`url` | [`String`](#string) | URL of the asset link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseassetlinkupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseassetlinkupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseassetlinkupdatelink"></a>`link` | [`ReleaseAssetLink`](#releaseassetlink) | Asset link after mutation. |

### `Mutation.releaseCreate`

Input type: `ReleaseCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateassets"></a>`assets` | [`ReleaseAssetsInput`](#releaseassetsinput) | Assets associated to the release. |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasecreatedescription"></a>`description` | [`String`](#string) | Description (also known as "release notes") of the release. |
| <a id="mutationreleasecreatemilestones"></a>`milestones` | [`[String!]`](#string) | Title of each milestone the release is associated with. GitLab Premium customers can specify group milestones. |
| <a id="mutationreleasecreatename"></a>`name` | [`String`](#string) | Name of the release. |
| <a id="mutationreleasecreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleasecreateref"></a>`ref` | [`String`](#string) | Commit SHA or branch name to use if creating a new tag. |
| <a id="mutationreleasecreatereleasedat"></a>`releasedAt` | [`Time`](#time) | Date and time for the release. Defaults to the current time. Expected in ISO 8601 format (`2019-03-15T08:00:00Z`). Only provide this field if creating an upcoming or historical release. |
| <a id="mutationreleasecreatetagmessage"></a>`tagMessage` | [`String`](#string) | Message to use if creating a new annotated tag. |
| <a id="mutationreleasecreatetagname"></a>`tagName` | [`String!`](#string) | Name of the tag to associate with the release. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleasecreaterelease"></a>`release` | [`Release`](#release) | Release after mutation. |

### `Mutation.releaseDelete`

Input type: `ReleaseDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasedeleteprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleasedeletetagname"></a>`tagName` | [`String!`](#string) | Name of the tag associated with the release to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleasedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleasedeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleasedeleterelease"></a>`release` | [`Release`](#release) | Deleted release. |

### `Mutation.releaseUpdate`

Input type: `ReleaseUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseupdatedescription"></a>`description` | [`String`](#string) | Description (release notes) of the release. |
| <a id="mutationreleaseupdatemilestones"></a>`milestones` | [`[String!]`](#string) | Title of each milestone the release is associated with. GitLab Premium customers can specify group milestones. |
| <a id="mutationreleaseupdatename"></a>`name` | [`String`](#string) | Name of the release. |
| <a id="mutationreleaseupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project the release is associated with. |
| <a id="mutationreleaseupdatereleasedat"></a>`releasedAt` | [`Time`](#time) | Release date. |
| <a id="mutationreleaseupdatetagname"></a>`tagName` | [`String!`](#string) | Name of the tag associated with the release. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationreleaseupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationreleaseupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationreleaseupdaterelease"></a>`release` | [`Release`](#release) | Release after mutation. |

### `Mutation.removeProjectFromSecurityDashboard`

Input type: `RemoveProjectFromSecurityDashboardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationremoveprojectfromsecuritydashboardid"></a>`id` | [`ProjectID!`](#projectid) | ID of the project to remove from the Instance Security Dashboard. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationremoveprojectfromsecuritydashboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationremoveprojectfromsecuritydashboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.repositionImageDiffNote`

Repositions a DiffNote on an image (a `Note` where the `position.positionType` is `"image"`).

Input type: `RepositionImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrepositionimagediffnoteid"></a>`id` | [`DiffNoteID!`](#diffnoteid) | Global ID of the DiffNote to update. |
| <a id="mutationrepositionimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput!`](#updatediffimagepositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrepositionimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrepositionimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrepositionimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.runnerCacheClear`

Input type: `RunnerCacheClearInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercacheclearprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Global ID of the project that will have its runner cache cleared. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercacheclearclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercacheclearerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.runnerCreate`

DETAILS:
**Introduced** in GitLab 15.10.
**Status**: Experiment.

Input type: `RunnerCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercreatedescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="mutationrunnercreategroupid"></a>`groupId` | [`GroupID`](#groupid) | Global ID of the group that the runner is created in (valid only for group runner). |
| <a id="mutationrunnercreatelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="mutationrunnercreatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="mutationrunnercreatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="mutationrunnercreatepaused"></a>`paused` | [`Boolean`](#boolean) | Indicates the runner is not allowed to receive jobs. |
| <a id="mutationrunnercreateprojectid"></a>`projectId` | [`ProjectID`](#projectid) | Global ID of the project that the runner is created in (valid only for project runner). |
| <a id="mutationrunnercreaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="mutationrunnercreaterunnertype"></a>`runnerType` | [`CiRunnerType!`](#cirunnertype) | Type of the runner to create. |
| <a id="mutationrunnercreatetaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnercreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnercreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrunnercreaterunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner after mutation. |

### `Mutation.runnerDelete`

Input type: `RunnerDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerdeleteid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to delete. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.runnerUpdate`

Input type: `RunnerUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateaccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="mutationrunnerupdateactive"></a>`active` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** This was renamed. Please use `paused`. Deprecated in GitLab 14.8. |
| <a id="mutationrunnerupdateassociatedprojects"></a>`associatedProjects` | [`[ProjectID!]`](#projectid) | Projects associated with the runner. Available only for project runners. |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerupdatedescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="mutationrunnerupdateid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner to update. |
| <a id="mutationrunnerupdatelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="mutationrunnerupdatemaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="mutationrunnerupdatemaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="mutationrunnerupdatepaused"></a>`paused` | [`Boolean`](#boolean) | Indicates the runner is not allowed to receive jobs. |
| <a id="mutationrunnerupdateprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` | [`Float`](#float) | Private projects' "compute cost factor" associated with the runner (GitLab.com only). |
| <a id="mutationrunnerupdatepublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` | [`Float`](#float) | Public projects' "compute cost factor" associated with the runner (GitLab.com only). |
| <a id="mutationrunnerupdaterununtagged"></a>`runUntagged` | [`Boolean`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="mutationrunnerupdatetaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnerupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnerupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrunnerupdaterunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner after mutation. |

### `Mutation.runnersExportUsage`

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `RunnersExportUsageInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersexportusagefromdate"></a>`fromDate` | [`ISO8601Date`](#iso8601date) | UTC start date of the period to report on. Defaults to the start of last full month. |
| <a id="mutationrunnersexportusagemaxprojectcount"></a>`maxProjectCount` | [`Int`](#int) | Maximum number of projects to return. All other runner usage will be attributed to an `<Other projects>` entry. Defaults to 1000 projects. |
| <a id="mutationrunnersexportusagetodate"></a>`toDate` | [`ISO8601Date`](#iso8601date) | UTC end date of the period to report on. " \ "Defaults to the end of the month specified by `fromDate`. |
| <a id="mutationrunnersexportusagetype"></a>`type` | [`CiRunnerType`](#cirunnertype) | Scope of the runners to include in the report. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersexportusageclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersexportusageerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.runnersRegistrationTokenReset`

Input type: `RunnersRegistrationTokenResetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersregistrationtokenresetid"></a>`id` | [`ID`](#id) | ID of the project or group to reset the token for. Omit if resetting instance runner token. |
| <a id="mutationrunnersregistrationtokenresettype"></a>`type` | [`CiRunnerType!`](#cirunnertype) | Scope of the object to reset the token for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationrunnersregistrationtokenresetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationrunnersregistrationtokenreseterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationrunnersregistrationtokenresettoken"></a>`token` | [`String`](#string) | Runner token after mutation. |

### `Mutation.savedReplyCreate`

Input type: `SavedReplyCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplycreatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationsavedreplycreatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsavedreplycreatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.savedReplyDestroy`

Input type: `SavedReplyDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplydestroyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | Global ID of the user saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplydestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplydestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsavedreplydestroysavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.savedReplyUpdate`

Input type: `SavedReplyUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplyupdatecontent"></a>`content` | [`String!`](#string) | Content of the saved reply. |
| <a id="mutationsavedreplyupdateid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | Global ID of the user saved reply. |
| <a id="mutationsavedreplyupdatename"></a>`name` | [`String!`](#string) | Name of the saved reply. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsavedreplyupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsavedreplyupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsavedreplyupdatesavedreply"></a>`savedReply` | [`SavedReply`](#savedreply) | Saved reply after mutation. |

### `Mutation.scanExecutionPolicyCommit`

Commits the `policy_yaml` content to the assigned security policy project for the given project (`full_path`).

Input type: `ScanExecutionPolicyCommitInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationscanexecutionpolicycommitfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project. |
| <a id="mutationscanexecutionpolicycommitname"></a>`name` | [`String!`](#string) | Name of the policy. If the name is null, the `name` field from `policy_yaml` is used. |
| <a id="mutationscanexecutionpolicycommitoperationmode"></a>`operationMode` | [`MutationOperationMode!`](#mutationoperationmode) | Changes the operation mode. |
| <a id="mutationscanexecutionpolicycommitpolicyyaml"></a>`policyYaml` | [`String!`](#string) | YAML snippet of the policy. |
| <a id="mutationscanexecutionpolicycommitprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in GitLab 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationscanexecutionpolicycommitbranch"></a>`branch` | [`String`](#string) | Name of the branch to which the policy changes are committed. |
| <a id="mutationscanexecutionpolicycommitclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationscanexecutionpolicycommiterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationscanexecutionpolicycommitvalidationerrors"></a>`validationErrors` | [`[SecurityPolicyValidationError!]`](#securitypolicyvalidationerror) | Validation errors encountered during execution of the mutation. |

### `Mutation.securityFindingCreateIssue`

Input type: `SecurityFindingCreateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreateissueproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the issue to. |
| <a id="mutationsecurityfindingcreateissueuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create an issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingcreateissueissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |

### `Mutation.securityFindingCreateMergeRequest`

Input type: `SecurityFindingCreateMergeRequestInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatemergerequestuuid"></a>`uuid` | [`String!`](#string) | UUID of the security finding to be used to create a merge request. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingcreatemergerequestclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingcreatemergerequesterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingcreatemergerequestmergerequest"></a>`mergeRequest` | [`MergeRequest`](#mergerequest) | Merge Request created after mutation. |

### `Mutation.securityFindingDismiss`

Input type: `SecurityFindingDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingdismisscomment"></a>`comment` | [`String`](#string) | Comment why finding should be dismissed. |
| <a id="mutationsecurityfindingdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why finding should be dismissed. |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String!`](#string) | UUID of the finding to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingdismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingdismisssecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | Dismissed finding. |
| <a id="mutationsecurityfindingdismissuuid"></a>`uuid` | [`String`](#string) | UUID of dismissed finding. |

### `Mutation.securityFindingRevertToDetected`

Input type: `SecurityFindingRevertToDetectedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingreverttodetectedcomment"></a>`comment` | [`String`](#string) | Comment that explains why finding was reverted to detected status. |
| <a id="mutationsecurityfindingreverttodetecteduuid"></a>`uuid` | [`String!`](#string) | UUID of the finding to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecurityfindingreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecurityfindingreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecurityfindingreverttodetectedsecurityfinding"></a>`securityFinding` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | Finding reverted to detected. |

### `Mutation.securityPolicyProjectAssign`

Assigns the specified project(`security_policy_project_id`) as security policy project for the given project(`full_path`). If the project already has a security policy project, this reassigns the project's security policy project with the given `security_policy_project_id`.

Input type: `SecurityPolicyProjectAssignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectassignfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectassignprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in GitLab 14.10. |
| <a id="mutationsecuritypolicyprojectassignsecuritypolicyprojectid"></a>`securityPolicyProjectId` | [`ProjectID!`](#projectid) | ID of the security policy project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.securityPolicyProjectCreate`

Creates and assigns a security policy project for the given project or group (`full_path`).

Input type: `SecurityPolicyProjectCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreatefullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectcreateprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in GitLab 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecuritypolicyprojectcreateproject"></a>`project` | [`Project`](#project) | Security Policy Project that was created. |

### `Mutation.securityPolicyProjectUnassign`

Unassigns the security policy project for the given project (`full_path`).

Input type: `SecurityPolicyProjectUnassignInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectunassignfullpath"></a>`fullPath` | [`String`](#string) | Full path of the project or group. |
| <a id="mutationsecuritypolicyprojectunassignprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Use `fullPath`. Deprecated in GitLab 14.10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritypolicyprojectunassignclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritypolicyprojectunassignerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.securityTrainingUpdate`

Input type: `SecurityTrainingUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritytrainingupdateisenabled"></a>`isEnabled` | [`Boolean!`](#boolean) | Sets the training provider as enabled for the project. |
| <a id="mutationsecuritytrainingupdateisprimary"></a>`isPrimary` | [`Boolean`](#boolean) | Sets the training provider as primary for the project. |
| <a id="mutationsecuritytrainingupdateprojectpath"></a>`projectPath` | [`ID!`](#id) | Full path of the project. |
| <a id="mutationsecuritytrainingupdateproviderid"></a>`providerId` | [`SecurityTrainingProviderID!`](#securitytrainingproviderid) | ID of the provider. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsecuritytrainingupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsecuritytrainingupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsecuritytrainingupdatetraining"></a>`training` | [`ProjectSecurityTraining`](#projectsecuritytraining) | Represents the training entity subject to mutation. |

### `Mutation.setContainerScanningForRegistry`

Enable/disable Container Scanning on Container Registry for the given project or group.

Input type: `SetContainerScanningForRegistryInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetcontainerscanningforregistryenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for Container Scanning on Container Registry feature. |
| <a id="mutationsetcontainerscanningforregistrynamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace (project or group). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetcontainerscanningforregistryclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetcontainerscanningforregistrycontainerscanningforregistryenabled"></a>`containerScanningForRegistryEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |
| <a id="mutationsetcontainerscanningforregistryerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.setPreReceiveSecretDetection`

Enable/disable pre-receive secret detection for the given project.

Input type: `SetPreReceiveSecretDetectionInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetprereceivesecretdetectionenable"></a>`enable` | [`Boolean!`](#boolean) | Desired status for pre-receive secret detection feature. |
| <a id="mutationsetprereceivesecretdetectionnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace (project). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationsetprereceivesecretdetectionclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationsetprereceivesecretdetectionerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationsetprereceivesecretdetectionprereceivesecretdetectionenabled"></a>`preReceiveSecretDetectionEnabled` | [`Boolean`](#boolean) | Whether the feature is enabled. |

### `Mutation.starProject`

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `StarProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationstarprojectprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | Full path of the project to star or unstar. |
| <a id="mutationstarprojectstarred"></a>`starred` | [`Boolean!`](#boolean) | Indicates whether to star or unstar the project. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationstarprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationstarprojectcount"></a>`count` | [`String!`](#string) | Number of stars for the project. |
| <a id="mutationstarprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.terraformStateDelete`

Input type: `TerraformStateDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatedeleteid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatedeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatedeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.terraformStateLock`

Input type: `TerraformStateLockInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatelockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstatelockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstatelockerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.terraformStateUnlock`

Input type: `TerraformStateUnlockInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstateunlockid"></a>`id` | [`TerraformStateID!`](#terraformstateid) | Global ID of the Terraform state. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationterraformstateunlockclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationterraformstateunlockerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.timelineEventCreate`

DETAILS:
**Introduced** in GitLab 15.6.
**Status**: Experiment.

Input type: `TimelineEventCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventcreateincidentid"></a>`incidentId` | [`IssueID!`](#issueid) | Incident ID of the timeline event. |
| <a id="mutationtimelineeventcreatenote"></a>`note` | [`String!`](#string) | Text note of the timeline event. |
| <a id="mutationtimelineeventcreateoccurredat"></a>`occurredAt` | [`Time!`](#time) | Timestamp of when the event occurred. |
| <a id="mutationtimelineeventcreatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | Tags for the incident timeline event. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventcreatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventDestroy`

Input type: `TimelineEventDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventdestroyid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | Timeline event ID to remove. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventdestroytimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventPromoteFromNote`

Input type: `TimelineEventPromoteFromNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventpromotefromnotenoteid"></a>`noteId` | [`NoteID!`](#noteid) | Note ID from which the timeline event promoted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventpromotefromnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventpromotefromnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventpromotefromnotetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelineEventTagCreate`

Input type: `TimelineEventTagCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventtagcreatename"></a>`name` | [`String!`](#string) | Name of the tag. |
| <a id="mutationtimelineeventtagcreateprojectpath"></a>`projectPath` | [`ID!`](#id) | Project to create the timeline event tag in. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventtagcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventtagcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventtagcreatetimelineeventtag"></a>`timelineEventTag` | [`TimelineEventTagType`](#timelineeventtagtype) | Timeline event tag. |

### `Mutation.timelineEventUpdate`

Input type: `TimelineEventUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventupdateid"></a>`id` | [`IncidentManagementTimelineEventID!`](#incidentmanagementtimelineeventid) | ID of the timeline event to update. |
| <a id="mutationtimelineeventupdatenote"></a>`note` | [`String`](#string) | Text note of the timeline event. |
| <a id="mutationtimelineeventupdateoccurredat"></a>`occurredAt` | [`Time`](#time) | Timestamp when the event occurred. |
| <a id="mutationtimelineeventupdatetimelineeventtagnames"></a>`timelineEventTagNames` | [`[String!]`](#string) | Tags for the incident timeline event. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelineeventupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelineeventupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelineeventupdatetimelineevent"></a>`timelineEvent` | [`TimelineEventType`](#timelineeventtype) | Timeline event. |

### `Mutation.timelogCreate`

Input type: `TimelogCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogcreateissuableid"></a>`issuableId` | [`IssuableID!`](#issuableid) | Global ID of the issuable (Issue, WorkItem or MergeRequest). |
| <a id="mutationtimelogcreatespentat"></a>`spentAt` | [`Time`](#time) | Timestamp of when the time was spent. If empty, defaults to current time. |
| <a id="mutationtimelogcreatesummary"></a>`summary` | [`String!`](#string) | Summary of time spent. |
| <a id="mutationtimelogcreatetimespent"></a>`timeSpent` | [`String!`](#string) | Amount of time spent. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelogcreatetimelog"></a>`timelog` | [`Timelog`](#timelog) | Timelog. |

### `Mutation.timelogDelete`

Input type: `TimelogDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogdeleteid"></a>`id` | [`TimelogID!`](#timelogid) | Global ID of the timelog. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtimelogdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtimelogdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtimelogdeletetimelog"></a>`timelog` | [`Timelog`](#timelog) | Timelog. |

### `Mutation.todoCreate`

Input type: `TodoCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodocreatetargetid"></a>`targetId` | [`TodoableID!`](#todoableid) | Global ID of the to-do item's parent. Issues, merge requests, designs, and epics are supported. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodocreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodocreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodocreatetodo"></a>`todo` | [`Todo`](#todo) | To-do item created. |

### `Mutation.todoMarkDone`

Input type: `TodoMarkDoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodomarkdoneid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to mark as done. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodomarkdoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodomarkdoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodomarkdonetodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoRestore`

Input type: `TodoRestoreInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoreid"></a>`id` | [`TodoID!`](#todoid) | Global ID of the to-do item to restore. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoreclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoreerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodorestoretodo"></a>`todo` | [`Todo!`](#todo) | Requested to-do item. |

### `Mutation.todoRestoreMany`

Input type: `TodoRestoreManyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoremanyids"></a>`ids` | [`[TodoID!]!`](#todoid) | Global IDs of the to-do items to restore (a maximum of 50 is supported at once). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodorestoremanyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodorestoremanyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodorestoremanytodos"></a>`todos` | [`[Todo!]!`](#todo) | Updated to-do items. |

### `Mutation.todosMarkAllDone`

Input type: `TodosMarkAllDoneInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosmarkalldonetargetid"></a>`targetId` | [`TodoableID`](#todoableid) | Global ID of the to-do item's parent. Issues, merge requests, designs, and epics are supported. If argument is omitted, all pending to-do items of the current user are marked as done. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationtodosmarkalldoneclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationtodosmarkalldoneerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationtodosmarkalldonetodos"></a>`todos` | [`[Todo!]!`](#todo) | Updated to-do items. |

### `Mutation.updateAlertStatus`

Input type: `UpdateAlertStatusInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatealertstatusiid"></a>`iid` | [`String!`](#string) | IID of the alert to mutate. |
| <a id="mutationupdatealertstatusprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the alert to mutate is in. |
| <a id="mutationupdatealertstatusstatus"></a>`status` | [`AlertManagementStatus!`](#alertmanagementstatus) | Status to set the alert. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatealertstatusalert"></a>`alert` | [`AlertManagementAlert`](#alertmanagementalert) | Alert after mutation. |
| <a id="mutationupdatealertstatusclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatealertstatuserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatealertstatusissue"></a>`issue` | [`Issue`](#issue) | Issue created after mutation. |
| <a id="mutationupdatealertstatustodo"></a>`todo` | [`Todo`](#todo) | To-do item after mutation. |

### `Mutation.updateBoard`

Input type: `UpdateBoardInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardassigneeid"></a>`assigneeId` | [`UserID`](#userid) | ID of user to be assigned to the board. |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="mutationupdateboardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="mutationupdateboardid"></a>`id` | [`BoardID!`](#boardid) | Board global ID. |
| <a id="mutationupdateboarditerationcadenceid"></a>`iterationCadenceId` | [`IterationsCadenceID`](#iterationscadenceid) | ID of iteration cadence to be assigned to the board. |
| <a id="mutationupdateboarditerationid"></a>`iterationId` | [`IterationID`](#iterationid) | ID of iteration to be assigned to the board. |
| <a id="mutationupdateboardlabelids"></a>`labelIds` | [`[LabelID!]`](#labelid) | IDs of labels to be added to the board. |
| <a id="mutationupdateboardlabels"></a>`labels` | [`[String!]`](#string) | Labels of the issue. |
| <a id="mutationupdateboardmilestoneid"></a>`milestoneId` | [`MilestoneID`](#milestoneid) | ID of milestone to be assigned to the board. |
| <a id="mutationupdateboardname"></a>`name` | [`String`](#string) | Board name. |
| <a id="mutationupdateboardweight"></a>`weight` | [`Int`](#int) | Weight value to be assigned to the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardboard"></a>`board` | [`Board`](#board) | Board after mutation. |
| <a id="mutationupdateboardclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboarderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateBoardEpicUserPreferences`

Input type: `UpdateBoardEpicUserPreferencesInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesboardid"></a>`boardId` | [`BoardID!`](#boardid) | Board global ID. |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | Whether the epic should be collapsed in the board. |
| <a id="mutationupdateboardepicuserpreferencesepicid"></a>`epicId` | [`EpicID!`](#epicid) | ID of an epic to set preferences for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardepicuserpreferencesclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardepicuserpreferencesepicuserpreferences"></a>`epicUserPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | User preferences for the epic in the board after mutation. |
| <a id="mutationupdateboardepicuserpreferenceserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateBoardList`

Input type: `UpdateBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for the user. |
| <a id="mutationupdateboardlistlistid"></a>`listId` | [`ListID!`](#listid) | Global ID of the list. |
| <a id="mutationupdateboardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateboardlistlist"></a>`list` | [`BoardList`](#boardlist) | Mutated list. |

### `Mutation.updateComplianceFramework`

Input type: `UpdateComplianceFrameworkInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecomplianceframeworkid"></a>`id` | [`ComplianceManagementFrameworkID!`](#compliancemanagementframeworkid) | Global ID of the compliance framework to update. |
| <a id="mutationupdatecomplianceframeworkparams"></a>`params` | [`ComplianceFrameworkInput!`](#complianceframeworkinput) | Parameters to update the compliance framework with. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecomplianceframeworkclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecomplianceframeworkcomplianceframework"></a>`complianceFramework` | [`ComplianceFramework`](#complianceframework) | Compliance framework after mutation. |
| <a id="mutationupdatecomplianceframeworkerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateContainerExpirationPolicy`

Input type: `UpdateContainerExpirationPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicycadence"></a>`cadence` | [`ContainerExpirationPolicyCadenceEnum`](#containerexpirationpolicycadenceenum) | This container expiration policy schedule. |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerexpirationpolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether this container expiration policy is enabled. |
| <a id="mutationupdatecontainerexpirationpolicykeepn"></a>`keepN` | [`ContainerExpirationPolicyKeepEnum`](#containerexpirationpolicykeepenum) | Number of tags to retain. |
| <a id="mutationupdatecontainerexpirationpolicynameregex"></a>`nameRegex` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching this regex pattern will expire. |
| <a id="mutationupdatecontainerexpirationpolicynameregexkeep"></a>`nameRegexKeep` | [`UntrustedRegexp`](#untrustedregexp) | Tags with names matching this regex pattern will be preserved. |
| <a id="mutationupdatecontainerexpirationpolicyolderthan"></a>`olderThan` | [`ContainerExpirationPolicyOlderThanEnum`](#containerexpirationpolicyolderthanenum) | Tags older that this will expire. |
| <a id="mutationupdatecontainerexpirationpolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the container expiration policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerexpirationpolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerexpirationpolicycontainerexpirationpolicy"></a>`containerExpirationPolicy` | [`ContainerExpirationPolicy`](#containerexpirationpolicy) | Container expiration policy after mutation. |
| <a id="mutationupdatecontainerexpirationpolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateContainerRegistryProtectionRule`

Updates a container registry protection rule to restrict access to project containers. You can prevent users without certain roles from altering containers. Available only when feature flag `container_registry_protected_containers` is enabled.

DETAILS:
**Introduced** in GitLab 16.7.
**Status**: Experiment.

Input type: `UpdateContainerRegistryProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerregistryprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerregistryprotectionruleid"></a>`id` | [`ContainerRegistryProtectionRuleID!`](#containerregistryprotectionruleid) | Global ID of the container registry protection rule to be updated. |
| <a id="mutationupdatecontainerregistryprotectionruleminimumaccesslevelfordelete"></a>`minimumAccessLevelForDelete` | [`ContainerRegistryProtectionRuleAccessLevel`](#containerregistryprotectionruleaccesslevel) | Minimum GitLab access level allowed to delete container images to the container registry. For example, `MAINTAINER`, `OWNER`, or `ADMIN`. |
| <a id="mutationupdatecontainerregistryprotectionruleminimumaccesslevelforpush"></a>`minimumAccessLevelForPush` | [`ContainerRegistryProtectionRuleAccessLevel`](#containerregistryprotectionruleaccesslevel) | Minimum GitLab access level allowed to push container images to the container registry. For example, `MAINTAINER`, `OWNER`, or `ADMIN`. |
| <a id="mutationupdatecontainerregistryprotectionrulerepositorypathpattern"></a>`repositoryPathPattern` | [`String`](#string) | Container's repository path pattern of the protection rule. For example, `my-scope/my-project/container-dev-*`. Wildcard character `*` allowed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatecontainerregistryprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatecontainerregistryprotectionrulecontainerregistryprotectionrule"></a>`containerRegistryProtectionRule` | [`ContainerRegistryProtectionRule`](#containerregistryprotectionrule) | Container registry protection rule after mutation. |
| <a id="mutationupdatecontainerregistryprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateDependencyProxyImageTtlGroupPolicy`

These settings can be adjusted only by the group Owner.

Input type: `UpdateDependencyProxyImageTtlGroupPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the policy is enabled or disabled. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicygrouppath"></a>`groupPath` | [`ID!`](#id) | Group path for the group dependency proxy image TTL policy. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyttl"></a>`ttl` | [`Int`](#int) | Number of days to retain a cached image file. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicydependencyproxyimagettlpolicy"></a>`dependencyProxyImageTtlPolicy` | [`DependencyProxyImageTtlGroupPolicy`](#dependencyproxyimagettlgrouppolicy) | Group image TTL policy after mutation. |
| <a id="mutationupdatedependencyproxyimagettlgrouppolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateDependencyProxyPackagesSettings`

Updates or creates dependency proxy for packages settings.
Requires the packages and dependency proxy to be enabled in the config.
Requires the packages feature to be enabled at the project level.

Input type: `UpdateDependencyProxyPackagesSettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxypackagessettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the dependency proxy for packages is enabled for the project. |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistrypassword"></a>`mavenExternalRegistryPassword` | [`String`](#string) | Password for the external Maven packages registry. Introduced in 16.5: This feature is an Experiment. It can be changed or removed at any time. |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryurl"></a>`mavenExternalRegistryUrl` | [`String`](#string) | URL for the external Maven packages registry. |
| <a id="mutationupdatedependencyproxypackagessettingsmavenexternalregistryusername"></a>`mavenExternalRegistryUsername` | [`String`](#string) | Username for the external Maven packages registry. |
| <a id="mutationupdatedependencyproxypackagessettingsprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path for the dependency proxy for packages settings. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxypackagessettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxypackagessettingsdependencyproxypackagessetting"></a>`dependencyProxyPackagesSetting` | [`DependencyProxyPackagesSetting`](#dependencyproxypackagessetting) | Dependency proxy for packages settings after mutation. |
| <a id="mutationupdatedependencyproxypackagessettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateDependencyProxySettings`

These settings can be adjusted only by the group Owner.

Input type: `UpdateDependencyProxySettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxysettingsenabled"></a>`enabled` | [`Boolean`](#boolean) | Indicates whether the policy is enabled or disabled. |
| <a id="mutationupdatedependencyproxysettingsgrouppath"></a>`groupPath` | [`ID!`](#id) | Group path for the group dependency proxy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatedependencyproxysettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatedependencyproxysettingsdependencyproxysetting"></a>`dependencyProxySetting` | [`DependencyProxySetting`](#dependencyproxysetting) | Group dependency proxy settings after mutation. |
| <a id="mutationupdatedependencyproxysettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateEpic`

Input type: `UpdateEpicInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the epic. |
| <a id="mutationupdateepicaddlabels"></a>`addLabels` | [`[String!]`](#string) | Array of labels to be added to the epic. |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepiccolor"></a>`color` | [`Color`](#color) | Color of the epic. Available only when feature flag `epic_color_highlight` is enabled. This flag is disabled by default, because the feature is experimental and is subject to change without notice. |
| <a id="mutationupdateepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="mutationupdateepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="mutationupdateepicduedatefixed"></a>`dueDateFixed` | [`String`](#string) | End date of the epic. |
| <a id="mutationupdateepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates end date should be sourced from due_date_fixed field not the issue milestones. |
| <a id="mutationupdateepicgrouppath"></a>`groupPath` | [`ID!`](#id) | Group the epic to mutate is in. |
| <a id="mutationupdateepiciid"></a>`iid` | [`ID!`](#id) | IID of the epic to mutate. |
| <a id="mutationupdateepicremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the epic. |
| <a id="mutationupdateepicremovelabels"></a>`removeLabels` | [`[String!]`](#string) | Array of labels to be removed from the epic. |
| <a id="mutationupdateepicstartdatefixed"></a>`startDateFixed` | [`String`](#string) | Start date of the epic. |
| <a id="mutationupdateepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates start date should be sourced from start_date_fixed field not the issue milestones. |
| <a id="mutationupdateepicstateevent"></a>`stateEvent` | [`EpicStateEvent`](#epicstateevent) | State event for the epic. |
| <a id="mutationupdateepictitle"></a>`title` | [`String`](#string) | Title of the epic. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicepic"></a>`epic` | [`Epic`](#epic) | Epic after mutation. |
| <a id="mutationupdateepicerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.updateEpicBoardList`

Input type: `UpdateEpicBoardListInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicboardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for the user. |
| <a id="mutationupdateepicboardlistlistid"></a>`listId` | [`BoardsEpicListID!`](#boardsepiclistid) | Global ID of the epic list. |
| <a id="mutationupdateepicboardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateepicboardlistclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateepicboardlisterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateepicboardlistlist"></a>`list` | [`EpicList`](#epiclist) | Mutated epic list. |

### `Mutation.updateImageDiffNote`

Updates a DiffNote on an image (a `Note` where the `position.positionType` is `"image"`).
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `UpdateImageDiffNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnotebody"></a>`body` | [`String`](#string) | Content of the note. |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateimagediffnoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to update. |
| <a id="mutationupdateimagediffnoteposition"></a>`position` | [`UpdateDiffImagePositionInput`](#updatediffimagepositioninput) | Position of the note on a diff. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateimagediffnoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateimagediffnoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateimagediffnotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.updateIssue`

Input type: `UpdateIssueInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueaddlabelids"></a>`addLabelIds` | [`[ID!]`](#id) | IDs of labels to be added to the issue. |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateissueconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates the issue is confidential. |
| <a id="mutationupdateissuedescription"></a>`description` | [`String`](#string) | Description of the issue. |
| <a id="mutationupdateissueduedate"></a>`dueDate` | [`ISO8601Date`](#iso8601date) | Due date of the issue. |
| <a id="mutationupdateissueepicid"></a>`epicId` | [`EpicID`](#epicid) | ID of the parent epic. NULL when removing the association. |
| <a id="mutationupdateissuehealthstatus"></a>`healthStatus` | [`HealthStatus`](#healthstatus) | Desired health status. |
| <a id="mutationupdateissueiid"></a>`iid` | [`String!`](#string) | IID of the issue to mutate. |
| <a id="mutationupdateissuelabelids"></a>`labelIds` | [`[ID!]`](#id) | IDs of labels to be set. Replaces existing issue labels. |
| <a id="mutationupdateissuelocked"></a>`locked` | [`Boolean`](#boolean) | Indicates discussion is locked on the issue. |
| <a id="mutationupdateissuemilestoneid"></a>`milestoneId` | [`ID`](#id) | ID of the milestone to assign to the issue. On update milestone will be removed if set to null. |
| <a id="mutationupdateissueprojectpath"></a>`projectPath` | [`ID!`](#id) | Project the issue to mutate is in. |
| <a id="mutationupdateissueremovelabelids"></a>`removeLabelIds` | [`[ID!]`](#id) | IDs of labels to be removed from the issue. |
| <a id="mutationupdateissuestateevent"></a>`stateEvent` | [`IssueStateEvent`](#issuestateevent) | Close or reopen an issue. |
| <a id="mutationupdateissuetimeestimate"></a>`timeEstimate` | [`String`](#string) | Estimated time to complete the issue. Use `null` or `0` to remove the current estimate. |
| <a id="mutationupdateissuetitle"></a>`title` | [`String`](#string) | Title of the issue. |
| <a id="mutationupdateissuetype"></a>`type` | [`IssueType`](#issuetype) | Type of the issue. |
| <a id="mutationupdateissueweight"></a>`weight` | [`Int`](#int) | Weight of the issue. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateissueclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateissueerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateissueissue"></a>`issue` | [`Issue`](#issue) | Issue after mutation. |

### `Mutation.updateIteration`

Input type: `UpdateIterationInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateiterationdescription"></a>`description` | [`String`](#string) | Description of the iteration. |
| <a id="mutationupdateiterationduedate"></a>`dueDate` | [`String`](#string) | End date of the iteration. |
| <a id="mutationupdateiterationgrouppath"></a>`groupPath` | [`ID!`](#id) | Group of the iteration. |
| <a id="mutationupdateiterationid"></a>`id` | [`ID!`](#id) | Global ID of the iteration. |
| <a id="mutationupdateiterationstartdate"></a>`startDate` | [`String`](#string) | Start date of the iteration. |
| <a id="mutationupdateiterationtitle"></a>`title` | [`String`](#string) | Title of the iteration. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdateiterationclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdateiterationerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdateiterationiteration"></a>`iteration` | [`Iteration`](#iteration) | Updated iteration. |

### `Mutation.updateNamespacePackageSettings`

These settings can be adjusted only by the group Owner.

Input type: `UpdateNamespacePackageSettingsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicateexceptionregex"></a>`genericDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When generic_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsgenericduplicatesallowed"></a>`genericDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate generic packages are allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingslockmavenpackagerequestsforwarding"></a>`lockMavenPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether Maven package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingslocknpmpackagerequestsforwarding"></a>`lockNpmPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether npm package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingslockpypipackagerequestsforwarding"></a>`lockPypiPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether PyPI package forwarding is locked for all descendent namespaces. |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicateexceptionregex"></a>`mavenDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When maven_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsmavenduplicatesallowed"></a>`mavenDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate Maven packages are allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingsmavenpackagerequestsforwarding"></a>`mavenPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether Maven package forwarding is allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingsnamespacepath"></a>`namespacePath` | [`ID!`](#id) | Namespace path where the namespace package setting is located. |
| <a id="mutationupdatenamespacepackagesettingsnpmpackagerequestsforwarding"></a>`npmPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether npm package forwarding is allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicateexceptionregex"></a>`nugetDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When nuget_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsnugetduplicatesallowed"></a>`nugetDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate NuGet packages are allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingsnugetsymbolserverenabled"></a>`nugetSymbolServerEnabled` | [`Boolean`](#boolean) | Indicates wheather the NuGet symbol server is enabled for this namespace. |
| <a id="mutationupdatenamespacepackagesettingspypipackagerequestsforwarding"></a>`pypiPackageRequestsForwarding` | [`Boolean`](#boolean) | Indicates whether PyPI package forwarding is allowed for this namespace. |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicateexceptionregex"></a>`terraformModuleDuplicateExceptionRegex` | [`UntrustedRegexp`](#untrustedregexp) | When terraform_module_duplicates_allowed is false, you can publish duplicate packages with names that match this regex. Otherwise, this setting has no effect. |
| <a id="mutationupdatenamespacepackagesettingsterraformmoduleduplicatesallowed"></a>`terraformModuleDuplicatesAllowed` | [`Boolean`](#boolean) | Indicates whether duplicate Terraform packages are allowed for this namespace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenamespacepackagesettingsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenamespacepackagesettingserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatenamespacepackagesettingspackagesettings"></a>`packageSettings` | [`PackageSettings`](#packagesettings) | Namespace package setting after mutation. |

### `Mutation.updateNote`

Updates a Note.
If the body of the Note contains only quick actions,
the Note will be destroyed during an update, and no Note will be
returned.

Input type: `UpdateNoteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenotebody"></a>`body` | [`String`](#string) | Content of the note. |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenoteconfidential"></a>`confidential` **{warning-solid}** | [`Boolean`](#boolean) | **Deprecated:** No longer allowed to update confidentiality of notes. Deprecated in GitLab 14.10. |
| <a id="mutationupdatenoteid"></a>`id` | [`NoteID!`](#noteid) | Global ID of the note to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatenoteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatenoteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatenotenote"></a>`note` | [`Note`](#note) | Note after mutation. |

### `Mutation.updatePackagesCleanupPolicy`

Input type: `UpdatePackagesCleanupPolicyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagescleanuppolicykeepnduplicatedpackagefiles"></a>`keepNDuplicatedPackageFiles` | [`PackagesCleanupKeepDuplicatedPackageFilesEnum`](#packagescleanupkeepduplicatedpackagefilesenum) | Number of duplicated package files to retain. |
| <a id="mutationupdatepackagescleanuppolicyprojectpath"></a>`projectPath` | [`ID!`](#id) | Project path where the packages cleanup policy is located. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagescleanuppolicyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagescleanuppolicyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatepackagescleanuppolicypackagescleanuppolicy"></a>`packagesCleanupPolicy` | [`PackagesCleanupPolicy`](#packagescleanuppolicy) | Packages cleanup policy after mutation. |

### `Mutation.updatePackagesProtectionRule`

Updates a package protection rule to restrict access to project packages. You can prevent users without certain permissions from altering packages. Available only when feature flag `packages_protected_packages` is enabled.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `UpdatePackagesProtectionRuleInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagesprotectionruleid"></a>`id` | [`PackagesProtectionRuleID!`](#packagesprotectionruleid) | Global ID of the package protection rule to be updated. |
| <a id="mutationupdatepackagesprotectionrulepackagenamepattern"></a>`packageNamePattern` | [`String`](#string) | Package name protected by the protection rule. For example, `@my-scope/my-package-*`. Wildcard character `*` allowed. |
| <a id="mutationupdatepackagesprotectionrulepackagetype"></a>`packageType` | [`PackagesProtectionRulePackageType`](#packagesprotectionrulepackagetype) | Package type protected by the protection rule. For example, `NPM`. |
| <a id="mutationupdatepackagesprotectionrulepushprotecteduptoaccesslevel"></a>`pushProtectedUpToAccessLevel` | [`PackagesProtectionRuleAccessLevel`](#packagesprotectionruleaccesslevel) | Maximum GitLab access level unable to push a package. For example, `DEVELOPER`, `MAINTAINER`, `OWNER`. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatepackagesprotectionruleclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatepackagesprotectionruleerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatepackagesprotectionrulepackageprotectionrule"></a>`packageProtectionRule` | [`PackagesProtectionRule`](#packagesprotectionrule) | Packages protection rule after mutation. |

### `Mutation.updateRequirement`

Input type: `UpdateRequirementInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdaterequirementdescription"></a>`description` | [`String`](#string) | Description of the requirement. |
| <a id="mutationupdaterequirementiid"></a>`iid` **{warning-solid}** | [`String`](#string) | **Deprecated:** Use work_item_iid instead. Deprecated in GitLab 15.8. |
| <a id="mutationupdaterequirementlasttestreportstate"></a>`lastTestReportState` | [`TestReportState`](#testreportstate) | Creates a test report for the requirement with the given state. |
| <a id="mutationupdaterequirementprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path the requirement is associated with. |
| <a id="mutationupdaterequirementstate"></a>`state` | [`RequirementState`](#requirementstate) | State of the requirement. |
| <a id="mutationupdaterequirementtitle"></a>`title` | [`String`](#string) | Title of the requirement. |
| <a id="mutationupdaterequirementworkitemiid"></a>`workItemIid` | [`String`](#string) | IID of the requirement work item to update. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdaterequirementclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdaterequirementerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdaterequirementrequirement"></a>`requirement` | [`Requirement`](#requirement) | Requirement after mutation. |

### `Mutation.updateSnippet`

Input type: `UpdateSnippetInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetblobactions"></a>`blobActions` | [`[SnippetBlobActionInputType!]`](#snippetblobactioninputtype) | Actions to perform over the snippet repository and blobs. |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatesnippetdescription"></a>`description` | [`String`](#string) | Description of the snippet. |
| <a id="mutationupdatesnippetid"></a>`id` | [`SnippetID!`](#snippetid) | Global ID of the snippet to update. |
| <a id="mutationupdatesnippettitle"></a>`title` | [`String`](#string) | Title of the snippet. |
| <a id="mutationupdatesnippetvisibilitylevel"></a>`visibilityLevel` | [`VisibilityLevelsEnum`](#visibilitylevelsenum) | Visibility level of the snippet. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationupdatesnippetclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationupdatesnippeterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationupdatesnippetsnippet"></a>`snippet` | [`Snippet`](#snippet) | Snippet after mutation. |

### `Mutation.uploadDelete`

Deletes an upload.

Input type: `UploadDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuploaddeletefilename"></a>`filename` | [`String!`](#string) | Upload filename. |
| <a id="mutationuploaddeletegrouppath"></a>`groupPath` | [`ID`](#id) | Full path of the group with which the resource is associated. |
| <a id="mutationuploaddeleteprojectpath"></a>`projectPath` | [`ID`](#id) | Full path of the project with which the resource is associated. |
| <a id="mutationuploaddeletesecret"></a>`secret` | [`String!`](#string) | Secret part of upload path. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuploaddeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuploaddeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuploaddeleteupload"></a>`upload` | [`FileUpload`](#fileupload) | Deleted upload. |

### `Mutation.userAchievementPrioritiesUpdate`

DETAILS:
**Introduced** in GitLab 16.5.
**Status**: Experiment.

Input type: `UserAchievementPrioritiesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementprioritiesupdateuserachievementids"></a>`userAchievementIds` | [`[AchievementsUserAchievementID!]!`](#achievementsuserachievementid) | Global IDs of the user achievements being prioritized, ordered from highest to lowest priority. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementprioritiesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementprioritiesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuserachievementprioritiesupdateuserachievements"></a>`userAchievements` | [`[UserAchievement!]!`](#userachievement) | Updated user achievements. |

### `Mutation.userAchievementsDelete`

DETAILS:
**Introduced** in GitLab 16.1.
**Status**: Experiment.

Input type: `UserAchievementsDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementsdeleteuserachievementid"></a>`userAchievementId` | [`AchievementsUserAchievementID!`](#achievementsuserachievementid) | Global ID of the user achievement being deleted. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserachievementsdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserachievementsdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuserachievementsdeleteuserachievement"></a>`userAchievement` | [`UserAchievement`](#userachievement) | Deleted user achievement. |

### `Mutation.userAddOnAssignmentBulkCreate`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `UserAddOnAssignmentBulkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase to be assigned to. |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkcreateuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of user to be assigned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentbulkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.userAddOnAssignmentBulkRemove`

DETAILS:
**Introduced** in GitLab 16.11.
**Status**: Experiment.

Input type: `UserAddOnAssignmentBulkRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase to be unassigned from. |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkremoveuserids"></a>`userIds` | [`[UserID!]!`](#userid) | Global IDs of user to be unassigned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentbulkremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentbulkremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentbulkremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.userAddOnAssignmentCreate`

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `UserAddOnAssignmentCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase to be assigned to. |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentcreateuserid"></a>`userId` | [`UserID!`](#userid) | Global ID of user to be assigned. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentcreateaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuseraddonassignmentcreateuser"></a>`user` | [`AddOnUser`](#addonuser) | User who the add-on purchase was assigned to. |

### `Mutation.userAddOnAssignmentRemove`

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `UserAddOnAssignmentRemoveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchaseid"></a>`addOnPurchaseId` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | Global ID of AddOnPurchase assignment belongs to. |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentremoveuserid"></a>`userId` | [`UserID!`](#userid) | Global ID of user whose assignment will be removed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuseraddonassignmentremoveaddonpurchase"></a>`addOnPurchase` | [`AddOnPurchase`](#addonpurchase) | AddOnPurchase state after mutation. |
| <a id="mutationuseraddonassignmentremoveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuseraddonassignmentremoveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuseraddonassignmentremoveuser"></a>`user` | [`AddOnUser`](#addonuser) | User that the add-on was removed from. |

### `Mutation.userCalloutCreate`

Input type: `UserCalloutCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusercalloutcreatefeaturename"></a>`featureName` | [`String!`](#string) | Feature name you want to dismiss the callout for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusercalloutcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusercalloutcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationusercalloutcreateusercallout"></a>`userCallout` | [`UserCallout!`](#usercallout) | User callout dismissed. |

### `Mutation.userPreferencesUpdate`

Input type: `UserPreferencesUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserpreferencesupdateextensionsmarketplaceoptinstatus"></a>`extensionsMarketplaceOptInStatus` | [`ExtensionsMarketplaceOptInStatus`](#extensionsmarketplaceoptinstatus) | Status of the Web IDE Extension Marketplace opt-in for the user. |
| <a id="mutationuserpreferencesupdateissuessort"></a>`issuesSort` | [`IssueSort`](#issuesort) | Sort order for issue lists. |
| <a id="mutationuserpreferencesupdateusewebideextensionmarketplace"></a>`useWebIdeExtensionMarketplace` | [`Boolean`](#boolean) | Whether Web IDE Extension Marketplace is enabled for the user. |
| <a id="mutationuserpreferencesupdatevisibilitypipelineidtype"></a>`visibilityPipelineIdType` | [`VisibilityPipelineIdType`](#visibilitypipelineidtype) | Determines whether the pipeline list shows ID or IID. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationuserpreferencesupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationuserpreferencesupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationuserpreferencesupdateuserpreferences"></a>`userPreferences` | [`UserPreferences`](#userpreferences) | User preferences after mutation. |

### `Mutation.userSetNamespaceCommitEmail`

Input type: `UserSetNamespaceCommitEmailInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusersetnamespacecommitemailemailid"></a>`emailId` | [`EmailID`](#emailid) | ID of the email to set. |
| <a id="mutationusersetnamespacecommitemailnamespaceid"></a>`namespaceId` | [`NamespaceID!`](#namespaceid) | ID of the namespace to set the namespace commit email for. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationusersetnamespacecommitemailclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationusersetnamespacecommitemailerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationusersetnamespacecommitemailnamespacecommitemail"></a>`namespaceCommitEmail` | [`NamespaceCommitEmail`](#namespacecommitemail) | User namespace commit email after mutation. |

### `Mutation.valueStreamCreate`

Creates a value stream.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `ValueStreamCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamcreatename"></a>`name` | [`String!`](#string) | Value stream name. |
| <a id="mutationvaluestreamcreatenamespacepath"></a>`namespacePath` | [`ID!`](#id) | Full path of the namespace(project or group) the value stream is created in. |
| <a id="mutationvaluestreamcreatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | Value stream configuration. |
| <a id="mutationvaluestreamcreatestages"></a>`stages` | [`[ValueStreamStageInput!]`](#valuestreamstageinput) | Value stream custom stages. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvaluestreamcreatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | Created value stream. |

### `Mutation.valueStreamDestroy`

Destroy a value stream.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `ValueStreamDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamdestroyid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | Global ID of the value stream to destroy. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvaluestreamdestroyvaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | Value stream deleted after mutation. |

### `Mutation.valueStreamUpdate`

Updates a value stream.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Input type: `ValueStreamUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamupdateid"></a>`id` | [`AnalyticsCycleAnalyticsValueStreamID!`](#analyticscycleanalyticsvaluestreamid) | Global ID of the value stream to update. |
| <a id="mutationvaluestreamupdatename"></a>`name` | [`String`](#string) | Value stream name. |
| <a id="mutationvaluestreamupdatesetting"></a>`setting` | [`ValueStreamSettingInput`](#valuestreamsettinginput) | Value stream configuration. |
| <a id="mutationvaluestreamupdatestages"></a>`stages` | [`[ValueStreamStageInput!]`](#valuestreamstageinput) | Value stream custom stages. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvaluestreamupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvaluestreamupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvaluestreamupdatevaluestream"></a>`valueStream` | [`ValueStream`](#valuestream) | Updated value stream. |

### `Mutation.vulnerabilitiesDismiss`

Input type: `VulnerabilitiesDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesdismisscomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was dismissed (maximum 50,000 characters). |
| <a id="mutationvulnerabilitiesdismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why vulnerability should be dismissed. |
| <a id="mutationvulnerabilitiesdismissvulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | IDs of the vulnerabilities to be dismissed (maximum 100 entries). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesdismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesdismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilitiesdismissvulnerabilities"></a>`vulnerabilities` | [`[Vulnerability!]!`](#vulnerability) | Vulnerabilities after state change. |

### `Mutation.vulnerabilitiesRemoveAllFromProject`

Remove all Vulnerabilities and related information from a given project. [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/412602) in GitLab 16.7.

Input type: `VulnerabilitiesRemoveAllFromProjectInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojectids"></a>`projectIds` | [`[ProjectID!]!`](#projectid) | IDs of project for which all Vulnerabilities should be removed. The deletion will happen in the background so the changes will not be visible immediately. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitiesremoveallfromprojectclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitiesremoveallfromprojecterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilitiesremoveallfromprojectprojects"></a>`projects` | [`[Project!]!`](#project) | Projects for which the deletion was scheduled. |

### `Mutation.vulnerabilityConfirm`

Input type: `VulnerabilityConfirmInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityconfirmcomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was confirmed (maximum 50,000 characters). |
| <a id="mutationvulnerabilityconfirmid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be confirmed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityconfirmclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityconfirmerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityconfirmvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityCreate`

Input type: `VulnerabilityCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitycreateconfirmedat"></a>`confirmedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to confirmed (defaults to creation time if status is `confirmed`). |
| <a id="mutationvulnerabilitycreatedescription"></a>`description` | [`String!`](#string) | Long text section that describes the vulnerability in more detail. |
| <a id="mutationvulnerabilitycreatedetectedat"></a>`detectedAt` | [`Time`](#time) | Timestamp of when the vulnerability was first detected (defaults to creation time). |
| <a id="mutationvulnerabilitycreatedismissedat"></a>`dismissedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to dismissed (defaults to creation time if status is `dismissed`). |
| <a id="mutationvulnerabilitycreateidentifiers"></a>`identifiers` | [`[VulnerabilityIdentifierInput!]!`](#vulnerabilityidentifierinput) | Array of CVE or CWE identifiers for the vulnerability. |
| <a id="mutationvulnerabilitycreatename"></a>`name` | [`String!`](#string) | Name of the vulnerability. |
| <a id="mutationvulnerabilitycreateproject"></a>`project` | [`ProjectID!`](#projectid) | ID of the project to attach the vulnerability to. |
| <a id="mutationvulnerabilitycreateresolvedat"></a>`resolvedAt` | [`Time`](#time) | Timestamp of when the vulnerability state changed to resolved (defaults to creation time if status is `resolved`). |
| <a id="mutationvulnerabilitycreatescanner"></a>`scanner` | [`VulnerabilityScannerInput!`](#vulnerabilityscannerinput) | Information about the scanner used to discover the vulnerability. |
| <a id="mutationvulnerabilitycreateseverity"></a>`severity` | [`VulnerabilitySeverity`](#vulnerabilityseverity) | Severity of the vulnerability (defaults to `unknown`). |
| <a id="mutationvulnerabilitycreatesolution"></a>`solution` | [`String`](#string) | Instructions for how to fix the vulnerability. |
| <a id="mutationvulnerabilitycreatestate"></a>`state` | [`VulnerabilityState`](#vulnerabilitystate) | State of the vulnerability (defaults to `detected`). |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitycreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitycreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilitycreatevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability created. |

### `Mutation.vulnerabilityDismiss`

Input type: `VulnerabilityDismissInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismisscomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was dismissed (maximum 50,000 characters). |
| <a id="mutationvulnerabilitydismissdismissalreason"></a>`dismissalReason` | [`VulnerabilityDismissalReason`](#vulnerabilitydismissalreason) | Reason why vulnerability should be dismissed. |
| <a id="mutationvulnerabilitydismissid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be dismissed. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilitydismissclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilitydismisserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilitydismissvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityExternalIssueLinkCreate`

Input type: `VulnerabilityExternalIssueLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternaltracker"></a>`externalTracker` | [`VulnerabilityExternalIssueLinkExternalTracker!`](#vulnerabilityexternalissuelinkexternaltracker) | External tracker type of the external issue link. |
| <a id="mutationvulnerabilityexternalissuelinkcreateid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability. |
| <a id="mutationvulnerabilityexternalissuelinkcreatelinktype"></a>`linkType` | [`VulnerabilityExternalIssueLinkType!`](#vulnerabilityexternalissuelinktype) | Type of the external issue link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkcreateexternalissuelink"></a>`externalIssueLink` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | Created external issue link. |

### `Mutation.vulnerabilityExternalIssueLinkDestroy`

Input type: `VulnerabilityExternalIssueLinkDestroyInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkdestroyid"></a>`id` | [`VulnerabilitiesExternalIssueLinkID!`](#vulnerabilitiesexternalissuelinkid) | Global ID of the vulnerability external issue link. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityexternalissuelinkdestroyclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityexternalissuelinkdestroyerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `Mutation.vulnerabilityIssueLinkCreate`

Input type: `VulnerabilityIssueLinkCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateissueid"></a>`issueId` | [`IssueID!`](#issueid) | ID of the issue to link to. |
| <a id="mutationvulnerabilityissuelinkcreatevulnerabilityids"></a>`vulnerabilityIds` | [`[VulnerabilityID!]!`](#vulnerabilityid) | IDs of vulnerabilities to link to the given issue. Up to 100 can be provided. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityissuelinkcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityissuelinkcreateissuelinks"></a>`issueLinks` | [`[VulnerabilityIssueLink!]`](#vulnerabilityissuelink) | Created issue links. |

### `Mutation.vulnerabilityResolve`

Input type: `VulnerabilityResolveInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityresolvecomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was resolved (maximum 50,000 characters). |
| <a id="mutationvulnerabilityresolveid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be resolved. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityresolveclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityresolveerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityresolvevulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.vulnerabilityRevertToDetected`

Input type: `VulnerabilityRevertToDetectedInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityreverttodetectedcomment"></a>`comment` | [`String`](#string) | Comment why vulnerability was reverted to detected (maximum 50,000 characters). |
| <a id="mutationvulnerabilityreverttodetectedid"></a>`id` | [`VulnerabilityID!`](#vulnerabilityid) | ID of the vulnerability to be reverted to detected. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationvulnerabilityreverttodetectedclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationvulnerabilityreverttodetectederrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationvulnerabilityreverttodetectedvulnerability"></a>`vulnerability` | [`Vulnerability`](#vulnerability) | Vulnerability after state change. |

### `Mutation.workItemAddLinkedItems`

Add linked items to the work item.

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `WorkItemAddLinkedItemsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemaddlinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemaddlinkeditemslinktype"></a>`linkType` | [`WorkItemRelatedLinkType`](#workitemrelatedlinktype) | Type of link. Defaults to `RELATED`. |
| <a id="mutationworkitemaddlinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | Global IDs of the items to link. Maximum number of IDs you can provide: 10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemaddlinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemaddlinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemaddlinkeditemsmessage"></a>`message` | [`String`](#string) | Linked items update result message. |
| <a id="mutationworkitemaddlinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemConvert`

Converts the work item to a new type.

DETAILS:
**Introduced** in GitLab 15.11.
**Status**: Experiment.

Input type: `WorkItemConvertInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemconvertid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemconvertworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | Global ID of the new work item type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemconvertclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemconverterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemconvertworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemCreate`

Creates a work item.

DETAILS:
**Introduced** in GitLab 15.1.
**Status**: Experiment.

Input type: `WorkItemCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | Input for assignees widget. |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | Input for color widget. |
| <a id="mutationworkitemcreateconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the work item confidentiality. |
| <a id="mutationworkitemcreatedescription"></a>`description` **{warning-solid}** | [`String`](#string) | **Deprecated:** use description widget instead. Deprecated in GitLab 16.9. |
| <a id="mutationworkitemcreatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | Input for description widget. |
| <a id="mutationworkitemcreatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | Input for health status widget. |
| <a id="mutationworkitemcreatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyCreateInput`](#workitemwidgethierarchycreateinput) | Input for hierarchy widget. |
| <a id="mutationworkitemcreateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | Iteration widget of the work item. |
| <a id="mutationworkitemcreatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsCreateInput`](#workitemwidgetlabelscreateinput) | Input for labels widget. |
| <a id="mutationworkitemcreatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | Input for milestone widget. |
| <a id="mutationworkitemcreatenamespacepath"></a>`namespacePath` | [`ID`](#id) | Full path of the namespace(project or group) the work item is created in. |
| <a id="mutationworkitemcreateprojectpath"></a>`projectPath` **{warning-solid}** | [`ID`](#id) | **Deprecated:** Please use namespace_path instead. That will cover for both projects and groups. Deprecated in GitLab 15.10. |
| <a id="mutationworkitemcreaterolledupdateswidget"></a>`rolledupDatesWidget` **{warning-solid}** | [`WorkItemWidgetRolledupDatesInput`](#workitemwidgetrolledupdatesinput) | **Deprecated:** **Status**: Experiment. Introduced in GitLab 16.9. |
| <a id="mutationworkitemcreatetitle"></a>`title` | [`String!`](#string) | Title of the work item. |
| <a id="mutationworkitemcreateworkitemtypeid"></a>`workItemTypeId` | [`WorkItemsTypeID!`](#workitemstypeid) | Global ID of a work item type. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemcreateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Created work item. |

### `Mutation.workItemCreateFromTask`

Creates a work item from a task in another work item's description.

DETAILS:
**Introduced** in GitLab 15.1.
**Status**: Experiment.

Input type: `WorkItemCreateFromTaskInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatefromtaskid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemcreatefromtaskworkitemdata"></a>`workItemData` | [`WorkItemConvertTaskInput!`](#workitemconverttaskinput) | Arguments necessary to convert a task into a work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemcreatefromtaskclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemcreatefromtaskerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemcreatefromtasknewworkitem"></a>`newWorkItem` | [`WorkItem`](#workitem) | New work item created from task. |
| <a id="mutationworkitemcreatefromtaskworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemDelete`

Deletes a work item.

DETAILS:
**Introduced** in GitLab 15.1.
**Status**: Experiment.

Input type: `WorkItemDeleteInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeleteid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemdeleteclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemdeleteerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemdeletenamespace"></a>`namespace` | [`Namespace`](#namespace) | Namespace the deleted work item belonged to. |
| <a id="mutationworkitemdeleteproject"></a>`project` **{warning-solid}** | [`Project`](#project) | **Deprecated:** Use `namespace`. Deprecated in GitLab 16.9. |

### `Mutation.workItemExport`

DETAILS:
**Introduced** in GitLab 15.10.
**Status**: Experiment.

Input type: `WorkItemExportInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportauthorusername"></a>`authorUsername` **{warning-solid}** | [`String`](#string) | **Deprecated:** **Status**: Experiment. Introduced in GitLab 15.9. |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemexportiids"></a>`iids` | [`[String!]`](#string) | List of IIDs of work items. For example, `["1", "2"]`. |
| <a id="mutationworkitemexportin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="mutationworkitemexportprojectpath"></a>`projectPath` | [`ID!`](#id) | Full project path. |
| <a id="mutationworkitemexportsearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="mutationworkitemexportselectedfields"></a>`selectedFields` | [`[AvailableExportFields!]`](#availableexportfields) | List of selected fields to be exported. Omit to export all available fields. |
| <a id="mutationworkitemexportstate"></a>`state` | [`IssuableState`](#issuablestate) | Current state of the work item. |
| <a id="mutationworkitemexporttypes"></a>`types` | [`[IssueType!]`](#issuetype) | Filter work items by the given work item types. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemexportclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemexporterrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemexportmessage"></a>`message` | [`String`](#string) | Export request result message. |

### `Mutation.workItemRemoveLinkedItems`

Remove items linked to the work item.

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `WorkItemRemoveLinkedItemsInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemremovelinkeditemsid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemremovelinkeditemsworkitemsids"></a>`workItemsIds` | [`[WorkItemID!]!`](#workitemid) | Global IDs of the items to unlink. Maximum number of IDs you can provide: 10. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemremovelinkeditemsclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemremovelinkeditemserrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemremovelinkeditemsmessage"></a>`message` | [`String`](#string) | Linked items update result message. |
| <a id="mutationworkitemremovelinkeditemsworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workItemSubscribe`

DETAILS:
**Introduced** in GitLab 16.3.
**Status**: Experiment.

Input type: `WorkItemSubscribeInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemsubscribeid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemsubscribesubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Desired state of the subscription. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemsubscribeclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemsubscribeerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemsubscribeworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Work item after mutation. |

### `Mutation.workItemUpdate`

Updates a work item by Global ID.

DETAILS:
**Introduced** in GitLab 15.1.
**Status**: Experiment.

Input type: `WorkItemUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateassigneeswidget"></a>`assigneesWidget` | [`WorkItemWidgetAssigneesInput`](#workitemwidgetassigneesinput) | Input for assignees widget. |
| <a id="mutationworkitemupdateawardemojiwidget"></a>`awardEmojiWidget` | [`WorkItemWidgetAwardEmojiUpdateInput`](#workitemwidgetawardemojiupdateinput) | Input for emoji reactions widget. |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdatecolorwidget"></a>`colorWidget` | [`WorkItemWidgetColorInput`](#workitemwidgetcolorinput) | Input for color widget. |
| <a id="mutationworkitemupdateconfidential"></a>`confidential` | [`Boolean`](#boolean) | Sets the work item confidentiality. |
| <a id="mutationworkitemupdatecurrentusertodoswidget"></a>`currentUserTodosWidget` | [`WorkItemWidgetCurrentUserTodosInput`](#workitemwidgetcurrentusertodosinput) | Input for to-dos widget. |
| <a id="mutationworkitemupdatedescriptionwidget"></a>`descriptionWidget` | [`WorkItemWidgetDescriptionInput`](#workitemwidgetdescriptioninput) | Input for description widget. |
| <a id="mutationworkitemupdatehealthstatuswidget"></a>`healthStatusWidget` | [`WorkItemWidgetHealthStatusInput`](#workitemwidgethealthstatusinput) | Input for health status widget. |
| <a id="mutationworkitemupdatehierarchywidget"></a>`hierarchyWidget` | [`WorkItemWidgetHierarchyUpdateInput`](#workitemwidgethierarchyupdateinput) | Input for hierarchy widget. |
| <a id="mutationworkitemupdateid"></a>`id` | [`WorkItemID!`](#workitemid) | Global ID of the work item. |
| <a id="mutationworkitemupdateiterationwidget"></a>`iterationWidget` | [`WorkItemWidgetIterationInput`](#workitemwidgetiterationinput) | Input for iteration widget. |
| <a id="mutationworkitemupdatelabelswidget"></a>`labelsWidget` | [`WorkItemWidgetLabelsUpdateInput`](#workitemwidgetlabelsupdateinput) | Input for labels widget. |
| <a id="mutationworkitemupdatemilestonewidget"></a>`milestoneWidget` | [`WorkItemWidgetMilestoneInput`](#workitemwidgetmilestoneinput) | Input for milestone widget. |
| <a id="mutationworkitemupdatenoteswidget"></a>`notesWidget` | [`WorkItemWidgetNotesInput`](#workitemwidgetnotesinput) | Input for notes widget. |
| <a id="mutationworkitemupdatenotificationswidget"></a>`notificationsWidget` | [`WorkItemWidgetNotificationsUpdateInput`](#workitemwidgetnotificationsupdateinput) | Input for notifications widget. |
| <a id="mutationworkitemupdateprogresswidget"></a>`progressWidget` | [`WorkItemWidgetProgressInput`](#workitemwidgetprogressinput) | Input for progress widget. |
| <a id="mutationworkitemupdaterolledupdateswidget"></a>`rolledupDatesWidget` **{warning-solid}** | [`WorkItemWidgetRolledupDatesInput`](#workitemwidgetrolledupdatesinput) | **Deprecated:** **Status**: Experiment. Introduced in GitLab 16.9. |
| <a id="mutationworkitemupdatestartandduedatewidget"></a>`startAndDueDateWidget` | [`WorkItemWidgetStartAndDueDateUpdateInput`](#workitemwidgetstartandduedateupdateinput) | Input for start and due date widget. |
| <a id="mutationworkitemupdatestateevent"></a>`stateEvent` | [`WorkItemStateEvent`](#workitemstateevent) | Close or reopen a work item. |
| <a id="mutationworkitemupdatestatuswidget"></a>`statusWidget` | [`StatusInput`](#statusinput) | Input for status widget. |
| <a id="mutationworkitemupdatetimetrackingwidget"></a>`timeTrackingWidget` | [`WorkItemWidgetTimeTrackingInput`](#workitemwidgettimetrackinginput) | Input for time tracking widget. |
| <a id="mutationworkitemupdatetitle"></a>`title` | [`String`](#string) | Title of the work item. |
| <a id="mutationworkitemupdateweightwidget"></a>`weightWidget` | [`WorkItemWidgetWeightInput`](#workitemwidgetweightinput) | Input for weight widget. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkitemupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkitemupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkitemupdateworkitem"></a>`workItem` | [`WorkItem`](#workitem) | Updated work item. |

### `Mutation.workspaceCreate`

Input type: `WorkspaceCreateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspacecreateclusteragentid"></a>`clusterAgentId` | [`ClustersAgentID!`](#clustersagentid) | GlobalID of the cluster agent the created workspace will be associated with. |
| <a id="mutationworkspacecreatedesiredstate"></a>`desiredState` | [`String!`](#string) | Desired state of the created workspace. |
| <a id="mutationworkspacecreatedevfilepath"></a>`devfilePath` | [`String!`](#string) | Project repo git path containing the devfile used to configure the workspace. |
| <a id="mutationworkspacecreatedevfileref"></a>`devfileRef` | [`String!`](#string) | Project repo git ref containing the devfile used to configure the workspace. |
| <a id="mutationworkspacecreateeditor"></a>`editor` | [`String!`](#string) | Editor to inject into the created workspace. Must match a configured template. |
| <a id="mutationworkspacecreatemaxhoursbeforetermination"></a>`maxHoursBeforeTermination` | [`Int!`](#int) | Maximum hours the workspace can exist before it is automatically terminated. |
| <a id="mutationworkspacecreateprojectid"></a>`projectId` | [`ProjectID!`](#projectid) | ID of the project that will provide the Devfile for the created workspace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspacecreateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspacecreateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkspacecreateworkspace"></a>`workspace` | [`Workspace`](#workspace) | Created workspace. |

### `Mutation.workspaceUpdate`

Input type: `WorkspaceUpdateInput`

#### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspaceupdatedesiredstate"></a>`desiredState` | [`String!`](#string) | Desired state of the created workspace. |
| <a id="mutationworkspaceupdateid"></a>`id` | [`RemoteDevelopmentWorkspaceID!`](#remotedevelopmentworkspaceid) | Global ID of the workspace. |

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mutationworkspaceupdateclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="mutationworkspaceupdateerrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="mutationworkspaceupdateworkspace"></a>`workspace` | [`Workspace`](#workspace) | Created workspace. |

## Connections

Some types in our schema are `Connection` types - they represent a paginated
collection of edges between two nodes in the graph. These follow the
[Relay cursor connections specification](https://relay.dev/graphql/connections.htm).

### Pagination arguments

All connection fields support the following pagination arguments:

| Name | Type | Description |
|------|------|-------------|
| `after` | [`String`](#string) | Returns the elements in the list that come after the specified cursor. |
| `before` | [`String`](#string) | Returns the elements in the list that come before the specified cursor. |
| `first` | [`Int`](#int) | Returns the first _n_ elements from the list. |
| `last` | [`Int`](#int) | Returns the last _n_ elements from the list. |

Since these arguments are common to all connection fields, they are not repeated for each connection.

### Connection fields

All connections have at least the following fields:

| Name | Type | Description |
|------|------|-------------|
| `pageInfo` | [`PageInfo!`](#pageinfo) | Pagination information. |
| `edges` | `[edge!]` | The edges. |
| `nodes` | `[item!]` | The items in the current page. |

The precise type of `Edge` and `Item` depends on the kind of connection. A
[`ProjectConnection`](#projectconnection) will have nodes that have the type
[`[Project!]`](#project), and edges that have the type [`ProjectEdge`](#projectedge).

### Connection types

Some of the types in the schema exist solely to model connections. Each connection
has a distinct, named type, with a distinct named edge type. These are listed separately
below.

#### `AccessLevelDeployKeyConnection`

The connection type for [`AccessLevelDeployKey`](#accessleveldeploykey).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyconnectionedges"></a>`edges` | [`[AccessLevelDeployKeyEdge]`](#accessleveldeploykeyedge) | A list of edges. |
| <a id="accessleveldeploykeyconnectionnodes"></a>`nodes` | [`[AccessLevelDeployKey]`](#accessleveldeploykey) | A list of nodes. |
| <a id="accessleveldeploykeyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AccessLevelDeployKeyEdge`

The edge type for [`AccessLevelDeployKey`](#accessleveldeploykey).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="accessleveldeploykeyedgenode"></a>`node` | [`AccessLevelDeployKey`](#accessleveldeploykey) | The item at the end of the edge. |

#### `AchievementConnection`

The connection type for [`Achievement`](#achievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="achievementconnectionedges"></a>`edges` | [`[AchievementEdge]`](#achievementedge) | A list of edges. |
| <a id="achievementconnectionnodes"></a>`nodes` | [`[Achievement]`](#achievement) | A list of nodes. |
| <a id="achievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AchievementEdge`

The edge type for [`Achievement`](#achievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="achievementedgenode"></a>`node` | [`Achievement`](#achievement) | The item at the end of the edge. |

#### `AddOnUserConnection`

The connection type for [`AddOnUser`](#addonuser).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="addonuserconnectionedges"></a>`edges` | [`[AddOnUserEdge]`](#addonuseredge) | A list of edges. |
| <a id="addonuserconnectionnodes"></a>`nodes` | [`[AddOnUser]`](#addonuser) | A list of nodes. |
| <a id="addonuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AddOnUserEdge`

The edge type for [`AddOnUser`](#addonuser).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuseredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="addonuseredgenode"></a>`node` | [`AddOnUser`](#addonuser) | The item at the end of the edge. |

#### `AgentConfigurationConnection`

The connection type for [`AgentConfiguration`](#agentconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationconnectionedges"></a>`edges` | [`[AgentConfigurationEdge]`](#agentconfigurationedge) | A list of edges. |
| <a id="agentconfigurationconnectionnodes"></a>`nodes` | [`[AgentConfiguration]`](#agentconfiguration) | A list of nodes. |
| <a id="agentconfigurationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AgentConfigurationEdge`

The edge type for [`AgentConfiguration`](#agentconfiguration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="agentconfigurationedgenode"></a>`node` | [`AgentConfiguration`](#agentconfiguration) | The item at the end of the edge. |

#### `AiAgentConnection`

The connection type for [`AiAgent`](#aiagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiagentconnectionedges"></a>`edges` | [`[AiAgentEdge]`](#aiagentedge) | A list of edges. |
| <a id="aiagentconnectionnodes"></a>`nodes` | [`[AiAgent]`](#aiagent) | A list of nodes. |
| <a id="aiagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiAgentEdge`

The edge type for [`AiAgent`](#aiagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiagentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aiagentedgenode"></a>`node` | [`AiAgent`](#aiagent) | The item at the end of the edge. |

#### `AiMessageConnection`

The connection type for [`AiMessage`](#aimessage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessageconnectionedges"></a>`edges` | [`[AiMessageEdge]`](#aimessageedge) | A list of edges. |
| <a id="aimessageconnectionnodes"></a>`nodes` | [`[AiMessage]`](#aimessage) | A list of nodes. |
| <a id="aimessageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AiMessageEdge`

The edge type for [`AiMessage`](#aimessage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="aimessageedgenode"></a>`node` | [`AiMessage`](#aimessage) | The item at the end of the edge. |

#### `AlertManagementAlertConnection`

The connection type for [`AlertManagementAlert`](#alertmanagementalert).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertconnectionedges"></a>`edges` | [`[AlertManagementAlertEdge]`](#alertmanagementalertedge) | A list of edges. |
| <a id="alertmanagementalertconnectionnodes"></a>`nodes` | [`[AlertManagementAlert]`](#alertmanagementalert) | A list of nodes. |
| <a id="alertmanagementalertconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementAlertEdge`

The edge type for [`AlertManagementAlert`](#alertmanagementalert).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementalertedgenode"></a>`node` | [`AlertManagementAlert`](#alertmanagementalert) | The item at the end of the edge. |

#### `AlertManagementHttpIntegrationConnection`

The connection type for [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationconnectionedges"></a>`edges` | [`[AlertManagementHttpIntegrationEdge]`](#alertmanagementhttpintegrationedge) | A list of edges. |
| <a id="alertmanagementhttpintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementHttpIntegration]`](#alertmanagementhttpintegration) | A list of nodes. |
| <a id="alertmanagementhttpintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementHttpIntegrationEdge`

The edge type for [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementhttpintegrationedgenode"></a>`node` | [`AlertManagementHttpIntegration`](#alertmanagementhttpintegration) | The item at the end of the edge. |

#### `AlertManagementIntegrationConnection`

The connection type for [`AlertManagementIntegration`](#alertmanagementintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationconnectionedges"></a>`edges` | [`[AlertManagementIntegrationEdge]`](#alertmanagementintegrationedge) | A list of edges. |
| <a id="alertmanagementintegrationconnectionnodes"></a>`nodes` | [`[AlertManagementIntegration]`](#alertmanagementintegration) | A list of nodes. |
| <a id="alertmanagementintegrationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AlertManagementIntegrationEdge`

The edge type for [`AlertManagementIntegration`](#alertmanagementintegration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementintegrationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="alertmanagementintegrationedgenode"></a>`node` | [`AlertManagementIntegration`](#alertmanagementintegration) | The item at the end of the edge. |

#### `AmazonS3ConfigurationTypeConnection`

The connection type for [`AmazonS3ConfigurationType`](#amazons3configurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeconnectionedges"></a>`edges` | [`[AmazonS3ConfigurationTypeEdge]`](#amazons3configurationtypeedge) | A list of edges. |
| <a id="amazons3configurationtypeconnectionnodes"></a>`nodes` | [`[AmazonS3ConfigurationType]`](#amazons3configurationtype) | A list of nodes. |
| <a id="amazons3configurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AmazonS3ConfigurationTypeEdge`

The edge type for [`AmazonS3ConfigurationType`](#amazons3configurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="amazons3configurationtypeedgenode"></a>`node` | [`AmazonS3ConfigurationType`](#amazons3configurationtype) | The item at the end of the edge. |

#### `ApprovalPolicyConnection`

The connection type for [`ApprovalPolicy`](#approvalpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalpolicyconnectionedges"></a>`edges` | [`[ApprovalPolicyEdge]`](#approvalpolicyedge) | A list of edges. |
| <a id="approvalpolicyconnectionnodes"></a>`nodes` | [`[ApprovalPolicy]`](#approvalpolicy) | A list of nodes. |
| <a id="approvalpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ApprovalPolicyEdge`

The edge type for [`ApprovalPolicy`](#approvalpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="approvalpolicyedgenode"></a>`node` | [`ApprovalPolicy`](#approvalpolicy) | The item at the end of the edge. |

#### `ApprovalProjectRuleConnection`

The connection type for [`ApprovalProjectRule`](#approvalprojectrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleconnectionedges"></a>`edges` | [`[ApprovalProjectRuleEdge]`](#approvalprojectruleedge) | A list of edges. |
| <a id="approvalprojectruleconnectionnodes"></a>`nodes` | [`[ApprovalProjectRule]`](#approvalprojectrule) | A list of nodes. |
| <a id="approvalprojectruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ApprovalProjectRuleEdge`

The edge type for [`ApprovalProjectRule`](#approvalprojectrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="approvalprojectruleedgenode"></a>`node` | [`ApprovalProjectRule`](#approvalprojectrule) | The item at the end of the edge. |

#### `AuditEventDefinitionConnection`

The connection type for [`AuditEventDefinition`](#auditeventdefinition).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionconnectionedges"></a>`edges` | [`[AuditEventDefinitionEdge]`](#auditeventdefinitionedge) | A list of edges. |
| <a id="auditeventdefinitionconnectionnodes"></a>`nodes` | [`[AuditEventDefinition]`](#auditeventdefinition) | A list of nodes. |
| <a id="auditeventdefinitionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AuditEventDefinitionEdge`

The edge type for [`AuditEventDefinition`](#auditeventdefinition).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="auditeventdefinitionedgenode"></a>`node` | [`AuditEventDefinition`](#auditeventdefinition) | The item at the end of the edge. |

#### `AuditEventStreamingHeaderConnection`

The connection type for [`AuditEventStreamingHeader`](#auditeventstreamingheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderconnectionedges"></a>`edges` | [`[AuditEventStreamingHeaderEdge]`](#auditeventstreamingheaderedge) | A list of edges. |
| <a id="auditeventstreamingheaderconnectionnodes"></a>`nodes` | [`[AuditEventStreamingHeader]`](#auditeventstreamingheader) | A list of nodes. |
| <a id="auditeventstreamingheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AuditEventStreamingHeaderEdge`

The edge type for [`AuditEventStreamingHeader`](#auditeventstreamingheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="auditeventstreamingheaderedgenode"></a>`node` | [`AuditEventStreamingHeader`](#auditeventstreamingheader) | The item at the end of the edge. |

#### `AuditEventsStreamingInstanceHeaderConnection`

The connection type for [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderconnectionedges"></a>`edges` | [`[AuditEventsStreamingInstanceHeaderEdge]`](#auditeventsstreaminginstanceheaderedge) | A list of edges. |
| <a id="auditeventsstreaminginstanceheaderconnectionnodes"></a>`nodes` | [`[AuditEventsStreamingInstanceHeader]`](#auditeventsstreaminginstanceheader) | A list of nodes. |
| <a id="auditeventsstreaminginstanceheaderconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AuditEventsStreamingInstanceHeaderEdge`

The edge type for [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="auditeventsstreaminginstanceheaderedgenode"></a>`node` | [`AuditEventsStreamingInstanceHeader`](#auditeventsstreaminginstanceheader) | The item at the end of the edge. |

#### `AwardEmojiConnection`

The connection type for [`AwardEmoji`](#awardemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojiconnectionedges"></a>`edges` | [`[AwardEmojiEdge]`](#awardemojiedge) | A list of edges. |
| <a id="awardemojiconnectionnodes"></a>`nodes` | [`[AwardEmoji]`](#awardemoji) | A list of nodes. |
| <a id="awardemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `AwardEmojiEdge`

The edge type for [`AwardEmoji`](#awardemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojiedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="awardemojiedgenode"></a>`node` | [`AwardEmoji`](#awardemoji) | The item at the end of the edge. |

#### `BlobConnection`

The connection type for [`Blob`](#blob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobconnectionedges"></a>`edges` | [`[BlobEdge]`](#blobedge) | A list of edges. |
| <a id="blobconnectionnodes"></a>`nodes` | [`[Blob]`](#blob) | A list of nodes. |
| <a id="blobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BlobEdge`

The edge type for [`Blob`](#blob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="blobedgenode"></a>`node` | [`Blob`](#blob) | The item at the end of the edge. |

#### `BoardConnection`

The connection type for [`Board`](#board).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardconnectionedges"></a>`edges` | [`[BoardEdge]`](#boardedge) | A list of edges. |
| <a id="boardconnectionnodes"></a>`nodes` | [`[Board]`](#board) | A list of nodes. |
| <a id="boardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardEdge`

The edge type for [`Board`](#board).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardedgenode"></a>`node` | [`Board`](#board) | The item at the end of the edge. |

#### `BoardEpicConnection`

The connection type for [`BoardEpic`](#boardepic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="boardepicconnectionedges"></a>`edges` | [`[BoardEpicEdge]`](#boardepicedge) | A list of edges. |
| <a id="boardepicconnectionnodes"></a>`nodes` | [`[BoardEpic]`](#boardepic) | A list of nodes. |
| <a id="boardepicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardEpicEdge`

The edge type for [`BoardEpic`](#boardepic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardepicedgenode"></a>`node` | [`BoardEpic`](#boardepic) | The item at the end of the edge. |

#### `BoardListConnection`

The connection type for [`BoardList`](#boardlist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistconnectionedges"></a>`edges` | [`[BoardListEdge]`](#boardlistedge) | A list of edges. |
| <a id="boardlistconnectionnodes"></a>`nodes` | [`[BoardList]`](#boardlist) | A list of nodes. |
| <a id="boardlistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BoardListEdge`

The edge type for [`BoardList`](#boardlist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="boardlistedgenode"></a>`node` | [`BoardList`](#boardlist) | The item at the end of the edge. |

#### `BranchRuleConnection`

The connection type for [`BranchRule`](#branchrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleconnectionedges"></a>`edges` | [`[BranchRuleEdge]`](#branchruleedge) | A list of edges. |
| <a id="branchruleconnectionnodes"></a>`nodes` | [`[BranchRule]`](#branchrule) | A list of nodes. |
| <a id="branchruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `BranchRuleEdge`

The edge type for [`BranchRule`](#branchrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="branchruleedgenode"></a>`node` | [`BranchRule`](#branchrule) | The item at the end of the edge. |

#### `CiBuildNeedConnection`

The connection type for [`CiBuildNeed`](#cibuildneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneedconnectionedges"></a>`edges` | [`[CiBuildNeedEdge]`](#cibuildneededge) | A list of edges. |
| <a id="cibuildneedconnectionnodes"></a>`nodes` | [`[CiBuildNeed]`](#cibuildneed) | A list of nodes. |
| <a id="cibuildneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiBuildNeedEdge`

The edge type for [`CiBuildNeed`](#cibuildneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneededgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cibuildneededgenode"></a>`node` | [`CiBuildNeed`](#cibuildneed) | The item at the end of the edge. |

#### `CiCatalogResourceComponentConnection`

The connection type for [`CiCatalogResourceComponent`](#cicatalogresourcecomponent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentconnectionedges"></a>`edges` | [`[CiCatalogResourceComponentEdge]`](#cicatalogresourcecomponentedge) | A list of edges. |
| <a id="cicatalogresourcecomponentconnectionnodes"></a>`nodes` | [`[CiCatalogResourceComponent]`](#cicatalogresourcecomponent) | A list of nodes. |
| <a id="cicatalogresourcecomponentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceComponentEdge`

The edge type for [`CiCatalogResourceComponent`](#cicatalogresourcecomponent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourcecomponentedgenode"></a>`node` | [`CiCatalogResourceComponent`](#cicatalogresourcecomponent) | The item at the end of the edge. |

#### `CiCatalogResourceConnection`

The connection type for [`CiCatalogResource`](#cicatalogresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cicatalogresourceconnectionedges"></a>`edges` | [`[CiCatalogResourceEdge]`](#cicatalogresourceedge) | A list of edges. |
| <a id="cicatalogresourceconnectionnodes"></a>`nodes` | [`[CiCatalogResource]`](#cicatalogresource) | A list of nodes. |
| <a id="cicatalogresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceEdge`

The edge type for [`CiCatalogResource`](#cicatalogresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourceedgenode"></a>`node` | [`CiCatalogResource`](#cicatalogresource) | The item at the end of the edge. |

#### `CiCatalogResourceVersionConnection`

The connection type for [`CiCatalogResourceVersion`](#cicatalogresourceversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cicatalogresourceversionconnectionedges"></a>`edges` | [`[CiCatalogResourceVersionEdge]`](#cicatalogresourceversionedge) | A list of edges. |
| <a id="cicatalogresourceversionconnectionnodes"></a>`nodes` | [`[CiCatalogResourceVersion]`](#cicatalogresourceversion) | A list of nodes. |
| <a id="cicatalogresourceversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiCatalogResourceVersionEdge`

The edge type for [`CiCatalogResourceVersion`](#cicatalogresourceversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cicatalogresourceversionedgenode"></a>`node` | [`CiCatalogResourceVersion`](#cicatalogresourceversion) | The item at the end of the edge. |

#### `CiConfigGroupConnection`

The connection type for [`CiConfigGroup`](#ciconfiggroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupconnectionedges"></a>`edges` | [`[CiConfigGroupEdge]`](#ciconfiggroupedge) | A list of edges. |
| <a id="ciconfiggroupconnectionnodes"></a>`nodes` | [`[CiConfigGroup]`](#ciconfiggroup) | A list of nodes. |
| <a id="ciconfiggroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigGroupEdge`

The edge type for [`CiConfigGroup`](#ciconfiggroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfiggroupedgenode"></a>`node` | [`CiConfigGroup`](#ciconfiggroup) | The item at the end of the edge. |

#### `CiConfigJobConnection`

The connection type for [`CiConfigJob`](#ciconfigjob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobconnectionedges"></a>`edges` | [`[CiConfigJobEdge]`](#ciconfigjobedge) | A list of edges. |
| <a id="ciconfigjobconnectionnodes"></a>`nodes` | [`[CiConfigJob]`](#ciconfigjob) | A list of nodes. |
| <a id="ciconfigjobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigJobEdge`

The edge type for [`CiConfigJob`](#ciconfigjob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigjobedgenode"></a>`node` | [`CiConfigJob`](#ciconfigjob) | The item at the end of the edge. |

#### `CiConfigNeedConnection`

The connection type for [`CiConfigNeed`](#ciconfigneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneedconnectionedges"></a>`edges` | [`[CiConfigNeedEdge]`](#ciconfigneededge) | A list of edges. |
| <a id="ciconfigneedconnectionnodes"></a>`nodes` | [`[CiConfigNeed]`](#ciconfigneed) | A list of nodes. |
| <a id="ciconfigneedconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigNeedEdge`

The edge type for [`CiConfigNeed`](#ciconfigneed).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneededgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigneededgenode"></a>`node` | [`CiConfigNeed`](#ciconfigneed) | The item at the end of the edge. |

#### `CiConfigStageConnection`

The connection type for [`CiConfigStage`](#ciconfigstage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstageconnectionedges"></a>`edges` | [`[CiConfigStageEdge]`](#ciconfigstageedge) | A list of edges. |
| <a id="ciconfigstageconnectionnodes"></a>`nodes` | [`[CiConfigStage]`](#ciconfigstage) | A list of nodes. |
| <a id="ciconfigstageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiConfigStageEdge`

The edge type for [`CiConfigStage`](#ciconfigstage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciconfigstageedgenode"></a>`node` | [`CiConfigStage`](#ciconfigstage) | The item at the end of the edge. |

#### `CiGroupConnection`

The connection type for [`CiGroup`](#cigroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupconnectionedges"></a>`edges` | [`[CiGroupEdge]`](#cigroupedge) | A list of edges. |
| <a id="cigroupconnectionnodes"></a>`nodes` | [`[CiGroup]`](#cigroup) | A list of nodes. |
| <a id="cigroupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupEdge`

The edge type for [`CiGroup`](#cigroup).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupedgenode"></a>`node` | [`CiGroup`](#cigroup) | The item at the end of the edge. |

#### `CiGroupEnvironmentScopeConnection`

The connection type for [`CiGroupEnvironmentScope`](#cigroupenvironmentscope).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeconnectionedges"></a>`edges` | [`[CiGroupEnvironmentScopeEdge]`](#cigroupenvironmentscopeedge) | A list of edges. |
| <a id="cigroupenvironmentscopeconnectionnodes"></a>`nodes` | [`[CiGroupEnvironmentScope]`](#cigroupenvironmentscope) | A list of nodes. |
| <a id="cigroupenvironmentscopeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupEnvironmentScopeEdge`

The edge type for [`CiGroupEnvironmentScope`](#cigroupenvironmentscope).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupenvironmentscopeedgenode"></a>`node` | [`CiGroupEnvironmentScope`](#cigroupenvironmentscope) | The item at the end of the edge. |

#### `CiGroupVariableConnection`

The connection type for [`CiGroupVariable`](#cigroupvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariableconnectionedges"></a>`edges` | [`[CiGroupVariableEdge]`](#cigroupvariableedge) | A list of edges. |
| <a id="cigroupvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | Maximum amount of group CI/CD variables. |
| <a id="cigroupvariableconnectionnodes"></a>`nodes` | [`[CiGroupVariable]`](#cigroupvariable) | A list of nodes. |
| <a id="cigroupvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiGroupVariableEdge`

The edge type for [`CiGroupVariable`](#cigroupvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cigroupvariableedgenode"></a>`node` | [`CiGroupVariable`](#cigroupvariable) | The item at the end of the edge. |

#### `CiInstanceVariableConnection`

The connection type for [`CiInstanceVariable`](#ciinstancevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableconnectionedges"></a>`edges` | [`[CiInstanceVariableEdge]`](#ciinstancevariableedge) | A list of edges. |
| <a id="ciinstancevariableconnectionnodes"></a>`nodes` | [`[CiInstanceVariable]`](#ciinstancevariable) | A list of nodes. |
| <a id="ciinstancevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiInstanceVariableEdge`

The edge type for [`CiInstanceVariable`](#ciinstancevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciinstancevariableedgenode"></a>`node` | [`CiInstanceVariable`](#ciinstancevariable) | The item at the end of the edge. |

#### `CiJobArtifactConnection`

The connection type for [`CiJobArtifact`](#cijobartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactconnectionedges"></a>`edges` | [`[CiJobArtifactEdge]`](#cijobartifactedge) | A list of edges. |
| <a id="cijobartifactconnectionnodes"></a>`nodes` | [`[CiJobArtifact]`](#cijobartifact) | A list of nodes. |
| <a id="cijobartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiJobArtifactEdge`

The edge type for [`CiJobArtifact`](#cijobartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobartifactedgenode"></a>`node` | [`CiJobArtifact`](#cijobartifact) | The item at the end of the edge. |

#### `CiJobConnection`

The connection type for [`CiJob`](#cijob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobconnectionedges"></a>`edges` | [`[CiJobEdge]`](#cijobedge) | A list of edges. |
| <a id="cijobconnectionnodes"></a>`nodes` | [`[CiJob]`](#cijob) | A list of nodes. |
| <a id="cijobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `CiJobConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `CiJobEdge`

The edge type for [`CiJob`](#cijob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cijobedgenode"></a>`node` | [`CiJob`](#cijob) | The item at the end of the edge. |

#### `CiManualVariableConnection`

The connection type for [`CiManualVariable`](#cimanualvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableconnectionedges"></a>`edges` | [`[CiManualVariableEdge]`](#cimanualvariableedge) | A list of edges. |
| <a id="cimanualvariableconnectionnodes"></a>`nodes` | [`[CiManualVariable]`](#cimanualvariable) | A list of nodes. |
| <a id="cimanualvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiManualVariableEdge`

The edge type for [`CiManualVariable`](#cimanualvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cimanualvariableedgenode"></a>`node` | [`CiManualVariable`](#cimanualvariable) | The item at the end of the edge. |

#### `CiMinutesNamespaceMonthlyUsageConnection`

The connection type for [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesNamespaceMonthlyUsageEdge]`](#ciminutesnamespacemonthlyusageedge) | A list of edges. |
| <a id="ciminutesnamespacemonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesNamespaceMonthlyUsage]`](#ciminutesnamespacemonthlyusage) | A list of nodes. |
| <a id="ciminutesnamespacemonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiMinutesNamespaceMonthlyUsageEdge`

The edge type for [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciminutesnamespacemonthlyusageedgenode"></a>`node` | [`CiMinutesNamespaceMonthlyUsage`](#ciminutesnamespacemonthlyusage) | The item at the end of the edge. |

#### `CiMinutesProjectMonthlyUsageConnection`

The connection type for [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageconnectionedges"></a>`edges` | [`[CiMinutesProjectMonthlyUsageEdge]`](#ciminutesprojectmonthlyusageedge) | A list of edges. |
| <a id="ciminutesprojectmonthlyusageconnectionnodes"></a>`nodes` | [`[CiMinutesProjectMonthlyUsage]`](#ciminutesprojectmonthlyusage) | A list of nodes. |
| <a id="ciminutesprojectmonthlyusageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiMinutesProjectMonthlyUsageEdge`

The edge type for [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciminutesprojectmonthlyusageedgenode"></a>`node` | [`CiMinutesProjectMonthlyUsage`](#ciminutesprojectmonthlyusage) | The item at the end of the edge. |

#### `CiProjectVariableConnection`

The connection type for [`CiProjectVariable`](#ciprojectvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableconnectionedges"></a>`edges` | [`[CiProjectVariableEdge]`](#ciprojectvariableedge) | A list of edges. |
| <a id="ciprojectvariableconnectionlimit"></a>`limit` | [`Int!`](#int) | Maximum amount of project CI/CD variables. |
| <a id="ciprojectvariableconnectionnodes"></a>`nodes` | [`[CiProjectVariable]`](#ciprojectvariable) | A list of nodes. |
| <a id="ciprojectvariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiProjectVariableEdge`

The edge type for [`CiProjectVariable`](#ciprojectvariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="ciprojectvariableedgenode"></a>`node` | [`CiProjectVariable`](#ciprojectvariable) | The item at the end of the edge. |

#### `CiRunnerConnection`

The connection type for [`CiRunner`](#cirunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cirunnerconnectionedges"></a>`edges` | [`[CiRunnerEdge]`](#cirunneredge) | A list of edges. |
| <a id="cirunnerconnectionjobsstatistics"></a>`jobsStatistics` | [`CiJobsStatistics`](#cijobsstatistics) | Jobs statistics for jobs executed by a collection of runners. Available only to admins. |
| <a id="cirunnerconnectionnodes"></a>`nodes` | [`[CiRunner]`](#cirunner) | A list of nodes. |
| <a id="cirunnerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiRunnerEdge`

The edge type for [`CiRunner`](#cirunner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunneredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cirunneredgeediturl"></a>`editUrl` | [`String`](#string) | Web URL of the runner edit page. The value depends on where you put this field in the query. You can use it for projects or groups. |
| <a id="cirunneredgenode"></a>`node` | [`CiRunner`](#cirunner) | The item at the end of the edge. |
| <a id="cirunneredgeweburl"></a>`webUrl` | [`String`](#string) | Web URL of the runner. The value depends on where you put this field in the query. You can use it for projects or groups. |

#### `CiRunnerManagerConnection`

The connection type for [`CiRunnerManager`](#cirunnermanager).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanagerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cirunnermanagerconnectionedges"></a>`edges` | [`[CiRunnerManagerEdge]`](#cirunnermanageredge) | A list of edges. |
| <a id="cirunnermanagerconnectionnodes"></a>`nodes` | [`[CiRunnerManager]`](#cirunnermanager) | A list of nodes. |
| <a id="cirunnermanagerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiRunnerManagerEdge`

The edge type for [`CiRunnerManager`](#cirunnermanager).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanageredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cirunnermanageredgenode"></a>`node` | [`CiRunnerManager`](#cirunnermanager) | The item at the end of the edge. |

#### `CiSecureFileRegistryConnection`

The connection type for [`CiSecureFileRegistry`](#cisecurefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryconnectionedges"></a>`edges` | [`[CiSecureFileRegistryEdge]`](#cisecurefileregistryedge) | A list of edges. |
| <a id="cisecurefileregistryconnectionnodes"></a>`nodes` | [`[CiSecureFileRegistry]`](#cisecurefileregistry) | A list of nodes. |
| <a id="cisecurefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiSecureFileRegistryEdge`

The edge type for [`CiSecureFileRegistry`](#cisecurefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cisecurefileregistryedgenode"></a>`node` | [`CiSecureFileRegistry`](#cisecurefileregistry) | The item at the end of the edge. |

#### `CiStageConnection`

The connection type for [`CiStage`](#cistage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistageconnectionedges"></a>`edges` | [`[CiStageEdge]`](#cistageedge) | A list of edges. |
| <a id="cistageconnectionnodes"></a>`nodes` | [`[CiStage]`](#cistage) | A list of nodes. |
| <a id="cistageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiStageEdge`

The edge type for [`CiStage`](#cistage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cistageedgenode"></a>`node` | [`CiStage`](#cistage) | The item at the end of the edge. |

#### `CiSubscriptionsProjectConnection`

The connection type for [`CiSubscriptionsProject`](#cisubscriptionsproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="cisubscriptionsprojectconnectionedges"></a>`edges` | [`[CiSubscriptionsProjectEdge]`](#cisubscriptionsprojectedge) | A list of edges. |
| <a id="cisubscriptionsprojectconnectionnodes"></a>`nodes` | [`[CiSubscriptionsProject]`](#cisubscriptionsproject) | A list of nodes. |
| <a id="cisubscriptionsprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CiSubscriptionsProjectEdge`

The edge type for [`CiSubscriptionsProject`](#cisubscriptionsproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="cisubscriptionsprojectedgenode"></a>`node` | [`CiSubscriptionsProject`](#cisubscriptionsproject) | The item at the end of the edge. |

#### `ClusterAgentActivityEventConnection`

The connection type for [`ClusterAgentActivityEvent`](#clusteragentactivityevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragentactivityeventconnectionedges"></a>`edges` | [`[ClusterAgentActivityEventEdge]`](#clusteragentactivityeventedge) | A list of edges. |
| <a id="clusteragentactivityeventconnectionnodes"></a>`nodes` | [`[ClusterAgentActivityEvent]`](#clusteragentactivityevent) | A list of nodes. |
| <a id="clusteragentactivityeventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentActivityEventEdge`

The edge type for [`ClusterAgentActivityEvent`](#clusteragentactivityevent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentactivityeventedgenode"></a>`node` | [`ClusterAgentActivityEvent`](#clusteragentactivityevent) | The item at the end of the edge. |

#### `ClusterAgentAuthorizationCiAccessConnection`

The connection type for [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationCiAccessEdge]`](#clusteragentauthorizationciaccessedge) | A list of edges. |
| <a id="clusteragentauthorizationciaccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationCiAccess]`](#clusteragentauthorizationciaccess) | A list of nodes. |
| <a id="clusteragentauthorizationciaccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentAuthorizationCiAccessEdge`

The edge type for [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentauthorizationciaccessedgenode"></a>`node` | [`ClusterAgentAuthorizationCiAccess`](#clusteragentauthorizationciaccess) | The item at the end of the edge. |

#### `ClusterAgentAuthorizationUserAccessConnection`

The connection type for [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessconnectionedges"></a>`edges` | [`[ClusterAgentAuthorizationUserAccessEdge]`](#clusteragentauthorizationuseraccessedge) | A list of edges. |
| <a id="clusteragentauthorizationuseraccessconnectionnodes"></a>`nodes` | [`[ClusterAgentAuthorizationUserAccess]`](#clusteragentauthorizationuseraccess) | A list of nodes. |
| <a id="clusteragentauthorizationuseraccessconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentAuthorizationUserAccessEdge`

The edge type for [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentauthorizationuseraccessedgenode"></a>`node` | [`ClusterAgentAuthorizationUserAccess`](#clusteragentauthorizationuseraccess) | The item at the end of the edge. |

#### `ClusterAgentConnection`

The connection type for [`ClusterAgent`](#clusteragent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragentconnectionedges"></a>`edges` | [`[ClusterAgentEdge]`](#clusteragentedge) | A list of edges. |
| <a id="clusteragentconnectionnodes"></a>`nodes` | [`[ClusterAgent]`](#clusteragent) | A list of nodes. |
| <a id="clusteragentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentEdge`

The edge type for [`ClusterAgent`](#clusteragent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragentedgenode"></a>`node` | [`ClusterAgent`](#clusteragent) | The item at the end of the edge. |

#### `ClusterAgentTokenConnection`

The connection type for [`ClusterAgentToken`](#clusteragenttoken).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="clusteragenttokenconnectionedges"></a>`edges` | [`[ClusterAgentTokenEdge]`](#clusteragenttokenedge) | A list of edges. |
| <a id="clusteragenttokenconnectionnodes"></a>`nodes` | [`[ClusterAgentToken]`](#clusteragenttoken) | A list of nodes. |
| <a id="clusteragenttokenconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ClusterAgentTokenEdge`

The edge type for [`ClusterAgentToken`](#clusteragenttoken).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="clusteragenttokenedgenode"></a>`node` | [`ClusterAgentToken`](#clusteragenttoken) | The item at the end of the edge. |

#### `CodeCoverageActivityConnection`

The connection type for [`CodeCoverageActivity`](#codecoverageactivity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityconnectionedges"></a>`edges` | [`[CodeCoverageActivityEdge]`](#codecoverageactivityedge) | A list of edges. |
| <a id="codecoverageactivityconnectionnodes"></a>`nodes` | [`[CodeCoverageActivity]`](#codecoverageactivity) | A list of nodes. |
| <a id="codecoverageactivityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CodeCoverageActivityEdge`

The edge type for [`CodeCoverageActivity`](#codecoverageactivity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="codecoverageactivityedgenode"></a>`node` | [`CodeCoverageActivity`](#codecoverageactivity) | The item at the end of the edge. |

#### `CodeQualityDegradationConnection`

The connection type for [`CodeQualityDegradation`](#codequalitydegradation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="codequalitydegradationconnectionedges"></a>`edges` | [`[CodeQualityDegradationEdge]`](#codequalitydegradationedge) | A list of edges. |
| <a id="codequalitydegradationconnectionnodes"></a>`nodes` | [`[CodeQualityDegradation]`](#codequalitydegradation) | A list of nodes. |
| <a id="codequalitydegradationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CodeQualityDegradationEdge`

The edge type for [`CodeQualityDegradation`](#codequalitydegradation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="codequalitydegradationedgenode"></a>`node` | [`CodeQualityDegradation`](#codequalitydegradation) | The item at the end of the edge. |

#### `CommitConnection`

The connection type for [`Commit`](#commit).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitconnectionedges"></a>`edges` | [`[CommitEdge]`](#commitedge) | A list of edges. |
| <a id="commitconnectionnodes"></a>`nodes` | [`[Commit]`](#commit) | A list of nodes. |
| <a id="commitconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CommitEdge`

The edge type for [`Commit`](#commit).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="commitedgenode"></a>`node` | [`Commit`](#commit) | The item at the end of the edge. |

#### `ComplianceFrameworkConnection`

The connection type for [`ComplianceFramework`](#complianceframework).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkconnectionedges"></a>`edges` | [`[ComplianceFrameworkEdge]`](#complianceframeworkedge) | A list of edges. |
| <a id="complianceframeworkconnectionnodes"></a>`nodes` | [`[ComplianceFramework]`](#complianceframework) | A list of nodes. |
| <a id="complianceframeworkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceFrameworkEdge`

The edge type for [`ComplianceFramework`](#complianceframework).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceframeworkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceframeworkedgenode"></a>`node` | [`ComplianceFramework`](#complianceframework) | The item at the end of the edge. |

#### `ComplianceStandardsAdherenceConnection`

The connection type for [`ComplianceStandardsAdherence`](#compliancestandardsadherence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceconnectionedges"></a>`edges` | [`[ComplianceStandardsAdherenceEdge]`](#compliancestandardsadherenceedge) | A list of edges. |
| <a id="compliancestandardsadherenceconnectionnodes"></a>`nodes` | [`[ComplianceStandardsAdherence]`](#compliancestandardsadherence) | A list of nodes. |
| <a id="compliancestandardsadherenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceStandardsAdherenceEdge`

The edge type for [`ComplianceStandardsAdherence`](#compliancestandardsadherence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="compliancestandardsadherenceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="compliancestandardsadherenceedgenode"></a>`node` | [`ComplianceStandardsAdherence`](#compliancestandardsadherence) | The item at the end of the edge. |

#### `ComplianceViolationConnection`

The connection type for [`ComplianceViolation`](#complianceviolation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceviolationconnectionedges"></a>`edges` | [`[ComplianceViolationEdge]`](#complianceviolationedge) | A list of edges. |
| <a id="complianceviolationconnectionnodes"></a>`nodes` | [`[ComplianceViolation]`](#complianceviolation) | A list of nodes. |
| <a id="complianceviolationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ComplianceViolationEdge`

The edge type for [`ComplianceViolation`](#complianceviolation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="complianceviolationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="complianceviolationedgenode"></a>`node` | [`ComplianceViolation`](#complianceviolation) | The item at the end of the edge. |

#### `ConnectedAgentConnection`

The connection type for [`ConnectedAgent`](#connectedagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="connectedagentconnectionedges"></a>`edges` | [`[ConnectedAgentEdge]`](#connectedagentedge) | A list of edges. |
| <a id="connectedagentconnectionnodes"></a>`nodes` | [`[ConnectedAgent]`](#connectedagent) | A list of nodes. |
| <a id="connectedagentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ConnectedAgentEdge`

The edge type for [`ConnectedAgent`](#connectedagent).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="connectedagentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="connectedagentedgenode"></a>`node` | [`ConnectedAgent`](#connectedagent) | The item at the end of the edge. |

#### `ContainerRegistryProtectionRuleConnection`

The connection type for [`ContainerRegistryProtectionRule`](#containerregistryprotectionrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerregistryprotectionruleconnectionedges"></a>`edges` | [`[ContainerRegistryProtectionRuleEdge]`](#containerregistryprotectionruleedge) | A list of edges. |
| <a id="containerregistryprotectionruleconnectionnodes"></a>`nodes` | [`[ContainerRegistryProtectionRule]`](#containerregistryprotectionrule) | A list of nodes. |
| <a id="containerregistryprotectionruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRegistryProtectionRuleEdge`

The edge type for [`ContainerRegistryProtectionRule`](#containerregistryprotectionrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerregistryprotectionruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerregistryprotectionruleedgenode"></a>`node` | [`ContainerRegistryProtectionRule`](#containerregistryprotectionrule) | The item at the end of the edge. |

#### `ContainerRepositoryConnection`

The connection type for [`ContainerRepository`](#containerrepository).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryconnectionedges"></a>`edges` | [`[ContainerRepositoryEdge]`](#containerrepositoryedge) | A list of edges. |
| <a id="containerrepositoryconnectionnodes"></a>`nodes` | [`[ContainerRepository]`](#containerrepository) | A list of nodes. |
| <a id="containerrepositoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryEdge`

The edge type for [`ContainerRepository`](#containerrepository).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositoryedgenode"></a>`node` | [`ContainerRepository`](#containerrepository) | The item at the end of the edge. |

#### `ContainerRepositoryRegistryConnection`

The connection type for [`ContainerRepositoryRegistry`](#containerrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryconnectionedges"></a>`edges` | [`[ContainerRepositoryRegistryEdge]`](#containerrepositoryregistryedge) | A list of edges. |
| <a id="containerrepositoryregistryconnectionnodes"></a>`nodes` | [`[ContainerRepositoryRegistry]`](#containerrepositoryregistry) | A list of nodes. |
| <a id="containerrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryRegistryEdge`

The edge type for [`ContainerRepositoryRegistry`](#containerrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositoryregistryedgenode"></a>`node` | [`ContainerRepositoryRegistry`](#containerrepositoryregistry) | The item at the end of the edge. |

#### `ContainerRepositoryTagConnection`

The connection type for [`ContainerRepositoryTag`](#containerrepositorytag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagconnectionedges"></a>`edges` | [`[ContainerRepositoryTagEdge]`](#containerrepositorytagedge) | A list of edges. |
| <a id="containerrepositorytagconnectionnodes"></a>`nodes` | [`[ContainerRepositoryTag]`](#containerrepositorytag) | A list of nodes. |
| <a id="containerrepositorytagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContainerRepositoryTagEdge`

The edge type for [`ContainerRepositoryTag`](#containerrepositorytag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="containerrepositorytagedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="containerrepositorytagedgenode"></a>`node` | [`ContainerRepositoryTag`](#containerrepositorytag) | The item at the end of the edge. |

#### `ContributionAnalyticsContributionConnection`

The connection type for [`ContributionAnalyticsContribution`](#contributionanalyticscontribution).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionconnectionedges"></a>`edges` | [`[ContributionAnalyticsContributionEdge]`](#contributionanalyticscontributionedge) | A list of edges. |
| <a id="contributionanalyticscontributionconnectionnodes"></a>`nodes` | [`[ContributionAnalyticsContribution]`](#contributionanalyticscontribution) | A list of nodes. |
| <a id="contributionanalyticscontributionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ContributionAnalyticsContributionEdge`

The edge type for [`ContributionAnalyticsContribution`](#contributionanalyticscontribution).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="contributionanalyticscontributionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="contributionanalyticscontributionedgenode"></a>`node` | [`ContributionAnalyticsContribution`](#contributionanalyticscontribution) | The item at the end of the edge. |

#### `CoverageFuzzingCorpusConnection`

The connection type for [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusconnectionedges"></a>`edges` | [`[CoverageFuzzingCorpusEdge]`](#coveragefuzzingcorpusedge) | A list of edges. |
| <a id="coveragefuzzingcorpusconnectionnodes"></a>`nodes` | [`[CoverageFuzzingCorpus]`](#coveragefuzzingcorpus) | A list of nodes. |
| <a id="coveragefuzzingcorpusconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CoverageFuzzingCorpusEdge`

The edge type for [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="coveragefuzzingcorpusedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="coveragefuzzingcorpusedgenode"></a>`node` | [`CoverageFuzzingCorpus`](#coveragefuzzingcorpus) | The item at the end of the edge. |

#### `CustomEmojiConnection`

The connection type for [`CustomEmoji`](#customemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customemojiconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="customemojiconnectionedges"></a>`edges` | [`[CustomEmojiEdge]`](#customemojiedge) | A list of edges. |
| <a id="customemojiconnectionnodes"></a>`nodes` | [`[CustomEmoji]`](#customemoji) | A list of nodes. |
| <a id="customemojiconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomEmojiEdge`

The edge type for [`CustomEmoji`](#customemoji).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customemojiedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customemojiedgenode"></a>`node` | [`CustomEmoji`](#customemoji) | The item at the end of the edge. |

#### `CustomerRelationsContactConnection`

The connection type for [`CustomerRelationsContact`](#customerrelationscontact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactconnectionedges"></a>`edges` | [`[CustomerRelationsContactEdge]`](#customerrelationscontactedge) | A list of edges. |
| <a id="customerrelationscontactconnectionnodes"></a>`nodes` | [`[CustomerRelationsContact]`](#customerrelationscontact) | A list of nodes. |
| <a id="customerrelationscontactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomerRelationsContactEdge`

The edge type for [`CustomerRelationsContact`](#customerrelationscontact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationscontactedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customerrelationscontactedgenode"></a>`node` | [`CustomerRelationsContact`](#customerrelationscontact) | The item at the end of the edge. |

#### `CustomerRelationsOrganizationConnection`

The connection type for [`CustomerRelationsOrganization`](#customerrelationsorganization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationconnectionedges"></a>`edges` | [`[CustomerRelationsOrganizationEdge]`](#customerrelationsorganizationedge) | A list of edges. |
| <a id="customerrelationsorganizationconnectionnodes"></a>`nodes` | [`[CustomerRelationsOrganization]`](#customerrelationsorganization) | A list of nodes. |
| <a id="customerrelationsorganizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomerRelationsOrganizationEdge`

The edge type for [`CustomerRelationsOrganization`](#customerrelationsorganization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customerrelationsorganizationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customerrelationsorganizationedgenode"></a>`node` | [`CustomerRelationsOrganization`](#customerrelationsorganization) | The item at the end of the edge. |

#### `CustomizableDashboardConnection`

The connection type for [`CustomizableDashboard`](#customizabledashboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizabledashboardconnectionedges"></a>`edges` | [`[CustomizableDashboardEdge]`](#customizabledashboardedge) | A list of edges. |
| <a id="customizabledashboardconnectionnodes"></a>`nodes` | [`[CustomizableDashboard]`](#customizabledashboard) | A list of nodes. |
| <a id="customizabledashboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomizableDashboardEdge`

The edge type for [`CustomizableDashboard`](#customizabledashboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizabledashboardedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customizabledashboardedgenode"></a>`node` | [`CustomizableDashboard`](#customizabledashboard) | The item at the end of the edge. |

#### `CustomizableDashboardPanelConnection`

The connection type for [`CustomizableDashboardPanel`](#customizabledashboardpanel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizabledashboardpanelconnectionedges"></a>`edges` | [`[CustomizableDashboardPanelEdge]`](#customizabledashboardpaneledge) | A list of edges. |
| <a id="customizabledashboardpanelconnectionnodes"></a>`nodes` | [`[CustomizableDashboardPanel]`](#customizabledashboardpanel) | A list of nodes. |
| <a id="customizabledashboardpanelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomizableDashboardPanelEdge`

The edge type for [`CustomizableDashboardPanel`](#customizabledashboardpanel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizabledashboardpaneledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customizabledashboardpaneledgenode"></a>`node` | [`CustomizableDashboardPanel`](#customizabledashboardpanel) | The item at the end of the edge. |

#### `CustomizableDashboardVisualizationConnection`

The connection type for [`CustomizableDashboardVisualization`](#customizabledashboardvisualization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizabledashboardvisualizationconnectionedges"></a>`edges` | [`[CustomizableDashboardVisualizationEdge]`](#customizabledashboardvisualizationedge) | A list of edges. |
| <a id="customizabledashboardvisualizationconnectionnodes"></a>`nodes` | [`[CustomizableDashboardVisualization]`](#customizabledashboardvisualization) | A list of nodes. |
| <a id="customizabledashboardvisualizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomizableDashboardVisualizationEdge`

The edge type for [`CustomizableDashboardVisualization`](#customizabledashboardvisualization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizabledashboardvisualizationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customizabledashboardvisualizationedgenode"></a>`node` | [`CustomizableDashboardVisualization`](#customizabledashboardvisualization) | The item at the end of the edge. |

#### `CustomizablePermissionConnection`

The connection type for [`CustomizablePermission`](#customizablepermission).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizablepermissionconnectionedges"></a>`edges` | [`[CustomizablePermissionEdge]`](#customizablepermissionedge) | A list of edges. |
| <a id="customizablepermissionconnectionnodes"></a>`nodes` | [`[CustomizablePermission]`](#customizablepermission) | A list of nodes. |
| <a id="customizablepermissionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `CustomizablePermissionEdge`

The edge type for [`CustomizablePermission`](#customizablepermission).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="customizablepermissionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="customizablepermissionedgenode"></a>`node` | [`CustomizablePermission`](#customizablepermission) | The item at the end of the edge. |

#### `DastProfileConnection`

The connection type for [`DastProfile`](#dastprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofileconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="dastprofileconnectionedges"></a>`edges` | [`[DastProfileEdge]`](#dastprofileedge) | A list of edges. |
| <a id="dastprofileconnectionnodes"></a>`nodes` | [`[DastProfile]`](#dastprofile) | A list of nodes. |
| <a id="dastprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastProfileEdge`

The edge type for [`DastProfile`](#dastprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastprofileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastprofileedgenode"></a>`node` | [`DastProfile`](#dastprofile) | The item at the end of the edge. |

#### `DastScannerProfileConnection`

The connection type for [`DastScannerProfile`](#dastscannerprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileconnectionedges"></a>`edges` | [`[DastScannerProfileEdge]`](#dastscannerprofileedge) | A list of edges. |
| <a id="dastscannerprofileconnectionnodes"></a>`nodes` | [`[DastScannerProfile]`](#dastscannerprofile) | A list of nodes. |
| <a id="dastscannerprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastScannerProfileEdge`

The edge type for [`DastScannerProfile`](#dastscannerprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastscannerprofileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastscannerprofileedgenode"></a>`node` | [`DastScannerProfile`](#dastscannerprofile) | The item at the end of the edge. |

#### `DastSiteProfileConnection`

The connection type for [`DastSiteProfile`](#dastsiteprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileconnectionedges"></a>`edges` | [`[DastSiteProfileEdge]`](#dastsiteprofileedge) | A list of edges. |
| <a id="dastsiteprofileconnectionnodes"></a>`nodes` | [`[DastSiteProfile]`](#dastsiteprofile) | A list of nodes. |
| <a id="dastsiteprofileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastSiteProfileEdge`

The edge type for [`DastSiteProfile`](#dastsiteprofile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsiteprofileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastsiteprofileedgenode"></a>`node` | [`DastSiteProfile`](#dastsiteprofile) | The item at the end of the edge. |

#### `DastSiteValidationConnection`

The connection type for [`DastSiteValidation`](#dastsitevalidation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationconnectionedges"></a>`edges` | [`[DastSiteValidationEdge]`](#dastsitevalidationedge) | A list of edges. |
| <a id="dastsitevalidationconnectionnodes"></a>`nodes` | [`[DastSiteValidation]`](#dastsitevalidation) | A list of nodes. |
| <a id="dastsitevalidationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DastSiteValidationEdge`

The edge type for [`DastSiteValidation`](#dastsitevalidation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dastsitevalidationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dastsitevalidationedgenode"></a>`node` | [`DastSiteValidation`](#dastsitevalidation) | The item at the end of the edge. |

#### `DependencyConnection`

The connection type for [`Dependency`](#dependency).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyconnectionedges"></a>`edges` | [`[DependencyEdge]`](#dependencyedge) | A list of edges. |
| <a id="dependencyconnectionnodes"></a>`nodes` | [`[Dependency]`](#dependency) | A list of nodes. |
| <a id="dependencyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyEdge`

The edge type for [`Dependency`](#dependency).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyedgenode"></a>`node` | [`Dependency`](#dependency) | The item at the end of the edge. |

#### `DependencyProxyBlobConnection`

The connection type for [`DependencyProxyBlob`](#dependencyproxyblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobconnectionedges"></a>`edges` | [`[DependencyProxyBlobEdge]`](#dependencyproxyblobedge) | A list of edges. |
| <a id="dependencyproxyblobconnectionnodes"></a>`nodes` | [`[DependencyProxyBlob]`](#dependencyproxyblob) | A list of nodes. |
| <a id="dependencyproxyblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyBlobEdge`

The edge type for [`DependencyProxyBlob`](#dependencyproxyblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxyblobedgenode"></a>`node` | [`DependencyProxyBlob`](#dependencyproxyblob) | The item at the end of the edge. |

#### `DependencyProxyBlobRegistryConnection`

The connection type for [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryconnectionedges"></a>`edges` | [`[DependencyProxyBlobRegistryEdge]`](#dependencyproxyblobregistryedge) | A list of edges. |
| <a id="dependencyproxyblobregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyBlobRegistry]`](#dependencyproxyblobregistry) | A list of nodes. |
| <a id="dependencyproxyblobregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyBlobRegistryEdge`

The edge type for [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxyblobregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxyblobregistryedgenode"></a>`node` | [`DependencyProxyBlobRegistry`](#dependencyproxyblobregistry) | The item at the end of the edge. |

#### `DependencyProxyManifestConnection`

The connection type for [`DependencyProxyManifest`](#dependencyproxymanifest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestconnectionedges"></a>`edges` | [`[DependencyProxyManifestEdge]`](#dependencyproxymanifestedge) | A list of edges. |
| <a id="dependencyproxymanifestconnectionnodes"></a>`nodes` | [`[DependencyProxyManifest]`](#dependencyproxymanifest) | A list of nodes. |
| <a id="dependencyproxymanifestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyManifestEdge`

The edge type for [`DependencyProxyManifest`](#dependencyproxymanifest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxymanifestedgenode"></a>`node` | [`DependencyProxyManifest`](#dependencyproxymanifest) | The item at the end of the edge. |

#### `DependencyProxyManifestRegistryConnection`

The connection type for [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryconnectionedges"></a>`edges` | [`[DependencyProxyManifestRegistryEdge]`](#dependencyproxymanifestregistryedge) | A list of edges. |
| <a id="dependencyproxymanifestregistryconnectionnodes"></a>`nodes` | [`[DependencyProxyManifestRegistry]`](#dependencyproxymanifestregistry) | A list of nodes. |
| <a id="dependencyproxymanifestregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DependencyProxyManifestRegistryEdge`

The edge type for [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="dependencyproxymanifestregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="dependencyproxymanifestregistryedgenode"></a>`node` | [`DependencyProxyManifestRegistry`](#dependencyproxymanifestregistry) | The item at the end of the edge. |

#### `DeploymentConnection`

The connection type for [`Deployment`](#deployment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentconnectionedges"></a>`edges` | [`[DeploymentEdge]`](#deploymentedge) | A list of edges. |
| <a id="deploymentconnectionnodes"></a>`nodes` | [`[Deployment]`](#deployment) | A list of nodes. |
| <a id="deploymentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DeploymentEdge`

The edge type for [`Deployment`](#deployment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="deploymentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="deploymentedgenode"></a>`node` | [`Deployment`](#deployment) | The item at the end of the edge. |

#### `DesignAtVersionConnection`

The connection type for [`DesignAtVersion`](#designatversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designatversionconnectionedges"></a>`edges` | [`[DesignAtVersionEdge]`](#designatversionedge) | A list of edges. |
| <a id="designatversionconnectionnodes"></a>`nodes` | [`[DesignAtVersion]`](#designatversion) | A list of nodes. |
| <a id="designatversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignAtVersionEdge`

The edge type for [`DesignAtVersion`](#designatversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designatversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designatversionedgenode"></a>`node` | [`DesignAtVersion`](#designatversion) | The item at the end of the edge. |

#### `DesignConnection`

The connection type for [`Design`](#design).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designconnectionedges"></a>`edges` | [`[DesignEdge]`](#designedge) | A list of edges. |
| <a id="designconnectionnodes"></a>`nodes` | [`[Design]`](#design) | A list of nodes. |
| <a id="designconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignEdge`

The edge type for [`Design`](#design).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designedgenode"></a>`node` | [`Design`](#design) | The item at the end of the edge. |

#### `DesignManagementRepositoryRegistryConnection`

The connection type for [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryconnectionedges"></a>`edges` | [`[DesignManagementRepositoryRegistryEdge]`](#designmanagementrepositoryregistryedge) | A list of edges. |
| <a id="designmanagementrepositoryregistryconnectionnodes"></a>`nodes` | [`[DesignManagementRepositoryRegistry]`](#designmanagementrepositoryregistry) | A list of nodes. |
| <a id="designmanagementrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignManagementRepositoryRegistryEdge`

The edge type for [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designmanagementrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designmanagementrepositoryregistryedgenode"></a>`node` | [`DesignManagementRepositoryRegistry`](#designmanagementrepositoryregistry) | The item at the end of the edge. |

#### `DesignVersionConnection`

The connection type for [`DesignVersion`](#designversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversionconnectionedges"></a>`edges` | [`[DesignVersionEdge]`](#designversionedge) | A list of edges. |
| <a id="designversionconnectionnodes"></a>`nodes` | [`[DesignVersion]`](#designversion) | A list of nodes. |
| <a id="designversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DesignVersionEdge`

The edge type for [`DesignVersion`](#designversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="designversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="designversionedgenode"></a>`node` | [`DesignVersion`](#designversion) | The item at the end of the edge. |

#### `DevopsAdoptionEnabledNamespaceConnection`

The connection type for [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceconnectionedges"></a>`edges` | [`[DevopsAdoptionEnabledNamespaceEdge]`](#devopsadoptionenablednamespaceedge) | A list of edges. |
| <a id="devopsadoptionenablednamespaceconnectionnodes"></a>`nodes` | [`[DevopsAdoptionEnabledNamespace]`](#devopsadoptionenablednamespace) | A list of nodes. |
| <a id="devopsadoptionenablednamespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DevopsAdoptionEnabledNamespaceEdge`

The edge type for [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionenablednamespaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="devopsadoptionenablednamespaceedgenode"></a>`node` | [`DevopsAdoptionEnabledNamespace`](#devopsadoptionenablednamespace) | The item at the end of the edge. |

#### `DevopsAdoptionSnapshotConnection`

The connection type for [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotconnectionedges"></a>`edges` | [`[DevopsAdoptionSnapshotEdge]`](#devopsadoptionsnapshotedge) | A list of edges. |
| <a id="devopsadoptionsnapshotconnectionnodes"></a>`nodes` | [`[DevopsAdoptionSnapshot]`](#devopsadoptionsnapshot) | A list of nodes. |
| <a id="devopsadoptionsnapshotconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DevopsAdoptionSnapshotEdge`

The edge type for [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="devopsadoptionsnapshotedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="devopsadoptionsnapshotedgenode"></a>`node` | [`DevopsAdoptionSnapshot`](#devopsadoptionsnapshot) | The item at the end of the edge. |

#### `DiscussionConnection`

The connection type for [`Discussion`](#discussion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="discussionconnectionedges"></a>`edges` | [`[DiscussionEdge]`](#discussionedge) | A list of edges. |
| <a id="discussionconnectionnodes"></a>`nodes` | [`[Discussion]`](#discussion) | A list of nodes. |
| <a id="discussionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `DiscussionEdge`

The edge type for [`Discussion`](#discussion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="discussionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="discussionedgenode"></a>`node` | [`Discussion`](#discussion) | The item at the end of the edge. |

#### `DoraPerformanceScoreCountConnection`

The connection type for [`DoraPerformanceScoreCount`](#doraperformancescorecount).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="doraperformancescorecountconnectionedges"></a>`edges` | [`[DoraPerformanceScoreCountEdge]`](#doraperformancescorecountedge) | A list of edges. |
| <a id="doraperformancescorecountconnectionnodoradataprojectscount"></a>`noDoraDataProjectsCount` | [`Int!`](#int) | Count of projects without any DORA scores within the scope. |
| <a id="doraperformancescorecountconnectionnodes"></a>`nodes` | [`[DoraPerformanceScoreCount]`](#doraperformancescorecount) | A list of nodes. |
| <a id="doraperformancescorecountconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="doraperformancescorecountconnectiontotalprojectscount"></a>`totalProjectsCount` | [`Int!`](#int) | Count of total projects. |

#### `DoraPerformanceScoreCountEdge`

The edge type for [`DoraPerformanceScoreCount`](#doraperformancescorecount).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="doraperformancescorecountedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="doraperformancescorecountedgenode"></a>`node` | [`DoraPerformanceScoreCount`](#doraperformancescorecount) | The item at the end of the edge. |

#### `EgressNodeConnection`

The connection type for [`EgressNode`](#egressnode).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="egressnodeconnectionedges"></a>`edges` | [`[EgressNodeEdge]`](#egressnodeedge) | A list of edges. |
| <a id="egressnodeconnectionnodes"></a>`nodes` | [`[EgressNode]`](#egressnode) | A list of nodes. |
| <a id="egressnodeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EgressNodeEdge`

The edge type for [`EgressNode`](#egressnode).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="egressnodeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="egressnodeedgenode"></a>`node` | [`EgressNode`](#egressnode) | The item at the end of the edge. |

#### `EmailConnection`

The connection type for [`Email`](#email).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="emailconnectionedges"></a>`edges` | [`[EmailEdge]`](#emailedge) | A list of edges. |
| <a id="emailconnectionnodes"></a>`nodes` | [`[Email]`](#email) | A list of nodes. |
| <a id="emailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EmailEdge`

The edge type for [`Email`](#email).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="emailedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="emailedgenode"></a>`node` | [`Email`](#email) | The item at the end of the edge. |

#### `EnvironmentConnection`

The connection type for [`Environment`](#environment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentconnectionedges"></a>`edges` | [`[EnvironmentEdge]`](#environmentedge) | A list of edges. |
| <a id="environmentconnectionnodes"></a>`nodes` | [`[Environment]`](#environment) | A list of nodes. |
| <a id="environmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EnvironmentEdge`

The edge type for [`Environment`](#environment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="environmentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="environmentedgenode"></a>`node` | [`Environment`](#environment) | The item at the end of the edge. |

#### `EpicBoardConnection`

The connection type for [`EpicBoard`](#epicboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicboardconnectionedges"></a>`edges` | [`[EpicBoardEdge]`](#epicboardedge) | A list of edges. |
| <a id="epicboardconnectionnodes"></a>`nodes` | [`[EpicBoard]`](#epicboard) | A list of nodes. |
| <a id="epicboardconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EpicBoardEdge`

The edge type for [`EpicBoard`](#epicboard).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicboardedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epicboardedgenode"></a>`node` | [`EpicBoard`](#epicboard) | The item at the end of the edge. |

#### `EpicConnection`

The connection type for [`Epic`](#epic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="epicconnectionedges"></a>`edges` | [`[EpicEdge]`](#epicedge) | A list of edges. |
| <a id="epicconnectionnodes"></a>`nodes` | [`[Epic]`](#epic) | A list of nodes. |
| <a id="epicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EpicEdge`

The edge type for [`Epic`](#epic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epicedgenode"></a>`node` | [`Epic`](#epic) | The item at the end of the edge. |

#### `EpicIssueConnection`

The connection type for [`EpicIssue`](#epicissue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissueconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="epicissueconnectionedges"></a>`edges` | [`[EpicIssueEdge]`](#epicissueedge) | A list of edges. |
| <a id="epicissueconnectionnodes"></a>`nodes` | [`[EpicIssue]`](#epicissue) | A list of nodes. |
| <a id="epicissueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="epicissueconnectionweight"></a>`weight` | [`Int!`](#int) | Total weight of issues collection. |

#### `EpicIssueEdge`

The edge type for [`EpicIssue`](#epicissue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epicissueedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epicissueedgenode"></a>`node` | [`EpicIssue`](#epicissue) | The item at the end of the edge. |

#### `EpicListConnection`

The connection type for [`EpicList`](#epiclist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiclistconnectionedges"></a>`edges` | [`[EpicListEdge]`](#epiclistedge) | A list of edges. |
| <a id="epiclistconnectionnodes"></a>`nodes` | [`[EpicList]`](#epiclist) | A list of nodes. |
| <a id="epiclistconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EpicListEdge`

The edge type for [`EpicList`](#epiclist).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="epiclistedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="epiclistedgenode"></a>`node` | [`EpicList`](#epiclist) | The item at the end of the edge. |

#### `EscalationPolicyTypeConnection`

The connection type for [`EscalationPolicyType`](#escalationpolicytype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeconnectionedges"></a>`edges` | [`[EscalationPolicyTypeEdge]`](#escalationpolicytypeedge) | A list of edges. |
| <a id="escalationpolicytypeconnectionnodes"></a>`nodes` | [`[EscalationPolicyType]`](#escalationpolicytype) | A list of nodes. |
| <a id="escalationpolicytypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EscalationPolicyTypeEdge`

The edge type for [`EscalationPolicyType`](#escalationpolicytype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="escalationpolicytypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="escalationpolicytypeedgenode"></a>`node` | [`EscalationPolicyType`](#escalationpolicytype) | The item at the end of the edge. |

#### `EventConnection`

The connection type for [`Event`](#event).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="eventconnectionedges"></a>`edges` | [`[EventEdge]`](#eventedge) | A list of edges. |
| <a id="eventconnectionnodes"></a>`nodes` | [`[Event]`](#event) | A list of nodes. |
| <a id="eventconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `EventEdge`

The edge type for [`Event`](#event).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="eventedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="eventedgenode"></a>`node` | [`Event`](#event) | The item at the end of the edge. |

#### `ExternalAuditEventDestinationConnection`

The connection type for [`ExternalAuditEventDestination`](#externalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationconnectionedges"></a>`edges` | [`[ExternalAuditEventDestinationEdge]`](#externalauditeventdestinationedge) | A list of edges. |
| <a id="externalauditeventdestinationconnectionnodes"></a>`nodes` | [`[ExternalAuditEventDestination]`](#externalauditeventdestination) | A list of nodes. |
| <a id="externalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ExternalAuditEventDestinationEdge`

The edge type for [`ExternalAuditEventDestination`](#externalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="externalauditeventdestinationedgenode"></a>`node` | [`ExternalAuditEventDestination`](#externalauditeventdestination) | The item at the end of the edge. |

#### `ExternalStatusCheckConnection`

The connection type for [`ExternalStatusCheck`](#externalstatuscheck).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckconnectionedges"></a>`edges` | [`[ExternalStatusCheckEdge]`](#externalstatuscheckedge) | A list of edges. |
| <a id="externalstatuscheckconnectionnodes"></a>`nodes` | [`[ExternalStatusCheck]`](#externalstatuscheck) | A list of nodes. |
| <a id="externalstatuscheckconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ExternalStatusCheckEdge`

The edge type for [`ExternalStatusCheck`](#externalstatuscheck).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="externalstatuscheckedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="externalstatuscheckedgenode"></a>`node` | [`ExternalStatusCheck`](#externalstatuscheck) | The item at the end of the edge. |

#### `FeatureFlagConnection`

The connection type for [`FeatureFlag`](#featureflag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="featureflagconnectionedges"></a>`edges` | [`[FeatureFlagEdge]`](#featureflagedge) | A list of edges. |
| <a id="featureflagconnectionnodes"></a>`nodes` | [`[FeatureFlag]`](#featureflag) | A list of nodes. |
| <a id="featureflagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `FeatureFlagEdge`

The edge type for [`FeatureFlag`](#featureflag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="featureflagedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="featureflagedgenode"></a>`node` | [`FeatureFlag`](#featureflag) | The item at the end of the edge. |

#### `ForecastDatapointConnection`

The connection type for [`ForecastDatapoint`](#forecastdatapoint).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="forecastdatapointconnectionedges"></a>`edges` | [`[ForecastDatapointEdge]`](#forecastdatapointedge) | A list of edges. |
| <a id="forecastdatapointconnectionnodes"></a>`nodes` | [`[ForecastDatapoint]`](#forecastdatapoint) | A list of nodes. |
| <a id="forecastdatapointconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ForecastDatapointEdge`

The edge type for [`ForecastDatapoint`](#forecastdatapoint).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="forecastdatapointedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="forecastdatapointedgenode"></a>`node` | [`ForecastDatapoint`](#forecastdatapoint) | The item at the end of the edge. |

#### `GoogleCloudArtifactRegistryArtifactConnection`

The connection type for [`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="googlecloudartifactregistryartifactconnectionedges"></a>`edges` | [`[GoogleCloudArtifactRegistryArtifactEdge]`](#googlecloudartifactregistryartifactedge) | A list of edges. |
| <a id="googlecloudartifactregistryartifactconnectionnodes"></a>`nodes` | [`[GoogleCloudArtifactRegistryArtifact]`](#googlecloudartifactregistryartifact) | A list of nodes. |
| <a id="googlecloudartifactregistryartifactconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GoogleCloudArtifactRegistryArtifactEdge`

The edge type for [`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="googlecloudartifactregistryartifactedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="googlecloudartifactregistryartifactedgenode"></a>`node` | [`GoogleCloudArtifactRegistryArtifact`](#googlecloudartifactregistryartifact) | The item at the end of the edge. |

#### `GoogleCloudLoggingConfigurationTypeConnection`

The connection type for [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="googlecloudloggingconfigurationtypeconnectionedges"></a>`edges` | [`[GoogleCloudLoggingConfigurationTypeEdge]`](#googlecloudloggingconfigurationtypeedge) | A list of edges. |
| <a id="googlecloudloggingconfigurationtypeconnectionnodes"></a>`nodes` | [`[GoogleCloudLoggingConfigurationType]`](#googlecloudloggingconfigurationtype) | A list of nodes. |
| <a id="googlecloudloggingconfigurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GoogleCloudLoggingConfigurationTypeEdge`

The edge type for [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="googlecloudloggingconfigurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="googlecloudloggingconfigurationtypeedgenode"></a>`node` | [`GoogleCloudLoggingConfigurationType`](#googlecloudloggingconfigurationtype) | The item at the end of the edge. |

#### `GroupAuditEventStreamingDestinationConnection`

The connection type for [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupauditeventstreamingdestinationconnectionedges"></a>`edges` | [`[GroupAuditEventStreamingDestinationEdge]`](#groupauditeventstreamingdestinationedge) | A list of edges. |
| <a id="groupauditeventstreamingdestinationconnectionnodes"></a>`nodes` | [`[GroupAuditEventStreamingDestination]`](#groupauditeventstreamingdestination) | A list of nodes. |
| <a id="groupauditeventstreamingdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupAuditEventStreamingDestinationEdge`

The edge type for [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupauditeventstreamingdestinationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupauditeventstreamingdestinationedgenode"></a>`node` | [`GroupAuditEventStreamingDestination`](#groupauditeventstreamingdestination) | The item at the end of the edge. |

#### `GroupConnection`

The connection type for [`Group`](#group).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupconnectionedges"></a>`edges` | [`[GroupEdge]`](#groupedge) | A list of edges. |
| <a id="groupconnectionnodes"></a>`nodes` | [`[Group]`](#group) | A list of nodes. |
| <a id="groupconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupEdge`

The edge type for [`Group`](#group).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupedgenode"></a>`node` | [`Group`](#group) | The item at the end of the edge. |

#### `GroupMemberConnection`

The connection type for [`GroupMember`](#groupmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmemberconnectionedges"></a>`edges` | [`[GroupMemberEdge]`](#groupmemberedge) | A list of edges. |
| <a id="groupmemberconnectionnodes"></a>`nodes` | [`[GroupMember]`](#groupmember) | A list of nodes. |
| <a id="groupmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupMemberEdge`

The edge type for [`GroupMember`](#groupmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupmemberedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupmemberedgenode"></a>`node` | [`GroupMember`](#groupmember) | The item at the end of the edge. |

#### `GroupSavedReplyConnection`

The connection type for [`GroupSavedReply`](#groupsavedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupsavedreplyconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="groupsavedreplyconnectionedges"></a>`edges` | [`[GroupSavedReplyEdge]`](#groupsavedreplyedge) | A list of edges. |
| <a id="groupsavedreplyconnectionnodes"></a>`nodes` | [`[GroupSavedReply]`](#groupsavedreply) | A list of nodes. |
| <a id="groupsavedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupSavedReplyEdge`

The edge type for [`GroupSavedReply`](#groupsavedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupsavedreplyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupsavedreplyedgenode"></a>`node` | [`GroupSavedReply`](#groupsavedreply) | The item at the end of the edge. |

#### `GroupWikiRepositoryRegistryConnection`

The connection type for [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryconnectionedges"></a>`edges` | [`[GroupWikiRepositoryRegistryEdge]`](#groupwikirepositoryregistryedge) | A list of edges. |
| <a id="groupwikirepositoryregistryconnectionnodes"></a>`nodes` | [`[GroupWikiRepositoryRegistry]`](#groupwikirepositoryregistry) | A list of nodes. |
| <a id="groupwikirepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `GroupWikiRepositoryRegistryEdge`

The edge type for [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="groupwikirepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="groupwikirepositoryregistryedgenode"></a>`node` | [`GroupWikiRepositoryRegistry`](#groupwikirepositoryregistry) | The item at the end of the edge. |

#### `IncidentManagementOncallRotationConnection`

The connection type for [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationconnectionedges"></a>`edges` | [`[IncidentManagementOncallRotationEdge]`](#incidentmanagementoncallrotationedge) | A list of edges. |
| <a id="incidentmanagementoncallrotationconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallRotation]`](#incidentmanagementoncallrotation) | A list of nodes. |
| <a id="incidentmanagementoncallrotationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IncidentManagementOncallRotationEdge`

The edge type for [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallrotationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="incidentmanagementoncallrotationedgenode"></a>`node` | [`IncidentManagementOncallRotation`](#incidentmanagementoncallrotation) | The item at the end of the edge. |

#### `IncidentManagementOncallScheduleConnection`

The connection type for [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleconnectionedges"></a>`edges` | [`[IncidentManagementOncallScheduleEdge]`](#incidentmanagementoncallscheduleedge) | A list of edges. |
| <a id="incidentmanagementoncallscheduleconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallSchedule]`](#incidentmanagementoncallschedule) | A list of nodes. |
| <a id="incidentmanagementoncallscheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IncidentManagementOncallScheduleEdge`

The edge type for [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallscheduleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="incidentmanagementoncallscheduleedgenode"></a>`node` | [`IncidentManagementOncallSchedule`](#incidentmanagementoncallschedule) | The item at the end of the edge. |

#### `IncidentManagementOncallShiftConnection`

The connection type for [`IncidentManagementOncallShift`](#incidentmanagementoncallshift).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftconnectionedges"></a>`edges` | [`[IncidentManagementOncallShiftEdge]`](#incidentmanagementoncallshiftedge) | A list of edges. |
| <a id="incidentmanagementoncallshiftconnectionnodes"></a>`nodes` | [`[IncidentManagementOncallShift]`](#incidentmanagementoncallshift) | A list of nodes. |
| <a id="incidentmanagementoncallshiftconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IncidentManagementOncallShiftEdge`

The edge type for [`IncidentManagementOncallShift`](#incidentmanagementoncallshift).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="incidentmanagementoncallshiftedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="incidentmanagementoncallshiftedgenode"></a>`node` | [`IncidentManagementOncallShift`](#incidentmanagementoncallshift) | The item at the end of the edge. |

#### `InheritedCiVariableConnection`

The connection type for [`InheritedCiVariable`](#inheritedcivariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableconnectionedges"></a>`edges` | [`[InheritedCiVariableEdge]`](#inheritedcivariableedge) | A list of edges. |
| <a id="inheritedcivariableconnectionnodes"></a>`nodes` | [`[InheritedCiVariable]`](#inheritedcivariable) | A list of nodes. |
| <a id="inheritedcivariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `InheritedCiVariableEdge`

The edge type for [`InheritedCiVariable`](#inheritedcivariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="inheritedcivariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="inheritedcivariableedgenode"></a>`node` | [`InheritedCiVariable`](#inheritedcivariable) | The item at the end of the edge. |

#### `InstanceAmazonS3ConfigurationTypeConnection`

The connection type for [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceamazons3configurationtypeconnectionedges"></a>`edges` | [`[InstanceAmazonS3ConfigurationTypeEdge]`](#instanceamazons3configurationtypeedge) | A list of edges. |
| <a id="instanceamazons3configurationtypeconnectionnodes"></a>`nodes` | [`[InstanceAmazonS3ConfigurationType]`](#instanceamazons3configurationtype) | A list of nodes. |
| <a id="instanceamazons3configurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `InstanceAmazonS3ConfigurationTypeEdge`

The edge type for [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceamazons3configurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="instanceamazons3configurationtypeedgenode"></a>`node` | [`InstanceAmazonS3ConfigurationType`](#instanceamazons3configurationtype) | The item at the end of the edge. |

#### `InstanceAuditEventStreamingDestinationConnection`

The connection type for [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceauditeventstreamingdestinationconnectionedges"></a>`edges` | [`[InstanceAuditEventStreamingDestinationEdge]`](#instanceauditeventstreamingdestinationedge) | A list of edges. |
| <a id="instanceauditeventstreamingdestinationconnectionnodes"></a>`nodes` | [`[InstanceAuditEventStreamingDestination]`](#instanceauditeventstreamingdestination) | A list of nodes. |
| <a id="instanceauditeventstreamingdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `InstanceAuditEventStreamingDestinationEdge`

The edge type for [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceauditeventstreamingdestinationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="instanceauditeventstreamingdestinationedgenode"></a>`node` | [`InstanceAuditEventStreamingDestination`](#instanceauditeventstreamingdestination) | The item at the end of the edge. |

#### `InstanceExternalAuditEventDestinationConnection`

The connection type for [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationconnectionedges"></a>`edges` | [`[InstanceExternalAuditEventDestinationEdge]`](#instanceexternalauditeventdestinationedge) | A list of edges. |
| <a id="instanceexternalauditeventdestinationconnectionnodes"></a>`nodes` | [`[InstanceExternalAuditEventDestination]`](#instanceexternalauditeventdestination) | A list of nodes. |
| <a id="instanceexternalauditeventdestinationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `InstanceExternalAuditEventDestinationEdge`

The edge type for [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instanceexternalauditeventdestinationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="instanceexternalauditeventdestinationedgenode"></a>`node` | [`InstanceExternalAuditEventDestination`](#instanceexternalauditeventdestination) | The item at the end of the edge. |

#### `InstanceGoogleCloudLoggingConfigurationTypeConnection`

The connection type for [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionedges"></a>`edges` | [`[InstanceGoogleCloudLoggingConfigurationTypeEdge]`](#instancegooglecloudloggingconfigurationtypeedge) | A list of edges. |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionnodes"></a>`nodes` | [`[InstanceGoogleCloudLoggingConfigurationType]`](#instancegooglecloudloggingconfigurationtype) | A list of nodes. |
| <a id="instancegooglecloudloggingconfigurationtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `InstanceGoogleCloudLoggingConfigurationTypeEdge`

The edge type for [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="instancegooglecloudloggingconfigurationtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="instancegooglecloudloggingconfigurationtypeedgenode"></a>`node` | [`InstanceGoogleCloudLoggingConfigurationType`](#instancegooglecloudloggingconfigurationtype) | The item at the end of the edge. |

#### `IntegrationExclusionConnection`

The connection type for [`IntegrationExclusion`](#integrationexclusion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="integrationexclusionconnectionedges"></a>`edges` | [`[IntegrationExclusionEdge]`](#integrationexclusionedge) | A list of edges. |
| <a id="integrationexclusionconnectionnodes"></a>`nodes` | [`[IntegrationExclusion]`](#integrationexclusion) | A list of nodes. |
| <a id="integrationexclusionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IntegrationExclusionEdge`

The edge type for [`IntegrationExclusion`](#integrationexclusion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="integrationexclusionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="integrationexclusionedgenode"></a>`node` | [`IntegrationExclusion`](#integrationexclusion) | The item at the end of the edge. |

#### `IssuableResourceLinkConnection`

The connection type for [`IssuableResourceLink`](#issuableresourcelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkconnectionedges"></a>`edges` | [`[IssuableResourceLinkEdge]`](#issuableresourcelinkedge) | A list of edges. |
| <a id="issuableresourcelinkconnectionnodes"></a>`nodes` | [`[IssuableResourceLink]`](#issuableresourcelink) | A list of nodes. |
| <a id="issuableresourcelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IssuableResourceLinkEdge`

The edge type for [`IssuableResourceLink`](#issuableresourcelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issuableresourcelinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="issuableresourcelinkedgenode"></a>`node` | [`IssuableResourceLink`](#issuableresourcelink) | The item at the end of the edge. |

#### `IssueConnection`

The connection type for [`Issue`](#issue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issueconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="issueconnectionedges"></a>`edges` | [`[IssueEdge]`](#issueedge) | A list of edges. |
| <a id="issueconnectionnodes"></a>`nodes` | [`[Issue]`](#issue) | A list of nodes. |
| <a id="issueconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="issueconnectionweight"></a>`weight` | [`Int!`](#int) | Total weight of issues collection. |

#### `IssueEdge`

The edge type for [`Issue`](#issue).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="issueedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="issueedgenode"></a>`node` | [`Issue`](#issue) | The item at the end of the edge. |

#### `IterationCadenceConnection`

The connection type for [`IterationCadence`](#iterationcadence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationcadenceconnectionedges"></a>`edges` | [`[IterationCadenceEdge]`](#iterationcadenceedge) | A list of edges. |
| <a id="iterationcadenceconnectionnodes"></a>`nodes` | [`[IterationCadence]`](#iterationcadence) | A list of nodes. |
| <a id="iterationcadenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IterationCadenceEdge`

The edge type for [`IterationCadence`](#iterationcadence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationcadenceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="iterationcadenceedgenode"></a>`node` | [`IterationCadence`](#iterationcadence) | The item at the end of the edge. |

#### `IterationConnection`

The connection type for [`Iteration`](#iteration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationconnectionedges"></a>`edges` | [`[IterationEdge]`](#iterationedge) | A list of edges. |
| <a id="iterationconnectionnodes"></a>`nodes` | [`[Iteration]`](#iteration) | A list of nodes. |
| <a id="iterationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `IterationEdge`

The edge type for [`Iteration`](#iteration).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="iterationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="iterationedgenode"></a>`node` | [`Iteration`](#iteration) | The item at the end of the edge. |

#### `JiraImportConnection`

The connection type for [`JiraImport`](#jiraimport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraimportconnectionedges"></a>`edges` | [`[JiraImportEdge]`](#jiraimportedge) | A list of edges. |
| <a id="jiraimportconnectionnodes"></a>`nodes` | [`[JiraImport]`](#jiraimport) | A list of nodes. |
| <a id="jiraimportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JiraImportEdge`

The edge type for [`JiraImport`](#jiraimport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraimportedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jiraimportedgenode"></a>`node` | [`JiraImport`](#jiraimport) | The item at the end of the edge. |

#### `JiraProjectConnection`

The connection type for [`JiraProject`](#jiraproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraprojectconnectionedges"></a>`edges` | [`[JiraProjectEdge]`](#jiraprojectedge) | A list of edges. |
| <a id="jiraprojectconnectionnodes"></a>`nodes` | [`[JiraProject]`](#jiraproject) | A list of nodes. |
| <a id="jiraprojectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JiraProjectEdge`

The edge type for [`JiraProject`](#jiraproject).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jiraprojectedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jiraprojectedgenode"></a>`node` | [`JiraProject`](#jiraproject) | The item at the end of the edge. |

#### `JobArtifactRegistryConnection`

The connection type for [`JobArtifactRegistry`](#jobartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryconnectionedges"></a>`edges` | [`[JobArtifactRegistryEdge]`](#jobartifactregistryedge) | A list of edges. |
| <a id="jobartifactregistryconnectionnodes"></a>`nodes` | [`[JobArtifactRegistry]`](#jobartifactregistry) | A list of nodes. |
| <a id="jobartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JobArtifactRegistryEdge`

The edge type for [`JobArtifactRegistry`](#jobartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jobartifactregistryedgenode"></a>`node` | [`JobArtifactRegistry`](#jobartifactregistry) | The item at the end of the edge. |

#### `JobNeedUnionConnection`

The connection type for [`JobNeedUnion`](#jobneedunion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobneedunionconnectionedges"></a>`edges` | [`[JobNeedUnionEdge]`](#jobneedunionedge) | A list of edges. |
| <a id="jobneedunionconnectionnodes"></a>`nodes` | [`[JobNeedUnion]`](#jobneedunion) | A list of nodes. |
| <a id="jobneedunionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `JobNeedUnionEdge`

The edge type for [`JobNeedUnion`](#jobneedunion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="jobneedunionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="jobneedunionedgenode"></a>`node` | [`JobNeedUnion`](#jobneedunion) | The item at the end of the edge. |

#### `LabelConnection`

The connection type for [`Label`](#label).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="labelconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="labelconnectionedges"></a>`edges` | [`[LabelEdge]`](#labeledge) | A list of edges. |
| <a id="labelconnectionnodes"></a>`nodes` | [`[Label]`](#label) | A list of nodes. |
| <a id="labelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `LabelEdge`

The edge type for [`Label`](#label).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="labeledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="labeledgenode"></a>`node` | [`Label`](#label) | The item at the end of the edge. |

#### `LfsObjectRegistryConnection`

The connection type for [`LfsObjectRegistry`](#lfsobjectregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryconnectionedges"></a>`edges` | [`[LfsObjectRegistryEdge]`](#lfsobjectregistryedge) | A list of edges. |
| <a id="lfsobjectregistryconnectionnodes"></a>`nodes` | [`[LfsObjectRegistry]`](#lfsobjectregistry) | A list of nodes. |
| <a id="lfsobjectregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `LfsObjectRegistryEdge`

The edge type for [`LfsObjectRegistry`](#lfsobjectregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="lfsobjectregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="lfsobjectregistryedgenode"></a>`node` | [`LfsObjectRegistry`](#lfsobjectregistry) | The item at the end of the edge. |

#### `LicenseHistoryEntryConnection`

The connection type for [`LicenseHistoryEntry`](#licensehistoryentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryconnectionedges"></a>`edges` | [`[LicenseHistoryEntryEdge]`](#licensehistoryentryedge) | A list of edges. |
| <a id="licensehistoryentryconnectionnodes"></a>`nodes` | [`[LicenseHistoryEntry]`](#licensehistoryentry) | A list of nodes. |
| <a id="licensehistoryentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `LicenseHistoryEntryEdge`

The edge type for [`LicenseHistoryEntry`](#licensehistoryentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="licensehistoryentryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="licensehistoryentryedgenode"></a>`node` | [`LicenseHistoryEntry`](#licensehistoryentry) | The item at the end of the edge. |

#### `LinkedWorkItemTypeConnection`

The connection type for [`LinkedWorkItemType`](#linkedworkitemtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="linkedworkitemtypeconnectionedges"></a>`edges` | [`[LinkedWorkItemTypeEdge]`](#linkedworkitemtypeedge) | A list of edges. |
| <a id="linkedworkitemtypeconnectionnodes"></a>`nodes` | [`[LinkedWorkItemType]`](#linkedworkitemtype) | A list of nodes. |
| <a id="linkedworkitemtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `LinkedWorkItemTypeEdge`

The edge type for [`LinkedWorkItemType`](#linkedworkitemtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="linkedworkitemtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="linkedworkitemtypeedgenode"></a>`node` | [`LinkedWorkItemType`](#linkedworkitemtype) | The item at the end of the edge. |

#### `MemberInterfaceConnection`

The connection type for [`MemberInterface`](#memberinterface).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="memberinterfaceconnectionedges"></a>`edges` | [`[MemberInterfaceEdge]`](#memberinterfaceedge) | A list of edges. |
| <a id="memberinterfaceconnectionnodes"></a>`nodes` | [`[MemberInterface]`](#memberinterface) | A list of nodes. |
| <a id="memberinterfaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MemberInterfaceEdge`

The edge type for [`MemberInterface`](#memberinterface).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="memberinterfaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="memberinterfaceedgenode"></a>`node` | [`MemberInterface`](#memberinterface) | The item at the end of the edge. |

#### `MemberRoleConnection`

The connection type for [`MemberRole`](#memberrole).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="memberroleconnectionedges"></a>`edges` | [`[MemberRoleEdge]`](#memberroleedge) | A list of edges. |
| <a id="memberroleconnectionnodes"></a>`nodes` | [`[MemberRole]`](#memberrole) | A list of nodes. |
| <a id="memberroleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MemberRoleEdge`

The edge type for [`MemberRole`](#memberrole).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="memberroleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="memberroleedgenode"></a>`node` | [`MemberRole`](#memberrole) | The item at the end of the edge. |

#### `MergeAccessLevelConnection`

The connection type for [`MergeAccessLevel`](#mergeaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergeaccesslevelconnectionedges"></a>`edges` | [`[MergeAccessLevelEdge]`](#mergeaccessleveledge) | A list of edges. |
| <a id="mergeaccesslevelconnectionnodes"></a>`nodes` | [`[MergeAccessLevel]`](#mergeaccesslevel) | A list of nodes. |
| <a id="mergeaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeAccessLevelEdge`

The edge type for [`MergeAccessLevel`](#mergeaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergeaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergeaccessleveledgenode"></a>`node` | [`MergeAccessLevel`](#mergeaccesslevel) | The item at the end of the edge. |

#### `MergeRequestAssigneeConnection`

The connection type for [`MergeRequestAssignee`](#mergerequestassignee).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="mergerequestassigneeconnectionedges"></a>`edges` | [`[MergeRequestAssigneeEdge]`](#mergerequestassigneeedge) | A list of edges. |
| <a id="mergerequestassigneeconnectionnodes"></a>`nodes` | [`[MergeRequestAssignee]`](#mergerequestassignee) | A list of nodes. |
| <a id="mergerequestassigneeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestAssigneeEdge`

The edge type for [`MergeRequestAssignee`](#mergerequestassignee).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestassigneeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestassigneeedgenode"></a>`node` | [`MergeRequestAssignee`](#mergerequestassignee) | The item at the end of the edge. |

#### `MergeRequestConnection`

The connection type for [`MergeRequest`](#mergerequest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="mergerequestconnectionedges"></a>`edges` | [`[MergeRequestEdge]`](#mergerequestedge) | A list of edges. |
| <a id="mergerequestconnectionnodes"></a>`nodes` | [`[MergeRequest]`](#mergerequest) | A list of nodes. |
| <a id="mergerequestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="mergerequestconnectiontotaltimetomerge"></a>`totalTimeToMerge` | [`Float`](#float) | Total sum of time to merge, in seconds, for the collection of merge requests. |

#### `MergeRequestDiffConnection`

The connection type for [`MergeRequestDiff`](#mergerequestdiff).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffconnectionedges"></a>`edges` | [`[MergeRequestDiffEdge]`](#mergerequestdiffedge) | A list of edges. |
| <a id="mergerequestdiffconnectionnodes"></a>`nodes` | [`[MergeRequestDiff]`](#mergerequestdiff) | A list of nodes. |
| <a id="mergerequestdiffconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestDiffEdge`

The edge type for [`MergeRequestDiff`](#mergerequestdiff).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestdiffedgenode"></a>`node` | [`MergeRequestDiff`](#mergerequestdiff) | The item at the end of the edge. |

#### `MergeRequestDiffRegistryConnection`

The connection type for [`MergeRequestDiffRegistry`](#mergerequestdiffregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryconnectionedges"></a>`edges` | [`[MergeRequestDiffRegistryEdge]`](#mergerequestdiffregistryedge) | A list of edges. |
| <a id="mergerequestdiffregistryconnectionnodes"></a>`nodes` | [`[MergeRequestDiffRegistry]`](#mergerequestdiffregistry) | A list of nodes. |
| <a id="mergerequestdiffregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestDiffRegistryEdge`

The edge type for [`MergeRequestDiffRegistry`](#mergerequestdiffregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestdiffregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestdiffregistryedgenode"></a>`node` | [`MergeRequestDiffRegistry`](#mergerequestdiffregistry) | The item at the end of the edge. |

#### `MergeRequestEdge`

The edge type for [`MergeRequest`](#mergerequest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestedgenode"></a>`node` | [`MergeRequest`](#mergerequest) | The item at the end of the edge. |

#### `MergeRequestParticipantConnection`

The connection type for [`MergeRequestParticipant`](#mergerequestparticipant).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="mergerequestparticipantconnectionedges"></a>`edges` | [`[MergeRequestParticipantEdge]`](#mergerequestparticipantedge) | A list of edges. |
| <a id="mergerequestparticipantconnectionnodes"></a>`nodes` | [`[MergeRequestParticipant]`](#mergerequestparticipant) | A list of nodes. |
| <a id="mergerequestparticipantconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestParticipantEdge`

The edge type for [`MergeRequestParticipant`](#mergerequestparticipant).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestparticipantedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestparticipantedgenode"></a>`node` | [`MergeRequestParticipant`](#mergerequestparticipant) | The item at the end of the edge. |

#### `MergeRequestReviewLlmSummaryConnection`

The connection type for [`MergeRequestReviewLlmSummary`](#mergerequestreviewllmsummary).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestreviewllmsummaryconnectionedges"></a>`edges` | [`[MergeRequestReviewLlmSummaryEdge]`](#mergerequestreviewllmsummaryedge) | A list of edges. |
| <a id="mergerequestreviewllmsummaryconnectionnodes"></a>`nodes` | [`[MergeRequestReviewLlmSummary]`](#mergerequestreviewllmsummary) | A list of nodes. |
| <a id="mergerequestreviewllmsummaryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestReviewLlmSummaryEdge`

The edge type for [`MergeRequestReviewLlmSummary`](#mergerequestreviewllmsummary).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestreviewllmsummaryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestreviewllmsummaryedgenode"></a>`node` | [`MergeRequestReviewLlmSummary`](#mergerequestreviewllmsummary) | The item at the end of the edge. |

#### `MergeRequestReviewerConnection`

The connection type for [`MergeRequestReviewer`](#mergerequestreviewer).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestreviewerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="mergerequestreviewerconnectionedges"></a>`edges` | [`[MergeRequestReviewerEdge]`](#mergerequestrevieweredge) | A list of edges. |
| <a id="mergerequestreviewerconnectionnodes"></a>`nodes` | [`[MergeRequestReviewer]`](#mergerequestreviewer) | A list of nodes. |
| <a id="mergerequestreviewerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MergeRequestReviewerEdge`

The edge type for [`MergeRequestReviewer`](#mergerequestreviewer).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mergerequestrevieweredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mergerequestrevieweredgenode"></a>`node` | [`MergeRequestReviewer`](#mergerequestreviewer) | The item at the end of the edge. |

#### `MilestoneConnection`

The connection type for [`Milestone`](#milestone).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="milestoneconnectionedges"></a>`edges` | [`[MilestoneEdge]`](#milestoneedge) | A list of edges. |
| <a id="milestoneconnectionnodes"></a>`nodes` | [`[Milestone]`](#milestone) | A list of nodes. |
| <a id="milestoneconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `MilestoneEdge`

The edge type for [`Milestone`](#milestone).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="milestoneedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="milestoneedgenode"></a>`node` | [`Milestone`](#milestone) | The item at the end of the edge. |

#### `MlCandidateConnection`

The connection type for [`MlCandidate`](#mlcandidate).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidateconnectionedges"></a>`edges` | [`[MlCandidateEdge]`](#mlcandidateedge) | A list of edges. |
| <a id="mlcandidateconnectionnodes"></a>`nodes` | [`[MlCandidate]`](#mlcandidate) | A list of nodes. |
| <a id="mlcandidateconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `MlCandidateConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidateconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `MlCandidateEdge`

The edge type for [`MlCandidate`](#mlcandidate).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidateedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mlcandidateedgenode"></a>`node` | [`MlCandidate`](#mlcandidate) | The item at the end of the edge. |

#### `MlCandidateMetadataConnection`

The connection type for [`MlCandidateMetadata`](#mlcandidatemetadata).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataconnectionedges"></a>`edges` | [`[MlCandidateMetadataEdge]`](#mlcandidatemetadataedge) | A list of edges. |
| <a id="mlcandidatemetadataconnectionnodes"></a>`nodes` | [`[MlCandidateMetadata]`](#mlcandidatemetadata) | A list of nodes. |
| <a id="mlcandidatemetadataconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `MlCandidateMetadataConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `MlCandidateMetadataEdge`

The edge type for [`MlCandidateMetadata`](#mlcandidatemetadata).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetadataedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mlcandidatemetadataedgenode"></a>`node` | [`MlCandidateMetadata`](#mlcandidatemetadata) | The item at the end of the edge. |

#### `MlCandidateMetricConnection`

The connection type for [`MlCandidateMetric`](#mlcandidatemetric).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricconnectionedges"></a>`edges` | [`[MlCandidateMetricEdge]`](#mlcandidatemetricedge) | A list of edges. |
| <a id="mlcandidatemetricconnectionnodes"></a>`nodes` | [`[MlCandidateMetric]`](#mlcandidatemetric) | A list of nodes. |
| <a id="mlcandidatemetricconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `MlCandidateMetricConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `MlCandidateMetricEdge`

The edge type for [`MlCandidateMetric`](#mlcandidatemetric).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidatemetricedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mlcandidatemetricedgenode"></a>`node` | [`MlCandidateMetric`](#mlcandidatemetric) | The item at the end of the edge. |

#### `MlCandidateParamConnection`

The connection type for [`MlCandidateParam`](#mlcandidateparam).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamconnectionedges"></a>`edges` | [`[MlCandidateParamEdge]`](#mlcandidateparamedge) | A list of edges. |
| <a id="mlcandidateparamconnectionnodes"></a>`nodes` | [`[MlCandidateParam]`](#mlcandidateparam) | A list of nodes. |
| <a id="mlcandidateparamconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `MlCandidateParamConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `MlCandidateParamEdge`

The edge type for [`MlCandidateParam`](#mlcandidateparam).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlcandidateparamedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mlcandidateparamedgenode"></a>`node` | [`MlCandidateParam`](#mlcandidateparam) | The item at the end of the edge. |

#### `MlModelConnection`

The connection type for [`MlModel`](#mlmodel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlmodelconnectionedges"></a>`edges` | [`[MlModelEdge]`](#mlmodeledge) | A list of edges. |
| <a id="mlmodelconnectionnodes"></a>`nodes` | [`[MlModel]`](#mlmodel) | A list of nodes. |
| <a id="mlmodelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `MlModelConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlmodelconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `MlModelEdge`

The edge type for [`MlModel`](#mlmodel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlmodeledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mlmodeledgenode"></a>`node` | [`MlModel`](#mlmodel) | The item at the end of the edge. |

#### `MlModelVersionConnection`

The connection type for [`MlModelVersion`](#mlmodelversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlmodelversionconnectionedges"></a>`edges` | [`[MlModelVersionEdge]`](#mlmodelversionedge) | A list of edges. |
| <a id="mlmodelversionconnectionnodes"></a>`nodes` | [`[MlModelVersion]`](#mlmodelversion) | A list of nodes. |
| <a id="mlmodelversionconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

##### Fields with arguments

###### `MlModelVersionConnection.count`

Limited count of collection. Returns limit + 1 for counts greater than the limit.

Returns [`Int!`](#int).

####### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlmodelversionconnectioncountlimit"></a>`limit` | [`Int`](#int) | Limit value to be applied to the count query. Default is 1000. |

#### `MlModelVersionEdge`

The edge type for [`MlModelVersion`](#mlmodelversion).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="mlmodelversionedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="mlmodelversionedgenode"></a>`node` | [`MlModelVersion`](#mlmodelversion) | The item at the end of the edge. |

#### `NamespaceCommitEmailConnection`

The connection type for [`NamespaceCommitEmail`](#namespacecommitemail).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailconnectionedges"></a>`edges` | [`[NamespaceCommitEmailEdge]`](#namespacecommitemailedge) | A list of edges. |
| <a id="namespacecommitemailconnectionnodes"></a>`nodes` | [`[NamespaceCommitEmail]`](#namespacecommitemail) | A list of nodes. |
| <a id="namespacecommitemailconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NamespaceCommitEmailEdge`

The edge type for [`NamespaceCommitEmail`](#namespacecommitemail).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespacecommitemailedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="namespacecommitemailedgenode"></a>`node` | [`NamespaceCommitEmail`](#namespacecommitemail) | The item at the end of the edge. |

#### `NamespaceConnection`

The connection type for [`Namespace`](#namespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespaceconnectionedges"></a>`edges` | [`[NamespaceEdge]`](#namespaceedge) | A list of edges. |
| <a id="namespaceconnectionnodes"></a>`nodes` | [`[Namespace]`](#namespace) | A list of nodes. |
| <a id="namespaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NamespaceEdge`

The edge type for [`Namespace`](#namespace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="namespaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="namespaceedgenode"></a>`node` | [`Namespace`](#namespace) | The item at the end of the edge. |

#### `NestedEnvironmentConnection`

The connection type for [`NestedEnvironment`](#nestedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentconnectionedges"></a>`edges` | [`[NestedEnvironmentEdge]`](#nestedenvironmentedge) | A list of edges. |
| <a id="nestedenvironmentconnectionnodes"></a>`nodes` | [`[NestedEnvironment]`](#nestedenvironment) | A list of nodes. |
| <a id="nestedenvironmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NestedEnvironmentEdge`

The edge type for [`NestedEnvironment`](#nestedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="nestedenvironmentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="nestedenvironmentedgenode"></a>`node` | [`NestedEnvironment`](#nestedenvironment) | The item at the end of the edge. |

#### `NoteConnection`

The connection type for [`Note`](#note).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="noteconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="noteconnectionedges"></a>`edges` | [`[NoteEdge]`](#noteedge) | A list of edges. |
| <a id="noteconnectionnodes"></a>`nodes` | [`[Note]`](#note) | A list of nodes. |
| <a id="noteconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `NoteEdge`

The edge type for [`Note`](#note).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="noteedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="noteedgenode"></a>`node` | [`Note`](#note) | The item at the end of the edge. |

#### `OncallParticipantTypeConnection`

The connection type for [`OncallParticipantType`](#oncallparticipanttype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeconnectionedges"></a>`edges` | [`[OncallParticipantTypeEdge]`](#oncallparticipanttypeedge) | A list of edges. |
| <a id="oncallparticipanttypeconnectionnodes"></a>`nodes` | [`[OncallParticipantType]`](#oncallparticipanttype) | A list of nodes. |
| <a id="oncallparticipanttypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `OncallParticipantTypeEdge`

The edge type for [`OncallParticipantType`](#oncallparticipanttype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="oncallparticipanttypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="oncallparticipanttypeedgenode"></a>`node` | [`OncallParticipantType`](#oncallparticipanttype) | The item at the end of the edge. |

#### `OrganizationConnection`

The connection type for [`Organization`](#organization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="organizationconnectionedges"></a>`edges` | [`[OrganizationEdge]`](#organizationedge) | A list of edges. |
| <a id="organizationconnectionnodes"></a>`nodes` | [`[Organization]`](#organization) | A list of nodes. |
| <a id="organizationconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `OrganizationEdge`

The edge type for [`Organization`](#organization).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="organizationedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="organizationedgenode"></a>`node` | [`Organization`](#organization) | The item at the end of the edge. |

#### `OrganizationUserConnection`

The connection type for [`OrganizationUser`](#organizationuser).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="organizationuserconnectionedges"></a>`edges` | [`[OrganizationUserEdge]`](#organizationuseredge) | A list of edges. |
| <a id="organizationuserconnectionnodes"></a>`nodes` | [`[OrganizationUser]`](#organizationuser) | A list of nodes. |
| <a id="organizationuserconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `OrganizationUserEdge`

The edge type for [`OrganizationUser`](#organizationuser).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="organizationuseredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="organizationuseredgenode"></a>`node` | [`OrganizationUser`](#organizationuser) | The item at the end of the edge. |

#### `PackageBaseConnection`

The connection type for [`PackageBase`](#packagebase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagebaseconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="packagebaseconnectionedges"></a>`edges` | [`[PackageBaseEdge]`](#packagebaseedge) | A list of edges. |
| <a id="packagebaseconnectionnodes"></a>`nodes` | [`[PackageBase]`](#packagebase) | A list of nodes. |
| <a id="packagebaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageBaseEdge`

The edge type for [`PackageBase`](#packagebase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagebaseedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagebaseedgenode"></a>`node` | [`PackageBase`](#packagebase) | The item at the end of the edge. |

#### `PackageConnection`

The connection type for [`Package`](#package).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packageconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="packageconnectionedges"></a>`edges` | [`[PackageEdge]`](#packageedge) | A list of edges. |
| <a id="packageconnectionnodes"></a>`nodes` | [`[Package]`](#package) | A list of nodes. |
| <a id="packageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageDependencyLinkConnection`

The connection type for [`PackageDependencyLink`](#packagedependencylink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkconnectionedges"></a>`edges` | [`[PackageDependencyLinkEdge]`](#packagedependencylinkedge) | A list of edges. |
| <a id="packagedependencylinkconnectionnodes"></a>`nodes` | [`[PackageDependencyLink]`](#packagedependencylink) | A list of nodes. |
| <a id="packagedependencylinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageDependencyLinkEdge`

The edge type for [`PackageDependencyLink`](#packagedependencylink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagedependencylinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagedependencylinkedgenode"></a>`node` | [`PackageDependencyLink`](#packagedependencylink) | The item at the end of the edge. |

#### `PackageEdge`

The edge type for [`Package`](#package).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packageedgenode"></a>`node` | [`Package`](#package) | The item at the end of the edge. |

#### `PackageFileConnection`

The connection type for [`PackageFile`](#packagefile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileconnectionedges"></a>`edges` | [`[PackageFileEdge]`](#packagefileedge) | A list of edges. |
| <a id="packagefileconnectionnodes"></a>`nodes` | [`[PackageFile]`](#packagefile) | A list of nodes. |
| <a id="packagefileconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageFileEdge`

The edge type for [`PackageFile`](#packagefile).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagefileedgenode"></a>`node` | [`PackageFile`](#packagefile) | The item at the end of the edge. |

#### `PackageFileRegistryConnection`

The connection type for [`PackageFileRegistry`](#packagefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileregistryconnectionedges"></a>`edges` | [`[PackageFileRegistryEdge]`](#packagefileregistryedge) | A list of edges. |
| <a id="packagefileregistryconnectionnodes"></a>`nodes` | [`[PackageFileRegistry]`](#packagefileregistry) | A list of nodes. |
| <a id="packagefileregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageFileRegistryEdge`

The edge type for [`PackageFileRegistry`](#packagefileregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagefileregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagefileregistryedgenode"></a>`node` | [`PackageFileRegistry`](#packagefileregistry) | The item at the end of the edge. |

#### `PackageTagConnection`

The connection type for [`PackageTag`](#packagetag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagetagconnectionedges"></a>`edges` | [`[PackageTagEdge]`](#packagetagedge) | A list of edges. |
| <a id="packagetagconnectionnodes"></a>`nodes` | [`[PackageTag]`](#packagetag) | A list of nodes. |
| <a id="packagetagconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackageTagEdge`

The edge type for [`PackageTag`](#packagetag).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagetagedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagetagedgenode"></a>`node` | [`PackageTag`](#packagetag) | The item at the end of the edge. |

#### `PackagesProtectionRuleConnection`

The connection type for [`PackagesProtectionRule`](#packagesprotectionrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagesprotectionruleconnectionedges"></a>`edges` | [`[PackagesProtectionRuleEdge]`](#packagesprotectionruleedge) | A list of edges. |
| <a id="packagesprotectionruleconnectionnodes"></a>`nodes` | [`[PackagesProtectionRule]`](#packagesprotectionrule) | A list of nodes. |
| <a id="packagesprotectionruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PackagesProtectionRuleEdge`

The edge type for [`PackagesProtectionRule`](#packagesprotectionrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="packagesprotectionruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="packagesprotectionruleedgenode"></a>`node` | [`PackagesProtectionRule`](#packagesprotectionrule) | The item at the end of the edge. |

#### `PagesDeploymentConnection`

The connection type for [`PagesDeployment`](#pagesdeployment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="pagesdeploymentconnectionedges"></a>`edges` | [`[PagesDeploymentEdge]`](#pagesdeploymentedge) | A list of edges. |
| <a id="pagesdeploymentconnectionnodes"></a>`nodes` | [`[PagesDeployment]`](#pagesdeployment) | A list of nodes. |
| <a id="pagesdeploymentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PagesDeploymentEdge`

The edge type for [`PagesDeployment`](#pagesdeployment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pagesdeploymentedgenode"></a>`node` | [`PagesDeployment`](#pagesdeployment) | The item at the end of the edge. |

#### `PagesDeploymentRegistryConnection`

The connection type for [`PagesDeploymentRegistry`](#pagesdeploymentregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryconnectionedges"></a>`edges` | [`[PagesDeploymentRegistryEdge]`](#pagesdeploymentregistryedge) | A list of edges. |
| <a id="pagesdeploymentregistryconnectionnodes"></a>`nodes` | [`[PagesDeploymentRegistry]`](#pagesdeploymentregistry) | A list of nodes. |
| <a id="pagesdeploymentregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PagesDeploymentRegistryEdge`

The edge type for [`PagesDeploymentRegistry`](#pagesdeploymentregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pagesdeploymentregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pagesdeploymentregistryedgenode"></a>`node` | [`PagesDeploymentRegistry`](#pagesdeploymentregistry) | The item at the end of the edge. |

#### `PathLockConnection`

The connection type for [`PathLock`](#pathlock).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pathlockconnectionedges"></a>`edges` | [`[PathLockEdge]`](#pathlockedge) | A list of edges. |
| <a id="pathlockconnectionnodes"></a>`nodes` | [`[PathLock]`](#pathlock) | A list of nodes. |
| <a id="pathlockconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PathLockEdge`

The edge type for [`PathLock`](#pathlock).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pathlockedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pathlockedgenode"></a>`node` | [`PathLock`](#pathlock) | The item at the end of the edge. |

#### `PendingGroupMemberConnection`

The connection type for [`PendingGroupMember`](#pendinggroupmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pendinggroupmemberconnectionedges"></a>`edges` | [`[PendingGroupMemberEdge]`](#pendinggroupmemberedge) | A list of edges. |
| <a id="pendinggroupmemberconnectionnodes"></a>`nodes` | [`[PendingGroupMember]`](#pendinggroupmember) | A list of nodes. |
| <a id="pendinggroupmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PendingGroupMemberEdge`

The edge type for [`PendingGroupMember`](#pendinggroupmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pendinggroupmemberedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pendinggroupmemberedgenode"></a>`node` | [`PendingGroupMember`](#pendinggroupmember) | The item at the end of the edge. |

#### `PipelineArtifactRegistryConnection`

The connection type for [`PipelineArtifactRegistry`](#pipelineartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryconnectionedges"></a>`edges` | [`[PipelineArtifactRegistryEdge]`](#pipelineartifactregistryedge) | A list of edges. |
| <a id="pipelineartifactregistryconnectionnodes"></a>`nodes` | [`[PipelineArtifactRegistry]`](#pipelineartifactregistry) | A list of nodes. |
| <a id="pipelineartifactregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineArtifactRegistryEdge`

The edge type for [`PipelineArtifactRegistry`](#pipelineartifactregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineartifactregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelineartifactregistryedgenode"></a>`node` | [`PipelineArtifactRegistry`](#pipelineartifactregistry) | The item at the end of the edge. |

#### `PipelineConnection`

The connection type for [`Pipeline`](#pipeline).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="pipelineconnectionedges"></a>`edges` | [`[PipelineEdge]`](#pipelineedge) | A list of edges. |
| <a id="pipelineconnectionnodes"></a>`nodes` | [`[Pipeline]`](#pipeline) | A list of nodes. |
| <a id="pipelineconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineEdge`

The edge type for [`Pipeline`](#pipeline).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelineedgenode"></a>`node` | [`Pipeline`](#pipeline) | The item at the end of the edge. |

#### `PipelineExecutionPolicyConnection`

The connection type for [`PipelineExecutionPolicy`](#pipelineexecutionpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionpolicyconnectionedges"></a>`edges` | [`[PipelineExecutionPolicyEdge]`](#pipelineexecutionpolicyedge) | A list of edges. |
| <a id="pipelineexecutionpolicyconnectionnodes"></a>`nodes` | [`[PipelineExecutionPolicy]`](#pipelineexecutionpolicy) | A list of nodes. |
| <a id="pipelineexecutionpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineExecutionPolicyEdge`

The edge type for [`PipelineExecutionPolicy`](#pipelineexecutionpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineexecutionpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelineexecutionpolicyedgenode"></a>`node` | [`PipelineExecutionPolicy`](#pipelineexecutionpolicy) | The item at the end of the edge. |

#### `PipelineScheduleConnection`

The connection type for [`PipelineSchedule`](#pipelineschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="pipelinescheduleconnectionedges"></a>`edges` | [`[PipelineScheduleEdge]`](#pipelinescheduleedge) | A list of edges. |
| <a id="pipelinescheduleconnectionnodes"></a>`nodes` | [`[PipelineSchedule]`](#pipelineschedule) | A list of nodes. |
| <a id="pipelinescheduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineScheduleEdge`

The edge type for [`PipelineSchedule`](#pipelineschedule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinescheduleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelinescheduleedgenode"></a>`node` | [`PipelineSchedule`](#pipelineschedule) | The item at the end of the edge. |

#### `PipelineScheduleVariableConnection`

The connection type for [`PipelineScheduleVariable`](#pipelineschedulevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableconnectionedges"></a>`edges` | [`[PipelineScheduleVariableEdge]`](#pipelineschedulevariableedge) | A list of edges. |
| <a id="pipelineschedulevariableconnectionnodes"></a>`nodes` | [`[PipelineScheduleVariable]`](#pipelineschedulevariable) | A list of nodes. |
| <a id="pipelineschedulevariableconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineScheduleVariableEdge`

The edge type for [`PipelineScheduleVariable`](#pipelineschedulevariable).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelineschedulevariableedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelineschedulevariableedgenode"></a>`node` | [`PipelineScheduleVariable`](#pipelineschedulevariable) | The item at the end of the edge. |

#### `PipelineSecurityReportFindingConnection`

The connection type for [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingconnectionedges"></a>`edges` | [`[PipelineSecurityReportFindingEdge]`](#pipelinesecurityreportfindingedge) | A list of edges. |
| <a id="pipelinesecurityreportfindingconnectionnodes"></a>`nodes` | [`[PipelineSecurityReportFinding]`](#pipelinesecurityreportfinding) | A list of nodes. |
| <a id="pipelinesecurityreportfindingconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineSecurityReportFindingEdge`

The edge type for [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinesecurityreportfindingedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelinesecurityreportfindingedgenode"></a>`node` | [`PipelineSecurityReportFinding`](#pipelinesecurityreportfinding) | The item at the end of the edge. |

#### `PipelineTriggerConnection`

The connection type for [`PipelineTrigger`](#pipelinetrigger).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinetriggerconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="pipelinetriggerconnectionedges"></a>`edges` | [`[PipelineTriggerEdge]`](#pipelinetriggeredge) | A list of edges. |
| <a id="pipelinetriggerconnectionnodes"></a>`nodes` | [`[PipelineTrigger]`](#pipelinetrigger) | A list of nodes. |
| <a id="pipelinetriggerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PipelineTriggerEdge`

The edge type for [`PipelineTrigger`](#pipelinetrigger).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pipelinetriggeredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pipelinetriggeredgenode"></a>`node` | [`PipelineTrigger`](#pipelinetrigger) | The item at the end of the edge. |

#### `ProjectConnection`

The connection type for [`Project`](#project).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="projectconnectionedges"></a>`edges` | [`[ProjectEdge]`](#projectedge) | A list of edges. |
| <a id="projectconnectionnodes"></a>`nodes` | [`[Project]`](#project) | A list of nodes. |
| <a id="projectconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectEdge`

The edge type for [`Project`](#project).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectedgenode"></a>`node` | [`Project`](#project) | The item at the end of the edge. |

#### `ProjectMemberConnection`

The connection type for [`ProjectMember`](#projectmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectmemberconnectionedges"></a>`edges` | [`[ProjectMemberEdge]`](#projectmemberedge) | A list of edges. |
| <a id="projectmemberconnectionnodes"></a>`nodes` | [`[ProjectMember]`](#projectmember) | A list of nodes. |
| <a id="projectmemberconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectMemberEdge`

The edge type for [`ProjectMember`](#projectmember).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectmemberedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectmemberedgenode"></a>`node` | [`ProjectMember`](#projectmember) | The item at the end of the edge. |

#### `ProjectRepositoryRegistryConnection`

The connection type for [`ProjectRepositoryRegistry`](#projectrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectrepositoryregistryconnectionedges"></a>`edges` | [`[ProjectRepositoryRegistryEdge]`](#projectrepositoryregistryedge) | A list of edges. |
| <a id="projectrepositoryregistryconnectionnodes"></a>`nodes` | [`[ProjectRepositoryRegistry]`](#projectrepositoryregistry) | A list of nodes. |
| <a id="projectrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectRepositoryRegistryEdge`

The edge type for [`ProjectRepositoryRegistry`](#projectrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectrepositoryregistryedgenode"></a>`node` | [`ProjectRepositoryRegistry`](#projectrepositoryregistry) | The item at the end of the edge. |

#### `ProjectSavedReplyConnection`

The connection type for [`ProjectSavedReply`](#projectsavedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectsavedreplyconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="projectsavedreplyconnectionedges"></a>`edges` | [`[ProjectSavedReplyEdge]`](#projectsavedreplyedge) | A list of edges. |
| <a id="projectsavedreplyconnectionnodes"></a>`nodes` | [`[ProjectSavedReply]`](#projectsavedreply) | A list of nodes. |
| <a id="projectsavedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectSavedReplyEdge`

The edge type for [`ProjectSavedReply`](#projectsavedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectsavedreplyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectsavedreplyedgenode"></a>`node` | [`ProjectSavedReply`](#projectsavedreply) | The item at the end of the edge. |

#### `ProjectWikiRepositoryRegistryConnection`

The connection type for [`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectwikirepositoryregistryconnectionedges"></a>`edges` | [`[ProjectWikiRepositoryRegistryEdge]`](#projectwikirepositoryregistryedge) | A list of edges. |
| <a id="projectwikirepositoryregistryconnectionnodes"></a>`nodes` | [`[ProjectWikiRepositoryRegistry]`](#projectwikirepositoryregistry) | A list of nodes. |
| <a id="projectwikirepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProjectWikiRepositoryRegistryEdge`

The edge type for [`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="projectwikirepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="projectwikirepositoryregistryedgenode"></a>`node` | [`ProjectWikiRepositoryRegistry`](#projectwikirepositoryregistry) | The item at the end of the edge. |

#### `ProtectedEnvironmentApprovalRuleConnection`

The connection type for [`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentapprovalruleconnectionedges"></a>`edges` | [`[ProtectedEnvironmentApprovalRuleEdge]`](#protectedenvironmentapprovalruleedge) | A list of edges. |
| <a id="protectedenvironmentapprovalruleconnectionnodes"></a>`nodes` | [`[ProtectedEnvironmentApprovalRule]`](#protectedenvironmentapprovalrule) | A list of nodes. |
| <a id="protectedenvironmentapprovalruleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProtectedEnvironmentApprovalRuleEdge`

The edge type for [`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentapprovalruleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="protectedenvironmentapprovalruleedgenode"></a>`node` | [`ProtectedEnvironmentApprovalRule`](#protectedenvironmentapprovalrule) | The item at the end of the edge. |

#### `ProtectedEnvironmentConnection`

The connection type for [`ProtectedEnvironment`](#protectedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentconnectionedges"></a>`edges` | [`[ProtectedEnvironmentEdge]`](#protectedenvironmentedge) | A list of edges. |
| <a id="protectedenvironmentconnectionnodes"></a>`nodes` | [`[ProtectedEnvironment]`](#protectedenvironment) | A list of nodes. |
| <a id="protectedenvironmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProtectedEnvironmentDeployAccessLevelConnection`

The connection type for [`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentdeployaccesslevelconnectionedges"></a>`edges` | [`[ProtectedEnvironmentDeployAccessLevelEdge]`](#protectedenvironmentdeployaccessleveledge) | A list of edges. |
| <a id="protectedenvironmentdeployaccesslevelconnectionnodes"></a>`nodes` | [`[ProtectedEnvironmentDeployAccessLevel]`](#protectedenvironmentdeployaccesslevel) | A list of nodes. |
| <a id="protectedenvironmentdeployaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ProtectedEnvironmentDeployAccessLevelEdge`

The edge type for [`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentdeployaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="protectedenvironmentdeployaccessleveledgenode"></a>`node` | [`ProtectedEnvironmentDeployAccessLevel`](#protectedenvironmentdeployaccesslevel) | The item at the end of the edge. |

#### `ProtectedEnvironmentEdge`

The edge type for [`ProtectedEnvironment`](#protectedenvironment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="protectedenvironmentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="protectedenvironmentedgenode"></a>`node` | [`ProtectedEnvironment`](#protectedenvironment) | The item at the end of the edge. |

#### `PushAccessLevelConnection`

The connection type for [`PushAccessLevel`](#pushaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pushaccesslevelconnectionedges"></a>`edges` | [`[PushAccessLevelEdge]`](#pushaccessleveledge) | A list of edges. |
| <a id="pushaccesslevelconnectionnodes"></a>`nodes` | [`[PushAccessLevel]`](#pushaccesslevel) | A list of nodes. |
| <a id="pushaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `PushAccessLevelEdge`

The edge type for [`PushAccessLevel`](#pushaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="pushaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="pushaccessleveledgenode"></a>`node` | [`PushAccessLevel`](#pushaccesslevel) | The item at the end of the edge. |

#### `ReleaseAssetLinkConnection`

The connection type for [`ReleaseAssetLink`](#releaseassetlink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseassetlinkconnectionedges"></a>`edges` | [`[ReleaseAssetLinkEdge]`](#releaseassetlinkedge) | A list of edges. |
| <a id="releaseassetlinkconnectionnodes"></a>`nodes` | [`[ReleaseAssetLink]`](#releaseassetlink) | A list of nodes. |
| <a id="releaseassetlinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseAssetLinkEdge`

The edge type for [`ReleaseAssetLink`](#releaseassetlink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseassetlinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releaseassetlinkedgenode"></a>`node` | [`ReleaseAssetLink`](#releaseassetlink) | The item at the end of the edge. |

#### `ReleaseConnection`

The connection type for [`Release`](#release).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="releaseconnectionedges"></a>`edges` | [`[ReleaseEdge]`](#releaseedge) | A list of edges. |
| <a id="releaseconnectionnodes"></a>`nodes` | [`[Release]`](#release) | A list of nodes. |
| <a id="releaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseEdge`

The edge type for [`Release`](#release).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releaseedgenode"></a>`node` | [`Release`](#release) | The item at the end of the edge. |

#### `ReleaseEvidenceConnection`

The connection type for [`ReleaseEvidence`](#releaseevidence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseevidenceconnectionedges"></a>`edges` | [`[ReleaseEvidenceEdge]`](#releaseevidenceedge) | A list of edges. |
| <a id="releaseevidenceconnectionnodes"></a>`nodes` | [`[ReleaseEvidence]`](#releaseevidence) | A list of nodes. |
| <a id="releaseevidenceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseEvidenceEdge`

The edge type for [`ReleaseEvidence`](#releaseevidence).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releaseevidenceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releaseevidenceedgenode"></a>`node` | [`ReleaseEvidence`](#releaseevidence) | The item at the end of the edge. |

#### `ReleaseSourceConnection`

The connection type for [`ReleaseSource`](#releasesource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releasesourceconnectionedges"></a>`edges` | [`[ReleaseSourceEdge]`](#releasesourceedge) | A list of edges. |
| <a id="releasesourceconnectionnodes"></a>`nodes` | [`[ReleaseSource]`](#releasesource) | A list of nodes. |
| <a id="releasesourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ReleaseSourceEdge`

The edge type for [`ReleaseSource`](#releasesource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="releasesourceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="releasesourceedgenode"></a>`node` | [`ReleaseSource`](#releasesource) | The item at the end of the edge. |

#### `RepositoryBlobConnection`

The connection type for [`RepositoryBlob`](#repositoryblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="repositoryblobconnectionedges"></a>`edges` | [`[RepositoryBlobEdge]`](#repositoryblobedge) | A list of edges. |
| <a id="repositoryblobconnectionnodes"></a>`nodes` | [`[RepositoryBlob]`](#repositoryblob) | A list of nodes. |
| <a id="repositoryblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RepositoryBlobEdge`

The edge type for [`RepositoryBlob`](#repositoryblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="repositoryblobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="repositoryblobedgenode"></a>`node` | [`RepositoryBlob`](#repositoryblob) | The item at the end of the edge. |

#### `RequirementConnection`

The connection type for [`Requirement`](#requirement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="requirementconnectionedges"></a>`edges` | [`[RequirementEdge]`](#requirementedge) | A list of edges. |
| <a id="requirementconnectionnodes"></a>`nodes` | [`[Requirement]`](#requirement) | A list of nodes. |
| <a id="requirementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RequirementEdge`

The edge type for [`Requirement`](#requirement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="requirementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="requirementedgenode"></a>`node` | [`Requirement`](#requirement) | The item at the end of the edge. |

#### `RunnerArchitectureConnection`

The connection type for [`RunnerArchitecture`](#runnerarchitecture).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerarchitectureconnectionedges"></a>`edges` | [`[RunnerArchitectureEdge]`](#runnerarchitectureedge) | A list of edges. |
| <a id="runnerarchitectureconnectionnodes"></a>`nodes` | [`[RunnerArchitecture]`](#runnerarchitecture) | A list of nodes. |
| <a id="runnerarchitectureconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RunnerArchitectureEdge`

The edge type for [`RunnerArchitecture`](#runnerarchitecture).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerarchitectureedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="runnerarchitectureedgenode"></a>`node` | [`RunnerArchitecture`](#runnerarchitecture) | The item at the end of the edge. |

#### `RunnerPlatformConnection`

The connection type for [`RunnerPlatform`](#runnerplatform).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerplatformconnectionedges"></a>`edges` | [`[RunnerPlatformEdge]`](#runnerplatformedge) | A list of edges. |
| <a id="runnerplatformconnectionnodes"></a>`nodes` | [`[RunnerPlatform]`](#runnerplatform) | A list of nodes. |
| <a id="runnerplatformconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `RunnerPlatformEdge`

The edge type for [`RunnerPlatform`](#runnerplatform).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="runnerplatformedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="runnerplatformedgenode"></a>`node` | [`RunnerPlatform`](#runnerplatform) | The item at the end of the edge. |

#### `SastCiConfigurationAnalyzersEntityConnection`

The connection type for [`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationanalyzersentityconnectionedges"></a>`edges` | [`[SastCiConfigurationAnalyzersEntityEdge]`](#sastciconfigurationanalyzersentityedge) | A list of edges. |
| <a id="sastciconfigurationanalyzersentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationAnalyzersEntity]`](#sastciconfigurationanalyzersentity) | A list of nodes. |
| <a id="sastciconfigurationanalyzersentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SastCiConfigurationAnalyzersEntityEdge`

The edge type for [`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationanalyzersentityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sastciconfigurationanalyzersentityedgenode"></a>`node` | [`SastCiConfigurationAnalyzersEntity`](#sastciconfigurationanalyzersentity) | The item at the end of the edge. |

#### `SastCiConfigurationEntityConnection`

The connection type for [`SastCiConfigurationEntity`](#sastciconfigurationentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationentityconnectionedges"></a>`edges` | [`[SastCiConfigurationEntityEdge]`](#sastciconfigurationentityedge) | A list of edges. |
| <a id="sastciconfigurationentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationEntity]`](#sastciconfigurationentity) | A list of nodes. |
| <a id="sastciconfigurationentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SastCiConfigurationEntityEdge`

The edge type for [`SastCiConfigurationEntity`](#sastciconfigurationentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationentityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sastciconfigurationentityedgenode"></a>`node` | [`SastCiConfigurationEntity`](#sastciconfigurationentity) | The item at the end of the edge. |

#### `SastCiConfigurationOptionsEntityConnection`

The connection type for [`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationoptionsentityconnectionedges"></a>`edges` | [`[SastCiConfigurationOptionsEntityEdge]`](#sastciconfigurationoptionsentityedge) | A list of edges. |
| <a id="sastciconfigurationoptionsentityconnectionnodes"></a>`nodes` | [`[SastCiConfigurationOptionsEntity]`](#sastciconfigurationoptionsentity) | A list of nodes. |
| <a id="sastciconfigurationoptionsentityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SastCiConfigurationOptionsEntityEdge`

The edge type for [`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sastciconfigurationoptionsentityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sastciconfigurationoptionsentityedgenode"></a>`node` | [`SastCiConfigurationOptionsEntity`](#sastciconfigurationoptionsentity) | The item at the end of the edge. |

#### `SavedReplyConnection`

The connection type for [`SavedReply`](#savedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="savedreplyconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="savedreplyconnectionedges"></a>`edges` | [`[SavedReplyEdge]`](#savedreplyedge) | A list of edges. |
| <a id="savedreplyconnectionnodes"></a>`nodes` | [`[SavedReply]`](#savedreply) | A list of nodes. |
| <a id="savedreplyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SavedReplyEdge`

The edge type for [`SavedReply`](#savedreply).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="savedreplyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="savedreplyedgenode"></a>`node` | [`SavedReply`](#savedreply) | The item at the end of the edge. |

#### `ScanConnection`

The connection type for [`Scan`](#scan).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanconnectionedges"></a>`edges` | [`[ScanEdge]`](#scanedge) | A list of edges. |
| <a id="scanconnectionnodes"></a>`nodes` | [`[Scan]`](#scan) | A list of nodes. |
| <a id="scanconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScanEdge`

The edge type for [`Scan`](#scan).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scanedgenode"></a>`node` | [`Scan`](#scan) | The item at the end of the edge. |

#### `ScanExecutionPolicyConnection`

The connection type for [`ScanExecutionPolicy`](#scanexecutionpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanexecutionpolicyconnectionedges"></a>`edges` | [`[ScanExecutionPolicyEdge]`](#scanexecutionpolicyedge) | A list of edges. |
| <a id="scanexecutionpolicyconnectionnodes"></a>`nodes` | [`[ScanExecutionPolicy]`](#scanexecutionpolicy) | A list of nodes. |
| <a id="scanexecutionpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScanExecutionPolicyEdge`

The edge type for [`ScanExecutionPolicy`](#scanexecutionpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanexecutionpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scanexecutionpolicyedgenode"></a>`node` | [`ScanExecutionPolicy`](#scanexecutionpolicy) | The item at the end of the edge. |

#### `ScanResultPolicyConnection`

The connection type for [`ScanResultPolicy`](#scanresultpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanresultpolicyconnectionedges"></a>`edges` | [`[ScanResultPolicyEdge]`](#scanresultpolicyedge) | A list of edges. |
| <a id="scanresultpolicyconnectionnodes"></a>`nodes` | [`[ScanResultPolicy]`](#scanresultpolicy) | A list of nodes. |
| <a id="scanresultpolicyconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScanResultPolicyEdge`

The edge type for [`ScanResultPolicy`](#scanresultpolicy).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scanresultpolicyedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scanresultpolicyedgenode"></a>`node` | [`ScanResultPolicy`](#scanresultpolicy) | The item at the end of the edge. |

#### `ScannedResourceConnection`

The connection type for [`ScannedResource`](#scannedresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scannedresourceconnectionedges"></a>`edges` | [`[ScannedResourceEdge]`](#scannedresourceedge) | A list of edges. |
| <a id="scannedresourceconnectionnodes"></a>`nodes` | [`[ScannedResource]`](#scannedresource) | A list of nodes. |
| <a id="scannedresourceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ScannedResourceEdge`

The edge type for [`ScannedResource`](#scannedresource).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="scannedresourceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="scannedresourceedgenode"></a>`node` | [`ScannedResource`](#scannedresource) | The item at the end of the edge. |

#### `SentryErrorConnection`

The connection type for [`SentryError`](#sentryerror).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sentryerrorconnectionedges"></a>`edges` | [`[SentryErrorEdge]`](#sentryerroredge) | A list of edges. |
| <a id="sentryerrorconnectionnodes"></a>`nodes` | [`[SentryError]`](#sentryerror) | A list of nodes. |
| <a id="sentryerrorconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SentryErrorEdge`

The edge type for [`SentryError`](#sentryerror).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="sentryerroredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="sentryerroredgenode"></a>`node` | [`SentryError`](#sentryerror) | The item at the end of the edge. |

#### `ServiceConnection`

The connection type for [`Service`](#service).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="serviceconnectionedges"></a>`edges` | [`[ServiceEdge]`](#serviceedge) | A list of edges. |
| <a id="serviceconnectionnodes"></a>`nodes` | [`[Service]`](#service) | A list of nodes. |
| <a id="serviceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ServiceEdge`

The edge type for [`Service`](#service).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="serviceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="serviceedgenode"></a>`node` | [`Service`](#service) | The item at the end of the edge. |

#### `SnippetBlobConnection`

The connection type for [`SnippetBlob`](#snippetblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetblobconnectionedges"></a>`edges` | [`[SnippetBlobEdge]`](#snippetblobedge) | A list of edges. |
| <a id="snippetblobconnectionhasunretrievableblobs"></a>`hasUnretrievableBlobs` | [`Boolean!`](#boolean) | Indicates if the snippet has unretrievable blobs. |
| <a id="snippetblobconnectionnodes"></a>`nodes` | [`[SnippetBlob]`](#snippetblob) | A list of nodes. |
| <a id="snippetblobconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SnippetBlobEdge`

The edge type for [`SnippetBlob`](#snippetblob).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetblobedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="snippetblobedgenode"></a>`node` | [`SnippetBlob`](#snippetblob) | The item at the end of the edge. |

#### `SnippetConnection`

The connection type for [`Snippet`](#snippet).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetconnectionedges"></a>`edges` | [`[SnippetEdge]`](#snippetedge) | A list of edges. |
| <a id="snippetconnectionnodes"></a>`nodes` | [`[Snippet]`](#snippet) | A list of nodes. |
| <a id="snippetconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SnippetEdge`

The edge type for [`Snippet`](#snippet).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="snippetedgenode"></a>`node` | [`Snippet`](#snippet) | The item at the end of the edge. |

#### `SnippetRepositoryRegistryConnection`

The connection type for [`SnippetRepositoryRegistry`](#snippetrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetrepositoryregistryconnectionedges"></a>`edges` | [`[SnippetRepositoryRegistryEdge]`](#snippetrepositoryregistryedge) | A list of edges. |
| <a id="snippetrepositoryregistryconnectionnodes"></a>`nodes` | [`[SnippetRepositoryRegistry]`](#snippetrepositoryregistry) | A list of nodes. |
| <a id="snippetrepositoryregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SnippetRepositoryRegistryEdge`

The edge type for [`SnippetRepositoryRegistry`](#snippetrepositoryregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="snippetrepositoryregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="snippetrepositoryregistryedgenode"></a>`node` | [`SnippetRepositoryRegistry`](#snippetrepositoryregistry) | The item at the end of the edge. |

#### `SubmoduleConnection`

The connection type for [`Submodule`](#submodule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="submoduleconnectionedges"></a>`edges` | [`[SubmoduleEdge]`](#submoduleedge) | A list of edges. |
| <a id="submoduleconnectionnodes"></a>`nodes` | [`[Submodule]`](#submodule) | A list of nodes. |
| <a id="submoduleconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SubmoduleEdge`

The edge type for [`Submodule`](#submodule).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="submoduleedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="submoduleedgenode"></a>`node` | [`Submodule`](#submodule) | The item at the end of the edge. |

#### `SubscriptionFutureEntryConnection`

The connection type for [`SubscriptionFutureEntry`](#subscriptionfutureentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="subscriptionfutureentryconnectionedges"></a>`edges` | [`[SubscriptionFutureEntryEdge]`](#subscriptionfutureentryedge) | A list of edges. |
| <a id="subscriptionfutureentryconnectionnodes"></a>`nodes` | [`[SubscriptionFutureEntry]`](#subscriptionfutureentry) | A list of nodes. |
| <a id="subscriptionfutureentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `SubscriptionFutureEntryEdge`

The edge type for [`SubscriptionFutureEntry`](#subscriptionfutureentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="subscriptionfutureentryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="subscriptionfutureentryedgenode"></a>`node` | [`SubscriptionFutureEntry`](#subscriptionfutureentry) | The item at the end of the edge. |

#### `TerraformStateConnection`

The connection type for [`TerraformState`](#terraformstate).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="terraformstateconnectionedges"></a>`edges` | [`[TerraformStateEdge]`](#terraformstateedge) | A list of edges. |
| <a id="terraformstateconnectionnodes"></a>`nodes` | [`[TerraformState]`](#terraformstate) | A list of nodes. |
| <a id="terraformstateconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TerraformStateEdge`

The edge type for [`TerraformState`](#terraformstate).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="terraformstateedgenode"></a>`node` | [`TerraformState`](#terraformstate) | The item at the end of the edge. |

#### `TerraformStateVersionRegistryConnection`

The connection type for [`TerraformStateVersionRegistry`](#terraformstateversionregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateversionregistryconnectionedges"></a>`edges` | [`[TerraformStateVersionRegistryEdge]`](#terraformstateversionregistryedge) | A list of edges. |
| <a id="terraformstateversionregistryconnectionnodes"></a>`nodes` | [`[TerraformStateVersionRegistry]`](#terraformstateversionregistry) | A list of nodes. |
| <a id="terraformstateversionregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TerraformStateVersionRegistryEdge`

The edge type for [`TerraformStateVersionRegistry`](#terraformstateversionregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="terraformstateversionregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="terraformstateversionregistryedgenode"></a>`node` | [`TerraformStateVersionRegistry`](#terraformstateversionregistry) | The item at the end of the edge. |

#### `TestCaseConnection`

The connection type for [`TestCase`](#testcase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testcaseconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="testcaseconnectionedges"></a>`edges` | [`[TestCaseEdge]`](#testcaseedge) | A list of edges. |
| <a id="testcaseconnectionnodes"></a>`nodes` | [`[TestCase]`](#testcase) | A list of nodes. |
| <a id="testcaseconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TestCaseEdge`

The edge type for [`TestCase`](#testcase).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testcaseedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="testcaseedgenode"></a>`node` | [`TestCase`](#testcase) | The item at the end of the edge. |

#### `TestReportConnection`

The connection type for [`TestReport`](#testreport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testreportconnectionedges"></a>`edges` | [`[TestReportEdge]`](#testreportedge) | A list of edges. |
| <a id="testreportconnectionnodes"></a>`nodes` | [`[TestReport]`](#testreport) | A list of nodes. |
| <a id="testreportconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TestReportEdge`

The edge type for [`TestReport`](#testreport).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testreportedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="testreportedgenode"></a>`node` | [`TestReport`](#testreport) | The item at the end of the edge. |

#### `TestSuiteSummaryConnection`

The connection type for [`TestSuiteSummary`](#testsuitesummary).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testsuitesummaryconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="testsuitesummaryconnectionedges"></a>`edges` | [`[TestSuiteSummaryEdge]`](#testsuitesummaryedge) | A list of edges. |
| <a id="testsuitesummaryconnectionnodes"></a>`nodes` | [`[TestSuiteSummary]`](#testsuitesummary) | A list of nodes. |
| <a id="testsuitesummaryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TestSuiteSummaryEdge`

The edge type for [`TestSuiteSummary`](#testsuitesummary).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="testsuitesummaryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="testsuitesummaryedgenode"></a>`node` | [`TestSuiteSummary`](#testsuitesummary) | The item at the end of the edge. |

#### `TimeTrackingTimelogCategoryConnection`

The connection type for [`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timetrackingtimelogcategoryconnectionedges"></a>`edges` | [`[TimeTrackingTimelogCategoryEdge]`](#timetrackingtimelogcategoryedge) | A list of edges. |
| <a id="timetrackingtimelogcategoryconnectionnodes"></a>`nodes` | [`[TimeTrackingTimelogCategory]`](#timetrackingtimelogcategory) | A list of nodes. |
| <a id="timetrackingtimelogcategoryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TimeTrackingTimelogCategoryEdge`

The edge type for [`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timetrackingtimelogcategoryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timetrackingtimelogcategoryedgenode"></a>`node` | [`TimeTrackingTimelogCategory`](#timetrackingtimelogcategory) | The item at the end of the edge. |

#### `TimelineEventTagTypeConnection`

The connection type for [`TimelineEventTagType`](#timelineeventtagtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtagtypeconnectionedges"></a>`edges` | [`[TimelineEventTagTypeEdge]`](#timelineeventtagtypeedge) | A list of edges. |
| <a id="timelineeventtagtypeconnectionnodes"></a>`nodes` | [`[TimelineEventTagType]`](#timelineeventtagtype) | A list of nodes. |
| <a id="timelineeventtagtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TimelineEventTagTypeEdge`

The edge type for [`TimelineEventTagType`](#timelineeventtagtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtagtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timelineeventtagtypeedgenode"></a>`node` | [`TimelineEventTagType`](#timelineeventtagtype) | The item at the end of the edge. |

#### `TimelineEventTypeConnection`

The connection type for [`TimelineEventType`](#timelineeventtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtypeconnectionedges"></a>`edges` | [`[TimelineEventTypeEdge]`](#timelineeventtypeedge) | A list of edges. |
| <a id="timelineeventtypeconnectionnodes"></a>`nodes` | [`[TimelineEventType]`](#timelineeventtype) | A list of nodes. |
| <a id="timelineeventtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TimelineEventTypeEdge`

The edge type for [`TimelineEventType`](#timelineeventtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelineeventtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timelineeventtypeedgenode"></a>`node` | [`TimelineEventType`](#timelineeventtype) | The item at the end of the edge. |

#### `TimelogConnection`

The connection type for [`Timelog`](#timelog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelogconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="timelogconnectionedges"></a>`edges` | [`[TimelogEdge]`](#timelogedge) | A list of edges. |
| <a id="timelogconnectionnodes"></a>`nodes` | [`[Timelog]`](#timelog) | A list of nodes. |
| <a id="timelogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="timelogconnectiontotalspenttime"></a>`totalSpentTime` | [`BigInt!`](#bigint) | Total time spent in seconds. |

#### `TimelogEdge`

The edge type for [`Timelog`](#timelog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="timelogedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="timelogedgenode"></a>`node` | [`Timelog`](#timelog) | The item at the end of the edge. |

#### `TodoConnection`

The connection type for [`Todo`](#todo).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="todoconnectionedges"></a>`edges` | [`[TodoEdge]`](#todoedge) | A list of edges. |
| <a id="todoconnectionnodes"></a>`nodes` | [`[Todo]`](#todo) | A list of nodes. |
| <a id="todoconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TodoEdge`

The edge type for [`Todo`](#todo).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="todoedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="todoedgenode"></a>`node` | [`Todo`](#todo) | The item at the end of the edge. |

#### `TopicConnection`

The connection type for [`Topic`](#topic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="topicconnectionedges"></a>`edges` | [`[TopicEdge]`](#topicedge) | A list of edges. |
| <a id="topicconnectionnodes"></a>`nodes` | [`[Topic]`](#topic) | A list of nodes. |
| <a id="topicconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TopicEdge`

The edge type for [`Topic`](#topic).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="topicedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="topicedgenode"></a>`node` | [`Topic`](#topic) | The item at the end of the edge. |

#### `TreeConnection`

The connection type for [`Tree`](#tree).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeconnectionedges"></a>`edges` | [`[TreeEdge]`](#treeedge) | A list of edges. |
| <a id="treeconnectionnodes"></a>`nodes` | [`[Tree]`](#tree) | A list of nodes. |
| <a id="treeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TreeEdge`

The edge type for [`Tree`](#tree).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="treeedgenode"></a>`node` | [`Tree`](#tree) | The item at the end of the edge. |

#### `TreeEntryConnection`

The connection type for [`TreeEntry`](#treeentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeentryconnectionedges"></a>`edges` | [`[TreeEntryEdge]`](#treeentryedge) | A list of edges. |
| <a id="treeentryconnectionnodes"></a>`nodes` | [`[TreeEntry]`](#treeentry) | A list of nodes. |
| <a id="treeentryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `TreeEntryEdge`

The edge type for [`TreeEntry`](#treeentry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="treeentryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="treeentryedgenode"></a>`node` | [`TreeEntry`](#treeentry) | The item at the end of the edge. |

#### `UnprotectAccessLevelConnection`

The connection type for [`UnprotectAccessLevel`](#unprotectaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="unprotectaccesslevelconnectionedges"></a>`edges` | [`[UnprotectAccessLevelEdge]`](#unprotectaccessleveledge) | A list of edges. |
| <a id="unprotectaccesslevelconnectionnodes"></a>`nodes` | [`[UnprotectAccessLevel]`](#unprotectaccesslevel) | A list of nodes. |
| <a id="unprotectaccesslevelconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UnprotectAccessLevelEdge`

The edge type for [`UnprotectAccessLevel`](#unprotectaccesslevel).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="unprotectaccessleveledgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="unprotectaccessleveledgenode"></a>`node` | [`UnprotectAccessLevel`](#unprotectaccesslevel) | The item at the end of the edge. |

#### `UploadRegistryConnection`

The connection type for [`UploadRegistry`](#uploadregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="uploadregistryconnectionedges"></a>`edges` | [`[UploadRegistryEdge]`](#uploadregistryedge) | A list of edges. |
| <a id="uploadregistryconnectionnodes"></a>`nodes` | [`[UploadRegistry]`](#uploadregistry) | A list of nodes. |
| <a id="uploadregistryconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UploadRegistryEdge`

The edge type for [`UploadRegistry`](#uploadregistry).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="uploadregistryedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="uploadregistryedgenode"></a>`node` | [`UploadRegistry`](#uploadregistry) | The item at the end of the edge. |

#### `UsageTrendsMeasurementConnection`

The connection type for [`UsageTrendsMeasurement`](#usagetrendsmeasurement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usagetrendsmeasurementconnectionedges"></a>`edges` | [`[UsageTrendsMeasurementEdge]`](#usagetrendsmeasurementedge) | A list of edges. |
| <a id="usagetrendsmeasurementconnectionnodes"></a>`nodes` | [`[UsageTrendsMeasurement]`](#usagetrendsmeasurement) | A list of nodes. |
| <a id="usagetrendsmeasurementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UsageTrendsMeasurementEdge`

The edge type for [`UsageTrendsMeasurement`](#usagetrendsmeasurement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usagetrendsmeasurementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="usagetrendsmeasurementedgenode"></a>`node` | [`UsageTrendsMeasurement`](#usagetrendsmeasurement) | The item at the end of the edge. |

#### `UserAchievementConnection`

The connection type for [`UserAchievement`](#userachievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="userachievementconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="userachievementconnectionedges"></a>`edges` | [`[UserAchievementEdge]`](#userachievementedge) | A list of edges. |
| <a id="userachievementconnectionnodes"></a>`nodes` | [`[UserAchievement]`](#userachievement) | A list of nodes. |
| <a id="userachievementconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UserAchievementEdge`

The edge type for [`UserAchievement`](#userachievement).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="userachievementedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="userachievementedgenode"></a>`node` | [`UserAchievement`](#userachievement) | The item at the end of the edge. |

#### `UserAddOnAssignmentConnection`

The connection type for [`UserAddOnAssignment`](#useraddonassignment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="useraddonassignmentconnectionedges"></a>`edges` | [`[UserAddOnAssignmentEdge]`](#useraddonassignmentedge) | A list of edges. |
| <a id="useraddonassignmentconnectionnodes"></a>`nodes` | [`[UserAddOnAssignment]`](#useraddonassignment) | A list of nodes. |
| <a id="useraddonassignmentconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UserAddOnAssignmentEdge`

The edge type for [`UserAddOnAssignment`](#useraddonassignment).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="useraddonassignmentedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="useraddonassignmentedgenode"></a>`node` | [`UserAddOnAssignment`](#useraddonassignment) | The item at the end of the edge. |

#### `UserCalloutConnection`

The connection type for [`UserCallout`](#usercallout).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercalloutconnectionedges"></a>`edges` | [`[UserCalloutEdge]`](#usercalloutedge) | A list of edges. |
| <a id="usercalloutconnectionnodes"></a>`nodes` | [`[UserCallout]`](#usercallout) | A list of nodes. |
| <a id="usercalloutconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UserCalloutEdge`

The edge type for [`UserCallout`](#usercallout).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercalloutedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="usercalloutedgenode"></a>`node` | [`UserCallout`](#usercallout) | The item at the end of the edge. |

#### `UserCoreConnection`

The connection type for [`UserCore`](#usercore).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercoreconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="usercoreconnectionedges"></a>`edges` | [`[UserCoreEdge]`](#usercoreedge) | A list of edges. |
| <a id="usercoreconnectionnodes"></a>`nodes` | [`[UserCore]`](#usercore) | A list of nodes. |
| <a id="usercoreconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `UserCoreEdge`

The edge type for [`UserCore`](#usercore).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="usercoreedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="usercoreedgenode"></a>`node` | [`UserCore`](#usercore) | The item at the end of the edge. |

#### `ValueStreamConnection`

The connection type for [`ValueStream`](#valuestream).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="valuestreamconnectionedges"></a>`edges` | [`[ValueStreamEdge]`](#valuestreamedge) | A list of edges. |
| <a id="valuestreamconnectionnodes"></a>`nodes` | [`[ValueStream]`](#valuestream) | A list of nodes. |
| <a id="valuestreamconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `ValueStreamEdge`

The edge type for [`ValueStream`](#valuestream).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="valuestreamedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="valuestreamedgenode"></a>`node` | [`ValueStream`](#valuestream) | The item at the end of the edge. |

#### `VulnerabilitiesCountByDayConnection`

The connection type for [`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitiescountbydayconnectionedges"></a>`edges` | [`[VulnerabilitiesCountByDayEdge]`](#vulnerabilitiescountbydayedge) | A list of edges. |
| <a id="vulnerabilitiescountbydayconnectionnodes"></a>`nodes` | [`[VulnerabilitiesCountByDay]`](#vulnerabilitiescountbyday) | A list of nodes. |
| <a id="vulnerabilitiescountbydayconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilitiesCountByDayEdge`

The edge type for [`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitiescountbydayedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilitiescountbydayedgenode"></a>`node` | [`VulnerabilitiesCountByDay`](#vulnerabilitiescountbyday) | The item at the end of the edge. |

#### `VulnerabilityConnection`

The connection type for [`Vulnerability`](#vulnerability).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityconnectionedges"></a>`edges` | [`[VulnerabilityEdge]`](#vulnerabilityedge) | A list of edges. |
| <a id="vulnerabilityconnectionnodes"></a>`nodes` | [`[Vulnerability]`](#vulnerability) | A list of nodes. |
| <a id="vulnerabilityconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityContainerImageConnection`

The connection type for [`VulnerabilityContainerImage`](#vulnerabilitycontainerimage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitycontainerimageconnectionedges"></a>`edges` | [`[VulnerabilityContainerImageEdge]`](#vulnerabilitycontainerimageedge) | A list of edges. |
| <a id="vulnerabilitycontainerimageconnectionnodes"></a>`nodes` | [`[VulnerabilityContainerImage]`](#vulnerabilitycontainerimage) | A list of nodes. |
| <a id="vulnerabilitycontainerimageconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityContainerImageEdge`

The edge type for [`VulnerabilityContainerImage`](#vulnerabilitycontainerimage).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitycontainerimageedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilitycontainerimageedgenode"></a>`node` | [`VulnerabilityContainerImage`](#vulnerabilitycontainerimage) | The item at the end of the edge. |

#### `VulnerabilityEdge`

The edge type for [`Vulnerability`](#vulnerability).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityedgenode"></a>`node` | [`Vulnerability`](#vulnerability) | The item at the end of the edge. |

#### `VulnerabilityExternalIssueLinkConnection`

The connection type for [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityexternalissuelinkconnectionedges"></a>`edges` | [`[VulnerabilityExternalIssueLinkEdge]`](#vulnerabilityexternalissuelinkedge) | A list of edges. |
| <a id="vulnerabilityexternalissuelinkconnectionnodes"></a>`nodes` | [`[VulnerabilityExternalIssueLink]`](#vulnerabilityexternalissuelink) | A list of nodes. |
| <a id="vulnerabilityexternalissuelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityExternalIssueLinkEdge`

The edge type for [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityexternalissuelinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityexternalissuelinkedgenode"></a>`node` | [`VulnerabilityExternalIssueLink`](#vulnerabilityexternalissuelink) | The item at the end of the edge. |

#### `VulnerabilityIssueLinkConnection`

The connection type for [`VulnerabilityIssueLink`](#vulnerabilityissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityissuelinkconnectionedges"></a>`edges` | [`[VulnerabilityIssueLinkEdge]`](#vulnerabilityissuelinkedge) | A list of edges. |
| <a id="vulnerabilityissuelinkconnectionnodes"></a>`nodes` | [`[VulnerabilityIssueLink]`](#vulnerabilityissuelink) | A list of nodes. |
| <a id="vulnerabilityissuelinkconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityIssueLinkEdge`

The edge type for [`VulnerabilityIssueLink`](#vulnerabilityissuelink).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityissuelinkedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityissuelinkedgenode"></a>`node` | [`VulnerabilityIssueLink`](#vulnerabilityissuelink) | The item at the end of the edge. |

#### `VulnerabilityScannerConnection`

The connection type for [`VulnerabilityScanner`](#vulnerabilityscanner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityscannerconnectionedges"></a>`edges` | [`[VulnerabilityScannerEdge]`](#vulnerabilityscanneredge) | A list of edges. |
| <a id="vulnerabilityscannerconnectionnodes"></a>`nodes` | [`[VulnerabilityScanner]`](#vulnerabilityscanner) | A list of nodes. |
| <a id="vulnerabilityscannerconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityScannerEdge`

The edge type for [`VulnerabilityScanner`](#vulnerabilityscanner).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilityscanneredgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilityscanneredgenode"></a>`node` | [`VulnerabilityScanner`](#vulnerabilityscanner) | The item at the end of the edge. |

#### `VulnerabilityStateTransitionTypeConnection`

The connection type for [`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitystatetransitiontypeconnectionedges"></a>`edges` | [`[VulnerabilityStateTransitionTypeEdge]`](#vulnerabilitystatetransitiontypeedge) | A list of edges. |
| <a id="vulnerabilitystatetransitiontypeconnectionnodes"></a>`nodes` | [`[VulnerabilityStateTransitionType]`](#vulnerabilitystatetransitiontype) | A list of nodes. |
| <a id="vulnerabilitystatetransitiontypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `VulnerabilityStateTransitionTypeEdge`

The edge type for [`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="vulnerabilitystatetransitiontypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="vulnerabilitystatetransitiontypeedgenode"></a>`node` | [`VulnerabilityStateTransitionType`](#vulnerabilitystatetransitiontype) | The item at the end of the edge. |

#### `WorkItemConnection`

The connection type for [`WorkItem`](#workitem).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemconnectionedges"></a>`edges` | [`[WorkItemEdge]`](#workitemedge) | A list of edges. |
| <a id="workitemconnectionnodes"></a>`nodes` | [`[WorkItem]`](#workitem) | A list of nodes. |
| <a id="workitemconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `WorkItemEdge`

The edge type for [`WorkItem`](#workitem).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workitemedgenode"></a>`node` | [`WorkItem`](#workitem) | The item at the end of the edge. |

#### `WorkItemRelatedMergeRequestConnection`

The connection type for [`WorkItemRelatedMergeRequest`](#workitemrelatedmergerequest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemrelatedmergerequestconnectionedges"></a>`edges` | [`[WorkItemRelatedMergeRequestEdge]`](#workitemrelatedmergerequestedge) | A list of edges. |
| <a id="workitemrelatedmergerequestconnectionnodes"></a>`nodes` | [`[WorkItemRelatedMergeRequest]`](#workitemrelatedmergerequest) | A list of nodes. |
| <a id="workitemrelatedmergerequestconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `WorkItemRelatedMergeRequestEdge`

The edge type for [`WorkItemRelatedMergeRequest`](#workitemrelatedmergerequest).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemrelatedmergerequestedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workitemrelatedmergerequestedgenode"></a>`node` | [`WorkItemRelatedMergeRequest`](#workitemrelatedmergerequest) | The item at the end of the edge. |

#### `WorkItemTimelogConnection`

The connection type for [`WorkItemTimelog`](#workitemtimelog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemtimelogconnectioncount"></a>`count` | [`Int!`](#int) | Total count of collection. |
| <a id="workitemtimelogconnectionedges"></a>`edges` | [`[WorkItemTimelogEdge]`](#workitemtimelogedge) | A list of edges. |
| <a id="workitemtimelogconnectionnodes"></a>`nodes` | [`[WorkItemTimelog]`](#workitemtimelog) | A list of nodes. |
| <a id="workitemtimelogconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |
| <a id="workitemtimelogconnectiontotalspenttime"></a>`totalSpentTime` | [`BigInt!`](#bigint) | Total time spent in seconds. |

#### `WorkItemTimelogEdge`

The edge type for [`WorkItemTimelog`](#workitemtimelog).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemtimelogedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workitemtimelogedgenode"></a>`node` | [`WorkItemTimelog`](#workitemtimelog) | The item at the end of the edge. |

#### `WorkItemTypeConnection`

The connection type for [`WorkItemType`](#workitemtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemtypeconnectionedges"></a>`edges` | [`[WorkItemTypeEdge]`](#workitemtypeedge) | A list of edges. |
| <a id="workitemtypeconnectionnodes"></a>`nodes` | [`[WorkItemType]`](#workitemtype) | A list of nodes. |
| <a id="workitemtypeconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `WorkItemTypeEdge`

The edge type for [`WorkItemType`](#workitemtype).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workitemtypeedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workitemtypeedgenode"></a>`node` | [`WorkItemType`](#workitemtype) | The item at the end of the edge. |

#### `WorkspaceConnection`

The connection type for [`Workspace`](#workspace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workspaceconnectionedges"></a>`edges` | [`[WorkspaceEdge]`](#workspaceedge) | A list of edges. |
| <a id="workspaceconnectionnodes"></a>`nodes` | [`[Workspace]`](#workspace) | A list of nodes. |
| <a id="workspaceconnectionpageinfo"></a>`pageInfo` | [`PageInfo!`](#pageinfo) | Information to aid in pagination. |

#### `WorkspaceEdge`

The edge type for [`Workspace`](#workspace).

##### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="workspaceedgecursor"></a>`cursor` | [`String!`](#string) | A cursor for use in pagination. |
| <a id="workspaceedgenode"></a>`node` | [`Workspace`](#workspace) | The item at the end of the edge. |

## Object types

Object types represent the resources that the GitLab GraphQL API can return.
They contain _fields_. Each field has its own type, which will either be one of the
basic GraphQL [scalar types](https://graphql.org/learn/schema/#scalar-types)
(e.g.: `String` or `Boolean`) or other object types. Fields may have arguments.
Fields with arguments are exactly like top-level queries, and are listed beneath
the table of fields for each object type.

For more information, see
[Object Types and Fields](https://graphql.org/learn/schema/#object-types-and-fields)
on `graphql.org`.

### `AbuseReport`

An abuse report.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="abusereportcommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="abusereportdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="abusereportid"></a>`id` | [`AbuseReportID!`](#abusereportid) | Global ID of the abuse report. |
| <a id="abusereportlabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels of the abuse report. (see [Connections](#connections)) |

#### Fields with arguments

##### `AbuseReport.notes`

All notes on this noteable.

Returns [`NoteConnection!`](#noteconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="abusereportnotesfilter"></a>`filter` | [`NotesFilterType`](#notesfiltertype) | Type of notes collection: ALL_NOTES, ONLY_COMMENTS, ONLY_ACTIVITY. |

### `AccessLevel`

Represents the access level of a relationship between a User and object that it is related to.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accesslevelintegervalue"></a>`integerValue` | [`Int`](#int) | Integer representation of access level. |
| <a id="accesslevelstringvalue"></a>`stringValue` | [`AccessLevelEnum`](#accesslevelenum) | String representation of access level. |

### `AccessLevelDeployKey`

Representation of a GitLab deploy key.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accessleveldeploykeyexpiresat"></a>`expiresAt` | [`Date`](#date) | Expiration date of the deploy key. |
| <a id="accessleveldeploykeyid"></a>`id` | [`ID!`](#id) | ID of the deploy key. |
| <a id="accessleveldeploykeytitle"></a>`title` | [`String!`](#string) | Title of the deploy key. |
| <a id="accessleveldeploykeyuser"></a>`user` | [`AccessLevelUser!`](#accessleveluser) | User assigned to the deploy key. |

### `AccessLevelGroup`

Representation of a GitLab group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accesslevelgroupavatarurl"></a>`avatarUrl` | [`String`](#string) | Avatar URL of the group. |
| <a id="accesslevelgroupid"></a>`id` | [`ID!`](#id) | ID of the group. |
| <a id="accesslevelgroupname"></a>`name` | [`String!`](#string) | Name of the group. |
| <a id="accesslevelgroupparent"></a>`parent` | [`AccessLevelGroup`](#accesslevelgroup) | Parent group. |
| <a id="accesslevelgroupweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the group. |

### `AccessLevelUser`

Representation of a GitLab user.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="accessleveluseravatarurl"></a>`avatarUrl` | [`String`](#string) | URL of the user's avatar. |
| <a id="accessleveluserid"></a>`id` | [`ID!`](#id) | ID of the user. |
| <a id="accesslevelusername"></a>`name` | [`String!`](#string) | Human-readable name of the user. Returns `****` if the user is a project bot and the requester does not have permission to view the project. |
| <a id="accessleveluserpublicemail"></a>`publicEmail` | [`String`](#string) | User's public email. |
| <a id="accessleveluserusername"></a>`username` | [`String!`](#string) | Username of the user. |
| <a id="accessleveluserwebpath"></a>`webPath` | [`String!`](#string) | Web path of the user. |
| <a id="accessleveluserweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the user. |

### `Achievement`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="achievementavatarurl"></a>`avatarUrl` | [`String`](#string) | URL to avatar of the achievement. |
| <a id="achievementcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp the achievement was created. |
| <a id="achievementdescription"></a>`description` | [`String`](#string) | Description or notes for the achievement. |
| <a id="achievementid"></a>`id` | [`AchievementsAchievementID!`](#achievementsachievementid) | ID of the achievement. |
| <a id="achievementname"></a>`name` | [`String!`](#string) | Name of the achievement. |
| <a id="achievementnamespace"></a>`namespace` | [`Namespace`](#namespace) | Namespace of the achievement. |
| <a id="achievementupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp the achievement was last updated. |
| <a id="achievementuserachievements"></a>`userAchievements` **{warning-solid}** | [`UserAchievementConnection`](#userachievementconnection) | **Introduced** in GitLab 15.10. **Status**: Experiment. Recipients for the achievement. |

### `AddOnPurchase`

Represents AddOn purchase for Namespace.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonpurchaseassignedquantity"></a>`assignedQuantity` | [`Int!`](#int) | Number of seats assigned. |
| <a id="addonpurchaseid"></a>`id` | [`GitlabSubscriptionsAddOnPurchaseID!`](#gitlabsubscriptionsaddonpurchaseid) | ID of AddOnPurchase. |
| <a id="addonpurchasename"></a>`name` | [`String!`](#string) | Name of AddOn. |
| <a id="addonpurchasepurchasedquantity"></a>`purchasedQuantity` | [`Int!`](#int) | Number of seats purchased. |

### `AddOnUser`

A user with add-on data.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuseravatarurl"></a>`avatarUrl` | [`String`](#string) | URL of the user's avatar. |
| <a id="addonuserbio"></a>`bio` | [`String`](#string) | Bio of the user. |
| <a id="addonuserbot"></a>`bot` | [`Boolean!`](#boolean) | Indicates if the user is a bot. |
| <a id="addonusercallouts"></a>`callouts` | [`UserCalloutConnection`](#usercalloutconnection) | User callouts that belong to the user. (see [Connections](#connections)) |
| <a id="addonusercommitemail"></a>`commitEmail` | [`String`](#string) | User's default commit email. |
| <a id="addonusercreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the user was created. |
| <a id="addonuserdiscord"></a>`discord` | [`String`](#string) | Discord ID of the user. |
| <a id="addonuseremail"></a>`email` **{warning-solid}** | [`String`](#string) | **Deprecated** in GitLab 13.7. This was renamed. Use: [`User.publicEmail`](#userpublicemail). |
| <a id="addonuseremails"></a>`emails` | [`EmailConnection`](#emailconnection) | User's email addresses. (see [Connections](#connections)) |
| <a id="addonusergitpodenabled"></a>`gitpodEnabled` | [`Boolean`](#boolean) | Whether Gitpod is enabled at the user level. |
| <a id="addonusergroupcount"></a>`groupCount` | [`Int`](#int) | Group count for the user. |
| <a id="addonusergroupmemberships"></a>`groupMemberships` | [`GroupMemberConnection`](#groupmemberconnection) | Group memberships of the user. (see [Connections](#connections)) |
| <a id="addonuserid"></a>`id` | [`ID!`](#id) | ID of the user. |
| <a id="addonuseride"></a>`ide` | [`Ide`](#ide) | IDE settings. |
| <a id="addonuserjobtitle"></a>`jobTitle` | [`String`](#string) | Job title of the user. |
| <a id="addonuserlastactivityon"></a>`lastActivityOn` | [`Date`](#date) | Date the user last performed any actions. |
| <a id="addonuserlastloginat"></a>`lastLoginAt` | [`Time`](#time) | Timestamp of the last sign in. |
| <a id="addonuserlinkedin"></a>`linkedin` | [`String`](#string) | LinkedIn profile name of the user. |
| <a id="addonuserlocation"></a>`location` | [`String`](#string) | Location of the user. |
| <a id="addonusername"></a>`name` | [`String!`](#string) | Human-readable name of the user. Returns `****` if the user is a project bot and the requester does not have permission to view the project. |
| <a id="addonusernamespace"></a>`namespace` | [`Namespace`](#namespace) | Personal namespace of the user. |
| <a id="addonusernamespacecommitemails"></a>`namespaceCommitEmails` | [`NamespaceCommitEmailConnection`](#namespacecommitemailconnection) | User's custom namespace commit emails. (see [Connections](#connections)) |
| <a id="addonuserorganization"></a>`organization` | [`String`](#string) | Who the user represents or works for. |
| <a id="addonuserpreferencesgitpodpath"></a>`preferencesGitpodPath` | [`String`](#string) | Web path to the Gitpod section within user preferences. |
| <a id="addonuserprofileenablegitpodpath"></a>`profileEnableGitpodPath` | [`String`](#string) | Web path to enable Gitpod for the user. |
| <a id="addonuserprojectmemberships"></a>`projectMemberships` | [`ProjectMemberConnection`](#projectmemberconnection) | Project memberships of the user. (see [Connections](#connections)) |
| <a id="addonuserpronouns"></a>`pronouns` | [`String`](#string) | Pronouns of the user. |
| <a id="addonuserpublicemail"></a>`publicEmail` | [`String`](#string) | User's public email. |
| <a id="addonusersavedreplies"></a>`savedReplies` | [`SavedReplyConnection`](#savedreplyconnection) | Saved replies authored by the user. (see [Connections](#connections)) |
| <a id="addonuserstate"></a>`state` | [`UserState!`](#userstate) | State of the user. |
| <a id="addonuserstatus"></a>`status` | [`UserStatus`](#userstatus) | User status. |
| <a id="addonusertwitter"></a>`twitter` | [`String`](#string) | X (formerly Twitter) username of the user. |
| <a id="addonuseruserachievements"></a>`userAchievements` **{warning-solid}** | [`UserAchievementConnection`](#userachievementconnection) | **Introduced** in GitLab 15.10. **Status**: Experiment. Achievements for the user. Only returns for namespaces where the `achievements` feature flag is enabled. |
| <a id="addonuseruserpermissions"></a>`userPermissions` | [`UserPermissions!`](#userpermissions) | Permissions for the current user on the resource. |
| <a id="addonuserusername"></a>`username` | [`String!`](#string) | Username of the user. Unique within this instance of GitLab. |
| <a id="addonuserwebpath"></a>`webPath` | [`String!`](#string) | Web path of the user. |
| <a id="addonuserweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the user. |

#### Fields with arguments

##### `AddOnUser.addOnAssignments`

Add-on purchase assignments for the user.

DETAILS:
**Introduced** in GitLab 16.4.
**Status**: Experiment.

Returns [`UserAddOnAssignmentConnection`](#useraddonassignmentconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuseraddonassignmentsaddonpurchaseids"></a>`addOnPurchaseIds` | [`[GitlabSubscriptionsAddOnPurchaseID!]!`](#gitlabsubscriptionsaddonpurchaseid) | Global IDs of the add on purchases to find assignments for. |

##### `AddOnUser.assignedMergeRequests`

Merge requests assigned to the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserassignedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="addonuserassignedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="addonuserassignedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="addonuserassignedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="addonuserassignedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="addonuserassignedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | The global ID of the group the authored merge requests should be in. Merge requests in subgroups are included. |
| <a id="addonuserassignedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="addonuserassignedmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="addonuserassignedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="addonuserassignedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="addonuserassignedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="addonuserassignedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="addonuserassignedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="addonuserassignedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="addonuserassignedmergerequestsreviewstate"></a>`reviewState` **{warning-solid}** | [`MergeRequestReviewState`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer state of the merge request. |
| <a id="addonuserassignedmergerequestsreviewstates"></a>`reviewStates` **{warning-solid}** | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer states of the merge request. |
| <a id="addonuserassignedmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | Username of the reviewer. |
| <a id="addonuserassignedmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | Filter by reviewer presence. Incompatible with reviewerUsername. |
| <a id="addonuserassignedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="addonuserassignedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="addonuserassignedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="addonuserassignedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="addonuserassignedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="addonuserassignedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `AddOnUser.authoredMergeRequests`

Merge requests authored by the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserauthoredmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="addonuserauthoredmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of the assignee. |
| <a id="addonuserauthoredmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="addonuserauthoredmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="addonuserauthoredmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="addonuserauthoredmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | The global ID of the group the authored merge requests should be in. Merge requests in subgroups are included. |
| <a id="addonuserauthoredmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="addonuserauthoredmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="addonuserauthoredmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="addonuserauthoredmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="addonuserauthoredmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="addonuserauthoredmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="addonuserauthoredmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="addonuserauthoredmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="addonuserauthoredmergerequestsreviewstate"></a>`reviewState` **{warning-solid}** | [`MergeRequestReviewState`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer state of the merge request. |
| <a id="addonuserauthoredmergerequestsreviewstates"></a>`reviewStates` **{warning-solid}** | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer states of the merge request. |
| <a id="addonuserauthoredmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | Username of the reviewer. |
| <a id="addonuserauthoredmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | Filter by reviewer presence. Incompatible with reviewerUsername. |
| <a id="addonuserauthoredmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="addonuserauthoredmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="addonuserauthoredmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="addonuserauthoredmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="addonuserauthoredmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="addonuserauthoredmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `AddOnUser.groups`

Groups where the user has access.

Returns [`GroupConnection`](#groupconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonusergroupspermissionscope"></a>`permissionScope` | [`GroupPermission`](#grouppermission) | Filter by permissions the user has on groups. |
| <a id="addonusergroupssearch"></a>`search` | [`String`](#string) | Search by group name or path. |

##### `AddOnUser.organizations`

Organizations where the user has access.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Returns [`OrganizationConnection`](#organizationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserorganizationssearch"></a>`search` | [`String`](#string) | Search query, which can be for the organization name or a path. |

##### `AddOnUser.reviewRequestedMergeRequests`

Merge requests assigned to the user for review.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserreviewrequestedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="addonuserreviewrequestedmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of the assignee. |
| <a id="addonuserreviewrequestedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="addonuserreviewrequestedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="addonuserreviewrequestedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="addonuserreviewrequestedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="addonuserreviewrequestedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | The global ID of the group the authored merge requests should be in. Merge requests in subgroups are included. |
| <a id="addonuserreviewrequestedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="addonuserreviewrequestedmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="addonuserreviewrequestedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="addonuserreviewrequestedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="addonuserreviewrequestedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="addonuserreviewrequestedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="addonuserreviewrequestedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="addonuserreviewrequestedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="addonuserreviewrequestedmergerequestsreviewstate"></a>`reviewState` **{warning-solid}** | [`MergeRequestReviewState`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer state of the merge request. |
| <a id="addonuserreviewrequestedmergerequestsreviewstates"></a>`reviewStates` **{warning-solid}** | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer states of the merge request. |
| <a id="addonuserreviewrequestedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="addonuserreviewrequestedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="addonuserreviewrequestedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="addonuserreviewrequestedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="addonuserreviewrequestedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="addonuserreviewrequestedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `AddOnUser.savedReply`

Saved reply authored by the user.

Returns [`SavedReply`](#savedreply).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonusersavedreplyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | ID of a saved reply. |

##### `AddOnUser.snippets`

Snippets authored by the user.

Returns [`SnippetConnection`](#snippetconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonusersnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | Array of global snippet IDs. For example, `gid://gitlab/ProjectSnippet/1`. |
| <a id="addonusersnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | Type of snippet. |
| <a id="addonusersnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | Visibility of the snippet. |

##### `AddOnUser.starredProjects`

Projects starred by the user.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserstarredprojectssearch"></a>`search` | [`String`](#string) | Search query. |

##### `AddOnUser.timelogs`

Time logged by the user.

Returns [`TimelogConnection`](#timelogconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonusertimelogsenddate"></a>`endDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or before endDate. |
| <a id="addonusertimelogsendtime"></a>`endTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or before endTime. |
| <a id="addonusertimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | List timelogs for a group. |
| <a id="addonusertimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | List timelogs for a project. |
| <a id="addonusertimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | List timelogs in a particular order. |
| <a id="addonusertimelogsstartdate"></a>`startDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or after startDate. |
| <a id="addonusertimelogsstarttime"></a>`startTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or after startTime. |
| <a id="addonusertimelogsusername"></a>`username` | [`String`](#string) | List timelogs for a user. |

##### `AddOnUser.todos`

To-do items of the user.

Returns [`TodoConnection`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonusertodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | Action to be filtered. |
| <a id="addonusertodosauthorid"></a>`authorId` | [`[ID!]`](#id) | ID of an author. |
| <a id="addonusertodosgroupid"></a>`groupId` | [`[ID!]`](#id) | ID of a group. |
| <a id="addonusertodosprojectid"></a>`projectId` | [`[ID!]`](#id) | ID of a project. |
| <a id="addonusertodossort"></a>`sort` | [`TodoSort`](#todosort) | Sort todos by given criteria. |
| <a id="addonusertodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | State of the todo. |
| <a id="addonusertodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | Type of the todo. |

##### `AddOnUser.workspaces`

Workspaces owned by the current user.

Returns [`WorkspaceConnection`](#workspaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="addonuserworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | Filter workspaces by actual states. |
| <a id="addonuserworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | Filter workspaces by agent GlobalIDs. |
| <a id="addonuserworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | Filter workspaces by workspace GlobalIDs. For example, `["gid://gitlab/RemoteDevelopment::Workspace/1"]`. |
| <a id="addonuserworkspacesincludeactualstates"></a>`includeActualStates` **{warning-solid}** | [`[String!]`](#string) | **Deprecated** in GitLab 16.7. Use actual_states instead. |
| <a id="addonuserworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | Filter workspaces by project GlobalIDs. |

### `AgentConfiguration`

Configuration details for an Agent.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentconfigurationagentname"></a>`agentName` | [`String`](#string) | Name of the agent. |

### `AgentMetadata`

Information about a connected Agent.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="agentmetadatacommit"></a>`commit` | [`String`](#string) | Agent version commit. |
| <a id="agentmetadatapodname"></a>`podName` | [`String`](#string) | Name of the pod running the Agent. |
| <a id="agentmetadatapodnamespace"></a>`podNamespace` | [`String`](#string) | Namespace of the pod running the Agent. |
| <a id="agentmetadataversion"></a>`version` | [`String`](#string) | Agent version tag. |

### `AggregationStatus`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aggregationstatusenabled"></a>`enabled` | [`Boolean!`](#boolean) | Whether background aggregation is enabled or disabled. For downgraded, non-licensed groups and projects the field is `false`. |
| <a id="aggregationstatusestimatednextupdateat"></a>`estimatedNextUpdateAt` | [`Time`](#time) | Estimated time when the next incremental update will happen. |
| <a id="aggregationstatuslastupdateat"></a>`lastUpdateAt` | [`Time`](#time) | Last incremental update time. |

### `AiAgent`

An AI agent.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiagentcreatedat"></a>`createdAt` | [`Time!`](#time) | Date of creation. |
| <a id="aiagentid"></a>`id` | [`ID!`](#id) | ID of the agent. |
| <a id="aiagentlatestversion"></a>`latestVersion` | [`AiAgentVersion`](#aiagentversion) | Latest version of the agent. |
| <a id="aiagentname"></a>`name` | [`String!`](#string) | Name of the agent. |
| <a id="aiagentrouteid"></a>`routeId` | [`Int!`](#int) | Route ID of the agent. |
| <a id="aiagentversions"></a>`versions` | [`[AiAgentVersion!]`](#aiagentversion) | Versions of the agent. |

### `AiAgentVersion`

Version of an AI Agent.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aiagentversioncreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp when the agent version was created. |
| <a id="aiagentversionid"></a>`id` | [`ID!`](#id) | ID of the agent version. |
| <a id="aiagentversionmodel"></a>`model` | [`String!`](#string) | Model of the agent. |
| <a id="aiagentversionprompt"></a>`prompt` | [`String!`](#string) | Prompt of the agent. |

### `AiMessage`

AI features communication message.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessageagentversionid"></a>`agentVersionId` | [`AiAgentVersionID`](#aiagentversionid) | Global ID of the agent version to answer the message. |
| <a id="aimessagechunkid"></a>`chunkId` | [`Int`](#int) | Incremental ID for a chunk from a streamed message. Null when it is not a streamed message. |
| <a id="aimessagecontent"></a>`content` | [`String`](#string) | Raw response content. |
| <a id="aimessagecontenthtml"></a>`contentHtml` | [`String`](#string) | Response content as HTML. |
| <a id="aimessageerrors"></a>`errors` | [`[String!]`](#string) | Message errors. |
| <a id="aimessageextras"></a>`extras` | [`AiMessageExtras`](#aimessageextras) | Extra message metadata. |
| <a id="aimessageid"></a>`id` | [`ID`](#id) | UUID of the message. |
| <a id="aimessagerequestid"></a>`requestId` | [`String`](#string) | UUID of the original request. Shared between chat prompt and response. |
| <a id="aimessagerole"></a>`role` | [`AiMessageRole!`](#aimessagerole) | Message owner role. |
| <a id="aimessagetimestamp"></a>`timestamp` | [`Time!`](#time) | Message creation timestamp. |
| <a id="aimessagetype"></a>`type` | [`AiMessageType`](#aimessagetype) | Message type. |

### `AiMessageExtras`

Extra metadata for AI message.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimessageextrashasfeedback"></a>`hasFeedback` | [`Boolean`](#boolean) | Whether the user has provided feedback for the mesage. |
| <a id="aimessageextrassources"></a>`sources` | [`[JSON!]`](#json) | Sources used to form the message. |

### `AiMetrics`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="aimetricscodecontributorscount"></a>`codeContributorsCount` | [`Int!`](#int) | Number of code contributors. |
| <a id="aimetricscodesuggestionscontributorscount"></a>`codeSuggestionsContributorsCount` | [`Int!`](#int) | Number of code contributors who used GitLab Duo Code Suggestions features. |
| <a id="aimetricscodesuggestionsusagerate"></a>`codeSuggestionsUsageRate` | [`Float!`](#float) | Percentage of contributors who used GitLab Duo Code Suggestions features. |

### `AlertManagementAlert`

Describes an alert from the project's Alert Management.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertassignees"></a>`assignees` | [`UserCoreConnection`](#usercoreconnection) | Assignees of the alert. (see [Connections](#connections)) |
| <a id="alertmanagementalertcommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="alertmanagementalertcreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp the alert was created. |
| <a id="alertmanagementalertdescription"></a>`description` | [`String`](#string) | Description of the alert. |
| <a id="alertmanagementalertdetails"></a>`details` | [`JSON`](#json) | Alert details. |
| <a id="alertmanagementalertdetailsurl"></a>`detailsUrl` | [`String!`](#string) | URL of the alert detail page. |
| <a id="alertmanagementalertdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="alertmanagementalertendedat"></a>`endedAt` | [`Time`](#time) | Timestamp the alert ended. |
| <a id="alertmanagementalertenvironment"></a>`environment` | [`Environment`](#environment) | Environment for the alert. |
| <a id="alertmanagementalerteventcount"></a>`eventCount` | [`Int`](#int) | Number of events of this alert. |
| <a id="alertmanagementalerthosts"></a>`hosts` | [`[String!]`](#string) | List of hosts the alert came from. |
| <a id="alertmanagementalertid"></a>`id` | [`ID!`](#id) | ID of the alert. |
| <a id="alertmanagementalertiid"></a>`iid` | [`ID!`](#id) | Internal ID of the alert. |
| <a id="alertmanagementalertissue"></a>`issue` | [`Issue`](#issue) | Issue attached to the alert. |
| <a id="alertmanagementalertissueiid"></a>`issueIid` **{warning-solid}** | [`ID`](#id) | **Deprecated** in GitLab 13.10. Use issue field. |
| <a id="alertmanagementalertmetricsdashboardurl"></a>`metricsDashboardUrl` **{warning-solid}** | [`String`](#string) | **Deprecated** in GitLab 16.0. Returns no data. Underlying feature was removed in 16.0. |
| <a id="alertmanagementalertmonitoringtool"></a>`monitoringTool` | [`String`](#string) | Monitoring tool the alert came from. |
| <a id="alertmanagementalertprometheusalert"></a>`prometheusAlert` | [`PrometheusAlert`](#prometheusalert) | Alert condition for Prometheus. |
| <a id="alertmanagementalertrunbook"></a>`runbook` | [`String`](#string) | Runbook for the alert as defined in alert details. |
| <a id="alertmanagementalertservice"></a>`service` | [`String`](#string) | Service the alert came from. |
| <a id="alertmanagementalertseverity"></a>`severity` | [`AlertManagementSeverity`](#alertmanagementseverity) | Severity of the alert. |
| <a id="alertmanagementalertstartedat"></a>`startedAt` | [`Time`](#time) | Timestamp the alert was raised. |
| <a id="alertmanagementalertstatus"></a>`status` | [`AlertManagementStatus`](#alertmanagementstatus) | Status of the alert. |
| <a id="alertmanagementalerttitle"></a>`title` | [`String`](#string) | Title of the alert. |
| <a id="alertmanagementalertupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp the alert was last updated. |
| <a id="alertmanagementalertweburl"></a>`webUrl` | [`String!`](#string) | URL of the alert. |

#### Fields with arguments

##### `AlertManagementAlert.notes`

All notes on this noteable.

Returns [`NoteConnection!`](#noteconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertnotesfilter"></a>`filter` | [`NotesFilterType`](#notesfiltertype) | Type of notes collection: ALL_NOTES, ONLY_COMMENTS, ONLY_ACTIVITY. |

##### `AlertManagementAlert.todos`

To-do items of the current user for the alert.

Returns [`TodoConnection`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalerttodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | Action to be filtered. |
| <a id="alertmanagementalerttodosauthorid"></a>`authorId` | [`[ID!]`](#id) | ID of an author. |
| <a id="alertmanagementalerttodosgroupid"></a>`groupId` | [`[ID!]`](#id) | ID of a group. |
| <a id="alertmanagementalerttodosprojectid"></a>`projectId` | [`[ID!]`](#id) | ID of a project. |
| <a id="alertmanagementalerttodossort"></a>`sort` | [`TodoSort`](#todosort) | Sort todos by given criteria. |
| <a id="alertmanagementalerttodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | State of the todo. |
| <a id="alertmanagementalerttodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | Type of the todo. |

### `AlertManagementAlertStatusCountsType`

Represents total number of alerts for the represented categories.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementalertstatuscountstypeacknowledged"></a>`acknowledged` | [`Int`](#int) | Number of alerts with status ACKNOWLEDGED for the project. |
| <a id="alertmanagementalertstatuscountstypeall"></a>`all` | [`Int`](#int) | Total number of alerts for the project. |
| <a id="alertmanagementalertstatuscountstypeignored"></a>`ignored` | [`Int`](#int) | Number of alerts with status IGNORED for the project. |
| <a id="alertmanagementalertstatuscountstypeopen"></a>`open` | [`Int`](#int) | Number of alerts with status TRIGGERED or ACKNOWLEDGED for the project. |
| <a id="alertmanagementalertstatuscountstyperesolved"></a>`resolved` | [`Int`](#int) | Number of alerts with status RESOLVED for the project. |
| <a id="alertmanagementalertstatuscountstypetriggered"></a>`triggered` | [`Int`](#int) | Number of alerts with status TRIGGERED for the project. |

### `AlertManagementHttpIntegration`

An endpoint and credentials used to accept alerts for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementhttpintegrationactive"></a>`active` | [`Boolean`](#boolean) | Whether the endpoint is currently accepting alerts. |
| <a id="alertmanagementhttpintegrationapiurl"></a>`apiUrl` | [`String`](#string) | URL at which Prometheus metrics can be queried to populate the metrics dashboard. |
| <a id="alertmanagementhttpintegrationid"></a>`id` | [`ID!`](#id) | ID of the integration. |
| <a id="alertmanagementhttpintegrationname"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="alertmanagementhttpintegrationpayloadalertfields"></a>`payloadAlertFields` | [`[AlertManagementPayloadAlertField!]`](#alertmanagementpayloadalertfield) | Extract alert fields from payload example for custom mapping. |
| <a id="alertmanagementhttpintegrationpayloadattributemappings"></a>`payloadAttributeMappings` | [`[AlertManagementPayloadAlertMappingField!]`](#alertmanagementpayloadalertmappingfield) | The custom mapping of GitLab alert attributes to fields from the payload_example. |
| <a id="alertmanagementhttpintegrationpayloadexample"></a>`payloadExample` | [`JsonString`](#jsonstring) | Example of an alert payload. |
| <a id="alertmanagementhttpintegrationtoken"></a>`token` | [`String`](#string) | Token used to authenticate alert notification requests. |
| <a id="alertmanagementhttpintegrationtype"></a>`type` | [`AlertManagementIntegrationType!`](#alertmanagementintegrationtype) | Type of integration. |
| <a id="alertmanagementhttpintegrationurl"></a>`url` | [`String`](#string) | Endpoint which accepts alert notifications. |

### `AlertManagementPayloadAlertField`

Parsed field from an alert used for custom mappings.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementpayloadalertfieldlabel"></a>`label` | [`String`](#string) | Human-readable label of the payload path. |
| <a id="alertmanagementpayloadalertfieldpath"></a>`path` | [`[PayloadAlertFieldPathSegment!]`](#payloadalertfieldpathsegment) | Path to value inside payload JSON. |
| <a id="alertmanagementpayloadalertfieldtype"></a>`type` | [`AlertManagementPayloadAlertFieldType`](#alertmanagementpayloadalertfieldtype) | Type of the parsed value. |

### `AlertManagementPayloadAlertMappingField`

Parsed field (with its name) from an alert used for custom mappings.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementpayloadalertmappingfieldfieldname"></a>`fieldName` | [`AlertManagementPayloadAlertFieldName`](#alertmanagementpayloadalertfieldname) | GitLab alert field name. |
| <a id="alertmanagementpayloadalertmappingfieldlabel"></a>`label` | [`String`](#string) | Human-readable label of the payload path. |
| <a id="alertmanagementpayloadalertmappingfieldpath"></a>`path` | [`[PayloadAlertFieldPathSegment!]`](#payloadalertfieldpathsegment) | Path to value inside payload JSON. |
| <a id="alertmanagementpayloadalertmappingfieldtype"></a>`type` | [`AlertManagementPayloadAlertFieldType`](#alertmanagementpayloadalertfieldtype) | Type of the parsed value. |

### `AlertManagementPrometheusIntegration`

An endpoint and credentials used to accept Prometheus alerts for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="alertmanagementprometheusintegrationactive"></a>`active` | [`Boolean`](#boolean) | Whether the endpoint is currently accepting alerts. |
| <a id="alertmanagementprometheusintegrationapiurl"></a>`apiUrl` | [`String`](#string) | URL at which Prometheus metrics can be queried to populate the metrics dashboard. |
| <a id="alertmanagementprometheusintegrationid"></a>`id` | [`ID!`](#id) | ID of the integration. |
| <a id="alertmanagementprometheusintegrationname"></a>`name` | [`String`](#string) | Name of the integration. |
| <a id="alertmanagementprometheusintegrationtoken"></a>`token` | [`String`](#string) | Token used to authenticate alert notification requests. |
| <a id="alertmanagementprometheusintegrationtype"></a>`type` | [`AlertManagementIntegrationType!`](#alertmanagementintegrationtype) | Type of integration. |
| <a id="alertmanagementprometheusintegrationurl"></a>`url` | [`String`](#string) | Endpoint which accepts alert notifications. |

### `AmazonS3ConfigurationType`

Stores Amazon S3 configurations for audit event streaming.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="amazons3configurationtypeaccesskeyxid"></a>`accessKeyXid` | [`String!`](#string) | Access key ID of the Amazon S3 account. |
| <a id="amazons3configurationtypeawsregion"></a>`awsRegion` | [`String!`](#string) | AWS region where the bucket is created. |
| <a id="amazons3configurationtypebucketname"></a>`bucketName` | [`String!`](#string) | Name of the bucket where the audit events would be logged. |
| <a id="amazons3configurationtypegroup"></a>`group` | [`Group!`](#group) | Group the configuration belongs to. |
| <a id="amazons3configurationtypeid"></a>`id` | [`ID!`](#id) | ID of the configuration. |
| <a id="amazons3configurationtypename"></a>`name` | [`String!`](#string) | Name of the external destination to send audit events to. |

### `ApiFuzzingCiConfiguration`

Data associated with configuring API fuzzing scans in GitLab CI.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="apifuzzingciconfigurationscanmodes"></a>`scanModes` | [`[ApiFuzzingScanMode!]`](#apifuzzingscanmode) | All available scan modes. |
| <a id="apifuzzingciconfigurationscanprofiles"></a>`scanProfiles` | [`[ApiFuzzingScanProfile!]`](#apifuzzingscanprofile) | All default scan profiles. |

### `ApiFuzzingScanProfile`

An API Fuzzing scan profile.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="apifuzzingscanprofiledescription"></a>`description` | [`String`](#string) | Short description of the profile. |
| <a id="apifuzzingscanprofilename"></a>`name` | [`String`](#string) | Unique name of the profile. |
| <a id="apifuzzingscanprofileyaml"></a>`yaml` | [`String`](#string) | Syntax highlighted HTML representation of the YAML. |

### `ApprovalPolicy`

Represents the approval policy.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalpolicyallgroupapprovers"></a>`allGroupApprovers` | [`[PolicyApprovalGroup!]`](#policyapprovalgroup) | All potential approvers of the group type, including groups inaccessible to the user. |
| <a id="approvalpolicydeprecatedproperties"></a>`deprecatedProperties` **{warning-solid}** | [`[String!]`](#string) | **Introduced** in GitLab 16.10. **Status**: Experiment. All deprecated properties in the policy. |
| <a id="approvalpolicydescription"></a>`description` | [`String!`](#string) | Description of the policy. |
| <a id="approvalpolicyeditpath"></a>`editPath` | [`String!`](#string) | URL of policy edit page. |
| <a id="approvalpolicyenabled"></a>`enabled` | [`Boolean!`](#boolean) | Indicates whether this policy is enabled. |
| <a id="approvalpolicyname"></a>`name` | [`String!`](#string) | Name of the policy. |
| <a id="approvalpolicypolicyscope"></a>`policyScope` | [`PolicyScope`](#policyscope) | Scope of the policy. |
| <a id="approvalpolicyroleapprovers"></a>`roleApprovers` | [`[MemberAccessLevelName!]`](#memberaccesslevelname) | Approvers of the role type. Users belonging to these role(s) alone will be approvers. |
| <a id="approvalpolicysource"></a>`source` | [`SecurityPolicySource!`](#securitypolicysource) | Source of the policy. Its fields depend on the source type. |
| <a id="approvalpolicyupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the policy YAML was last updated. |
| <a id="approvalpolicyuserapprovers"></a>`userApprovers` | [`[UserCore!]`](#usercore) | Approvers of the user type. |
| <a id="approvalpolicyyaml"></a>`yaml` | [`String!`](#string) | YAML definition of the policy. |

### `ApprovalProjectRule`

Describes a project approval rule regarding who can approve merge requests.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalprojectruleapprovalsrequired"></a>`approvalsRequired` | [`Int`](#int) | Number of required approvals. |
| <a id="approvalprojectruleeligibleapprovers"></a>`eligibleApprovers` | [`UserCoreConnection`](#usercoreconnection) | List of users eligible to approve merge requests for this approval rule. (see [Connections](#connections)) |
| <a id="approvalprojectruleid"></a>`id` | [`GlobalID!`](#globalid) | ID of the rule. |
| <a id="approvalprojectrulename"></a>`name` | [`String`](#string) | Name of the rule. |
| <a id="approvalprojectruletype"></a>`type` | [`ApprovalRuleType`](#approvalruletype) | Type of the rule. |

### `ApprovalRule`

Describes a rule for who can approve merge requests.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalruleallowmergewheninvalid"></a>`allowMergeWhenInvalid` | [`Boolean`](#boolean) | Indicates if the rule can be ignored if it is invalid. |
| <a id="approvalruleapprovalsrequired"></a>`approvalsRequired` | [`Int`](#int) | Number of required approvals. |
| <a id="approvalruleapproved"></a>`approved` | [`Boolean`](#boolean) | Indicates if the rule is satisfied. |
| <a id="approvalruleapprovedby"></a>`approvedBy` | [`UserCoreConnection`](#usercoreconnection) | List of users defined in the rule that approved the merge request. (see [Connections](#connections)) |
| <a id="approvalrulecommentedby"></a>`commentedBy` | [`UserCoreConnection`](#usercoreconnection) | List of users, defined in the rule, who commented on the merge request. (see [Connections](#connections)) |
| <a id="approvalrulecontainshiddengroups"></a>`containsHiddenGroups` | [`Boolean`](#boolean) | Indicates if the rule contains approvers from a hidden group. |
| <a id="approvalruleeligibleapprovers"></a>`eligibleApprovers` | [`[UserCore!]`](#usercore) | List of all users eligible to approve the merge request (defined explicitly and from associated groups). |
| <a id="approvalrulegroups"></a>`groups` | [`GroupConnection`](#groupconnection) | List of groups added as approvers for the rule. (see [Connections](#connections)) |
| <a id="approvalruleid"></a>`id` | [`GlobalID!`](#globalid) | ID of the rule. |
| <a id="approvalruleinvalid"></a>`invalid` | [`Boolean`](#boolean) | Indicates if the rule is invalid and cannot be approved. |
| <a id="approvalrulename"></a>`name` | [`String`](#string) | Name of the rule. |
| <a id="approvalruleoverridden"></a>`overridden` | [`Boolean`](#boolean) | Indicates if the rule was overridden for the merge request. |
| <a id="approvalrulescanresultpolicies"></a>`scanResultPolicies` | [`[ApprovalScanResultPolicy!]`](#approvalscanresultpolicy) | List of scan result policies associated with the rule. |
| <a id="approvalrulesection"></a>`section` | [`String`](#string) | Named section of the Code Owners file that the rule applies to. |
| <a id="approvalrulesourcerule"></a>`sourceRule` | [`ApprovalRule`](#approvalrule) | Source rule used to create the rule. |
| <a id="approvalruletype"></a>`type` | [`ApprovalRuleType`](#approvalruletype) | Type of the rule. |
| <a id="approvalruleusers"></a>`users` | [`UserCoreConnection`](#usercoreconnection) | List of users added as approvers for the rule. (see [Connections](#connections)) |

### `ApprovalScanResultPolicy`

Represents the scan result policy.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="approvalscanresultpolicyapprovalsrequired"></a>`approvalsRequired` | [`Int!`](#int) | Represents the required approvals defined in the policy. |
| <a id="approvalscanresultpolicyname"></a>`name` | [`String!`](#string) | Represents the name of the policy. |
| <a id="approvalscanresultpolicyreporttype"></a>`reportType` | [`ApprovalReportType!`](#approvalreporttype) | Represents the report_type of the approval rule. |

### `AssetType`

Represents a vulnerability asset type.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="assettypename"></a>`name` | [`String!`](#string) | Name of the asset. |
| <a id="assettypetype"></a>`type` | [`String!`](#string) | Type of the asset. |
| <a id="assettypeurl"></a>`url` | [`String!`](#string) | URL of the asset. |

### `AuditEventDefinition`

Represents the YAML definitions for audit events defined in `ee/config/audit_events/types/<event-type-name>.yml` and `config/audit_events/types/<event-type-name>.yml`.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventdefinitiondescription"></a>`description` | [`String!`](#string) | Description of what action the audit event tracks. |
| <a id="auditeventdefinitionfeaturecategory"></a>`featureCategory` | [`String!`](#string) | Feature category associated with the event. |
| <a id="auditeventdefinitionintroducedbyissue"></a>`introducedByIssue` | [`String`](#string) | Link to the issue introducing the event. For olderaudit events, it can be a commit URL rather than amerge request URL. |
| <a id="auditeventdefinitionintroducedbymr"></a>`introducedByMr` | [`String`](#string) | Link to the merge request introducing the event. Forolder audit events, it can be a commit URL rather thana merge request URL. |
| <a id="auditeventdefinitionmilestone"></a>`milestone` | [`String!`](#string) | Milestone the event was introduced in. |
| <a id="auditeventdefinitionname"></a>`name` | [`String!`](#string) | Key name of the audit event. |
| <a id="auditeventdefinitionsavedtodatabase"></a>`savedToDatabase` | [`Boolean!`](#boolean) | Indicates if the event is saved to PostgreSQL database. |
| <a id="auditeventdefinitionstreamed"></a>`streamed` | [`Boolean!`](#boolean) | Indicates if the event is streamed to an external destination. |

### `AuditEventStreamingHTTPNamespaceFilter`

Represents a subgroup or project filter that belongs to an external audit event streaming destination.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreaminghttpnamespacefilterexternalauditeventdestination"></a>`externalAuditEventDestination` | [`ExternalAuditEventDestination!`](#externalauditeventdestination) | Destination to which the filter belongs. |
| <a id="auditeventstreaminghttpnamespacefilterid"></a>`id` | [`ID!`](#id) | ID of the filter. |
| <a id="auditeventstreaminghttpnamespacefilternamespace"></a>`namespace` | [`Namespace!`](#namespace) | Group or project namespace the filter belongs to. |

### `AuditEventStreamingHeader`

Represents a HTTP header key/value that belongs to an audit streaming destination.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventstreamingheaderactive"></a>`active` | [`Boolean!`](#boolean) | Header is active or not. |
| <a id="auditeventstreamingheaderid"></a>`id` | [`ID!`](#id) | ID of the header. |
| <a id="auditeventstreamingheaderkey"></a>`key` | [`String!`](#string) | Key of the header. |
| <a id="auditeventstreamingheadervalue"></a>`value` | [`String!`](#string) | Value of the header. |

### `AuditEventsStreamingHTTPNamespaceFiltersAddPayload`

Autogenerated return type of AuditEventsStreamingHTTPNamespaceFiltersAdd.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminghttpnamespacefiltersaddpayloadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="auditeventsstreaminghttpnamespacefiltersaddpayloaderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |
| <a id="auditeventsstreaminghttpnamespacefiltersaddpayloadnamespacefilter"></a>`namespaceFilter` | [`AuditEventStreamingHTTPNamespaceFilter`](#auditeventstreaminghttpnamespacefilter) | Namespace filter created. |

### `AuditEventsStreamingHTTPNamespaceFiltersDeletePayload`

Autogenerated return type of AuditEventsStreamingHTTPNamespaceFiltersDelete.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminghttpnamespacefiltersdeletepayloadclientmutationid"></a>`clientMutationId` | [`String`](#string) | A unique identifier for the client performing the mutation. |
| <a id="auditeventsstreaminghttpnamespacefiltersdeletepayloaderrors"></a>`errors` | [`[String!]!`](#string) | Errors encountered during execution of the mutation. |

### `AuditEventsStreamingInstanceHeader`

Represents a HTTP header key/value that belongs to an instance level audit streaming destination.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="auditeventsstreaminginstanceheaderactive"></a>`active` | [`Boolean!`](#boolean) | Header is active or not. |
| <a id="auditeventsstreaminginstanceheaderid"></a>`id` | [`ID!`](#id) | ID of the header. |
| <a id="auditeventsstreaminginstanceheaderkey"></a>`key` | [`String!`](#string) | Key of the header. |
| <a id="auditeventsstreaminginstanceheadervalue"></a>`value` | [`String!`](#string) | Value of the header. |

### `AutocompletedUser`

Core representation of a GitLab user.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompleteduseravatarurl"></a>`avatarUrl` | [`String`](#string) | URL of the user's avatar. |
| <a id="autocompleteduserbio"></a>`bio` | [`String`](#string) | Bio of the user. |
| <a id="autocompleteduserbot"></a>`bot` | [`Boolean!`](#boolean) | Indicates if the user is a bot. |
| <a id="autocompletedusercallouts"></a>`callouts` | [`UserCalloutConnection`](#usercalloutconnection) | User callouts that belong to the user. (see [Connections](#connections)) |
| <a id="autocompletedusercommitemail"></a>`commitEmail` | [`String`](#string) | User's default commit email. |
| <a id="autocompletedusercreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the user was created. |
| <a id="autocompleteduserdiscord"></a>`discord` | [`String`](#string) | Discord ID of the user. |
| <a id="autocompleteduseremail"></a>`email` **{warning-solid}** | [`String`](#string) | **Deprecated** in GitLab 13.7. This was renamed. Use: [`User.publicEmail`](#userpublicemail). |
| <a id="autocompleteduseremails"></a>`emails` | [`EmailConnection`](#emailconnection) | User's email addresses. (see [Connections](#connections)) |
| <a id="autocompletedusergitpodenabled"></a>`gitpodEnabled` | [`Boolean`](#boolean) | Whether Gitpod is enabled at the user level. |
| <a id="autocompletedusergroupcount"></a>`groupCount` | [`Int`](#int) | Group count for the user. |
| <a id="autocompletedusergroupmemberships"></a>`groupMemberships` | [`GroupMemberConnection`](#groupmemberconnection) | Group memberships of the user. (see [Connections](#connections)) |
| <a id="autocompleteduserid"></a>`id` | [`ID!`](#id) | ID of the user. |
| <a id="autocompleteduseride"></a>`ide` | [`Ide`](#ide) | IDE settings. |
| <a id="autocompleteduserjobtitle"></a>`jobTitle` | [`String`](#string) | Job title of the user. |
| <a id="autocompleteduserlastactivityon"></a>`lastActivityOn` | [`Date`](#date) | Date the user last performed any actions. |
| <a id="autocompleteduserlinkedin"></a>`linkedin` | [`String`](#string) | LinkedIn profile name of the user. |
| <a id="autocompleteduserlocation"></a>`location` | [`String`](#string) | Location of the user. |
| <a id="autocompletedusername"></a>`name` | [`String!`](#string) | Human-readable name of the user. Returns `****` if the user is a project bot and the requester does not have permission to view the project. |
| <a id="autocompletedusernamespace"></a>`namespace` | [`Namespace`](#namespace) | Personal namespace of the user. |
| <a id="autocompletedusernamespacecommitemails"></a>`namespaceCommitEmails` | [`NamespaceCommitEmailConnection`](#namespacecommitemailconnection) | User's custom namespace commit emails. (see [Connections](#connections)) |
| <a id="autocompleteduserorganization"></a>`organization` | [`String`](#string) | Who the user represents or works for. |
| <a id="autocompleteduserpreferencesgitpodpath"></a>`preferencesGitpodPath` | [`String`](#string) | Web path to the Gitpod section within user preferences. |
| <a id="autocompleteduserprofileenablegitpodpath"></a>`profileEnableGitpodPath` | [`String`](#string) | Web path to enable Gitpod for the user. |
| <a id="autocompleteduserprojectmemberships"></a>`projectMemberships` | [`ProjectMemberConnection`](#projectmemberconnection) | Project memberships of the user. (see [Connections](#connections)) |
| <a id="autocompleteduserpronouns"></a>`pronouns` | [`String`](#string) | Pronouns of the user. |
| <a id="autocompleteduserpublicemail"></a>`publicEmail` | [`String`](#string) | User's public email. |
| <a id="autocompletedusersavedreplies"></a>`savedReplies` | [`SavedReplyConnection`](#savedreplyconnection) | Saved replies authored by the user. (see [Connections](#connections)) |
| <a id="autocompleteduserstate"></a>`state` | [`UserState!`](#userstate) | State of the user. |
| <a id="autocompleteduserstatus"></a>`status` | [`UserStatus`](#userstatus) | User status. |
| <a id="autocompletedusertwitter"></a>`twitter` | [`String`](#string) | X (formerly Twitter) username of the user. |
| <a id="autocompleteduseruserachievements"></a>`userAchievements` **{warning-solid}** | [`UserAchievementConnection`](#userachievementconnection) | **Introduced** in GitLab 15.10. **Status**: Experiment. Achievements for the user. Only returns for namespaces where the `achievements` feature flag is enabled. |
| <a id="autocompleteduseruserpermissions"></a>`userPermissions` | [`UserPermissions!`](#userpermissions) | Permissions for the current user on the resource. |
| <a id="autocompleteduserusername"></a>`username` | [`String!`](#string) | Username of the user. Unique within this instance of GitLab. |
| <a id="autocompleteduserwebpath"></a>`webPath` | [`String!`](#string) | Web path of the user. |
| <a id="autocompleteduserweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the user. |

#### Fields with arguments

##### `AutocompletedUser.assignedMergeRequests`

Merge requests assigned to the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompleteduserassignedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="autocompleteduserassignedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="autocompleteduserassignedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="autocompleteduserassignedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="autocompleteduserassignedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="autocompleteduserassignedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | The global ID of the group the authored merge requests should be in. Merge requests in subgroups are included. |
| <a id="autocompleteduserassignedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="autocompleteduserassignedmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="autocompleteduserassignedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="autocompleteduserassignedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="autocompleteduserassignedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="autocompleteduserassignedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="autocompleteduserassignedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="autocompleteduserassignedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="autocompleteduserassignedmergerequestsreviewstate"></a>`reviewState` **{warning-solid}** | [`MergeRequestReviewState`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer state of the merge request. |
| <a id="autocompleteduserassignedmergerequestsreviewstates"></a>`reviewStates` **{warning-solid}** | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer states of the merge request. |
| <a id="autocompleteduserassignedmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | Username of the reviewer. |
| <a id="autocompleteduserassignedmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | Filter by reviewer presence. Incompatible with reviewerUsername. |
| <a id="autocompleteduserassignedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="autocompleteduserassignedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="autocompleteduserassignedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="autocompleteduserassignedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="autocompleteduserassignedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="autocompleteduserassignedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `AutocompletedUser.authoredMergeRequests`

Merge requests authored by the user.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompleteduserauthoredmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="autocompleteduserauthoredmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of the assignee. |
| <a id="autocompleteduserauthoredmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="autocompleteduserauthoredmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="autocompleteduserauthoredmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="autocompleteduserauthoredmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | The global ID of the group the authored merge requests should be in. Merge requests in subgroups are included. |
| <a id="autocompleteduserauthoredmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="autocompleteduserauthoredmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="autocompleteduserauthoredmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="autocompleteduserauthoredmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="autocompleteduserauthoredmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="autocompleteduserauthoredmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="autocompleteduserauthoredmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="autocompleteduserauthoredmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="autocompleteduserauthoredmergerequestsreviewstate"></a>`reviewState` **{warning-solid}** | [`MergeRequestReviewState`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer state of the merge request. |
| <a id="autocompleteduserauthoredmergerequestsreviewstates"></a>`reviewStates` **{warning-solid}** | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer states of the merge request. |
| <a id="autocompleteduserauthoredmergerequestsreviewerusername"></a>`reviewerUsername` | [`String`](#string) | Username of the reviewer. |
| <a id="autocompleteduserauthoredmergerequestsreviewerwildcardid"></a>`reviewerWildcardId` | [`ReviewerWildcardId`](#reviewerwildcardid) | Filter by reviewer presence. Incompatible with reviewerUsername. |
| <a id="autocompleteduserauthoredmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="autocompleteduserauthoredmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="autocompleteduserauthoredmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="autocompleteduserauthoredmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="autocompleteduserauthoredmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="autocompleteduserauthoredmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `AutocompletedUser.groups`

Groups where the user has access.

Returns [`GroupConnection`](#groupconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompletedusergroupspermissionscope"></a>`permissionScope` | [`GroupPermission`](#grouppermission) | Filter by permissions the user has on groups. |
| <a id="autocompletedusergroupssearch"></a>`search` | [`String`](#string) | Search by group name or path. |

##### `AutocompletedUser.mergeRequestInteraction`

Merge request state related to the user.

Returns [`UserMergeRequestInteraction`](#usermergerequestinteraction).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompletedusermergerequestinteractionid"></a>`id` | [`MergeRequestID!`](#mergerequestid) | Global ID of the merge request. |

##### `AutocompletedUser.organizations`

Organizations where the user has access.

DETAILS:
**Introduced** in GitLab 16.6.
**Status**: Experiment.

Returns [`OrganizationConnection`](#organizationconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompleteduserorganizationssearch"></a>`search` | [`String`](#string) | Search query, which can be for the organization name or a path. |

##### `AutocompletedUser.reviewRequestedMergeRequests`

Merge requests assigned to the user for review.

Returns [`MergeRequestConnection`](#mergerequestconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompleteduserreviewrequestedmergerequestsapproved"></a>`approved` | [`Boolean`](#boolean) | Limit results to approved merge requests. Available only when the feature flag `mr_approved_filter` is enabled. |
| <a id="autocompleteduserreviewrequestedmergerequestsassigneeusername"></a>`assigneeUsername` | [`String`](#string) | Username of the assignee. |
| <a id="autocompleteduserreviewrequestedmergerequestsauthorusername"></a>`authorUsername` | [`String`](#string) | Username of the author. |
| <a id="autocompleteduserreviewrequestedmergerequestscreatedafter"></a>`createdAfter` | [`Time`](#time) | Merge requests created after this timestamp. |
| <a id="autocompleteduserreviewrequestedmergerequestscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Merge requests created before this timestamp. |
| <a id="autocompleteduserreviewrequestedmergerequestsdraft"></a>`draft` | [`Boolean`](#boolean) | Limit result to draft merge requests. |
| <a id="autocompleteduserreviewrequestedmergerequestsgroupid"></a>`groupId` | [`GroupID`](#groupid) | The global ID of the group the authored merge requests should be in. Merge requests in subgroups are included. |
| <a id="autocompleteduserreviewrequestedmergerequestsiids"></a>`iids` | [`[String!]`](#string) | Array of IIDs of merge requests, for example `[1, 2]`. |
| <a id="autocompleteduserreviewrequestedmergerequestslabels"></a>`labels` | [`[String!]`](#string) | Array of label names. All resolved merge requests will have all of these labels. |
| <a id="autocompleteduserreviewrequestedmergerequestsmergedafter"></a>`mergedAfter` | [`Time`](#time) | Merge requests merged after this date. |
| <a id="autocompleteduserreviewrequestedmergerequestsmergedbefore"></a>`mergedBefore` | [`Time`](#time) | Merge requests merged before this date. |
| <a id="autocompleteduserreviewrequestedmergerequestsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Title of the milestone. |
| <a id="autocompleteduserreviewrequestedmergerequestsnot"></a>`not` | [`MergeRequestsResolverNegatedParams`](#mergerequestsresolvernegatedparams) | List of negated arguments. Warning: this argument is experimental and a subject to change in future. |
| <a id="autocompleteduserreviewrequestedmergerequestsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | The global ID of the project the authored merge requests should be in. Incompatible with projectPath. |
| <a id="autocompleteduserreviewrequestedmergerequestsprojectpath"></a>`projectPath` | [`String`](#string) | The full-path of the project the authored merge requests should be in. Incompatible with projectId. |
| <a id="autocompleteduserreviewrequestedmergerequestsreviewstate"></a>`reviewState` **{warning-solid}** | [`MergeRequestReviewState`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer state of the merge request. |
| <a id="autocompleteduserreviewrequestedmergerequestsreviewstates"></a>`reviewStates` **{warning-solid}** | [`[MergeRequestReviewState!]`](#mergerequestreviewstate) | **Introduced** in GitLab 17.0. **Status**: Experiment. Reviewer states of the merge request. |
| <a id="autocompleteduserreviewrequestedmergerequestssort"></a>`sort` | [`MergeRequestSort`](#mergerequestsort) | Sort merge requests by this criteria. |
| <a id="autocompleteduserreviewrequestedmergerequestssourcebranches"></a>`sourceBranches` | [`[String!]`](#string) | Array of source branch names. All resolved merge requests will have one of these branches as their source. |
| <a id="autocompleteduserreviewrequestedmergerequestsstate"></a>`state` | [`MergeRequestState`](#mergerequeststate) | Merge request state. If provided, all resolved merge requests will have this state. |
| <a id="autocompleteduserreviewrequestedmergerequeststargetbranches"></a>`targetBranches` | [`[String!]`](#string) | Array of target branch names. All resolved merge requests will have one of these branches as their target. |
| <a id="autocompleteduserreviewrequestedmergerequestsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Merge requests updated after this timestamp. |
| <a id="autocompleteduserreviewrequestedmergerequestsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Merge requests updated before this timestamp. |

##### `AutocompletedUser.savedReply`

Saved reply authored by the user.

Returns [`SavedReply`](#savedreply).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompletedusersavedreplyid"></a>`id` | [`UsersSavedReplyID!`](#userssavedreplyid) | ID of a saved reply. |

##### `AutocompletedUser.snippets`

Snippets authored by the user.

Returns [`SnippetConnection`](#snippetconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompletedusersnippetsids"></a>`ids` | [`[SnippetID!]`](#snippetid) | Array of global snippet IDs. For example, `gid://gitlab/ProjectSnippet/1`. |
| <a id="autocompletedusersnippetstype"></a>`type` | [`TypeEnum`](#typeenum) | Type of snippet. |
| <a id="autocompletedusersnippetsvisibility"></a>`visibility` | [`VisibilityScopesEnum`](#visibilityscopesenum) | Visibility of the snippet. |

##### `AutocompletedUser.starredProjects`

Projects starred by the user.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompleteduserstarredprojectssearch"></a>`search` | [`String`](#string) | Search query. |

##### `AutocompletedUser.timelogs`

Time logged by the user.

Returns [`TimelogConnection`](#timelogconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompletedusertimelogsenddate"></a>`endDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or before endDate. |
| <a id="autocompletedusertimelogsendtime"></a>`endTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or before endTime. |
| <a id="autocompletedusertimelogsgroupid"></a>`groupId` | [`GroupID`](#groupid) | List timelogs for a group. |
| <a id="autocompletedusertimelogsprojectid"></a>`projectId` | [`ProjectID`](#projectid) | List timelogs for a project. |
| <a id="autocompletedusertimelogssort"></a>`sort` | [`TimelogSort`](#timelogsort) | List timelogs in a particular order. |
| <a id="autocompletedusertimelogsstartdate"></a>`startDate` | [`Time`](#time) | List timelogs within a date range where the logged date is equal to or after startDate. |
| <a id="autocompletedusertimelogsstarttime"></a>`startTime` | [`Time`](#time) | List timelogs within a time range where the logged time is equal to or after startTime. |
| <a id="autocompletedusertimelogsusername"></a>`username` | [`String`](#string) | List timelogs for a user. |

##### `AutocompletedUser.todos`

To-do items of the user.

Returns [`TodoConnection`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompletedusertodosaction"></a>`action` | [`[TodoActionEnum!]`](#todoactionenum) | Action to be filtered. |
| <a id="autocompletedusertodosauthorid"></a>`authorId` | [`[ID!]`](#id) | ID of an author. |
| <a id="autocompletedusertodosgroupid"></a>`groupId` | [`[ID!]`](#id) | ID of a group. |
| <a id="autocompletedusertodosprojectid"></a>`projectId` | [`[ID!]`](#id) | ID of a project. |
| <a id="autocompletedusertodossort"></a>`sort` | [`TodoSort`](#todosort) | Sort todos by given criteria. |
| <a id="autocompletedusertodosstate"></a>`state` | [`[TodoStateEnum!]`](#todostateenum) | State of the todo. |
| <a id="autocompletedusertodostype"></a>`type` | [`[TodoTargetEnum!]`](#todotargetenum) | Type of the todo. |

##### `AutocompletedUser.workspaces`

Workspaces owned by the current user.

Returns [`WorkspaceConnection`](#workspaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="autocompleteduserworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | Filter workspaces by actual states. |
| <a id="autocompleteduserworkspacesagentids"></a>`agentIds` | [`[ClustersAgentID!]`](#clustersagentid) | Filter workspaces by agent GlobalIDs. |
| <a id="autocompleteduserworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | Filter workspaces by workspace GlobalIDs. For example, `["gid://gitlab/RemoteDevelopment::Workspace/1"]`. |
| <a id="autocompleteduserworkspacesincludeactualstates"></a>`includeActualStates` **{warning-solid}** | [`[String!]`](#string) | **Deprecated** in GitLab 16.7. Use actual_states instead. |
| <a id="autocompleteduserworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | Filter workspaces by project GlobalIDs. |

### `AwardEmoji`

An emoji awarded by a user.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="awardemojidescription"></a>`description` | [`String!`](#string) | Emoji description. |
| <a id="awardemojiemoji"></a>`emoji` | [`String!`](#string) | Emoji as an icon. |
| <a id="awardemojiname"></a>`name` | [`String!`](#string) | Emoji name. |
| <a id="awardemojiunicode"></a>`unicode` | [`String!`](#string) | Emoji in Unicode. |
| <a id="awardemojiunicodeversion"></a>`unicodeVersion` | [`String!`](#string) | Unicode version for this emoji. |
| <a id="awardemojiuser"></a>`user` | [`UserCore!`](#usercore) | User who awarded the emoji. |

### `BaseService`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="baseserviceactive"></a>`active` | [`Boolean`](#boolean) | Indicates if the service is active. |
| <a id="baseserviceservicetype"></a>`serviceType` | [`ServiceType`](#servicetype) | Type of the service. |
| <a id="baseservicetype"></a>`type` | [`String`](#string) | Class name of the service. |

### `Blame`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blamefirstline"></a>`firstLine` | [`String`](#string) | First line of Git Blame for given range. |
| <a id="blamegroups"></a>`groups` | [`[Groups!]`](#groups) | Git Blame grouped by contiguous lines for commit. |

### `Blob`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobflatpath"></a>`flatPath` | [`String!`](#string) | Flat path of the entry. |
| <a id="blobid"></a>`id` | [`ID!`](#id) | ID of the entry. |
| <a id="bloblfsoid"></a>`lfsOid` | [`String`](#string) | LFS ID of the blob. |
| <a id="blobmode"></a>`mode` | [`String`](#string) | Blob mode in numeric format. |
| <a id="blobname"></a>`name` | [`String!`](#string) | Name of the entry. |
| <a id="blobpath"></a>`path` | [`String!`](#string) | Path of the entry. |
| <a id="blobsha"></a>`sha` | [`String!`](#string) | Last commit SHA for the entry. |
| <a id="blobtype"></a>`type` | [`EntryType!`](#entrytype) | Type of tree entry. |
| <a id="blobwebpath"></a>`webPath` | [`String`](#string) | Web path of the blob. |
| <a id="blobweburl"></a>`webUrl` | [`String`](#string) | Web URL of the blob. |

### `BlobViewer`

Represents how the blob content should be displayed.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blobviewercollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | Shows whether the blob should be displayed collapsed. |
| <a id="blobviewerfiletype"></a>`fileType` | [`String!`](#string) | Content file type. |
| <a id="blobviewerloadasync"></a>`loadAsync` | [`Boolean!`](#boolean) | Shows whether the blob content is loaded asynchronously. |
| <a id="blobviewerloadingpartialname"></a>`loadingPartialName` | [`String!`](#string) | Loading partial name. |
| <a id="blobviewerrendererror"></a>`renderError` | [`String`](#string) | Error rendering the blob content. |
| <a id="blobviewertoolarge"></a>`tooLarge` | [`Boolean!`](#boolean) | Shows whether the blob is too large to be displayed. |
| <a id="blobviewertype"></a>`type` | [`BlobViewersType!`](#blobviewerstype) | Type of blob viewer. |

### `BlockingMergeRequests`

Information about the rules that must be satisfied to merge this merge request.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="blockingmergerequestshiddencount"></a>`hiddenCount` | [`Int!`](#int) | Blocking merge requests not visible to the user. |
| <a id="blockingmergerequeststotalcount"></a>`totalCount` | [`Int!`](#int) | Total number of blocking merge requests. |
| <a id="blockingmergerequestsvisiblemergerequests"></a>`visibleMergeRequests` | [`[MergeRequest!]`](#mergerequest) | Blocking merge requests visible to the user. |

### `Board`

Represents a project or group issue board.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardassignee"></a>`assignee` | [`UserCore`](#usercore) | Board assignee. |
| <a id="boardcreatedat"></a>`createdAt` | [`Time!`](#time) | Timestamp of when the board was created. |
| <a id="boardhidebackloglist"></a>`hideBacklogList` | [`Boolean`](#boolean) | Whether or not backlog list is hidden. |
| <a id="boardhideclosedlist"></a>`hideClosedList` | [`Boolean`](#boolean) | Whether or not closed list is hidden. |
| <a id="boardid"></a>`id` | [`ID!`](#id) | ID (global ID) of the board. |
| <a id="boarditeration"></a>`iteration` | [`Iteration`](#iteration) | Board iteration. |
| <a id="boarditerationcadence"></a>`iterationCadence` | [`IterationCadence`](#iterationcadence) | Board iteration cadence. |
| <a id="boardlabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels of the board. (see [Connections](#connections)) |
| <a id="boardmilestone"></a>`milestone` | [`Milestone`](#milestone) | Board milestone. |
| <a id="boardname"></a>`name` | [`String`](#string) | Name of the board. |
| <a id="boardupdatedat"></a>`updatedAt` | [`Time!`](#time) | Timestamp of when the board was last updated. |
| <a id="boardwebpath"></a>`webPath` | [`String!`](#string) | Web path of the board. |
| <a id="boardweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the board. |
| <a id="boardweight"></a>`weight` | [`Int`](#int) | Weight of the board. |

#### Fields with arguments

##### `Board.epics`

Epics associated with board issues.

Returns [`BoardEpicConnection`](#boardepicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicsissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when selecting issues on the board. |

##### `Board.lists`

Lists of the board.

Returns [`BoardListConnection`](#boardlistconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistsid"></a>`id` | [`ListID`](#listid) | Find a list by its global ID. |
| <a id="boardlistsissuefilters"></a>`issueFilters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when getting issue metadata in the board list. |

### `BoardEpic`

Represents an epic on an issue board.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicauthor"></a>`author` | [`UserCore!`](#usercore) | Author of the epic. |
| <a id="boardepicawardemoji"></a>`awardEmoji` | [`AwardEmojiConnection`](#awardemojiconnection) | List of emoji reactions associated with the epic. (see [Connections](#connections)) |
| <a id="boardepicblocked"></a>`blocked` | [`Boolean`](#boolean) | Indicates the epic is blocked. |
| <a id="boardepicblockedbycount"></a>`blockedByCount` | [`Int`](#int) | Count of epics blocking this epic. |
| <a id="boardepicblockedbyepics"></a>`blockedByEpics` | [`EpicConnection`](#epicconnection) | Epics blocking this epic. (see [Connections](#connections)) |
| <a id="boardepicblockingcount"></a>`blockingCount` | [`Int`](#int) | Count of epics that this epic is blocking. |
| <a id="boardepicclosedat"></a>`closedAt` | [`Time`](#time) | Timestamp of when the epic was closed. |
| <a id="boardepiccolor"></a>`color` | [`String`](#string) | Color of the epic. Returns `null` if `epic_color_highlight` feature flag is disabled. |
| <a id="boardepiccommenters"></a>`commenters` | [`UserCoreConnection!`](#usercoreconnection) | All commenters on this noteable. (see [Connections](#connections)) |
| <a id="boardepicconfidential"></a>`confidential` | [`Boolean`](#boolean) | Indicates if the epic is confidential. |
| <a id="boardepiccreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the epic was created. |
| <a id="boardepicdefaultprojectforissuecreation"></a>`defaultProjectForIssueCreation` | [`Project`](#project) | Default Project for issue creation. Based on the project the user created the last issue in. |
| <a id="boardepicdescendantcounts"></a>`descendantCounts` | [`EpicDescendantCount`](#epicdescendantcount) | Number of open and closed descendant epics and issues. |
| <a id="boardepicdescendantweightsum"></a>`descendantWeightSum` | [`EpicDescendantWeights`](#epicdescendantweights) | Total weight of open and closed issues in the epic and its descendants. |
| <a id="boardepicdescription"></a>`description` | [`String`](#string) | Description of the epic. |
| <a id="boardepicdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="boardepicdiscussions"></a>`discussions` | [`DiscussionConnection!`](#discussionconnection) | All discussions on this noteable. (see [Connections](#connections)) |
| <a id="boardepicdownvotes"></a>`downvotes` | [`Int!`](#int) | Number of downvotes the epic has received. |
| <a id="boardepicduedate"></a>`dueDate` | [`Time`](#time) | Due date of the epic. |
| <a id="boardepicduedatefixed"></a>`dueDateFixed` | [`Time`](#time) | Fixed due date of the epic. |
| <a id="boardepicduedatefrominheritedsource"></a>`dueDateFromInheritedSource` | [`Time`](#time) | Inherited due date of the epic from child epics or milestones. |
| <a id="boardepicduedatefrommilestones"></a>`dueDateFromMilestones` | [`Time`](#time) | Inherited due date of the epic from milestones. |
| <a id="boardepicduedateisfixed"></a>`dueDateIsFixed` | [`Boolean`](#boolean) | Indicates if the due date has been manually set. |
| <a id="boardepicevents"></a>`events` | [`EventConnection`](#eventconnection) | List of events associated with the object. (see [Connections](#connections)) |
| <a id="boardepicgroup"></a>`group` | [`Group!`](#group) | Group to which the epic belongs. |
| <a id="boardepichaschildren"></a>`hasChildren` | [`Boolean!`](#boolean) | Indicates if the epic has children. |
| <a id="boardepichasissues"></a>`hasIssues` | [`Boolean!`](#boolean) | Indicates if the epic has direct issues. |
| <a id="boardepichasparent"></a>`hasParent` | [`Boolean!`](#boolean) | Indicates if the epic has a parent epic. |
| <a id="boardepichealthstatus"></a>`healthStatus` | [`EpicHealthStatus`](#epichealthstatus) | Current health status of the epic. |
| <a id="boardepicid"></a>`id` | [`ID!`](#id) | ID of the epic. |
| <a id="boardepiciid"></a>`iid` | [`ID!`](#id) | Internal ID of the epic. |
| <a id="boardepicissues"></a>`issues` | [`EpicIssueConnection`](#epicissueconnection) | A list of issues associated with the epic. (see [Connections](#connections)) |
| <a id="boardepiclabels"></a>`labels` | [`LabelConnection`](#labelconnection) | Labels assigned to the epic. (see [Connections](#connections)) |
| <a id="boardepicparent"></a>`parent` | [`Epic`](#epic) | Parent epic of the epic. |
| <a id="boardepicparticipants"></a>`participants` | [`UserCoreConnection`](#usercoreconnection) | List of participants for the epic. (see [Connections](#connections)) |
| <a id="boardepicrelationpath"></a>`relationPath` | [`String`](#string) | URI path of the epic-issue relationship. |
| <a id="boardepicrelativeposition"></a>`relativePosition` | [`Int`](#int) | Relative position of the epic in the epic tree. |
| <a id="boardepicstartdate"></a>`startDate` | [`Time`](#time) | Start date of the epic. |
| <a id="boardepicstartdatefixed"></a>`startDateFixed` | [`Time`](#time) | Fixed start date of the epic. |
| <a id="boardepicstartdatefrominheritedsource"></a>`startDateFromInheritedSource` | [`Time`](#time) | Inherited start date of the epic from child epics or milestones. |
| <a id="boardepicstartdatefrommilestones"></a>`startDateFromMilestones` | [`Time`](#time) | Inherited start date of the epic from milestones. |
| <a id="boardepicstartdateisfixed"></a>`startDateIsFixed` | [`Boolean`](#boolean) | Indicates if the start date has been manually set. |
| <a id="boardepicstate"></a>`state` | [`EpicState!`](#epicstate) | State of the epic. |
| <a id="boardepicsubscribed"></a>`subscribed` | [`Boolean!`](#boolean) | Indicates the currently logged in user is subscribed to the epic. |
| <a id="boardepictextcolor"></a>`textColor` | [`String`](#string) | Text color generated for the epic. Returns `null` if `epic_color_highlight` feature flag is disabled. |
| <a id="boardepictitle"></a>`title` | [`String`](#string) | Title of the epic. |
| <a id="boardepictitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="boardepicupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp of when the epic was updated. |
| <a id="boardepicupvotes"></a>`upvotes` | [`Int!`](#int) | Number of upvotes the epic has received. |
| <a id="boardepicuserdiscussionscount"></a>`userDiscussionsCount` | [`Int!`](#int) | Number of user discussions in the epic. |
| <a id="boardepicusernotescount"></a>`userNotesCount` | [`Int!`](#int) | Number of user notes of the epic. |
| <a id="boardepicuserpermissions"></a>`userPermissions` | [`EpicPermissions!`](#epicpermissions) | Permissions for the current user on the resource. |
| <a id="boardepicuserpreferences"></a>`userPreferences` | [`BoardEpicUserPreferences`](#boardepicuserpreferences) | User preferences for the epic on the issue board. |
| <a id="boardepicwebpath"></a>`webPath` | [`String!`](#string) | Web path of the epic. |
| <a id="boardepicweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the epic. |

#### Fields with arguments

##### `BoardEpic.ancestors`

Ancestors (parents) of the epic.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicancestorsauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="boardepicancestorsconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="boardepicancestorscreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="boardepicancestorscreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="boardepicancestorsiid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="boardepicancestorsiidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="boardepicancestorsiids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="boardepicancestorsin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="boardepicancestorsincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include epics from ancestor groups. |
| <a id="boardepicancestorsincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="boardepicancestorslabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="boardepicancestorsmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="boardepicancestorsmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="boardepicancestorsnot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="boardepicancestorsor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in GitLab 15.9. **Status**: Experiment. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="boardepicancestorssearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="boardepicancestorssort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="boardepicancestorsstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="boardepicancestorstimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="boardepicancestorstoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="boardepicancestorsupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="boardepicancestorsupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `BoardEpic.children`

Children (sub-epics) of the epic.

Returns [`EpicConnection`](#epicconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicchildrenauthorusername"></a>`authorUsername` | [`String`](#string) | Filter epics by author. |
| <a id="boardepicchildrenconfidential"></a>`confidential` | [`Boolean`](#boolean) | Filter epics by given confidentiality. |
| <a id="boardepicchildrencreatedafter"></a>`createdAfter` | [`Time`](#time) | Epics created after this date. |
| <a id="boardepicchildrencreatedbefore"></a>`createdBefore` | [`Time`](#time) | Epics created before this date. |
| <a id="boardepicchildreniid"></a>`iid` | [`ID`](#id) | IID of the epic, e.g., "1". |
| <a id="boardepicchildreniidstartswith"></a>`iidStartsWith` | [`String`](#string) | Filter epics by IID for autocomplete. |
| <a id="boardepicchildreniids"></a>`iids` | [`[ID!]`](#id) | List of IIDs of epics, e.g., `[1, 2]`. |
| <a id="boardepicchildrenin"></a>`in` | [`[IssuableSearchableField!]`](#issuablesearchablefield) | Specify the fields to perform the search in. Defaults to `[TITLE, DESCRIPTION]`. Requires the `search` argument.'. |
| <a id="boardepicchildrenincludeancestorgroups"></a>`includeAncestorGroups` | [`Boolean`](#boolean) | Include child epics from ancestor groups. |
| <a id="boardepicchildrenincludedescendantgroups"></a>`includeDescendantGroups` | [`Boolean`](#boolean) | Include epics from descendant groups. |
| <a id="boardepicchildrenlabelname"></a>`labelName` | [`[String!]`](#string) | Filter epics by labels. |
| <a id="boardepicchildrenmilestonetitle"></a>`milestoneTitle` | [`String`](#string) | Filter epics by milestone title, computed from epic's issues. |
| <a id="boardepicchildrenmyreactionemoji"></a>`myReactionEmoji` | [`String`](#string) | Filter by reaction emoji applied by the current user. |
| <a id="boardepicchildrennot"></a>`not` | [`NegatedEpicFilterInput`](#negatedepicfilterinput) | Negated epic arguments. |
| <a id="boardepicchildrenor"></a>`or` **{warning-solid}** | [`UnionedEpicFilterInput`](#unionedepicfilterinput) | **Introduced** in GitLab 15.9. **Status**: Experiment. List of arguments with inclusive OR. Ignored unless `or_issuable_queries` flag is enabled. |
| <a id="boardepicchildrensearch"></a>`search` | [`String`](#string) | Search query for title or description. |
| <a id="boardepicchildrensort"></a>`sort` | [`EpicSort`](#epicsort) | List epics by sort order. |
| <a id="boardepicchildrenstate"></a>`state` | [`EpicState`](#epicstate) | Filter epics by state. |
| <a id="boardepicchildrentimeframe"></a>`timeframe` | [`Timeframe`](#timeframe) | List items overlapping the given timeframe. |
| <a id="boardepicchildrentoplevelhierarchyonly"></a>`topLevelHierarchyOnly` | [`Boolean`](#boolean) | Filter epics with a top-level hierarchy. |
| <a id="boardepicchildrenupdatedafter"></a>`updatedAfter` | [`Time`](#time) | Epics updated after this date. |
| <a id="boardepicchildrenupdatedbefore"></a>`updatedBefore` | [`Time`](#time) | Epics updated before this date. |

##### `BoardEpic.currentUserTodos`

To-do items for the current user.

Returns [`TodoConnection!`](#todoconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepiccurrentusertodosstate"></a>`state` | [`TodoStateEnum`](#todostateenum) | State of the to-do items. |

##### `BoardEpic.notes`

All notes on this noteable.

Returns [`NoteConnection!`](#noteconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicnotesfilter"></a>`filter` | [`NotesFilterType`](#notesfiltertype) | Type of notes collection: ALL_NOTES, ONLY_COMMENTS, ONLY_ACTIVITY. |

##### `BoardEpic.reference`

Internal reference of the epic. Returned in shortened format by default.

Returns [`String!`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicreferencefull"></a>`full` | [`Boolean`](#boolean) | Indicates if the reference should be returned in full. |

### `BoardEpicUserPreferences`

Represents user preferences for a board epic.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardepicuserpreferencescollapsed"></a>`collapsed` | [`Boolean!`](#boolean) | Indicates epic should be displayed as collapsed. |

### `BoardList`

Represents a list for an issue board.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistassignee"></a>`assignee` | [`UserCore`](#usercore) | Assignee in the list. |
| <a id="boardlistcollapsed"></a>`collapsed` | [`Boolean`](#boolean) | Indicates if the list is collapsed for this user. |
| <a id="boardlistid"></a>`id` | [`ID!`](#id) | ID (global ID) of the list. |
| <a id="boardlistissuescount"></a>`issuesCount` | [`Int`](#int) | Count of issues in the list. |
| <a id="boardlistiteration"></a>`iteration` | [`Iteration`](#iteration) | Iteration of the list. |
| <a id="boardlistlabel"></a>`label` | [`Label`](#label) | Label of the list. |
| <a id="boardlistlimitmetric"></a>`limitMetric` | [`ListLimitMetric`](#listlimitmetric) | Current limit metric for the list. |
| <a id="boardlistlisttype"></a>`listType` | [`String!`](#string) | Type of the list. |
| <a id="boardlistmaxissuecount"></a>`maxIssueCount` | [`Int`](#int) | Maximum number of issues in the list. |
| <a id="boardlistmaxissueweight"></a>`maxIssueWeight` | [`Int`](#int) | Maximum weight of issues in the list. |
| <a id="boardlistmilestone"></a>`milestone` | [`Milestone`](#milestone) | Milestone of the list. |
| <a id="boardlistposition"></a>`position` | [`Int`](#int) | Position of list within the board. |
| <a id="boardlisttitle"></a>`title` | [`String!`](#string) | Title of the list. |
| <a id="boardlisttotalissueweight"></a>`totalIssueWeight` | [`BigInt`](#bigint) | Total weight of all issues in the list, encoded as a string. |

#### Fields with arguments

##### `BoardList.issues`

Board issues.

Returns [`IssueConnection`](#issueconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="boardlistissuesfilters"></a>`filters` | [`BoardIssueInput`](#boardissueinput) | Filters applied when selecting issues in the board list. |

### `Branch`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchcommit"></a>`commit` | [`Commit`](#commit) | Commit for the branch. |
| <a id="branchname"></a>`name` | [`String!`](#string) | Name of the branch. |

### `BranchProtection`

Branch protection details for a branch rule.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchprotectionallowforcepush"></a>`allowForcePush` | [`Boolean!`](#boolean) | Toggle force push to the branch for users with write access. |
| <a id="branchprotectioncodeownerapprovalrequired"></a>`codeOwnerApprovalRequired` | [`Boolean!`](#boolean) | Enforce code owner approvals before allowing a merge. |
| <a id="branchprotectionmergeaccesslevels"></a>`mergeAccessLevels` | [`MergeAccessLevelConnection`](#mergeaccesslevelconnection) | Details about who can merge when this branch is the source branch. (see [Connections](#connections)) |
| <a id="branchprotectionpushaccesslevels"></a>`pushAccessLevels` | [`PushAccessLevelConnection`](#pushaccesslevelconnection) | Details about who can push when this branch is the source branch. (see [Connections](#connections)) |
| <a id="branchprotectionunprotectaccesslevels"></a>`unprotectAccessLevels` | [`UnprotectAccessLevelConnection`](#unprotectaccesslevelconnection) | Details about who can unprotect this branch. (see [Connections](#connections)) |

### `BranchRule`

Branch rules configured for a rule target.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="branchruleapprovalrules"></a>`approvalRules` | [`ApprovalProjectRuleConnection`](#approvalprojectruleconnection) | Merge request approval rules configured for this branch rule. (see [Connections](#connections)) |
| <a id="branchrulebranchprotection"></a>`branchProtection` | [`BranchProtection`](#branchprotection) | Branch protections configured for this branch rule. |
| <a id="branchrulecreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of when the branch rule was created. |
| <a id="branchruleexternalstatuschecks"></a>`externalStatusChecks` | [`ExternalStatusCheckConnection`](#externalstatuscheckconnection) | External status checks configured for this branch rule. (see [Connections](#connections)) |
| <a id="branchruleid"></a>`id` | [`ProjectsBranchRuleID`](#projectsbranchruleid) | ID of the branch rule. |
| <a id="branchruleisdefault"></a>`isDefault` | [`Boolean!`](#boolean) | Check if this branch rule protects the project's default branch. |
| <a id="branchruleisprotected"></a>`isProtected` | [`Boolean!`](#boolean) | Check if this branch rule protects access for the branch. |
| <a id="branchrulematchingbranchescount"></a>`matchingBranchesCount` | [`Int!`](#int) | Number of existing branches that match this branch rule. |
| <a id="branchrulename"></a>`name` | [`String!`](#string) | Name of the branch rule target. Includes wildcards. |
| <a id="branchruleupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp of when the branch rule was last updated. |

### `BurnupChartDailyTotals`

Represents the total number of issues and their weights for a particular day.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="burnupchartdailytotalscompletedcount"></a>`completedCount` | [`Int!`](#int) | Number of closed issues as of this day. |
| <a id="burnupchartdailytotalscompletedweight"></a>`completedWeight` | [`Int!`](#int) | Total weight of closed issues as of this day. |
| <a id="burnupchartdailytotalsdate"></a>`date` | [`ISO8601Date!`](#iso8601date) | Date for burnup totals. |
| <a id="burnupchartdailytotalsscopecount"></a>`scopeCount` | [`Int!`](#int) | Number of issues as of this day. |
| <a id="burnupchartdailytotalsscopeweight"></a>`scopeWeight` | [`Int!`](#int) | Total weight of issues as of this day. |

### `CiApplicationSettings`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciapplicationsettingskeeplatestartifact"></a>`keepLatestArtifact` | [`Boolean`](#boolean) | Whether to keep the latest jobs artifacts. |

### `CiBuildNeed`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cibuildneedid"></a>`id` | [`ID!`](#id) | ID of the BuildNeed. |
| <a id="cibuildneedname"></a>`name` | [`String`](#string) | Name of the job we need to complete. |

### `CiCatalogResource`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcedescription"></a>`description` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 15.11. **Status**: Experiment. Description of the catalog resource. |
| <a id="cicatalogresourcefullpath"></a>`fullPath` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.11. **Status**: Experiment. Full project path of the catalog resource. |
| <a id="cicatalogresourceicon"></a>`icon` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 15.11. **Status**: Experiment. Icon for the catalog resource. |
| <a id="cicatalogresourceid"></a>`id` **{warning-solid}** | [`ID!`](#id) | **Introduced** in GitLab 15.11. **Status**: Experiment. ID of the catalog resource. |
| <a id="cicatalogresourcelast30dayusagecount"></a>`last30DayUsageCount` **{warning-solid}** | [`Int!`](#int) | **Introduced** in GitLab 17.0. **Status**: Experiment. Number of projects that used a component from this catalog resource in a pipeline, by using `include:component`, in the last 30 days. |
| <a id="cicatalogresourcelatestreleasedat"></a>`latestReleasedAt` **{warning-solid}** | [`Time`](#time) | **Introduced** in GitLab 16.5. **Status**: Experiment. Release date of the catalog resource's latest version. |
| <a id="cicatalogresourcename"></a>`name` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 15.11. **Status**: Experiment. Name of the catalog resource. |
| <a id="cicatalogresourceopenissuescount"></a>`openIssuesCount` **{warning-solid}** | [`Int!`](#int) | **Introduced** in GitLab 16.3. **Status**: Experiment. Count of open issues that belong to the the catalog resource. |
| <a id="cicatalogresourceopenmergerequestscount"></a>`openMergeRequestsCount` **{warning-solid}** | [`Int!`](#int) | **Introduced** in GitLab 16.3. **Status**: Experiment. Count of open merge requests that belong to the the catalog resource. |
| <a id="cicatalogresourcestarcount"></a>`starCount` **{warning-solid}** | [`Int!`](#int) | **Introduced** in GitLab 16.1. **Status**: Experiment. Number of times the catalog resource has been starred. |
| <a id="cicatalogresourcestarrerspath"></a>`starrersPath` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.10. **Status**: Experiment. Relative path to the starrers page for the catalog resource project. |
| <a id="cicatalogresourceverificationlevel"></a>`verificationLevel` **{warning-solid}** | [`CiCatalogResourceVerificationLevel`](#cicatalogresourceverificationlevel) | **Introduced** in GitLab 16.9. **Status**: Experiment. Verification level of the catalog resource. |
| <a id="cicatalogresourcewebpath"></a>`webPath` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.1. **Status**: Experiment. Web path of the catalog resource. |

#### Fields with arguments

##### `CiCatalogResource.versions`

Versions of the catalog resource. This field can only be resolved for one catalog resource in any single request.

DETAILS:
**Introduced** in GitLab 16.2.
**Status**: Experiment.

Returns [`CiCatalogResourceVersionConnection`](#cicatalogresourceversionconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionsname"></a>`name` | [`String`](#string) | Name of the version. |

### `CiCatalogResourceComponent`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentid"></a>`id` **{warning-solid}** | [`CiCatalogResourcesComponentID!`](#cicatalogresourcescomponentid) | **Introduced** in GitLab 16.7. **Status**: Experiment. ID of the component. |
| <a id="cicatalogresourcecomponentincludepath"></a>`includePath` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.7. **Status**: Experiment. Path used to include the component. |
| <a id="cicatalogresourcecomponentinputs"></a>`inputs` **{warning-solid}** | [`[CiCatalogResourceComponentInput!]`](#cicatalogresourcecomponentinput) | **Introduced** in GitLab 16.7. **Status**: Experiment. Inputs for the component. |
| <a id="cicatalogresourcecomponentname"></a>`name` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.7. **Status**: Experiment. Name of the component. |

### `CiCatalogResourceComponentInput`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourcecomponentinputdefault"></a>`default` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.7. **Status**: Experiment. Default value for the input. |
| <a id="cicatalogresourcecomponentinputname"></a>`name` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.7. **Status**: Experiment. Name of the input. |
| <a id="cicatalogresourcecomponentinputrequired"></a>`required` **{warning-solid}** | [`Boolean`](#boolean) | **Introduced** in GitLab 16.7. **Status**: Experiment. Indicates if an input is required. |

### `CiCatalogResourceVersion`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cicatalogresourceversionauthor"></a>`author` **{warning-solid}** | [`UserCore`](#usercore) | **Introduced** in GitLab 16.7. **Status**: Experiment. User that created the version. |
| <a id="cicatalogresourceversioncommit"></a>`commit` **{warning-solid}** | [`Commit`](#commit) | **Introduced** in GitLab 16.7. **Status**: Experiment. Commit associated with the version. |
| <a id="cicatalogresourceversioncomponents"></a>`components` **{warning-solid}** | [`CiCatalogResourceComponentConnection`](#cicatalogresourcecomponentconnection) | **Introduced** in GitLab 16.7. **Status**: Experiment. Components belonging to the catalog resource. |
| <a id="cicatalogresourceversioncreatedat"></a>`createdAt` **{warning-solid}** | [`Time`](#time) | **Introduced** in GitLab 16.7. **Status**: Experiment. Timestamp of when the version was created. |
| <a id="cicatalogresourceversionid"></a>`id` **{warning-solid}** | [`CiCatalogResourcesVersionID!`](#cicatalogresourcesversionid) | **Introduced** in GitLab 16.7. **Status**: Experiment. Global ID of the version. |
| <a id="cicatalogresourceversionname"></a>`name` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.8. **Status**: Experiment. Name that uniquely identifies the version within the catalog resource. |
| <a id="cicatalogresourceversionpath"></a>`path` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.8. **Status**: Experiment. Relative web path to the version. |
| <a id="cicatalogresourceversionreadmehtml"></a>`readmeHtml` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.8. **Status**: Experiment. GitLab Flavored Markdown rendering of README.md. This field can only be resolved for one version in any single request. |
| <a id="cicatalogresourceversionreleasedat"></a>`releasedAt` **{warning-solid}** | [`Time`](#time) | **Introduced** in GitLab 16.7. **Status**: Experiment. Timestamp of when the version was released. |

### `CiConfig`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigerrors"></a>`errors` | [`[String!]`](#string) | Linting errors. |
| <a id="ciconfigincludes"></a>`includes` | [`[CiConfigInclude!]`](#ciconfiginclude) | List of included files. |
| <a id="ciconfigmergedyaml"></a>`mergedYaml` | [`String`](#string) | Merged CI configuration YAML. |
| <a id="ciconfigstages"></a>`stages` | [`CiConfigStageConnection`](#ciconfigstageconnection) | Stages of the pipeline. (see [Connections](#connections)) |
| <a id="ciconfigstatus"></a>`status` | [`CiConfigStatus`](#ciconfigstatus) | Status of linting, can be either valid or invalid. |
| <a id="ciconfigwarnings"></a>`warnings` | [`[String!]`](#string) | Linting warnings. |

### `CiConfigGroup`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfiggroupjobs"></a>`jobs` | [`CiConfigJobConnection`](#ciconfigjobconnection) | Jobs in group. (see [Connections](#connections)) |
| <a id="ciconfiggroupname"></a>`name` | [`String`](#string) | Name of the job group. |
| <a id="ciconfiggroupsize"></a>`size` | [`Int`](#int) | Size of the job group. |

### `CiConfigInclude`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigincludeblob"></a>`blob` | [`String`](#string) | File blob location. It can be masked if it contains masked variables. For example, `"https://gitlab.com/gitlab-org/gitlab/-/blob/e52d6d0246d7375291850e61f0abc101fbda9dc2/.gitlab/ci/build-images.gitlab-ci.yml"`. |
| <a id="ciconfigincludecontextproject"></a>`contextProject` | [`String`](#string) | Current project scope, e.g., "gitlab-org/gitlab". |
| <a id="ciconfigincludecontextsha"></a>`contextSha` | [`String`](#string) | Current sha scope. |
| <a id="ciconfigincludeextra"></a>`extra` | [`JSON`](#json) | Extra information for the `include`, which can contain `job_name`, `project`, and `ref`. Values can be masked if they contain masked variables. |
| <a id="ciconfigincludelocation"></a>`location` | [`String`](#string) | File location. It can be masked if it contains masked variables. For example, `".gitlab/ci/build-images.gitlab-ci.yml"`. |
| <a id="ciconfigincluderaw"></a>`raw` | [`String`](#string) | File raw location. It can be masked if it contains masked variables. For example, `"https://gitlab.com/gitlab-org/gitlab/-/raw/e52d6d0246d7375291850e61f0abc101fbda9dc2/.gitlab/ci/build-images.gitlab-ci.yml"`. |
| <a id="ciconfigincludetype"></a>`type` | [`CiConfigIncludeType`](#ciconfigincludetype) | Include type. |

### `CiConfigJob`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobafterscript"></a>`afterScript` | [`[String!]`](#string) | Override a set of commands that are executed after the job. |
| <a id="ciconfigjoballowfailure"></a>`allowFailure` | [`Boolean`](#boolean) | Allow job to fail. |
| <a id="ciconfigjobbeforescript"></a>`beforeScript` | [`[String!]`](#string) | Override a set of commands that are executed before the job. |
| <a id="ciconfigjobenvironment"></a>`environment` | [`String`](#string) | Name of an environment to which the job deploys. |
| <a id="ciconfigjobexcept"></a>`except` | [`CiConfigJobRestriction`](#ciconfigjobrestriction) | Limit when jobs are not created. |
| <a id="ciconfigjobgroupname"></a>`groupName` | [`String`](#string) | Name of the job group. |
| <a id="ciconfigjobname"></a>`name` | [`String`](#string) | Name of the job. |
| <a id="ciconfigjobneeds"></a>`needs` | [`CiConfigNeedConnection`](#ciconfigneedconnection) | Builds that must complete before the jobs run. (see [Connections](#connections)) |
| <a id="ciconfigjobonly"></a>`only` | [`CiConfigJobRestriction`](#ciconfigjobrestriction) | Jobs are created when these conditions do not apply. |
| <a id="ciconfigjobscript"></a>`script` | [`[String!]`](#string) | Shell script that is executed by a runner. |
| <a id="ciconfigjobstage"></a>`stage` | [`String`](#string) | Name of the job stage. |
| <a id="ciconfigjobtags"></a>`tags` | [`[String!]`](#string) | List of tags that are used to select a runner. |
| <a id="ciconfigjobwhen"></a>`when` | [`String`](#string) | When to run the job. |

### `CiConfigJobRestriction`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigjobrestrictionrefs"></a>`refs` | [`[String!]`](#string) | Git refs the job restriction applies to. |

### `CiConfigNeed`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigneedname"></a>`name` | [`String`](#string) | Name of the need. |

### `CiConfigStage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigstagegroups"></a>`groups` | [`CiConfigGroupConnection`](#ciconfiggroupconnection) | Groups of jobs for the stage. (see [Connections](#connections)) |
| <a id="ciconfigstagename"></a>`name` | [`String`](#string) | Name of the stage. |

### `CiConfigVariable`

CI/CD config variables.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciconfigvariabledescription"></a>`description` | [`String`](#string) | Description for the CI/CD config variable. |
| <a id="ciconfigvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="ciconfigvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="ciconfigvariablevalueoptions"></a>`valueOptions` | [`[String!]`](#string) | Value options for the variable. |

### `CiFreezePeriod`

Represents a deployment freeze window of a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cifreezeperiodcrontimezone"></a>`cronTimezone` | [`String`](#string) | Time zone for the cron fields, defaults to UTC if not provided. |
| <a id="cifreezeperiodendcron"></a>`endCron` | [`String!`](#string) | End of the freeze period in cron format. |
| <a id="cifreezeperiodendtime"></a>`endTime` | [`Time`](#time) | Timestamp (UTC) of when the current/next active period ends. |
| <a id="cifreezeperiodstartcron"></a>`startCron` | [`String!`](#string) | Start of the freeze period in cron format. |
| <a id="cifreezeperiodstarttime"></a>`startTime` | [`Time`](#time) | Timestamp (UTC) of when the current/next active period starts. |
| <a id="cifreezeperiodstatus"></a>`status` | [`CiFreezePeriodStatus!`](#cifreezeperiodstatus) | Freeze period status. |

### `CiGroup`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupdetailedstatus"></a>`detailedStatus` | [`DetailedStatus`](#detailedstatus) | Detailed status of the group. |
| <a id="cigroupid"></a>`id` | [`String!`](#string) | ID for a group. |
| <a id="cigroupjobs"></a>`jobs` | [`CiJobConnection`](#cijobconnection) | Jobs in group. (see [Connections](#connections)) |
| <a id="cigroupname"></a>`name` | [`String`](#string) | Name of the job group. |
| <a id="cigroupsize"></a>`size` | [`Int`](#int) | Size of the group. |

### `CiGroupEnvironmentScope`

Ci/CD environment scope for a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupenvironmentscopename"></a>`name` | [`String`](#string) | Scope name defininig the enviromnments that can use the variable. |

### `CiGroupVariable`

CI/CD variables for a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cigroupvariabledescription"></a>`description` | [`String`](#string) | Description of the variable. |
| <a id="cigroupvariableenvironmentscope"></a>`environmentScope` | [`String`](#string) | Scope defining the environments that can use the variable. |
| <a id="cigroupvariablehidden"></a>`hidden` | [`Boolean`](#boolean) | Indicates whether the variable is hidden. |
| <a id="cigroupvariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="cigroupvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="cigroupvariablemasked"></a>`masked` | [`Boolean`](#boolean) | Indicates whether the variable is masked. |
| <a id="cigroupvariableprotected"></a>`protected` | [`Boolean`](#boolean) | Indicates whether the variable is protected. |
| <a id="cigroupvariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="cigroupvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="cigroupvariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiInstanceVariable`

CI/CD variables for a GitLab instance.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciinstancevariabledescription"></a>`description` | [`String`](#string) | Description of the variable. |
| <a id="ciinstancevariableenvironmentscope"></a>`environmentScope` **{warning-solid}** | [`String`](#string) | **Deprecated** in GitLab 15.3. No longer used, only available for GroupVariableType and ProjectVariableType. |
| <a id="ciinstancevariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="ciinstancevariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="ciinstancevariablemasked"></a>`masked` | [`Boolean`](#boolean) | Indicates whether the variable is masked. |
| <a id="ciinstancevariableprotected"></a>`protected` | [`Boolean`](#boolean) | Indicates whether the variable is protected. |
| <a id="ciinstancevariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="ciinstancevariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="ciinstancevariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiJob`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobactive"></a>`active` | [`Boolean!`](#boolean) | Indicates the job is active. |
| <a id="cijobaifailureanalysis"></a>`aiFailureAnalysis` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 16.1. **Status**: Experiment. Ai generated analysis of the root cause of failure. |
| <a id="cijoballowfailure"></a>`allowFailure` | [`Boolean!`](#boolean) | Whether the job is allowed to fail. |
| <a id="cijobartifacts"></a>`artifacts` | [`CiJobArtifactConnection`](#cijobartifactconnection) | Artifacts generated by the job. (see [Connections](#connections)) |
| <a id="cijobbrowseartifactspath"></a>`browseArtifactsPath` | [`String`](#string) | URL for browsing the artifact's archive. |
| <a id="cijobcanplayjob"></a>`canPlayJob` | [`Boolean!`](#boolean) | Indicates whether the current user can play the job. |
| <a id="cijobcancelable"></a>`cancelable` | [`Boolean!`](#boolean) | Indicates the job can be canceled. |
| <a id="cijobcommitpath"></a>`commitPath` | [`String`](#string) | Path to the commit that triggered the job. |
| <a id="cijobcoverage"></a>`coverage` | [`Float`](#float) | Coverage level of the job. |
| <a id="cijobcreatedat"></a>`createdAt` | [`Time!`](#time) | When the job was created. |
| <a id="cijobcreatedbytag"></a>`createdByTag` | [`Boolean!`](#boolean) | Whether the job was created by a tag. |
| <a id="cijobdetailedstatus"></a>`detailedStatus` | [`DetailedStatus`](#detailedstatus) | Detailed status of the job. |
| <a id="cijobdownstreampipeline"></a>`downstreamPipeline` | [`Pipeline`](#pipeline) | Downstream pipeline for a bridge. |
| <a id="cijobduration"></a>`duration` | [`Int`](#int) | Duration of the job in seconds. |
| <a id="cijoberasedat"></a>`erasedAt` | [`Time`](#time) | When the job was erased. |
| <a id="cijobfailuremessage"></a>`failureMessage` | [`String`](#string) | Message on why the job failed. |
| <a id="cijobfinishedat"></a>`finishedAt` | [`Time`](#time) | When a job has finished running. |
| <a id="cijobid"></a>`id` | [`JobID`](#jobid) | ID of the job. |
| <a id="cijobkind"></a>`kind` | [`CiJobKind!`](#cijobkind) | Indicates the type of job. |
| <a id="cijobmanualjob"></a>`manualJob` | [`Boolean`](#boolean) | Whether the job has a manual action. |
| <a id="cijobmanualvariables"></a>`manualVariables` | [`CiManualVariableConnection`](#cimanualvariableconnection) | Variables added to a manual job when the job is triggered. (see [Connections](#connections)) |
| <a id="cijobname"></a>`name` | [`String`](#string) | Name of the job. |
| <a id="cijobneeds"></a>`needs` | [`CiBuildNeedConnection`](#cibuildneedconnection) | References to builds that must complete before the jobs run. (see [Connections](#connections)) |
| <a id="cijobpipeline"></a>`pipeline` | [`Pipeline`](#pipeline) | Pipeline the job belongs to. |
| <a id="cijobplaypath"></a>`playPath` | [`String`](#string) | Play path of the job. |
| <a id="cijobplayable"></a>`playable` | [`Boolean!`](#boolean) | Indicates the job can be played. |
| <a id="cijobpreviousstagejobs"></a>`previousStageJobs` | [`CiJobConnection`](#cijobconnection) | Jobs from the previous stage. (see [Connections](#connections)) |
| <a id="cijobpreviousstagejobsorneeds"></a>`previousStageJobsOrNeeds` **{warning-solid}** | [`JobNeedUnionConnection`](#jobneedunionconnection) | **Deprecated** in GitLab 16.4. Replaced by previousStageJobs and needs fields. |
| <a id="cijobproject"></a>`project` | [`Project`](#project) | Project that the job belongs to. |
| <a id="cijobqueuedat"></a>`queuedAt` | [`Time`](#time) | When the job was enqueued and marked as pending. |
| <a id="cijobqueuedduration"></a>`queuedDuration` | [`Duration`](#duration) | How long the job was enqueued before starting. |
| <a id="cijobrefname"></a>`refName` | [`String`](#string) | Ref name of the job. |
| <a id="cijobrefpath"></a>`refPath` | [`String`](#string) | Path to the ref. |
| <a id="cijobretried"></a>`retried` | [`Boolean`](#boolean) | Indicates that the job has been retried. |
| <a id="cijobretryable"></a>`retryable` | [`Boolean!`](#boolean) | Indicates the job can be retried. |
| <a id="cijobrunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner assigned to execute the job. |
| <a id="cijobrunnermanager"></a>`runnerManager` **{warning-solid}** | [`CiRunnerManager`](#cirunnermanager) | **Introduced** in GitLab 15.11. **Status**: Experiment. Runner manager assigned to the job. |
| <a id="cijobscheduled"></a>`scheduled` | [`Boolean!`](#boolean) | Indicates the job is scheduled. |
| <a id="cijobscheduledat"></a>`scheduledAt` | [`Time`](#time) | Schedule for the build. |
| <a id="cijobschedulingtype"></a>`schedulingType` | [`String`](#string) | Type of job scheduling. Value is `dag` if the job uses the `needs` keyword, and `stage` otherwise. |
| <a id="cijobshortsha"></a>`shortSha` | [`String!`](#string) | Short SHA1 ID of the commit. |
| <a id="cijobstage"></a>`stage` | [`CiStage`](#cistage) | Stage of the job. |
| <a id="cijobstartedat"></a>`startedAt` | [`Time`](#time) | When the job was started. |
| <a id="cijobstatus"></a>`status` | [`CiJobStatus`](#cijobstatus) | Status of the job. |
| <a id="cijobstuck"></a>`stuck` | [`Boolean!`](#boolean) | Indicates the job is stuck. |
| <a id="cijobtags"></a>`tags` | [`[String!]`](#string) | Tags for the current job. |
| <a id="cijobtrace"></a>`trace` | [`CiJobTrace`](#cijobtrace) | Trace generated by the job. |
| <a id="cijobtriggered"></a>`triggered` | [`Boolean`](#boolean) | Whether the job was triggered. |
| <a id="cijobuserpermissions"></a>`userPermissions` | [`JobPermissions!`](#jobpermissions) | Permissions for the current user on the resource. |
| <a id="cijobwebpath"></a>`webPath` | [`String`](#string) | Web path of the job. |

### `CiJobArtifact`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobartifactdownloadpath"></a>`downloadPath` | [`String`](#string) | URL for downloading the artifact's file. |
| <a id="cijobartifactexpireat"></a>`expireAt` | [`Time`](#time) | Expiry date of the artifact. |
| <a id="cijobartifactfiletype"></a>`fileType` | [`JobArtifactFileType`](#jobartifactfiletype) | File type of the artifact. |
| <a id="cijobartifactid"></a>`id` | [`CiJobArtifactID!`](#cijobartifactid) | ID of the artifact. |
| <a id="cijobartifactname"></a>`name` | [`String`](#string) | File name of the artifact. |
| <a id="cijobartifactsize"></a>`size` | [`BigInt!`](#bigint) | Size of the artifact in bytes. |

### `CiJobTokenScopeType`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtokenscopetypegroupsallowlist"></a>`groupsAllowlist` | [`GroupConnection!`](#groupconnection) | Allowlist of groups that can access the current project by authenticating with a CI/CD job token. (see [Connections](#connections)) |
| <a id="cijobtokenscopetypegroupsallowlistcount"></a>`groupsAllowlistCount` | [`Int!`](#int) | Count of groups that can access the current project by authenticating with a CI/CD job token. The count does not include subgroups. |
| <a id="cijobtokenscopetypeinboundallowlist"></a>`inboundAllowlist` | [`ProjectConnection!`](#projectconnection) | Allowlist of projects that can access the current project by authenticating with a CI/CD job token. (see [Connections](#connections)) |
| <a id="cijobtokenscopetypeinboundallowlistcount"></a>`inboundAllowlistCount` | [`Int!`](#int) | Count of projects that can access the current project by authenticating with a CI/CD job token. The count does not include nested projects. |
| <a id="cijobtokenscopetypeoutboundallowlist"></a>`outboundAllowlist` | [`ProjectConnection!`](#projectconnection) | Allow list of projects that are accessible using the current project's CI Job tokens. (see [Connections](#connections)) |
| <a id="cijobtokenscopetypeprojects"></a>`projects` **{warning-solid}** | [`ProjectConnection!`](#projectconnection) | **Deprecated** in GitLab 15.9. The `projects` attribute is being deprecated. Use `outbound_allowlist`. |

### `CiJobTrace`

#### Fields with arguments

##### `CiJobTrace.htmlSummary`

HTML summary that contains the tail lines of the trace. Returns at most 16KB of raw bytes from the trace. The returned string might start with an unexpected invalid UTF-8 code point due to truncation.

DETAILS:
**Introduced** in GitLab 15.11.
**Status**: Experiment.

Returns [`String!`](#string).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobtracehtmlsummarylastlines"></a>`lastLines` | [`Int`](#int) | Number of tail lines to return, up to a maximum of 100 lines. |

### `CiJobsDurationStatistics`

Representation of duration statistics for a group of CI jobs.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobsdurationstatisticsp50"></a>`p50` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in GitLab 15.8. **Status**: Experiment. 50th percentile. 50% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp75"></a>`p75` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in GitLab 15.8. **Status**: Experiment. 75th percentile. 75% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp90"></a>`p90` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in GitLab 15.8. **Status**: Experiment. 90th percentile. 90% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp95"></a>`p95` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in GitLab 15.8. **Status**: Experiment. 95th percentile. 95% of the durations are lower than this value. |
| <a id="cijobsdurationstatisticsp99"></a>`p99` **{warning-solid}** | [`Duration`](#duration) | **Introduced** in GitLab 15.8. **Status**: Experiment. 99th percentile. 99% of the durations are lower than this value. |

### `CiJobsStatistics`

Statistics for a group of CI jobs.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cijobsstatisticsqueuedduration"></a>`queuedDuration` | [`CiJobsDurationStatistics`](#cijobsdurationstatistics) | Statistics for amount of time that jobs were waiting to be picked up. The calculation is performed based on the most recent 100 jobs executed by the 5000 most recently created runners in context. If no filter is applied to runners, the calculation is performed based on the most recent 100 jobs globally. |

### `CiManualVariable`

CI/CD variables given to a manual job.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cimanualvariableenvironmentscope"></a>`environmentScope` **{warning-solid}** | [`String`](#string) | **Deprecated** in GitLab 15.3. No longer used, only available for GroupVariableType and ProjectVariableType. |
| <a id="cimanualvariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="cimanualvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="cimanualvariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="cimanualvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="cimanualvariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiMinutesNamespaceMonthlyUsage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesnamespacemonthlyusageminutes"></a>`minutes` | [`Int`](#int) | Total number of compute minutes used by all projects in the namespace. |
| <a id="ciminutesnamespacemonthlyusagemonth"></a>`month` | [`String`](#string) | Month related to the usage data. |
| <a id="ciminutesnamespacemonthlyusagemonthiso8601"></a>`monthIso8601` | [`ISO8601Date`](#iso8601date) | Month related to the usage data in ISO 8601 date format. |
| <a id="ciminutesnamespacemonthlyusageprojects"></a>`projects` | [`CiMinutesProjectMonthlyUsageConnection`](#ciminutesprojectmonthlyusageconnection) | Compute usage data for projects in the namespace. (see [Connections](#connections)) |
| <a id="ciminutesnamespacemonthlyusagesharedrunnersduration"></a>`sharedRunnersDuration` | [`Int`](#int) | Total duration (in seconds) of shared runners use by the namespace for the month. |

### `CiMinutesProjectMonthlyUsage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciminutesprojectmonthlyusageminutes"></a>`minutes` | [`Int`](#int) | Number of compute minutes used by the project in the month. |
| <a id="ciminutesprojectmonthlyusagename"></a>`name` **{warning-solid}** | [`String`](#string) | **Deprecated** in GitLab 15.6. Use `project.name`. |
| <a id="ciminutesprojectmonthlyusageproject"></a>`project` | [`Project`](#project) | Project having the recorded usage. |
| <a id="ciminutesprojectmonthlyusagesharedrunnersduration"></a>`sharedRunnersDuration` | [`Int`](#int) | Total duration (in seconds) of shared runners use by the project for the month. |

### `CiProjectVariable`

CI/CD variables for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="ciprojectvariabledescription"></a>`description` | [`String`](#string) | Description of the variable. |
| <a id="ciprojectvariableenvironmentscope"></a>`environmentScope` | [`String`](#string) | Scope defining the environments that can use the variable. |
| <a id="ciprojectvariablehidden"></a>`hidden` | [`Boolean`](#boolean) | Indicates whether the variable is hidden. |
| <a id="ciprojectvariableid"></a>`id` | [`ID!`](#id) | ID of the variable. |
| <a id="ciprojectvariablekey"></a>`key` | [`String`](#string) | Name of the variable. |
| <a id="ciprojectvariablemasked"></a>`masked` | [`Boolean`](#boolean) | Indicates whether the variable is masked. |
| <a id="ciprojectvariableprotected"></a>`protected` | [`Boolean`](#boolean) | Indicates whether the variable is protected. |
| <a id="ciprojectvariableraw"></a>`raw` | [`Boolean`](#boolean) | Indicates whether the variable is raw. |
| <a id="ciprojectvariablevalue"></a>`value` | [`String`](#string) | Value of the variable. |
| <a id="ciprojectvariablevariabletype"></a>`variableType` | [`CiVariableType`](#civariabletype) | Type of the variable. |

### `CiRunner`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunneraccesslevel"></a>`accessLevel` | [`CiRunnerAccessLevel!`](#cirunneraccesslevel) | Access level of the runner. |
| <a id="cirunneractive"></a>`active` **{warning-solid}** | [`Boolean!`](#boolean) | **Deprecated** in GitLab 14.8. Use paused. |
| <a id="cirunneradminurl"></a>`adminUrl` | [`String`](#string) | Admin URL of the runner. Only available for administrators. |
| <a id="cirunnercontactedat"></a>`contactedAt` | [`Time`](#time) | Timestamp of last contact from this runner. |
| <a id="cirunnercreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of creation of this runner. |
| <a id="cirunnercreatedby"></a>`createdBy` | [`UserCore`](#usercore) | User that created this runner. |
| <a id="cirunnerdescription"></a>`description` | [`String`](#string) | Description of the runner. |
| <a id="cirunnereditadminurl"></a>`editAdminUrl` | [`String`](#string) | Admin form URL of the runner. Only available for administrators. |
| <a id="cirunnerephemeralauthenticationtoken"></a>`ephemeralAuthenticationToken` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 15.9. **Status**: Experiment. Ephemeral authentication token used for runner manager registration. Only available for the creator of the runner for a limited time during registration. |
| <a id="cirunnerephemeralregisterurl"></a>`ephemeralRegisterUrl` **{warning-solid}** | [`String`](#string) | **Introduced** in GitLab 15.11. **Status**: Experiment. URL of the registration page of the runner manager. Only available for the creator of the runner for a limited time during registration. |
| <a id="cirunnergroups"></a>`groups` | [`GroupConnection`](#groupconnection) | Groups the runner is associated with. For group runners only. (see [Connections](#connections)) |
| <a id="cirunnerid"></a>`id` | [`CiRunnerID!`](#cirunnerid) | ID of the runner. |
| <a id="cirunnerjobexecutionstatus"></a>`jobExecutionStatus` **{warning-solid}** | [`CiRunnerJobExecutionStatus`](#cirunnerjobexecutionstatus) | **Introduced** in GitLab 15.7. **Status**: Experiment. Job execution status of the runner. |
| <a id="cirunnerlocked"></a>`locked` | [`Boolean`](#boolean) | Indicates the runner is locked. |
| <a id="cirunnermaintenancenote"></a>`maintenanceNote` | [`String`](#string) | Runner's maintenance notes. |
| <a id="cirunnermaintenancenotehtml"></a>`maintenanceNoteHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `maintenance_note`. |
| <a id="cirunnermaximumtimeout"></a>`maximumTimeout` | [`Int`](#int) | Maximum timeout (in seconds) for jobs processed by the runner. |
| <a id="cirunnerownerproject"></a>`ownerProject` | [`Project`](#project) | Project that owns the runner. For project runners only. |
| <a id="cirunnerpaused"></a>`paused` | [`Boolean!`](#boolean) | Indicates the runner is paused and not available to run jobs. |
| <a id="cirunnerprivateprojectsminutescostfactor"></a>`privateProjectsMinutesCostFactor` | [`Float`](#float) | Private projects' "compute cost factor" associated with the runner (GitLab.com only). |
| <a id="cirunnerprojectcount"></a>`projectCount` | [`Int`](#int) | Number of projects that the runner is associated with. |
| <a id="cirunnerpublicprojectsminutescostfactor"></a>`publicProjectsMinutesCostFactor` | [`Float`](#float) | Public projects' "compute cost factor" associated with the runner (GitLab.com only). |
| <a id="cirunnerregisteradminurl"></a>`registerAdminUrl` | [`String`](#string) | URL of the temporary registration page of the runner. Only available before the runner is registered. Only available for administrators. |
| <a id="cirunnerrununtagged"></a>`runUntagged` | [`Boolean!`](#boolean) | Indicates the runner is able to run untagged jobs. |
| <a id="cirunnerrunnertype"></a>`runnerType` | [`CiRunnerType!`](#cirunnertype) | Type of the runner. |
| <a id="cirunnershortsha"></a>`shortSha` | [`String`](#string) | First eight characters of the runner's token used to authenticate new job requests. Used as the runner's unique ID. |
| <a id="cirunnerstatus"></a>`status` | [`CiRunnerStatus!`](#cirunnerstatus) | Status of the runner. |
| <a id="cirunnertaglist"></a>`tagList` | [`[String!]`](#string) | Tags associated with the runner. |
| <a id="cirunnertokenexpiresat"></a>`tokenExpiresAt` | [`Time`](#time) | Runner token expiration time. |
| <a id="cirunnerupgradestatus"></a>`upgradeStatus` **{warning-solid}** | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | **Introduced** in GitLab 14.10. **Status**: Experiment. Availability of upgrades for the runner. |
| <a id="cirunneruserpermissions"></a>`userPermissions` | [`RunnerPermissions!`](#runnerpermissions) | Permissions for the current user on the resource. |

#### Fields with arguments

##### `CiRunner.jobCount`

Number of jobs processed by the runner (limited to 1000, plus one to indicate that more items exist).
`jobCount` is an optimized version of `jobs { count }`, and can be requested for multiple runners on the same request.

Returns [`Int`](#int).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerjobcountstatuses"></a>`statuses` **{warning-solid}** | [`[CiJobStatus!]`](#cijobstatus) | **Introduced** in GitLab 16.2. **Status**: Experiment. Filter jobs by status. |

##### `CiRunner.jobs`

Jobs assigned to the runner. This field can only be resolved for one runner in any single request.

Returns [`CiJobConnection`](#cijobconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerjobsstatuses"></a>`statuses` | [`[CiJobStatus!]`](#cijobstatus) | Filter jobs by status. |

##### `CiRunner.managers`

Runner managers associated with the runner configuration.

DETAILS:
**Introduced** in GitLab 15.10.
**Status**: Experiment.

Returns [`CiRunnerManagerConnection`](#cirunnermanagerconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanagersstatus"></a>`status` | [`CiRunnerStatus`](#cirunnerstatus) | Filter runner managers by status. |
| <a id="cirunnermanagerssystemid"></a>`systemId` | [`String`](#string) | Filter runner managers by system ID. |

##### `CiRunner.projects`

Find projects the runner is associated with. For project runners only.

Returns [`ProjectConnection`](#projectconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerprojectsmembership"></a>`membership` | [`Boolean`](#boolean) | Return only projects that the current user is a member of. |
| <a id="cirunnerprojectspersonal"></a>`personal` | [`Boolean`](#boolean) | Return only personal projects. |
| <a id="cirunnerprojectssearch"></a>`search` | [`String`](#string) | Search query, which can be for the project name, a path, or a description. |
| <a id="cirunnerprojectssearchnamespaces"></a>`searchNamespaces` | [`Boolean`](#boolean) | Include namespace in project search. |
| <a id="cirunnerprojectssort"></a>`sort` | [`String`](#string) | Sort order of results. Format: `<field_name>_<sort_direction>`, for example: `id_desc` or `name_asc`. |
| <a id="cirunnerprojectstopics"></a>`topics` | [`[String!]`](#string) | Filter projects by topics. |

### `CiRunnerCloudProvisioningStep`

Step used to provision the runner to Google Cloud.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnercloudprovisioningstepinstructions"></a>`instructions` | [`String`](#string) | Instructions to provision the runner. |
| <a id="cirunnercloudprovisioningsteplanguageidentifier"></a>`languageIdentifier` | [`String`](#string) | Identifier of the language used for the instructions field. This identifier can be any of the identifiers specified in the [list of supported languages and lexers](https://github.com/rouge-ruby/rouge/wiki/List-of-supported-languages-and-lexers). |
| <a id="cirunnercloudprovisioningsteptitle"></a>`title` | [`String`](#string) | Title of the step. |

### `CiRunnerGoogleCloudProvisioning`

Information used for runner Google Cloud provisioning.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnergooglecloudprovisioningprojectsetupshellscript"></a>`projectSetupShellScript` | [`String`](#string) | Instructions for setting up a Google Cloud project. |

#### Fields with arguments

##### `CiRunnerGoogleCloudProvisioning.provisioningSteps`

Steps used to provision a runner in the cloud.

Returns [`[CiRunnerCloudProvisioningStep!]`](#cirunnercloudprovisioningstep).

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnergooglecloudprovisioningprovisioningstepsephemeralmachinetype"></a>`ephemeralMachineType` | [`GoogleCloudMachineType!`](#googlecloudmachinetype) | Name of the machine type to use for running jobs. |
| <a id="cirunnergooglecloudprovisioningprovisioningstepsregion"></a>`region` | [`GoogleCloudRegion!`](#googlecloudregion) | Name of the region to provision the runner in. |
| <a id="cirunnergooglecloudprovisioningprovisioningstepsrunnertoken"></a>`runnerToken` | [`String`](#string) | Authentication token of the runner. |
| <a id="cirunnergooglecloudprovisioningprovisioningstepszone"></a>`zone` | [`GoogleCloudZone!`](#googlecloudzone) | Name of the zone to provision the runner in. |

### `CiRunnerManager`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnermanagerarchitecturename"></a>`architectureName` | [`String`](#string) | Architecture provided by the runner manager. |
| <a id="cirunnermanagercontactedat"></a>`contactedAt` | [`Time`](#time) | Timestamp of last contact from the runner manager. |
| <a id="cirunnermanagercreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp of creation of the runner manager. |
| <a id="cirunnermanagerexecutorname"></a>`executorName` | [`String`](#string) | Executor last advertised by the runner. |
| <a id="cirunnermanagerid"></a>`id` | [`CiRunnerManagerID!`](#cirunnermanagerid) | ID of the runner manager. |
| <a id="cirunnermanageripaddress"></a>`ipAddress` | [`String`](#string) | IP address of the runner manager. |
| <a id="cirunnermanagerjobexecutionstatus"></a>`jobExecutionStatus` **{warning-solid}** | [`CiRunnerJobExecutionStatus`](#cirunnerjobexecutionstatus) | **Introduced** in GitLab 16.3. **Status**: Experiment. Job execution status of the runner manager. |
| <a id="cirunnermanagerplatformname"></a>`platformName` | [`String`](#string) | Platform provided by the runner manager. |
| <a id="cirunnermanagerrevision"></a>`revision` | [`String`](#string) | Revision of the runner. |
| <a id="cirunnermanagerrunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner configuration for the runner manager. |
| <a id="cirunnermanagerstatus"></a>`status` | [`CiRunnerStatus!`](#cirunnerstatus) | Status of the runner manager. |
| <a id="cirunnermanagersystemid"></a>`systemId` | [`String!`](#string) | System ID associated with the runner manager. |
| <a id="cirunnermanagerupgradestatus"></a>`upgradeStatus` | [`CiRunnerUpgradeStatus`](#cirunnerupgradestatus) | Availability of upgrades for the runner manager. |
| <a id="cirunnermanagerversion"></a>`version` | [`String`](#string) | Version of the runner. |

### `CiRunnerUsage`

Runner usage.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerusagecibuildcount"></a>`ciBuildCount` | [`Int!`](#int) | Amount of builds executed during the selected period. |
| <a id="cirunnerusageciminutesused"></a>`ciMinutesUsed` | [`Int!`](#int) | Amount of minutes used during the selected period. |
| <a id="cirunnerusagerunner"></a>`runner` | [`CiRunner`](#cirunner) | Runner that the usage refers to. Null means "Other runners". |

### `CiRunnerUsageByProject`

Runner usage in minutes by project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cirunnerusagebyprojectcibuildcount"></a>`ciBuildCount` | [`Int!`](#int) | Amount of builds executed during the selected period. |
| <a id="cirunnerusagebyprojectciminutesused"></a>`ciMinutesUsed` | [`Int!`](#int) | Amount of minutes used during the selected period. |
| <a id="cirunnerusagebyprojectproject"></a>`project` | [`Project`](#project) | Project that the usage refers to. Null means "Other projects". |

### `CiSecureFileRegistry`

Represents the Geo replication and verification state of a ci_secure_file.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisecurefileregistrycisecurefileid"></a>`ciSecureFileId` | [`ID!`](#id) | ID of the Ci Secure File. |
| <a id="cisecurefileregistrycreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp when the CiSecureFileRegistry was created. |
| <a id="cisecurefileregistryid"></a>`id` | [`ID!`](#id) | ID of the CiSecureFileRegistry. |
| <a id="cisecurefileregistrylastsyncfailure"></a>`lastSyncFailure` | [`String`](#string) | Error message during sync of the CiSecureFileRegistry. |
| <a id="cisecurefileregistrylastsyncedat"></a>`lastSyncedAt` | [`Time`](#time) | Timestamp of the most recent successful sync of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryretryat"></a>`retryAt` | [`Time`](#time) | Timestamp after which the CiSecureFileRegistry is resynced. |
| <a id="cisecurefileregistryretrycount"></a>`retryCount` | [`Int`](#int) | Number of consecutive failed sync attempts of the CiSecureFileRegistry. |
| <a id="cisecurefileregistrystate"></a>`state` | [`RegistryState`](#registrystate) | Sync state of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryverificationchecksum"></a>`verificationChecksum` | [`String`](#string) | The local checksum of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryverificationfailure"></a>`verificationFailure` | [`String`](#string) | Error message during verification of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryverificationretryat"></a>`verificationRetryAt` | [`Time`](#time) | Timestamp after which the CiSecureFileRegistry is reverified. |
| <a id="cisecurefileregistryverificationretrycount"></a>`verificationRetryCount` | [`Int`](#int) | Number of consecutive failed verification attempts of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryverificationstartedat"></a>`verificationStartedAt` | [`Time`](#time) | Timestamp when the verification started of CiSecureFileRegistry. |
| <a id="cisecurefileregistryverificationstate"></a>`verificationState` | [`VerificationStateEnum`](#verificationstateenum) | Verification state of the CiSecureFileRegistry. |
| <a id="cisecurefileregistryverifiedat"></a>`verifiedAt` | [`Time`](#time) | Timestamp of the most recent successful verification of the CiSecureFileRegistry. |

### `CiStage`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cistagedetailedstatus"></a>`detailedStatus` | [`DetailedStatus`](#detailedstatus) | Detailed status of the stage. |
| <a id="cistagegroups"></a>`groups` | [`CiGroupConnection`](#cigroupconnection) | Group of jobs for the stage. (see [Connections](#connections)) |
| <a id="cistageid"></a>`id` | [`ID!`](#id) | ID of the stage. |
| <a id="cistagejobs"></a>`jobs` | [`CiJobConnection`](#cijobconnection) | Jobs for the stage. (see [Connections](#connections)) |
| <a id="cistagename"></a>`name` | [`String`](#string) | Name of the stage. |
| <a id="cistagestatus"></a>`status` | [`String`](#string) | Status of the pipeline stage. |

### `CiSubscriptionsProject`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="cisubscriptionsprojectauthor"></a>`author` | [`UserCore`](#usercore) | Author of the subscription. |
| <a id="cisubscriptionsprojectdownstreamproject"></a>`downstreamProject` | [`Project`](#project) | Downstream project of the subscription. |
| <a id="cisubscriptionsprojectid"></a>`id` | [`CiSubscriptionsProjectID`](#cisubscriptionsprojectid) | Global ID of the subscription. |
| <a id="cisubscriptionsprojectupstreamproject"></a>`upstreamProject` | [`Project`](#project) | Upstream project of the subscription. |

### `CiTemplate`

GitLab CI/CD configuration template.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="citemplatecontent"></a>`content` | [`String!`](#string) | Contents of the CI template. |
| <a id="citemplatename"></a>`name` | [`String!`](#string) | Name of the CI template. |

### `ClusterAgent`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityevents"></a>`activityEvents` | [`ClusterAgentActivityEventConnection`](#clusteragentactivityeventconnection) | Recent activity for the cluster agent. (see [Connections](#connections)) |
| <a id="clusteragentconnections"></a>`connections` | [`ConnectedAgentConnection`](#connectedagentconnection) | Active connections for the cluster agent. (see [Connections](#connections)) |
| <a id="clusteragentcreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp the cluster agent was created. |
| <a id="clusteragentcreatedbyuser"></a>`createdByUser` | [`UserCore`](#usercore) | User object, containing information about the person who created the agent. |
| <a id="clusteragentid"></a>`id` | [`ID!`](#id) | ID of the cluster agent. |
| <a id="clusteragentname"></a>`name` | [`String`](#string) | Name of the cluster agent. |
| <a id="clusteragentproject"></a>`project` | [`Project`](#project) | Project this cluster agent is associated with. |
| <a id="clusteragenttokens"></a>`tokens` | [`ClusterAgentTokenConnection`](#clusteragenttokenconnection) | Tokens associated with the cluster agent. (see [Connections](#connections)) |
| <a id="clusteragentupdatedat"></a>`updatedAt` | [`Time`](#time) | Timestamp the cluster agent was updated. |
| <a id="clusteragentvulnerabilityimages"></a>`vulnerabilityImages` | [`VulnerabilityContainerImageConnection`](#vulnerabilitycontainerimageconnection) | Container images reported on the agent vulnerabilities. (see [Connections](#connections)) |
| <a id="clusteragentwebpath"></a>`webPath` | [`String`](#string) | Web path of the cluster agent. |

#### Fields with arguments

##### `ClusterAgent.workspaces`

Workspaces associated with the agent.

Returns [`WorkspaceConnection`](#workspaceconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentworkspacesactualstates"></a>`actualStates` | [`[String!]`](#string) | Filter workspaces by actual states. |
| <a id="clusteragentworkspacesids"></a>`ids` | [`[RemoteDevelopmentWorkspaceID!]`](#remotedevelopmentworkspaceid) | Filter workspaces by workspace GlobalIDs. For example, `["gid://gitlab/RemoteDevelopment::Workspace/1"]`. |
| <a id="clusteragentworkspacesprojectids"></a>`projectIds` | [`[ProjectID!]`](#projectid) | Filter workspaces by project GlobalID. |

### `ClusterAgentActivityEvent`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentactivityeventagenttoken"></a>`agentToken` | [`ClusterAgentToken`](#clusteragenttoken) | Agent token associated with the event. |
| <a id="clusteragentactivityeventkind"></a>`kind` | [`String`](#string) | Type of event. |
| <a id="clusteragentactivityeventlevel"></a>`level` | [`String`](#string) | Severity of the event. |
| <a id="clusteragentactivityeventrecordedat"></a>`recordedAt` | [`Time`](#time) | Timestamp the event was recorded. |
| <a id="clusteragentactivityeventuser"></a>`user` | [`UserCore`](#usercore) | User associated with the event. |

### `ClusterAgentAuthorizationCiAccess`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationciaccessagent"></a>`agent` | [`ClusterAgent`](#clusteragent) | Authorized cluster agent. |
| <a id="clusteragentauthorizationciaccessconfig"></a>`config` | [`JSON`](#json) | Configuration for the authorized project. |

### `ClusterAgentAuthorizationUserAccess`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragentauthorizationuseraccessagent"></a>`agent` | [`ClusterAgent`](#clusteragent) | Authorized cluster agent. |
| <a id="clusteragentauthorizationuseraccessconfig"></a>`config` | [`JSON`](#json) | Configuration for the authorized project. |

### `ClusterAgentToken`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="clusteragenttokenclusteragent"></a>`clusterAgent` | [`ClusterAgent`](#clusteragent) | Cluster agent this token is associated with. |
| <a id="clusteragenttokencreatedat"></a>`createdAt` | [`Time`](#time) | Timestamp the token was created. |
| <a id="clusteragenttokencreatedbyuser"></a>`createdByUser` | [`UserCore`](#usercore) | User who created the token. |
| <a id="clusteragenttokendescription"></a>`description` | [`String`](#string) | Description of the token. |
| <a id="clusteragenttokenid"></a>`id` | [`ClustersAgentTokenID!`](#clustersagenttokenid) | Global ID of the token. |
| <a id="clusteragenttokenlastusedat"></a>`lastUsedAt` | [`Time`](#time) | Timestamp the token was last used. |
| <a id="clusteragenttokenname"></a>`name` | [`String`](#string) | Name given to the token. |
| <a id="clusteragenttokenstatus"></a>`status` | [`AgentTokenStatus`](#agenttokenstatus) | Current status of the token. |

### `CodeCoverageActivity`

Represents the code coverage activity for a group.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoverageactivityaveragecoverage"></a>`averageCoverage` | [`Float`](#float) | Average percentage of the different code coverage results available for the group. |
| <a id="codecoverageactivitycoveragecount"></a>`coverageCount` | [`Int`](#int) | Number of different code coverage results available for the group. |
| <a id="codecoverageactivitydate"></a>`date` | [`Date!`](#date) | Date when the code coverage was created. |
| <a id="codecoverageactivityprojectcount"></a>`projectCount` | [`Int`](#int) | Number of projects with code coverage results for the group. |

### `CodeCoverageSummary`

Represents the code coverage summary for a project.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codecoveragesummaryaveragecoverage"></a>`averageCoverage` | [`Float`](#float) | Average percentage of the different code coverage results available for the project. |
| <a id="codecoveragesummarycoveragecount"></a>`coverageCount` | [`Int`](#int) | Number of different code coverage results available. |
| <a id="codecoveragesummarylastupdatedon"></a>`lastUpdatedOn` | [`Date`](#date) | Latest date when the code coverage was created for the project. |

### `CodeQualityDegradation`

Represents a code quality degradation on the pipeline.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalitydegradationdescription"></a>`description` | [`String!`](#string) | Description of the code quality degradation. |
| <a id="codequalitydegradationenginename"></a>`engineName` | [`String!`](#string) | Code Quality plugin that reported the finding. |
| <a id="codequalitydegradationfingerprint"></a>`fingerprint` | [`String!`](#string) | Unique fingerprint to identify the code quality degradation. For example, an MD5 hash. |
| <a id="codequalitydegradationline"></a>`line` | [`Int!`](#int) | Line on which the code quality degradation occurred. |
| <a id="codequalitydegradationpath"></a>`path` | [`String!`](#string) | Relative path to the file containing the code quality degradation. |
| <a id="codequalitydegradationseverity"></a>`severity` | [`CodeQualityDegradationSeverity!`](#codequalitydegradationseverity) | Status of the degradation (BLOCKER, CRITICAL, MAJOR, MINOR, INFO, UNKNOWN). |
| <a id="codequalitydegradationweburl"></a>`webUrl` | [`String`](#string) | URL to the file along with line number. |

### `CodeQualityReportSummary`

Code Quality report for a pipeline.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalityreportsummaryblocker"></a>`blocker` | [`Int`](#int) | Total number of blocker status. |
| <a id="codequalityreportsummarycount"></a>`count` | [`Int`](#int) | Total number of Code Quality reports. |
| <a id="codequalityreportsummarycritical"></a>`critical` | [`Int`](#int) | Total number of critical status. |
| <a id="codequalityreportsummaryinfo"></a>`info` | [`Int`](#int) | Total number of info status. |
| <a id="codequalityreportsummarymajor"></a>`major` | [`Int`](#int) | Total number of major status. |
| <a id="codequalityreportsummaryminor"></a>`minor` | [`Int`](#int) | Total number of minor status. |
| <a id="codequalityreportsummaryunknown"></a>`unknown` | [`Int`](#int) | Total number of unknown status. |

### `CodequalityReportsComparer`

Represents reports comparison for code quality.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalityreportscomparerreport"></a>`report` | [`CodequalityReportsComparerReport`](#codequalityreportscomparerreport) | Compared codequality report. |
| <a id="codequalityreportscomparerstatus"></a>`status` | [`CodequalityReportsComparerReportGenerationStatus`](#codequalityreportscomparerreportgenerationstatus) | Compared codequality report generation status. |

### `CodequalityReportsComparerReport`

Represents compared code quality report.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalityreportscomparerreportexistingerrors"></a>`existingErrors` | [`[CodequalityReportsComparerReportDegradation!]`](#codequalityreportscomparerreportdegradation) | All code quality degradations. |
| <a id="codequalityreportscomparerreportnewerrors"></a>`newErrors` | [`[CodequalityReportsComparerReportDegradation!]!`](#codequalityreportscomparerreportdegradation) | New code quality degradations. |
| <a id="codequalityreportscomparerreportresolvederrors"></a>`resolvedErrors` | [`[CodequalityReportsComparerReportDegradation!]`](#codequalityreportscomparerreportdegradation) | Resolved code quality degradations. |
| <a id="codequalityreportscomparerreportstatus"></a>`status` | [`CodequalityReportsComparerStatus!`](#codequalityreportscomparerstatus) | Status of report. |
| <a id="codequalityreportscomparerreportsummary"></a>`summary` | [`CodequalityReportsComparerReportSummary!`](#codequalityreportscomparerreportsummary) | Codequality report summary. |

### `CodequalityReportsComparerReportDegradation`

Represents a degradation on the compared codequality report.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalityreportscomparerreportdegradationdescription"></a>`description` | [`String!`](#string) | Description of the code quality degradation. |
| <a id="codequalityreportscomparerreportdegradationenginename"></a>`engineName` | [`String`](#string) | Code quality plugin that reported the degradation. |
| <a id="codequalityreportscomparerreportdegradationfilepath"></a>`filePath` | [`String!`](#string) | Relative path to the file containing the code quality degradation. |
| <a id="codequalityreportscomparerreportdegradationfingerprint"></a>`fingerprint` | [`String!`](#string) | Unique fingerprint to identify the code quality degradation. For example, an MD5 hash. |
| <a id="codequalityreportscomparerreportdegradationline"></a>`line` | [`Int!`](#int) | Line on which the code quality degradation occurred. |
| <a id="codequalityreportscomparerreportdegradationseverity"></a>`severity` | [`CodeQualityDegradationSeverity!`](#codequalitydegradationseverity) | Severity of the code quality degradation (BLOCKER, CRITICAL, MAJOR, MINOR, INFO, UNKNOWN). |
| <a id="codequalityreportscomparerreportdegradationweburl"></a>`webUrl` | [`String`](#string) | URL to the file along with line number. |

### `CodequalityReportsComparerReportSummary`

Represents a summary of the compared codequality report.

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="codequalityreportscomparerreportsummaryerrored"></a>`errored` | [`Int`](#int) | Count of code quality errors. |
| <a id="codequalityreportscomparerreportsummaryresolved"></a>`resolved` | [`Int`](#int) | Count of resolved code quality degradations. |
| <a id="codequalityreportscomparerreportsummarytotal"></a>`total` | [`Int`](#int) | Total count of code quality degradations. |

### `Commit`

#### Fields

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitauthor"></a>`author` | [`UserCore`](#usercore) | Author of the commit. |
| <a id="commitauthoremail"></a>`authorEmail` | [`String`](#string) | Commit author's email. |
| <a id="commitauthorgravatar"></a>`authorGravatar` | [`String`](#string) | Commit authors gravatar. |
| <a id="commitauthorname"></a>`authorName` | [`String`](#string) | Commit authors name. |
| <a id="commitauthoreddate"></a>`authoredDate` | [`Time`](#time) | Timestamp of when the commit was authored. |
| <a id="commitcommitteddate"></a>`committedDate` | [`Time`](#time) | Timestamp of when the commit was committed. |
| <a id="commitcommitteremail"></a>`committerEmail` | [`String`](#string) | Email of the committer. |
| <a id="commitcommittername"></a>`committerName` | [`String`](#string) | Name of the committer. |
| <a id="commitdescription"></a>`description` | [`String`](#string) | Description of the commit message. |
| <a id="commitdescriptionhtml"></a>`descriptionHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `description`. |
| <a id="commitdiffs"></a>`diffs` | [`[Diff!]`](#diff) | Diffs contained within the commit. This field can only be resolved for 10 diffs in any single request. |
| <a id="commitfulltitle"></a>`fullTitle` | [`String`](#string) | Full title of the commit message. |
| <a id="commitfulltitlehtml"></a>`fullTitleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `full_title`. |
| <a id="commitid"></a>`id` | [`ID!`](#id) | ID (global ID) of the commit. |
| <a id="commitmessage"></a>`message` | [`String`](#string) | Raw commit message. |
| <a id="commitsha"></a>`sha` | [`String!`](#string) | SHA1 ID of the commit. |
| <a id="commitshortid"></a>`shortId` | [`String!`](#string) | Short SHA1 ID of the commit. |
| <a id="commitsignature"></a>`signature` | [`CommitSignature`](#commitsignature) | Signature of the commit. |
| <a id="commitsignaturehtml"></a>`signatureHtml` | [`String`](#string) | Rendered HTML of the commit signature. |
| <a id="committitle"></a>`title` | [`String`](#string) | Title of the commit message. |
| <a id="committitlehtml"></a>`titleHtml` | [`String`](#string) | GitLab Flavored Markdown rendering of `title`. |
| <a id="commitwebpath"></a>`webPath` | [`String!`](#string) | Web path of the commit. |
| <a id="commitweburl"></a>`webUrl` | [`String!`](#string) | Web URL of the commit. |

#### Fields with arguments

##### `Commit.pipelines`

Pipelines of the commit ordered latest first.

Returns [`PipelineConnection`](#pipelineconnection).

This field returns a [connection](#connections). It accepts the
four standard [pagination arguments](#pagination-arguments):
`before: String`, `after: String`, `first: Int`, and `last: Int`.

###### Arguments

| Name | Type | Description |
| ---- | ---- | ----------- |
| <a id="commitpipelinesref"></a>`ref` | [`String`](#string) | Filter pipelines by the ref they are run for. |
| <a id="commitpipelinesscope"></a>`scope` | [`PipelineScopeEnum`](#pipelinescopeenum) | Filter pipelines by scope. |
| <a id="commitpipelinessha"></a>`sha` | [`String`](#string) | Filter pipelines by the sha of the commit they 