---
stage: Create
group: Editor Extensions
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# GitLab plugin for JetBrains IDEs

The [GitLab plugin](https://plugins.jetbrains.com/plugin/22325-gitlab-duo)
integrates GitLab with JetBrains IDEs. The following JetBrains IDEs are supported:

- IntelliJ IDEA Ultimate — 2023.2
- AppCode — build 232.7754.73 — 232.*
- Rider — 2023.2-RC1 (rc)
- DataGrip — 2023.2
- DataSpell — 2023.2
- GoLand — 2023.2
- Aqua — 2023.2 (preview)
- Android Studio — build 232.7754.73 — 232.*
- MPS — build 232.7754.73 — 232.*
- RubyMine — 2023.2
- PhpStorm — 2023.2 (rc)
- PyCharm Community — 2023.2
- IntelliJ IDEA Community — 2023.2
- PyCharm Educational — build 232.7754.73 — 232.*
- WebStorm — 2023.2
- CLion — 2023.2
- IntelliJ IDEA Educational — build 232.7754.73 — 232.*
- PyCharm Professional — 2023.2

## Supported features

GitLab for JetBrains supports [GitLab Duo Code Suggestions](../../user/project/repository/code_suggestions/index.md).

## Download the extension

Download the extension from the [JetBrains Plugin Marketplace](https://plugins.jetbrains.com/plugin/22325-gitlab-duo).

## Configure the extension

Instructions for getting started can be found in the project README under [setup](https://gitlab.com/gitlab-org/editor-extensions/gitlab-jetbrains-plugin#setup).

## Report issues with the extension

Report any issues, bugs, or feature requests in the
[`gitlab-jetbrains-plugin` issue queue](https://gitlab.com/gitlab-org/editor-extensions/gitlab-jetbrains-plugin/-/issues).

## Related topics

- [Download the plugin](https://plugins.jetbrains.com/plugin/22325-gitlab-duo)
- [Plugin documentation](https://gitlab.com/gitlab-org/editor-extensions/gitlab-jetbrains-plugin/-/blob/main/README.md)
- [View source code](https://gitlab.com/gitlab-org/editor-extensions/gitlab-jetbrains-plugin)
