/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

final class TypeNames {
    private static final Map<String, Class<?>> MAPPING = new LinkedHashMap(16);
    private final NameSpace ogcNS;
    private final NameSpace classNS;

    TypeNames(NameFactory nameFactory) {
        this.ogcNS = nameFactory.createNameSpace((GenericName)nameFactory.createLocalName(null, (CharSequence)"OGC"), null);
        this.classNS = nameFactory.createNameSpace((GenericName)nameFactory.createLocalName(null, (CharSequence)"class"), null);
    }

    final TypeName toTypeName(NameFactory nameFactory, Class<?> clazz) {
        TypeName typeName;
        String string;
        NameSpace nameSpace = this.ogcNS;
        if (CharSequence.class.isAssignableFrom(clazz)) {
            string = InternationalString.class.isAssignableFrom(clazz) ? "FreeText" : "CharacterString";
        } else if (Number.class.isAssignableFrom(clazz)) {
            string = Numbers.isInteger(clazz) ? "Integer" : "Real";
        } else {
            Class<?> clazz2;
            typeName = MAPPING.entrySet().iterator();
            do {
                Map.Entry<String, Class<?>> entry;
                if (!(clazz2 = (entry = typeName.next()).getValue()).isAssignableFrom(clazz)) continue;
                String string2 = entry.getKey();
                return nameFactory.createTypeName(nameSpace, (CharSequence)string2);
            } while (clazz2 != Boolean.class);
            string = Types.getStandardName(clazz);
            if (string == null) {
                nameSpace = this.classNS;
                string = clazz.getName();
            }
        }
        typeName = nameFactory.createTypeName(nameSpace, (CharSequence)string);
        if (typeName instanceof DefaultTypeName) {
            ((DefaultTypeName)typeName).setValueClass(nameSpace, string, clazz);
        }
        return typeName;
    }

    static Class<?> toClass(String string, String string2) throws ClassNotFoundException {
        Class<Object> clazz;
        if (string == null || string.equalsIgnoreCase("OGC")) {
            clazz = MAPPING.get(string2);
            if (clazz == null && (clazz = Types.forStandardName(string2)) == null && string == null) {
                clazz = Void.TYPE;
            }
        } else {
            clazz = string.equalsIgnoreCase("class") ? Class.forName(string2) : Void.TYPE;
        }
        return clazz;
    }

    static boolean isValid(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException(Errors.format((short)45, "valueClass", "void"));
        }
        return clazz != null;
    }

    static String namespace(NameSpace nameSpace) {
        GenericName genericName;
        if (nameSpace != null && !nameSpace.isGlobal() && (genericName = nameSpace.name()) != null) {
            return genericName.toString();
        }
        return null;
    }

    static String unknown(GenericName genericName) {
        return Errors.format((short)149, genericName.toFullyQualifiedName());
    }

    static {
        Map<String, Class<?>> map = MAPPING;
        map.put("URI", URI.class);
        map.put("DateTime", Date.class);
        map.put("PT_Locale", Locale.class);
        map.put("Decimal", BigDecimal.class);
        map.put("Boolean", Boolean.class);
        map.put("FreeText", InternationalString.class);
        map.put("CharacterString", String.class);
        map.put("Real", Double.class);
        map.put("Decimal", Double.class);
        map.put("Integer", Integer.class);
    }
}

