/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.GetSegmentDataResponse;
import org.apache.solr.client.api.util.CoreApiParameters;

@Path(value="/cores/{coreName}/segments")
public interface SegmentsApi {
    public static final String CORE_INFO_PARAM_DESC = "Boolean flag to include metadata (e.g. index an data directories, IndexWriter configuration, etc.) about each shard leader's core";
    public static final String FIELD_INFO_PARAM_DESC = "Boolean flag to include statistics about the indexed fields present on each shard leader.";
    public static final String RAW_SIZE_PARAM_DESC = "Boolean flag to include simple estimates of the disk size taken up by each field (e.g. \"id\", \"_version_\") and by each index data structure (e.g. 'storedFields', 'docValues_numeric').";
    public static final String RAW_SIZE_SUMMARY_DESC = "Boolean flag to include more involved estimates of the disk size taken up by index data structures, on a per-field basis (e.g. how much data does the \"id\" field contribute to 'storedField' index files).  More detail than 'rawSize', less detail than 'rawSizeDetails'.";
    public static final String RAW_SIZE_DETAILS_DESC = "Boolean flag to include detailed statistics about the disk size taken up by various fields and data structures.  More detail than 'rawSize' and 'rawSizeSummary'.";
    public static final String RAW_SIZE_SAMPLING_PERCENT_DESC = "Percentage (between 0 and 100) of data to read when estimating index size and statistics.  Defaults to 5.0 (i.e. 5%).";
    public static final String SIZE_INFO_PARAM_DESC = "Boolean flag to include information about the largest index files for each Lucene segment.";

    @GET
    @CoreApiParameters
    @Operation(summary="Fetches metadata about the segments in use by the specified core", tags={"segments"})
    public GetSegmentDataResponse getSegmentData(@Parameter(description="Boolean flag to include metadata (e.g. index an data directories, IndexWriter configuration, etc.) about each shard leader's core") @QueryParam(value="coreInfo") Boolean var1, @Parameter(description="Boolean flag to include statistics about the indexed fields present on each shard leader.") @QueryParam(value="fieldInfo") Boolean var2, @Parameter(description="Boolean flag to include simple estimates of the disk size taken up by each field (e.g. \"id\", \"_version_\") and by each index data structure (e.g. 'storedFields', 'docValues_numeric').") @QueryParam(value="rawSize") Boolean var3, @Parameter(description="Boolean flag to include more involved estimates of the disk size taken up by index data structures, on a per-field basis (e.g. how much data does the \"id\" field contribute to 'storedField' index files).  More detail than 'rawSize', less detail than 'rawSizeDetails'.") @QueryParam(value="rawSizeSummary") Boolean var4, @Parameter(description="Boolean flag to include detailed statistics about the disk size taken up by various fields and data structures.  More detail than 'rawSize' and 'rawSizeSummary'.") @QueryParam(value="rawSizeDetails") Boolean var5, @Parameter(description="Percentage (between 0 and 100) of data to read when estimating index size and statistics.  Defaults to 5.0 (i.e. 5%).") @QueryParam(value="rawSizeSamplingPercent") Float var6, @Parameter(description="Boolean flag to include information about the largest index files for each Lucene segment.") @QueryParam(value="sizeInfo") Boolean var7) throws Exception;
}

