/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public class DensityRulesClassifier
implements BoilerpipeFilter {
    public static final DensityRulesClassifier INSTANCE = new DensityRulesClassifier();

    public static DensityRulesClassifier getInstance() {
        return INSTANCE;
    }

    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        List<TextBlock> textBlocks = doc.getTextBlocks();
        boolean hasChanges = false;
        ListIterator<TextBlock> it = textBlocks.listIterator();
        if (!it.hasNext()) {
            return false;
        }
        TextBlock prevBlock = TextBlock.EMPTY_START;
        TextBlock currentBlock = it.next();
        TextBlock nextBlock = it.hasNext() ? it.next() : TextBlock.EMPTY_START;
        hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
        if (nextBlock != TextBlock.EMPTY_START) {
            while (it.hasNext()) {
                prevBlock = currentBlock;
                currentBlock = nextBlock;
                nextBlock = it.next();
                hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
            }
            prevBlock = currentBlock;
            currentBlock = nextBlock;
            nextBlock = TextBlock.EMPTY_START;
            hasChanges = this.classify(prevBlock, currentBlock, nextBlock) | hasChanges;
        }
        return hasChanges;
    }

    protected boolean classify(TextBlock prev, TextBlock curr, TextBlock next) {
        boolean isContent = (double)curr.getLinkDensity() <= 0.333333 ? ((double)prev.getLinkDensity() <= 0.555556 ? (curr.getTextDensity() <= 9.0f ? (next.getTextDensity() <= 10.0f ? !(prev.getTextDensity() <= 4.0f) : true) : next.getTextDensity() != 0.0f) : !(next.getTextDensity() <= 11.0f)) : false;
        return curr.setIsContent(isContent);
    }
}

