/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.DescriptorIndexNode;
import com.pff.PSTDescriptorItem;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTNodeInputStream;
import com.pff.PSTObject;
import com.pff.PSTTable7C;
import com.pff.PSTTable7CItem;
import com.pff.PSTTableBC;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class PSTFolder
extends PSTObject {
    private int currentEmailIndex = 0;
    private final LinkedHashSet<DescriptorIndexNode> otherItems = null;
    private PSTTable7C emailsTable = null;
    private LinkedList<DescriptorIndexNode> fallbackEmailsTable = null;
    private PSTTable7C subfoldersTable = null;

    PSTFolder(PSTFile theFile, DescriptorIndexNode descriptorIndexNode) throws PSTException, IOException {
        super(theFile, descriptorIndexNode);
    }

    PSTFolder(PSTFile theFile, DescriptorIndexNode folderIndexNode, PSTTableBC table, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) {
        super(theFile, folderIndexNode, table, localDescriptorItems);
    }

    public Vector<PSTFolder> getSubFolders() throws PSTException, IOException {
        this.initSubfoldersTable();
        Vector<PSTFolder> output = new Vector<PSTFolder>();
        try {
            List<HashMap<Integer, PSTTable7CItem>> itemMapSet = this.subfoldersTable.getItems();
            for (HashMap<Integer, PSTTable7CItem> itemMap : itemMapSet) {
                PSTTable7CItem item = itemMap.get(26610);
                PSTFolder folder = (PSTFolder)PSTObject.detectAndLoadPSTObject(this.pstFile, item.entryValueReference);
                output.add(folder);
            }
        }
        catch (PSTException err) {
            throw new PSTException("Can't get child folders for folder " + this.getDisplayName() + "(" + this.getDescriptorNodeId() + ") child count: " + this.getContentCount() + " - " + err.toString());
        }
        return output;
    }

    private void initSubfoldersTable() throws IOException, PSTException {
        if (this.subfoldersTable != null) {
            return;
        }
        long folderDescriptorIndex = this.descriptorIndexNode.descriptorIdentifier + 11;
        try {
            DescriptorIndexNode folderDescriptor = this.pstFile.getDescriptorIndexNode(folderDescriptorIndex);
            HashMap<Integer, PSTDescriptorItem> tmp = null;
            if (folderDescriptor.localDescriptorsOffsetIndexIdentifier > 0L) {
                tmp = this.pstFile.getPSTDescriptorItems(folderDescriptor.localDescriptorsOffsetIndexIdentifier);
            }
            this.subfoldersTable = new PSTTable7C(new PSTNodeInputStream(this.pstFile, this.pstFile.getOffsetIndexNode(folderDescriptor.dataOffsetIndexIdentifier)), tmp);
        }
        catch (PSTException err) {
            throw new PSTException("Can't get child folders for folder " + this.getDisplayName() + "(" + this.getDescriptorNodeId() + ") child count: " + this.getContentCount() + " - " + err.toString());
        }
    }

    private void initEmailsTable() throws PSTException, IOException {
        if (this.emailsTable != null || this.fallbackEmailsTable != null) {
            return;
        }
        if (this.getNodeType() == 3) {
            return;
        }
        try {
            long folderDescriptorIndex = this.descriptorIndexNode.descriptorIdentifier + 12;
            DescriptorIndexNode folderDescriptor = this.pstFile.getDescriptorIndexNode(folderDescriptorIndex);
            HashMap<Integer, PSTDescriptorItem> tmp = null;
            if (folderDescriptor.localDescriptorsOffsetIndexIdentifier > 0L) {
                tmp = this.pstFile.getPSTDescriptorItems(folderDescriptor.localDescriptorsOffsetIndexIdentifier);
            }
            this.emailsTable = new PSTTable7C(new PSTNodeInputStream(this.pstFile, this.pstFile.getOffsetIndexNode(folderDescriptor.dataOffsetIndexIdentifier)), tmp, 26610);
        }
        catch (Exception err) {
            LinkedHashMap<Integer, LinkedList<DescriptorIndexNode>> tree = this.pstFile.getChildDescriptorTree();
            this.fallbackEmailsTable = new LinkedList();
            LinkedList<DescriptorIndexNode> allChildren = tree.get(this.getDescriptorNode().descriptorIdentifier);
            if (allChildren != null) {
                for (DescriptorIndexNode node : allChildren) {
                    if (node == null || PSTObject.getNodeType(node.descriptorIdentifier) != 4) continue;
                    this.fallbackEmailsTable.add(node);
                }
            }
            System.err.println("Can't get children for folder " + this.getDisplayName() + "(" + this.getDescriptorNodeId() + ") child count: " + this.getContentCount() + " - " + err.toString() + ", using alternate child tree with " + this.fallbackEmailsTable.size() + " items");
        }
    }

    public Vector<PSTObject> getChildren(int numberToReturn) throws PSTException, IOException {
        Vector<PSTObject> output;
        block3: {
            block2: {
                this.initEmailsTable();
                output = new Vector<PSTObject>();
                if (this.emailsTable == null) break block2;
                List<HashMap<Integer, PSTTable7CItem>> rows = this.emailsTable.getItems(this.currentEmailIndex, numberToReturn);
                for (int x = 0; x < rows.size() && this.currentEmailIndex < this.getContentCount(); ++x) {
                    PSTTable7CItem emailRow = rows.get(x).get(26610);
                    DescriptorIndexNode childDescriptor = this.pstFile.getDescriptorIndexNode(emailRow.entryValueReference);
                    PSTObject child = PSTObject.detectAndLoadPSTObject(this.pstFile, childDescriptor);
                    output.add(child);
                    ++this.currentEmailIndex;
                }
                break block3;
            }
            if (this.fallbackEmailsTable == null) break block3;
            ListIterator<DescriptorIndexNode> iterator = this.fallbackEmailsTable.listIterator(this.currentEmailIndex);
            for (int x = 0; x < numberToReturn && this.currentEmailIndex < this.getContentCount(); ++x) {
                DescriptorIndexNode childDescriptor = iterator.next();
                PSTObject child = PSTObject.detectAndLoadPSTObject(this.pstFile, childDescriptor);
                output.add(child);
                ++this.currentEmailIndex;
            }
        }
        return output;
    }

    public LinkedList<Integer> getChildDescriptorNodes() throws PSTException, IOException {
        this.initEmailsTable();
        if (this.emailsTable == null) {
            return new LinkedList<Integer>();
        }
        LinkedList<Integer> output = new LinkedList<Integer>();
        List<HashMap<Integer, PSTTable7CItem>> rows = this.emailsTable.getItems();
        for (HashMap<Integer, PSTTable7CItem> row : rows) {
            if (this.currentEmailIndex == this.getContentCount()) break;
            PSTTable7CItem emailRow = row.get(26610);
            if (emailRow.entryValueReference == 0) break;
            output.add(emailRow.entryValueReference);
        }
        return output;
    }

    public PSTObject getNextChild() throws PSTException, IOException {
        this.initEmailsTable();
        if (this.emailsTable != null) {
            List<HashMap<Integer, PSTTable7CItem>> rows = this.emailsTable.getItems(this.currentEmailIndex, 1);
            if (this.currentEmailIndex == this.getContentCount()) {
                return null;
            }
            PSTTable7CItem emailRow = rows.get(0).get(26610);
            DescriptorIndexNode childDescriptor = this.pstFile.getDescriptorIndexNode(emailRow.entryValueReference);
            PSTObject child = PSTObject.detectAndLoadPSTObject(this.pstFile, childDescriptor);
            ++this.currentEmailIndex;
            return child;
        }
        if (this.fallbackEmailsTable != null) {
            if (this.currentEmailIndex >= this.getContentCount() || this.currentEmailIndex >= this.fallbackEmailsTable.size()) {
                return null;
            }
            DescriptorIndexNode childDescriptor = this.fallbackEmailsTable.get(this.currentEmailIndex);
            PSTObject child = PSTObject.detectAndLoadPSTObject(this.pstFile, childDescriptor);
            ++this.currentEmailIndex;
            return child;
        }
        return null;
    }

    public void moveChildCursorTo(int newIndex) throws IOException, PSTException {
        this.initEmailsTable();
        if (newIndex < 1) {
            this.currentEmailIndex = 0;
            return;
        }
        if (newIndex > this.getContentCount()) {
            newIndex = this.getContentCount();
        }
        this.currentEmailIndex = newIndex;
    }

    public int getSubFolderCount() throws IOException, PSTException {
        this.initSubfoldersTable();
        if (this.subfoldersTable != null) {
            return this.subfoldersTable.getRowCount();
        }
        return 0;
    }

    public int getEmailCount() throws IOException, PSTException {
        this.initEmailsTable();
        if (this.emailsTable == null) {
            return -1;
        }
        return this.emailsTable.getRowCount();
    }

    public int getFolderType() {
        return this.getIntItem(13825);
    }

    public int getContentCount() {
        return this.getIntItem(13826);
    }

    public int getUnreadCount() {
        return this.getIntItem(13827);
    }

    public boolean hasSubfolders() {
        return this.getIntItem(13834) != 0;
    }

    public String getContainerClass() {
        return this.getStringItem(13843);
    }

    public int getAssociateContentCount() {
        return this.getIntItem(13847);
    }

    public int getContainerFlags() {
        return this.getIntItem(13824);
    }
}

