/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.solr.common.util.Compressor;

public class ZLibCompressor
implements Compressor {
    private static final byte[] ZLIB_MAGIC = new byte[]{120, 1};
    private static final int COMPRESSED_SIZE_MAGIC_NUMBER = 2018370979;

    @Override
    public boolean isCompressedBytes(byte[] data) {
        if (data == null || data.length < 2) {
            return false;
        }
        return ZLIB_MAGIC[0] == data[0] && ZLIB_MAGIC[1] == data[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decompressBytes(byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(data, 0, data.length);
            ByteBuffer bb = ByteBuffer.wrap(data, data.length - 8, 8);
            int decompressedSize = bb.getInt();
            int xoredSize = bb.getInt();
            if ((decompressedSize ^ 0x784DE5A3) != xoredSize) {
                decompressedSize = 5 * data.length;
            }
            byte[] buf = new byte[decompressedSize];
            int actualDecompressedSize = 0;
            while (!inflater.finished()) {
                if (actualDecompressedSize >= buf.length) {
                    buf = Arrays.copyOf(buf, (int)((double)buf.length * 1.5));
                }
                actualDecompressedSize += inflater.inflate(buf, actualDecompressedSize, decompressedSize);
            }
            if (buf.length != actualDecompressedSize) {
                buf = Arrays.copyOf(buf, actualDecompressedSize);
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            inflater.end();
        }
    }

    @Override
    public byte[] compressBytes(byte[] data) {
        return this.compressBytes(data, data.length / 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compressBytes(byte[] data, int initialBufferCapacity) {
        Deflater compressor = new Deflater(1);
        try {
            compressor.setInput(data);
            compressor.finish();
            byte[] buf = new byte[Math.max(initialBufferCapacity, 16)];
            int compressedSize = 0;
            while (!compressor.finished()) {
                if (compressedSize >= buf.length) {
                    buf = Arrays.copyOf(buf, (int)((double)buf.length * 1.5));
                }
                compressedSize += compressor.deflate(buf, compressedSize, buf.length - compressedSize);
            }
            buf = Arrays.copyOf(buf, compressedSize + 8);
            ByteBuffer.wrap(buf, compressedSize, 8).putInt(data.length).putInt(data.length ^ 0x784DE5A3);
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            compressor.end();
        }
    }
}

