/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.ObjectStreamException;
import java.util.HashMap;
import org.apache.sis.internal.referencing.provider.EPSGName;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.apache.sis.parameter.MatrixParameters;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.util.GenericName;

final class MatrixParametersAlphaNum
extends MatrixParameters {
    private static final long serialVersionUID = 476760046257432637L;

    MatrixParametersAlphaNum(ParameterDescriptor<Integer> parameterDescriptor, ParameterDescriptor<Integer> parameterDescriptor2) {
        super(parameterDescriptor, parameterDescriptor2);
    }

    @Override
    protected String indicesToName(int[] nArray) throws IllegalArgumentException {
        return MatrixParametersAlphaNum.indicesToAlias(nArray);
    }

    @Override
    protected ParameterDescriptor<Double> createElementDescriptor(int[] nArray) throws IllegalArgumentException {
        if (WKT1 == this) {
            throw new AssertionError();
        }
        ParameterDescriptor parameterDescriptor = WKT1.getElementDescriptor(nArray);
        GenericName genericName = (GenericName)CollectionsExt.first(parameterDescriptor.getAlias());
        if (genericName == null) {
            return parameterDescriptor;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(6);
        if (MatrixParametersAlphaNum.isEPSG(nArray)) {
            genericName = EPSGName.create(genericName.tip().toString());
            int n = (nArray[0] == 0 ? 8623 : 8639) + nArray[1];
            hashMap.put("identifiers", EPSGName.identifier(n));
        }
        hashMap.put("name", genericName);
        hashMap.put("alias", parameterDescriptor.getName());
        return new DefaultParameterDescriptor<Double>(hashMap, 0, 1, Double.class, null, null, (Double)parameterDescriptor.getDefaultValue());
    }

    @Override
    Object readResolve() throws ObjectStreamException {
        return this.equals(ALPHANUM) ? ALPHANUM : this;
    }
}

