/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sis.io.wkt.AbstractParser;
import org.apache.sis.io.wkt.Element;
import org.apache.sis.io.wkt.MathTransformParser;
import org.apache.sis.util.ArraysExt;

final class StoredTree
implements Serializable {
    private static final long serialVersionUID = 8436779786449395346L;
    private final Node root;
    private final short[] offsets;

    StoredTree(Element element, Map<Object, Object> map) {
        Deflater deflater = new Deflater(map);
        this.root = (Node)deflater.unique(new Node(deflater, element));
        this.offsets = deflater.offsets();
    }

    StoredTree(List<Element> list, Map<Object, Object> map) {
        Deflater deflater = new Deflater(map);
        this.root = new Node(deflater, list);
        this.offsets = deflater.offsets();
    }

    final void toElements(AbstractParser abstractParser, Collection<? super Element> collection, int n) {
        this.root.toElements(new Inflater(abstractParser, this.offsets, n), collection);
    }

    final void peekIdentifiers(Object[] objectArray) {
        Node node = this.root.peekLastElement(MathTransformParser.ID_KEYWORDS);
        if (node != null) {
            node.peekValues(objectArray, 0);
            if (objectArray.length >= 4 && (node = node.peekLastElement("Citation")) != null) {
                node.peekValues(objectArray, 3);
            }
        }
    }

    final void forEachValue(Consumer<Object> consumer) {
        this.root.forEachValue(consumer);
    }

    final String keyword() {
        return this.root.keyword;
    }

    public String toString() {
        return this.root.toString();
    }

    private static final class Deflater {
        private Map<Object, Object> sharedValues;
        private short[] offsets;
        private int count;

        Deflater(Map<Object, Object> map) {
            this.sharedValues = map;
            this.offsets = new short[24];
        }

        final Object unique(Object object) {
            Object object2 = this.sharedValues.putIfAbsent(object, object);
            return object2 != null ? object2 : object;
        }

        final void addOffset(Element element) {
            if (this.count >= this.offsets.length) {
                this.offsets = Arrays.copyOf(this.offsets, this.count * 2);
            }
            int n = Math.min(Short.MAX_VALUE, Math.max(0, element.offset));
            if (element.isFragment) {
                n ^= 0xFFFFFFFF;
            }
            this.offsets[this.count++] = (short)n;
        }

        final short[] offsets() {
            this.offsets = ArraysExt.resize(this.offsets, this.count);
            short[] sArray = (short[])this.sharedValues.putIfAbsent(this, this.offsets);
            this.sharedValues = null;
            if (sArray != null) {
                this.offsets = sArray;
            }
            return this.offsets;
        }

        public boolean equals(Object object) {
            assert (this.offsets.length == this.count);
            return object instanceof Deflater && Arrays.equals(this.offsets, ((Deflater)object).offsets);
        }

        public int hashCode() {
            assert (this.offsets.length == this.count);
            return Arrays.hashCode(this.offsets);
        }
    }

    private static final class Node
    implements Serializable {
        private static final long serialVersionUID = 1463070931527783896L;
        final String keyword;
        private final Object[] children;

        Node(Deflater deflater, List<Element> list) {
            this.keyword = null;
            this.children = new Node[list.size()];
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i] = deflater.unique(new Node(deflater, list.get(i)));
            }
        }

        Node(Deflater deflater, Element element) {
            this.keyword = (String)deflater.unique(element.keyword);
            this.children = element.getChildren();
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    Object object = this.children[i];
                    if (object instanceof Element) {
                        object = new Node(deflater, (Element)object);
                    }
                    this.children[i] = deflater.unique(object);
                }
            }
            deflater.addOffset(element);
        }

        final void toElements(Inflater inflater, Collection<? super Element> collection) {
            if (this.keyword != null) {
                collection.add(this.toElement(inflater));
            } else {
                for (Node node : (Node[])this.children) {
                    collection.add(node.toElement(inflater));
                }
            }
        }

        private Element toElement(Inflater inflater) {
            LinkedList<Object> linkedList;
            if (this.children == null) {
                linkedList = null;
            } else {
                linkedList = new LinkedList<Object>();
                for (Object object : this.children) {
                    if (object instanceof Node) {
                        object = ((Node)object).toElement(inflater);
                    }
                    linkedList.add(object);
                }
            }
            return new Element(this.keyword, linkedList, inflater.nextOffset(), inflater.errorLocale);
        }

        final Node peekLastElement(String ... stringArray) {
            if (this.children != null) {
                int n = this.children.length;
                while (--n >= 0) {
                    Object object = this.children[n];
                    if (!(object instanceof Node)) continue;
                    Node node = (Node)object;
                    if (node.children == null) continue;
                    for (String string : stringArray) {
                        if (!node.keyword.equalsIgnoreCase(string)) continue;
                        return node;
                    }
                }
            }
            return null;
        }

        final void peekValues(Object[] objectArray, int n) {
            for (Object object : this.children) {
                if (object instanceof Node) continue;
                objectArray[n] = object;
                if (++n >= objectArray.length) break;
            }
        }

        final void forEachValue(Consumer<Object> consumer) {
            if (this.keyword != null) {
                consumer.accept(this.keyword);
            }
            if (this.children != null) {
                for (Object object : this.children) {
                    consumer.accept(object);
                    if (!(object instanceof Node)) continue;
                    ((Node)object).forEachValue(consumer);
                }
            }
        }

        public String toString() {
            return this.children != null && this.children.length != 0 ? String.valueOf(this.children[0]) : this.keyword;
        }

        public int hashCode() {
            int n = this.keyword.hashCode();
            if (this.children != null) {
                for (Object object : this.children) {
                    n = 31 * n + (object instanceof Node ? System.identityHashCode(object) : object.hashCode());
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Node) {
                Node node = (Node)object;
                if (this.keyword.equals(node.keyword)) {
                    if (this.children == node.children) {
                        return true;
                    }
                    if (this.children != null && node.children != null && this.children.length == node.children.length) {
                        for (int i = 0; i < this.children.length; ++i) {
                            Object object2 = this.children[i];
                            Object object3 = node.children[i];
                            if (!(object2 instanceof Node) ? object2.equals(object3) : object2 == object3) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static final class Inflater {
        private final int isFragment;
        private final short[] offsets;
        private int index;
        final Locale errorLocale;

        Inflater(AbstractParser abstractParser, short[] sArray, int n) {
            this.errorLocale = abstractParser.errorLocale;
            this.isFragment = n;
            this.offsets = sArray;
        }

        final int nextOffset() {
            return this.isFragment != 0 ? this.isFragment : this.offsets[this.index++];
        }
    }
}

