/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.referencing.provider;

import org.apache.sis.internal.referencing.provider.Equirectangular;
import org.apache.sis.internal.referencing.provider.LambertConformal2SP;
import org.apache.sis.internal.referencing.provider.MapProjection;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.util.Static;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;

final class ESRI
extends Static {
    static final ParameterDescriptor<Double> CENTRAL_MERIDIAN;
    static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    static final ParameterDescriptor<Double> STANDARD_PARALLEL_1;
    static final ParameterDescriptor<Double> STANDARD_PARALLEL_2;
    static final ParameterDescriptor<Double> FALSE_EASTING;
    static final ParameterDescriptor<Double> FALSE_NORTHING;

    private ESRI() {
    }

    static ParameterBuilder copyNames(ParameterBuilder parameterBuilder, ParameterDescriptor<Double> parameterDescriptor) {
        return (ParameterBuilder)((ParameterBuilder)((ParameterBuilder)parameterBuilder.addNameAndIdentifier(Citations.ESRI, (IdentifiedObject)parameterDescriptor)).addNameAndIdentifier(Citations.OGC, (IdentifiedObject)parameterDescriptor)).addNameAndIdentifier(Citations.PROJ4, (IdentifiedObject)parameterDescriptor);
    }

    static {
        ParameterBuilder parameterBuilder = MapProjection.builder();
        CENTRAL_MERIDIAN = MapProjection.createLongitude(ESRI.copyNames(parameterBuilder, Equirectangular.LONGITUDE_OF_ORIGIN));
        LATITUDE_OF_ORIGIN = MapProjection.createLatitude(ESRI.copyNames(parameterBuilder, Equirectangular.LATITUDE_OF_ORIGIN), true);
        STANDARD_PARALLEL_1 = MapProjection.createLatitude(ESRI.copyNames(parameterBuilder, LambertConformal2SP.STANDARD_PARALLEL_1), true);
        STANDARD_PARALLEL_2 = MapProjection.createLatitude(ESRI.copyNames(parameterBuilder, LambertConformal2SP.STANDARD_PARALLEL_2), true);
        FALSE_EASTING = MapProjection.createShift(ESRI.copyNames(parameterBuilder, Equirectangular.FALSE_EASTING));
        FALSE_NORTHING = MapProjection.createShift(ESRI.copyNames(parameterBuilder, Equirectangular.FALSE_NORTHING));
    }
}

