/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.icu;

import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.RuleBasedTransliterator;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeFilter;
import com.ibm.icu.text.UnicodeSet;
import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public final class ICUTransformFilter
extends TokenFilter {
    private final Transliterator transform;
    private final Transliterator.Position position = new Transliterator.Position();
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final ReplaceableTermAttribute replaceableAttribute = new ReplaceableTermAttribute();

    public ICUTransformFilter(TokenStream input, Transliterator transform) {
        super(input);
        UnicodeSet sourceSet;
        this.transform = transform;
        if (transform.getFilter() == null && transform instanceof RuleBasedTransliterator && (sourceSet = transform.getSourceSet()) != null && !sourceSet.isEmpty()) {
            transform.setFilter((UnicodeFilter)sourceSet);
        }
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            this.replaceableAttribute.setText(this.termAtt);
            int length = this.termAtt.length();
            this.position.start = 0;
            this.position.limit = length;
            this.position.contextStart = 0;
            this.position.contextLimit = length;
            this.transform.filteredTransliterate((Replaceable)this.replaceableAttribute, this.position, false);
            return true;
        }
        return false;
    }

    static final class ReplaceableTermAttribute
    implements Replaceable {
        private char[] buffer;
        private int length;
        private CharTermAttribute token;

        ReplaceableTermAttribute() {
        }

        void setText(CharTermAttribute token) {
            this.token = token;
            this.buffer = token.buffer();
            this.length = token.length();
        }

        public int char32At(int pos) {
            return UTF16.charAt((char[])this.buffer, (int)0, (int)this.length, (int)pos);
        }

        public char charAt(int pos) {
            return this.buffer[pos];
        }

        public void copy(int start, int limit, int dest) {
            char[] text = new char[limit - start];
            this.getChars(start, limit, text, 0);
            this.replace(dest, dest, text, 0, limit - start);
        }

        public void getChars(int srcStart, int srcLimit, char[] dst, int dstStart) {
            System.arraycopy(this.buffer, srcStart, dst, dstStart, srcLimit - srcStart);
        }

        public boolean hasMetaData() {
            return false;
        }

        public int length() {
            return this.length;
        }

        public void replace(int start, int limit, String text) {
            int charsLen = text.length();
            int newLength = this.shiftForReplace(start, limit, charsLen);
            text.getChars(0, charsLen, this.buffer, start);
            this.length = newLength;
            this.token.setLength(this.length);
        }

        public void replace(int start, int limit, char[] text, int charsStart, int charsLen) {
            int newLength = this.shiftForReplace(start, limit, charsLen);
            System.arraycopy(text, charsStart, this.buffer, start, charsLen);
            this.length = newLength;
            this.token.setLength(this.length);
        }

        private int shiftForReplace(int start, int limit, int charsLen) {
            int replacementLength = limit - start;
            int newLength = this.length - replacementLength + charsLen;
            if (newLength > this.length) {
                this.buffer = this.token.resizeBuffer(newLength);
            }
            if (replacementLength != charsLen && limit < this.length) {
                System.arraycopy(this.buffer, limit, this.buffer, start + charsLen, this.length - limit);
            }
            return newLength;
        }
    }
}

