/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.TextField;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.SyntaxError;

public class FuzzyQParserPlugin
extends QParserPlugin {
    public static final String NAME = "fuzzy";

    @Override
    public QParser createParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new FuzzyQParser(qstr, localParams, params, req);
    }

    static class FuzzyQParser
    extends QParser {
        static final String MAX_EDITS_PARAM = "maxEdits";
        static final String PREFIX_LENGTH_PARAM = "prefixLength";
        static final String MAX_EXPANSIONS_PARAM = "maxExpansions";
        static final String TRANSPOSITIONS_PARAM = "transpositions";

        public FuzzyQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(qstr, localParams, params, req);
        }

        @Override
        public Query parse() throws SyntaxError {
            String termStr = this.getParam("v");
            String field = this.getParam("f");
            termStr = this.analyzeIfMultitermTermText(field, termStr);
            Term t = new Term(field, termStr);
            String maxEditsRaw = this.getParam(MAX_EDITS_PARAM);
            int maxEdits = maxEditsRaw != null ? Integer.parseInt(maxEditsRaw) : 2;
            String prefixLengthRaw = this.getParam(PREFIX_LENGTH_PARAM);
            int prefixLength = prefixLengthRaw != null ? Integer.parseInt(prefixLengthRaw) : 0;
            String maxExpansionsRaw = this.getParam(MAX_EXPANSIONS_PARAM);
            int maxExpansions = maxExpansionsRaw != null ? Integer.parseInt(maxExpansionsRaw) : 50;
            String transpositionsRaw = this.getParam(TRANSPOSITIONS_PARAM);
            boolean transpositions = transpositionsRaw != null ? Boolean.parseBoolean(transpositionsRaw) : true;
            return new FuzzyQuery(t, maxEdits, prefixLength, maxExpansions, transpositions);
        }

        protected String analyzeIfMultitermTermText(String field, String part) {
            FieldType fieldType = this.req.getSchema().getFieldTypeNoEx(field);
            if (part == null || !(fieldType instanceof TextField) || ((TextField)fieldType).getMultiTermAnalyzer() == null) {
                return part;
            }
            BytesRef out = TextField.analyzeMultiTerm(field, part, ((TextField)fieldType).getMultiTermAnalyzer());
            return out == null ? part : out.utf8ToString();
        }
    }
}

