/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.core;

import com.codahale.metrics.Metric;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.solr.common.SolrException;
import org.apache.solr.metrics.prometheus.SolrMetric;

public abstract class SolrCoreMetric
extends SolrMetric {
    public static Pattern CLOUD_CORE_PATTERN = Pattern.compile("(?<core>^core_(?<collection>.*)_(?<shard>shard[0-9]+)_(?<replica>replica_.[0-9]+)).(.*)$");
    public static Pattern STANDALONE_CORE_PATTERN = Pattern.compile("^core_(?<core>.*?)\\.(.*)$");
    public static List<String> CLOUD_LABEL_KEYS = List.of("core", "collection", "shard", "replica");
    public static List<String> STANDALONE_LABEL_KEYS = List.of("core");
    public String coreName;

    public SolrCoreMetric(Metric dropwizardMetric, String metricName) {
        super(dropwizardMetric, metricName.substring(metricName.indexOf(".") + 1));
        Matcher cloudPattern = CLOUD_CORE_PATTERN.matcher(metricName);
        Matcher standalonePattern = STANDALONE_CORE_PATTERN.matcher(metricName);
        if (cloudPattern.find()) {
            this.coreName = cloudPattern.group("core");
            CLOUD_LABEL_KEYS.forEach(key -> this.labels.put(key, cloudPattern.group((String)key)));
        } else if (standalonePattern.find()) {
            this.coreName = standalonePattern.group("core");
            STANDALONE_LABEL_KEYS.forEach(key -> this.labels.put(key, standalonePattern.group((String)key)));
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core name does not match pattern for parsing in metric " + metricName);
        }
    }
}

