/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Version;
import org.apache.solr.api.JerseyResource;
import org.apache.solr.client.api.endpoint.SegmentsApi;
import org.apache.solr.client.api.model.GetSegmentDataResponse;
import org.apache.solr.common.luke.FieldFlag;
import org.apache.solr.common.util.Pair;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.admin.IndexSizeEstimator;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.jersey.SolrJacksonMapper;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSegmentData
extends JerseyResource
implements SegmentsApi {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double GB = 1.073741824E9;
    private static final List<String> FI_LEGEND = Arrays.asList(FieldFlag.INDEXED.toString(), FieldFlag.DOC_VALUES.toString(), "xxx - DocValues type", FieldFlag.TERM_VECTOR_STORED.toString(), FieldFlag.OMIT_NORMS.toString(), FieldFlag.OMIT_TF.toString(), FieldFlag.OMIT_POSITIONS.toString(), FieldFlag.STORE_OFFSETS_WITH_POSITIONS.toString(), "p - field has payloads", "s - field uses soft deletes", ":x:x:x - point data dim : index dim : num bytes");
    protected final SolrCore solrCore;
    protected final SolrQueryRequest solrQueryRequest;
    protected final SolrQueryResponse solrQueryResponse;

    @Inject
    public GetSegmentData(SolrCore solrCore, SolrQueryRequest req, SolrQueryResponse rsp) {
        this.solrCore = solrCore;
        this.solrQueryRequest = req;
        this.solrQueryResponse = rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PermissionName(value=PermissionNameProvider.Name.METRICS_READ_PERM)
    public GetSegmentDataResponse getSegmentData(Boolean coreInfo, Boolean fieldInfo, Boolean rawSize, Boolean rawSizeSummary, Boolean rawSizeDetails, Float rawSizeSamplingPercent, Boolean sizeInfo) throws Exception {
        Version commitVersion;
        boolean withFieldInfo = Boolean.TRUE.equals(fieldInfo);
        boolean withCoreInfo = Boolean.TRUE.equals(coreInfo);
        boolean withSizeInfo = Boolean.TRUE.equals(sizeInfo);
        boolean withRawSizeInfo = Boolean.TRUE.equals(rawSize);
        boolean withRawSizeSummary = Boolean.TRUE.equals(rawSizeSummary);
        boolean withRawSizeDetails = Boolean.TRUE.equals(rawSizeDetails);
        if (withRawSizeSummary || withRawSizeDetails) {
            withRawSizeInfo = true;
        }
        SolrIndexSearcher searcher = this.solrQueryRequest.getSearcher();
        SolrCore core = this.solrQueryRequest.getCore();
        GetSegmentDataResponse response = new GetSegmentDataResponse();
        SegmentInfos infos = SegmentInfos.readLatestCommit((Directory)searcher.getIndexReader().directory());
        response.info = new GetSegmentDataResponse.SegmentSummary();
        Version minVersion = infos.getMinSegmentLuceneVersion();
        if (minVersion != null) {
            response.info.minSegmentLuceneVersion = minVersion.toString();
        }
        if ((commitVersion = infos.getCommitLuceneVersion()) != null) {
            response.info.commitLuceneVersion = commitVersion.toString();
        }
        response.info.numSegments = infos.size();
        response.info.segmentsFileName = infos.getSegmentsFileName();
        response.info.totalMaxDoc = infos.totalMaxDoc();
        response.info.userData = infos.userData;
        if (withCoreInfo) {
            GetSegmentDataResponse.CoreSummary coreSummary;
            response.info.core = coreSummary = new GetSegmentDataResponse.CoreSummary();
            coreSummary.startTime = core.getStartTimeStamp().getTime() + "(" + String.valueOf(core.getStartTimeStamp()) + ")";
            coreSummary.dataDir = core.getDataDir();
            coreSummary.indexDir = core.getIndexDir();
            coreSummary.sizeInGB = (double)core.getIndexSize() / 1.073741824E9;
            RefCounted<IndexWriter> iwRef = core.getSolrCoreState().getIndexWriter(core);
            if (iwRef != null) {
                try {
                    IndexWriter iw = iwRef.get();
                    coreSummary.indexWriterConfig = this.convertIndexWriterConfigToResponse(iw.getConfig());
                }
                finally {
                    iwRef.decref();
                }
            }
        }
        ArrayList sortable = new ArrayList(infos.asList());
        sortable.sort((s1, s2) -> s2.info.maxDoc() - s2.getDelCount() - (s1.info.maxDoc() - s1.getDelCount()));
        ArrayList<String> mergeCandidates = new ArrayList<String>();
        Map<String, Object> runningMerges = this.getMergeInformation(this.solrQueryRequest, infos, mergeCandidates);
        List leafContexts = searcher.getIndexReader().leaves();
        IndexSchema schema = this.solrQueryRequest.getSchema();
        response.segments = new HashMap();
        for (SegmentCommitInfo segmentCommitInfo : sortable) {
            GetSegmentDataResponse.SingleSegmentData singleSegmentData = this.getSegmentInfo(segmentCommitInfo, withSizeInfo, withFieldInfo, leafContexts, schema);
            if (mergeCandidates.contains(segmentCommitInfo.info.name)) {
                singleSegmentData.mergeCandidate = true;
            }
            response.segments.put(singleSegmentData.name, singleSegmentData);
        }
        if (runningMerges.size() > 0) {
            response.runningMerges = runningMerges;
        }
        if (withFieldInfo) {
            response.fieldInfoLegend = FI_LEGEND;
        }
        if (withRawSizeInfo) {
            IndexSizeEstimator estimator = new IndexSizeEstimator((IndexReader)searcher.getRawReader(), 20, 100, withRawSizeSummary, withRawSizeDetails);
            if (rawSizeSamplingPercent != null) {
                estimator.setSamplingPercent(rawSizeSamplingPercent.floatValue());
            }
            IndexSizeEstimator.Estimate estimate = estimator.estimate();
            GetSegmentDataResponse.RawSize rawSizeResponse = new GetSegmentDataResponse.RawSize();
            rawSizeResponse.fieldsBySize = estimate.getHumanReadableFieldsBySize();
            rawSizeResponse.typesBySize = estimate.getHumanReadableTypesBySize();
            if (estimate.getSummary() != null) {
                rawSizeResponse.summary = estimate.getSummary();
            }
            if (estimate.getDetails() != null) {
                rawSizeResponse.details = estimate.getDetails();
            }
            response.rawSize = rawSizeResponse;
        }
        return response;
    }

    private GetSegmentDataResponse.IndexWriterConfigSummary convertIndexWriterConfigToResponse(LiveIndexWriterConfig iwConfig) {
        GetSegmentDataResponse.IndexWriterConfigSummary iwConfigResponse = new GetSegmentDataResponse.IndexWriterConfigSummary();
        iwConfigResponse.analyzer = iwConfig.getAnalyzer() != null ? iwConfig.getAnalyzer().getClass().getName() : "null";
        iwConfigResponse.ramBufferSizeMB = iwConfig.getRAMBufferSizeMB();
        iwConfigResponse.maxBufferedDocs = iwConfig.getMaxBufferedDocs();
        iwConfigResponse.mergedSegmentWarmer = String.valueOf(iwConfig.getMergedSegmentWarmer());
        iwConfigResponse.delPolicy = iwConfig.getIndexDeletionPolicy().getClass().getName();
        iwConfigResponse.commit = String.valueOf(iwConfig.getIndexCommit());
        iwConfigResponse.openMode = String.valueOf(iwConfig.getOpenMode());
        iwConfigResponse.similarity = iwConfig.getSimilarity().getClass().getName();
        iwConfigResponse.mergeScheduler = String.valueOf(iwConfig.getMergeScheduler());
        iwConfigResponse.codec = String.valueOf(iwConfig.getCodec());
        iwConfigResponse.infoStream = iwConfig.getInfoStream().getClass().getName();
        iwConfigResponse.mergePolicy = String.valueOf(iwConfig.getMergePolicy());
        iwConfigResponse.readerPooling = iwConfig.getReaderPooling();
        iwConfigResponse.perThreadHardLimitMB = iwConfig.getRAMPerThreadHardLimitMB();
        iwConfigResponse.useCompoundFile = iwConfig.getUseCompoundFile();
        iwConfigResponse.commitOnClose = iwConfig.getCommitOnClose();
        iwConfigResponse.indexSort = String.valueOf(iwConfig.getIndexSort());
        iwConfigResponse.checkPendingFlushOnUpdate = iwConfig.isCheckPendingFlushOnUpdate();
        iwConfigResponse.softDeletesField = iwConfig.getSoftDeletesField();
        iwConfigResponse.maxFullFlushMergeWaitMillis = iwConfig.getMaxFullFlushMergeWaitMillis();
        iwConfigResponse.leafSorter = String.valueOf(iwConfig.getLeafSorter());
        iwConfigResponse.eventListener = String.valueOf(iwConfig.getIndexWriterEventListener());
        iwConfigResponse.parentField = iwConfig.getParentField();
        return iwConfigResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getMergeInformation(SolrQueryRequest req, SegmentInfos infos, List<String> mergeCandidates) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RefCounted<IndexWriter> refCounted = req.getCore().getSolrCoreState().getIndexWriter(req.getCore());
        try {
            MergePolicy mp;
            MergePolicy.MergeSpecification findMerges;
            IndexWriter indexWriter = refCounted.get();
            if (indexWriter instanceof SolrIndexWriter) {
                result.putAll(((SolrIndexWriter)indexWriter).getRunningMerges());
            }
            if ((findMerges = (mp = indexWriter.getConfig().getMergePolicy()).findMerges(MergeTrigger.EXPLICIT, infos, (MergePolicy.MergeContext)indexWriter)) != null && findMerges.merges != null && findMerges.merges.size() > 0) {
                for (MergePolicy.OneMerge merge : findMerges.merges) {
                    for (SegmentCommitInfo mergeSegmentInfo : merge.segments) {
                        mergeCandidates.add(mergeSegmentInfo.info.name);
                    }
                }
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            refCounted.decref();
        }
    }

    private GetSegmentDataResponse.SingleSegmentData getSegmentInfo(SegmentCommitInfo segmentCommitInfo, boolean withSizeInfo, boolean withFieldInfos, List<LeafReaderContext> leafContexts, IndexSchema schema) throws IOException {
        LeafMetaData metaData;
        GetSegmentDataResponse.SingleSegmentData segmentInfo = new GetSegmentDataResponse.SingleSegmentData();
        segmentInfo.name = segmentCommitInfo.info.name;
        segmentInfo.delCount = segmentCommitInfo.getDelCount();
        segmentInfo.softDelCount = segmentCommitInfo.getSoftDelCount();
        segmentInfo.hasFieldUpdates = segmentCommitInfo.hasFieldUpdates();
        segmentInfo.sizeInBytes = segmentCommitInfo.sizeInBytes();
        segmentInfo.size = segmentCommitInfo.info.maxDoc();
        Long timestamp = Long.parseLong((String)segmentCommitInfo.info.getDiagnostics().get("timestamp"));
        segmentInfo.age = new Date(timestamp);
        segmentInfo.source = (String)segmentCommitInfo.info.getDiagnostics().get("source");
        segmentInfo.version = segmentCommitInfo.info.getVersion().toString();
        SegmentReader seg = null;
        for (LeafReaderContext lrc : leafContexts) {
            LeafReader leafReader = lrc.reader();
            if (!((leafReader = FilterLeafReader.unwrap((LeafReader)leafReader)) instanceof SegmentReader)) continue;
            SegmentReader sr = (SegmentReader)leafReader;
            if (!sr.getSegmentInfo().info.equals((Object)segmentCommitInfo.info)) continue;
            seg = sr;
            break;
        }
        if (seg != null && (metaData = seg.getMetaData()) != null) {
            segmentInfo.createdVersionMajor = metaData.getCreatedVersionMajor();
            segmentInfo.minVersion = metaData.getMinVersion().toString();
            if (metaData.getSort() != null) {
                segmentInfo.sort = metaData.getSort().toString();
            }
        }
        if (!segmentCommitInfo.info.getDiagnostics().isEmpty()) {
            segmentInfo.diagnostics = (GetSegmentDataResponse.SegmentDiagnosticInfo)SolrJacksonMapper.getObjectMapper().convertValue((Object)segmentCommitInfo.info.getDiagnostics(), GetSegmentDataResponse.SegmentDiagnosticInfo.class);
        }
        if (!segmentCommitInfo.info.getAttributes().isEmpty()) {
            segmentInfo.attributes = segmentCommitInfo.info.getAttributes();
        }
        if (withSizeInfo) {
            Directory dir = segmentCommitInfo.info.dir;
            List files = segmentCommitInfo.files().stream().map(f -> {
                long size = -1L;
                try {
                    size = dir.fileLength(f);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new Pair(f, (Object)size);
            }).sorted((p1, p2) -> {
                if ((Long)p1.second() > (Long)p2.second()) {
                    return -1;
                }
                if ((Long)p1.second() < (Long)p2.second()) {
                    return 1;
                }
                return 0;
            }).collect(Collectors.toList());
            if (!files.isEmpty()) {
                HashMap<String, String> topFiles = new HashMap<String, String>();
                for (int i = 0; i < Math.min(files.size(), 5); ++i) {
                    Pair p = (Pair)files.get(i);
                    topFiles.put((String)p.first(), RamUsageEstimator.humanReadableUnits((long)((Long)p.second())));
                }
                segmentInfo.largestFilesByName = topFiles;
            }
        }
        if (withFieldInfos) {
            if (seg == null) {
                log.debug("Skipping segment info - not available as a SegmentReader: {}", (Object)segmentCommitInfo);
            } else {
                FieldInfos fis = seg.getFieldInfos();
                HashMap<String, GetSegmentDataResponse.SegmentSingleFieldInfo> fields = new HashMap<String, GetSegmentDataResponse.SegmentSingleFieldInfo>();
                for (FieldInfo fi : fis) {
                    fields.put(fi.name, this.getFieldInfo(seg, fi, schema));
                }
                segmentInfo.fields = fields;
            }
        }
        return segmentInfo;
    }

    private GetSegmentDataResponse.SegmentSingleFieldInfo getFieldInfo(SegmentReader reader, FieldInfo fi, IndexSchema schema) {
        boolean hasPoints;
        GetSegmentDataResponse.SegmentSingleFieldInfo responseFieldInfo = new GetSegmentDataResponse.SegmentSingleFieldInfo();
        StringBuilder flags = new StringBuilder();
        IndexOptions opts = fi.getIndexOptions();
        flags.append(opts != IndexOptions.NONE ? (char)FieldFlag.INDEXED.getAbbreviation() : (char)'-');
        DocValuesType dvt = fi.getDocValuesType();
        if (dvt != DocValuesType.NONE) {
            flags.append(FieldFlag.DOC_VALUES.getAbbreviation());
            switch (dvt) {
                case NUMERIC: {
                    flags.append("num");
                    break;
                }
                case BINARY: {
                    flags.append("bin");
                    break;
                }
                case SORTED: {
                    flags.append("srt");
                    break;
                }
                case SORTED_NUMERIC: {
                    flags.append("srn");
                    break;
                }
                case SORTED_SET: {
                    flags.append("srs");
                    break;
                }
                default: {
                    flags.append("???");
                    break;
                }
            }
        } else {
            flags.append("----");
        }
        flags.append(fi.hasVectors() ? (char)FieldFlag.TERM_VECTOR_STORED.getAbbreviation() : (char)'-');
        flags.append(fi.omitsNorms() ? (char)FieldFlag.OMIT_NORMS.getAbbreviation() : (char)'-');
        flags.append(IndexOptions.DOCS == opts ? (char)FieldFlag.OMIT_TF.getAbbreviation() : (char)'-');
        flags.append(IndexOptions.DOCS_AND_FREQS == opts ? (char)FieldFlag.OMIT_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS == opts ? (char)FieldFlag.STORE_OFFSETS_WITH_POSITIONS.getAbbreviation() : (char)'-');
        flags.append(fi.hasPayloads() ? "p" : "-");
        flags.append(fi.isSoftDeletesField() ? "s" : "-");
        if (fi.getPointDimensionCount() > 0 || fi.getPointIndexDimensionCount() > 0) {
            flags.append(":");
            flags.append(fi.getPointDimensionCount()).append(':');
            flags.append(fi.getPointIndexDimensionCount()).append(':');
            flags.append(fi.getPointNumBytes());
        }
        responseFieldInfo.flags = flags.toString();
        try {
            Terms terms = reader.terms(fi.name);
            if (terms != null) {
                responseFieldInfo.docCount = terms.getDocCount();
                responseFieldInfo.termCount = terms.size();
                responseFieldInfo.sumDocFreq = terms.getSumDocFreq();
                responseFieldInfo.sumTotalTermFreq = terms.getSumTotalTermFreq();
            }
        }
        catch (Exception e) {
            log.debug("Exception retrieving term stats for field {}", (Object)fi.name, (Object)e);
        }
        SchemaField sf = schema.getFieldOrNull(fi.name);
        boolean bl = hasPoints = fi.getPointDimensionCount() > 0 || fi.getPointIndexDimensionCount() > 0;
        if (sf != null) {
            responseFieldInfo.schemaType = sf.getType().getTypeName();
            HashMap<String, Object> nonCompliant = new HashMap<String, Object>();
            if (sf.hasDocValues() && fi.getDocValuesType() == DocValuesType.NONE && fi.getIndexOptions() != IndexOptions.NONE) {
                nonCompliant.put("docValues", "schema=" + String.valueOf((Object)sf.getType().getUninversionType(sf)) + ", segment=false");
            }
            if (!sf.hasDocValues() && fi.getDocValuesType() != DocValuesType.NONE) {
                nonCompliant.put("docValues", "schema=false, segment=" + fi.getDocValuesType().toString());
            }
            if (!sf.isPolyField() && sf.indexed() != (fi.getIndexOptions() != IndexOptions.NONE || hasPoints)) {
                nonCompliant.put("indexed", "schema=" + sf.indexed() + ", segment=" + String.valueOf(fi.getIndexOptions()));
            }
            if (!hasPoints && sf.omitNorms() != fi.omitsNorms()) {
                nonCompliant.put("omitNorms", "schema=" + sf.omitNorms() + ", segment=" + fi.omitsNorms());
            }
            if (sf.storeTermVector() != fi.hasVectors()) {
                nonCompliant.put("termVectors", "schema=" + sf.storeTermVector() + ", segment=" + fi.hasVectors());
            }
            if (sf.storeOffsetsWithPositions() != (fi.getIndexOptions() == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS)) {
                nonCompliant.put("storeOffsetsWithPositions", "schema=" + sf.storeOffsetsWithPositions() + ", segment=" + String.valueOf(fi.getIndexOptions()));
            }
            if (nonCompliant.size() > 0) {
                nonCompliant.put("schemaField", sf.toString());
                responseFieldInfo.nonCompliant = nonCompliant;
            }
        } else {
            responseFieldInfo.schemaType = "(UNKNOWN)";
        }
        return responseFieldInfo;
    }
}

