/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core.backup;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Version;
import org.apache.solr.core.backup.BackupFilePaths;
import org.apache.solr.core.backup.BackupId;
import org.apache.solr.core.backup.ShardBackupId;
import org.apache.solr.core.backup.repository.BackupRepository;
import org.apache.solr.util.PropertiesInputStream;

public class BackupProperties {
    private static final String EXTRA_PROPERTY_PREFIX = "property.";
    private double indexSizeMB;
    private int indexFileCount;
    private final Properties properties;
    private final Map<String, String> extraProperties;

    private BackupProperties(Properties properties, Map<String, String> extraProperties) {
        this.properties = properties;
        if (extraProperties == null) {
            extraProperties = Map.of();
        } else if (extraProperties.keySet().stream().anyMatch(String::isEmpty)) {
            throw new IllegalArgumentException("Can't have an extra property with an empty key");
        }
        this.extraProperties = extraProperties;
    }

    public static BackupProperties create(String backupName, String collectionName, String extCollectionName, String configName, Map<String, String> extraProperties) {
        Properties properties = new Properties();
        properties.put("backupName", backupName);
        properties.put("collection", collectionName);
        properties.put("collectionAlias", extCollectionName);
        properties.put("collection.configName", configName);
        properties.put("startTime", Instant.now().toString());
        properties.put("indexVersion", Version.LATEST.toString());
        return new BackupProperties(properties, extraProperties);
    }

    public static Optional<BackupProperties> readFromLatest(BackupRepository repository, URI backupPath) throws IOException {
        Optional<BackupId> lastBackupId = BackupFilePaths.findMostRecentBackupIdFromFileListing(repository.listAllOrEmpty(backupPath));
        if (!lastBackupId.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(BackupProperties.readFrom(repository, backupPath, BackupFilePaths.getBackupPropsName(lastBackupId.get())));
    }

    public static BackupProperties readFrom(BackupRepository repository, URI backupPath, String fileName) throws IOException {
        Properties props = new Properties();
        try (InputStreamReader is = new InputStreamReader((InputStream)new PropertiesInputStream(repository.openInput(backupPath, fileName, IOContext.DEFAULT)), StandardCharsets.UTF_8);){
            props.load(is);
            Map<String, String> extraProperties = BackupProperties.extractExtraProperties(props);
            BackupProperties backupProperties = new BackupProperties(props, extraProperties);
            return backupProperties;
        }
    }

    private static Map<String, String> extractExtraProperties(Properties props) {
        HashMap<String, String> extraProperties = new HashMap<String, String>();
        props.entrySet().removeIf(e -> {
            String entryKey = e.getKey().toString();
            if (entryKey.startsWith(EXTRA_PROPERTY_PREFIX)) {
                extraProperties.put(entryKey.substring(EXTRA_PROPERTY_PREFIX.length()), String.valueOf(e.getValue()));
                return true;
            }
            return false;
        });
        return extraProperties;
    }

    public List<String> getAllShardBackupMetadataFiles() {
        return this.properties.entrySet().stream().filter(entry -> entry.getKey().toString().endsWith(".md")).map(entry -> entry.getValue().toString()).collect(Collectors.toList());
    }

    public void countIndexFiles(int numFiles, double sizeMB) {
        this.indexSizeMB += sizeMB;
        this.indexFileCount += numFiles;
    }

    public Optional<ShardBackupId> getShardBackupIdFor(String shardName) {
        String key = this.getKeyForShardBackupId(shardName);
        if (this.properties.containsKey(key)) {
            return Optional.of(ShardBackupId.fromShardMetadataFilename(this.properties.getProperty(key)));
        }
        return Optional.empty();
    }

    public ShardBackupId putAndGetShardBackupIdFor(String shardName, int backupId) {
        ShardBackupId shardBackupId = new ShardBackupId(shardName, new BackupId(backupId));
        this.properties.put(this.getKeyForShardBackupId(shardName), shardBackupId.getBackupMetadataFilename());
        return shardBackupId;
    }

    private String getKeyForShardBackupId(String shardName) {
        return shardName + ".md";
    }

    public void store(Writer propsWriter) throws IOException {
        Properties propertiesCopy = (Properties)this.properties.clone();
        propertiesCopy.put("indexSizeMB", String.valueOf(this.indexSizeMB));
        propertiesCopy.put("indexFileCount", String.valueOf(this.indexFileCount));
        propertiesCopy.put("endTime", Instant.now().toString());
        if (this.extraProperties != null && !this.extraProperties.isEmpty()) {
            this.extraProperties.forEach((k, v) -> propertiesCopy.put(EXTRA_PROPERTY_PREFIX + k, v));
        }
        propertiesCopy.store(propsWriter, "Backup properties file");
    }

    public String getCollection() {
        return this.properties.getProperty("collection");
    }

    public String getCollectionAlias() {
        return this.properties.getProperty("collectionAlias");
    }

    public String getConfigName() {
        return this.properties.getProperty("collection.configName");
    }

    public String getStartTime() {
        return this.properties.getProperty("startTime");
    }

    public String getEndTime() {
        return this.properties.getProperty("endTime");
    }

    public String getIndexVersion() {
        return this.properties.getProperty("indexVersion");
    }

    public Map<String, String> getExtraProperties() {
        return this.extraProperties;
    }

    public Map<String, Object> getDetails() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.properties.entrySet().forEach(entry -> result.put(entry.getKey().toString(), entry.getValue()));
        result.remove("backupName");
        result.remove("collection");
        result.put("indexSizeMB", Double.valueOf(this.properties.getProperty("indexSizeMB")));
        result.put("indexFileCount", Integer.valueOf(this.properties.getProperty("indexFileCount")));
        if (this.extraProperties != null && !this.extraProperties.isEmpty()) {
            result.put("extraProperties", this.extraProperties);
        }
        HashMap<String, String> shardBackupIds = new HashMap<String, String>();
        Iterator keyIt = result.keySet().iterator();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            if (!key.endsWith(".md")) continue;
            shardBackupIds.put(key.substring(0, key.length() - 3), this.properties.getProperty(key));
            keyIt.remove();
        }
        result.put("shardBackupIds", shardBackupIds);
        return result;
    }

    public String getBackupName() {
        return this.properties.getProperty("backupName");
    }
}

