/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.common.cloud.SolrZkClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkLsTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkLsTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_RECURSE_DEPRECATED, SolrCLI.OPTION_RECURSIVE, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public String getName() {
        return "ls";
    }

    @Override
    public String getUsage() {
        return "bin/solr zk ls [-r ] [-s <HOST>] [-u <credentials>] [-v] [-z <HOST>] path";
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        String znode = cli.getArgs()[0];
        try (SolrZkClient zkClient = SolrCLI.getSolrZkClient(cli, zkHost);){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            boolean recursive = cli.hasOption("recursive") || cli.hasOption("recurse");
            this.echoIfVerbose("Getting listing for ZooKeeper node " + znode + " from ZooKeeper at " + zkHost + " recursive: " + recursive, cli);
            this.runtime.print(zkClient.listZnode(znode, Boolean.valueOf(recursive)));
        }
        catch (Exception e) {
            log.error("Could not complete ls operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

