"""Add DQ Summary

Revision ID: 436f8bb22192
Revises: b4b8a9957556
Create Date: 2025-01-28 17:10:37.091847

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '436f8bb22192'
down_revision: Union[str, None] = 'b4b8a9957556'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('dq_summary',
    sa.Column('id', sa.Integer(), autoincrement=False, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('(CURRENT_TIMESTAMP)'), nullable=True),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), nullable=True),
    sa.Column('summary', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_dq_summary_id'), 'dq_summary', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_dq_summary_id'), table_name='dq_summary')
    op.drop_table('dq_summary')
    # ### end Alembic commands ###
