/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.name.FqName;

@PhaseDescription(name="RepeatedAnnotation")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J&\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00132\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/RepeatedAnnotationLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitFile", "declaration", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "transformAnnotations", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "annotations", "getOrCreateContainerClass", "annotationClass", "wrapAnnotationEntriesInContainer", "containerClass", "entries", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nRepeatedAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepeatedAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RepeatedAnnotationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n1516#2,3:136\n1519#2,3:146\n2746#2,3:149\n382#3,7:139\n1#4:152\n*S KotlinDebug\n*F\n+ 1 RepeatedAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/RepeatedAnnotationLowering\n*L\n86#1:136,3\n86#1:146,3\n87#1:149,3\n86#1:139,7\n*E\n"})
public final class RepeatedAnnotationLowering
extends IrVisitorVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public RepeatedAnnotationLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptVoid((IrElement)irFile, this);
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        IrVisitorsKt.acceptChildrenVoid(element, this);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        declaration.setAnnotations(this.transformAnnotations(declaration.getAnnotations()));
        super.visitFile(declaration);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        declaration.setAnnotations(this.transformAnnotations(declaration.getAnnotations()));
        super.visitDeclaration(declaration);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.getKind() == ClassKind.ANNOTATION_CLASS && IrUtilsKt.hasAnnotation((IrAnnotationContainer)declaration, StandardNames.FqNames.repeatable)) {
            IrAnnotationContainer irAnnotationContainer = declaration;
            FqName fqName = JvmAnnotationNames.REPEATABLE_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"REPEATABLE_ANNOTATION");
            if (!IrUtilsKt.hasAnnotation(irAnnotationContainer, fqName)) {
                declaration.getDeclarations().add(this.context.getCachedDeclarations().getRepeatedAnnotationSyntheticContainer(declaration));
            }
        }
        super.visitClass(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrConstructorCall> transformAnnotations(List<? extends IrConstructorCall> annotations2) {
        boolean bl;
        void annotationsByClass;
        block11: {
            void destination$iv;
            void $this$groupByTo$iv;
            if (!this.context.getState().getClassBuilderMode().generateBodies) {
                return annotations2;
            }
            if (annotations2.size() < 2) {
                return annotations2;
            }
            Iterable iterable = annotations2;
            Map map = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv : $this$groupByTo$iv) {
                Object object;
                void $this$getOrPut$iv$iv;
                IrConstructorCall it = (IrConstructorCall)element$iv;
                boolean bl2 = false;
                IrClass key$iv = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)it.getSymbol().getOwner());
                void var11_16 = destination$iv;
                IrClass key$iv$iv = key$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv$iv);
                if (value$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                    object = answer$iv$iv;
                } else {
                    object = value$iv$iv;
                }
                List list$iv = (List)object;
                list$iv.add(element$iv);
            }
            annotationsByClass = destination$iv;
            Iterable $this$none$iv = annotationsByClass.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    List it = (List)element$iv;
                    boolean bl4 = false;
                    if (!(it.size() > 1)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return annotations2;
        }
        List result2 = new ArrayList();
        for (IrConstructorCall annotation : annotations2) {
            List grouped2;
            IrClass annotationClass = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)annotation.getSymbol().getOwner());
            if ((List)annotationsByClass.remove(annotationClass) == null) continue;
            if (grouped2.size() < 2) {
                result2.add(CollectionsKt.single((List)grouped2));
                continue;
            }
            IrClass containerClass = this.getOrCreateContainerClass(annotationClass);
            result2.add(this.wrapAnnotationEntriesInContainer(annotationClass, containerClass, grouped2));
        }
        return result2;
    }

    private final IrClass getOrCreateContainerClass(IrClass annotationClass) {
        Object object;
        Object v1;
        block5: {
            List<IrConstructorCall> metaAnnotations = annotationClass.getAnnotations();
            Iterable iterable = metaAnnotations;
            for (Object t2 : iterable) {
                IrConstructorCall it = (IrConstructorCall)t2;
                boolean bl = false;
                FqName fqName = JvmAnnotationNames.REPEATABLE_ANNOTATION;
                Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"REPEATABLE_ANNOTATION");
                if (!IrUtilsKt.isAnnotation(it, fqName)) continue;
                v1 = t2;
                break block5;
            }
            v1 = null;
        }
        IrConstructorCall jvmRepeatable = v1;
        if (jvmRepeatable != null) {
            IrExpression containerClassReference = (IrExpression)jvmRepeatable.getArguments().get(0);
            if (!(containerClassReference instanceof IrClassReference)) {
                boolean bl = false;
                String string = "Repeatable annotation container value must be a class reference: " + annotationClass;
                throw new IllegalArgumentException(string.toString());
            }
            IrClassifierSymbol irClassifierSymbol = ((IrClassReference)containerClassReference).getSymbol();
            object = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (object == null || (object = (IrClass)object.getOwner()) == null) {
                throw new IllegalStateException(("Repeatable annotation container must be a class: " + annotationClass).toString());
            }
        } else {
            object = this.context.getCachedDeclarations().getRepeatedAnnotationSyntheticContainer(annotationClass);
        }
        return object;
    }

    private final IrConstructorCall wrapAnnotationEntriesInContainer(IrClass annotationClass, IrClass containerClass, List<? extends IrConstructorCall> entries) {
        IrConstructorCallImpl irConstructorCallImpl;
        IrSimpleType annotationType = IrTypesKt.typeWith(annotationClass, new IrType[0]);
        IrType irType = IrUtilsKt.getDefaultType(containerClass);
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(containerClass);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructorCallImpl $this$wrapAnnotationEntriesInContainer_u24lambda_u240 = irConstructorCallImpl = BuildersKt.fromSymbolOwner$default(IrConstructorCallImpl.Companion, irType, irConstructor.getSymbol(), null, 4, null);
        boolean bl = false;
        IrType[] irTypeArray = new IrType[]{annotationType};
        $this$wrapAnnotationEntriesInContainer_u24lambda_u240.getArguments().set(0, BuildersKt.IrVarargImpl(-1, -1, IrTypesKt.typeWith((IrClassifierSymbol)this.context.getIrBuiltIns().getArrayClass(), irTypeArray), annotationType, entries));
        return irConstructorCallImpl;
    }
}

