/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.signatures;

import java.io.File;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerificationConfiguration;
import org.gradle.security.internal.KeyringFilePublicKeyService;
import org.gradle.security.internal.PublicKeyService;
import org.gradle.security.internal.PublicKeyServiceChain;
import org.jspecify.annotations.Nullable;

public class BuildTreeDefinedKeys {
    private static final String VERIFICATION_KEYRING_GPG = "verification-keyring.gpg";
    private static final String VERIFICATION_KEYRING_ASCII = "verification-keyring.keys";
    private final KeyringFilePublicKeyService keyService;
    private final File keyringsRoot;
    private final File effectiveKeyringsFile;

    public BuildTreeDefinedKeys(File keyringsRoot,  @Nullable DependencyVerificationConfiguration.KeyringFormat effectiveFormat) {
        File effectiveFile;
        this.keyringsRoot = keyringsRoot;
        if (effectiveFormat == DependencyVerificationConfiguration.KeyringFormat.ARMORED) {
            effectiveFile = this.getAsciiKeyringsFile();
        } else if (effectiveFormat == DependencyVerificationConfiguration.KeyringFormat.BINARY) {
            effectiveFile = this.getBinaryKeyringsFile();
        } else if (effectiveFormat == null) {
            effectiveFile = this.getBinaryKeyringsFile();
            if (!effectiveFile.exists()) {
                effectiveFile = this.getAsciiKeyringsFile();
            }
        } else {
            throw new IllegalArgumentException("Unknown keyring format: " + (Object)((Object)effectiveFormat));
        }
        this.effectiveKeyringsFile = effectiveFile;
        this.keyService = effectiveFile.exists() ? new KeyringFilePublicKeyService(this.effectiveKeyringsFile) : null;
    }

    public File getBinaryKeyringsFile() {
        return new File(this.keyringsRoot, VERIFICATION_KEYRING_GPG);
    }

    public File getAsciiKeyringsFile() {
        return new File(this.keyringsRoot, VERIFICATION_KEYRING_ASCII);
    }

    public File getEffectiveKeyringsFile() {
        return this.effectiveKeyringsFile;
    }

    public PublicKeyService applyTo(PublicKeyService original) {
        if (this.keyService != null) {
            return PublicKeyServiceChain.of((PublicKeyService[])new PublicKeyService[]{this.keyService, original});
        }
        return original;
    }
}

