﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/quicksight/QuickSight_EXPORTS.h>
#include <aws/quicksight/model/ColumnIdentifier.h>
#include <aws/quicksight/model/NumberFormatConfiguration.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace QuickSight {
namespace Model {

/**
 * <p>The dimension type field with numerical type columns.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/NumericalDimensionField">AWS
 * API Reference</a></p>
 */
class NumericalDimensionField {
 public:
  AWS_QUICKSIGHT_API NumericalDimensionField() = default;
  AWS_QUICKSIGHT_API NumericalDimensionField(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API NumericalDimensionField& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_QUICKSIGHT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The custom field ID.</p>
   */
  inline const Aws::String& GetFieldId() const { return m_fieldId; }
  inline bool FieldIdHasBeenSet() const { return m_fieldIdHasBeenSet; }
  template <typename FieldIdT = Aws::String>
  void SetFieldId(FieldIdT&& value) {
    m_fieldIdHasBeenSet = true;
    m_fieldId = std::forward<FieldIdT>(value);
  }
  template <typename FieldIdT = Aws::String>
  NumericalDimensionField& WithFieldId(FieldIdT&& value) {
    SetFieldId(std::forward<FieldIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The column that is used in the <code>NumericalDimensionField</code>.</p>
   */
  inline const ColumnIdentifier& GetColumn() const { return m_column; }
  inline bool ColumnHasBeenSet() const { return m_columnHasBeenSet; }
  template <typename ColumnT = ColumnIdentifier>
  void SetColumn(ColumnT&& value) {
    m_columnHasBeenSet = true;
    m_column = std::forward<ColumnT>(value);
  }
  template <typename ColumnT = ColumnIdentifier>
  NumericalDimensionField& WithColumn(ColumnT&& value) {
    SetColumn(std::forward<ColumnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The custom hierarchy ID.</p>
   */
  inline const Aws::String& GetHierarchyId() const { return m_hierarchyId; }
  inline bool HierarchyIdHasBeenSet() const { return m_hierarchyIdHasBeenSet; }
  template <typename HierarchyIdT = Aws::String>
  void SetHierarchyId(HierarchyIdT&& value) {
    m_hierarchyIdHasBeenSet = true;
    m_hierarchyId = std::forward<HierarchyIdT>(value);
  }
  template <typename HierarchyIdT = Aws::String>
  NumericalDimensionField& WithHierarchyId(HierarchyIdT&& value) {
    SetHierarchyId(std::forward<HierarchyIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The format configuration of the field.</p>
   */
  inline const NumberFormatConfiguration& GetFormatConfiguration() const { return m_formatConfiguration; }
  inline bool FormatConfigurationHasBeenSet() const { return m_formatConfigurationHasBeenSet; }
  template <typename FormatConfigurationT = NumberFormatConfiguration>
  void SetFormatConfiguration(FormatConfigurationT&& value) {
    m_formatConfigurationHasBeenSet = true;
    m_formatConfiguration = std::forward<FormatConfigurationT>(value);
  }
  template <typename FormatConfigurationT = NumberFormatConfiguration>
  NumericalDimensionField& WithFormatConfiguration(FormatConfigurationT&& value) {
    SetFormatConfiguration(std::forward<FormatConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_fieldId;

  ColumnIdentifier m_column;

  Aws::String m_hierarchyId;

  NumberFormatConfiguration m_formatConfiguration;
  bool m_fieldIdHasBeenSet = false;
  bool m_columnHasBeenSet = false;
  bool m_hierarchyIdHasBeenSet = false;
  bool m_formatConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace QuickSight
}  // namespace Aws
