﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/entityresolution/EntityResolution_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EntityResolution {
namespace Model {

/**
 * <p>An object containing <code>inputSourceARN</code>, <code>schemaName</code>,
 * and <code>applyNormalization</code>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/entityresolution-2018-05-10/InputSource">AWS
 * API Reference</a></p>
 */
class InputSource {
 public:
  AWS_ENTITYRESOLUTION_API InputSource() = default;
  AWS_ENTITYRESOLUTION_API InputSource(Aws::Utils::Json::JsonView jsonValue);
  AWS_ENTITYRESOLUTION_API InputSource& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ENTITYRESOLUTION_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>An Glue table Amazon Resource Name (ARN) for the input source table.</p>
   */
  inline const Aws::String& GetInputSourceARN() const { return m_inputSourceARN; }
  inline bool InputSourceARNHasBeenSet() const { return m_inputSourceARNHasBeenSet; }
  template <typename InputSourceARNT = Aws::String>
  void SetInputSourceARN(InputSourceARNT&& value) {
    m_inputSourceARNHasBeenSet = true;
    m_inputSourceARN = std::forward<InputSourceARNT>(value);
  }
  template <typename InputSourceARNT = Aws::String>
  InputSource& WithInputSourceARN(InputSourceARNT&& value) {
    SetInputSourceARN(std::forward<InputSourceARNT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the schema to be retrieved.</p>
   */
  inline const Aws::String& GetSchemaName() const { return m_schemaName; }
  inline bool SchemaNameHasBeenSet() const { return m_schemaNameHasBeenSet; }
  template <typename SchemaNameT = Aws::String>
  void SetSchemaName(SchemaNameT&& value) {
    m_schemaNameHasBeenSet = true;
    m_schemaName = std::forward<SchemaNameT>(value);
  }
  template <typename SchemaNameT = Aws::String>
  InputSource& WithSchemaName(SchemaNameT&& value) {
    SetSchemaName(std::forward<SchemaNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Normalizes the attributes defined in the schema in the input data. For
   * example, if an attribute has an <code>AttributeType</code> of
   * <code>PHONE_NUMBER</code>, and the data in the input table is in a format of
   * 1234567890, Entity Resolution will normalize this field in the output to
   * (123)-456-7890.</p>
   */
  inline bool GetApplyNormalization() const { return m_applyNormalization; }
  inline bool ApplyNormalizationHasBeenSet() const { return m_applyNormalizationHasBeenSet; }
  inline void SetApplyNormalization(bool value) {
    m_applyNormalizationHasBeenSet = true;
    m_applyNormalization = value;
  }
  inline InputSource& WithApplyNormalization(bool value) {
    SetApplyNormalization(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_inputSourceARN;

  Aws::String m_schemaName;

  bool m_applyNormalization{false};
  bool m_inputSourceARNHasBeenSet = false;
  bool m_schemaNameHasBeenSet = false;
  bool m_applyNormalizationHasBeenSet = false;
};

}  // namespace Model
}  // namespace EntityResolution
}  // namespace Aws
