﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/entityresolution/EntityResolution_EXPORTS.h>
#include <aws/entityresolution/model/SchemaInputAttribute.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace EntityResolution {
namespace Model {
class CreateSchemaMappingResult {
 public:
  AWS_ENTITYRESOLUTION_API CreateSchemaMappingResult() = default;
  AWS_ENTITYRESOLUTION_API CreateSchemaMappingResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ENTITYRESOLUTION_API CreateSchemaMappingResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The name of the schema.</p>
   */
  inline const Aws::String& GetSchemaName() const { return m_schemaName; }
  template <typename SchemaNameT = Aws::String>
  void SetSchemaName(SchemaNameT&& value) {
    m_schemaNameHasBeenSet = true;
    m_schemaName = std::forward<SchemaNameT>(value);
  }
  template <typename SchemaNameT = Aws::String>
  CreateSchemaMappingResult& WithSchemaName(SchemaNameT&& value) {
    SetSchemaName(std::forward<SchemaNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN (Amazon Resource Name) that Entity Resolution generated for the
   * <code>SchemaMapping</code>.</p>
   */
  inline const Aws::String& GetSchemaArn() const { return m_schemaArn; }
  template <typename SchemaArnT = Aws::String>
  void SetSchemaArn(SchemaArnT&& value) {
    m_schemaArnHasBeenSet = true;
    m_schemaArn = std::forward<SchemaArnT>(value);
  }
  template <typename SchemaArnT = Aws::String>
  CreateSchemaMappingResult& WithSchemaArn(SchemaArnT&& value) {
    SetSchemaArn(std::forward<SchemaArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A description of the schema.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  CreateSchemaMappingResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code>
   * corresponds to a column the source data table, and contains column name plus
   * additional information that Entity Resolution uses for matching.</p>
   */
  inline const Aws::Vector<SchemaInputAttribute>& GetMappedInputFields() const { return m_mappedInputFields; }
  template <typename MappedInputFieldsT = Aws::Vector<SchemaInputAttribute>>
  void SetMappedInputFields(MappedInputFieldsT&& value) {
    m_mappedInputFieldsHasBeenSet = true;
    m_mappedInputFields = std::forward<MappedInputFieldsT>(value);
  }
  template <typename MappedInputFieldsT = Aws::Vector<SchemaInputAttribute>>
  CreateSchemaMappingResult& WithMappedInputFields(MappedInputFieldsT&& value) {
    SetMappedInputFields(std::forward<MappedInputFieldsT>(value));
    return *this;
  }
  template <typename MappedInputFieldsT = SchemaInputAttribute>
  CreateSchemaMappingResult& AddMappedInputFields(MappedInputFieldsT&& value) {
    m_mappedInputFieldsHasBeenSet = true;
    m_mappedInputFields.emplace_back(std::forward<MappedInputFieldsT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateSchemaMappingResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_schemaName;

  Aws::String m_schemaArn;

  Aws::String m_description;

  Aws::Vector<SchemaInputAttribute> m_mappedInputFields;

  Aws::String m_requestId;
  bool m_schemaNameHasBeenSet = false;
  bool m_schemaArnHasBeenSet = false;
  bool m_descriptionHasBeenSet = false;
  bool m_mappedInputFieldsHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace EntityResolution
}  // namespace Aws
