//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_IMAGING_USD_RENDER_SETTINGS_SCHEMA_H
#define PXR_USD_IMAGING_USD_IMAGING_USD_RENDER_SETTINGS_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_IMAGING_USD_RENDER_SETTINGS_SCHEMA_TOKENS \
    (__usdRenderSettings) \
    (resolution) \
    (pixelAspectRatio) \
    (aspectRatioConformPolicy) \
    (dataWindowNDC) \
    (disableMotionBlur) \
    (disableDepthOfField) \
    (camera) \
    (includedPurposes) \
    (materialBindingPurposes) \
    (renderingColorSpace) \
    (products) \
    (namespacedSettings) \

TF_DECLARE_PUBLIC_TOKENS(UsdImagingUsdRenderSettingsSchemaTokens, USDIMAGING_API,
    USD_IMAGING_USD_RENDER_SETTINGS_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class UsdImagingUsdRenderSettingsSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdImagingUsdRenderSettingsSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "__usdRenderSettings" from the parent container and constructs a
    /// UsdImagingUsdRenderSettingsSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDIMAGING_API
    static UsdImagingUsdRenderSettingsSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    USDIMAGING_API
    HdVec2iDataSourceHandle GetResolution() const;

    USDIMAGING_API
    HdFloatDataSourceHandle GetPixelAspectRatio() const;

    USDIMAGING_API
    HdTokenDataSourceHandle GetAspectRatioConformPolicy() const;

    USDIMAGING_API
    HdVec4fDataSourceHandle GetDataWindowNDC() const;

    USDIMAGING_API
    HdBoolDataSourceHandle GetDisableMotionBlur() const;

    USDIMAGING_API
    HdBoolDataSourceHandle GetDisableDepthOfField() const;

    USDIMAGING_API
    HdPathDataSourceHandle GetCamera() const;

    USDIMAGING_API
    HdTokenArrayDataSourceHandle GetIncludedPurposes() const;

    USDIMAGING_API
    HdTokenArrayDataSourceHandle GetMaterialBindingPurposes() const;

    USDIMAGING_API
    HdTokenDataSourceHandle GetRenderingColorSpace() const;

    USDIMAGING_API
    HdPathArrayDataSourceHandle GetProducts() const;

    USDIMAGING_API
    HdContainerDataSourceHandle GetNamespacedSettings() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate resolution.
    USDIMAGING_API
    static const HdDataSourceLocator &GetResolutionLocator();

    /// Prim-level relative data source locator to locate pixelAspectRatio.
    USDIMAGING_API
    static const HdDataSourceLocator &GetPixelAspectRatioLocator();

    /// Prim-level relative data source locator to locate aspectRatioConformPolicy.
    USDIMAGING_API
    static const HdDataSourceLocator &GetAspectRatioConformPolicyLocator();

    /// Prim-level relative data source locator to locate dataWindowNDC.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDataWindowNDCLocator();

    /// Prim-level relative data source locator to locate disableMotionBlur.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDisableMotionBlurLocator();

    /// Prim-level relative data source locator to locate disableDepthOfField.
    USDIMAGING_API
    static const HdDataSourceLocator &GetDisableDepthOfFieldLocator();

    /// Prim-level relative data source locator to locate camera.
    USDIMAGING_API
    static const HdDataSourceLocator &GetCameraLocator();

    /// Prim-level relative data source locator to locate includedPurposes.
    USDIMAGING_API
    static const HdDataSourceLocator &GetIncludedPurposesLocator();

    /// Prim-level relative data source locator to locate materialBindingPurposes.
    USDIMAGING_API
    static const HdDataSourceLocator &GetMaterialBindingPurposesLocator();

    /// Prim-level relative data source locator to locate renderingColorSpace.
    USDIMAGING_API
    static const HdDataSourceLocator &GetRenderingColorSpaceLocator();

    /// Prim-level relative data source locator to locate products.
    USDIMAGING_API
    static const HdDataSourceLocator &GetProductsLocator();

    /// Prim-level relative data source locator to locate namespacedSettings.
    USDIMAGING_API
    static const HdDataSourceLocator &GetNamespacedSettingsLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdVec2iDataSourceHandle &resolution,
        const HdFloatDataSourceHandle &pixelAspectRatio,
        const HdTokenDataSourceHandle &aspectRatioConformPolicy,
        const HdVec4fDataSourceHandle &dataWindowNDC,
        const HdBoolDataSourceHandle &disableMotionBlur,
        const HdBoolDataSourceHandle &disableDepthOfField,
        const HdPathDataSourceHandle &camera,
        const HdTokenArrayDataSourceHandle &includedPurposes,
        const HdTokenArrayDataSourceHandle &materialBindingPurposes,
        const HdTokenDataSourceHandle &renderingColorSpace,
        const HdPathArrayDataSourceHandle &products,
        const HdContainerDataSourceHandle &namespacedSettings
    );

    /// \class UsdImagingUsdRenderSettingsSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDIMAGING_API
        Builder &SetResolution(
            const HdVec2iDataSourceHandle &resolution);
        USDIMAGING_API
        Builder &SetPixelAspectRatio(
            const HdFloatDataSourceHandle &pixelAspectRatio);
        USDIMAGING_API
        Builder &SetAspectRatioConformPolicy(
            const HdTokenDataSourceHandle &aspectRatioConformPolicy);
        USDIMAGING_API
        Builder &SetDataWindowNDC(
            const HdVec4fDataSourceHandle &dataWindowNDC);
        USDIMAGING_API
        Builder &SetDisableMotionBlur(
            const HdBoolDataSourceHandle &disableMotionBlur);
        USDIMAGING_API
        Builder &SetDisableDepthOfField(
            const HdBoolDataSourceHandle &disableDepthOfField);
        USDIMAGING_API
        Builder &SetCamera(
            const HdPathDataSourceHandle &camera);
        USDIMAGING_API
        Builder &SetIncludedPurposes(
            const HdTokenArrayDataSourceHandle &includedPurposes);
        USDIMAGING_API
        Builder &SetMaterialBindingPurposes(
            const HdTokenArrayDataSourceHandle &materialBindingPurposes);
        USDIMAGING_API
        Builder &SetRenderingColorSpace(
            const HdTokenDataSourceHandle &renderingColorSpace);
        USDIMAGING_API
        Builder &SetProducts(
            const HdPathArrayDataSourceHandle &products);
        USDIMAGING_API
        Builder &SetNamespacedSettings(
            const HdContainerDataSourceHandle &namespacedSettings);

        /// Returns a container data source containing the members set thus far.
        USDIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdVec2iDataSourceHandle _resolution;
        HdFloatDataSourceHandle _pixelAspectRatio;
        HdTokenDataSourceHandle _aspectRatioConformPolicy;
        HdVec4fDataSourceHandle _dataWindowNDC;
        HdBoolDataSourceHandle _disableMotionBlur;
        HdBoolDataSourceHandle _disableDepthOfField;
        HdPathDataSourceHandle _camera;
        HdTokenArrayDataSourceHandle _includedPurposes;
        HdTokenArrayDataSourceHandle _materialBindingPurposes;
        HdTokenDataSourceHandle _renderingColorSpace;
        HdPathArrayDataSourceHandle _products;
        HdContainerDataSourceHandle _namespacedSettings;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif