(function() {
    var type_impls = Object.fromEntries([["kernel",[["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Borrow%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#911-918\">Source</a><a href=\"#impl-Borrow%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/borrow/trait.Borrow.html\" title=\"trait core::borrow::Borrow\">Borrow</a>&lt;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3><div class=\"docblock\"><h4 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h4>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">struct </span>Foo&lt;B: Borrow&lt;[u32]&gt;&gt;(B);\n\n<span class=\"comment\">// Owned array.\n</span><span class=\"kw\">let </span>owned_array = Foo([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n\n<span class=\"comment\">// Owned vector.\n</span><span class=\"kw\">let </span>owned_vec = Foo(KVec::from_elem(<span class=\"number\">0</span>, <span class=\"number\">3</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>);\n\n<span class=\"kw\">let </span>arr = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"comment\">// Borrowed slice from `arr`.\n</span><span class=\"kw\">let </span>borrowed_slice = Foo(<span class=\"kw-2\">&amp;</span>arr[..]);</code></pre></div></div></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#915-917\">Source</a><a href=\"#method.borrow\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/borrow/trait.Borrow.html#tymethod.borrow\" class=\"fn\">borrow</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Immutably borrows from an owned value. <a href=\"core/borrow/trait.Borrow.html#tymethod.borrow\">Read more</a></div></details></div></details>","Borrow<[T]>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-BorrowMut%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#937-944\">Source</a><a href=\"#impl-BorrowMut%3C%5BT%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/borrow/trait.BorrowMut.html\" title=\"trait core::borrow::BorrowMut\">BorrowMut</a>&lt;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a>&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3><div class=\"docblock\"><h4 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h4>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">struct </span>Foo&lt;B: BorrowMut&lt;[u32]&gt;&gt;(B);\n\n<span class=\"comment\">// Owned array.\n</span><span class=\"kw\">let </span>owned_array = Foo([<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]);\n\n<span class=\"comment\">// Owned vector.\n</span><span class=\"kw\">let </span>owned_vec = Foo(KVec::from_elem(<span class=\"number\">0</span>, <span class=\"number\">3</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>);\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>arr = [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>];\n<span class=\"comment\">// Borrowed slice from `arr`.\n</span><span class=\"kw\">let </span>borrowed_slice = Foo(<span class=\"kw-2\">&amp;mut </span>arr[..]);</code></pre></div></div></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.borrow_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#941-943\">Source</a><a href=\"#method.borrow_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/borrow/trait.BorrowMut.html#tymethod.borrow_mut\" class=\"fn\">borrow_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Mutably borrows from an owned value. <a href=\"core/borrow/trait.BorrowMut.html#tymethod.borrow_mut\">Read more</a></div></details></div></details>","BorrowMut<[T]>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Debug-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#862-866\">Source</a><a href=\"#impl-Debug-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"kernel/fmt/trait.Debug.html\" title=\"trait kernel::fmt::Debug\">Debug</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"kernel/fmt/trait.Debug.html\" title=\"trait kernel::fmt::Debug\">Debug</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.fmt\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#863-865\">Source</a><a href=\"#method.fmt\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"kernel/fmt/trait.Debug.html#tymethod.fmt\" class=\"fn\">fmt</a>(&amp;self, f: &amp;mut <a class=\"struct\" href=\"kernel/fmt/struct.Formatter.html\" title=\"struct kernel::fmt::Formatter\">Formatter</a>&lt;'_&gt;) -&gt; <a class=\"type\" href=\"kernel/fmt/type.Result.html\" title=\"type kernel::fmt::Result\">Result</a></h4></section></summary><div class='docblock'>Formats the value using the given formatter. <a href=\"kernel/fmt/trait.Debug.html#tymethod.fmt\">Read more</a></div></details></div></details>","Debug","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Default-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#855-860\">Source</a><a href=\"#impl-Default-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"core/default/trait.Default.html\" title=\"trait core::default::Default\">Default</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.default\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#857-859\">Source</a><a href=\"#method.default\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/default/trait.Default.html#tymethod.default\" class=\"fn\">default</a>() -&gt; Self</h4></section></summary><div class='docblock'>Returns the “default value” for a type. <a href=\"core/default/trait.Default.html#tymethod.default\">Read more</a></div></details></div></details>","Default","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Deref-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#868-880\">Source</a><a href=\"#impl-Deref-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/deref/trait.Deref.html\" title=\"trait core::ops::deref::Deref\">Deref</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Target\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#872\">Source</a><a href=\"#associatedtype.Target\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/deref/trait.Deref.html#associatedtype.Target\" class=\"associatedtype\">Target</a> = <a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>The resulting type after dereferencing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#875-879\">Source</a><a href=\"#method.deref\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.Deref.html#tymethod.deref\" class=\"fn\">deref</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Dereferences the value.</div></details></div></details>","Deref","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-DerefMut-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#882-892\">Source</a><a href=\"#impl-DerefMut-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/deref/trait.DerefMut.html\" title=\"trait core::ops::deref::DerefMut\">DerefMut</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.deref_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#887-891\">Source</a><a href=\"#method.deref_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/deref/trait.DerefMut.html#tymethod.deref_mut\" class=\"fn\">deref_mut</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a></h4></section></summary><div class='docblock'>Mutably dereferences the value.</div></details></div></details>","DerefMut","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Drop-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#817-835\">Source</a><a href=\"#impl-Drop-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/ops/drop/trait.Drop.html\" title=\"trait core::ops::drop::Drop\">Drop</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.drop\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#821-834\">Source</a><a href=\"#method.drop\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\" class=\"fn\">drop</a>(&amp;mut self)</h4></section></summary><div class='docblock'>Executes the destructor for this type. <a href=\"core/ops/drop/trait.Drop.html#tymethod.drop\">Read more</a></div></details></div></details>","Drop","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-From%3CBox%3C%5BT;+N%5D,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#837-853\">Source</a><a href=\"#impl-From%3CBox%3C%5BT;+N%5D,+A%3E%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A, const N: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"core/convert/trait.From.html\" title=\"trait core::convert::From\">From</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"primitive\" href=\"core/primitive.array.html\">[T; N]</a>, A&gt;&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.from\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#841-852\">Source</a><a href=\"#method.from\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/convert/trait.From.html#tymethod.from\" class=\"fn\">from</a>(b: <a class=\"struct\" href=\"kernel/alloc/kbox/struct.Box.html\" title=\"struct kernel::alloc::kbox::Box\">Box</a>&lt;<a class=\"primitive\" href=\"core/primitive.array.html\">[T; N]</a>, A&gt;) -&gt; <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;</h4></section></summary><div class='docblock'>Converts to this type from the input type.</div></details></div></details>","From<Box<[T; N], A>>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Index%3CI%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#948-958\">Source</a><a href=\"#impl-Index%3CI%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, I: <a class=\"trait\" href=\"core/slice/index/trait.SliceIndex.html\" title=\"trait core::slice::index::SliceIndex\">SliceIndex</a>&lt;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a>&gt;, A&gt; <a class=\"trait\" href=\"core/ops/index/trait.Index.html\" title=\"trait core::ops::index::Index\">Index</a>&lt;I&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle\" open><summary><section id=\"associatedtype.Output\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#952\">Source</a><a href=\"#associatedtype.Output\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/ops/index/trait.Index.html#associatedtype.Output\" class=\"associatedtype\">Output</a> = &lt;I as <a class=\"trait\" href=\"core/slice/index/trait.SliceIndex.html\" title=\"trait core::slice::index::SliceIndex\">SliceIndex</a>&lt;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a>&gt;&gt;::<a class=\"associatedtype\" href=\"core/slice/index/trait.SliceIndex.html#associatedtype.Output\" title=\"type core::slice::index::SliceIndex::Output\">Output</a></h4></section></summary><div class='docblock'>The returned type after indexing.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.index\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#955-957\">Source</a><a href=\"#method.index\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/index/trait.Index.html#tymethod.index\" class=\"fn\">index</a>(&amp;self, index: I) -&gt; &amp;Self::<a class=\"associatedtype\" href=\"core/ops/index/trait.Index.html#associatedtype.Output\" title=\"type core::ops::index::Index::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the indexing (<code>container[index]</code>) operation. <a href=\"core/ops/index/trait.Index.html#tymethod.index\">Read more</a></div></details></div></details>","Index<I>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IndexMut%3CI%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#960-968\">Source</a><a href=\"#impl-IndexMut%3CI%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, I: <a class=\"trait\" href=\"core/slice/index/trait.SliceIndex.html\" title=\"trait core::slice::index::SliceIndex\">SliceIndex</a>&lt;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a>&gt;, A&gt; <a class=\"trait\" href=\"core/ops/index/trait.IndexMut.html\" title=\"trait core::ops::index::IndexMut\">IndexMut</a>&lt;I&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.index_mut\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#965-967\">Source</a><a href=\"#method.index_mut\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/ops/index/trait.IndexMut.html#tymethod.index_mut\" class=\"fn\">index_mut</a>(&amp;mut self, index: I) -&gt; &amp;mut Self::<a class=\"associatedtype\" href=\"core/ops/index/trait.Index.html#associatedtype.Output\" title=\"type core::ops::index::Index::Output\">Output</a></h4></section></summary><div class='docblock'>Performs the mutable indexing (<code>container[index]</code>) operation. <a href=\"core/ops/index/trait.IndexMut.html#tymethod.index_mut\">Read more</a></div></details></div></details>","IndexMut<I>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-IntoIterator-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#1211-1260\">Source</a><a href=\"#impl-IntoIterator-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/iter/traits/collect/trait.IntoIterator.html\" title=\"trait core::iter::traits::collect::IntoIterator\">IntoIterator</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_iter\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#1247-1259\">Source</a><a href=\"#method.into_iter\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/iter/traits/collect/trait.IntoIterator.html#tymethod.into_iter\" class=\"fn\">into_iter</a>(self) -&gt; Self::<a class=\"associatedtype\" href=\"core/iter/traits/collect/trait.IntoIterator.html#associatedtype.IntoIter\" title=\"type core::iter::traits::collect::IntoIterator::IntoIter\">IntoIter</a></h4></section></summary><div class=\"docblock\"><p>Consumes the <code>Vec&lt;T, A&gt;</code> and creates an <code>Iterator</code>, which moves each value out of the\nvector (from start to end).</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>]<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v_iter = v.into_iter();\n\n<span class=\"kw\">let </span>first_element: <span class=\"prelude-ty\">Option</span>&lt;u32&gt; = v_iter.next();\n\n<span class=\"macro\">assert_eq!</span>(first_element, <span class=\"prelude-val\">Some</span>(<span class=\"number\">1</span>));\n<span class=\"macro\">assert_eq!</span>(v_iter.next(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(v_iter.next(), <span class=\"prelude-val\">None</span>);\n</code></pre></div>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = <span class=\"macro\">kernel::kvec!</span>[];\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v_iter = v.into_iter();\n\n<span class=\"kw\">let </span>first_element: <span class=\"prelude-ty\">Option</span>&lt;u32&gt; = v_iter.next();\n\n<span class=\"macro\">assert_eq!</span>(first_element, <span class=\"prelude-val\">None</span>);\n</code></pre></div></div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.Item\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#1215\">Source</a><a href=\"#associatedtype.Item\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/iter/traits/collect/trait.IntoIterator.html#associatedtype.Item\" class=\"associatedtype\">Item</a> = T</h4></section></summary><div class='docblock'>The type of the elements being iterated over.</div></details><details class=\"toggle\" open><summary><section id=\"associatedtype.IntoIter\" class=\"associatedtype trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#1216\">Source</a><a href=\"#associatedtype.IntoIter\" class=\"anchor\">§</a><h4 class=\"code-header\">type <a href=\"core/iter/traits/collect/trait.IntoIterator.html#associatedtype.IntoIter\" class=\"associatedtype\">IntoIter</a> = <a class=\"struct\" href=\"kernel/alloc/kvec/struct.IntoIter.html\" title=\"struct kernel::alloc::kvec::IntoIter\">IntoIter</a>&lt;T, A&gt;</h4></section></summary><div class='docblock'>Which kind of iterator are we turning this into?</div></details></div></details>","IntoIterator","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%26%5BU%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#impl-PartialEq%3C%26%5BU%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;&amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[U]</a>&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;&amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq<&[U]>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%26%5BU;+N%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#impl-PartialEq%3C%26%5BU;+N%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>, const N: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;&amp;<a class=\"primitive\" href=\"core/primitive.array.html\">[U; N]</a>&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;&amp;<a class=\"primitive\" href=\"core/primitive.array.html\">[U; N]</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq<&[U; N]>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%26mut+%5BU%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#impl-PartialEq%3C%26mut+%5BU%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;&amp;mut <a class=\"primitive\" href=\"core/primitive.slice.html\">[U]</a>&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;&amp;mut <a class=\"primitive\" href=\"core/primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq<&mut [U]>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%5BU%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#impl-PartialEq%3C%5BU%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;<a class=\"primitive\" href=\"core/primitive.slice.html\">[U]</a>&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[U]</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq<[U]>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3C%5BU;+N%5D%3E-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#impl-PartialEq%3C%5BU;+N%5D%3E-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>, const N: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;<a class=\"primitive\" href=\"core/primitive.array.html\">[U; N]</a>&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"primitive\" href=\"core/primitive.array.html\">[U; N]</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq<[U; N]>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-PartialEq%3CVec%3CU,+A2%3E%3E-for-Vec%3CT,+A1%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#impl-PartialEq%3CVec%3CU,+A2%3E%3E-for-Vec%3CT,+A1%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, U, A1: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>, A2: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;<a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;U, A2&gt;&gt; for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A1&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/cmp/trait.PartialEq.html\" title=\"trait core::cmp::PartialEq\">PartialEq</a>&lt;U&gt;,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.eq\" class=\"method trait-impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#984-994\">Source</a><a href=\"#method.eq\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#tymethod.eq\" class=\"fn\">eq</a>(&amp;self, other: &amp;<a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;U, A2&gt;) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>self</code> and <code>other</code> values to be equal, and is used by <code>==</code>.</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.ne\" class=\"method trait-impl\"><span class=\"rightside\"><span class=\"since\" title=\"Stable since Rust version 1.0.0\">1.0.0</span> · <a class=\"src\" href=\"src/core/cmp.rs.html#264\">Source</a></span><a href=\"#method.ne\" class=\"anchor\">§</a><h4 class=\"code-header\">fn <a href=\"core/cmp/trait.PartialEq.html#method.ne\" class=\"fn\">ne</a>(&amp;self, other: <a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;Rhs</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class='docblock'>Tests for <code>!=</code>. The default implementation is almost always sufficient,\nand should not be overridden without very good reason.</div></details></div></details>","PartialEq<Vec<U, A2>>","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#167-722\">Source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.capacity\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#178-184\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.capacity\" class=\"fn\">capacity</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Returns the number of elements that can be stored within the vector without allocating\nadditional memory.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.len\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#188-190\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.len\" class=\"fn\">len</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a></h4></section></summary><div class=\"docblock\"><p>Returns the number of elements stored within the vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.inc_len\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#199-205\">Source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.inc_len\" class=\"fn\">inc_len</a>(&amp;mut self, additional: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Increments <code>self.len</code> by <code>additional</code>.</p>\n<h5 id=\"safety\"><a class=\"doc-anchor\" href=\"#safety\">§</a>Safety</h5>\n<ul>\n<li><code>additional</code> must be less than or equal to <code>self.capacity - self.len</code>.</li>\n<li>All elements within the interval [<code>self.len</code>,<code>self.len + additional</code>) must be initialized.</li>\n</ul>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#228-230\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.as_slice\" class=\"fn\">as_slice</a>(&amp;self) -&gt; &amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a></h4></section></summary><div class=\"docblock\"><p>Returns a slice of the entire vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#234-236\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.as_mut_slice\" class=\"fn\">as_mut_slice</a>(&amp;mut self) -&gt; &amp;mut <a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a></h4></section></summary><div class=\"docblock\"><p>Returns a mutable slice of the entire vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_mut_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#241-243\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.as_mut_ptr\" class=\"fn\">as_mut_ptr</a>(&amp;mut self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a></h4></section></summary><div class=\"docblock\"><p>Returns a mutable raw pointer to the vector’s backing buffer, or, if <code>T</code> is a ZST, a\ndangling raw pointer.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.as_ptr\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#248-250\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.as_ptr\" class=\"fn\">as_ptr</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.pointer.html\">*const T</a></h4></section></summary><div class=\"docblock\"><p>Returns a raw pointer to the vector’s backing buffer, or, if <code>T</code> is a ZST, a dangling raw\npointer.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.is_empty\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#264-266\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.is_empty\" class=\"fn\">is_empty</a>(&amp;self) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a></h4></section></summary><div class=\"docblock\"><p>Returns <code>true</code> if the vector contains no elements, <code>false</code> otherwise.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = KVec::new();\n<span class=\"macro\">assert!</span>(v.is_empty());\n\nv.push(<span class=\"number\">1</span>, GFP_KERNEL);\n<span class=\"macro\">assert!</span>(!v.is_empty());</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.new\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#272-284\">Source</a><h4 class=\"code-header\">pub const fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.new\" class=\"fn\">new</a>() -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a new, empty <code>Vec&lt;T, A&gt;</code>.</p>\n<p>This method does not allocate by itself.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.spare_capacity_mut\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#287-297\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.spare_capacity_mut\" class=\"fn\">spare_capacity_mut</a>(&amp;mut self) -&gt; &amp;mut [<a class=\"union\" href=\"core/mem/maybe_uninit/union.MaybeUninit.html\" title=\"union core::mem::maybe_uninit::MaybeUninit\">MaybeUninit</a>&lt;T&gt;]</h4></section></summary><div class=\"docblock\"><p>Returns a slice of <code>MaybeUninit&lt;T&gt;</code> for the remaining spare capacity of the vector.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.push\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#312-318\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.push\" class=\"fn\">push</a>(&amp;mut self, v: T, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Appends an element to the back of the <a href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\"><code>Vec</code></a> instance.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = KVec::new();\nv.push(<span class=\"number\">1</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>]);\n\nv.push(<span class=\"number\">2</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>]);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.push_within_capacity\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#335-343\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.push_within_capacity\" class=\"fn\">push_within_capacity</a>(&amp;mut self, v: T) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"kernel/alloc/kvec/struct.PushError.html\" title=\"struct kernel::alloc::kvec::PushError\">PushError</a>&lt;T&gt;&gt;</h4></section></summary><div class=\"docblock\"><p>Appends an element to the back of the <a href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\"><code>Vec</code></a> instance without reallocating.</p>\n<p>Fails if the vector does not have capacity for the new element.</p>\n<h5 id=\"examples-2\"><a class=\"doc-anchor\" href=\"#examples-2\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = KVec::with_capacity(<span class=\"number\">10</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..<span class=\"number\">10 </span>{\n    v.push_within_capacity(i)<span class=\"question-mark\">?</span>;\n}\n\n<span class=\"macro\">assert!</span>(v.push_within_capacity(<span class=\"number\">10</span>).is_err());</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.insert_within_capacity\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#382-409\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.insert_within_capacity\" class=\"fn\">insert_within_capacity</a>(\n    &amp;mut self,\n    index: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>,\n    element: T,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"enum\" href=\"kernel/alloc/kvec/enum.InsertError.html\" title=\"enum kernel::alloc::kvec::InsertError\">InsertError</a>&lt;T&gt;&gt;</h4></section></summary><div class=\"docblock\"><p>Inserts an element at the given index in the <a href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\"><code>Vec</code></a> instance.</p>\n<p>Fails if the vector does not have capacity for the new element. Panics if the index is out\nof bounds.</p>\n<h5 id=\"examples-3\"><a class=\"doc-anchor\" href=\"#examples-3\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">use </span>kernel::alloc::kvec::InsertError;\n\n<span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = KVec::with_capacity(<span class=\"number\">5</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">for </span>i <span class=\"kw\">in </span><span class=\"number\">0</span>..<span class=\"number\">5 </span>{\n    v.insert_within_capacity(<span class=\"number\">0</span>, i)<span class=\"question-mark\">?</span>;\n}\n\n<span class=\"macro\">assert!</span>(<span class=\"macro\">matches!</span>(v.insert_within_capacity(<span class=\"number\">0</span>, <span class=\"number\">5</span>), <span class=\"prelude-val\">Err</span>(InsertError::OutOfCapacity(<span class=\"kw\">_</span>))));\n<span class=\"macro\">assert!</span>(<span class=\"macro\">matches!</span>(v.insert_within_capacity(<span class=\"number\">1000</span>, <span class=\"number\">5</span>), <span class=\"prelude-val\">Err</span>(InsertError::IndexOutOfBounds(<span class=\"kw\">_</span>))));\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">4</span>, <span class=\"number\">3</span>, <span class=\"number\">2</span>, <span class=\"number\">1</span>, <span class=\"number\">0</span>]);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.pop\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#426-440\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.pop\" class=\"fn\">pop</a>(&amp;mut self) -&gt; <a class=\"enum\" href=\"core/option/enum.Option.html\" title=\"enum core::option::Option\">Option</a>&lt;T&gt;</h4></section></summary><div class=\"docblock\"><p>Removes the last element from a vector and returns it, or <code>None</code> if it is empty.</p>\n<h5 id=\"examples-4\"><a class=\"doc-anchor\" href=\"#examples-4\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = KVec::new();\nv.push(<span class=\"number\">1</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\nv.push(<span class=\"number\">2</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>]);\n\n<span class=\"macro\">assert_eq!</span>(v.pop(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">2</span>));\n<span class=\"macro\">assert_eq!</span>(v.pop(), <span class=\"prelude-val\">Some</span>(<span class=\"number\">1</span>));\n<span class=\"macro\">assert_eq!</span>(v.pop(), <span class=\"prelude-val\">None</span>);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.remove\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#452-476\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.remove\" class=\"fn\">remove</a>(&amp;mut self, i: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;T, <a class=\"struct\" href=\"kernel/alloc/kvec/struct.RemoveError.html\" title=\"struct kernel::alloc::kvec::RemoveError\">RemoveError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Removes the element at the given index.</p>\n<h5 id=\"examples-5\"><a class=\"doc-anchor\" href=\"#examples-5\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(v.remove(<span class=\"number\">1</span>)<span class=\"question-mark\">?</span>, <span class=\"number\">2</span>);\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">1</span>, <span class=\"number\">3</span>]);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.with_capacity\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#488-494\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.with_capacity\" class=\"fn\">with_capacity</a>(capacity: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Creates a new <a href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\"><code>Vec</code></a> instance with at least the given capacity.</p>\n<h5 id=\"examples-6\"><a class=\"doc-anchor\" href=\"#examples-6\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span>v = KVec::&lt;u32&gt;::with_capacity(<span class=\"number\">20</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n\n<span class=\"macro\">assert!</span>(v.capacity() &gt;= <span class=\"number\">20</span>);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_raw_parts\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#537-556\">Source</a><h4 class=\"code-header\">pub unsafe fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.from_raw_parts\" class=\"fn\">from_raw_parts</a>(\n    ptr: <a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>,\n    length: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>,\n    capacity: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>,\n) -&gt; Self</h4></section></summary><div class=\"docblock\"><p>Creates a <code>Vec&lt;T, A&gt;</code> from a pointer, a length and a capacity using the allocator <code>A</code>.</p>\n<h5 id=\"examples-7\"><a class=\"doc-anchor\" href=\"#examples-7\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]<span class=\"question-mark\">?</span>;\nv.reserve(<span class=\"number\">1</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n\n<span class=\"kw\">let </span>(<span class=\"kw-2\">mut </span>ptr, <span class=\"kw-2\">mut </span>len, cap) = v.into_raw_parts();\n\n<span class=\"comment\">// SAFETY: We've just reserved memory for another element.\n</span><span class=\"kw\">unsafe </span>{ ptr.add(len).write(<span class=\"number\">4</span>) };\nlen += <span class=\"number\">1</span>;\n\n<span class=\"comment\">// SAFETY: We only wrote an additional element at the end of the `KVec`'s buffer and\n// correspondingly increased the length of the `KVec` by one. Otherwise, we construct it\n// from the exact same raw parts.\n</span><span class=\"kw\">let </span>v = <span class=\"kw\">unsafe </span>{ KVec::from_raw_parts(ptr, len, cap) };\n\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]);\n</code></pre></div><h5 id=\"safety-1\"><a class=\"doc-anchor\" href=\"#safety-1\">§</a>Safety</h5>\n<p>If <code>T</code> is a ZST:</p>\n<ul>\n<li><code>ptr</code> must be a dangling, well aligned pointer.</li>\n</ul>\n<p>Otherwise:</p>\n<ul>\n<li><code>ptr</code> must have been allocated with the allocator <code>A</code>.</li>\n<li><code>ptr</code> must satisfy or exceed the alignment requirements of <code>T</code>.</li>\n<li><code>ptr</code> must point to memory with a size of at least <code>size_of::&lt;T&gt;() * capacity</code> bytes.</li>\n<li>The allocated size in bytes must not be larger than <code>isize::MAX</code>.</li>\n<li><code>length</code> must be less than or equal to <code>capacity</code>.</li>\n<li>The first <code>length</code> elements must be initialized values of type <code>T</code>.</li>\n</ul>\n<p>It is also valid to create an empty <code>Vec</code> passing a dangling pointer for <code>ptr</code> and zero for\n<code>cap</code> and <code>len</code>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.into_raw_parts\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#563-569\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.into_raw_parts\" class=\"fn\">into_raw_parts</a>(self) -&gt; (<a class=\"primitive\" href=\"core/primitive.pointer.html\">*mut T</a>, <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>, <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Consumes the <code>Vec&lt;T, A&gt;</code> and returns its raw components <code>pointer</code>, <code>length</code> and <code>capacity</code>.</p>\n<p>This will not run the destructor of the contained elements and for non-ZSTs the allocation\nwill stay alive indefinitely. Use <a href=\"kernel/alloc/kvec/struct.Vec.html#method.from_raw_parts\" title=\"associated function kernel::alloc::kvec::Vec::from_raw_parts\"><code>Vec::from_raw_parts</code></a> to recover the <a href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\"><code>Vec</code></a>, drop the\nelements and free the allocation, if any.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.clear\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#587-589\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.clear\" class=\"fn\">clear</a>(&amp;mut self)</h4></section></summary><div class=\"docblock\"><p>Clears the vector, removing all values.</p>\n<p>Note that this method has no effect on the allocated capacity\nof the vector.</p>\n<h5 id=\"examples-8\"><a class=\"doc-anchor\" href=\"#examples-8\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]<span class=\"question-mark\">?</span>;\n\nv.clear();\n\n<span class=\"macro\">assert!</span>(v.is_empty());</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.reserve\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#609-647\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.reserve\" class=\"fn\">reserve</a>(\n    &amp;mut self,\n    additional: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Ensures that the capacity exceeds the length by at least <code>additional</code> elements.</p>\n<h5 id=\"examples-9\"><a class=\"doc-anchor\" href=\"#examples-9\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = KVec::new();\nv.push(<span class=\"number\">1</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n\nv.reserve(<span class=\"number\">10</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>cap = v.capacity();\n<span class=\"macro\">assert!</span>(cap &gt;= <span class=\"number\">10</span>);\n\nv.reserve(<span class=\"number\">10</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"kw\">let </span>new_cap = v.capacity();\n<span class=\"macro\">assert_eq!</span>(new_cap, cap);\n</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.truncate\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#664-674\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.truncate\" class=\"fn\">truncate</a>(&amp;mut self, len: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>)</h4></section></summary><div class=\"docblock\"><p>Shortens the vector, setting the length to <code>len</code> and drops the removed values.\nIf <code>len</code> is greater than or equal to the current length, this does nothing.</p>\n<p>This has no effect on the capacity and will not allocate.</p>\n<h5 id=\"examples-10\"><a class=\"doc-anchor\" href=\"#examples-10\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]<span class=\"question-mark\">?</span>;\nv.truncate(<span class=\"number\">1</span>);\n<span class=\"macro\">assert_eq!</span>(v.len(), <span class=\"number\">1</span>);\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>]);\n</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.drain_all\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#690-698\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.drain_all\" class=\"fn\">drain_all</a>(&amp;mut self) -&gt; <a class=\"struct\" href=\"kernel/alloc/kvec/struct.DrainAll.html\" title=\"struct kernel::alloc::kvec::DrainAll\">DrainAll</a>&lt;'_, T&gt; <a href=\"#\" class=\"tooltip\" data-notable-ty=\"DrainAll&lt;&#39;_, T&gt;\">ⓘ</a></h4></section></summary><div class=\"docblock\"><p>Takes ownership of all items in this vector without consuming the allocation.</p>\n<h5 id=\"examples-11\"><a class=\"doc-anchor\" href=\"#examples-11\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">0</span>, <span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]<span class=\"question-mark\">?</span>;\n\n<span class=\"kw\">for </span>(i, j) <span class=\"kw\">in </span>v.drain_all().enumerate() {\n    <span class=\"macro\">assert_eq!</span>(i, j);\n}\n\n<span class=\"macro\">assert!</span>(v.capacity() &gt;= <span class=\"number\">4</span>);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.retain\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#710-721\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.retain\" class=\"fn\">retain</a>(&amp;mut self, f: impl <a class=\"trait\" href=\"core/ops/function/trait.FnMut.html\" title=\"trait core::ops::function::FnMut\">FnMut</a>(<a class=\"primitive\" href=\"core/primitive.reference.html\">&amp;mut T</a>) -&gt; <a class=\"primitive\" href=\"core/primitive.bool.html\">bool</a>)</h4></section></summary><div class=\"docblock\"><p>Removes all elements that don’t match the provided closure.</p>\n<h5 id=\"examples-12\"><a class=\"doc-anchor\" href=\"#examples-12\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>, <span class=\"number\">4</span>]<span class=\"question-mark\">?</span>;\nv.retain(|i| <span class=\"kw-2\">*</span>i % <span class=\"number\">2 </span>== <span class=\"number\">0</span>);\n<span class=\"macro\">assert_eq!</span>(v, [<span class=\"number\">2</span>, <span class=\"number\">4</span>]);</code></pre></div></div></details></div></details>",0,"kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<details class=\"toggle implementors-toggle\" open><summary><section id=\"impl-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#724-815\">Source</a><a href=\"#impl-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/clone/trait.Clone.html\" title=\"trait core::clone::Clone\">Clone</a>, A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>&gt; <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;</h3></section></summary><div class=\"impl-items\"><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_with\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#726-748\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.extend_with\" class=\"fn\">extend_with</a>(\n    &amp;mut self,\n    n: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>,\n    value: T,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Extend the vector by <code>n</code> clones of <code>value</code>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.extend_from_slice\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#765-778\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.extend_from_slice\" class=\"fn\">extend_from_slice</a>(\n    &amp;mut self,\n    other: &amp;<a class=\"primitive\" href=\"core/primitive.slice.html\">[T]</a>,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Pushes clones of the elements of slice into the <a href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\"><code>Vec</code></a> instance.</p>\n<h5 id=\"examples\"><a class=\"doc-anchor\" href=\"#examples\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = KVec::new();\nv.push(<span class=\"number\">1</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n\nv.extend_from_slice(<span class=\"kw-2\">&amp;</span>[<span class=\"number\">20</span>, <span class=\"number\">30</span>, <span class=\"number\">40</span>], GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">20</span>, <span class=\"number\">30</span>, <span class=\"number\">40</span>]);\n\nv.extend_from_slice(<span class=\"kw-2\">&amp;</span>[<span class=\"number\">50</span>, <span class=\"number\">60</span>], GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">20</span>, <span class=\"number\">30</span>, <span class=\"number\">40</span>, <span class=\"number\">50</span>, <span class=\"number\">60</span>]);</code></pre></div></div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.from_elem\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#781-787\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.from_elem\" class=\"fn\">from_elem</a>(value: T, n: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>, flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;Self, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Create a new <code>Vec&lt;T, A&gt;</code> and extend it by <code>n</code> clones of <code>value</code>.</p>\n</div></details><details class=\"toggle method-toggle\" open><summary><section id=\"method.resize\" class=\"method\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#806-814\">Source</a><h4 class=\"code-header\">pub fn <a href=\"kernel/alloc/kvec/struct.Vec.html#tymethod.resize\" class=\"fn\">resize</a>(\n    &amp;mut self,\n    new_len: <a class=\"primitive\" href=\"core/primitive.usize.html\">usize</a>,\n    value: T,\n    flags: <a class=\"struct\" href=\"kernel/alloc/struct.Flags.html\" title=\"struct kernel::alloc::Flags\">Flags</a>,\n) -&gt; <a class=\"enum\" href=\"core/result/enum.Result.html\" title=\"enum core::result::Result\">Result</a>&lt;<a class=\"primitive\" href=\"core/primitive.unit.html\">()</a>, <a class=\"struct\" href=\"kernel/alloc/struct.AllocError.html\" title=\"struct kernel::alloc::AllocError\">AllocError</a>&gt;</h4></section></summary><div class=\"docblock\"><p>Resizes the <a href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\"><code>Vec</code></a> so that <code>len</code> is equal to <code>new_len</code>.</p>\n<p>If <code>new_len</code> is smaller than <code>len</code>, the <code>Vec</code> is <a href=\"kernel/alloc/kvec/struct.Vec.html#method.truncate\" title=\"method kernel::alloc::kvec::Vec::truncate\"><code>Vec::truncate</code></a>d.\nIf <code>new_len</code> is larger, each new slot is filled with clones of <code>value</code>.</p>\n<h5 id=\"examples-1\"><a class=\"doc-anchor\" href=\"#examples-1\">§</a>Examples</h5>\n<div class=\"example-wrap\"><pre class=\"rust rust-example-rendered\"><code><span class=\"kw\">let </span><span class=\"kw-2\">mut </span>v = <span class=\"macro\">kernel::kvec!</span>[<span class=\"number\">1</span>, <span class=\"number\">2</span>, <span class=\"number\">3</span>]<span class=\"question-mark\">?</span>;\nv.resize(<span class=\"number\">1</span>, <span class=\"number\">42</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>]);\n\nv.resize(<span class=\"number\">3</span>, <span class=\"number\">42</span>, GFP_KERNEL)<span class=\"question-mark\">?</span>;\n<span class=\"macro\">assert_eq!</span>(<span class=\"kw-2\">&amp;</span>v, <span class=\"kw-2\">&amp;</span>[<span class=\"number\">1</span>, <span class=\"number\">42</span>, <span class=\"number\">42</span>]);\n</code></pre></div></div></details></div></details>",0,"kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<section id=\"impl-Eq-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#946\">Source</a><a href=\"#impl-Eq-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T: <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a>, A&gt; <a class=\"trait\" href=\"core/cmp/trait.Eq.html\" title=\"trait core::cmp::Eq\">Eq</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section>","Eq","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<section id=\"impl-Send-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#152-157\">Source</a><a href=\"#impl-Send-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Send.html\" title=\"trait core::marker::Send\">Send</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section>","Send","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"],["<section id=\"impl-Sync-for-Vec%3CT,+A%3E\" class=\"impl\"><a class=\"src rightside\" href=\"src/kernel/alloc/kvec.rs.html#160-165\">Source</a><a href=\"#impl-Sync-for-Vec%3CT,+A%3E\" class=\"anchor\">§</a><h3 class=\"code-header\">impl&lt;T, A&gt; <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a> for <a class=\"struct\" href=\"kernel/alloc/kvec/struct.Vec.html\" title=\"struct kernel::alloc::kvec::Vec\">Vec</a>&lt;T, A&gt;<div class=\"where\">where\n    T: <a class=\"trait\" href=\"core/marker/trait.Sync.html\" title=\"trait core::marker::Sync\">Sync</a>,\n    A: <a class=\"trait\" href=\"kernel/alloc/trait.Allocator.html\" title=\"trait kernel::alloc::Allocator\">Allocator</a>,</div></h3></section>","Sync","kernel::alloc::kvec::KVec","kernel::alloc::kvec::VVec","kernel::alloc::kvec::KVVec"]]]]);
    if (window.register_type_impls) {
        window.register_type_impls(type_impls);
    } else {
        window.pending_type_impls = type_impls;
    }
})()
//{"start":55,"fragment_lengths":[79224]}