/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.exec.DBCConnectException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.dialogs.StandardErrorDialog;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class DriverEditHelpers {
    private static final Log log = Log.getLog(DriverEditHelpers.class);

    static void exportDriverLibraries(Shell shell, List<DBPDriverLibrary> libraries) {
        String outputFolder = DialogUtils.openDirectoryDialog((Shell)shell, (String)UIConnectionMessages.controls_client_homes_panel_label_path, null);
        if (CommonUtils.isEmpty((String)outputFolder)) {
            return;
        }
        Path[] firstExported = new Path[1];
        try {
            UIUtils.runInProgressDialog(monitor -> {
                int totalFiles = 0;
                monitor.beginTask("Count driver files", libraries.size());
                for (DBPDriverLibrary library : libraries) {
                    totalFiles += DriverEditHelpers.countFiles(monitor, library);
                    monitor.worked(1);
                }
                monitor.done();
                monitor.beginTask("Export driver files", totalFiles);
                for (DBPDriverLibrary library : libraries) {
                    if (monitor.isCanceled()) break;
                    try {
                        Path exported = DriverEditHelpers.exportLibrary(monitor, library, outputFolder);
                        if (exported == null || firstExported[0] != null) continue;
                        pathArray[0] = exported;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e) {
            log.debug((Object)e.getTargetException());
        }
        if (firstExported[0] != null) {
            ShellUtils.showInSystemExplorer((File)firstExported[0].toFile());
        }
    }

    private static int countFiles(DBRProgressMonitor monitor, DBPDriverLibrary library) {
        Path localFile;
        if (monitor.isCanceled()) {
            return 0;
        }
        int totalFiles = 0;
        try {
            Collection dependencies = library.getDependencies(monitor);
            if (!CommonUtils.isEmpty((Collection)dependencies)) {
                for (DBPDriverLibrary dep : dependencies) {
                    totalFiles += DriverEditHelpers.countFiles(monitor, dep);
                }
            }
        }
        catch (IOException iOException) {}
        if ((localFile = library.getLocalFile()) == null) {
            try {
                library.downloadLibraryFile(monitor, false, "Download file");
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
        }
        if (localFile != null && Files.exists(localFile, new LinkOption[0])) {
            if (Files.isDirectory(localFile, new LinkOption[0])) {
                try {
                    Throwable e = null;
                    Iterator iterator = null;
                    try (Stream<Path> walk = Files.walk(localFile, new FileVisitOption[0]);){
                        totalFiles += walk.sorted(Comparator.reverseOrder()).toList().size();
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (IOException e) {
                    log.debug((Object)e);
                }
            } else {
                ++totalFiles;
            }
        }
        return totalFiles;
    }

    private static Path exportLibrary(DBRProgressMonitor monitor, DBPDriverLibrary library, String outputFolder) throws InterruptedException {
        if (monitor.isCanceled()) {
            return null;
        }
        block11: while (true) {
            try {
                Path localFile;
                Path depExported = null;
                Collection dependencies = library.getDependencies(monitor);
                if (!CommonUtils.isEmpty((Collection)dependencies)) {
                    for (DBPDriverLibrary dep : dependencies) {
                        Path result = DriverEditHelpers.exportLibrary(monitor, dep, outputFolder);
                        if (depExported != null) continue;
                        depExported = result;
                    }
                }
                if ((localFile = library.getLocalFile()) == null || !Files.exists(localFile, new LinkOption[0])) {
                    return depExported;
                }
                Path outFile = null;
                if (Files.isDirectory(localFile, new LinkOption[0])) {
                    Path[] exported = new Path[1];
                    Throwable throwable = null;
                    Object var9_11 = null;
                    try (Stream<Path> walk = Files.walk(localFile, new FileVisitOption[0]);){
                        walk.forEach(source -> {
                            if (Files.isDirectory(source, new LinkOption[0])) {
                                return;
                            }
                            monitor.subTask("Export file '" + String.valueOf(source) + "'");
                            Path destination = Path.of(outputFolder, source.getFileName().toString());
                            try {
                                Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                log.debug((Object)e);
                            }
                            if (exported[0] == null) {
                                pathArray[0] = destination;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    outFile = exported[0];
                } else {
                    String driverFileName = localFile.getFileName().toString();
                    monitor.subTask("Export library file '" + driverFileName + "'");
                    outFile = Path.of(outputFolder, driverFileName);
                    Files.copy(localFile, outFile, StandardCopyOption.REPLACE_EXISTING);
                }
                monitor.worked(1);
                return outFile;
            }
            catch (IOException e) {
                DBPPlatformUI.UserResponse resp = DBWorkbench.getPlatformUI().showErrorStopRetryIgnore("Export driver files", (Throwable)e, false);
                switch (resp) {
                    case RETRY: {
                        continue block11;
                    }
                    case CANCEL: 
                    case STOP: {
                        throw new InterruptedException();
                    }
                }
                continue;
            }
            break;
        }
    }

    static void showFileInExplorer(Path localFile) {
        if (localFile != null) {
            if (Files.isDirectory(localFile, new LinkOption[0])) {
                ShellUtils.launchProgram((String)localFile.toAbsolutePath().toString());
            } else {
                ShellUtils.showInSystemExplorer((String)localFile.toAbsolutePath().toString());
            }
        }
    }

    static List<DBPDriver> getDriversByLibrary(DBPDriverLibrary oldLib) {
        ArrayList<DBPDriver> drivers = new ArrayList<DBPDriver>();
        for (DataSourceProviderDescriptor dspd : DataSourceProviderRegistry.getInstance().getDataSourceProviders()) {
            for (DBPDriver driver : dspd.getDrivers()) {
                for (DBPDriverLibrary library : driver.getDriverLibraries()) {
                    if (!CommonUtils.equalObjects((Object)library.getPath(), (Object)oldLib.getPath())) continue;
                    drivers.add(driver);
                }
            }
        }
        return drivers;
    }

    public static void showBadConfigDialog(Shell shell, String message, DBException error) {
        Runnable runnable = () -> {
            DBPDataSource dBPDataSource;
            if (error instanceof DBDatabaseException) {
                DBDatabaseException dbe = (DBDatabaseException)error;
                dBPDataSource = dbe.getDataSource();
            } else {
                dBPDataSource = null;
            }
            DBPDataSource dataSource = dBPDataSource;
            String title = NLS.bind((String)UIConnectionMessages.dialog_edit_driver_dialog_bad_configuration, (Object)(dataSource == null ? "<unknown driver>" : dataSource.getContainer().getDriver().getName()));
            new BadDriverConfigDialog(shell, title, message == null ? title : message, DriverEditHelpers.defineException(error)).open();
        };
        UIUtils.syncExec((Runnable)runnable);
    }

    @NotNull
    private static DBException defineException(@NotNull DBException error) {
        DBException cause;
        Throwable throwable;
        return error instanceof DBCConnectException && (throwable = error.getCause()) instanceof DBException ? (cause = (DBException)throwable) : error;
    }

    static class BadDriverConfigDialog
    extends StandardErrorDialog {
        private final DBPDataSource dataSource;

        BadDriverConfigDialog(Shell shell, String title, String message, DBException error) {
            super(shell == null ? UIUtils.getActiveWorkbenchShell() : shell, title, message, RuntimeUtils.stripStack((IStatus)GeneralUtils.makeExceptionStatus((Throwable)error)), 4);
            DBPDataSource dBPDataSource;
            if (error instanceof DBDatabaseException) {
                DBDatabaseException dbe = (DBDatabaseException)error;
                dBPDataSource = dbe.getDataSource();
            } else {
                dBPDataSource = null;
            }
            this.dataSource = dBPDataSource;
        }

        protected void createButtonsForButtonBar(@NotNull Composite parent) {
            this.createButton(parent, 8, "Open Driver &Configuration", true);
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int id) {
            if (id == 8) {
                UIUtils.asyncExec(() -> {
                    DriverEditDialog dialog = new DriverEditDialog(UIUtils.getActiveWorkbenchShell(), this.dataSource.getContainer().getDriver());
                    dialog.open();
                });
                super.buttonPressed(0);
            }
            super.buttonPressed(id);
        }
    }
}

