/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreClass;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDefaultPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreMaterializedView;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreObjectPrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeGrant;
import org.jkiss.dbeaver.ext.postgresql.model.PostgrePrivilegeOwner;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureKind;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleMember;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRolePrivilege;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreRoleReference;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreScriptObject;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSequence;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreServerExtension;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPPersistedObject;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPScriptObjectExt2;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.access.DBAUser;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyValueValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class PostgreRole
implements PostgreObject,
PostgrePrivilegeOwner,
DBPPersistedObject,
DBPSaveableObject,
DBPRefreshableObject,
DBPNamedObject2,
DBARole,
DBAUser,
PostgreScriptObject,
DBPScriptObjectExt2 {
    public static final String CAT_SETTINGS = "Settings";
    public static final String CAT_FLAGS = "Flags";
    private static final Log log = Log.getLog(PostgreRole.class);
    protected final PostgreDatabase database;
    protected long oid;
    protected String name;
    protected boolean superUser;
    protected boolean inherit;
    protected boolean createRole;
    protected boolean createDatabase;
    protected boolean canLogin;
    protected boolean replication;
    protected boolean bypassRls;
    protected int connLimit;
    protected String password;
    protected LocalDateTime validUntil;
    protected String description;
    protected boolean persisted;
    private final MembersCache membersCache = new MembersCache(true);
    private final MembersCache belongsCache = new MembersCache(false);
    private List<PostgreRoleSetting> extraSettings;
    private final String lineBreak = System.lineSeparator();

    public PostgreRole(PostgreDatabase database, String name, String password, boolean isUser) {
        this.database = database;
        this.name = name;
        this.password = password;
        this.canLogin = isUser;
        this.persisted = false;
    }

    public PostgreRole(PostgreDatabase database, ResultSet dbResult) throws SQLException {
        this.database = database;
        this.loadInfo(dbResult);
    }

    protected void loadInfo(ResultSet dbResult) {
        this.persisted = true;
        this.oid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"oid");
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rolname");
        this.superUser = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolsuper");
        this.inherit = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolinherit");
        this.createRole = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcreaterole");
        this.createDatabase = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcreatedb");
        this.canLogin = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolcanlogin");
        this.replication = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolreplication");
        this.bypassRls = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"rolbypassrls");
        this.connLimit = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"rolconnlimit");
        this.password = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"rolpassword");
        this.validUntil = Optional.ofNullable(JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"rolvaliduntil")).map(Timestamp::toLocalDateTime).orElse(null);
        this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"description");
    }

    @Property(viewable=true, editable=true, updatable=true, length=PropertyLength.MULTILINE, order=50, visibleIf=CommentsOnRolesSupportedValidator.class)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.database;
    }

    @Override
    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public boolean isUser() {
        return this.canLogin;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String newName) {
        this.name = newName;
    }

    @Override
    @NotNull
    public PostgreDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=3)
    public long getObjectId() {
        return this.oid;
    }

    @Property(editable=true, updatable=true, order=10, visibleIf=PostgreRoleCanBeSuperUserValidator.class)
    public boolean isSuperUser() {
        return this.superUser;
    }

    public void setSuperUser(boolean superUser) {
        this.superUser = superUser;
    }

    @Property(editable=true, updatable=true, order=11, visibleIf=PostgreRoleInheritValidator.class)
    public boolean isInherit() {
        return this.inherit;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    @Property(editable=true, updatable=true, order=12)
    public boolean isCreateRole() {
        return this.createRole;
    }

    public void setCreateRole(boolean createRole) {
        this.createRole = createRole;
    }

    @Property(editable=true, updatable=true, order=13, visibleIf=PostgreRoleCanCreateDBValidator.class)
    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.createDatabase = createDatabase;
    }

    @Property(editable=true, updatable=true, order=14)
    public boolean isCanLogin() {
        return this.canLogin;
    }

    public void setCanLogin(boolean canLogin) {
        this.canLogin = canLogin;
    }

    @Property(editable=true, updatable=true, order=15, visibleIf=RoleCanBeReplicationValidator.class)
    public boolean isReplication() {
        return this.replication;
    }

    public void setReplication(boolean replication) {
        this.replication = replication;
    }

    @Property(editable=true, updatable=true, order=16, visibleIf=RoleCanBypassRLSValidator.class)
    public boolean isBypassRls() {
        return this.bypassRls;
    }

    public void setBypassRls(boolean bypassRls) {
        this.bypassRls = bypassRls;
    }

    @Property(category="Settings", editable=true, updatable=true, order=20)
    public int getConnLimit() {
        return this.connLimit;
    }

    public void setConnLimit(int connLimit) {
        this.connLimit = connLimit;
    }

    @Property(viewable=true, password=true, editable=true, order=2, visibleIf=PersistenceUserValidator.class)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Property(category="Settings", editable=true, updatable=true, order=22)
    public LocalDateTime getValidUntil() {
        return this.validUntil;
    }

    public void setValidUntil(LocalDateTime validUntil) {
        this.validUntil = validUntil;
    }

    @Association
    public Collection<PostgreRoleMember> getMembers(DBRProgressMonitor monitor) throws DBException {
        return this.membersCache.getAllObjects(monitor, this);
    }

    @Association
    public Collection<PostgreRoleMember> getBelongs(DBRProgressMonitor monitor) throws DBException {
        return this.belongsCache.getAllObjects(monitor, this);
    }

    @Override
    public PostgreSchema getSchema() {
        return null;
    }

    @Override
    public PostgreRole getOwner(DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    private void loadExtraConfigParameters(@NotNull DBRProgressMonitor monitor) throws DBCException {
        this.extraSettings = new ArrayList<PostgreRoleSetting>();
        if (!this.getDataSource().isServerVersionAtLeast(9, 0)) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load configuration parameters");){
            try {
                Throwable throwable2 = null;
                Object var6_9 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("select s.setconfig, pd.datname from pg_catalog.pg_db_role_setting s\nleft join pg_catalog.pg_database pd on s.setdatabase = pd.oid\nwhere s.setrole = ?");){
                    dbStat.setLong(1, this.getObjectId());
                    Throwable throwable3 = null;
                    Object var9_14 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        while (dbResult.next()) {
                            Object[] setconfig = PostgreUtils.safeGetStringArray((ResultSet)dbResult, "setconfig");
                            if (ArrayUtils.isEmpty((Object[])setconfig)) continue;
                            String databaseName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"datname");
                            PostgreDatabase database = null;
                            if (CommonUtils.isNotEmpty((String)databaseName)) {
                                database = this.getDataSource().getDatabase(databaseName);
                            }
                            Object[] objectArray = setconfig;
                            int n = setconfig.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object parameter = objectArray[n2];
                                parameter = this.quoteParamIfNeed((String)parameter);
                                this.extraSettings.add(new PostgreRoleSetting(database, (String)parameter));
                                ++n2;
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException sQLException) {
                log.error((Object)"Can't read extra role configuration parameters.");
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private String quoteParamIfNeed(String parameter) {
        String value;
        if (parameter == null || parameter.isEmpty()) {
            return parameter;
        }
        int valueStartingIndex = parameter.indexOf("=");
        if (valueStartingIndex < 0 || valueStartingIndex + 1 >= parameter.length()) {
            return parameter;
        }
        if (CommonUtils.isNumber((Object)(value = parameter.substring(++valueStartingIndex))) || value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return parameter;
        }
        return parameter.substring(0, valueStartingIndex) + SQLUtils.quoteString((DBSObject)this, (String)value);
    }

    public boolean supportsObjectDefinitionOption(@NotNull String option) {
        return "ddl.includePermissions".equals(option);
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        String lineBreak = System.lineSeparator();
        PostgreDataSource dataSource = this.getDataSource();
        PostgreServerExtension extension = dataSource.getServerType();
        StringBuilder ddl = new StringBuilder();
        String roleName = DBUtils.getQuotedIdentifier((DBSObject)this);
        ddl.append("-- DROP ROLE ").append(roleName).append(";\n\n");
        ddl.append("CREATE ROLE ").append(roleName).append(" WITH ");
        if (extension.supportsSuperusers()) {
            this.addOptionToDDL(ddl, this.isSuperUser(), "SUPERUSER");
        }
        if (extension.supportsRolesWithCreateDBAbility()) {
            this.addOptionToDDL(ddl, this.isCreateDatabase(), "CREATEDB");
        }
        this.addOptionToDDL(ddl, this.isCreateRole(), "CREATEROLE");
        if (extension.supportsInheritance()) {
            this.addOptionToDDL(ddl, this.isInherit(), "INHERIT");
        }
        this.addOptionToDDL(ddl, this.isCanLogin(), "LOGIN");
        if (extension.supportsRoleReplication()) {
            this.addOptionToDDL(ddl, this.isReplication(), "REPLICATION");
        }
        if (extension.supportsRoleBypassRLS()) {
            this.addOptionToDDL(ddl, this.isBypassRls(), "BYPASSRLS");
        }
        if (this.getConnLimit() > 0) {
            ddl.append(lineBreak);
            ddl.append("\tCONNECTION LIMIT ").append(this.getConnLimit());
        } else {
            ddl.append(lineBreak);
            ddl.append("\tCONNECTION LIMIT -1");
        }
        if (this.getValidUntil() != null) {
            ddl.append(lineBreak);
            ddl.append("\tVALID UNTIL '").append(this.getValidUntil()).append("'");
        }
        ddl.append(";");
        if (this.extraSettings == null) {
            this.loadExtraConfigParameters(monitor);
        }
        if (!CommonUtils.isEmpty(this.extraSettings)) {
            String beginning = "\nALTER ROLE " + roleName + " ";
            for (PostgreRoleSetting setting : this.extraSettings) {
                ddl.append(beginning);
                if (setting.database != null) {
                    ddl.append("IN DATABASE ").append(DBUtils.getQuotedIdentifier((DBSObject)setting.database)).append(" ");
                }
                ddl.append("SET ").append(setting.configurationParameter).append(";");
            }
        }
        if (CommonUtils.isNotEmpty((String)this.description)) {
            ddl.append("\n\n").append("COMMENT ON ROLE ").append(roleName).append(" IS ").append(SQLUtils.quoteString((DBSObject)this, (String)this.description)).append(";");
        }
        if (CommonUtils.getOption(options, (String)"ddl.includePermissions")) {
            ddl.append("\n");
            ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
            PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
            ddl.append("\n").append(SQLUtils.generateScript((DBPDataSource)dataSource, (DBEPersistAction[])actions.toArray(new DBEPersistAction[0]), (boolean)false));
        }
        if (this.isInherit()) {
            ddl.append("\n");
            for (PostgreRoleMember member : this.belongsCache.getAllObjects(monitor, this)) {
                ddl.append("\n").append("GRANT ").append(DBUtils.getQuotedIdentifier((DBSObject)member.getOwner(monitor))).append(" TO ").append(DBUtils.getQuotedIdentifier((DBSObject)this)).append(";");
            }
        }
        return ddl.toString();
    }

    private void addOptionToDDL(StringBuilder ddl, boolean isOptionOn, String option) {
        ddl.append(this.lineBreak).append("\t");
        if (isOptionOn) {
            ddl.append(option);
        } else {
            ddl.append("NO").append(option);
        }
    }

    public List<PostgrePrivilege> getPrivileges(@NotNull DBRProgressMonitor monitor, boolean includeNestedObjects) throws DBCException {
        ArrayList<PostgrePrivilege> permissions = new ArrayList<PostgrePrivilege>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read role privileges");){
                String objectType;
                long schemaId;
                JDBCResultSet dbResult;
                Object var14_32;
                Throwable throwable2;
                JDBCPreparedStatement dbStat;
                boolean supportsOnlySchemasPermissions;
                JDBCPreparedStatement dbStat2;
                Object var8_16;
                try {
                    Throwable throwable3 = null;
                    var8_16 = null;
                    try {
                        dbStat2 = session.prepareStatement("SELECT * FROM information_schema.table_privileges WHERE table_catalog=? AND grantee=?");
                        try {
                            dbStat2.setString(1, this.getDatabase().getName());
                            dbStat2.setString(2, this.getName());
                            permissions.addAll(PostgreRole.getRolePermissions(monitor, this, PostgrePrivilegeGrant.Kind.TABLE, dbStat2));
                        }
                        finally {
                            if (dbStat2 != null) {
                                dbStat2.close();
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error reading table privileges", e);
                }
                try {
                    e = null;
                    var8_16 = null;
                    try {
                        dbStat2 = session.prepareStatement("SELECT * FROM information_schema.routine_privileges WHERE specific_catalog=? AND grantee=?");
                        try {
                            dbStat2.setString(1, this.getDatabase().getName());
                            dbStat2.setString(2, this.getName());
                            permissions.addAll(PostgreRole.getRolePermissions(monitor, this, PostgrePrivilegeGrant.Kind.FUNCTION, dbStat2));
                        }
                        finally {
                            if (dbStat2 != null) {
                                dbStat2.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (e == null) {
                            e = throwable5;
                        } else if (e != throwable5) {
                            e.addSuppressed(throwable5);
                        }
                        throw e;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Error reading routine privileges", e);
                }
                boolean supportsDistinct = this.getDataSource().getServerType().supportsDistinctForStatementsWithAcl();
                boolean bl = supportsOnlySchemasPermissions = !this.getDataSource().isServerVersionAtLeast(9, 0);
                Object otherObjectsSQL = supportsOnlySchemasPermissions ? "SELECT n.oid, n.nspacl FROM pg_catalog.pg_namespace n WHERE n.nspacl IS NOT NULL" : "SELECT * FROM (\n\tSELECT " + (supportsDistinct ? "DISTINCT" : "") + " relnamespace,\n\trelacl,\n\trelname,\n\trelkind,\n(aclexplode(relacl)).grantee as granteeI\nFROM\n\tpg_class\nWHERE\n\trelacl IS NOT NULL\n\tAND relnamespace IN (\nSELECT oid\nFROM pg_namespace\nWHERE nspname NOT LIKE 'pg_%' AND nspname != 'information_schema')\nUNION ALL\nSELECT " + (supportsDistinct ? "DISTINCT" : "") + "\n\tn.oid AS relnamespace,\n\tnspacl AS relacl,\n\tn.nspname AS relname,\n\tcast('C' as \"char\") AS relkind,\n(aclexplode(nspacl)).grantee as granteeI\nFROM\n\tpg_catalog.pg_namespace n\nWHERE\n\tn.nspacl IS NOT NULL \n\t) AS tr\nWHERE pg_get_userbyid(tr.granteeI)= ? AND tr.relkind IN('S', 'm', 'C')";
                Throwable throwable6 = null;
                Object var11_25 = null;
                try {
                    dbStat = session.prepareStatement((String)otherObjectsSQL);
                    try {
                        if (!supportsOnlySchemasPermissions) {
                            dbStat.setString(1, this.getName());
                        }
                        throwable2 = null;
                        var14_32 = null;
                        try {
                            dbResult = dbStat.executeQuery();
                            try {
                                while (dbResult.nextRow()) {
                                    PostgreSchema schema;
                                    schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (int)1);
                                    Object acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (int)2);
                                    String objectName = null;
                                    objectType = null;
                                    if (!supportsOnlySchemasPermissions) {
                                        objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relname");
                                        objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"relkind");
                                    }
                                    if ((schema = this.getDatabase().getSchema(monitor, schemaId)) == null) continue;
                                    List<PostgrePrivilege> privileges = null;
                                    PostgrePrivilegeGrant.Kind pKind = null;
                                    if (supportsOnlySchemasPermissions) {
                                        pKind = PostgrePrivilegeGrant.Kind.SCHEMA;
                                        privileges = PostgreUtils.extractPermissionsFromACL(monitor, schema, acl, false);
                                    } else if (objectType != null && objectName != null) {
                                        pKind = PostgrePrivilegeGrant.Kind.TABLE;
                                        if (objectType.equals("C")) {
                                            privileges = PostgreUtils.extractPermissionsFromACL(monitor, schema, acl, false);
                                            pKind = PostgrePrivilegeGrant.Kind.SCHEMA;
                                        } else if (PostgreClass.RelKind.S.getCode().equals(objectType)) {
                                            PostgreSequence sequence = schema.getSequence(monitor, objectName);
                                            privileges = PostgreUtils.extractPermissionsFromACL(monitor, sequence, acl, false);
                                            pKind = PostgrePrivilegeGrant.Kind.SEQUENCE;
                                        } else {
                                            PostgreMaterializedView materializedView = schema.getMaterializedView(monitor, objectName);
                                            privileges = PostgreUtils.extractPermissionsFromACL(monitor, materializedView, acl, false);
                                        }
                                    }
                                    for (PostgrePrivilege p : CommonUtils.safeCollection(privileges)) {
                                        PostgreRoleReference grantee;
                                        if (!(p instanceof PostgreObjectPrivilege) || (grantee = ((PostgreObjectPrivilege)p).getGrantee()) == null || !this.isReferencedWith(grantee)) continue;
                                        ArrayList<PostgrePrivilegeGrant> grants = new ArrayList<PostgrePrivilegeGrant>();
                                        PostgrePrivilege.ObjectPermission[] objectPermissionArray = p.getPermissions();
                                        int n = objectPermissionArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            PostgrePrivilege.ObjectPermission perm = objectPermissionArray[n2];
                                            grants.add(new PostgrePrivilegeGrant(perm.getGrantor(), grantee, this.getDatabase().getName(), schema.getName(), objectName, perm.getPrivilegeType(), false, false));
                                            ++n2;
                                        }
                                        permissions.add(new PostgreRolePrivilege(this, pKind, schema.getName(), objectName, grants));
                                    }
                                }
                            }
                            finally {
                                if (dbResult != null) {
                                    dbResult.close();
                                }
                            }
                        }
                        catch (Throwable throwable7) {
                            if (throwable2 == null) {
                                throwable2 = throwable7;
                            } else if (throwable2 != throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            throw throwable2;
                        }
                    }
                    finally {
                        if (dbStat != null) {
                            dbStat.close();
                        }
                    }
                }
                catch (Throwable throwable8) {
                    if (throwable6 == null) {
                        throwable6 = throwable8;
                    } else if (throwable6 != throwable8) {
                        throwable6.addSuppressed(throwable8);
                    }
                    throw throwable6;
                }
                if (this.getDataSource().getServerType().supportsDefaultPrivileges()) {
                    try {
                        throwable6 = null;
                        var11_25 = null;
                        try {
                            dbStat = session.prepareStatement("SELECT DISTINCT g.* FROM (\nSELECT *,\n(aclexplode(defaclacl)).grantee as grantee\nFROM pg_default_acl a WHERE a.defaclnamespace <> 0) as g\nwhere pg_get_userbyid(g.grantee) = ?");
                            try {
                                dbStat.setString(1, this.getName());
                                throwable2 = null;
                                var14_32 = null;
                                try {
                                    dbResult = dbStat.executeQuery();
                                    try {
                                        while (dbResult.nextRow()) {
                                            Object acl;
                                            schemaId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"defaclnamespace");
                                            PostgreSchema schema = this.getDatabase().getSchema(monitor, schemaId);
                                            if (schema == null || (acl = JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"defaclacl")) == null) continue;
                                            objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"defaclobjtype");
                                            if (CommonUtils.isEmpty((String)objectType)) {
                                                log.debug((Object)("Can't read default permissions object type for " + schema.getName()));
                                                continue;
                                            }
                                            List<PostgrePrivilege> privileges = PostgreUtils.extractPermissionsFromACL(monitor, schema, acl, true);
                                            ArrayList<PostgrePrivilege> resultPrivileges = new ArrayList<PostgrePrivilege>();
                                            for (PostgrePrivilege privilege : privileges) {
                                                PostgreDefaultPrivilege defaultPrivilege;
                                                if (!(privilege instanceof PostgreDefaultPrivilege) || !(defaultPrivilege = (PostgreDefaultPrivilege)privilege).getGrantee().getRoleName().equals(this.getName())) continue;
                                                defaultPrivilege.setUnderKind(objectType);
                                                resultPrivileges.add(defaultPrivilege);
                                            }
                                            permissions.addAll(resultPrivileges);
                                            schema.addDefaultPrivileges(resultPrivileges);
                                        }
                                    }
                                    finally {
                                        if (dbResult != null) {
                                            dbResult.close();
                                        }
                                    }
                                }
                                catch (Throwable throwable9) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable9;
                                    } else if (throwable2 != throwable9) {
                                        throwable2.addSuppressed(throwable9);
                                    }
                                    throw throwable2;
                                }
                            }
                            finally {
                                if (dbStat != null) {
                                    dbStat.close();
                                }
                            }
                        }
                        catch (Throwable throwable10) {
                            if (throwable6 == null) {
                                throwable6 = throwable10;
                            } else if (throwable6 != throwable10) {
                                throwable6.addSuppressed(throwable10);
                            }
                            throw throwable6;
                        }
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error reading default privileges", e);
                    }
                }
                Collections.sort(permissions);
            }
            catch (Throwable throwable11) {
                if (throwable == null) {
                    throwable = throwable11;
                } else if (throwable != throwable11) {
                    throwable.addSuppressed(throwable11);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException("Error reading role privileges", (Throwable)e);
        }
        return permissions;
    }

    @Override
    public String generateChangeOwnerQuery(@NotNull String owner, @NotNull Map<String, Object> options) {
        return null;
    }

    protected static Collection<PostgrePrivilege> getRolePermissions(@NotNull DBRProgressMonitor monitor, @NotNull PostgreRole role, @NotNull PostgrePrivilegeGrant.Kind kind, @NotNull JDBCPreparedStatement dbStat) throws SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (JDBCResultSet dbResult = dbStat.executeQuery();){
            LinkedHashMap<String, List> privs = new LinkedHashMap<String, List>();
            while (dbResult.next()) {
                PostgrePrivilegeGrant privilege = new PostgrePrivilegeGrant(role.database, kind, (ResultSet)dbResult);
                String privilegeObjectName = privilege.getObjectName();
                String objectSchema = privilege.getObjectSchema();
                if ((kind == PostgrePrivilegeGrant.Kind.FUNCTION || kind == PostgrePrivilegeGrant.Kind.PROCEDURE) && CommonUtils.isNotEmpty((String)privilegeObjectName) && privilegeObjectName.contains("_") && !privilegeObjectName.endsWith("_") && CommonUtils.isNotEmpty((String)objectSchema)) {
                    PostgreRole.changeRoutineFullName(monitor, role, privilege, privilegeObjectName, objectSchema);
                }
                String tableId = objectSchema + "." + privilege.getObjectName();
                List privList = privs.computeIfAbsent(tableId, k -> new ArrayList());
                privList.add(privilege);
            }
            ArrayList<PostgrePrivilege> result = new ArrayList<PostgrePrivilege>(privs.size());
            for (List priv : privs.values()) {
                PostgrePrivilegeGrant privilegeGrant = (PostgrePrivilegeGrant)priv.get(0);
                result.add(new PostgreRolePrivilege(role, privilegeGrant.getKind(), privilegeGrant.getObjectSchema(), privilegeGrant.getObjectName(), priv));
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void changeRoutineFullName(@NotNull DBRProgressMonitor monitor, @NotNull PostgreRole role, @NotNull PostgrePrivilegeGrant privilege, String privilegeObjectName, String objectSchema) {
        String privId = privilegeObjectName.substring(privilegeObjectName.lastIndexOf("_") + 1);
        long routineId = CommonUtils.toLong((Object)privId, (long)-1L);
        if (routineId != -1L) {
            PostgreSchema schema;
            PostgreDatabase database = role.getDatabase();
            try {
                schema = database.getSchema(monitor, objectSchema);
            }
            catch (DBException e) {
                log.debug((Object)("Can't find routine schema '" + objectSchema + "'"), (Throwable)e);
                schema = database.getPublicSchema();
            }
            if (schema != null) {
                PostgreProcedure procedure = null;
                try {
                    procedure = schema.getProcedure(monitor, routineId);
                }
                catch (DBException e) {
                    log.debug((Object)("Can't find routine in schema '" + privilegeObjectName + "'"), (Throwable)e);
                }
                if (procedure != null && CommonUtils.isNotEmpty((String)procedure.getOverloadedName())) {
                    privilege.setObjectName(procedure.getOverloadedName());
                    if (procedure.getKind() == PostgreProcedureKind.p) {
                        privilege.setKind(PostgrePrivilegeGrant.Kind.PROCEDURE);
                    }
                }
            }
        }
    }

    @Nullable
    public String getSpecificRoleType() {
        return null;
    }

    public PostgreRoleReference getRoleReference() {
        return new PostgreRoleReference(this.database, this.getName(), this.getSpecificRoleType());
    }

    public boolean isReferencedWith(PostgreRoleReference reference) {
        return reference != null && Objects.equals(this.getDatabase(), reference.getDatabase()) && Objects.equals(this.getName(), reference.getRoleName()) && Objects.equals(this.getSpecificRoleType(), reference.getRoleType());
    }

    public boolean supportsRoutinesPermissions() {
        return true;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.membersCache.clearCache();
        this.belongsCache.clearCache();
        this.extraSettings = null;
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public static class CommentsOnRolesSupportedValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(@NotNull PostgreRole object, @Nullable Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsCommentsOnRole();
        }
    }

    static class MembersCache
    extends JDBCObjectCache<PostgreRole, PostgreRoleMember> {
        private final boolean members;

        MembersCache(boolean members) {
            this.members = members;
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreRole owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM pg_catalog.pg_auth_members WHERE " + (this.members ? "roleid" : "member") + "=?");
            dbStat.setLong(1, owner.getObjectId());
            return dbStat;
        }

        protected PostgreRoleMember fetchObject(@NotNull JDBCSession session, @NotNull PostgreRole owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new PostgreRoleMember(owner, (ResultSet)dbResult);
        }
    }

    public static class PersistenceUserValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(@NotNull PostgreRole object, @Nullable Object value) throws IllegalArgumentException {
            return !object.isPersisted();
        }
    }

    public static class PostgreRoleCanBeSuperUserValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(@NotNull PostgreRole object, @Nullable Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsSuperusers();
        }
    }

    public static class PostgreRoleCanCreateDBValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(@NotNull PostgreRole object, @Nullable Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsRolesWithCreateDBAbility();
        }
    }

    public static class PostgreRoleInheritValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(@NotNull PostgreRole object, @Nullable Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsInheritance();
        }
    }

    private static class PostgreRoleSetting {
        @Nullable
        PostgreDatabase database;
        @NotNull
        String configurationParameter;

        PostgreRoleSetting(@Nullable PostgreDatabase database, @NotNull String configurationParameter) {
            this.database = database;
            this.configurationParameter = configurationParameter;
        }
    }

    public static class RoleCanBeReplicationValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(@NotNull PostgreRole object, @Nullable Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsRoleReplication();
        }
    }

    public static class RoleCanBypassRLSValidator
    implements IPropertyValueValidator<PostgreRole, Object> {
        public boolean isValidValue(@NotNull PostgreRole object, @Nullable Object value) throws IllegalArgumentException {
            return object.getDataSource().getServerType().supportsRoleBypassRLS();
        }
    }
}

