/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.db2.model.DB2Object;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class DB2TablespaceContainer
extends DB2Object<DB2Tablespace> {
    private final DB2Tablespace tablespace;
    private Long containerId;
    private String containerType;
    private Long totalPages;
    private Long usablePages;

    public DB2TablespaceContainer(DB2Tablespace tablespace, ResultSet dbResult) {
        super(tablespace, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONTAINER_NAME"), true);
        this.tablespace = tablespace;
        this.containerId = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"CONTAINER_ID");
        this.containerType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONTAINER_TYPE");
        this.totalPages = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"TOTAL_PAGES");
        this.usablePages = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USABLE_PAGES");
    }

    public DB2Tablespace getTablespace() {
        return this.tablespace;
    }

    @Override
    @Property(viewable=true, editable=false, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, editable=false, order=2)
    public Long getContainerId() {
        return this.containerId;
    }

    @Property(viewable=true, editable=false, order=3)
    public String getContainerType() {
        return this.containerType;
    }

    @Property(viewable=true, editable=false, order=4, category="Statistics")
    public Long getTotalPages() {
        return this.totalPages;
    }

    @Property(viewable=true, editable=false, order=5, category="Statistics")
    public Long getUsablePages() {
        return this.usablePages;
    }
}

