import { spawn as ogSpawn } from 'child_process';
export function spawn(command, args, options) {
    const process = ogSpawn(command, args, options);
    const promise = new Promise((resolve, reject) => {
        process.on('close', code => {
            if (options?.rejectOnNonZero && code !== 0) {
                reject(new Error(`command exited with code ${code}`));
            }
            else {
                resolve(typeof code === 'number' ? code : 0);
            }
        });
        process.on('error', reject);
    });
    Object.assign(process, {
        promise,
        then: promise.then.bind(promise),
        catch: promise.catch.bind(promise),
        finally: promise.finally.bind(promise),
    });
    return process;
}
export default spawn;
//# sourceMappingURL=index.js.map