export interface GitlabConfig {
    protocol?: string;
    domain?: string;
    apiPrefix?: string;
    token?: string;
}
export interface Commit {
    id: string;
    short_id: string;
    created_at: string;
    parent_ids: string[];
}
export interface Tag {
    name: string;
    message: string;
    target: string;
    commit: Commit;
    protected: boolean;
}
export declare class Gitlab {
    private _protocol;
    private _domain;
    private _apiPrefix;
    private _token;
    constructor(options?: GitlabConfig);
    setToken(token: string | null | undefined): void;
    getHomepage(): string;
    getUrlPrefix(): string;
    getTags(repoPath: string): Promise<Tag[]>;
    getPackageTags(pkgBase: string): Promise<Tag[]>;
}
export default Gitlab;
