/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.command.template.BaseTemplateRenderer;
import schemacrawler.tools.options.OutputOptions;

public final class FreeMarkerRenderer
extends BaseTemplateRenderer {
    @Override
    public void execute() {
        OutputOptions outputOptions = this.getOutputOptions();
        String templateLocation = this.getResourceFilename();
        String templatePath = ".";
        File templateFilePath = new File(templateLocation);
        if (templateFilePath.exists()) {
            templatePath = templateFilePath.getAbsoluteFile().getParent();
            templateLocation = templateFilePath.getName();
        }
        try {
            System.setProperty("org.freemarker.loggerLibrary", "JUL");
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_28);
            ClassTemplateLoader ctl = new ClassTemplateLoader(FreeMarkerRenderer.class, "/");
            FileTemplateLoader ftl = new FileTemplateLoader(new File(templatePath));
            MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ctl, ftl});
            cfg.setTemplateLoader((TemplateLoader)mtl);
            cfg.setEncoding(Locale.getDefault(), outputOptions.getInputCharset().name());
            cfg.setWhitespaceStripping(true);
            try (PrintWriter writer = outputOptions.openNewOutputWriter();){
                Template template = cfg.getTemplate(templateLocation);
                Map<String, Object> context = this.getContext();
                template.process(context, (Writer)writer);
            }
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Exception rendering FreeMarker template", (Throwable)e);
        }
    }
}

