/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.property.PropertyName;

class LinterForeignKeySelfReference
extends BaseLinter {
    LinterForeignKeySelfReference(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
        this.setSeverity(LintSeverity.critical);
    }

    @Override
    public String getSummary() {
        return "foreign key self-references primary key";
    }

    @Override
    protected void lint(Table table, Connection connections) {
        Objects.requireNonNull(table, "No table provided");
        if (MetaDataUtility.isPartial((DatabaseObject)table) || !table.isSelfReferencing()) {
            return;
        }
        block0: for (ForeignKey foreignKey : table.getImportedForeignKeys()) {
            for (ColumnReference columnReference : foreignKey) {
                Column fkColumn;
                Column pkColumn = columnReference.getPrimaryKeyColumn();
                if (!pkColumn.equals(fkColumn = columnReference.getForeignKeyColumn())) continue;
                this.addTableLint(table, this.getSummary(), foreignKey);
                continue block0;
            }
        }
    }
}

