/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\nJ\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\n\u0010\u0013\u001a\u00020\u0005*\u00020\u000eJ\u001c\u0010\u0014\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0015\u001a\u00020\u0005J\u0014\u0010\u0016\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u0005J\n\u0010\u0017\u001a\u00020\u0005*\u00020\u000eJ\u0012\u0010\u0017\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\bJ\u001e\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0019J\u0012\u0010!\u001a\u00020\u0011*\u00020\u000e2\u0006\u0010\"\u001a\u00020#J\"\u0010$\u001a\u00020\f*\u00020%2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0019J\u001a\u0010$\u001a\u00020\f*\u00020\u000e2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0019J\"\u0010&\u001a\u00020\f*\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u0019J\u001a\u0010&\u001a\u00020\f*\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\bJ8\u0010'\u001a\u00020\f*\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010(\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u00192\b\b\u0002\u0010)\u001a\u00020\bJ\n\u0010*\u001a\u00020\u0005*\u00020+J\n\u0010*\u001a\u00020\u0005*\u00020%J\n\u0010*\u001a\u00020\u0005*\u00020\u0006J\u0012\u0010,\u001a\u00020\f*\u00020%2\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010-\u001a\u00020\f*\u00020%2\u0006\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u00020\bJ\u0012\u00100\u001a\u00020\f*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u00061"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/TableModificationUtils;", "", "<init>", "()V", "modifyColumn", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "columnIndex", "", "transformSeparator", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/TextRange;", "", "transformCell", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableCell;", "getCellPotentialWidth", "cellText", "", "isSeparatorCellCorrectlyFormatted", "hasCorrectPadding", "isColumnCorrectlyFormatted", "checkAlignment", "isCorrectlyFormatted", "hasValidAlignment", "expected", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow$CellAlignment;", "validateColumnAlignment", "buildSeparatorCellContent", "alignment", "cellContentWidth", "buildRealignedCellContent", "cellContent", "wholeCellWidth", "getContentWithoutWhitespaces", "document", "Lcom/intellij/openapi/editor/Document;", "updateAlignment", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "updateColumnAlignment", "insertColumn", "after", "columnWidth", "hasCorrectBorders", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "removeCell", "swapCells", "leftIndex", "rightIndex", "removeColumn", "intellij.markdown"})
@ApiStatus.Internal
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nTableModificationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableModificationUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableModificationUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,291:1\n1069#2,2:292\n158#2,6:300\n170#2,6:306\n130#2,2:315\n221#2,5:317\n1740#3,3:294\n1740#3,3:297\n1740#3,3:312\n1740#3,3:322\n1563#3:325\n1634#3,3:326\n*S KotlinDebug\n*F\n+ 1 TableModificationUtils.kt\norg/intellij/plugins/markdown/editor/tables/TableModificationUtils\n*L\n59#1:292,2\n110#1:300,6\n111#1:306,6\n235#1:315,2\n236#1:317,5\n81#1:294,3\n88#1:297,3\n128#1:312,3\n242#1:322,3\n249#1:325\n249#1:326,3\n*E\n"})
public final class TableModificationUtils {
    @NotNull
    public static final TableModificationUtils INSTANCE = new TableModificationUtils();

    private TableModificationUtils() {
    }

    public final boolean modifyColumn(@NotNull MarkdownTable $this$modifyColumn, int columnIndex, @NotNull Function1<? super TextRange, Unit> transformSeparator, @NotNull Function1<? super MarkdownTableCell, Unit> transformCell) {
        Intrinsics.checkNotNullParameter((Object)$this$modifyColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter(transformSeparator, (String)"transformSeparator");
        Intrinsics.checkNotNullParameter(transformCell, (String)"transformCell");
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$modifyColumn);
        if (markdownTableSeparatorRow == null || (markdownTableSeparatorRow = MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, columnIndex, false, 2, null)) == null) {
            return false;
        }
        MarkdownTableSeparatorRow separatorRange = markdownTableSeparatorRow;
        MarkdownCompositePsiElementBase markdownCompositePsiElementBase = $this$modifyColumn.getHeaderRow();
        if (markdownCompositePsiElementBase == null || (markdownCompositePsiElementBase = markdownCompositePsiElementBase.getCell(columnIndex)) == null) {
            return false;
        }
        MarkdownCompositePsiElementBase headerCell = markdownCompositePsiElementBase;
        List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$modifyColumn, columnIndex, false);
        for (MarkdownTableCell cell : CollectionsKt.asReversed(cells)) {
            transformCell.invoke((Object)cell);
        }
        transformSeparator.invoke((Object)separatorRange);
        transformCell.invoke((Object)headerCell);
        return true;
    }

    private final int getCellPotentialWidth(String cellText) {
        int width = cellText.length();
        if (!StringsKt.startsWith$default((CharSequence)cellText, (char)' ', (boolean)false, (int)2, null)) {
            ++width;
        }
        if (!StringsKt.endsWith$default((CharSequence)cellText, (char)' ', (boolean)false, (int)2, null)) {
            ++width;
        }
        return width;
    }

    private final boolean isSeparatorCellCorrectlyFormatted(String cellText) {
        boolean bl;
        block1: {
            CharSequence $this$all$iv = cellText;
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (it == '-' || it == ':') continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public final boolean hasCorrectPadding(@NotNull MarkdownTableCell $this$hasCorrectPadding) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectPadding, (String)"<this>");
        String cellText = $this$hasCorrectPadding.getText();
        Intrinsics.checkNotNull((Object)cellText);
        return StringsKt.startsWith$default((String)cellText, (String)" ", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)cellText, (String)" ", (boolean)false, (int)2, null);
    }

    public final boolean isColumnCorrectlyFormatted(@NotNull MarkdownTable $this$isColumnCorrectlyFormatted, int columnIndex, boolean checkAlignment) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$isColumnCorrectlyFormatted, (String)"<this>");
            List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$isColumnCorrectlyFormatted, columnIndex, true);
            if (cells.isEmpty()) {
                return true;
            }
            if (checkAlignment && !this.validateColumnAlignment($this$isColumnCorrectlyFormatted, columnIndex)) {
                return false;
            }
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$isColumnCorrectlyFormatted);
            String string = markdownTableSeparatorRow != null ? markdownTableSeparatorRow.getCellText(columnIndex) : null;
            Intrinsics.checkNotNull((Object)string);
            String separatorCellText = string;
            String string2 = ((MarkdownTableCell)CollectionsKt.first(cells)).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            int width = this.getCellPotentialWidth(string2);
            if (separatorCellText.length() != width || !this.isSeparatorCellCorrectlyFormatted(separatorCellText)) {
                return false;
            }
            Iterable $this$all$iv = cells;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MarkdownTableCell it = (MarkdownTableCell)element$iv;
                    boolean bl2 = false;
                    String string3 = it.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    int selfWidth = INSTANCE.getCellPotentialWidth(string3);
                    if (INSTANCE.hasCorrectPadding(it) && selfWidth == it.getTextRange().getLength() && selfWidth == width) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isColumnCorrectlyFormatted$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        return tableModificationUtils.isColumnCorrectlyFormatted(markdownTable, n, bl);
    }

    public final boolean isCorrectlyFormatted(@NotNull MarkdownTable $this$isCorrectlyFormatted, boolean checkAlignment) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isCorrectlyFormatted, (String)"<this>");
            Iterable $this$all$iv = (Iterable)RangesKt.until((int)0, (int)TableUtils.INSTANCE.getColumnsCount($this$isCorrectlyFormatted));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (INSTANCE.isColumnCorrectlyFormatted($this$isCorrectlyFormatted, it, checkAlignment)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean isCorrectlyFormatted$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return tableModificationUtils.isCorrectlyFormatted(markdownTable, bl);
    }

    public final boolean hasValidAlignment(@NotNull MarkdownTableCell $this$hasValidAlignment) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidAlignment, (String)"<this>");
        MarkdownTable markdownTable = $this$hasValidAlignment.getParentTable();
        if (markdownTable == null) {
            return true;
        }
        MarkdownTable table = markdownTable;
        MarkdownTableSeparatorRow.CellAlignment columnAlignment = TableUtils.INSTANCE.getColumnAlignment(table, $this$hasValidAlignment.getColumnIndex());
        return this.hasValidAlignment($this$hasValidAlignment, columnAlignment);
    }

    /*
     * Unable to fully structure code
     */
    public final boolean hasValidAlignment(@NotNull MarkdownTableCell $this$hasValidAlignment, @NotNull MarkdownTableSeparatorRow.CellAlignment expected) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValidAlignment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        content = $this$hasValidAlignment.getText();
        Intrinsics.checkNotNull((Object)content);
        if (StringsKt.isBlank((CharSequence)content)) {
            return true;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[expected.ordinal()]) {
            case 1: {
                return content.charAt(0) == ' ' && content.charAt(1) != ' ';
            }
            case 2: {
                return StringsKt.last((CharSequence)content) == ' ' && content.charAt(StringsKt.getLastIndex((CharSequence)content) - 1) != ' ';
            }
            case 3: {
                $this$indexOfFirst$iv = content;
                $i$f$indexOfFirst = false;
                var8_9 = $this$indexOfFirst$iv.length();
                for (index$iv = 0; index$iv < var8_9; ++index$iv) {
                    it = $this$indexOfFirst$iv.charAt(index$iv);
                    $i$a$-indexOfFirst-TableModificationUtils$hasValidAlignment$spacesLeft$1 = false;
                    if (!(it != ' ')) continue;
                    v0 = index$iv;
                    ** GOTO lbl23
                }
                v0 = -1;
lbl23:
                // 2 sources

                spacesLeft = v0;
                $this$indexOfLast$iv = content;
                $i$f$indexOfLast = false;
                var8_9 = $this$indexOfLast$iv.length() + -1;
                if (0 > var8_9) ** GOTO lbl36
                do {
                    index$iv = var8_9--;
                    it = $this$indexOfLast$iv.charAt(index$iv);
                    $i$a$-indexOfLast-TableModificationUtils$hasValidAlignment$spacesRight$1 = false;
                    if (!(it != ' ')) continue;
                    v1 = index$iv;
                    ** GOTO lbl37
                } while (0 <= var8_9);
lbl36:
                // 2 sources

                v1 = spacesRight = -1;
lbl37:
                // 2 sources

                if (spacesLeft == -1 || spacesRight == -1) {
                    return true;
                }
                spacesRight = StringsKt.getLastIndex((CharSequence)content) - spacesRight + 1;
                return ++spacesLeft == spacesRight || spacesLeft + 1 == spacesRight;
            }
        }
        return true;
    }

    public final boolean validateColumnAlignment(@NotNull MarkdownTable $this$validateColumnAlignment, int columnIndex) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)$this$validateColumnAlignment, (String)"<this>");
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$validateColumnAlignment);
            Intrinsics.checkNotNull((Object)markdownTableSeparatorRow);
            MarkdownTableSeparatorRow.CellAlignment expected = markdownTableSeparatorRow.getCellAlignment(columnIndex);
            if (expected == MarkdownTableSeparatorRow.CellAlignment.NONE) {
                return true;
            }
            Iterable $this$all$iv = TableUtils.INSTANCE.getColumnCells($this$validateColumnAlignment, columnIndex, true);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    MarkdownTableCell it = (MarkdownTableCell)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.hasValidAlignment(it, expected)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final String buildSeparatorCellContent(@NotNull MarkdownTableSeparatorRow.CellAlignment alignment, int cellContentWidth) {
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        return switch (WhenMappings.$EnumSwitchMapping$0[alignment.ordinal()]) {
            case 4 -> StringsKt.repeat((CharSequence)"-", (int)cellContentWidth);
            case 1 -> ":" + StringsKt.repeat((CharSequence)"-", (int)RangesKt.coerceAtLeast((int)(cellContentWidth - 1), (int)1));
            case 2 -> StringsKt.repeat((CharSequence)"-", (int)RangesKt.coerceAtLeast((int)(cellContentWidth - 1), (int)1)) + ":";
            case 3 -> ":" + StringsKt.repeat((CharSequence)"-", (int)RangesKt.coerceAtLeast((int)(cellContentWidth - 2), (int)1)) + ":";
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String buildRealignedCellContent(@NotNull String cellContent, int wholeCellWidth, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)cellContent, (String)"cellContent");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        if (!(wholeCellWidth >= cellContent.length())) {
            throw new IllegalStateException("Check failed.");
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[alignment.ordinal()]) {
            case 2 -> StringsKt.repeat((CharSequence)" ", (int)RangesKt.coerceAtLeast((int)(wholeCellWidth - cellContent.length() - 1), (int)0)) + cellContent + " ";
            case 3 -> {
                int it;
                StringBuilder var6_6;
                int leftPadding = (wholeCellWidth - cellContent.length()) / 2;
                int rightPadding = wholeCellWidth - cellContent.length() - leftPadding;
                StringBuilder $this$buildRealignedCellContent_u24lambda_u240 = var6_6 = new StringBuilder();
                boolean $i$a$-buildString-TableModificationUtils$buildRealignedCellContent$1 = false;
                int var9_9 = 0;
                while (var9_9 < leftPadding) {
                    it = var9_9++;
                    boolean $i$a$-repeat-TableModificationUtils$buildRealignedCellContent$1$1 = false;
                    $this$buildRealignedCellContent_u24lambda_u240.append(' ');
                }
                $this$buildRealignedCellContent_u24lambda_u240.append(cellContent);
                var9_9 = 0;
                while (var9_9 < rightPadding) {
                    it = var9_9++;
                    boolean $i$a$-repeat-TableModificationUtils$buildRealignedCellContent$1$2 = false;
                    $this$buildRealignedCellContent_u24lambda_u240.append(' ');
                }
                yield var6_6.toString();
            }
            default -> " " + cellContent + StringsKt.repeat((CharSequence)" ", (int)RangesKt.coerceAtLeast((int)(wholeCellWidth - cellContent.length() - 1), (int)0));
        };
    }

    @NotNull
    public final String getContentWithoutWhitespaces(@NotNull MarkdownTableCell $this$getContentWithoutWhitespaces, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getContentWithoutWhitespaces, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        TextRange range = $this$getContentWithoutWhitespaces.getTextRange();
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        Object object = charSequence;
        int n = range.getStartOffset();
        int n2 = range.getEndOffset();
        String content2 = ((Object)object.subSequence(n, n2)).toString();
        object = new char[1];
        object[0] = 32;
        return StringsKt.trim((String)content2, (char[])object);
    }

    public final void updateAlignment(@NotNull MarkdownTableSeparatorRow $this$updateAlignment, @NotNull Document document, int columnIndex, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAlignment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        TextRange textRange = MarkdownTableSeparatorRow.getCellRange$default($this$updateAlignment, columnIndex, false, 2, null);
        Intrinsics.checkNotNull((Object)textRange);
        TextRange cellRange = textRange;
        int width = cellRange.getLength();
        String replacement = this.buildSeparatorCellContent(alignment, width);
        document.replaceString(cellRange.getStartOffset(), cellRange.getEndOffset(), (CharSequence)replacement);
    }

    public final void updateAlignment(@NotNull MarkdownTableCell $this$updateAlignment, @NotNull Document document, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)$this$updateAlignment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        if (alignment == MarkdownTableSeparatorRow.CellAlignment.NONE) {
            return;
        }
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence documentText = charSequence;
        TextRange cellRange = $this$updateAlignment.getTextRange();
        String cellText = ((Object)documentText.subSequence(cellRange.getStartOffset(), cellRange.getEndOffset())).toString();
        char[] cArray = new char[]{' '};
        String actualContent = StringsKt.trim((String)cellText, (char[])cArray);
        String replacement = this.buildRealignedCellContent(actualContent, cellText.length(), alignment);
        document.replaceString(cellRange.getStartOffset(), cellRange.getEndOffset(), (CharSequence)replacement);
    }

    public final void updateColumnAlignment(@NotNull MarkdownTable $this$updateColumnAlignment, @NotNull Document document, int columnIndex, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment) {
        Intrinsics.checkNotNullParameter((Object)$this$updateColumnAlignment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        this.modifyColumn($this$updateColumnAlignment, columnIndex, (Function1<? super TextRange, Unit>)((Function1)arg_0 -> TableModificationUtils.updateColumnAlignment$lambda$0($this$updateColumnAlignment, document, columnIndex, alignment, arg_0)), (Function1<? super MarkdownTableCell, Unit>)((Function1)arg_0 -> TableModificationUtils.updateColumnAlignment$lambda$1(document, alignment, arg_0)));
    }

    public final void updateColumnAlignment(@NotNull MarkdownTable $this$updateColumnAlignment, @NotNull Document document, int columnIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$updateColumnAlignment, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object object = TableUtils.INSTANCE.getSeparatorRow($this$updateColumnAlignment);
        if (object == null || (object = object.getCellAlignment(columnIndex)) == null) {
            return;
        }
        Object alignment = object;
        this.updateColumnAlignment($this$updateColumnAlignment, document, columnIndex, (MarkdownTableSeparatorRow.CellAlignment)((Object)alignment));
    }

    public final void insertColumn(@NotNull MarkdownTable $this$insertColumn, @NotNull Document document, int columnIndex, boolean after, @NotNull MarkdownTableSeparatorRow.CellAlignment alignment, int columnWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$insertColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)((Object)alignment), (String)"alignment");
        List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$insertColumn, columnIndex, false);
        MarkdownTableRow markdownTableRow = $this$insertColumn.getHeaderRow();
        MarkdownTableCell markdownTableCell = markdownTableRow != null ? markdownTableRow.getCell(columnIndex) : null;
        Intrinsics.checkNotNull((Object)markdownTableCell);
        MarkdownTableCell headerCell = markdownTableCell;
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$insertColumn);
        TextRange textRange = markdownTableSeparatorRow != null ? MarkdownTableSeparatorRow.getCellRange$default(markdownTableSeparatorRow, columnIndex, false, 2, null) : null;
        Intrinsics.checkNotNull(textRange);
        TextRange separatorCell = textRange;
        String cellContent = StringsKt.repeat((CharSequence)" ", (int)columnWidth);
        for (MarkdownTableCell cell : CollectionsKt.asReversed(cells)) {
            if (after) {
                document.insertString(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)cell)) + 1, (CharSequence)(cellContent + "|"));
                continue;
            }
            document.insertString(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)cell)) - 1, (CharSequence)("|" + cellContent));
        }
        if (after) {
            document.insertString(separatorCell.getEndOffset() + 1, (CharSequence)(this.buildSeparatorCellContent(alignment, columnWidth) + "|"));
        } else {
            document.insertString(separatorCell.getStartOffset() - 1, (CharSequence)("|" + this.buildSeparatorCellContent(alignment, columnWidth)));
        }
        if (after) {
            document.insertString(PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)headerCell)) + 1, (CharSequence)(cellContent + "|"));
        } else {
            document.insertString(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)headerCell)) - 1, (CharSequence)("|" + cellContent));
        }
    }

    public static /* synthetic */ void insertColumn$default(TableModificationUtils tableModificationUtils, MarkdownTable markdownTable, Document document, int n, boolean bl, MarkdownTableSeparatorRow.CellAlignment cellAlignment, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            bl = true;
        }
        if ((n3 & 8) != 0) {
            cellAlignment = MarkdownTableSeparatorRow.CellAlignment.NONE;
        }
        if ((n3 & 0x10) != 0) {
            n2 = 3;
        }
        tableModificationUtils.insertColumn(markdownTable, document, n, bl, cellAlignment, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCorrectBorders(@NotNull MarkdownTableRow $this$hasCorrectBorders) {
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectBorders, (String)"<this>");
        PsiElement psiElement = $this$hasCorrectBorders.getFirstChild();
        if (psiElement == null) return false;
        IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
        if (!PsiUtilsKt.hasType(psiElement, iElementType)) return false;
        boolean bl = true;
        if (!bl) return false;
        PsiElement psiElement2 = $this$hasCorrectBorders.getLastChild();
        if (psiElement2 == null) return false;
        IElementType iElementType2 = MarkdownTokenTypes.TABLE_SEPARATOR;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"TABLE_SEPARATOR");
        if (!PsiUtilsKt.hasType(psiElement2, iElementType2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCorrectBorders(@NotNull MarkdownTableSeparatorRow $this$hasCorrectBorders) {
        Character c;
        Character first;
        block4: {
            Character c2;
            String text2;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$hasCorrectBorders, (String)"<this>");
                TextRange textRange = TableUtils.INSTANCE.calculateActualTextRange$intellij_markdown($this$hasCorrectBorders).shiftLeft($this$hasCorrectBorders.getStartOffset());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftLeft(...)");
                TextRange range = textRange;
                String string = range.substring($this$hasCorrectBorders.getText());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                text2 = string;
                CharSequence $this$firstOrNull$iv = text2;
                boolean $i$f$firstOrNull = false;
                for (int i = 0; i < $this$firstOrNull$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$firstOrNull$iv.charAt(i);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    c2 = Character.valueOf(element$iv);
                    break block3;
                }
                c2 = null;
            }
            first = c2;
            CharSequence $this$lastOrNull$iv = text2;
            boolean $i$f$lastOrNull = false;
            int n = $this$lastOrNull$iv.length() + -1;
            if (0 <= n) {
                do {
                    char element$iv;
                    int index$iv = n--;
                    char it = element$iv = $this$lastOrNull$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    c = Character.valueOf(element$iv);
                    break block4;
                } while (0 <= n);
            }
            c = null;
        }
        Character last = c;
        Character c3 = first;
        char c4 = '|';
        if (c3 == null) return false;
        if (c3.charValue() != c4) return false;
        Character c5 = last;
        c4 = '|';
        if (c5 == null) return false;
        if (c5.charValue() != c4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasCorrectBorders(@NotNull MarkdownTable $this$hasCorrectBorders) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$hasCorrectBorders, (String)"<this>");
        List<MarkdownTableRow> list2 = $this$hasCorrectBorders.getRows(true);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRows(...)");
        List<MarkdownTableRow> rows = list2;
        Iterable $this$all$iv = rows;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$all$iv) {
                MarkdownTableRow it = (MarkdownTableRow)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (INSTANCE.hasCorrectBorders(it)) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$hasCorrectBorders);
        if (markdownTableSeparatorRow == null) return false;
        if (!this.hasCorrectBorders(markdownTableSeparatorRow)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void removeCell(@NotNull MarkdownTableSeparatorRow $this$removeCell, int columnIndex) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$removeCell, (String)"<this>");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$removeCell.getCellsCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)((int)it), (Object)$this$removeCell.getCellText((int)it)));
        }
        List contents = (List)destination$iv$iv;
        String newContents = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)contents), arg_0 -> TableModificationUtils.removeCell$lambda$1(columnIndex, arg_0)), TableModificationUtils::removeCell$lambda$2), (CharSequence)"|", (CharSequence)"|", (CharSequence)"|", (int)0, null, null, (int)56, null);
        $this$removeCell.replaceWithText(newContents);
    }

    public final void swapCells(@NotNull MarkdownTableSeparatorRow $this$swapCells, int leftIndex, int rightIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$swapCells, (String)"<this>");
        List contents = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)$this$swapCells.getCellsCount()))), arg_0 -> TableModificationUtils.swapCells$lambda$0($this$swapCells, arg_0)));
        ContainerUtil.swapElements((List)contents, (int)leftIndex, (int)rightIndex);
        String newContents = CollectionsKt.joinToString$default((Iterable)contents, (CharSequence)"|", (CharSequence)"|", (CharSequence)"|", (int)0, null, null, (int)56, null);
        $this$swapCells.replaceWithText(newContents);
    }

    public final void removeColumn(@NotNull MarkdownTable $this$removeColumn, int columnIndex) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)$this$removeColumn, (String)"<this>");
            List<MarkdownTableCell> cells = TableUtils.INSTANCE.getColumnCells($this$removeColumn, columnIndex, true);
            for (MarkdownTableCell cell : CollectionsKt.asReversed(cells)) {
                boolean bl;
                PsiElement parent = cell.getParent();
                if (columnIndex == 0) {
                    boolean bl2;
                    PsiElement psiElement = cell.getPrevSibling();
                    if (psiElement != null) {
                        IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
                        bl2 = PsiUtilsKt.hasType(psiElement, iElementType);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        parent.deleteChildRange(cell.getPrevSibling(), (PsiElement)cell);
                        continue;
                    }
                }
                PsiElement psiElement = cell.getNextSibling();
                if (psiElement != null) {
                    IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
                    bl = PsiUtilsKt.hasType(psiElement, iElementType);
                } else {
                    bl = false;
                }
                if (bl) {
                    parent.deleteChildRange((PsiElement)cell, cell.getNextSibling());
                    continue;
                }
                cell.delete();
            }
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this$removeColumn);
            if (markdownTableSeparatorRow == null) break block8;
            this.removeCell(markdownTableSeparatorRow, columnIndex);
        }
    }

    private static final Unit updateColumnAlignment$lambda$0(MarkdownTable $this_updateColumnAlignment, Document $document, int $columnIndex, MarkdownTableSeparatorRow.CellAlignment $alignment, TextRange it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow($this_updateColumnAlignment);
            if (markdownTableSeparatorRow == null) break block0;
            INSTANCE.updateAlignment(markdownTableSeparatorRow, $document, $columnIndex, $alignment);
        }
        return Unit.INSTANCE;
    }

    private static final Unit updateColumnAlignment$lambda$1(Document $document, MarkdownTableSeparatorRow.CellAlignment $alignment, MarkdownTableCell it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.updateAlignment(it, $document, $alignment);
        return Unit.INSTANCE;
    }

    private static final boolean removeCell$lambda$1(int $columnIndex, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        int index = ((Number)pair.component1()).intValue();
        return index != $columnIndex;
    }

    private static final String removeCell$lambda$2(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String text2 = (String)pair.component2();
        return text2;
    }

    private static final String swapCells$lambda$0(MarkdownTableSeparatorRow $this_swapCells, int it) {
        return $this_swapCells.getCellText(it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MarkdownTableSeparatorRow.CellAlignment.values().length];
            try {
                nArray[MarkdownTableSeparatorRow.CellAlignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkdownTableSeparatorRow.CellAlignment.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkdownTableSeparatorRow.CellAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MarkdownTableSeparatorRow.CellAlignment.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

