/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import java.math.BigInteger;
import org.jetbrains.annotations.NotNull;

public abstract class TypeMerger {
    @NotNull
    private final String myName;
    @NotNull
    private final Consumer<String> myConsumer;
    private final int myPriority;

    TypeMerger(@NotNull String name, @NotNull Consumer<String> consumer, int priority) {
        if (name == null) {
            TypeMerger.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            TypeMerger.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myConsumer = consumer;
        this.myPriority = priority;
    }

    public int getPriority() {
        return this.myPriority;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            TypeMerger.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isSuitable(@NotNull String s) {
        if (s == null) {
            TypeMerger.$$$reportNull$$$0(3);
        }
        try {
            this.myConsumer.consume((Object)s);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public TypeMerger merge(@NotNull TypeMerger toMerge) {
        if (toMerge == null) {
            TypeMerger.$$$reportNull$$$0(4);
        }
        int priority = toMerge.getPriority();
        if (this.getPriority() > priority) {
            return this;
        }
        return toMerge;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/TypeMerger";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/TypeMerger";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSuitable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class BooleanMerger
    extends TypeMerger {
        public BooleanMerger(@NotNull String name) {
            if (name == null) {
                BooleanMerger.$$$reportNull$$$0(0);
            }
            super(name, (Consumer<String>)((Consumer)v -> {
                if (!StringUtil.equalsIgnoreCase((CharSequence)v, (CharSequence)"true") && !StringUtil.equalsIgnoreCase((CharSequence)v, (CharSequence)"false")) {
                    throw new IllegalArgumentException();
                }
            }), 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$BooleanMerger", "<init>"));
        }
    }

    public static class IntegerMerger
    extends TypeMerger {
        public IntegerMerger(@NotNull String name) {
            if (name == null) {
                IntegerMerger.$$$reportNull$$$0(0);
            }
            super(name, (Consumer<String>)((Consumer)Integer::valueOf), 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$IntegerMerger", "<init>"));
        }
    }

    public static class BigIntegerMerger
    extends TypeMerger {
        public BigIntegerMerger(@NotNull String name) {
            if (name == null) {
                BigIntegerMerger.$$$reportNull$$$0(0);
            }
            super(name, (Consumer<String>)((Consumer)s -> new BigInteger((String)s)), 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$BigIntegerMerger", "<init>"));
        }
    }

    public static class DoubleMerger
    extends TypeMerger {
        public DoubleMerger(@NotNull String name) {
            if (name == null) {
                DoubleMerger.$$$reportNull$$$0(0);
            }
            super(name, (Consumer<String>)((Consumer)Double::valueOf), 2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$DoubleMerger", "<init>"));
        }
    }

    public static class StringMerger
    extends TypeMerger {
        public StringMerger(@NotNull String name) {
            if (name == null) {
                StringMerger.$$$reportNull$$$0(0);
            }
            super(name, (Consumer<String>)((Consumer)s -> {}), 4);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/dbimport/TypeMerger$StringMerger", "<init>"));
        }
    }
}

