/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.google.gson.Gson;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.sdk.flavors.PyFlavorAndData;
import com.jetbrains.python.sdk.flavors.PyFlavorData;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonSdkAdditionalData
implements SdkAdditionalData {
    @ApiStatus.Internal
    @NonNls
    public static final String REQUIREMENT_TXT_DEFAULT = "requirements.txt";
    @NonNls
    private static final String PATHS_ADDED_BY_USER_ROOT = "PATHS_ADDED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_ADDED_BY_USER = "PATH_ADDED_BY_USER";
    @NonNls
    private static final String PATHS_REMOVED_BY_USER_ROOT = "PATHS_REMOVED_BY_USER_ROOT";
    @NonNls
    private static final String PATH_REMOVED_BY_USER = "PATH_REMOVED_BY_USER";
    @NonNls
    private static final String PATHS_TO_TRANSFER_ROOT = "PATHS_TO_TRANSFER_ROOT";
    @NonNls
    private static final String PATH_TO_TRANSFER = "PATH_TO_TRANSFER";
    @NonNls
    private static final String ASSOCIATED_PROJECT_PATH = "ASSOCIATED_PROJECT_PATH";
    @NonNls
    private static final String ASSOCIATED_REQUIRED_TXT_PATH = "ASSOCIATED_REQUIRED_TXT_PATH";
    @NonNls
    private static final String SDK_UUID_FIELD_NAME = "SDK_UUID";
    @NonNls
    private static final String FLAVOR_ID = "FLAVOR_ID";
    @NonNls
    private static final String FLAVOR_DATA = "FLAVOR_DATA";
    private final VirtualFilePointerContainer myAddedPaths;
    private final VirtualFilePointerContainer myExcludedPaths;
    private final VirtualFilePointerContainer myPathsToTransfer;
    @NotNull
    private UUID myUUID;
    private PyFlavorAndData<?, ?> myFlavorAndData;
    private String myAssociatedModulePath;
    private Path myRequiredTxtPath;
    private final Gson myGson;

    public PythonSdkAdditionalData() {
        this((PyFlavorAndData)null);
    }

    @Deprecated(forRemoval=true)
    public PythonSdkAdditionalData(@Nullable PythonSdkFlavor<?> flavor) {
        this(flavor == null ? PyFlavorAndData.getUNKNOWN_FLAVOR_DATA() : new PyFlavorAndData(PyFlavorData.Empty.INSTANCE, PythonSdkAdditionalData.ensureSupportsEmptyData(flavor)));
    }

    @NotNull
    private static PythonSdkFlavor<?> ensureSupportsEmptyData(@NotNull PythonSdkFlavor<?> flavor) {
        if (flavor == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(0);
        }
        if (!flavor.supportsEmptyData()) {
            throw new IllegalArgumentException(flavor.getName() + " can't be created without additional data");
        }
        PythonSdkFlavor<?> pythonSdkFlavor = flavor;
        if (pythonSdkFlavor == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return pythonSdkFlavor;
    }

    public PythonSdkAdditionalData(@Nullable PyFlavorAndData<?, ?> flavorAndData) {
        this.myUUID = UUID.randomUUID();
        this.myGson = new Gson();
        this.myFlavorAndData = flavorAndData != null ? flavorAndData : PyFlavorAndData.getUNKNOWN_FLAVOR_DATA();
        this.myAddedPaths = VirtualFilePointerManager.getInstance().createContainer(PythonPluginDisposable.getInstance());
        this.myExcludedPaths = VirtualFilePointerManager.getInstance().createContainer(PythonPluginDisposable.getInstance());
        this.myPathsToTransfer = VirtualFilePointerManager.getInstance().createContainer(PythonPluginDisposable.getInstance());
    }

    protected PythonSdkAdditionalData(@NotNull PythonSdkAdditionalData from) {
        if (from == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(2);
        }
        this.myUUID = UUID.randomUUID();
        this.myGson = new Gson();
        this.myAddedPaths = from.myAddedPaths.clone(PythonPluginDisposable.getInstance());
        this.myExcludedPaths = from.myExcludedPaths.clone(PythonPluginDisposable.getInstance());
        this.myPathsToTransfer = from.myPathsToTransfer.clone(PythonPluginDisposable.getInstance());
        this.myAssociatedModulePath = from.myAssociatedModulePath;
        this.myRequiredTxtPath = from.myRequiredTxtPath;
        this.myFlavorAndData = from.myFlavorAndData;
        this.myUUID = from.myUUID;
    }

    @ApiStatus.Internal
    public final void changeFlavorAndData(@NotNull PyFlavorAndData<?, ?> flavorAndData) {
        if (flavorAndData == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(3);
        }
        this.myFlavorAndData = flavorAndData;
    }

    @ApiStatus.Internal
    @NotNull
    public final UUID getUUID() {
        UUID uUID = this.myUUID;
        if (uUID == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(4);
        }
        return uUID;
    }

    @NotNull
    public PythonSdkAdditionalData copy() {
        return new PythonSdkAdditionalData(this);
    }

    public final void setAddedPathsFromVirtualFiles(@NotNull Set<VirtualFile> addedPaths) {
        if (addedPaths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(5);
        }
        this.myAddedPaths.clear();
        for (VirtualFile file : addedPaths) {
            this.myAddedPaths.add(file);
        }
    }

    @ApiStatus.Internal
    public final void setExcludedPathsFromVirtualFiles(@NotNull Set<VirtualFile> addedPaths) {
        if (addedPaths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(6);
        }
        this.myExcludedPaths.clear();
        for (VirtualFile file : addedPaths) {
            this.myExcludedPaths.add(file);
        }
    }

    @ApiStatus.Internal
    public final void setPathsToTransferFromVirtualFiles(@NotNull Set<VirtualFile> addedPaths) {
        if (addedPaths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(7);
        }
        this.myPathsToTransfer.clear();
        for (VirtualFile file : addedPaths) {
            this.myPathsToTransfer.add(file);
        }
    }

    @ApiStatus.Internal
    public final String getAssociatedModulePath() {
        return this.myAssociatedModulePath;
    }

    @ApiStatus.Internal
    public final void setAssociatedModulePath(@Nullable String modulePath) {
        this.myAssociatedModulePath = modulePath == null ? null : FileUtil.toSystemIndependentName((String)modulePath);
    }

    @ApiStatus.Internal
    public final Path getRequiredTxtPath() {
        return this.myRequiredTxtPath;
    }

    @ApiStatus.Internal
    public final void setRequiredTxtPath(@Nullable Path requiredTxtPath) {
        boolean isNotDefault = requiredTxtPath == null;
        this.myRequiredTxtPath = isNotDefault ? null : requiredTxtPath;
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(8);
        }
        PythonSdkAdditionalData.savePaths(rootElement, this.myAddedPaths, PATHS_ADDED_BY_USER_ROOT, PATH_ADDED_BY_USER);
        PythonSdkAdditionalData.savePaths(rootElement, this.myExcludedPaths, PATHS_REMOVED_BY_USER_ROOT, PATH_REMOVED_BY_USER);
        PythonSdkAdditionalData.savePaths(rootElement, this.myPathsToTransfer, PATHS_TO_TRANSFER_ROOT, PATH_TO_TRANSFER);
        if (this.myAssociatedModulePath != null) {
            rootElement.setAttribute(ASSOCIATED_PROJECT_PATH, this.myAssociatedModulePath);
        }
        if (this.myRequiredTxtPath != null) {
            rootElement.setAttribute(ASSOCIATED_REQUIRED_TXT_PATH, this.myRequiredTxtPath.toString());
        }
        rootElement.setAttribute(SDK_UUID_FIELD_NAME, this.myUUID.toString());
        JDOMExternalizer.write((Element)rootElement, (String)FLAVOR_ID, (String)((PythonSdkFlavor)this.myFlavorAndData.getFlavor()).getUniqueId());
        JDOMExternalizer.write((Element)rootElement, (String)FLAVOR_DATA, (String)this.myGson.toJson(this.myFlavorAndData.getData(), this.myFlavorAndData.getDataClass()));
    }

    private static void savePaths(Element rootElement, VirtualFilePointerContainer paths, String root, String element) {
        for (String addedPath : paths.getUrls()) {
            Element child = new Element(root);
            child.setAttribute(element, addedPath);
            rootElement.addContent(child);
        }
    }

    @NotNull
    public final PythonSdkFlavor<?> getFlavor() {
        Object obj = this.myFlavorAndData.getFlavor();
        if (obj == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(9);
        }
        return obj;
    }

    @ApiStatus.Internal
    @NotNull
    public final PyFlavorAndData<?, ?> getFlavorAndData() {
        PyFlavorAndData<?, ?> pyFlavorAndData = this.myFlavorAndData;
        if (pyFlavorAndData == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(10);
        }
        return pyFlavorAndData;
    }

    @ApiStatus.Internal
    @NotNull
    public static PythonSdkAdditionalData loadFromElement(@Nullable Element element) {
        PythonSdkAdditionalData data = new PythonSdkAdditionalData();
        data.load(element);
        PythonSdkAdditionalData pythonSdkAdditionalData = data;
        if (pythonSdkAdditionalData == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(11);
        }
        return pythonSdkAdditionalData;
    }

    public void load(@Nullable Element element) {
        PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_ADDED_BY_USER_ROOT, (String)PATH_ADDED_BY_USER), this.myAddedPaths);
        PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_REMOVED_BY_USER_ROOT, (String)PATH_REMOVED_BY_USER), this.myExcludedPaths);
        PythonSdkAdditionalData.collectPaths(JDOMExternalizer.loadStringsList((Element)element, (String)PATHS_TO_TRANSFER_ROOT, (String)PATH_TO_TRANSFER), this.myPathsToTransfer);
        if (element != null) {
            String flavorId;
            this.myAssociatedModulePath = element.getAttributeValue(ASSOCIATED_PROJECT_PATH);
            String storedRequiredTxtPath = element.getAttributeValue(ASSOCIATED_REQUIRED_TXT_PATH);
            this.myRequiredTxtPath = storedRequiredTxtPath != null ? Path.of(storedRequiredTxtPath, new String[0]) : null;
            String uuidStr = element.getAttributeValue(SDK_UUID_FIELD_NAME);
            if (uuidStr != null) {
                this.myUUID = UUID.fromString(uuidStr);
            }
            if ((flavorId = JDOMExternalizer.readString((Element)element, (String)FLAVOR_ID)) != null) {
                Optional<PythonSdkFlavor> flavorOpt = PythonSdkFlavor.getApplicableFlavors(true).stream().filter(f -> f.getUniqueId().equals(flavorId)).findFirst();
                if (flavorOpt.isPresent()) {
                    this.setFlavorFromConfig(element, flavorOpt.get());
                } else {
                    this.myFlavorAndData = new PyFlavorAndData<PyFlavorData.Empty, PythonSdkFlavor.UnknownFlavor>(PyFlavorData.Empty.INSTANCE, PythonSdkFlavor.UnknownFlavor.INSTANCE);
                }
            }
        }
    }

    private void setFlavorFromConfig(@NotNull Element element, @NotNull PythonSdkFlavor<?> flavor) {
        if (element == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(12);
        }
        if (flavor == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(13);
        }
        PyFlavorData flavorData = (PyFlavorData)this.myGson.fromJson(JDOMExternalizer.readString((Element)element, (String)FLAVOR_DATA), flavor.getFlavorDataClass());
        this.myFlavorAndData = new PyFlavorAndData(flavorData, flavor);
    }

    private static void collectPaths(@NotNull List<String> paths, VirtualFilePointerContainer container) {
        if (paths == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(14);
        }
        for (String path : paths) {
            if (StringUtil.isEmpty((String)path)) continue;
            String protocol = VirtualFileManager.extractProtocol((String)path);
            String url = protocol != null ? path : VirtualFileManager.constructUrl((String)"file", (String)path);
            container.add(url);
        }
    }

    @ApiStatus.Internal
    public final Set<VirtualFile> getAddedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myAddedPaths);
    }

    @ApiStatus.Internal
    public final Set<VirtualFile> getExcludedPathFiles() {
        return PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myExcludedPaths);
    }

    @ApiStatus.Internal
    @NotNull
    public final Set<VirtualFile> getPathsToTransfer() {
        Set<VirtualFile> set = PythonSdkAdditionalData.getPathsAsVirtualFiles(this.myPathsToTransfer);
        if (set == null) {
            PythonSdkAdditionalData.$$$reportNull$$$0(15);
        }
        return set;
    }

    private static Set<VirtualFile> getPathsAsVirtualFiles(VirtualFilePointerContainer paths) {
        LinkedHashSet<VirtualFile> ret = new LinkedHashSet<VirtualFile>();
        Collections.addAll(ret, paths.getFiles());
        return ret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 9, 10, 11, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavor";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkAdditionalData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flavorAndData";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedPaths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureSupportsEmptyData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUUID";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlavor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlavorAndData";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromElement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsToTransfer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureSupportsEmptyData";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeFlavorAndData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAddedPathsFromVirtualFiles";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExcludedPathsFromVirtualFiles";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPathsToTransferFromVirtualFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setFlavorFromConfig";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 9, 10, 11, 15 -> new IllegalStateException(string);
        };
    }
}

