/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\u0019\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery;", "", "terms", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "<init>", "(Ljava/util/List;)V", "getTerms", "()Ljava/util/List;", "isEmpty", "", "toString", "", "equals", "other", "hashCode", "", "Companion", "QualifierName", "Term", "intellij.vcs.github"})
@ApiStatus.Experimental
public final class GHPRSearchQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Term<?>> terms;
    @NotNull
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public GHPRSearchQuery(@NotNull List<? extends Term<?>> terms) {
        Intrinsics.checkNotNullParameter(terms, (String)"terms");
        this.terms = terms;
    }

    @NotNull
    public final List<Term<?>> getTerms() {
        return this.terms;
    }

    public final boolean isEmpty() {
        return this.terms.isEmpty();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.terms, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRSearchQuery)) {
            return false;
        }
        return Intrinsics.areEqual(this.terms, ((GHPRSearchQuery)other).terms);
    }

    public int hashCode() {
        return ((Object)this.terms).hashCode();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Companion;", "", "<init>", "()V", "DATE_FORMAT", "Ljava/text/SimpleDateFormat;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "", "apiName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getApiName", "()Ljava/lang/String;", "is", "assignee", "author", "label", "repo", "review", "reviewRequested", "reviewedBy", "sortBy", "state", "type", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "value", "toString", "intellij.vcs.github"})
    public static final class QualifierName
    extends Enum<QualifierName> {
        @NotNull
        private final String apiName;
        public static final /* enum */ QualifierName is = new QualifierName("is");
        public static final /* enum */ QualifierName assignee = new QualifierName("assignee");
        public static final /* enum */ QualifierName author = new QualifierName("author");
        public static final /* enum */ QualifierName label = new QualifierName("label");
        public static final /* enum */ QualifierName repo = new QualifierName("repo");
        public static final /* enum */ QualifierName review = new QualifierName("review");
        public static final /* enum */ QualifierName reviewRequested = new QualifierName("review-requested");
        public static final /* enum */ QualifierName reviewedBy = new QualifierName("reviewed-by");
        public static final /* enum */ QualifierName sortBy = new QualifierName("sort");
        public static final /* enum */ QualifierName state = new state("state", 9);
        public static final /* enum */ QualifierName type = new QualifierName("type");
        private static final /* synthetic */ QualifierName[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private QualifierName(String apiName) {
            this.apiName = apiName;
        }

        @NotNull
        public final String getApiName() {
            return this.apiName;
        }

        @NotNull
        public Term<?> createTerm(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Term.Qualifier.Simple(this, value);
        }

        @NotNull
        public String toString() {
            return this.apiName;
        }

        public static QualifierName[] values() {
            return (QualifierName[])$VALUES.clone();
        }

        public static QualifierName valueOf(String value) {
            return Enum.valueOf(QualifierName.class, value);
        }

        @NotNull
        public static EnumEntries<QualifierName> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ QualifierName(String $enum$name, int $enum$ordinal, String apiName, DefaultConstructorMarker $constructor_marker) {
            this(apiName);
        }

        static {
            $VALUES = qualifierNameArray = new QualifierName[]{QualifierName.is, QualifierName.assignee, QualifierName.author, QualifierName.label, QualifierName.repo, QualifierName.review, QualifierName.reviewRequested, QualifierName.reviewedBy, QualifierName.sortBy, QualifierName.state, QualifierName.type};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0017\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"org/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery.QualifierName.state", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "createTerm", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "value", "", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGHPRSearchQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRSearchQuery.kt\norg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$state\n+ 2 GHPRSearchQuery.kt\norg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Enum$Companion\n*L\n1#1,146:1\n98#2,5:147\n*S KotlinDebug\n*F\n+ 1 GHPRSearchQuery.kt\norg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName$state\n*L\n42#1:147,5\n*E\n"})
        static final class state
        extends QualifierName {
            /*
             * WARNING - void declaration
             */
            state() {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public Term<?> createTerm(@NotNull String value) {
                Term term;
                void name$iv;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Term.Qualifier.Enum.Companion companion = Term.Qualifier.Enum.Companion;
                QualifierName qualifierName = this;
                String value$iv = value;
                boolean $i$f$from = false;
                try {
                    term = new Term.Qualifier.Enum<GithubIssueState>((QualifierName)name$iv, GithubIssueState.valueOf(value$iv));
                }
                catch (IllegalArgumentException e$iv) {
                    term = new Term.Qualifier.Simple((QualifierName)name$iv, value$iv);
                }
                return term;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u0012\u0013B\u0011\b\u0004\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0016\u0010\u0003\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u0004\u0018\u00010\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0002\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "T", "", "value", "<init>", "(Ljava/lang/Object;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "QueryPart", "Qualifier", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$QueryPart;", "intellij.vcs.github"})
    public static abstract sealed class Term<T> {
        @NotNull
        private final T value;

        private Term(T value) {
            this.value = value;
        }

        @NotNull
        protected final T getValue() {
            return this.value;
        }

        @Nullable
        public abstract String getApiValue();

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Term)) {
                return false;
            }
            return Intrinsics.areEqual(this.value, ((Term)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public /* synthetic */ Term(Object value, DefaultConstructorMarker $constructor_marker) {
            this(value);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003\u0010\u0011\u0012B\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u0082\u0001\u0003\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "T", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "<init>", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/lang/Object;)V", "getName", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "apiName", "", "getApiName", "()Ljava/lang/String;", "toString", "Simple", "Enum", "Date", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Enum;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "intellij.vcs.github"})
        public static abstract sealed class Qualifier<T>
        extends Term<T> {
            @NotNull
            private final QualifierName name;
            @NotNull
            private final String apiName;

            private Qualifier(QualifierName name, T value) {
                super(value, null);
                this.name = name;
                this.apiName = this.name.getApiName();
            }

            @NotNull
            protected final QualifierName getName() {
                return this.name;
            }

            @NotNull
            public final String getApiName() {
                return this.apiName;
            }

            @NotNull
            public String toString() {
                return this.name + ":" + this.getValue();
            }

            public /* synthetic */ Qualifier(QualifierName name, Object value, DefaultConstructorMarker $constructor_marker) {
                this(name, value);
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000b\fB\u0019\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0004J\b\u0010\n\u001a\u00020\tH\u0016\u0082\u0001\u0002\r\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "Ljava/util/Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "<init>", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/util/Date;)V", "formatDate", "", "toString", "Before", "After", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$After;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$Before;", "intellij.vcs.github"})
            public static abstract sealed class Date
            extends Qualifier<java.util.Date> {
                private Date(QualifierName name, java.util.Date value) {
                    super(name, value, null);
                }

                @NotNull
                protected final String formatDate() {
                    String string = DATE_FORMAT.format((java.util.Date)this.getValue());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                    return string;
                }

                @Override
                @NotNull
                public String toString() {
                    return this.getName() + ":" + this.formatDate();
                }

                public /* synthetic */ Date(QualifierName name, java.util.Date value, DefaultConstructorMarker $constructor_marker) {
                    this(name, value);
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$After;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "Ljava/util/Date;", "<init>", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/util/Date;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
                public static final class After
                extends Date {
                    @NotNull
                    public static final Companion Companion = new Companion(null);
                    @NotNull
                    private final String apiValue;

                    public After(@NotNull QualifierName name, @NotNull java.util.Date value) {
                        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        super(name, value, null);
                        this.apiValue = ">" + this.formatDate();
                    }

                    @Override
                    @NotNull
                    public String getApiValue() {
                        return this.apiValue;
                    }

                    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$After$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                    public static final class Companion {
                        private Companion() {
                        }

                        @NotNull
                        public final Term<?> from(@NotNull QualifierName name, @NotNull String value) {
                            Term term;
                            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            try {
                                java.util.Date date = DATE_FORMAT.parse(value);
                                Intrinsics.checkNotNullExpressionValue((Object)date, (String)"parse(...)");
                                term = new After(name, date);
                            }
                            catch (ParseException e) {
                                term = new Simple(name, value);
                            }
                            return term;
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$Before;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "Ljava/util/Date;", "<init>", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/util/Date;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
                public static final class Before
                extends Date {
                    @NotNull
                    public static final Companion Companion = new Companion(null);
                    @NotNull
                    private final String apiValue;

                    public Before(@NotNull QualifierName name, @NotNull java.util.Date value) {
                        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        super(name, value, null);
                        this.apiValue = "<" + this.formatDate();
                    }

                    @Override
                    @NotNull
                    public String getApiValue() {
                        return this.apiValue;
                    }

                    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Date$Before$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                    public static final class Companion {
                        private Companion() {
                        }

                        @NotNull
                        public final Term<?> from(@NotNull QualifierName name, @NotNull String value) {
                            java.util.Date date;
                            Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            try {
                                date = DATE_FORMAT.parse(value);
                            }
                            catch (ParseException e) {
                                return new Simple(name, value);
                            }
                            java.util.Date date2 = date;
                            Intrinsics.checkNotNull((Object)date2);
                            return new Before(name, date2);
                        }

                        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                            this();
                        }
                    }
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \r*\u000e\b\u0002\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00020\u0003:\u0001\rB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Enum;", "T", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "<init>", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/lang/Enum;)V", "apiValue", "", "getApiValue", "()Ljava/lang/String;", "Companion", "intellij.vcs.github"})
            public static final class Enum<T extends java.lang.Enum<T>>
            extends Qualifier<java.lang.Enum<T>> {
                @NotNull
                public static final Companion Companion = new Companion(null);
                @NotNull
                private final String apiValue;

                public Enum(@NotNull QualifierName name, @NotNull T value) {
                    Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                    Intrinsics.checkNotNullParameter(value, (String)"value");
                    super(name, value, null);
                    this.apiValue = ((java.lang.Enum)this.getValue()).name();
                }

                @Override
                @NotNull
                public String getApiValue() {
                    return this.apiValue;
                }

                @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\"\u0010\b\u0003\u0010\u0006\u0018\u0001*\b\u0012\u0004\u0012\u0002H\u00060\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0086\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Enum$Companion;", "", "<init>", "()V", "from", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "T", "", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "", "intellij.vcs.github"})
                public static final class Companion {
                    private Companion() {
                    }

                    public final /* synthetic */ <T extends java.lang.Enum<T>> Term<?> from(QualifierName name, String value) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        boolean $i$f$from = false;
                        try {
                            object = value;
                            Intrinsics.reifiedOperationMarker((int)5, (String)"T");
                            object = new Enum(name, java.lang.Enum.valueOf(null, (String)object));
                        }
                        catch (IllegalArgumentException e) {
                            object = new Simple(name, value);
                        }
                        return object;
                    }

                    public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                        this();
                    }
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\u0000J\b\u0010\r\u001a\u00020\u0002H\u0016R\u0014\u0010\b\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier$Simple;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$Qualifier;", "", "name", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;", "value", "<init>", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$QualifierName;Ljava/lang/String;)V", "apiValue", "getApiValue", "()Ljava/lang/String;", "not", "", "toString", "intellij.vcs.github"})
            public static final class Simple
            extends Qualifier<String> {
                @NotNull
                private final String apiValue;
                private boolean not;

                public Simple(@NotNull QualifierName name, @NotNull String value) {
                    Intrinsics.checkNotNullParameter((Object)((Object)name), (String)"name");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    super(name, value, null);
                    this.apiValue = (String)this.getValue();
                }

                @Override
                @NotNull
                public String getApiValue() {
                    return this.apiValue;
                }

                @NotNull
                public final Simple not() {
                    this.not = !this.not;
                    return this;
                }

                @Override
                @NotNull
                public String toString() {
                    String minus = this.not ? "-" : "";
                    return minus + this.getName() + ":" + this.getValue();
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term$QueryPart;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRSearchQuery$Term;", "", "value", "<init>", "(Ljava/lang/String;)V", "apiValue", "getApiValue", "()Ljava/lang/String;", "toString", "intellij.vcs.github"})
        public static final class QueryPart
        extends Term<String> {
            @NotNull
            private final String apiValue;

            public QueryPart(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(value, null);
                this.apiValue = (String)this.getValue();
            }

            @Override
            @NotNull
            public String getApiValue() {
                return this.apiValue;
            }

            @NotNull
            public String toString() {
                return (String)this.getValue();
            }
        }
    }
}

