/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.agreement.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.agreement.KeyAgreementCredential;
import org.opensaml.xmlsec.agreement.KeyAgreementException;
import org.opensaml.xmlsec.agreement.KeyAgreementParameters;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.impl.BasicKeyAgreementCredential;
import org.opensaml.xmlsec.agreement.impl.PrivateCredential;
import org.opensaml.xmlsec.agreement.impl.StaticStaticMode;
import org.slf4j.Logger;

public abstract class AbstractKeyAgreementProcessor
implements KeyAgreementProcessor {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractKeyAgreementProcessor.class);

    @Override
    @Nonnull
    public KeyAgreementCredential execute(@Nonnull Credential publicCredential, @Nonnull String keyAlgorithm, @Nonnull KeyAgreementParameters inputParameters) throws KeyAgreementException {
        KeyAgreementParameters parameters = new KeyAgreementParameters(inputParameters);
        Credential privateCredential = this.obtainPrivateCredential(publicCredential, parameters);
        if (privateCredential == null) {
            throw new KeyAgreementException("Unable to obtain or derive private key");
        }
        byte[] secret = this.generateAgreementSecret(publicCredential, privateCredential, parameters);
        SecretKey derivedKey = this.deriveSecretKey(secret, keyAlgorithm, parameters);
        return this.buildKeyAgreementCredential(derivedKey, publicCredential, privateCredential, parameters);
    }

    @Nullable
    protected Credential obtainPrivateCredential(@Nonnull Credential publicCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        PrivateCredential priv = parameters.get(PrivateCredential.class);
        if (priv != null) {
            this.log.debug("Found supplied PrivateCredential in KeyAgreementParameters");
            return priv.getCredential();
        }
        return null;
    }

    @Nonnull
    protected abstract byte[] generateAgreementSecret(@Nonnull Credential var1, @Nonnull Credential var2, @Nonnull KeyAgreementParameters var3) throws KeyAgreementException;

    @Nonnull
    protected abstract SecretKey deriveSecretKey(@Nonnull byte[] var1, @Nonnull String var2, @Nonnull KeyAgreementParameters var3) throws KeyAgreementException;

    @Nonnull
    protected KeyAgreementCredential buildKeyAgreementCredential(@Nonnull SecretKey derivedKey, @Nonnull Credential publicCredential, @Nonnull Credential privateCredential, @Nonnull KeyAgreementParameters parameters) throws KeyAgreementException {
        Credential recipient = null;
        Credential originator = null;
        if (parameters.contains(PrivateCredential.class) && !parameters.contains(StaticStaticMode.class)) {
            recipient = privateCredential;
            originator = publicCredential;
        } else {
            recipient = publicCredential;
            originator = privateCredential;
        }
        BasicKeyAgreementCredential cred = new BasicKeyAgreementCredential(derivedKey, this.getAlgorithm(), originator, recipient);
        cred.getParameters().addAll(parameters);
        return cred;
    }
}

