/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyList;
import net.shibboleth.shared.httpclient.AbstractHttpClient;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.httpclient.HttpClientSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.slf4j.Logger;

class ContextHandlingHttpClient
extends AbstractHttpClient {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ContextHandlingHttpClient.class);
    @Nonnull
    private HttpClient httpClient;
    @Nonnull
    private List<HttpClientContextHandler> handlers;

    public ContextHandlingHttpClient(@Nonnull HttpClient client) {
        this(client, CollectionSupport.emptyList());
    }

    public ContextHandlingHttpClient(@Nonnull HttpClient client, @Nonnull List<HttpClientContextHandler> staticHandlers) {
        this.httpClient = Constraint.isNotNull(client, "HttpClient was null");
        this.handlers = Constraint.isNotNull(staticHandlers, "staticHandlers was null");
    }

    public void close() throws IOException {
        if (Closeable.class.isInstance(this.httpClient)) {
            ((Closeable)Closeable.class.cast(this.httpClient)).close();
        }
    }

    public void close(CloseMode closeMode) {
        if (ModalCloseable.class.isInstance(this.httpClient)) {
            ((ModalCloseable)ModalCloseable.class.cast(this.httpClient)).close(closeMode);
        }
    }

    @Override
    protected ClassicHttpResponse doExecute(@Nullable HttpHost target, @Nonnull ClassicHttpRequest request, @Nullable HttpContext context) throws IOException {
        Throwable error = null;
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)(context != null ? context : new BasicHttpContext()));
        assert (clientContext != null);
        try {
            ClassicHttpResponse classicResponse;
            this.invokeBefore(request, clientContext);
            ClassicHttpResponse classicHttpResponse = classicResponse = this.httpClient.executeOpen(target, request, (HttpContext)clientContext);
            return classicHttpResponse;
        }
        catch (Throwable t) {
            error = t;
            throw t;
        }
        finally {
            this.invokeAfter(request, clientContext, error);
        }
    }

    private void invokeBefore(@Nonnull ClassicHttpRequest request, @Nonnull HttpClientContext context) throws IOException {
        this.log.trace("In invokeBefore");
        LazyList<Throwable> errors = new LazyList<Throwable>();
        for (HttpClientContextHandler handler : this.handlers) {
            try {
                this.log.trace("Invoking static handler invokeBefore: {}", (Object)handler.getClass().getName());
                handler.invokeBefore(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Static handler invokeBefore threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        for (HttpClientContextHandler handler : HttpClientSupport.getDynamicContextHandlerList(context)) {
            try {
                this.log.trace("Invoking dynamic handler invokeBefore: {}", (Object)handler.getClass().getName());
                handler.invokeBefore(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Dynamic handler invokeBefore threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        IOException exception = this.processHandlerErrors("Invoke Before", errors);
        if (exception != null) {
            throw exception;
        }
    }

    private void invokeAfter(@Nonnull ClassicHttpRequest request, @Nonnull HttpClientContext context, @Nullable Throwable priorError) throws IOException {
        this.log.trace("In invokeAfter");
        LazyList<Throwable> errors = new LazyList<Throwable>();
        for (HttpClientContextHandler handler : Lists.reverse(HttpClientSupport.getDynamicContextHandlerList(context))) {
            if (handler == null) continue;
            try {
                this.log.trace("Invoking dynamic handler invokeAfter: {}", (Object)handler.getClass().getName());
                handler.invokeAfter(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Dynamic handler invokeAfter threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        for (HttpClientContextHandler handler : Lists.reverse(this.handlers)) {
            if (handler == null) continue;
            try {
                this.log.trace("Invoking static handler invokeAfter: {}", (Object)handler.getClass().getName());
                handler.invokeAfter(context, request);
            }
            catch (Throwable t) {
                this.log.warn("Static handler invokeAfter threw: {}", (Object)handler.getClass().getName(), (Object)t);
                errors.add(t);
            }
        }
        IOException exception = this.processHandlerErrors("Invoke After", errors);
        this.processErrorsForInvokeAfter(exception, priorError);
    }

    @Nullable
    private IOException processHandlerErrors(String stage, @Nonnull List<Throwable> errors) {
        if (errors.isEmpty()) {
            return null;
        }
        if (errors.size() == 1) {
            Throwable t = errors.get(0);
            if (IOException.class.isInstance(t)) {
                return (IOException)IOException.class.cast(t);
            }
            return new IOException(String.format("Context handler threw non-IOException Throwable in stage '%s'", stage), t);
        }
        IOException e = new IOException(String.format("Multiple context handlers in stage '%s' reported error, see suppressed list", stage));
        for (Throwable t : errors) {
            e.addSuppressed(t);
        }
        return e;
    }

    private void processErrorsForInvokeAfter(@Nullable IOException invokeAfterException, @Nullable Throwable priorError) throws IOException {
        if (priorError != null) {
            if (invokeAfterException != null) {
                priorError.addSuppressed(invokeAfterException);
            }
            if (IOException.class.isInstance(priorError)) {
                throw (IOException)IOException.class.cast(priorError);
            }
            if (RuntimeException.class.isInstance(priorError)) {
                throw (RuntimeException)RuntimeException.class.cast(priorError);
            }
            if (Error.class.isInstance(priorError)) {
                throw (Error)Error.class.cast(priorError);
            }
            throw new RuntimeException(priorError);
        }
        if (invokeAfterException != null) {
            throw invokeAfterException;
        }
    }
}

