/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.indices.ForcemergeResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

public final class ForcemergeRequest
extends RequestBase
implements ToCopyableBuilder<Builder, ForcemergeRequest> {
    @Nullable
    private final Boolean allowNoIndices;
    @Nonnull
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean flush;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nonnull
    private final List<String> index;
    @Nullable
    private final Long maxNumSegments;
    @Nullable
    private final Boolean onlyExpungeDeletes;
    @Nullable
    private final Boolean primaryOnly;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<ForcemergeRequest, ForcemergeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ForcemergeRequest, ForcemergeResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_forcemerge";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(String.join((CharSequence)",", request.index), buf);
            buf.append("/_forcemerge");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), false, ForcemergeResponse._DESERIALIZER);

    private ForcemergeRequest(Builder builder) {
        super(builder);
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.flush = builder.flush;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.maxNumSegments = builder.maxNumSegments;
        this.onlyExpungeDeletes = builder.onlyExpungeDeletes;
        this.primaryOnly = builder.primaryOnly;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static ForcemergeRequest of(Function<Builder, ObjectBuilder<ForcemergeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nonnull
    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean flush() {
        return this.flush;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nonnull
    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Long maxNumSegments() {
        return this.maxNumSegments;
    }

    @Nullable
    public final Boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    @Nullable
    public final Boolean primaryOnly() {
        return this.primaryOnly;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected void applyQueryParameters(@Nonnull Map<String, String> params) {
        super.applyQueryParameters(params);
        if (this.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(this.allowNoIndices));
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            params.put("expand_wildcards", this.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (this.flush != null) {
            params.put("flush", String.valueOf(this.flush));
        }
        if (this.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(this.ignoreUnavailable));
        }
        if (this.maxNumSegments != null) {
            params.put("max_num_segments", String.valueOf(this.maxNumSegments));
        }
        if (this.onlyExpungeDeletes != null) {
            params.put("only_expunge_deletes", String.valueOf(this.onlyExpungeDeletes));
        }
        if (this.primaryOnly != null) {
            params.put("primary_only", String.valueOf(this.primaryOnly));
        }
        if (this.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(this.waitForCompletion));
        }
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.allowNoIndices);
        result = 31 * result + Objects.hashCode(this.expandWildcards);
        result = 31 * result + Objects.hashCode(this.flush);
        result = 31 * result + Objects.hashCode(this.ignoreUnavailable);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.maxNumSegments);
        result = 31 * result + Objects.hashCode(this.onlyExpungeDeletes);
        result = 31 * result + Objects.hashCode(this.primaryOnly);
        result = 31 * result + Objects.hashCode(this.waitForCompletion);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForcemergeRequest other = (ForcemergeRequest)o;
        return Objects.equals(this.allowNoIndices, other.allowNoIndices) && Objects.equals(this.expandWildcards, other.expandWildcards) && Objects.equals(this.flush, other.flush) && Objects.equals(this.ignoreUnavailable, other.ignoreUnavailable) && Objects.equals(this.index, other.index) && Objects.equals(this.maxNumSegments, other.maxNumSegments) && Objects.equals(this.onlyExpungeDeletes, other.onlyExpungeDeletes) && Objects.equals(this.primaryOnly, other.primaryOnly) && Objects.equals(this.waitForCompletion, other.waitForCompletion);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, ForcemergeRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean flush;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private Long maxNumSegments;
        @Nullable
        private Boolean onlyExpungeDeletes;
        @Nullable
        private Boolean primaryOnly;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(ForcemergeRequest o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.flush = o.flush;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.maxNumSegments = o.maxNumSegments;
            this.onlyExpungeDeletes = o.onlyExpungeDeletes;
            this.primaryOnly = o.primaryOnly;
            this.waitForCompletion = o.waitForCompletion;
        }

        private Builder(Builder o) {
            super(o);
            this.allowNoIndices = o.allowNoIndices;
            this.expandWildcards = Builder._listCopy(o.expandWildcards);
            this.flush = o.flush;
            this.ignoreUnavailable = o.ignoreUnavailable;
            this.index = Builder._listCopy(o.index);
            this.maxNumSegments = o.maxNumSegments;
            this.onlyExpungeDeletes = o.onlyExpungeDeletes;
            this.primaryOnly = o.primaryOnly;
            this.waitForCompletion = o.waitForCompletion;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        @Nonnull
        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        @Nonnull
        public final Builder flush(@Nullable Boolean value) {
            this.flush = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        @Nonnull
        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        @Nonnull
        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        @Nonnull
        public final Builder maxNumSegments(@Nullable Long value) {
            this.maxNumSegments = value;
            return this;
        }

        @Nonnull
        public final Builder onlyExpungeDeletes(@Nullable Boolean value) {
            this.onlyExpungeDeletes = value;
            return this;
        }

        @Nonnull
        public final Builder primaryOnly(@Nullable Boolean value) {
            this.primaryOnly = value;
            return this;
        }

        @Nonnull
        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        @Nonnull
        public ForcemergeRequest build() {
            this._checkSingleUse();
            return new ForcemergeRequest(this);
        }
    }
}

