/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.core.RenderSearchTemplateResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public final class RenderSearchTemplateRequest
extends RequestBase
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RenderSearchTemplateRequest> {
    @Nullable
    private final String id;
    @Nonnull
    private final Map<String, JsonData> params;
    @Nullable
    private final String source;
    public static final JsonpDeserializer<RenderSearchTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RenderSearchTemplateRequest::setupRenderSearchTemplateRequestDeserializer);
    public static final Endpoint<RenderSearchTemplateRequest, RenderSearchTemplateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RenderSearchTemplateRequest, RenderSearchTemplateResponse>(request -> "POST", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            return "/_render/template";
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_render/template/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        request.applyQueryParameters(params);
        return params;
    }, SimpleEndpoint.emptyMap(), true, RenderSearchTemplateResponse._DESERIALIZER);

    private RenderSearchTemplateRequest(Builder builder) {
        super(builder);
        this.id = builder.id;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.source = builder.source;
    }

    public static RenderSearchTemplateRequest of(Function<Builder, ObjectBuilder<RenderSearchTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRenderSearchTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.params);
        result = 31 * result + Objects.hashCode(this.source);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RenderSearchTemplateRequest other = (RenderSearchTemplateRequest)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.params, other.params) && Objects.equals(this.source, other.source);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RenderSearchTemplateRequest> {
        @Nullable
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String source;

        public Builder() {
        }

        private Builder(RenderSearchTemplateRequest o) {
            super(o);
            this.id = o.id;
            this.params = Builder._mapCopy(o.params);
            this.source = o.source;
        }

        private Builder(Builder o) {
            super(o);
            this.id = o.id;
            this.params = Builder._mapCopy(o.params);
            this.source = o.source;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        @Nonnull
        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        @Nonnull
        public final Builder source(@Nullable String value) {
            this.source = value;
            return this;
        }

        @Override
        @Nonnull
        public RenderSearchTemplateRequest build() {
            this._checkSingleUse();
            return new RenderSearchTemplateRequest(this);
        }
    }
}

