/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class UniqueTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, UniqueTokenFilter> {
    @Nullable
    private final Boolean onlyOnSamePosition;
    public static final JsonpDeserializer<UniqueTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UniqueTokenFilter::setupUniqueTokenFilterDeserializer);

    private UniqueTokenFilter(Builder builder) {
        super(builder);
        this.onlyOnSamePosition = builder.onlyOnSamePosition;
    }

    public static UniqueTokenFilter of(Function<Builder, ObjectBuilder<UniqueTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Unique;
    }

    @Nullable
    public final Boolean onlyOnSamePosition() {
        return this.onlyOnSamePosition;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "unique");
        super.serializeInternal(generator, mapper);
        if (this.onlyOnSamePosition != null) {
            generator.writeKey("only_on_same_position");
            generator.write(this.onlyOnSamePosition.booleanValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupUniqueTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        UniqueTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::onlyOnSamePosition, JsonpDeserializer.booleanDeserializer(), "only_on_same_position");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.onlyOnSamePosition);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueTokenFilter other = (UniqueTokenFilter)o;
        return Objects.equals(this.onlyOnSamePosition, other.onlyOnSamePosition);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, UniqueTokenFilter> {
        @Nullable
        private Boolean onlyOnSamePosition;

        public Builder() {
        }

        private Builder(UniqueTokenFilter o) {
            super(o);
            this.onlyOnSamePosition = o.onlyOnSamePosition;
        }

        private Builder(Builder o) {
            super(o);
            this.onlyOnSamePosition = o.onlyOnSamePosition;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder onlyOnSamePosition(@Nullable Boolean value) {
            this.onlyOnSamePosition = value;
            return this;
        }

        @Override
        @Nonnull
        public UniqueTokenFilter build() {
            this._checkSingleUse();
            return new UniqueTokenFilter(this);
        }
    }
}

